theory matrices_MatrixArithmetic_add_associativeqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.int_Sum" "../../lib/isabelle/matrices_MyMatrix" "../../lib/isabelle/sum_extended_Sum_extended"
begin
consts zerof :: "int \<Rightarrow> int \<Rightarrow> int"
axiomatization where zerof'def:   "zerof x x_1 = (0 :: int)"
  for x :: "int"
  and x_1 :: "int"
consts add2f :: "int mat \<Rightarrow> int mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
axiomatization where add2f'def:   "add2f a b x y = get a x y + get b x y"
  for a :: "int mat"
  and b :: "int mat"
  and x :: "int"
  and y :: "int"
definition add :: "int mat \<Rightarrow> int mat \<Rightarrow> int mat"
  where "add a b = create (rows a) (cols a) (add2f a b)" for a b
consts opp2f :: "int mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
axiomatization where opp2f'def:   "opp2f a x y = -get a x y"
  for a :: "int mat"
  and x :: "int"
  and y :: "int"
definition opp :: "int mat \<Rightarrow> int mat"
  where "opp a = create (rows a) (cols a) (opp2f a)" for a
definition sub :: "int mat \<Rightarrow> int mat \<Rightarrow> int mat"
  where "sub a b = add a (opp b)" for a b
consts mul_atom :: "int mat \<Rightarrow> int mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
axiomatization where mul_atom'def:   "mul_atom a b i j k = get a i k * get b k j"
  for a :: "int mat"
  and b :: "int mat"
  and i :: "int"
  and j :: "int"
  and k :: "int"
consts mul_cell :: "int mat \<Rightarrow> int mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
axiomatization where mul_cell'def:   "mul_cell a b i j = sum (mul_atom a b i j) (0 :: int) (cols a)"
  for a :: "int mat"
  and b :: "int mat"
  and i :: "int"
  and j :: "int"
definition mul :: "int mat \<Rightarrow> int mat \<Rightarrow> int mat"
  where "mul a b = create (rows a) (cols b) (mul_cell a b)" for a b
theorem add_associative'vc:
  fixes a :: "int mat"
  fixes b :: "int mat"
  fixes c :: "int mat"
  assumes fact0: "infix_eqeqeq a b"
  assumes fact1: "infix_eqeqeq b c"
  shows "add a (add b c) = add (add a b) c"
  sorry
end
