theory matrices_MyMatrix_set_def1
  imports "NTP4Verif.NTP4Verif"
begin
typedecl 'a mat
consts rows :: "'a mat \<Rightarrow> int"
consts cols :: "'a mat \<Rightarrow> int"
consts get :: "'a mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> 'a"
consts create :: "int \<Rightarrow> int \<Rightarrow> (int \<Rightarrow> int \<Rightarrow> 'a) \<Rightarrow> 'a mat"
axiomatization where create_rows:   "rows (create r c f) = r"
 if "(0 :: int) \<le> r"
  for r :: "int"
  and c :: "int"
  and f :: "int \<Rightarrow> int \<Rightarrow> 'a"
axiomatization where create_cols:   "cols (create r c f) = c"
 if "(0 :: int) \<le> c"
  for c :: "int"
  and r :: "int"
  and f :: "int \<Rightarrow> int \<Rightarrow> 'a"
axiomatization where create_get:   "get (create r c f) i j = f i j"
 if "(0 :: int) \<le> i"
 and "i < r"
 and "(0 :: int) \<le> j"
 and "j < c"
  for i :: "int"
  and r :: "int"
  and j :: "int"
  and c :: "int"
  and f :: "int \<Rightarrow> int \<Rightarrow> 'a"
consts fc :: "'a mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> 'a \<Rightarrow> int \<Rightarrow> int \<Rightarrow> 'a"
axiomatization where fc'def:   "fc m x y z x1 y1 = (if x1 = x \<and> y1 = y then z else get m x1 y1)"
  for m :: "'a mat"
  and x :: "int"
  and y :: "int"
  and z :: "'a"
  and x1 :: "int"
  and y1 :: "int"
definition set :: "'a mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> 'a \<Rightarrow> 'a mat"
  where "set m x y z = create (rows m) (cols m) (fc m x y z)" for m x y z
axiomatization where rows_and_cols_nonnegative'0:   "(0 :: int) \<le> rows m"
  for m :: "'a mat"
axiomatization where rows_and_cols_nonnegative'1:   "(0 :: int) \<le> cols m"
  for m :: "'a mat"
theorem set_def1:
  fixes i :: "int"
  fixes m :: "'a mat"
  fixes j :: "int"
  fixes v :: "'a"
  assumes fact0: "(0 :: int) \<le> i"
  assumes fact1: "i < rows m"
  assumes fact2: "(0 :: int) \<le> j"
  assumes fact3: "j < cols m"
  shows "rows (set m i j v) = rows m"
  sorry
end
