import Why3.Base
import Why3.why3.Ref.Ref
import Why3.int.Sum
import pearl.verifythis_2016_matrix_multiplication.lib.lean.matrices.MyMatrix
import pearl.verifythis_2016_matrix_multiplication.lib.lean.matrices.MatrixArithmetic
import pearl.verifythis_2016_matrix_multiplication.lib.lean.sum_extended.Sum_extended
import pearl.verifythis_2016_matrix_multiplication.lib.lean.matrices.BlockMul
import pearl.verifythis_2016_matrix_multiplication.lib.lean.matrices_ring_simp.Symb
import Why3.matrix.Matrix
open Classical
open Lean4Why3
namespace my_strassen_MatrixMultiplication_mult_ijkqtvc
noncomputable def mdl {α : Type} [Inhabited α] (m : Matrix.matrix α) := MyMatrix.create (Matrix.rows m) (Matrix.columns m) (Matrix.elts m)
structure with_symb where
  phy : Matrix.matrix ℤ
  sym : Symb.expr
axiom inhabited_axiom_with_symb : Inhabited with_symb
attribute [instance] inhabited_axiom_with_symb
noncomputable def with_symb_vld (env : Symb.env) (ws : with_symb) := Symb.e_mdl env (with_symb.sym ws) = mdl (with_symb.phy ws) ∧ Symb.e_vld env (with_symb.sym ws) ∧ Symb.expr.e_rows (with_symb.sym ws) = MyMatrix.rows (mdl (with_symb.phy ws)) ∧ Symb.expr.e_cols (with_symb.sym ws) = MyMatrix.cols (mdl (with_symb.phy ws))
lemma mult_ijk'vc (a : Matrix.matrix ℤ) (b : Matrix.matrix ℤ) (fact0 : MyMatrix.cols (mdl a) = MyMatrix.rows (mdl b)) : let r : ℤ := Matrix.rows a; let c : ℤ := Matrix.columns b; ((0 : ℤ) ≤ r ∧ (0 : ℤ) ≤ c) ∧ (∀(rs : Matrix.matrix ℤ), Matrix.rows rs = r ∧ Matrix.columns rs = c ∧ (∀(i : ℤ) (j : ℤ), ((0 : ℤ) ≤ i ∧ i < r) ∧ (0 : ℤ) ≤ j ∧ j < c → Matrix.elts rs i j = (0 : ℤ)) → (let o1 : ℤ := r - (1 : ℤ); ((0 : ℤ) ≤ o1 + (1 : ℤ) → ((∀(i0 : ℤ) (j0 : ℤ), ((0 : ℤ) ≤ i0 ∧ i0 < (0 : ℤ)) ∧ (0 : ℤ) ≤ j0 ∧ j0 < c → Matrix.elts rs i0 j0 = MatrixArithmetic.mul_cell (mdl a) (mdl b) i0 j0) ∧ (∀(i0 : ℤ) (j0 : ℤ), ((0 : ℤ) ≤ i0 ∧ i0 < r) ∧ (0 : ℤ) ≤ j0 ∧ j0 < c → Matrix.elts rs i0 j0 = (0 : ℤ))) ∧ (∀(rs1 : Matrix.matrix ℤ), Matrix.rows rs1 = Matrix.rows rs ∧ Matrix.columns rs1 = Matrix.columns rs → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i ≤ o1) ∧ (∀(i0 : ℤ) (j0 : ℤ), ((0 : ℤ) ≤ i0 ∧ i0 < i) ∧ (0 : ℤ) ≤ j0 ∧ j0 < c → Matrix.elts rs1 i0 j0 = MatrixArithmetic.mul_cell (mdl a) (mdl b) i0 j0) ∧ (∀(i0 : ℤ) (j0 : ℤ), (i ≤ i0 ∧ i0 < r) ∧ (0 : ℤ) ≤ j0 ∧ j0 < c → Matrix.elts rs1 i0 j0 = (0 : ℤ)) → (let o2 : ℤ := c - (1 : ℤ); ((0 : ℤ) ≤ o2 + (1 : ℤ) → (∀(j0 : ℤ), (0 : ℤ) ≤ j0 ∧ j0 < (0 : ℤ) → Matrix.elts rs1 i j0 = MatrixArithmetic.mul_cell (mdl a) (mdl b) i j0) ∧ (∀(rs2 : Matrix.matrix ℤ), Matrix.rows rs2 = Matrix.rows rs1 ∧ Matrix.columns rs2 = Matrix.columns rs1 → (∀(j : ℤ), ((0 : ℤ) ≤ j ∧ j ≤ o2) ∧ (∀(i0 : ℤ) (j0 : ℤ), ((0 : ℤ) ≤ i0 ∧ i0 < r) ∧ ((0 : ℤ) ≤ j0 ∧ j0 < c) ∧ (¬i0 = i ∨ j ≤ j0) → Matrix.elts rs2 i0 j0 = Matrix.elts rs1 i0 j0) ∧ (∀(j0 : ℤ), (0 : ℤ) ≤ j0 ∧ j0 < j → Matrix.elts rs2 i j0 = MatrixArithmetic.mul_cell (mdl a) (mdl b) i j0) → (let o3 : ℤ := Matrix.rows b - (1 : ℤ); ((0 : ℤ) ≤ o3 + (1 : ℤ) → Matrix.elts rs2 i j = int.Sum.sum (MatrixArithmetic.mul_atom (mdl a) (mdl b) i j) (0 : ℤ) (0 : ℤ) ∧ (∀(rs3 : Matrix.matrix ℤ), Matrix.rows rs3 = Matrix.rows rs2 ∧ Matrix.columns rs3 = Matrix.columns rs2 → (∀(k : ℤ), ((0 : ℤ) ≤ k ∧ k ≤ o3) ∧ (∀(i0 : ℤ) (j0 : ℤ), ((0 : ℤ) ≤ i0 ∧ i0 < r) ∧ ((0 : ℤ) ≤ j0 ∧ j0 < c) ∧ (¬i0 = i ∨ ¬j0 = j) → Matrix.elts rs3 i0 j0 = Matrix.elts rs2 i0 j0) ∧ Matrix.elts rs3 i j = int.Sum.sum (MatrixArithmetic.mul_atom (mdl a) (mdl b) i j) (0 : ℤ) k → Matrix.valid_index b k j ∧ Matrix.valid_index a i k ∧ Matrix.valid_index rs3 i j ∧ Matrix.valid_index rs3 i j ∧ (∀(rs4 : Matrix.matrix ℤ), Matrix.rows rs4 = Matrix.rows rs3 ∧ Matrix.columns rs4 = Matrix.columns rs3 → Matrix.elts rs4 = Function.update (Matrix.elts rs3) i (Function.update (Matrix.elts rs3 i) j (Matrix.elts rs3 i j + Matrix.elts a i k * Matrix.elts b k j)) → (∀(i0 : ℤ) (j0 : ℤ), ((0 : ℤ) ≤ i0 ∧ i0 < r) ∧ ((0 : ℤ) ≤ j0 ∧ j0 < c) ∧ (¬i0 = i ∨ ¬j0 = j) → Matrix.elts rs4 i0 j0 = Matrix.elts rs2 i0 j0) ∧ Matrix.elts rs4 i j = int.Sum.sum (MatrixArithmetic.mul_atom (mdl a) (mdl b) i j) (0 : ℤ) (k + (1 : ℤ)))) ∧ ((∀(i0 : ℤ) (j0 : ℤ), ((0 : ℤ) ≤ i0 ∧ i0 < r) ∧ ((0 : ℤ) ≤ j0 ∧ j0 < c) ∧ (¬i0 = i ∨ ¬j0 = j) → Matrix.elts rs3 i0 j0 = Matrix.elts rs2 i0 j0) ∧ Matrix.elts rs3 i j = int.Sum.sum (MatrixArithmetic.mul_atom (mdl a) (mdl b) i j) (0 : ℤ) (o3 + (1 : ℤ)) → (∀(i0 : ℤ) (j0 : ℤ), ((0 : ℤ) ≤ i0 ∧ i0 < r) ∧ ((0 : ℤ) ≤ j0 ∧ j0 < c) ∧ (¬i0 = i ∨ j + (1 : ℤ) ≤ j0) → Matrix.elts rs3 i0 j0 = Matrix.elts rs1 i0 j0) ∧ (∀(j0 : ℤ), (0 : ℤ) ≤ j0 ∧ j0 < j + (1 : ℤ) → Matrix.elts rs3 i j0 = MatrixArithmetic.mul_cell (mdl a) (mdl b) i j0)))) ∧ (o3 + (1 : ℤ) < (0 : ℤ) → (∀(i0 : ℤ) (j0 : ℤ), ((0 : ℤ) ≤ i0 ∧ i0 < r) ∧ ((0 : ℤ) ≤ j0 ∧ j0 < c) ∧ (¬i0 = i ∨ j + (1 : ℤ) ≤ j0) → Matrix.elts rs2 i0 j0 = Matrix.elts rs1 i0 j0) ∧ (∀(j0 : ℤ), (0 : ℤ) ≤ j0 ∧ j0 < j + (1 : ℤ) → Matrix.elts rs2 i j0 = MatrixArithmetic.mul_cell (mdl a) (mdl b) i j0)))) ∧ ((∀(i0 : ℤ) (j0 : ℤ), ((0 : ℤ) ≤ i0 ∧ i0 < r) ∧ ((0 : ℤ) ≤ j0 ∧ j0 < c) ∧ (¬i0 = i ∨ o2 + (1 : ℤ) ≤ j0) → Matrix.elts rs2 i0 j0 = Matrix.elts rs1 i0 j0) ∧ (∀(j0 : ℤ), (0 : ℤ) ≤ j0 ∧ j0 < o2 + (1 : ℤ) → Matrix.elts rs2 i j0 = MatrixArithmetic.mul_cell (mdl a) (mdl b) i j0) → (∀(i0 : ℤ) (j0 : ℤ), ((0 : ℤ) ≤ i0 ∧ i0 < i + (1 : ℤ)) ∧ (0 : ℤ) ≤ j0 ∧ j0 < c → Matrix.elts rs2 i0 j0 = MatrixArithmetic.mul_cell (mdl a) (mdl b) i0 j0) ∧ (∀(i0 : ℤ) (j0 : ℤ), (i + (1 : ℤ) ≤ i0 ∧ i0 < r) ∧ (0 : ℤ) ≤ j0 ∧ j0 < c → Matrix.elts rs2 i0 j0 = (0 : ℤ))))) ∧ (o2 + (1 : ℤ) < (0 : ℤ) → (∀(i0 : ℤ) (j0 : ℤ), ((0 : ℤ) ≤ i0 ∧ i0 < i + (1 : ℤ)) ∧ (0 : ℤ) ≤ j0 ∧ j0 < c → Matrix.elts rs1 i0 j0 = MatrixArithmetic.mul_cell (mdl a) (mdl b) i0 j0) ∧ (∀(i0 : ℤ) (j0 : ℤ), (i + (1 : ℤ) ≤ i0 ∧ i0 < r) ∧ (0 : ℤ) ≤ j0 ∧ j0 < c → Matrix.elts rs1 i0 j0 = (0 : ℤ))))) ∧ ((∀(i0 : ℤ) (j0 : ℤ), ((0 : ℤ) ≤ i0 ∧ i0 < o1 + (1 : ℤ)) ∧ (0 : ℤ) ≤ j0 ∧ j0 < c → Matrix.elts rs1 i0 j0 = MatrixArithmetic.mul_cell (mdl a) (mdl b) i0 j0) ∧ (∀(i0 : ℤ) (j0 : ℤ), (o1 + (1 : ℤ) ≤ i0 ∧ i0 < r) ∧ (0 : ℤ) ≤ j0 ∧ j0 < c → Matrix.elts rs1 i0 j0 = (0 : ℤ)) → MyMatrix.rows (mdl rs1) = MyMatrix.rows (mdl a) ∧ MyMatrix.cols (mdl rs1) = MyMatrix.cols (mdl b) ∧ mdl rs1 = MatrixArithmetic.mul (mdl a) (mdl b)))) ∧ (o1 + (1 : ℤ) < (0 : ℤ) → MyMatrix.rows (mdl rs) = MyMatrix.rows (mdl a) ∧ MyMatrix.cols (mdl rs) = MyMatrix.cols (mdl b) ∧ mdl rs = MatrixArithmetic.mul (mdl a) (mdl b))))
  := sorry
end my_strassen_MatrixMultiplication_mult_ijkqtvc
