import Why3.Base
import Why3.why3.Ref.Ref
import Why3.int.Sum
import pearl.verifythis_2016_matrix_multiplication.lib.lean.matrices.MyMatrix
import pearl.verifythis_2016_matrix_multiplication.lib.lean.matrices.MatrixArithmetic
import pearl.verifythis_2016_matrix_multiplication.lib.lean.sum_extended.Sum_extended
import pearl.verifythis_2016_matrix_multiplication.lib.lean.matrices.BlockMul
import pearl.verifythis_2016_matrix_multiplication.lib.lean.matrices_ring_simp.Symb
import Why3.matrix.Matrix
open Classical
open Lean4Why3
namespace my_strassen_MatrixMultiplication_strassenqtvc
noncomputable def mdl {α : Type} [Inhabited α] (m : Matrix.matrix α) := MyMatrix.create (Matrix.rows m) (Matrix.columns m) (Matrix.elts m)
structure with_symb where
  phy : Matrix.matrix ℤ
  sym : Symb.expr
axiom inhabited_axiom_with_symb : Inhabited with_symb
attribute [instance] inhabited_axiom_with_symb
noncomputable def with_symb_vld (env : Symb.env) (ws : with_symb) := Symb.e_mdl env (with_symb.sym ws) = mdl (with_symb.phy ws) ∧ Symb.e_vld env (with_symb.sym ws) ∧ Symb.expr.e_rows (with_symb.sym ws) = MyMatrix.rows (mdl (with_symb.phy ws)) ∧ Symb.expr.e_cols (with_symb.sym ws) = MyMatrix.cols (mdl (with_symb.phy ws))
lemma strassen'vc (a : Matrix.matrix ℤ) (b : Matrix.matrix ℤ) (flag : ℤ) (fact0 : MyMatrix.cols (mdl a) = MyMatrix.rows (mdl b)) (fact1 : (0 : ℤ) ≤ flag) (fact2 : flag = (0 : ℤ) → MyMatrix.rows (mdl a) = (1 : ℤ) ∨ MyMatrix.cols (mdl a) = (1 : ℤ) ∨ MyMatrix.cols (mdl b) = (1 : ℤ) ∨ Even (MyMatrix.rows (mdl a)) ∧ Even (MyMatrix.cols (mdl a)) ∧ Even (MyMatrix.cols (mdl b))) : (1 : ℤ) ≤ (42 : ℤ) ∧ (∀(cut_off : ℤ), (1 : ℤ) ≤ cut_off → (let o1 : ℤ := Matrix.columns b; let o2 : ℤ := Matrix.columns a; let o3 : ℤ := Matrix.rows a; ∀(o4 : Bool), (if o3 ≤ cut_off then o4 = true else if o2 ≤ cut_off then o4 = true else o4 = (if o1 ≤ cut_off then true else false)) → (if o4 = true then MyMatrix.cols (mdl a) = MyMatrix.rows (mdl b) ∧ (∀(result : Matrix.matrix ℤ), MyMatrix.rows (mdl result) = MyMatrix.rows (mdl a) ∧ MyMatrix.cols (mdl result) = MyMatrix.cols (mdl b) ∧ mdl result = MatrixArithmetic.mul (mdl a) (mdl b) → mdl result = MatrixArithmetic.mul (mdl a) (mdl b) ∧ MyMatrix.rows (mdl result) = MyMatrix.rows (mdl a) ∧ MyMatrix.cols (mdl result) = MyMatrix.cols (mdl b)) else (∀(n : ℤ), (0 : ℤ) ≤ n → ¬(2 : ℤ) = (0 : ℤ) ∧ (let o5 : ℤ := n % (2 : ℤ); ¬(2 : ℤ) = (0 : ℤ) ∧ (let o6 : ℤ := n / (2 : ℤ); n = (2 : ℤ) * o6 + o5 ∧ ((0 : ℤ) ≤ o5 ∧ o5 ≤ (1 : ℤ)) ∧ n + o5 = (2 : ℤ) * (o6 + o5)))) ∧ (0 : ℤ) ≤ o3 ∧ (∀(qr : ℤ) (rr : ℤ), o3 = (2 : ℤ) * qr + rr ∧ ((0 : ℤ) ≤ rr ∧ rr ≤ (1 : ℤ)) ∧ o3 + rr = (2 : ℤ) * (qr + rr) → (0 : ℤ) ≤ o2 ∧ (∀(qm : ℤ) (rm : ℤ), o2 = (2 : ℤ) * qm + rm ∧ ((0 : ℤ) ≤ rm ∧ rm ≤ (1 : ℤ)) ∧ o2 + rm = (2 : ℤ) * (qm + rm) → (0 : ℤ) ≤ o1 ∧ (∀(qc : ℤ) (rc : ℤ), o1 = (2 : ℤ) * qc + rc ∧ ((0 : ℤ) ≤ rc ∧ rc ≤ (1 : ℤ)) ∧ o1 + rc = (2 : ℤ) * (qc + rc) → (∀(o5 : Bool), (if ¬rr = (0 : ℤ) then o5 = true else if ¬rm = (0 : ℤ) then o5 = true else o5 = (if rc = (0 : ℤ) then false else true)) → (if o5 = true then let o6 : ℤ := o1 + rc; let o7 : ℤ := o2 + rm; let o8 : ℤ := o3 + rr; ((MyMatrix.rows (mdl a) ≤ o8 ∧ MyMatrix.cols (mdl a) ≤ o7) ∧ (∀(ap : Matrix.matrix ℤ), MyMatrix.rows (mdl ap) = o8 ∧ MyMatrix.cols (mdl ap) = o7 ∧ mdl a = BlockMul.block (mdl ap) (0 : ℤ) (MyMatrix.rows (mdl a)) (0 : ℤ) (MyMatrix.cols (mdl a)) ∧ (let dr : ℤ := o8 - MyMatrix.rows (mdl a); MyMatrix.create dr (MyMatrix.cols (mdl a)) MatrixArithmetic.zerof = BlockMul.block (mdl ap) (MyMatrix.rows (mdl a)) dr (0 : ℤ) (MyMatrix.cols (mdl a))) ∧ (let dc : ℤ := o7 - MyMatrix.cols (mdl a); MyMatrix.create (MyMatrix.rows (mdl a)) dc MatrixArithmetic.zerof = BlockMul.block (mdl ap) (0 : ℤ) (MyMatrix.rows (mdl a)) (MyMatrix.cols (mdl a)) dc) → (MyMatrix.rows (mdl b) ≤ o7 ∧ MyMatrix.cols (mdl b) ≤ o6) ∧ (∀(bp : Matrix.matrix ℤ), MyMatrix.rows (mdl bp) = o7 ∧ MyMatrix.cols (mdl bp) = o6 ∧ mdl b = BlockMul.block (mdl bp) (0 : ℤ) (MyMatrix.rows (mdl b)) (0 : ℤ) (MyMatrix.cols (mdl b)) ∧ (let dr : ℤ := o7 - MyMatrix.rows (mdl b); MyMatrix.create dr (MyMatrix.cols (mdl b)) MatrixArithmetic.zerof = BlockMul.block (mdl bp) (MyMatrix.rows (mdl b)) dr (0 : ℤ) (MyMatrix.cols (mdl b))) ∧ (let dc : ℤ := o6 - MyMatrix.cols (mdl b); MyMatrix.create (MyMatrix.rows (mdl b)) dc MatrixArithmetic.zerof = BlockMul.block (mdl bp) (0 : ℤ) (MyMatrix.rows (mdl b)) (MyMatrix.cols (mdl b)) dc) → (((0 : ℤ) ≤ MyMatrix.rows (mdl a) + MyMatrix.cols (mdl a) + MyMatrix.cols (mdl b) + (3 : ℤ) * flag ∧ MyMatrix.rows (mdl ap) + MyMatrix.cols (mdl ap) + MyMatrix.cols (mdl bp) + (3 : ℤ) * (0 : ℤ) < MyMatrix.rows (mdl a) + MyMatrix.cols (mdl a) + MyMatrix.cols (mdl b) + (3 : ℤ) * flag ∨ MyMatrix.rows (mdl a) + MyMatrix.cols (mdl a) + MyMatrix.cols (mdl b) + (3 : ℤ) * flag = MyMatrix.rows (mdl ap) + MyMatrix.cols (mdl ap) + MyMatrix.cols (mdl bp) + (3 : ℤ) * (0 : ℤ) ∧ (0 : ℤ) ≤ flag ∧ (0 : ℤ) < flag) ∧ MyMatrix.cols (mdl ap) = MyMatrix.rows (mdl bp) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (MyMatrix.rows (mdl ap) = (1 : ℤ) ∨ MyMatrix.cols (mdl ap) = (1 : ℤ) ∨ MyMatrix.cols (mdl bp) = (1 : ℤ) ∨ Even (MyMatrix.rows (mdl ap)) ∧ Even (MyMatrix.cols (mdl ap)) ∧ Even (MyMatrix.cols (mdl bp)))) ∧ (∀(m : Matrix.matrix ℤ), mdl m = MatrixArithmetic.mul (mdl ap) (mdl bp) ∧ MyMatrix.rows (mdl m) = MyMatrix.rows (mdl ap) ∧ MyMatrix.cols (mdl m) = MyMatrix.cols (mdl bp) → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o3 ∧ (0 : ℤ) + o3 ≤ MyMatrix.rows (mdl ap)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o7 ∧ (0 : ℤ) + o7 ≤ MyMatrix.cols (mdl ap)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o3 ∧ (0 : ℤ) + o3 ≤ o3) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o2 ∧ (0 : ℤ) + o2 ≤ o7) ∧ (BlockMul.block (BlockMul.block (mdl ap) (0 : ℤ) o3 (0 : ℤ) o7) (0 : ℤ) o3 (0 : ℤ) o2 = BlockMul.block (mdl ap) ((0 : ℤ) + (0 : ℤ)) o3 ((0 : ℤ) + (0 : ℤ)) o2 → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o3 ∧ (0 : ℤ) + o3 ≤ MyMatrix.rows (mdl ap)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o7 ∧ (0 : ℤ) + o7 ≤ MyMatrix.cols (mdl ap)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o3 ∧ (0 : ℤ) + o3 ≤ o3) ∧ (0 : ℤ) ≤ o2 ∧ o2 ≤ o2 + rm ∧ o2 + rm ≤ o7) ∧ (BlockMul.block (BlockMul.block (mdl ap) (0 : ℤ) o3 (0 : ℤ) o7) (0 : ℤ) o3 o2 rm = BlockMul.block (mdl ap) ((0 : ℤ) + (0 : ℤ)) o3 ((0 : ℤ) + o2) rm → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o7 ∧ (0 : ℤ) + o7 ≤ MyMatrix.rows (mdl bp)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o1 ∧ (0 : ℤ) + o1 ≤ MyMatrix.cols (mdl bp)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o2 ∧ (0 : ℤ) + o2 ≤ o7) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o1 ∧ (0 : ℤ) + o1 ≤ o1) ∧ (BlockMul.block (BlockMul.block (mdl bp) (0 : ℤ) o7 (0 : ℤ) o1) (0 : ℤ) o2 (0 : ℤ) o1 = BlockMul.block (mdl bp) ((0 : ℤ) + (0 : ℤ)) o2 ((0 : ℤ) + (0 : ℤ)) o1 → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o7 ∧ (0 : ℤ) + o7 ≤ MyMatrix.rows (mdl bp)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o1 ∧ (0 : ℤ) + o1 ≤ MyMatrix.cols (mdl bp)) ∧ ((0 : ℤ) ≤ o2 ∧ o2 ≤ o2 + rm ∧ o2 + rm ≤ o7) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o1 ∧ (0 : ℤ) + o1 ≤ o1) ∧ (BlockMul.block (BlockMul.block (mdl bp) (0 : ℤ) o7 (0 : ℤ) o1) o2 rm (0 : ℤ) o1 = BlockMul.block (mdl bp) ((0 : ℤ) + o2) rm ((0 : ℤ) + (0 : ℤ)) o1 → ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o3 ∧ (0 : ℤ) + o3 ≤ MyMatrix.rows (mdl m)) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o1 ∧ (0 : ℤ) + o1 ≤ MyMatrix.cols (mdl m))))))))) ∧ (∀(result : Matrix.matrix ℤ), (∃(ap : Matrix.matrix ℤ), (MyMatrix.rows (mdl ap) = o8 ∧ MyMatrix.cols (mdl ap) = o7 ∧ mdl a = BlockMul.block (mdl ap) (0 : ℤ) (MyMatrix.rows (mdl a)) (0 : ℤ) (MyMatrix.cols (mdl a)) ∧ (let dr : ℤ := o8 - MyMatrix.rows (mdl a); MyMatrix.create dr (MyMatrix.cols (mdl a)) MatrixArithmetic.zerof = BlockMul.block (mdl ap) (MyMatrix.rows (mdl a)) dr (0 : ℤ) (MyMatrix.cols (mdl a))) ∧ (let dc : ℤ := o7 - MyMatrix.cols (mdl a); MyMatrix.create (MyMatrix.rows (mdl a)) dc MatrixArithmetic.zerof = BlockMul.block (mdl ap) (0 : ℤ) (MyMatrix.rows (mdl a)) (MyMatrix.cols (mdl a)) dc)) ∧ (∃(bp : Matrix.matrix ℤ), (MyMatrix.rows (mdl bp) = o7 ∧ MyMatrix.cols (mdl bp) = o6 ∧ mdl b = BlockMul.block (mdl bp) (0 : ℤ) (MyMatrix.rows (mdl b)) (0 : ℤ) (MyMatrix.cols (mdl b)) ∧ (let dr : ℤ := o7 - MyMatrix.rows (mdl b); MyMatrix.create dr (MyMatrix.cols (mdl b)) MatrixArithmetic.zerof = BlockMul.block (mdl bp) (MyMatrix.rows (mdl b)) dr (0 : ℤ) (MyMatrix.cols (mdl b))) ∧ (let dc : ℤ := o6 - MyMatrix.cols (mdl b); MyMatrix.create (MyMatrix.rows (mdl b)) dc MatrixArithmetic.zerof = BlockMul.block (mdl bp) (0 : ℤ) (MyMatrix.rows (mdl b)) (MyMatrix.cols (mdl b)) dc)) ∧ (∃(m : Matrix.matrix ℤ), (mdl m = MatrixArithmetic.mul (mdl ap) (mdl bp) ∧ MyMatrix.rows (mdl m) = MyMatrix.rows (mdl ap) ∧ MyMatrix.cols (mdl m) = MyMatrix.cols (mdl bp)) ∧ BlockMul.block (BlockMul.block (mdl ap) (0 : ℤ) o3 (0 : ℤ) o7) (0 : ℤ) o3 (0 : ℤ) o2 = BlockMul.block (mdl ap) ((0 : ℤ) + (0 : ℤ)) o3 ((0 : ℤ) + (0 : ℤ)) o2 ∧ BlockMul.block (BlockMul.block (mdl ap) (0 : ℤ) o3 (0 : ℤ) o7) (0 : ℤ) o3 o2 rm = BlockMul.block (mdl ap) ((0 : ℤ) + (0 : ℤ)) o3 ((0 : ℤ) + o2) rm ∧ BlockMul.block (BlockMul.block (mdl bp) (0 : ℤ) o7 (0 : ℤ) o1) (0 : ℤ) o2 (0 : ℤ) o1 = BlockMul.block (mdl bp) ((0 : ℤ) + (0 : ℤ)) o2 ((0 : ℤ) + (0 : ℤ)) o1 ∧ BlockMul.block (BlockMul.block (mdl bp) (0 : ℤ) o7 (0 : ℤ) o1) o2 rm (0 : ℤ) o1 = BlockMul.block (mdl bp) ((0 : ℤ) + o2) rm ((0 : ℤ) + (0 : ℤ)) o1 ∧ mdl result = BlockMul.block (mdl m) (0 : ℤ) o3 (0 : ℤ) o1 ∧ MyMatrix.rows (mdl result) = o3 ∧ MyMatrix.cols (mdl result) = o1))) → mdl result = MatrixArithmetic.mul (mdl a) (mdl b) ∧ MyMatrix.rows (mdl result) = MyMatrix.rows (mdl a) ∧ MyMatrix.cols (mdl result) = MyMatrix.cols (mdl b)) else MyMatrix.cols (mdl a) = MyMatrix.rows (mdl b) ∧ (∀(gm : Matrix.matrix ℤ), MyMatrix.rows (mdl gm) = MyMatrix.rows (mdl a) ∧ MyMatrix.cols (mdl gm) = MyMatrix.cols (mdl b) ∧ mdl gm = MatrixArithmetic.mul (mdl a) (mdl b) → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qr ∧ (0 : ℤ) + qr ≤ MyMatrix.rows (mdl gm)) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qc ∧ (0 : ℤ) + qc ≤ MyMatrix.cols (mdl gm)) ∧ (∀(gm11 : Matrix.matrix ℤ), mdl gm11 = BlockMul.block (mdl gm) (0 : ℤ) qr (0 : ℤ) qc ∧ MyMatrix.rows (mdl gm11) = qr ∧ MyMatrix.cols (mdl gm11) = qc → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qr ∧ (0 : ℤ) + qr ≤ MyMatrix.rows (mdl gm)) ∧ (0 : ℤ) ≤ qc ∧ qc ≤ qc + qc ∧ qc + qc ≤ MyMatrix.cols (mdl gm)) ∧ (∀(gm12 : Matrix.matrix ℤ), mdl gm12 = BlockMul.block (mdl gm) (0 : ℤ) qr qc qc ∧ MyMatrix.rows (mdl gm12) = qr ∧ MyMatrix.cols (mdl gm12) = qc → (((0 : ℤ) ≤ qr ∧ qr ≤ qr + qr ∧ qr + qr ≤ MyMatrix.rows (mdl gm)) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qc ∧ (0 : ℤ) + qc ≤ MyMatrix.cols (mdl gm)) ∧ (∀(gm21 : Matrix.matrix ℤ), mdl gm21 = BlockMul.block (mdl gm) qr qr (0 : ℤ) qc ∧ MyMatrix.rows (mdl gm21) = qr ∧ MyMatrix.cols (mdl gm21) = qc → (((0 : ℤ) ≤ qr ∧ qr ≤ qr + qr ∧ qr + qr ≤ MyMatrix.rows (mdl gm)) ∧ (0 : ℤ) ≤ qc ∧ qc ≤ qc + qc ∧ qc + qc ≤ MyMatrix.cols (mdl gm)) ∧ (∀(gm22 : Matrix.matrix ℤ), mdl gm22 = BlockMul.block (mdl gm) qr qr qc qc ∧ MyMatrix.rows (mdl gm22) = qr ∧ MyMatrix.cols (mdl gm22) = qc → (∀(e : Symb.env), Symb.env.ev_c e = (0 : ℤ) → (∀(e1 : Symb.env) (a1 : with_symb) (b1 : with_symb), (with_symb_vld e1 a1 ∧ with_symb_vld e1 b1) ∧ (MyMatrix.rows (mdl (with_symb.phy a1)) = qr ∧ MyMatrix.cols (mdl (with_symb.phy a1)) = qm) ∧ MyMatrix.rows (mdl (with_symb.phy b1)) = qm ∧ MyMatrix.cols (mdl (with_symb.phy b1)) = qc → (∀(o6 : Bool), (if qr = (1 : ℤ) then o6 = true else if qm = (1 : ℤ) then o6 = true else o6 = (if qc = (1 : ℤ) then true else false)) → (∀(flag1 : ℤ), (if o6 = true then flag1 = (0 : ℤ) else flag1 = (1 : ℤ)) → (let o7 : Matrix.matrix ℤ := with_symb.phy b1; let o8 : Matrix.matrix ℤ := with_symb.phy a1; (((0 : ℤ) ≤ MyMatrix.rows (mdl a) + MyMatrix.cols (mdl a) + MyMatrix.cols (mdl b) + (3 : ℤ) * flag ∧ MyMatrix.rows (mdl o8) + MyMatrix.cols (mdl o8) + MyMatrix.cols (mdl o7) + (3 : ℤ) * flag1 < MyMatrix.rows (mdl a) + MyMatrix.cols (mdl a) + MyMatrix.cols (mdl b) + (3 : ℤ) * flag ∨ MyMatrix.rows (mdl a) + MyMatrix.cols (mdl a) + MyMatrix.cols (mdl b) + (3 : ℤ) * flag = MyMatrix.rows (mdl o8) + MyMatrix.cols (mdl o8) + MyMatrix.cols (mdl o7) + (3 : ℤ) * flag1 ∧ (0 : ℤ) ≤ flag ∧ flag1 < flag) ∧ MyMatrix.cols (mdl o8) = MyMatrix.rows (mdl o7) ∧ (0 : ℤ) ≤ flag1 ∧ (flag1 = (0 : ℤ) → MyMatrix.rows (mdl o8) = (1 : ℤ) ∨ MyMatrix.cols (mdl o8) = (1 : ℤ) ∨ MyMatrix.cols (mdl o7) = (1 : ℤ) ∨ Even (MyMatrix.rows (mdl o8)) ∧ Even (MyMatrix.cols (mdl o8)) ∧ Even (MyMatrix.cols (mdl o7)))) ∧ (∀(r : Matrix.matrix ℤ), mdl r = MatrixArithmetic.mul (mdl o8) (mdl o7) ∧ MyMatrix.rows (mdl r) = MyMatrix.rows (mdl o8) ∧ MyMatrix.cols (mdl r) = MyMatrix.cols (mdl o7) → (let o9 : Symb.expr := with_symb.sym b1; let o10 : Symb.expr := with_symb.sym a1; ((Symb.e_vld e1 o10 ∧ Symb.e_vld e1 o9) ∧ Symb.expr.e_cols o10 = Symb.expr.e_rows o9) ∧ (Symb.e_vld e1 (Symb.symb_mul o10 o9) ∧ Symb.e_mdl e1 (Symb.symb_mul o10 o9) = MatrixArithmetic.mul (Symb.e_mdl e1 o10) (Symb.e_mdl e1 o9) → with_symb_vld e1 (with_symb.mk r (Symb.symb_mul o10 o9)) ∧ mdl r = MatrixArithmetic.mul (mdl (with_symb.phy a1)) (mdl (with_symb.phy b1)) ∧ Symb.symb_mul o10 o9 = Symb.symb_mul (with_symb.sym a1) (with_symb.sym b1)))))))) ∧ (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qr ∧ (0 : ℤ) + qr ≤ MyMatrix.rows (mdl a)) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qm ∧ (0 : ℤ) + qm ≤ MyMatrix.cols (mdl a)) ∧ (∀(e1 : Symb.env) (a11 : with_symb), (let rm1 : MyMatrix.mat ℤ := mdl (with_symb.phy a11); rm1 = BlockMul.block (mdl a) (0 : ℤ) qr (0 : ℤ) qm ∧ MyMatrix.rows rm1 = qr ∧ MyMatrix.cols rm1 = qm) ∧ with_symb.sym a11 = Symb.symb_mat (mdl (with_symb.phy a11)) (Symb.env.ev_c e) ∧ Symb.env.ev_f e1 = Symb.extends1 (Symb.env.ev_f e) (Symb.env.ev_c e) (mdl (with_symb.phy a11)) ∧ Symb.env.ev_c e1 = Symb.env.ev_c e + (1 : ℤ) ∧ with_symb_vld e1 a11 → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qr ∧ (0 : ℤ) + qr ≤ MyMatrix.rows (mdl a)) ∧ (0 : ℤ) ≤ qm ∧ qm ≤ qm + qm ∧ qm + qm ≤ MyMatrix.cols (mdl a)) ∧ (∀(e2 : Symb.env) (a12 : with_symb), (let rm1 : MyMatrix.mat ℤ := mdl (with_symb.phy a12); rm1 = BlockMul.block (mdl a) (0 : ℤ) qr qm qm ∧ MyMatrix.rows rm1 = qr ∧ MyMatrix.cols rm1 = qm) ∧ with_symb.sym a12 = Symb.symb_mat (mdl (with_symb.phy a12)) (Symb.env.ev_c e1) ∧ Symb.env.ev_f e2 = Symb.extends1 (Symb.env.ev_f e1) (Symb.env.ev_c e1) (mdl (with_symb.phy a12)) ∧ Symb.env.ev_c e2 = Symb.env.ev_c e1 + (1 : ℤ) ∧ with_symb_vld e2 a12 → (((0 : ℤ) ≤ qr ∧ qr ≤ qr + qr ∧ qr + qr ≤ MyMatrix.rows (mdl a)) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qm ∧ (0 : ℤ) + qm ≤ MyMatrix.cols (mdl a)) ∧ (∀(e3 : Symb.env) (a21 : with_symb), (let rm1 : MyMatrix.mat ℤ := mdl (with_symb.phy a21); rm1 = BlockMul.block (mdl a) qr qr (0 : ℤ) qm ∧ MyMatrix.rows rm1 = qr ∧ MyMatrix.cols rm1 = qm) ∧ with_symb.sym a21 = Symb.symb_mat (mdl (with_symb.phy a21)) (Symb.env.ev_c e2) ∧ Symb.env.ev_f e3 = Symb.extends1 (Symb.env.ev_f e2) (Symb.env.ev_c e2) (mdl (with_symb.phy a21)) ∧ Symb.env.ev_c e3 = Symb.env.ev_c e2 + (1 : ℤ) ∧ with_symb_vld e3 a21 → (((0 : ℤ) ≤ qr ∧ qr ≤ qr + qr ∧ qr + qr ≤ MyMatrix.rows (mdl a)) ∧ (0 : ℤ) ≤ qm ∧ qm ≤ qm + qm ∧ qm + qm ≤ MyMatrix.cols (mdl a)) ∧ (∀(e4 : Symb.env) (a22 : with_symb), (let rm1 : MyMatrix.mat ℤ := mdl (with_symb.phy a22); rm1 = BlockMul.block (mdl a) qr qr qm qm ∧ MyMatrix.rows rm1 = qr ∧ MyMatrix.cols rm1 = qm) ∧ with_symb.sym a22 = Symb.symb_mat (mdl (with_symb.phy a22)) (Symb.env.ev_c e3) ∧ Symb.env.ev_f e4 = Symb.extends1 (Symb.env.ev_f e3) (Symb.env.ev_c e3) (mdl (with_symb.phy a22)) ∧ Symb.env.ev_c e4 = Symb.env.ev_c e3 + (1 : ℤ) ∧ with_symb_vld e4 a22 → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qr ∧ (0 : ℤ) + qr ≤ MyMatrix.rows (mdl a)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o2 ∧ (0 : ℤ) + o2 ≤ MyMatrix.cols (mdl a)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qr ∧ (0 : ℤ) + qr ≤ qr) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qm ∧ (0 : ℤ) + qm ≤ o2) ∧ (BlockMul.block (BlockMul.block (mdl a) (0 : ℤ) qr (0 : ℤ) o2) (0 : ℤ) qr (0 : ℤ) qm = BlockMul.block (mdl a) ((0 : ℤ) + (0 : ℤ)) qr ((0 : ℤ) + (0 : ℤ)) qm → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qr ∧ (0 : ℤ) + qr ≤ MyMatrix.rows (mdl a)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o2 ∧ (0 : ℤ) + o2 ≤ MyMatrix.cols (mdl a)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qr ∧ (0 : ℤ) + qr ≤ qr) ∧ (0 : ℤ) ≤ qm ∧ qm ≤ qm + qm ∧ qm + qm ≤ o2) ∧ (BlockMul.block (BlockMul.block (mdl a) (0 : ℤ) qr (0 : ℤ) o2) (0 : ℤ) qr qm qm = BlockMul.block (mdl a) ((0 : ℤ) + (0 : ℤ)) qr ((0 : ℤ) + qm) qm → (((0 : ℤ) ≤ qr ∧ qr ≤ qr + qr ∧ qr + qr ≤ MyMatrix.rows (mdl a)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o2 ∧ (0 : ℤ) + o2 ≤ MyMatrix.cols (mdl a)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qr ∧ (0 : ℤ) + qr ≤ qr) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qm ∧ (0 : ℤ) + qm ≤ o2) ∧ (BlockMul.block (BlockMul.block (mdl a) qr qr (0 : ℤ) o2) (0 : ℤ) qr (0 : ℤ) qm = BlockMul.block (mdl a) (qr + (0 : ℤ)) qr ((0 : ℤ) + (0 : ℤ)) qm → (((0 : ℤ) ≤ qr ∧ qr ≤ qr + qr ∧ qr + qr ≤ MyMatrix.rows (mdl a)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o2 ∧ (0 : ℤ) + o2 ≤ MyMatrix.cols (mdl a)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qr ∧ (0 : ℤ) + qr ≤ qr) ∧ (0 : ℤ) ≤ qm ∧ qm ≤ qm + qm ∧ qm + qm ≤ o2) ∧ (BlockMul.block (BlockMul.block (mdl a) qr qr (0 : ℤ) o2) (0 : ℤ) qr qm qm = BlockMul.block (mdl a) (qr + (0 : ℤ)) qr ((0 : ℤ) + qm) qm → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qm ∧ (0 : ℤ) + qm ≤ MyMatrix.rows (mdl b)) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qc ∧ (0 : ℤ) + qc ≤ MyMatrix.cols (mdl b)) ∧ (∀(e5 : Symb.env) (b11 : with_symb), (let rm1 : MyMatrix.mat ℤ := mdl (with_symb.phy b11); rm1 = BlockMul.block (mdl b) (0 : ℤ) qm (0 : ℤ) qc ∧ MyMatrix.rows rm1 = qm ∧ MyMatrix.cols rm1 = qc) ∧ with_symb.sym b11 = Symb.symb_mat (mdl (with_symb.phy b11)) (Symb.env.ev_c e4) ∧ Symb.env.ev_f e5 = Symb.extends1 (Symb.env.ev_f e4) (Symb.env.ev_c e4) (mdl (with_symb.phy b11)) ∧ Symb.env.ev_c e5 = Symb.env.ev_c e4 + (1 : ℤ) ∧ with_symb_vld e5 b11 → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qm ∧ (0 : ℤ) + qm ≤ MyMatrix.rows (mdl b)) ∧ (0 : ℤ) ≤ qc ∧ qc ≤ qc + qc ∧ qc + qc ≤ MyMatrix.cols (mdl b)) ∧ (∀(e6 : Symb.env) (b12 : with_symb), (let rm1 : MyMatrix.mat ℤ := mdl (with_symb.phy b12); rm1 = BlockMul.block (mdl b) (0 : ℤ) qm qc qc ∧ MyMatrix.rows rm1 = qm ∧ MyMatrix.cols rm1 = qc) ∧ with_symb.sym b12 = Symb.symb_mat (mdl (with_symb.phy b12)) (Symb.env.ev_c e5) ∧ Symb.env.ev_f e6 = Symb.extends1 (Symb.env.ev_f e5) (Symb.env.ev_c e5) (mdl (with_symb.phy b12)) ∧ Symb.env.ev_c e6 = Symb.env.ev_c e5 + (1 : ℤ) ∧ with_symb_vld e6 b12 → (((0 : ℤ) ≤ qm ∧ qm ≤ qm + qm ∧ qm + qm ≤ MyMatrix.rows (mdl b)) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qc ∧ (0 : ℤ) + qc ≤ MyMatrix.cols (mdl b)) ∧ (∀(e7 : Symb.env) (b21 : with_symb), (let rm1 : MyMatrix.mat ℤ := mdl (with_symb.phy b21); rm1 = BlockMul.block (mdl b) qm qm (0 : ℤ) qc ∧ MyMatrix.rows rm1 = qm ∧ MyMatrix.cols rm1 = qc) ∧ with_symb.sym b21 = Symb.symb_mat (mdl (with_symb.phy b21)) (Symb.env.ev_c e6) ∧ Symb.env.ev_f e7 = Symb.extends1 (Symb.env.ev_f e6) (Symb.env.ev_c e6) (mdl (with_symb.phy b21)) ∧ Symb.env.ev_c e7 = Symb.env.ev_c e6 + (1 : ℤ) ∧ with_symb_vld e7 b21 → (((0 : ℤ) ≤ qm ∧ qm ≤ qm + qm ∧ qm + qm ≤ MyMatrix.rows (mdl b)) ∧ (0 : ℤ) ≤ qc ∧ qc ≤ qc + qc ∧ qc + qc ≤ MyMatrix.cols (mdl b)) ∧ (∀(e8 : Symb.env) (b22 : with_symb), (let rm1 : MyMatrix.mat ℤ := mdl (with_symb.phy b22); rm1 = BlockMul.block (mdl b) qm qm qc qc ∧ MyMatrix.rows rm1 = qm ∧ MyMatrix.cols rm1 = qc) ∧ with_symb.sym b22 = Symb.symb_mat (mdl (with_symb.phy b22)) (Symb.env.ev_c e7) ∧ Symb.env.ev_f e8 = Symb.extends1 (Symb.env.ev_f e7) (Symb.env.ev_c e7) (mdl (with_symb.phy b22)) ∧ Symb.env.ev_c e8 = Symb.env.ev_c e7 + (1 : ℤ) ∧ with_symb_vld e8 b22 → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o2 ∧ (0 : ℤ) + o2 ≤ MyMatrix.rows (mdl b)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qc ∧ (0 : ℤ) + qc ≤ MyMatrix.cols (mdl b)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qm ∧ (0 : ℤ) + qm ≤ o2) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qc ∧ (0 : ℤ) + qc ≤ qc) ∧ (BlockMul.block (BlockMul.block (mdl b) (0 : ℤ) o2 (0 : ℤ) qc) (0 : ℤ) qm (0 : ℤ) qc = BlockMul.block (mdl b) ((0 : ℤ) + (0 : ℤ)) qm ((0 : ℤ) + (0 : ℤ)) qc → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o2 ∧ (0 : ℤ) + o2 ≤ MyMatrix.rows (mdl b)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qc ∧ (0 : ℤ) + qc ≤ MyMatrix.cols (mdl b)) ∧ ((0 : ℤ) ≤ qm ∧ qm ≤ qm + qm ∧ qm + qm ≤ o2) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qc ∧ (0 : ℤ) + qc ≤ qc) ∧ (BlockMul.block (BlockMul.block (mdl b) (0 : ℤ) o2 (0 : ℤ) qc) qm qm (0 : ℤ) qc = BlockMul.block (mdl b) ((0 : ℤ) + qm) qm ((0 : ℤ) + (0 : ℤ)) qc → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o2 ∧ (0 : ℤ) + o2 ≤ MyMatrix.rows (mdl b)) ∧ ((0 : ℤ) ≤ qc ∧ qc ≤ qc + qc ∧ qc + qc ≤ MyMatrix.cols (mdl b)) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qm ∧ (0 : ℤ) + qm ≤ o2) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qc ∧ (0 : ℤ) + qc ≤ qc) ∧ (BlockMul.block (BlockMul.block (mdl b) (0 : ℤ) o2 qc qc) (0 : ℤ) qm (0 : ℤ) qc = BlockMul.block (mdl b) ((0 : ℤ) + (0 : ℤ)) qm (qc + (0 : ℤ)) qc → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + o2 ∧ (0 : ℤ) + o2 ≤ MyMatrix.rows (mdl b)) ∧ ((0 : ℤ) ≤ qc ∧ qc ≤ qc + qc ∧ qc + qc ≤ MyMatrix.cols (mdl b)) ∧ ((0 : ℤ) ≤ qm ∧ qm ≤ qm + qm ∧ qm + qm ≤ o2) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qc ∧ (0 : ℤ) + qc ≤ qc) ∧ (BlockMul.block (BlockMul.block (mdl b) (0 : ℤ) o2 qc qc) qm qm (0 : ℤ) qc = BlockMul.block (mdl b) ((0 : ℤ) + qm) qm (qc + (0 : ℤ)) qc → ((with_symb_vld e8 a12 ∧ with_symb_vld e8 b21) ∧ (MyMatrix.rows (mdl (with_symb.phy a12)) = qr ∧ MyMatrix.cols (mdl (with_symb.phy a12)) = qm) ∧ MyMatrix.rows (mdl (with_symb.phy b21)) = qm ∧ MyMatrix.cols (mdl (with_symb.phy b21)) = qc) ∧ (∀(o6 : with_symb), with_symb_vld e8 o6 ∧ mdl (with_symb.phy o6) = MatrixArithmetic.mul (mdl (with_symb.phy a12)) (mdl (with_symb.phy b21)) ∧ with_symb.sym o6 = Symb.symb_mul (with_symb.sym a12) (with_symb.sym b21) → ((with_symb_vld e8 a11 ∧ with_symb_vld e8 b11) ∧ (MyMatrix.rows (mdl (with_symb.phy a11)) = qr ∧ MyMatrix.cols (mdl (with_symb.phy a11)) = qm) ∧ MyMatrix.rows (mdl (with_symb.phy b11)) = qm ∧ MyMatrix.cols (mdl (with_symb.phy b11)) = qc) ∧ (∀(o7 : with_symb), with_symb_vld e8 o7 ∧ mdl (with_symb.phy o7) = MatrixArithmetic.mul (mdl (with_symb.phy a11)) (mdl (with_symb.phy b11)) ∧ with_symb.sym o7 = Symb.symb_mul (with_symb.sym a11) (with_symb.sym b11) → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy o7)) (mdl (with_symb.phy o6)) ∧ with_symb_vld e8 o7 ∧ with_symb_vld e8 o6) ∧ (∀(o8 : with_symb), mdl (with_symb.phy o8) = MatrixArithmetic.add (mdl (with_symb.phy o7)) (mdl (with_symb.phy o6)) ∧ with_symb.sym o8 = Symb.symb_add (with_symb.sym o7) (with_symb.sym o6) ∧ with_symb_vld e8 o8 → ((with_symb_vld e8 a22 ∧ with_symb_vld e8 b21) ∧ (MyMatrix.rows (mdl (with_symb.phy a22)) = qr ∧ MyMatrix.cols (mdl (with_symb.phy a22)) = qm) ∧ MyMatrix.rows (mdl (with_symb.phy b21)) = qm ∧ MyMatrix.cols (mdl (with_symb.phy b21)) = qc) ∧ (∀(o9 : with_symb), with_symb_vld e8 o9 ∧ mdl (with_symb.phy o9) = MatrixArithmetic.mul (mdl (with_symb.phy a22)) (mdl (with_symb.phy b21)) ∧ with_symb.sym o9 = Symb.symb_mul (with_symb.sym a22) (with_symb.sym b21) → ((with_symb_vld e8 a21 ∧ with_symb_vld e8 b11) ∧ (MyMatrix.rows (mdl (with_symb.phy a21)) = qr ∧ MyMatrix.cols (mdl (with_symb.phy a21)) = qm) ∧ MyMatrix.rows (mdl (with_symb.phy b11)) = qm ∧ MyMatrix.cols (mdl (with_symb.phy b11)) = qc) ∧ (∀(o10 : with_symb), with_symb_vld e8 o10 ∧ mdl (with_symb.phy o10) = MatrixArithmetic.mul (mdl (with_symb.phy a21)) (mdl (with_symb.phy b11)) ∧ with_symb.sym o10 = Symb.symb_mul (with_symb.sym a21) (with_symb.sym b11) → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy o10)) (mdl (with_symb.phy o9)) ∧ with_symb_vld e8 o10 ∧ with_symb_vld e8 o9) ∧ (∀(o11 : with_symb), mdl (with_symb.phy o11) = MatrixArithmetic.add (mdl (with_symb.phy o10)) (mdl (with_symb.phy o9)) ∧ with_symb.sym o11 = Symb.symb_add (with_symb.sym o10) (with_symb.sym o9) ∧ with_symb_vld e8 o11 → ((with_symb_vld e8 a12 ∧ with_symb_vld e8 b22) ∧ (MyMatrix.rows (mdl (with_symb.phy a12)) = qr ∧ MyMatrix.cols (mdl (with_symb.phy a12)) = qm) ∧ MyMatrix.rows (mdl (with_symb.phy b22)) = qm ∧ MyMatrix.cols (mdl (with_symb.phy b22)) = qc) ∧ (∀(o12 : with_symb), with_symb_vld e8 o12 ∧ mdl (with_symb.phy o12) = MatrixArithmetic.mul (mdl (with_symb.phy a12)) (mdl (with_symb.phy b22)) ∧ with_symb.sym o12 = Symb.symb_mul (with_symb.sym a12) (with_symb.sym b22) → ((with_symb_vld e8 a11 ∧ with_symb_vld e8 b12) ∧ (MyMatrix.rows (mdl (with_symb.phy a11)) = qr ∧ MyMatrix.cols (mdl (with_symb.phy a11)) = qm) ∧ MyMatrix.rows (mdl (with_symb.phy b12)) = qm ∧ MyMatrix.cols (mdl (with_symb.phy b12)) = qc) ∧ (∀(o13 : with_symb), with_symb_vld e8 o13 ∧ mdl (with_symb.phy o13) = MatrixArithmetic.mul (mdl (with_symb.phy a11)) (mdl (with_symb.phy b12)) ∧ with_symb.sym o13 = Symb.symb_mul (with_symb.sym a11) (with_symb.sym b12) → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy o13)) (mdl (with_symb.phy o12)) ∧ with_symb_vld e8 o13 ∧ with_symb_vld e8 o12) ∧ (∀(o14 : with_symb), mdl (with_symb.phy o14) = MatrixArithmetic.add (mdl (with_symb.phy o13)) (mdl (with_symb.phy o12)) ∧ with_symb.sym o14 = Symb.symb_add (with_symb.sym o13) (with_symb.sym o12) ∧ with_symb_vld e8 o14 → ((with_symb_vld e8 a22 ∧ with_symb_vld e8 b22) ∧ (MyMatrix.rows (mdl (with_symb.phy a22)) = qr ∧ MyMatrix.cols (mdl (with_symb.phy a22)) = qm) ∧ MyMatrix.rows (mdl (with_symb.phy b22)) = qm ∧ MyMatrix.cols (mdl (with_symb.phy b22)) = qc) ∧ (∀(o15 : with_symb), with_symb_vld e8 o15 ∧ mdl (with_symb.phy o15) = MatrixArithmetic.mul (mdl (with_symb.phy a22)) (mdl (with_symb.phy b22)) ∧ with_symb.sym o15 = Symb.symb_mul (with_symb.sym a22) (with_symb.sym b22) → ((with_symb_vld e8 a21 ∧ with_symb_vld e8 b12) ∧ (MyMatrix.rows (mdl (with_symb.phy a21)) = qr ∧ MyMatrix.cols (mdl (with_symb.phy a21)) = qm) ∧ MyMatrix.rows (mdl (with_symb.phy b12)) = qm ∧ MyMatrix.cols (mdl (with_symb.phy b12)) = qc) ∧ (∀(o16 : with_symb), with_symb_vld e8 o16 ∧ mdl (with_symb.phy o16) = MatrixArithmetic.mul (mdl (with_symb.phy a21)) (mdl (with_symb.phy b12)) ∧ with_symb.sym o16 = Symb.symb_mul (with_symb.sym a21) (with_symb.sym b12) → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy o16)) (mdl (with_symb.phy o15)) ∧ with_symb_vld e8 o16 ∧ with_symb_vld e8 o15) ∧ (∀(o17 : with_symb), mdl (with_symb.phy o17) = MatrixArithmetic.add (mdl (with_symb.phy o16)) (mdl (with_symb.phy o15)) ∧ with_symb.sym o17 = Symb.symb_add (with_symb.sym o16) (with_symb.sym o15) ∧ with_symb_vld e8 o17 → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy b11)) (mdl (with_symb.phy b22)) ∧ with_symb_vld e8 b11 ∧ with_symb_vld e8 b22) ∧ (∀(o18 : with_symb), mdl (with_symb.phy o18) = MatrixArithmetic.add (mdl (with_symb.phy b11)) (mdl (with_symb.phy b22)) ∧ with_symb.sym o18 = Symb.symb_add (with_symb.sym b11) (with_symb.sym b22) ∧ with_symb_vld e8 o18 → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy a11)) (mdl (with_symb.phy a22)) ∧ with_symb_vld e8 a11 ∧ with_symb_vld e8 a22) ∧ (∀(o19 : with_symb), mdl (with_symb.phy o19) = MatrixArithmetic.add (mdl (with_symb.phy a11)) (mdl (with_symb.phy a22)) ∧ with_symb.sym o19 = Symb.symb_add (with_symb.sym a11) (with_symb.sym a22) ∧ with_symb_vld e8 o19 → ((with_symb_vld e8 o19 ∧ with_symb_vld e8 o18) ∧ (MyMatrix.rows (mdl (with_symb.phy o19)) = qr ∧ MyMatrix.cols (mdl (with_symb.phy o19)) = qm) ∧ MyMatrix.rows (mdl (with_symb.phy o18)) = qm ∧ MyMatrix.cols (mdl (with_symb.phy o18)) = qc) ∧ (∀(x1 : with_symb), with_symb_vld e8 x1 ∧ mdl (with_symb.phy x1) = MatrixArithmetic.mul (mdl (with_symb.phy o19)) (mdl (with_symb.phy o18)) ∧ with_symb.sym x1 = Symb.symb_mul (with_symb.sym o19) (with_symb.sym o18) → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy a21)) (mdl (with_symb.phy a22)) ∧ with_symb_vld e8 a21 ∧ with_symb_vld e8 a22) ∧ (∀(o20 : with_symb), mdl (with_symb.phy o20) = MatrixArithmetic.add (mdl (with_symb.phy a21)) (mdl (with_symb.phy a22)) ∧ with_symb.sym o20 = Symb.symb_add (with_symb.sym a21) (with_symb.sym a22) ∧ with_symb_vld e8 o20 → ((with_symb_vld e8 o20 ∧ with_symb_vld e8 b11) ∧ (MyMatrix.rows (mdl (with_symb.phy o20)) = qr ∧ MyMatrix.cols (mdl (with_symb.phy o20)) = qm) ∧ MyMatrix.rows (mdl (with_symb.phy b11)) = qm ∧ MyMatrix.cols (mdl (with_symb.phy b11)) = qc) ∧ (∀(x2 : with_symb), with_symb_vld e8 x2 ∧ mdl (with_symb.phy x2) = MatrixArithmetic.mul (mdl (with_symb.phy o20)) (mdl (with_symb.phy b11)) ∧ with_symb.sym x2 = Symb.symb_mul (with_symb.sym o20) (with_symb.sym b11) → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy b12)) (mdl (with_symb.phy b22)) ∧ with_symb_vld e8 b12 ∧ with_symb_vld e8 b22) ∧ (∀(o21 : with_symb), mdl (with_symb.phy o21) = MatrixArithmetic.sub (mdl (with_symb.phy b12)) (mdl (with_symb.phy b22)) ∧ with_symb.sym o21 = Symb.symb_sub (with_symb.sym b12) (with_symb.sym b22) ∧ with_symb_vld e8 o21 → ((with_symb_vld e8 a11 ∧ with_symb_vld e8 o21) ∧ (MyMatrix.rows (mdl (with_symb.phy a11)) = qr ∧ MyMatrix.cols (mdl (with_symb.phy a11)) = qm) ∧ MyMatrix.rows (mdl (with_symb.phy o21)) = qm ∧ MyMatrix.cols (mdl (with_symb.phy o21)) = qc) ∧ (∀(x3 : with_symb), with_symb_vld e8 x3 ∧ mdl (with_symb.phy x3) = MatrixArithmetic.mul (mdl (with_symb.phy a11)) (mdl (with_symb.phy o21)) ∧ with_symb.sym x3 = Symb.symb_mul (with_symb.sym a11) (with_symb.sym o21) → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy b21)) (mdl (with_symb.phy b11)) ∧ with_symb_vld e8 b21 ∧ with_symb_vld e8 b11) ∧ (∀(o22 : with_symb), mdl (with_symb.phy o22) = MatrixArithmetic.sub (mdl (with_symb.phy b21)) (mdl (with_symb.phy b11)) ∧ with_symb.sym o22 = Symb.symb_sub (with_symb.sym b21) (with_symb.sym b11) ∧ with_symb_vld e8 o22 → ((with_symb_vld e8 a22 ∧ with_symb_vld e8 o22) ∧ (MyMatrix.rows (mdl (with_symb.phy a22)) = qr ∧ MyMatrix.cols (mdl (with_symb.phy a22)) = qm) ∧ MyMatrix.rows (mdl (with_symb.phy o22)) = qm ∧ MyMatrix.cols (mdl (with_symb.phy o22)) = qc) ∧ (∀(x4 : with_symb), with_symb_vld e8 x4 ∧ mdl (with_symb.phy x4) = MatrixArithmetic.mul (mdl (with_symb.phy a22)) (mdl (with_symb.phy o22)) ∧ with_symb.sym x4 = Symb.symb_mul (with_symb.sym a22) (with_symb.sym o22) → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy a11)) (mdl (with_symb.phy a12)) ∧ with_symb_vld e8 a11 ∧ with_symb_vld e8 a12) ∧ (∀(o23 : with_symb), mdl (with_symb.phy o23) = MatrixArithmetic.add (mdl (with_symb.phy a11)) (mdl (with_symb.phy a12)) ∧ with_symb.sym o23 = Symb.symb_add (with_symb.sym a11) (with_symb.sym a12) ∧ with_symb_vld e8 o23 → ((with_symb_vld e8 o23 ∧ with_symb_vld e8 b22) ∧ (MyMatrix.rows (mdl (with_symb.phy o23)) = qr ∧ MyMatrix.cols (mdl (with_symb.phy o23)) = qm) ∧ MyMatrix.rows (mdl (with_symb.phy b22)) = qm ∧ MyMatrix.cols (mdl (with_symb.phy b22)) = qc) ∧ (∀(x5 : with_symb), with_symb_vld e8 x5 ∧ mdl (with_symb.phy x5) = MatrixArithmetic.mul (mdl (with_symb.phy o23)) (mdl (with_symb.phy b22)) ∧ with_symb.sym x5 = Symb.symb_mul (with_symb.sym o23) (with_symb.sym b22) → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy b11)) (mdl (with_symb.phy b12)) ∧ with_symb_vld e8 b11 ∧ with_symb_vld e8 b12) ∧ (∀(o24 : with_symb), mdl (with_symb.phy o24) = MatrixArithmetic.add (mdl (with_symb.phy b11)) (mdl (with_symb.phy b12)) ∧ with_symb.sym o24 = Symb.symb_add (with_symb.sym b11) (with_symb.sym b12) ∧ with_symb_vld e8 o24 → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy a21)) (mdl (with_symb.phy a11)) ∧ with_symb_vld e8 a21 ∧ with_symb_vld e8 a11) ∧ (∀(o25 : with_symb), mdl (with_symb.phy o25) = MatrixArithmetic.sub (mdl (with_symb.phy a21)) (mdl (with_symb.phy a11)) ∧ with_symb.sym o25 = Symb.symb_sub (with_symb.sym a21) (with_symb.sym a11) ∧ with_symb_vld e8 o25 → ((with_symb_vld e8 o25 ∧ with_symb_vld e8 o24) ∧ (MyMatrix.rows (mdl (with_symb.phy o25)) = qr ∧ MyMatrix.cols (mdl (with_symb.phy o25)) = qm) ∧ MyMatrix.rows (mdl (with_symb.phy o24)) = qm ∧ MyMatrix.cols (mdl (with_symb.phy o24)) = qc) ∧ (∀(x6 : with_symb), with_symb_vld e8 x6 ∧ mdl (with_symb.phy x6) = MatrixArithmetic.mul (mdl (with_symb.phy o25)) (mdl (with_symb.phy o24)) ∧ with_symb.sym x6 = Symb.symb_mul (with_symb.sym o25) (with_symb.sym o24) → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy b21)) (mdl (with_symb.phy b22)) ∧ with_symb_vld e8 b21 ∧ with_symb_vld e8 b22) ∧ (∀(o26 : with_symb), mdl (with_symb.phy o26) = MatrixArithmetic.add (mdl (with_symb.phy b21)) (mdl (with_symb.phy b22)) ∧ with_symb.sym o26 = Symb.symb_add (with_symb.sym b21) (with_symb.sym b22) ∧ with_symb_vld e8 o26 → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy a12)) (mdl (with_symb.phy a22)) ∧ with_symb_vld e8 a12 ∧ with_symb_vld e8 a22) ∧ (∀(o27 : with_symb), mdl (with_symb.phy o27) = MatrixArithmetic.sub (mdl (with_symb.phy a12)) (mdl (with_symb.phy a22)) ∧ with_symb.sym o27 = Symb.symb_sub (with_symb.sym a12) (with_symb.sym a22) ∧ with_symb_vld e8 o27 → ((with_symb_vld e8 o27 ∧ with_symb_vld e8 o26) ∧ (MyMatrix.rows (mdl (with_symb.phy o27)) = qr ∧ MyMatrix.cols (mdl (with_symb.phy o27)) = qm) ∧ MyMatrix.rows (mdl (with_symb.phy o26)) = qm ∧ MyMatrix.cols (mdl (with_symb.phy o26)) = qc) ∧ (∀(x7 : with_symb), with_symb_vld e8 x7 ∧ mdl (with_symb.phy x7) = MatrixArithmetic.mul (mdl (with_symb.phy o27)) (mdl (with_symb.phy o26)) ∧ with_symb.sym x7 = Symb.symb_mul (with_symb.sym o27) (with_symb.sym o26) → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy x1)) (mdl (with_symb.phy x4)) ∧ with_symb_vld e8 x1 ∧ with_symb_vld e8 x4) ∧ (∀(o28 : with_symb), mdl (with_symb.phy o28) = MatrixArithmetic.add (mdl (with_symb.phy x1)) (mdl (with_symb.phy x4)) ∧ with_symb.sym o28 = Symb.symb_add (with_symb.sym x1) (with_symb.sym x4) ∧ with_symb_vld e8 o28 → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy o28)) (mdl (with_symb.phy x5)) ∧ with_symb_vld e8 o28 ∧ with_symb_vld e8 x5) ∧ (∀(o29 : with_symb), mdl (with_symb.phy o29) = MatrixArithmetic.sub (mdl (with_symb.phy o28)) (mdl (with_symb.phy x5)) ∧ with_symb.sym o29 = Symb.symb_sub (with_symb.sym o28) (with_symb.sym x5) ∧ with_symb_vld e8 o29 → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy o29)) (mdl (with_symb.phy x7)) ∧ with_symb_vld e8 o29 ∧ with_symb_vld e8 x7) ∧ (∀(m11 : with_symb), mdl (with_symb.phy m11) = MatrixArithmetic.add (mdl (with_symb.phy o29)) (mdl (with_symb.phy x7)) ∧ with_symb.sym m11 = Symb.symb_add (with_symb.sym o29) (with_symb.sym x7) ∧ with_symb_vld e8 m11 → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy x3)) (mdl (with_symb.phy x5)) ∧ with_symb_vld e8 x3 ∧ with_symb_vld e8 x5) ∧ (∀(m12 : with_symb), mdl (with_symb.phy m12) = MatrixArithmetic.add (mdl (with_symb.phy x3)) (mdl (with_symb.phy x5)) ∧ with_symb.sym m12 = Symb.symb_add (with_symb.sym x3) (with_symb.sym x5) ∧ with_symb_vld e8 m12 → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy x2)) (mdl (with_symb.phy x4)) ∧ with_symb_vld e8 x2 ∧ with_symb_vld e8 x4) ∧ (∀(m21 : with_symb), mdl (with_symb.phy m21) = MatrixArithmetic.add (mdl (with_symb.phy x2)) (mdl (with_symb.phy x4)) ∧ with_symb.sym m21 = Symb.symb_add (with_symb.sym x2) (with_symb.sym x4) ∧ with_symb_vld e8 m21 → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy x1)) (mdl (with_symb.phy x2)) ∧ with_symb_vld e8 x1 ∧ with_symb_vld e8 x2) ∧ (∀(o30 : with_symb), mdl (with_symb.phy o30) = MatrixArithmetic.sub (mdl (with_symb.phy x1)) (mdl (with_symb.phy x2)) ∧ with_symb.sym o30 = Symb.symb_sub (with_symb.sym x1) (with_symb.sym x2) ∧ with_symb_vld e8 o30 → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy o30)) (mdl (with_symb.phy x3)) ∧ with_symb_vld e8 o30 ∧ with_symb_vld e8 x3) ∧ (∀(o31 : with_symb), mdl (with_symb.phy o31) = MatrixArithmetic.add (mdl (with_symb.phy o30)) (mdl (with_symb.phy x3)) ∧ with_symb.sym o31 = Symb.symb_add (with_symb.sym o30) (with_symb.sym x3) ∧ with_symb_vld e8 o31 → (MyMatrix.infix_eqeqeq (mdl (with_symb.phy o31)) (mdl (with_symb.phy x6)) ∧ with_symb_vld e8 o31 ∧ with_symb_vld e8 x6) ∧ (∀(m22 : with_symb), mdl (with_symb.phy m22) = MatrixArithmetic.add (mdl (with_symb.phy o31)) (mdl (with_symb.phy x6)) ∧ with_symb.sym m22 = Symb.symb_add (with_symb.sym o31) (with_symb.sym x6) ∧ with_symb_vld e8 m22 → mdl (with_symb.phy m11) = mdl gm11 ∧ mdl (with_symb.phy m12) = mdl gm12 ∧ mdl (with_symb.phy m21) = mdl gm21 ∧ mdl (with_symb.phy m22) = mdl gm22)))))))))))))))))))))))))))))))))))))))))))))))))))))) ∧ (∀(m11 : Matrix.matrix ℤ) (m12 : Matrix.matrix ℤ) (m21 : Matrix.matrix ℤ) (m22 : Matrix.matrix ℤ), mdl m11 = mdl gm11 ∧ mdl m12 = mdl gm12 ∧ mdl m21 = mdl gm21 ∧ mdl m22 = mdl gm22 → (let o6 : ℤ := Matrix.columns b; let o7 : ℤ := Matrix.rows a; ((0 : ℤ) ≤ o7 ∧ (0 : ℤ) ≤ o6) ∧ (∀(res : Matrix.matrix ℤ), Matrix.rows res = o7 ∧ Matrix.columns res = o6 ∧ (∀(i : ℤ) (j : ℤ), ((0 : ℤ) ≤ i ∧ i < o7) ∧ (0 : ℤ) ≤ j ∧ j < o6 → Matrix.elts res i j = (0 : ℤ)) → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qr ∧ (0 : ℤ) + qr ≤ Matrix.rows m11) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qc ∧ (0 : ℤ) + qc ≤ Matrix.columns m11) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qr ∧ (0 : ℤ) + qr ≤ Matrix.rows res) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qc ∧ (0 : ℤ) + qc ≤ Matrix.columns res) ∧ (∀(res1 : Matrix.matrix ℤ), Matrix.rows res1 = Matrix.rows res ∧ Matrix.columns res1 = Matrix.columns res → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < (0 : ℤ) + qr → (0 : ℤ) ≤ j ∧ j < (0 : ℤ) + qc → Matrix.elts res1 i j = Matrix.elts m11 (i + ((0 : ℤ) - (0 : ℤ))) (j + ((0 : ℤ) - (0 : ℤ)))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < Matrix.rows res1 → (0 : ℤ) ≤ j ∧ j < Matrix.columns res1 → ¬(((0 : ℤ) ≤ i ∧ i < (0 : ℤ) + qr) ∧ (0 : ℤ) ≤ j ∧ j < (0 : ℤ) + qc) → Matrix.elts res1 i j = Matrix.elts res i j) → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qr ∧ (0 : ℤ) + qr ≤ Matrix.rows m12) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qc ∧ (0 : ℤ) + qc ≤ Matrix.columns m12) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qr ∧ (0 : ℤ) + qr ≤ Matrix.rows res1) ∧ (0 : ℤ) ≤ qc ∧ qc ≤ qc + qc ∧ qc + qc ≤ Matrix.columns res1) ∧ (∀(res2 : Matrix.matrix ℤ), Matrix.rows res2 = Matrix.rows res1 ∧ Matrix.columns res2 = Matrix.columns res1 → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < (0 : ℤ) + qr → qc ≤ j ∧ j < qc + qc → Matrix.elts res2 i j = Matrix.elts m12 (i + ((0 : ℤ) - (0 : ℤ))) (j + ((0 : ℤ) - qc))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < Matrix.rows res2 → (0 : ℤ) ≤ j ∧ j < Matrix.columns res2 → ¬(((0 : ℤ) ≤ i ∧ i < (0 : ℤ) + qr) ∧ qc ≤ j ∧ j < qc + qc) → Matrix.elts res2 i j = Matrix.elts res1 i j) → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qr ∧ (0 : ℤ) + qr ≤ Matrix.rows m21) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qc ∧ (0 : ℤ) + qc ≤ Matrix.columns m21) ∧ ((0 : ℤ) ≤ qr ∧ qr ≤ qr + qr ∧ qr + qr ≤ Matrix.rows res2) ∧ (0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qc ∧ (0 : ℤ) + qc ≤ Matrix.columns res2) ∧ (∀(res3 : Matrix.matrix ℤ), Matrix.rows res3 = Matrix.rows res2 ∧ Matrix.columns res3 = Matrix.columns res2 → (∀(i : ℤ) (j : ℤ), qr ≤ i ∧ i < qr + qr → (0 : ℤ) ≤ j ∧ j < (0 : ℤ) + qc → Matrix.elts res3 i j = Matrix.elts m21 (i + ((0 : ℤ) - qr)) (j + ((0 : ℤ) - (0 : ℤ)))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < Matrix.rows res3 → (0 : ℤ) ≤ j ∧ j < Matrix.columns res3 → ¬((qr ≤ i ∧ i < qr + qr) ∧ (0 : ℤ) ≤ j ∧ j < (0 : ℤ) + qc) → Matrix.elts res3 i j = Matrix.elts res2 i j) → (((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qr ∧ (0 : ℤ) + qr ≤ Matrix.rows m22) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) + qc ∧ (0 : ℤ) + qc ≤ Matrix.columns m22) ∧ ((0 : ℤ) ≤ qr ∧ qr ≤ qr + qr ∧ qr + qr ≤ Matrix.rows res3) ∧ (0 : ℤ) ≤ qc ∧ qc ≤ qc + qc ∧ qc + qc ≤ Matrix.columns res3) ∧ (∀(res4 : Matrix.matrix ℤ), Matrix.rows res4 = Matrix.rows res3 ∧ Matrix.columns res4 = Matrix.columns res3 → (∀(i : ℤ) (j : ℤ), qr ≤ i ∧ i < qr + qr → qc ≤ j ∧ j < qc + qc → Matrix.elts res4 i j = Matrix.elts m22 (i + ((0 : ℤ) - qr)) (j + ((0 : ℤ) - qc))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < Matrix.rows res4 → (0 : ℤ) ≤ j ∧ j < Matrix.columns res4 → ¬((qr ≤ i ∧ i < qr + qr) ∧ qc ≤ j ∧ j < qc + qc) → Matrix.elts res4 i j = Matrix.elts res3 i j) → mdl res4 = MatrixArithmetic.mul (mdl a) (mdl b) ∧ MyMatrix.rows (mdl res4) = MyMatrix.rows (mdl a) ∧ MyMatrix.cols (mdl res4) = MyMatrix.cols (mdl b)))))))))))))))))))))
  := sorry
end my_strassen_MatrixMultiplication_strassenqtvc
