From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.why3.Ref.Ref.
Require Import Why3.int.Sum.
Require Import verifythis_2016_matrix_multiplication.matrices.MyMatrix.
Require Import verifythis_2016_matrix_multiplication.matrices.MatrixArithmetic.
Require Import verifythis_2016_matrix_multiplication.sum_extended.Sum_extended.
Require Import verifythis_2016_matrix_multiplication.matrices.BlockMul.
Require Import verifythis_2016_matrix_multiplication.matrices_ring_simp.Symb.
Require Import Why3.matrix.Matrix.
Open Scope Z_scope.
Definition mdl {α : Type} `{Inhabited α} (m : matrix α) : mat α := create (Matrix.rows m) (columns m) (elts m).
Inductive with_symb :=
  | with_symb'mk : matrix Z -> expr -> with_symb.
Axiom with_symb_inhabited : Inhabited with_symb.
Global Existing Instance with_symb_inhabited.
Axiom with_symb_countable : Countable with_symb.
Global Existing Instance with_symb_countable.
Definition phy (x : with_symb) := match x with |  with_symb'mk a _ => a end.
Definition sym (x : with_symb) := match x with |  with_symb'mk _ a => a end.
Definition with_symb_vld (env : Symb.env) (ws : with_symb) := e_mdl env (sym ws) = mdl (phy ws) ∧ e_vld env (sym ws) ∧ e_rows (sym ws) = MyMatrix.rows (mdl (phy ws)) ∧ e_cols (sym ws) = cols (mdl (phy ws)).
Lemma block'vc (r : Z) (dr : Z) (a : matrix Z) (c : Z) (dc : Z) (fact0 : 0%Z ≤ r) (fact1 : r ≤ r + dr) (fact2 : r + dr ≤ MyMatrix.rows (mdl a)) (fact3 : 0%Z ≤ c) (fact4 : c ≤ c + dc) (fact5 : c + dc ≤ cols (mdl a)) : 0%Z ≤ dr ∧ 0%Z ≤ dc ∧ (∀(res : matrix Z), Matrix.rows res = dr ∧ columns res = dc ∧ (∀(i : Z) (j : Z), (0%Z ≤ i ∧ i < dr) ∧ 0%Z ≤ j ∧ j < dc -> elts res i j = 0%Z) -> ((0%Z ≤ r ∧ r ≤ r + dr ∧ r + dr ≤ Matrix.rows a) ∧ (0%Z ≤ c ∧ c ≤ c + dc ∧ c + dc ≤ columns a) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + dr ∧ 0%Z + dr ≤ Matrix.rows res) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + dc ∧ 0%Z + dc ≤ columns res) ∧ (∀(res1 : matrix Z), Matrix.rows res1 = Matrix.rows res ∧ columns res1 = columns res -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < 0%Z + dr -> 0%Z ≤ j ∧ j < 0%Z + dc -> elts res1 i j = elts a (i + (r - 0%Z)) (j + (c - 0%Z))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < Matrix.rows res1 -> 0%Z ≤ j ∧ j < columns res1 -> ¬ ((0%Z ≤ i ∧ i < 0%Z + dr) ∧ 0%Z ≤ j ∧ j < 0%Z + dc) -> elts res1 i j = elts res i j) -> mdl res1 = block (mdl a) r dr c dc ∧ MyMatrix.rows (mdl res1) = dr ∧ cols (mdl res1) = dc)).
Admitted.
