From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.why3.Ref.Ref.
Require Import Why3.int.Sum.
Require Import verifythis_2016_matrix_multiplication.matrices.MyMatrix.
Require Import verifythis_2016_matrix_multiplication.matrices.MatrixArithmetic.
Require Import verifythis_2016_matrix_multiplication.sum_extended.Sum_extended.
Require Import verifythis_2016_matrix_multiplication.matrices.BlockMul.
Require Import verifythis_2016_matrix_multiplication.matrices_ring_simp.Symb.
Require Import Why3.matrix.Matrix.
Open Scope Z_scope.
Definition mdl {α : Type} `{Inhabited α} (m : matrix α) : mat α := create (Matrix.rows m) (columns m) (elts m).
Inductive with_symb :=
  | with_symb'mk : matrix Z -> expr -> with_symb.
Axiom with_symb_inhabited : Inhabited with_symb.
Global Existing Instance with_symb_inhabited.
Axiom with_symb_countable : Countable with_symb.
Global Existing Instance with_symb_countable.
Definition phy (x : with_symb) := match x with |  with_symb'mk a _ => a end.
Definition sym (x : with_symb) := match x with |  with_symb'mk _ a => a end.
Definition with_symb_vld (env : Symb.env) (ws : with_symb) := e_mdl env (sym ws) = mdl (phy ws) ∧ e_vld env (sym ws) ∧ e_rows (sym ws) = MyMatrix.rows (mdl (phy ws)) ∧ e_cols (sym ws) = cols (mdl (phy ws)).
Lemma strassen'vc (a : matrix Z) (b : matrix Z) (flag : Z) (fact0 : cols (mdl a) = MyMatrix.rows (mdl b)) (fact1 : 0%Z ≤ flag) (fact2 : flag = 0%Z -> MyMatrix.rows (mdl a) = 1%Z ∨ cols (mdl a) = 1%Z ∨ cols (mdl b) = 1%Z ∨ Z.Even (MyMatrix.rows (mdl a)) ∧ Z.Even (cols (mdl a)) ∧ Z.Even (cols (mdl b))) : 1%Z ≤ 42%Z ∧ (∀(cut_off : Z), 1%Z ≤ cut_off -> (let o1 : Z := columns b in let o2 : Z := columns a in let o3 : Z := Matrix.rows a in ∀(o4 : bool), (if decide (o3 ≤ cut_off) then o4 = true else if decide (o2 ≤ cut_off) then o4 = true else o4 = (if decide (o1 ≤ cut_off) then true else false)) -> (if decide (o4 = true) then cols (mdl a) = MyMatrix.rows (mdl b) ∧ (∀(result : matrix Z), MyMatrix.rows (mdl result) = MyMatrix.rows (mdl a) ∧ cols (mdl result) = cols (mdl b) ∧ mdl result = mul (mdl a) (mdl b) -> mdl result = mul (mdl a) (mdl b) ∧ MyMatrix.rows (mdl result) = MyMatrix.rows (mdl a) ∧ cols (mdl result) = cols (mdl b)) else (∀(n : Z), 0%Z ≤ n -> ¬ 2%Z = 0%Z ∧ (let o5 : Z := ZEuclid.modulo n 2%Z in ¬ 2%Z = 0%Z ∧ (let o6 : Z := ZEuclid.div n 2%Z in n = 2%Z * o6 + o5 ∧ (0%Z ≤ o5 ∧ o5 ≤ 1%Z) ∧ n + o5 = 2%Z * (o6 + o5)))) ∧ 0%Z ≤ o3 ∧ (∀(qr : Z) (rr : Z), o3 = 2%Z * qr + rr ∧ (0%Z ≤ rr ∧ rr ≤ 1%Z) ∧ o3 + rr = 2%Z * (qr + rr) -> 0%Z ≤ o2 ∧ (∀(qm : Z) (rm : Z), o2 = 2%Z * qm + rm ∧ (0%Z ≤ rm ∧ rm ≤ 1%Z) ∧ o2 + rm = 2%Z * (qm + rm) -> 0%Z ≤ o1 ∧ (∀(qc : Z) (rc : Z), o1 = 2%Z * qc + rc ∧ (0%Z ≤ rc ∧ rc ≤ 1%Z) ∧ o1 + rc = 2%Z * (qc + rc) -> (∀(o5 : bool), (if decide (¬ rr = 0%Z) then o5 = true else if decide (¬ rm = 0%Z) then o5 = true else o5 = (if decide (rc = 0%Z) then false else true)) -> (if decide (o5 = true) then let o6 : Z := o1 + rc in let o7 : Z := o2 + rm in let o8 : Z := o3 + rr in ((MyMatrix.rows (mdl a) ≤ o8 ∧ cols (mdl a) ≤ o7) ∧ (∀(ap : matrix Z), MyMatrix.rows (mdl ap) = o8 ∧ cols (mdl ap) = o7 ∧ mdl a = block (mdl ap) 0%Z (MyMatrix.rows (mdl a)) 0%Z (cols (mdl a)) ∧ (let dr : Z := o8 - MyMatrix.rows (mdl a) in create dr (cols (mdl a)) zerof = block (mdl ap) (MyMatrix.rows (mdl a)) dr 0%Z (cols (mdl a))) ∧ (let dc : Z := o7 - cols (mdl a) in create (MyMatrix.rows (mdl a)) dc zerof = block (mdl ap) 0%Z (MyMatrix.rows (mdl a)) (cols (mdl a)) dc) -> (MyMatrix.rows (mdl b) ≤ o7 ∧ cols (mdl b) ≤ o6) ∧ (∀(bp : matrix Z), MyMatrix.rows (mdl bp) = o7 ∧ cols (mdl bp) = o6 ∧ mdl b = block (mdl bp) 0%Z (MyMatrix.rows (mdl b)) 0%Z (cols (mdl b)) ∧ (let dr : Z := o7 - MyMatrix.rows (mdl b) in create dr (cols (mdl b)) zerof = block (mdl bp) (MyMatrix.rows (mdl b)) dr 0%Z (cols (mdl b))) ∧ (let dc : Z := o6 - cols (mdl b) in create (MyMatrix.rows (mdl b)) dc zerof = block (mdl bp) 0%Z (MyMatrix.rows (mdl b)) (cols (mdl b)) dc) -> ((0%Z ≤ MyMatrix.rows (mdl a) + cols (mdl a) + cols (mdl b) + 3%Z * flag ∧ MyMatrix.rows (mdl ap) + cols (mdl ap) + cols (mdl bp) + 3%Z * 0%Z < MyMatrix.rows (mdl a) + cols (mdl a) + cols (mdl b) + 3%Z * flag ∨ MyMatrix.rows (mdl a) + cols (mdl a) + cols (mdl b) + 3%Z * flag = MyMatrix.rows (mdl ap) + cols (mdl ap) + cols (mdl bp) + 3%Z * 0%Z ∧ 0%Z ≤ flag ∧ 0%Z < flag) ∧ cols (mdl ap) = MyMatrix.rows (mdl bp) ∧ 0%Z ≤ 0%Z ∧ (MyMatrix.rows (mdl ap) = 1%Z ∨ cols (mdl ap) = 1%Z ∨ cols (mdl bp) = 1%Z ∨ Z.Even (MyMatrix.rows (mdl ap)) ∧ Z.Even (cols (mdl ap)) ∧ Z.Even (cols (mdl bp)))) ∧ (∀(m : matrix Z), mdl m = mul (mdl ap) (mdl bp) ∧ MyMatrix.rows (mdl m) = MyMatrix.rows (mdl ap) ∧ cols (mdl m) = cols (mdl bp) -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o3 ∧ 0%Z + o3 ≤ MyMatrix.rows (mdl ap)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o7 ∧ 0%Z + o7 ≤ cols (mdl ap)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o3 ∧ 0%Z + o3 ≤ o3) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o2 ∧ 0%Z + o2 ≤ o7) ∧ (block (block (mdl ap) 0%Z o3 0%Z o7) 0%Z o3 0%Z o2 = block (mdl ap) (0%Z + 0%Z) o3 (0%Z + 0%Z) o2 -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o3 ∧ 0%Z + o3 ≤ MyMatrix.rows (mdl ap)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o7 ∧ 0%Z + o7 ≤ cols (mdl ap)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o3 ∧ 0%Z + o3 ≤ o3) ∧ 0%Z ≤ o2 ∧ o2 ≤ o2 + rm ∧ o2 + rm ≤ o7) ∧ (block (block (mdl ap) 0%Z o3 0%Z o7) 0%Z o3 o2 rm = block (mdl ap) (0%Z + 0%Z) o3 (0%Z + o2) rm -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o7 ∧ 0%Z + o7 ≤ MyMatrix.rows (mdl bp)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o1 ∧ 0%Z + o1 ≤ cols (mdl bp)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o2 ∧ 0%Z + o2 ≤ o7) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o1 ∧ 0%Z + o1 ≤ o1) ∧ (block (block (mdl bp) 0%Z o7 0%Z o1) 0%Z o2 0%Z o1 = block (mdl bp) (0%Z + 0%Z) o2 (0%Z + 0%Z) o1 -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o7 ∧ 0%Z + o7 ≤ MyMatrix.rows (mdl bp)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o1 ∧ 0%Z + o1 ≤ cols (mdl bp)) ∧ (0%Z ≤ o2 ∧ o2 ≤ o2 + rm ∧ o2 + rm ≤ o7) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o1 ∧ 0%Z + o1 ≤ o1) ∧ (block (block (mdl bp) 0%Z o7 0%Z o1) o2 rm 0%Z o1 = block (mdl bp) (0%Z + o2) rm (0%Z + 0%Z) o1 -> (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o3 ∧ 0%Z + o3 ≤ MyMatrix.rows (mdl m)) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o1 ∧ 0%Z + o1 ≤ cols (mdl m))))))))) ∧ (∀(result : matrix Z), (∃(ap : matrix Z), (MyMatrix.rows (mdl ap) = o8 ∧ cols (mdl ap) = o7 ∧ mdl a = block (mdl ap) 0%Z (MyMatrix.rows (mdl a)) 0%Z (cols (mdl a)) ∧ (let dr : Z := o8 - MyMatrix.rows (mdl a) in create dr (cols (mdl a)) zerof = block (mdl ap) (MyMatrix.rows (mdl a)) dr 0%Z (cols (mdl a))) ∧ (let dc : Z := o7 - cols (mdl a) in create (MyMatrix.rows (mdl a)) dc zerof = block (mdl ap) 0%Z (MyMatrix.rows (mdl a)) (cols (mdl a)) dc)) ∧ (∃(bp : matrix Z), (MyMatrix.rows (mdl bp) = o7 ∧ cols (mdl bp) = o6 ∧ mdl b = block (mdl bp) 0%Z (MyMatrix.rows (mdl b)) 0%Z (cols (mdl b)) ∧ (let dr : Z := o7 - MyMatrix.rows (mdl b) in create dr (cols (mdl b)) zerof = block (mdl bp) (MyMatrix.rows (mdl b)) dr 0%Z (cols (mdl b))) ∧ (let dc : Z := o6 - cols (mdl b) in create (MyMatrix.rows (mdl b)) dc zerof = block (mdl bp) 0%Z (MyMatrix.rows (mdl b)) (cols (mdl b)) dc)) ∧ (∃(m : matrix Z), (mdl m = mul (mdl ap) (mdl bp) ∧ MyMatrix.rows (mdl m) = MyMatrix.rows (mdl ap) ∧ cols (mdl m) = cols (mdl bp)) ∧ block (block (mdl ap) 0%Z o3 0%Z o7) 0%Z o3 0%Z o2 = block (mdl ap) (0%Z + 0%Z) o3 (0%Z + 0%Z) o2 ∧ block (block (mdl ap) 0%Z o3 0%Z o7) 0%Z o3 o2 rm = block (mdl ap) (0%Z + 0%Z) o3 (0%Z + o2) rm ∧ block (block (mdl bp) 0%Z o7 0%Z o1) 0%Z o2 0%Z o1 = block (mdl bp) (0%Z + 0%Z) o2 (0%Z + 0%Z) o1 ∧ block (block (mdl bp) 0%Z o7 0%Z o1) o2 rm 0%Z o1 = block (mdl bp) (0%Z + o2) rm (0%Z + 0%Z) o1 ∧ mdl result = block (mdl m) 0%Z o3 0%Z o1 ∧ MyMatrix.rows (mdl result) = o3 ∧ cols (mdl result) = o1))) -> mdl result = mul (mdl a) (mdl b) ∧ MyMatrix.rows (mdl result) = MyMatrix.rows (mdl a) ∧ cols (mdl result) = cols (mdl b)) else cols (mdl a) = MyMatrix.rows (mdl b) ∧ (∀(gm : matrix Z), MyMatrix.rows (mdl gm) = MyMatrix.rows (mdl a) ∧ cols (mdl gm) = cols (mdl b) ∧ mdl gm = mul (mdl a) (mdl b) -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qr ∧ 0%Z + qr ≤ MyMatrix.rows (mdl gm)) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qc ∧ 0%Z + qc ≤ cols (mdl gm)) ∧ (∀(gm11 : matrix Z), mdl gm11 = block (mdl gm) 0%Z qr 0%Z qc ∧ MyMatrix.rows (mdl gm11) = qr ∧ cols (mdl gm11) = qc -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qr ∧ 0%Z + qr ≤ MyMatrix.rows (mdl gm)) ∧ 0%Z ≤ qc ∧ qc ≤ qc + qc ∧ qc + qc ≤ cols (mdl gm)) ∧ (∀(gm12 : matrix Z), mdl gm12 = block (mdl gm) 0%Z qr qc qc ∧ MyMatrix.rows (mdl gm12) = qr ∧ cols (mdl gm12) = qc -> ((0%Z ≤ qr ∧ qr ≤ qr + qr ∧ qr + qr ≤ MyMatrix.rows (mdl gm)) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qc ∧ 0%Z + qc ≤ cols (mdl gm)) ∧ (∀(gm21 : matrix Z), mdl gm21 = block (mdl gm) qr qr 0%Z qc ∧ MyMatrix.rows (mdl gm21) = qr ∧ cols (mdl gm21) = qc -> ((0%Z ≤ qr ∧ qr ≤ qr + qr ∧ qr + qr ≤ MyMatrix.rows (mdl gm)) ∧ 0%Z ≤ qc ∧ qc ≤ qc + qc ∧ qc + qc ≤ cols (mdl gm)) ∧ (∀(gm22 : matrix Z), mdl gm22 = block (mdl gm) qr qr qc qc ∧ MyMatrix.rows (mdl gm22) = qr ∧ cols (mdl gm22) = qc -> (∀(e : env), ev_c e = 0%Z -> (∀(e1 : env) (a1 : with_symb) (b1 : with_symb), (with_symb_vld e1 a1 ∧ with_symb_vld e1 b1) ∧ (MyMatrix.rows (mdl (phy a1)) = qr ∧ cols (mdl (phy a1)) = qm) ∧ MyMatrix.rows (mdl (phy b1)) = qm ∧ cols (mdl (phy b1)) = qc -> (∀(o6 : bool), (if decide (qr = 1%Z) then o6 = true else if decide (qm = 1%Z) then o6 = true else o6 = (if decide (qc = 1%Z) then true else false)) -> (∀(flag1 : Z), (if decide (o6 = true) then flag1 = 0%Z else flag1 = 1%Z) -> (let o7 : matrix Z := phy b1 in let o8 : matrix Z := phy a1 in ((0%Z ≤ MyMatrix.rows (mdl a) + cols (mdl a) + cols (mdl b) + 3%Z * flag ∧ MyMatrix.rows (mdl o8) + cols (mdl o8) + cols (mdl o7) + 3%Z * flag1 < MyMatrix.rows (mdl a) + cols (mdl a) + cols (mdl b) + 3%Z * flag ∨ MyMatrix.rows (mdl a) + cols (mdl a) + cols (mdl b) + 3%Z * flag = MyMatrix.rows (mdl o8) + cols (mdl o8) + cols (mdl o7) + 3%Z * flag1 ∧ 0%Z ≤ flag ∧ flag1 < flag) ∧ cols (mdl o8) = MyMatrix.rows (mdl o7) ∧ 0%Z ≤ flag1 ∧ (flag1 = 0%Z -> MyMatrix.rows (mdl o8) = 1%Z ∨ cols (mdl o8) = 1%Z ∨ cols (mdl o7) = 1%Z ∨ Z.Even (MyMatrix.rows (mdl o8)) ∧ Z.Even (cols (mdl o8)) ∧ Z.Even (cols (mdl o7)))) ∧ (∀(r : matrix Z), mdl r = mul (mdl o8) (mdl o7) ∧ MyMatrix.rows (mdl r) = MyMatrix.rows (mdl o8) ∧ cols (mdl r) = cols (mdl o7) -> (let o9 : expr := sym b1 in let o10 : expr := sym a1 in ((e_vld e1 o10 ∧ e_vld e1 o9) ∧ e_cols o10 = e_rows o9) ∧ (e_vld e1 (symb_mul o10 o9) ∧ e_mdl e1 (symb_mul o10 o9) = mul (e_mdl e1 o10) (e_mdl e1 o9) -> with_symb_vld e1 (with_symb'mk r (symb_mul o10 o9)) ∧ mdl r = mul (mdl (phy a1)) (mdl (phy b1)) ∧ symb_mul o10 o9 = symb_mul (sym a1) (sym b1)))))))) ∧ ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qr ∧ 0%Z + qr ≤ MyMatrix.rows (mdl a)) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qm ∧ 0%Z + qm ≤ cols (mdl a)) ∧ (∀(e1 : env) (a11 : with_symb), (let rm1 : mat Z := mdl (phy a11) in rm1 = block (mdl a) 0%Z qr 0%Z qm ∧ MyMatrix.rows rm1 = qr ∧ cols rm1 = qm) ∧ sym a11 = symb_mat (mdl (phy a11)) (ev_c e) ∧ ev_f e1 = extends1 (ev_f e) (ev_c e) (mdl (phy a11)) ∧ ev_c e1 = ev_c e + 1%Z ∧ with_symb_vld e1 a11 -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qr ∧ 0%Z + qr ≤ MyMatrix.rows (mdl a)) ∧ 0%Z ≤ qm ∧ qm ≤ qm + qm ∧ qm + qm ≤ cols (mdl a)) ∧ (∀(e2 : env) (a12 : with_symb), (let rm1 : mat Z := mdl (phy a12) in rm1 = block (mdl a) 0%Z qr qm qm ∧ MyMatrix.rows rm1 = qr ∧ cols rm1 = qm) ∧ sym a12 = symb_mat (mdl (phy a12)) (ev_c e1) ∧ ev_f e2 = extends1 (ev_f e1) (ev_c e1) (mdl (phy a12)) ∧ ev_c e2 = ev_c e1 + 1%Z ∧ with_symb_vld e2 a12 -> ((0%Z ≤ qr ∧ qr ≤ qr + qr ∧ qr + qr ≤ MyMatrix.rows (mdl a)) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qm ∧ 0%Z + qm ≤ cols (mdl a)) ∧ (∀(e3 : env) (a21 : with_symb), (let rm1 : mat Z := mdl (phy a21) in rm1 = block (mdl a) qr qr 0%Z qm ∧ MyMatrix.rows rm1 = qr ∧ cols rm1 = qm) ∧ sym a21 = symb_mat (mdl (phy a21)) (ev_c e2) ∧ ev_f e3 = extends1 (ev_f e2) (ev_c e2) (mdl (phy a21)) ∧ ev_c e3 = ev_c e2 + 1%Z ∧ with_symb_vld e3 a21 -> ((0%Z ≤ qr ∧ qr ≤ qr + qr ∧ qr + qr ≤ MyMatrix.rows (mdl a)) ∧ 0%Z ≤ qm ∧ qm ≤ qm + qm ∧ qm + qm ≤ cols (mdl a)) ∧ (∀(e4 : env) (a22 : with_symb), (let rm1 : mat Z := mdl (phy a22) in rm1 = block (mdl a) qr qr qm qm ∧ MyMatrix.rows rm1 = qr ∧ cols rm1 = qm) ∧ sym a22 = symb_mat (mdl (phy a22)) (ev_c e3) ∧ ev_f e4 = extends1 (ev_f e3) (ev_c e3) (mdl (phy a22)) ∧ ev_c e4 = ev_c e3 + 1%Z ∧ with_symb_vld e4 a22 -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qr ∧ 0%Z + qr ≤ MyMatrix.rows (mdl a)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o2 ∧ 0%Z + o2 ≤ cols (mdl a)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qr ∧ 0%Z + qr ≤ qr) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qm ∧ 0%Z + qm ≤ o2) ∧ (block (block (mdl a) 0%Z qr 0%Z o2) 0%Z qr 0%Z qm = block (mdl a) (0%Z + 0%Z) qr (0%Z + 0%Z) qm -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qr ∧ 0%Z + qr ≤ MyMatrix.rows (mdl a)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o2 ∧ 0%Z + o2 ≤ cols (mdl a)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qr ∧ 0%Z + qr ≤ qr) ∧ 0%Z ≤ qm ∧ qm ≤ qm + qm ∧ qm + qm ≤ o2) ∧ (block (block (mdl a) 0%Z qr 0%Z o2) 0%Z qr qm qm = block (mdl a) (0%Z + 0%Z) qr (0%Z + qm) qm -> ((0%Z ≤ qr ∧ qr ≤ qr + qr ∧ qr + qr ≤ MyMatrix.rows (mdl a)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o2 ∧ 0%Z + o2 ≤ cols (mdl a)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qr ∧ 0%Z + qr ≤ qr) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qm ∧ 0%Z + qm ≤ o2) ∧ (block (block (mdl a) qr qr 0%Z o2) 0%Z qr 0%Z qm = block (mdl a) (qr + 0%Z) qr (0%Z + 0%Z) qm -> ((0%Z ≤ qr ∧ qr ≤ qr + qr ∧ qr + qr ≤ MyMatrix.rows (mdl a)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o2 ∧ 0%Z + o2 ≤ cols (mdl a)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qr ∧ 0%Z + qr ≤ qr) ∧ 0%Z ≤ qm ∧ qm ≤ qm + qm ∧ qm + qm ≤ o2) ∧ (block (block (mdl a) qr qr 0%Z o2) 0%Z qr qm qm = block (mdl a) (qr + 0%Z) qr (0%Z + qm) qm -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qm ∧ 0%Z + qm ≤ MyMatrix.rows (mdl b)) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qc ∧ 0%Z + qc ≤ cols (mdl b)) ∧ (∀(e5 : env) (b11 : with_symb), (let rm1 : mat Z := mdl (phy b11) in rm1 = block (mdl b) 0%Z qm 0%Z qc ∧ MyMatrix.rows rm1 = qm ∧ cols rm1 = qc) ∧ sym b11 = symb_mat (mdl (phy b11)) (ev_c e4) ∧ ev_f e5 = extends1 (ev_f e4) (ev_c e4) (mdl (phy b11)) ∧ ev_c e5 = ev_c e4 + 1%Z ∧ with_symb_vld e5 b11 -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qm ∧ 0%Z + qm ≤ MyMatrix.rows (mdl b)) ∧ 0%Z ≤ qc ∧ qc ≤ qc + qc ∧ qc + qc ≤ cols (mdl b)) ∧ (∀(e6 : env) (b12 : with_symb), (let rm1 : mat Z := mdl (phy b12) in rm1 = block (mdl b) 0%Z qm qc qc ∧ MyMatrix.rows rm1 = qm ∧ cols rm1 = qc) ∧ sym b12 = symb_mat (mdl (phy b12)) (ev_c e5) ∧ ev_f e6 = extends1 (ev_f e5) (ev_c e5) (mdl (phy b12)) ∧ ev_c e6 = ev_c e5 + 1%Z ∧ with_symb_vld e6 b12 -> ((0%Z ≤ qm ∧ qm ≤ qm + qm ∧ qm + qm ≤ MyMatrix.rows (mdl b)) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qc ∧ 0%Z + qc ≤ cols (mdl b)) ∧ (∀(e7 : env) (b21 : with_symb), (let rm1 : mat Z := mdl (phy b21) in rm1 = block (mdl b) qm qm 0%Z qc ∧ MyMatrix.rows rm1 = qm ∧ cols rm1 = qc) ∧ sym b21 = symb_mat (mdl (phy b21)) (ev_c e6) ∧ ev_f e7 = extends1 (ev_f e6) (ev_c e6) (mdl (phy b21)) ∧ ev_c e7 = ev_c e6 + 1%Z ∧ with_symb_vld e7 b21 -> ((0%Z ≤ qm ∧ qm ≤ qm + qm ∧ qm + qm ≤ MyMatrix.rows (mdl b)) ∧ 0%Z ≤ qc ∧ qc ≤ qc + qc ∧ qc + qc ≤ cols (mdl b)) ∧ (∀(e8 : env) (b22 : with_symb), (let rm1 : mat Z := mdl (phy b22) in rm1 = block (mdl b) qm qm qc qc ∧ MyMatrix.rows rm1 = qm ∧ cols rm1 = qc) ∧ sym b22 = symb_mat (mdl (phy b22)) (ev_c e7) ∧ ev_f e8 = extends1 (ev_f e7) (ev_c e7) (mdl (phy b22)) ∧ ev_c e8 = ev_c e7 + 1%Z ∧ with_symb_vld e8 b22 -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o2 ∧ 0%Z + o2 ≤ MyMatrix.rows (mdl b)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qc ∧ 0%Z + qc ≤ cols (mdl b)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qm ∧ 0%Z + qm ≤ o2) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qc ∧ 0%Z + qc ≤ qc) ∧ (block (block (mdl b) 0%Z o2 0%Z qc) 0%Z qm 0%Z qc = block (mdl b) (0%Z + 0%Z) qm (0%Z + 0%Z) qc -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o2 ∧ 0%Z + o2 ≤ MyMatrix.rows (mdl b)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qc ∧ 0%Z + qc ≤ cols (mdl b)) ∧ (0%Z ≤ qm ∧ qm ≤ qm + qm ∧ qm + qm ≤ o2) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qc ∧ 0%Z + qc ≤ qc) ∧ (block (block (mdl b) 0%Z o2 0%Z qc) qm qm 0%Z qc = block (mdl b) (0%Z + qm) qm (0%Z + 0%Z) qc -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o2 ∧ 0%Z + o2 ≤ MyMatrix.rows (mdl b)) ∧ (0%Z ≤ qc ∧ qc ≤ qc + qc ∧ qc + qc ≤ cols (mdl b)) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qm ∧ 0%Z + qm ≤ o2) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qc ∧ 0%Z + qc ≤ qc) ∧ (block (block (mdl b) 0%Z o2 qc qc) 0%Z qm 0%Z qc = block (mdl b) (0%Z + 0%Z) qm (qc + 0%Z) qc -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + o2 ∧ 0%Z + o2 ≤ MyMatrix.rows (mdl b)) ∧ (0%Z ≤ qc ∧ qc ≤ qc + qc ∧ qc + qc ≤ cols (mdl b)) ∧ (0%Z ≤ qm ∧ qm ≤ qm + qm ∧ qm + qm ≤ o2) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qc ∧ 0%Z + qc ≤ qc) ∧ (block (block (mdl b) 0%Z o2 qc qc) qm qm 0%Z qc = block (mdl b) (0%Z + qm) qm (qc + 0%Z) qc -> ((with_symb_vld e8 a12 ∧ with_symb_vld e8 b21) ∧ (MyMatrix.rows (mdl (phy a12)) = qr ∧ cols (mdl (phy a12)) = qm) ∧ MyMatrix.rows (mdl (phy b21)) = qm ∧ cols (mdl (phy b21)) = qc) ∧ (∀(o6 : with_symb), with_symb_vld e8 o6 ∧ mdl (phy o6) = mul (mdl (phy a12)) (mdl (phy b21)) ∧ sym o6 = symb_mul (sym a12) (sym b21) -> ((with_symb_vld e8 a11 ∧ with_symb_vld e8 b11) ∧ (MyMatrix.rows (mdl (phy a11)) = qr ∧ cols (mdl (phy a11)) = qm) ∧ MyMatrix.rows (mdl (phy b11)) = qm ∧ cols (mdl (phy b11)) = qc) ∧ (∀(o7 : with_symb), with_symb_vld e8 o7 ∧ mdl (phy o7) = mul (mdl (phy a11)) (mdl (phy b11)) ∧ sym o7 = symb_mul (sym a11) (sym b11) -> (infix_eqeqeq (mdl (phy o7)) (mdl (phy o6)) ∧ with_symb_vld e8 o7 ∧ with_symb_vld e8 o6) ∧ (∀(o8 : with_symb), mdl (phy o8) = add (mdl (phy o7)) (mdl (phy o6)) ∧ sym o8 = symb_add (sym o7) (sym o6) ∧ with_symb_vld e8 o8 -> ((with_symb_vld e8 a22 ∧ with_symb_vld e8 b21) ∧ (MyMatrix.rows (mdl (phy a22)) = qr ∧ cols (mdl (phy a22)) = qm) ∧ MyMatrix.rows (mdl (phy b21)) = qm ∧ cols (mdl (phy b21)) = qc) ∧ (∀(o9 : with_symb), with_symb_vld e8 o9 ∧ mdl (phy o9) = mul (mdl (phy a22)) (mdl (phy b21)) ∧ sym o9 = symb_mul (sym a22) (sym b21) -> ((with_symb_vld e8 a21 ∧ with_symb_vld e8 b11) ∧ (MyMatrix.rows (mdl (phy a21)) = qr ∧ cols (mdl (phy a21)) = qm) ∧ MyMatrix.rows (mdl (phy b11)) = qm ∧ cols (mdl (phy b11)) = qc) ∧ (∀(o10 : with_symb), with_symb_vld e8 o10 ∧ mdl (phy o10) = mul (mdl (phy a21)) (mdl (phy b11)) ∧ sym o10 = symb_mul (sym a21) (sym b11) -> (infix_eqeqeq (mdl (phy o10)) (mdl (phy o9)) ∧ with_symb_vld e8 o10 ∧ with_symb_vld e8 o9) ∧ (∀(o11 : with_symb), mdl (phy o11) = add (mdl (phy o10)) (mdl (phy o9)) ∧ sym o11 = symb_add (sym o10) (sym o9) ∧ with_symb_vld e8 o11 -> ((with_symb_vld e8 a12 ∧ with_symb_vld e8 b22) ∧ (MyMatrix.rows (mdl (phy a12)) = qr ∧ cols (mdl (phy a12)) = qm) ∧ MyMatrix.rows (mdl (phy b22)) = qm ∧ cols (mdl (phy b22)) = qc) ∧ (∀(o12 : with_symb), with_symb_vld e8 o12 ∧ mdl (phy o12) = mul (mdl (phy a12)) (mdl (phy b22)) ∧ sym o12 = symb_mul (sym a12) (sym b22) -> ((with_symb_vld e8 a11 ∧ with_symb_vld e8 b12) ∧ (MyMatrix.rows (mdl (phy a11)) = qr ∧ cols (mdl (phy a11)) = qm) ∧ MyMatrix.rows (mdl (phy b12)) = qm ∧ cols (mdl (phy b12)) = qc) ∧ (∀(o13 : with_symb), with_symb_vld e8 o13 ∧ mdl (phy o13) = mul (mdl (phy a11)) (mdl (phy b12)) ∧ sym o13 = symb_mul (sym a11) (sym b12) -> (infix_eqeqeq (mdl (phy o13)) (mdl (phy o12)) ∧ with_symb_vld e8 o13 ∧ with_symb_vld e8 o12) ∧ (∀(o14 : with_symb), mdl (phy o14) = add (mdl (phy o13)) (mdl (phy o12)) ∧ sym o14 = symb_add (sym o13) (sym o12) ∧ with_symb_vld e8 o14 -> ((with_symb_vld e8 a22 ∧ with_symb_vld e8 b22) ∧ (MyMatrix.rows (mdl (phy a22)) = qr ∧ cols (mdl (phy a22)) = qm) ∧ MyMatrix.rows (mdl (phy b22)) = qm ∧ cols (mdl (phy b22)) = qc) ∧ (∀(o15 : with_symb), with_symb_vld e8 o15 ∧ mdl (phy o15) = mul (mdl (phy a22)) (mdl (phy b22)) ∧ sym o15 = symb_mul (sym a22) (sym b22) -> ((with_symb_vld e8 a21 ∧ with_symb_vld e8 b12) ∧ (MyMatrix.rows (mdl (phy a21)) = qr ∧ cols (mdl (phy a21)) = qm) ∧ MyMatrix.rows (mdl (phy b12)) = qm ∧ cols (mdl (phy b12)) = qc) ∧ (∀(o16 : with_symb), with_symb_vld e8 o16 ∧ mdl (phy o16) = mul (mdl (phy a21)) (mdl (phy b12)) ∧ sym o16 = symb_mul (sym a21) (sym b12) -> (infix_eqeqeq (mdl (phy o16)) (mdl (phy o15)) ∧ with_symb_vld e8 o16 ∧ with_symb_vld e8 o15) ∧ (∀(o17 : with_symb), mdl (phy o17) = add (mdl (phy o16)) (mdl (phy o15)) ∧ sym o17 = symb_add (sym o16) (sym o15) ∧ with_symb_vld e8 o17 -> (infix_eqeqeq (mdl (phy b11)) (mdl (phy b22)) ∧ with_symb_vld e8 b11 ∧ with_symb_vld e8 b22) ∧ (∀(o18 : with_symb), mdl (phy o18) = add (mdl (phy b11)) (mdl (phy b22)) ∧ sym o18 = symb_add (sym b11) (sym b22) ∧ with_symb_vld e8 o18 -> (infix_eqeqeq (mdl (phy a11)) (mdl (phy a22)) ∧ with_symb_vld e8 a11 ∧ with_symb_vld e8 a22) ∧ (∀(o19 : with_symb), mdl (phy o19) = add (mdl (phy a11)) (mdl (phy a22)) ∧ sym o19 = symb_add (sym a11) (sym a22) ∧ with_symb_vld e8 o19 -> ((with_symb_vld e8 o19 ∧ with_symb_vld e8 o18) ∧ (MyMatrix.rows (mdl (phy o19)) = qr ∧ cols (mdl (phy o19)) = qm) ∧ MyMatrix.rows (mdl (phy o18)) = qm ∧ cols (mdl (phy o18)) = qc) ∧ (∀(x1 : with_symb), with_symb_vld e8 x1 ∧ mdl (phy x1) = mul (mdl (phy o19)) (mdl (phy o18)) ∧ sym x1 = symb_mul (sym o19) (sym o18) -> (infix_eqeqeq (mdl (phy a21)) (mdl (phy a22)) ∧ with_symb_vld e8 a21 ∧ with_symb_vld e8 a22) ∧ (∀(o20 : with_symb), mdl (phy o20) = add (mdl (phy a21)) (mdl (phy a22)) ∧ sym o20 = symb_add (sym a21) (sym a22) ∧ with_symb_vld e8 o20 -> ((with_symb_vld e8 o20 ∧ with_symb_vld e8 b11) ∧ (MyMatrix.rows (mdl (phy o20)) = qr ∧ cols (mdl (phy o20)) = qm) ∧ MyMatrix.rows (mdl (phy b11)) = qm ∧ cols (mdl (phy b11)) = qc) ∧ (∀(x2 : with_symb), with_symb_vld e8 x2 ∧ mdl (phy x2) = mul (mdl (phy o20)) (mdl (phy b11)) ∧ sym x2 = symb_mul (sym o20) (sym b11) -> (infix_eqeqeq (mdl (phy b12)) (mdl (phy b22)) ∧ with_symb_vld e8 b12 ∧ with_symb_vld e8 b22) ∧ (∀(o21 : with_symb), mdl (phy o21) = sub (mdl (phy b12)) (mdl (phy b22)) ∧ sym o21 = symb_sub (sym b12) (sym b22) ∧ with_symb_vld e8 o21 -> ((with_symb_vld e8 a11 ∧ with_symb_vld e8 o21) ∧ (MyMatrix.rows (mdl (phy a11)) = qr ∧ cols (mdl (phy a11)) = qm) ∧ MyMatrix.rows (mdl (phy o21)) = qm ∧ cols (mdl (phy o21)) = qc) ∧ (∀(x3 : with_symb), with_symb_vld e8 x3 ∧ mdl (phy x3) = mul (mdl (phy a11)) (mdl (phy o21)) ∧ sym x3 = symb_mul (sym a11) (sym o21) -> (infix_eqeqeq (mdl (phy b21)) (mdl (phy b11)) ∧ with_symb_vld e8 b21 ∧ with_symb_vld e8 b11) ∧ (∀(o22 : with_symb), mdl (phy o22) = sub (mdl (phy b21)) (mdl (phy b11)) ∧ sym o22 = symb_sub (sym b21) (sym b11) ∧ with_symb_vld e8 o22 -> ((with_symb_vld e8 a22 ∧ with_symb_vld e8 o22) ∧ (MyMatrix.rows (mdl (phy a22)) = qr ∧ cols (mdl (phy a22)) = qm) ∧ MyMatrix.rows (mdl (phy o22)) = qm ∧ cols (mdl (phy o22)) = qc) ∧ (∀(x4 : with_symb), with_symb_vld e8 x4 ∧ mdl (phy x4) = mul (mdl (phy a22)) (mdl (phy o22)) ∧ sym x4 = symb_mul (sym a22) (sym o22) -> (infix_eqeqeq (mdl (phy a11)) (mdl (phy a12)) ∧ with_symb_vld e8 a11 ∧ with_symb_vld e8 a12) ∧ (∀(o23 : with_symb), mdl (phy o23) = add (mdl (phy a11)) (mdl (phy a12)) ∧ sym o23 = symb_add (sym a11) (sym a12) ∧ with_symb_vld e8 o23 -> ((with_symb_vld e8 o23 ∧ with_symb_vld e8 b22) ∧ (MyMatrix.rows (mdl (phy o23)) = qr ∧ cols (mdl (phy o23)) = qm) ∧ MyMatrix.rows (mdl (phy b22)) = qm ∧ cols (mdl (phy b22)) = qc) ∧ (∀(x5 : with_symb), with_symb_vld e8 x5 ∧ mdl (phy x5) = mul (mdl (phy o23)) (mdl (phy b22)) ∧ sym x5 = symb_mul (sym o23) (sym b22) -> (infix_eqeqeq (mdl (phy b11)) (mdl (phy b12)) ∧ with_symb_vld e8 b11 ∧ with_symb_vld e8 b12) ∧ (∀(o24 : with_symb), mdl (phy o24) = add (mdl (phy b11)) (mdl (phy b12)) ∧ sym o24 = symb_add (sym b11) (sym b12) ∧ with_symb_vld e8 o24 -> (infix_eqeqeq (mdl (phy a21)) (mdl (phy a11)) ∧ with_symb_vld e8 a21 ∧ with_symb_vld e8 a11) ∧ (∀(o25 : with_symb), mdl (phy o25) = sub (mdl (phy a21)) (mdl (phy a11)) ∧ sym o25 = symb_sub (sym a21) (sym a11) ∧ with_symb_vld e8 o25 -> ((with_symb_vld e8 o25 ∧ with_symb_vld e8 o24) ∧ (MyMatrix.rows (mdl (phy o25)) = qr ∧ cols (mdl (phy o25)) = qm) ∧ MyMatrix.rows (mdl (phy o24)) = qm ∧ cols (mdl (phy o24)) = qc) ∧ (∀(x6 : with_symb), with_symb_vld e8 x6 ∧ mdl (phy x6) = mul (mdl (phy o25)) (mdl (phy o24)) ∧ sym x6 = symb_mul (sym o25) (sym o24) -> (infix_eqeqeq (mdl (phy b21)) (mdl (phy b22)) ∧ with_symb_vld e8 b21 ∧ with_symb_vld e8 b22) ∧ (∀(o26 : with_symb), mdl (phy o26) = add (mdl (phy b21)) (mdl (phy b22)) ∧ sym o26 = symb_add (sym b21) (sym b22) ∧ with_symb_vld e8 o26 -> (infix_eqeqeq (mdl (phy a12)) (mdl (phy a22)) ∧ with_symb_vld e8 a12 ∧ with_symb_vld e8 a22) ∧ (∀(o27 : with_symb), mdl (phy o27) = sub (mdl (phy a12)) (mdl (phy a22)) ∧ sym o27 = symb_sub (sym a12) (sym a22) ∧ with_symb_vld e8 o27 -> ((with_symb_vld e8 o27 ∧ with_symb_vld e8 o26) ∧ (MyMatrix.rows (mdl (phy o27)) = qr ∧ cols (mdl (phy o27)) = qm) ∧ MyMatrix.rows (mdl (phy o26)) = qm ∧ cols (mdl (phy o26)) = qc) ∧ (∀(x7 : with_symb), with_symb_vld e8 x7 ∧ mdl (phy x7) = mul (mdl (phy o27)) (mdl (phy o26)) ∧ sym x7 = symb_mul (sym o27) (sym o26) -> (infix_eqeqeq (mdl (phy x1)) (mdl (phy x4)) ∧ with_symb_vld e8 x1 ∧ with_symb_vld e8 x4) ∧ (∀(o28 : with_symb), mdl (phy o28) = add (mdl (phy x1)) (mdl (phy x4)) ∧ sym o28 = symb_add (sym x1) (sym x4) ∧ with_symb_vld e8 o28 -> (infix_eqeqeq (mdl (phy o28)) (mdl (phy x5)) ∧ with_symb_vld e8 o28 ∧ with_symb_vld e8 x5) ∧ (∀(o29 : with_symb), mdl (phy o29) = sub (mdl (phy o28)) (mdl (phy x5)) ∧ sym o29 = symb_sub (sym o28) (sym x5) ∧ with_symb_vld e8 o29 -> (infix_eqeqeq (mdl (phy o29)) (mdl (phy x7)) ∧ with_symb_vld e8 o29 ∧ with_symb_vld e8 x7) ∧ (∀(m11 : with_symb), mdl (phy m11) = add (mdl (phy o29)) (mdl (phy x7)) ∧ sym m11 = symb_add (sym o29) (sym x7) ∧ with_symb_vld e8 m11 -> (infix_eqeqeq (mdl (phy x3)) (mdl (phy x5)) ∧ with_symb_vld e8 x3 ∧ with_symb_vld e8 x5) ∧ (∀(m12 : with_symb), mdl (phy m12) = add (mdl (phy x3)) (mdl (phy x5)) ∧ sym m12 = symb_add (sym x3) (sym x5) ∧ with_symb_vld e8 m12 -> (infix_eqeqeq (mdl (phy x2)) (mdl (phy x4)) ∧ with_symb_vld e8 x2 ∧ with_symb_vld e8 x4) ∧ (∀(m21 : with_symb), mdl (phy m21) = add (mdl (phy x2)) (mdl (phy x4)) ∧ sym m21 = symb_add (sym x2) (sym x4) ∧ with_symb_vld e8 m21 -> (infix_eqeqeq (mdl (phy x1)) (mdl (phy x2)) ∧ with_symb_vld e8 x1 ∧ with_symb_vld e8 x2) ∧ (∀(o30 : with_symb), mdl (phy o30) = sub (mdl (phy x1)) (mdl (phy x2)) ∧ sym o30 = symb_sub (sym x1) (sym x2) ∧ with_symb_vld e8 o30 -> (infix_eqeqeq (mdl (phy o30)) (mdl (phy x3)) ∧ with_symb_vld e8 o30 ∧ with_symb_vld e8 x3) ∧ (∀(o31 : with_symb), mdl (phy o31) = add (mdl (phy o30)) (mdl (phy x3)) ∧ sym o31 = symb_add (sym o30) (sym x3) ∧ with_symb_vld e8 o31 -> (infix_eqeqeq (mdl (phy o31)) (mdl (phy x6)) ∧ with_symb_vld e8 o31 ∧ with_symb_vld e8 x6) ∧ (∀(m22 : with_symb), mdl (phy m22) = add (mdl (phy o31)) (mdl (phy x6)) ∧ sym m22 = symb_add (sym o31) (sym x6) ∧ with_symb_vld e8 m22 -> mdl (phy m11) = mdl gm11 ∧ mdl (phy m12) = mdl gm12 ∧ mdl (phy m21) = mdl gm21 ∧ mdl (phy m22) = mdl gm22)))))))))))))))))))))))))))))))))))))))))))))))))))))) ∧ (∀(m11 : matrix Z) (m12 : matrix Z) (m21 : matrix Z) (m22 : matrix Z), mdl m11 = mdl gm11 ∧ mdl m12 = mdl gm12 ∧ mdl m21 = mdl gm21 ∧ mdl m22 = mdl gm22 -> (let o6 : Z := columns b in let o7 : Z := Matrix.rows a in (0%Z ≤ o7 ∧ 0%Z ≤ o6) ∧ (∀(res : matrix Z), Matrix.rows res = o7 ∧ columns res = o6 ∧ (∀(i : Z) (j : Z), (0%Z ≤ i ∧ i < o7) ∧ 0%Z ≤ j ∧ j < o6 -> elts res i j = 0%Z) -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qr ∧ 0%Z + qr ≤ Matrix.rows m11) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qc ∧ 0%Z + qc ≤ columns m11) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qr ∧ 0%Z + qr ≤ Matrix.rows res) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qc ∧ 0%Z + qc ≤ columns res) ∧ (∀(res1 : matrix Z), Matrix.rows res1 = Matrix.rows res ∧ columns res1 = columns res -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < 0%Z + qr -> 0%Z ≤ j ∧ j < 0%Z + qc -> elts res1 i j = elts m11 (i + (0%Z - 0%Z)) (j + (0%Z - 0%Z))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < Matrix.rows res1 -> 0%Z ≤ j ∧ j < columns res1 -> ¬ ((0%Z ≤ i ∧ i < 0%Z + qr) ∧ 0%Z ≤ j ∧ j < 0%Z + qc) -> elts res1 i j = elts res i j) -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qr ∧ 0%Z + qr ≤ Matrix.rows m12) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qc ∧ 0%Z + qc ≤ columns m12) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qr ∧ 0%Z + qr ≤ Matrix.rows res1) ∧ 0%Z ≤ qc ∧ qc ≤ qc + qc ∧ qc + qc ≤ columns res1) ∧ (∀(res2 : matrix Z), Matrix.rows res2 = Matrix.rows res1 ∧ columns res2 = columns res1 -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < 0%Z + qr -> qc ≤ j ∧ j < qc + qc -> elts res2 i j = elts m12 (i + (0%Z - 0%Z)) (j + (0%Z - qc))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < Matrix.rows res2 -> 0%Z ≤ j ∧ j < columns res2 -> ¬ ((0%Z ≤ i ∧ i < 0%Z + qr) ∧ qc ≤ j ∧ j < qc + qc) -> elts res2 i j = elts res1 i j) -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qr ∧ 0%Z + qr ≤ Matrix.rows m21) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qc ∧ 0%Z + qc ≤ columns m21) ∧ (0%Z ≤ qr ∧ qr ≤ qr + qr ∧ qr + qr ≤ Matrix.rows res2) ∧ 0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qc ∧ 0%Z + qc ≤ columns res2) ∧ (∀(res3 : matrix Z), Matrix.rows res3 = Matrix.rows res2 ∧ columns res3 = columns res2 -> (∀(i : Z) (j : Z), qr ≤ i ∧ i < qr + qr -> 0%Z ≤ j ∧ j < 0%Z + qc -> elts res3 i j = elts m21 (i + (0%Z - qr)) (j + (0%Z - 0%Z))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < Matrix.rows res3 -> 0%Z ≤ j ∧ j < columns res3 -> ¬ ((qr ≤ i ∧ i < qr + qr) ∧ 0%Z ≤ j ∧ j < 0%Z + qc) -> elts res3 i j = elts res2 i j) -> ((0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qr ∧ 0%Z + qr ≤ Matrix.rows m22) ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ 0%Z + qc ∧ 0%Z + qc ≤ columns m22) ∧ (0%Z ≤ qr ∧ qr ≤ qr + qr ∧ qr + qr ≤ Matrix.rows res3) ∧ 0%Z ≤ qc ∧ qc ≤ qc + qc ∧ qc + qc ≤ columns res3) ∧ (∀(res4 : matrix Z), Matrix.rows res4 = Matrix.rows res3 ∧ columns res4 = columns res3 -> (∀(i : Z) (j : Z), qr ≤ i ∧ i < qr + qr -> qc ≤ j ∧ j < qc + qc -> elts res4 i j = elts m22 (i + (0%Z - qr)) (j + (0%Z - qc))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < Matrix.rows res4 -> 0%Z ≤ j ∧ j < columns res4 -> ¬ ((qr ≤ i ∧ i < qr + qr) ∧ qc ≤ j ∧ j < qc + qc) -> elts res4 i j = elts res3 i j) -> mdl res4 = mul (mdl a) (mdl b) ∧ MyMatrix.rows (mdl res4) = MyMatrix.rows (mdl a) ∧ cols (mdl res4) = cols (mdl b))))))))))))))))))))).
Admitted.
