theory naive_MatrixMultiplication_mult_naiveqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.int_Sum" "Why3STD.matrix_Matrix"
begin
consts mul_atom :: "int matrix \<Rightarrow> int matrix \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
axiomatization where mul_atom'def:   "mul_atom a b i j k = elts a i k * elts b k j"
  for a :: "int matrix"
  and b :: "int matrix"
  and i :: "int"
  and j :: "int"
  and k :: "int"
definition matrix_product :: "int matrix \<Rightarrow> int matrix \<Rightarrow> int matrix \<Rightarrow> _"
  where "matrix_product m a b \<longleftrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < rows m \<longrightarrow> (0 :: int) \<le> j \<and> j < columns m \<longrightarrow> elts m i j = sum (mul_atom a b i j) (0 :: int) (columns a))" for m a b
theorem mult_naive'vc:
  fixes a :: "int matrix"
  fixes b :: "int matrix"
  assumes fact0: "columns a = rows b"
  shows "let o1 :: int = columns b; o2 :: int = rows a in ((0 :: int) \<le> o2 \<and> (0 :: int) \<le> o1) \<and> (\<forall>(rs :: int matrix). rows rs = o2 \<and> columns rs = o1 \<and> (\<forall>(i :: int) (j :: int). ((0 :: int) \<le> i \<and> i < o2) \<and> (0 :: int) \<le> j \<and> j < o1 \<longrightarrow> elts rs i j = (0 :: int)) \<longrightarrow> (let o3 :: int = rows a - (1 :: int) in ((0 :: int) \<le> o3 + (1 :: int) \<longrightarrow> ((\<forall>(i0 :: int) (j0 :: int). ((0 :: int) \<le> i0 \<and> i0 < rows a) \<and> (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> elts rs i0 j0 = (0 :: int)) \<and> (\<forall>(i0 :: int) (j0 :: int). ((0 :: int) \<le> i0 \<and> i0 < (0 :: int)) \<and> (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> elts rs i0 j0 = sum (mul_atom a b i0 j0) (0 :: int) (columns a))) \<and> (\<forall>(rs1 :: int matrix). rows rs1 = rows rs \<and> columns rs1 = columns rs \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i \<le> o3) \<and> (\<forall>(i0 :: int) (j0 :: int). (i \<le> i0 \<and> i0 < rows a) \<and> (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> elts rs1 i0 j0 = (0 :: int)) \<and> (\<forall>(i0 :: int) (j0 :: int). ((0 :: int) \<le> i0 \<and> i0 < i) \<and> (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> elts rs1 i0 j0 = sum (mul_atom a b i0 j0) (0 :: int) (columns a)) \<longrightarrow> (let o4 :: int = rows b - (1 :: int) in ((0 :: int) \<le> o4 + (1 :: int) \<longrightarrow> (\<forall>(j0 :: int). (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> elts rs1 i j0 = sum (mul_atom a b i j0) (0 :: int) (0 :: int)) \<and> (\<forall>(rs2 :: int matrix). rows rs2 = rows rs1 \<and> columns rs2 = columns rs1 \<longrightarrow> (\<forall>(k :: int). ((0 :: int) \<le> k \<and> k \<le> o4) \<and> (\<forall>(i0 :: int) (j0 :: int). ((0 :: int) \<le> i0 \<and> i0 < rows a) \<and> (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> \<not>i0 = i \<longrightarrow> elts rs2 i0 j0 = elts rs1 i0 j0) \<and> (\<forall>(j0 :: int). (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> elts rs2 i j0 = sum (mul_atom a b i j0) (0 :: int) k) \<longrightarrow> (let o5 :: int = columns b - (1 :: int) in ((0 :: int) \<le> o5 + (1 :: int) \<longrightarrow> (\<forall>(j0 :: int). (0 :: int) \<le> j0 \<and> j0 < (0 :: int) \<longrightarrow> elts rs2 i j0 = sum (mul_atom a b i j0) (0 :: int) (k + (1 :: int))) \<and> (\<forall>(rs3 :: int matrix). rows rs3 = rows rs2 \<and> columns rs3 = columns rs2 \<longrightarrow> (\<forall>(j :: int). ((0 :: int) \<le> j \<and> j \<le> o5) \<and> (\<forall>(i0 :: int) (j0 :: int). ((0 :: int) \<le> i0 \<and> i0 < rows a) \<and> (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> \<not>i0 = i \<or> j \<le> j0 \<longrightarrow> elts rs3 i0 j0 = elts rs2 i0 j0) \<and> (\<forall>(j0 :: int). (0 :: int) \<le> j0 \<and> j0 < j \<longrightarrow> elts rs3 i j0 = sum (mul_atom a b i j0) (0 :: int) (k + (1 :: int))) \<longrightarrow> valid_index b k j \<and> valid_index a i k \<and> valid_index rs3 i j \<and> valid_index rs3 i j \<and> (\<forall>(rs4 :: int matrix). rows rs4 = rows rs3 \<and> columns rs4 = columns rs3 \<longrightarrow> elts rs4 = (elts rs3)(i := (elts rs3 i)(j := elts rs3 i j + elts a i k * elts b k j)) \<longrightarrow> (\<forall>(i0 :: int) (j0 :: int). ((0 :: int) \<le> i0 \<and> i0 < rows a) \<and> (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> \<not>i0 = i \<or> j + (1 :: int) \<le> j0 \<longrightarrow> elts rs4 i0 j0 = elts rs2 i0 j0) \<and> (\<forall>(j0 :: int). (0 :: int) \<le> j0 \<and> j0 < j + (1 :: int) \<longrightarrow> elts rs4 i j0 = sum (mul_atom a b i j0) (0 :: int) (k + (1 :: int))))) \<and> ((\<forall>(i0 :: int) (j0 :: int). ((0 :: int) \<le> i0 \<and> i0 < rows a) \<and> (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> \<not>i0 = i \<or> o5 + (1 :: int) \<le> j0 \<longrightarrow> elts rs3 i0 j0 = elts rs2 i0 j0) \<and> (\<forall>(j0 :: int). (0 :: int) \<le> j0 \<and> j0 < o5 + (1 :: int) \<longrightarrow> elts rs3 i j0 = sum (mul_atom a b i j0) (0 :: int) (k + (1 :: int))) \<longrightarrow> (\<forall>(i0 :: int) (j0 :: int). ((0 :: int) \<le> i0 \<and> i0 < rows a) \<and> (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> \<not>i0 = i \<longrightarrow> elts rs3 i0 j0 = elts rs1 i0 j0) \<and> (\<forall>(j0 :: int). (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> elts rs3 i j0 = sum (mul_atom a b i j0) (0 :: int) (k + (1 :: int)))))) \<and> (o5 + (1 :: int) < (0 :: int) \<longrightarrow> (\<forall>(i0 :: int) (j0 :: int). ((0 :: int) \<le> i0 \<and> i0 < rows a) \<and> (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> \<not>i0 = i \<longrightarrow> elts rs2 i0 j0 = elts rs1 i0 j0) \<and> (\<forall>(j0 :: int). (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> elts rs2 i j0 = sum (mul_atom a b i j0) (0 :: int) (k + (1 :: int)))))) \<and> ((\<forall>(i0 :: int) (j0 :: int). ((0 :: int) \<le> i0 \<and> i0 < rows a) \<and> (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> \<not>i0 = i \<longrightarrow> elts rs2 i0 j0 = elts rs1 i0 j0) \<and> (\<forall>(j0 :: int). (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> elts rs2 i j0 = sum (mul_atom a b i j0) (0 :: int) (o4 + (1 :: int))) \<longrightarrow> (\<forall>(i0 :: int) (j0 :: int). (i + (1 :: int) \<le> i0 \<and> i0 < rows a) \<and> (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> elts rs2 i0 j0 = (0 :: int)) \<and> (\<forall>(i0 :: int) (j0 :: int). ((0 :: int) \<le> i0 \<and> i0 < i + (1 :: int)) \<and> (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> elts rs2 i0 j0 = sum (mul_atom a b i0 j0) (0 :: int) (columns a))))) \<and> (o4 + (1 :: int) < (0 :: int) \<longrightarrow> (\<forall>(i0 :: int) (j0 :: int). (i + (1 :: int) \<le> i0 \<and> i0 < rows a) \<and> (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> elts rs1 i0 j0 = (0 :: int)) \<and> (\<forall>(i0 :: int) (j0 :: int). ((0 :: int) \<le> i0 \<and> i0 < i + (1 :: int)) \<and> (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> elts rs1 i0 j0 = sum (mul_atom a b i0 j0) (0 :: int) (columns a))))) \<and> ((\<forall>(i0 :: int) (j0 :: int). (o3 + (1 :: int) \<le> i0 \<and> i0 < rows a) \<and> (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> elts rs1 i0 j0 = (0 :: int)) \<and> (\<forall>(i0 :: int) (j0 :: int). ((0 :: int) \<le> i0 \<and> i0 < o3 + (1 :: int)) \<and> (0 :: int) \<le> j0 \<and> j0 < columns b \<longrightarrow> elts rs1 i0 j0 = sum (mul_atom a b i0 j0) (0 :: int) (columns a)) \<longrightarrow> (rows rs1 = rows a \<and> columns rs1 = columns b) \<and> matrix_product rs1 a b))) \<and> (o3 + (1 :: int) < (0 :: int) \<longrightarrow> (rows rs = rows a \<and> columns rs = columns b) \<and> matrix_product rs a b)))"
  sorry
end
