theory verifythis_2016_tree_traversal_Iterative_continuingqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.map_Const" "Why3STD.map_MapExt" "./verifythis_2016_tree_traversal_Memory" "./verifythis_2016_tree_traversal_TreeShape" "Why3STD.bintree_Tree" "Why3STD.bintree_Size"
begin
datatype  snap = snap'mk (pointers: "kind \<Rightarrow> loc \<Rightarrow> loc") (cursor: "loc") (parent: "loc") (marks: "loc \<Rightarrow> bool")
datatype  frame = frame'mk (memo0: "snap") (tree: "loc tree") (tleft: "loc tree") (pleft: "loc") (tright: "loc tree") (pright: "loc") (memo1: "snap") (memo2: "snap") (memo3: "snap") (memo4: "snap")
definition frame_memo :: "frame \<Rightarrow> int \<Rightarrow> snap"
  where "frame_memo f pc = (if pc \<le> (0 :: int) then memo0 f else if pc \<le> (1 :: int) then memo1 f else if pc \<le> (2 :: int) then memo2 f else if pc \<le> (3 :: int) then memo3 f else memo4 f)" for f pc
definition bloc_rel :: "(kind \<Rightarrow> loc \<Rightarrow> loc) \<Rightarrow> phase \<Rightarrow> snap \<Rightarrow> snap \<Rightarrow> _"
  where "bloc_rel mem0 ph s1 s2 \<longleftrightarrow> parent s2 = cursor s1 \<and> cursor s2 = pointers s2 Parent (parent s2) \<and> marks s2 (parent s2) = True \<and> (\<forall>(l :: loc). \<not>l = parent s2 \<longrightarrow> marks s2 l = marks s1 l) \<and> (if pointers s1 Left (cursor s1) = null \<and> null = pointers s1 Right (cursor s1) then pointers s2 = pointers s1 else rotated mem0 (pointers s2) (next_phase ph) (parent s2))" for mem0 ph s1 s2
definition rec_rel :: "loc tree \<Rightarrow> snap \<Rightarrow> snap \<Rightarrow> _"
  where "rec_rel t s1 s2 \<longleftrightarrow> unchanged (pointers s1) (pointers s2) \<and> cursor s2 = parent s1 \<and> parent s2 = cursor s1 \<and> was_marked t (marks s1) (marks s2)" for t s1 s2
datatype  stack = Bottom | Running "stack" "int" "frame" | Done
fun is_stack :: "loc tree \<Rightarrow> snap \<Rightarrow> snap \<Rightarrow> stack \<Rightarrow> loc tree option \<Rightarrow> _"
  where "is_stack t stop scur Bottom calls = (stop = scur \<and> calls = Some t)" for t stop scur calls
      | "is_stack t stop scur (Running s1 pc f) calls = (((0 :: int) \<le> pc \<and> pc \<le> (4 :: int)) \<and> (let m0 :: snap = memo0 f in is_stack t stop m0 s1 (Some (tree f)) \<and> \<not>cursor m0 = null \<and> is_tree (pointers m0) (tree f) (cursor m0) (parent m0) \<and> tree f = Node (tleft f) (cursor m0) (tright f) \<and> pleft f = pointers m0 Left (cursor m0) \<and> pright f = pointers m0 Right (cursor m0) \<and> ((1 :: int) \<le> pc \<longrightarrow> bloc_rel (pointers m0) GoLeft m0 (memo1 f) \<and> \<not>pleft f = null \<and> \<not>pright f = null) \<and> ((2 :: int) \<le> pc \<longrightarrow> rec_rel (tleft f) (memo1 f) (memo2 f)) \<and> ((3 :: int) \<le> pc \<longrightarrow> bloc_rel (pointers m0) GoRight (memo2 f) (memo3 f)) \<and> ((4 :: int) \<le> pc \<longrightarrow> rec_rel (tright f) (memo3 f) (memo4 f)) \<and> frame_memo f pc = scur \<and> (case calls of None \<Rightarrow> \<not>pc = (1 :: int) \<and> \<not>pc = (3 :: int) | Some u \<Rightarrow> (if pc = (1 :: int) then u = tleft f else pc = (3 :: int) \<and> u = tright f))))" for t stop scur s1 pc f calls
      | "is_stack t stop scur Done calls = (rec_rel t stop scur \<and> calls = None)" for t stop scur calls
fun stack_size :: "stack \<Rightarrow> int"
  where "stack_size Bottom = (1 :: int)"
      | "stack_size Done = (0 :: int)"
      | "stack_size (Running s pc f) = stack_size s + ((100 :: int) - pc) + (if pc = (0 :: int) then (100 :: int) * (bintree_Size.size (tleft f) + bintree_Size.size (tright f)) else if pc \<le> (2 :: int) then (100 :: int) * bintree_Size.size (tright f) else (0 :: int))" for s pc f
theorem continuing'vc:
  fixes t :: "loc tree"
  fixes stop :: "snap"
  fixes sprev :: "snap"
  fixes st :: "stack"
  fixes scur :: "snap"
  assumes fact0: "is_stack t stop sprev st None"
  assumes fact1: "case st of Bottom \<Rightarrow> False | Done \<Rightarrow> False | Running _ pc f \<Rightarrow> bloc_rel (pointers (memo0 f)) (if pc = (0 :: int) then GoLeft else if pc = (2 :: int) then GoRight else GoBack) sprev scur"
  shows "case st of Bottom \<Rightarrow> False | Done \<Rightarrow> False | Running s pc f \<Rightarrow> (let o1 :: loc = cursor (memo0 f); o2 :: loc tree = tright f; o3 :: loc tree = tleft f in is_tree (pointers (memo0 f)) (Node o3 o1 o2) o1 (parent (memo0 f)) \<and> (\<not>o1 \<in> footprint o3 \<and> \<not>o1 \<in> footprint o2 \<longrightarrow> (if pc = (0 :: int) then \<forall>(o4 :: bool). (if pleft f = null then o4 = (if pright f = null then True else False) else o4 = False) \<longrightarrow> (if o4 = True then let o5 :: snap = memo0 f; o6 :: loc tree = tree f in (is_stack t stop o5 s (Some o6) \<and> rec_rel o6 o5 scur) \<and> (\<forall>(st1 :: stack). is_stack t stop scur st1 None \<and> stack_size st1 < stack_size s \<longrightarrow> is_stack t stop scur st1 None \<and> stack_size st1 < stack_size st) else let o5 :: loc = pleft f; o6 :: loc tree = tleft f; o7 :: snap = memo0 f; o8 :: loc = cursor o7; o9 :: kind \<Rightarrow> loc \<Rightarrow> loc = pointers scur; o10 :: kind \<Rightarrow> loc \<Rightarrow> loc = pointers o7; o11 :: loc set = footprint o6 in (ext o11 o10 o9 \<and> footprint o6 \<subseteq> o11 \<and> is_tree o10 o6 o5 o8) \<and> (is_tree o9 o6 o5 o8 \<longrightarrow> (is_stack t stop scur (Running s (pc + (1 :: int)) (frame'mk o7 (tree f) o6 o5 (tright f) (pright f) scur (memo2 f) (memo3 f) (memo4 f))) (Some o6) \<and> is_tree (pointers scur) o6 (cursor scur) (parent scur) \<and> \<not>cursor scur = null) \<and> (\<forall>(st1 :: stack). is_stack t stop scur st1 None \<and> stack_size st1 \<le> stack_size (Running s (pc + (1 :: int)) (frame'mk o7 (tree f) o6 o5 (tright f) (pright f) scur (memo2 f) (memo3 f) (memo4 f))) + (100 :: int) * bintree_Size.size o6 \<longrightarrow> is_stack t stop scur st1 None \<and> stack_size st1 < stack_size st))) else if pc = (2 :: int) then let o4 :: loc = pright f; o5 :: loc tree = tright f; o6 :: snap = memo0 f; o7 :: loc = cursor o6; o8 :: kind \<Rightarrow> loc \<Rightarrow> loc = pointers scur; o9 :: kind \<Rightarrow> loc \<Rightarrow> loc = pointers o6; o10 :: loc set = footprint o5 in (ext o10 o9 o8 \<and> footprint o5 \<subseteq> o10 \<and> is_tree o9 o5 o4 o7) \<and> (is_tree o8 o5 o4 o7 \<longrightarrow> (is_stack t stop scur (Running s (pc + (1 :: int)) (frame'mk o6 (tree f) (tleft f) (pleft f) o5 o4 (memo1 f) (memo2 f) scur (memo4 f))) (Some o5) \<and> is_tree (pointers scur) o5 (cursor scur) (parent scur) \<and> \<not>cursor scur = null) \<and> (\<forall>(st1 :: stack). is_stack t stop scur st1 None \<and> stack_size st1 \<le> stack_size (Running s (pc + (1 :: int)) (frame'mk o6 (tree f) (tleft f) (pleft f) o5 o4 (memo1 f) (memo2 f) scur (memo4 f))) + (100 :: int) * bintree_Size.size o5 \<longrightarrow> is_stack t stop scur st1 None \<and> stack_size st1 < stack_size st)) else if pc = (4 :: int) then let o4 :: snap = memo0 f; o5 :: loc tree = tree f in (is_stack t stop o4 s (Some o5) \<and> rec_rel o5 o4 scur) \<and> (\<forall>(st1 :: stack). is_stack t stop scur st1 None \<and> stack_size st1 < stack_size s \<longrightarrow> is_stack t stop scur st1 None \<and> stack_size st1 < stack_size st) else is_stack t stop scur st None \<and> stack_size st < stack_size st)))"
  sorry
end
