theory verifythis_2016_tree_traversal_Iterative_markTreeqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.map_Const" "Why3STD.map_MapExt" "./verifythis_2016_tree_traversal_Memory" "./verifythis_2016_tree_traversal_TreeShape" "Why3STD.bintree_Tree" "Why3STD.bintree_Size"
begin
datatype  snap = snap'mk (pointers: "kind \<Rightarrow> loc \<Rightarrow> loc") (cursor: "loc") (parent: "loc") (marks: "loc \<Rightarrow> bool")
datatype  frame = frame'mk (memo0: "snap") (tree: "loc tree") (tleft: "loc tree") (pleft: "loc") (tright: "loc tree") (pright: "loc") (memo1: "snap") (memo2: "snap") (memo3: "snap") (memo4: "snap")
definition frame_memo :: "frame \<Rightarrow> int \<Rightarrow> snap"
  where "frame_memo f pc = (if pc \<le> (0 :: int) then memo0 f else if pc \<le> (1 :: int) then memo1 f else if pc \<le> (2 :: int) then memo2 f else if pc \<le> (3 :: int) then memo3 f else memo4 f)" for f pc
definition bloc_rel :: "(kind \<Rightarrow> loc \<Rightarrow> loc) \<Rightarrow> phase \<Rightarrow> snap \<Rightarrow> snap \<Rightarrow> _"
  where "bloc_rel mem0 ph s1 s2 \<longleftrightarrow> parent s2 = cursor s1 \<and> cursor s2 = pointers s2 Parent (parent s2) \<and> marks s2 (parent s2) = True \<and> (\<forall>(l :: loc). \<not>l = parent s2 \<longrightarrow> marks s2 l = marks s1 l) \<and> (if pointers s1 Left (cursor s1) = null \<and> null = pointers s1 Right (cursor s1) then pointers s2 = pointers s1 else rotated mem0 (pointers s2) (next_phase ph) (parent s2))" for mem0 ph s1 s2
definition rec_rel :: "loc tree \<Rightarrow> snap \<Rightarrow> snap \<Rightarrow> _"
  where "rec_rel t s1 s2 \<longleftrightarrow> unchanged (pointers s1) (pointers s2) \<and> cursor s2 = parent s1 \<and> parent s2 = cursor s1 \<and> was_marked t (marks s1) (marks s2)" for t s1 s2
datatype  stack = Bottom | Running "stack" "int" "frame" | Done
fun is_stack :: "loc tree \<Rightarrow> snap \<Rightarrow> snap \<Rightarrow> stack \<Rightarrow> loc tree option \<Rightarrow> _"
  where "is_stack t stop scur Bottom calls = (stop = scur \<and> calls = Some t)" for t stop scur calls
      | "is_stack t stop scur (Running s1 pc f) calls = (((0 :: int) \<le> pc \<and> pc \<le> (4 :: int)) \<and> (let m0 :: snap = memo0 f in is_stack t stop m0 s1 (Some (tree f)) \<and> \<not>cursor m0 = null \<and> is_tree (pointers m0) (tree f) (cursor m0) (parent m0) \<and> tree f = Node (tleft f) (cursor m0) (tright f) \<and> pleft f = pointers m0 Left (cursor m0) \<and> pright f = pointers m0 Right (cursor m0) \<and> ((1 :: int) \<le> pc \<longrightarrow> bloc_rel (pointers m0) GoLeft m0 (memo1 f) \<and> \<not>pleft f = null \<and> \<not>pright f = null) \<and> ((2 :: int) \<le> pc \<longrightarrow> rec_rel (tleft f) (memo1 f) (memo2 f)) \<and> ((3 :: int) \<le> pc \<longrightarrow> bloc_rel (pointers m0) GoRight (memo2 f) (memo3 f)) \<and> ((4 :: int) \<le> pc \<longrightarrow> rec_rel (tright f) (memo3 f) (memo4 f)) \<and> frame_memo f pc = scur \<and> (case calls of None \<Rightarrow> \<not>pc = (1 :: int) \<and> \<not>pc = (3 :: int) | Some u \<Rightarrow> (if pc = (1 :: int) then u = tleft f else pc = (3 :: int) \<and> u = tright f))))" for t stop scur s1 pc f calls
      | "is_stack t stop scur Done calls = (rec_rel t stop scur \<and> calls = None)" for t stop scur calls
fun stack_size :: "stack \<Rightarrow> int"
  where "stack_size Bottom = (1 :: int)"
      | "stack_size Done = (0 :: int)"
      | "stack_size (Running s pc f) = stack_size s + ((100 :: int) - pc) + (if pc = (0 :: int) then (100 :: int) * (bintree_Size.size (tleft f) + bintree_Size.size (tright f)) else if pc \<le> (2 :: int) then (100 :: int) * bintree_Size.size (tright f) else (0 :: int))" for s pc f
theorem markTree'vc:
  fixes memo :: "memory"
  fixes t :: "loc tree"
  fixes root :: "loc"
  assumes fact0: "is_tree (accessor memo) t root null"
  assumes fact1: "\<not>root = null"
  shows "let o1 :: loc = null in \<forall>(stop :: snap). pointers stop = accessor memo \<and> cursor stop = root \<and> parent stop = o1 \<and> marks stop = mark memo \<longrightarrow> (is_stack t stop stop Bottom (Some t) \<and> is_tree (pointers stop) t (cursor stop) (parent stop) \<and> \<not>cursor stop = null) \<and> (\<forall>(st :: stack). is_stack t stop stop st None \<and> stack_size st \<le> stack_size Bottom + (100 :: int) * bintree_Size.size t \<longrightarrow> (\<not>root = null \<and> pointers stop = accessor memo \<and> cursor stop = root \<and> parent stop = o1 \<and> marks stop = mark memo \<and> is_stack t stop stop st None) \<and> (\<forall>(entered :: bool) (st1 :: stack) (scur :: snap) (memo5 :: memory). (cursor scur = null \<longrightarrow> entered = True) \<and> pointers scur = accessor memo5 \<and> marks scur = mark memo5 \<and> is_stack t stop scur st1 None \<longrightarrow> (\<forall>(result :: bool). (if entered = True then result = (if cursor scur = null then True else False) else result = False) \<longrightarrow> result = True \<longleftrightarrow> cursor scur = null) \<and> (if \<not>cursor scur = null then \<not>cursor scur = null \<and> (\<forall>(memo6 :: memory). accessor memo6 = accessor memo5 \<longrightarrow> mark memo6 = (mark memo5)(cursor scur := True) \<longrightarrow> \<not>cursor scur = null \<and> (let o2 :: loc = accessor memo6 Left (cursor scur) in (o2 = null \<longrightarrow> \<not>cursor scur = null) \<and> (\<forall>(o3 :: bool). (if o2 = null then o3 = (if accessor memo6 Right (cursor scur) = null then True else False) else o3 = False) \<longrightarrow> (if o3 = True then \<not>cursor scur = null \<and> (\<forall>(o4 :: snap). pointers o4 = accessor memo6 \<and> cursor o4 = accessor memo6 Parent (cursor scur) \<and> parent o4 = cursor scur \<and> marks o4 = mark memo6 \<longrightarrow> (is_stack t stop scur st1 None \<and> (case st1 of Bottom \<Rightarrow> False | Done \<Rightarrow> False | Running _ pc f \<Rightarrow> bloc_rel (pointers (memo0 f)) (if pc = (0 :: int) then GoLeft else if pc = (2 :: int) then GoRight else GoBack) scur o4)) \<and> (\<forall>(st2 :: stack). is_stack t stop o4 st2 None \<and> stack_size st2 < stack_size st1 \<longrightarrow> ((0 :: int) \<le> stack_size st1 \<and> stack_size st2 < stack_size st1) \<and> (accessor memo6 Parent (cursor scur) = null \<longrightarrow> True) \<and> pointers o4 = accessor memo6 \<and> cursor o4 = accessor memo6 Parent (cursor scur) \<and> parent o4 = cursor scur \<and> marks o4 = mark memo6 \<and> is_stack t stop o4 st2 None)) else \<not>cursor scur = null \<and> \<not>cursor scur = null \<and> (let o4 :: kind = Left in \<not>cursor scur = null \<and> (\<forall>(memo7 :: memory). mark memo7 = mark memo6 \<longrightarrow> accessor memo7 = (accessor memo6)(o4 := (accessor memo6 o4)(cursor scur := accessor memo6 Right (cursor scur))) \<longrightarrow> \<not>cursor scur = null \<and> (let o5 :: kind = Right in \<not>cursor scur = null \<and> (\<forall>(memo8 :: memory). mark memo8 = mark memo7 \<longrightarrow> accessor memo8 = (accessor memo7)(o5 := (accessor memo7 o5)(cursor scur := accessor memo7 Parent (cursor scur))) \<longrightarrow> (let o6 :: kind = Parent in \<not>cursor scur = null \<and> (\<forall>(memo9 :: memory). mark memo9 = mark memo8 \<longrightarrow> accessor memo9 = (accessor memo8)(o6 := (accessor memo8 o6)(cursor scur := accessor memo6 Left (cursor scur))) \<longrightarrow> (\<forall>(o7 :: snap). pointers o7 = accessor memo9 \<and> cursor o7 = accessor memo6 Left (cursor scur) \<and> parent o7 = cursor scur \<and> marks o7 = mark memo9 \<longrightarrow> (is_stack t stop scur st1 None \<and> (case st1 of Bottom \<Rightarrow> False | Done \<Rightarrow> False | Running _ pc f \<Rightarrow> bloc_rel (pointers (memo0 f)) (if pc = (0 :: int) then GoLeft else if pc = (2 :: int) then GoRight else GoBack) scur o7)) \<and> (\<forall>(st2 :: stack). is_stack t stop o7 st2 None \<and> stack_size st2 < stack_size st1 \<longrightarrow> ((0 :: int) \<le> stack_size st1 \<and> stack_size st2 < stack_size st1) \<and> (accessor memo6 Left (cursor scur) = null \<longrightarrow> True) \<and> pointers o7 = accessor memo9 \<and> cursor o7 = accessor memo6 Left (cursor scur) \<and> parent o7 = cursor scur \<and> marks o7 = mark memo9 \<and> is_stack t stop o7 st2 None)))))))))))) else (case st1 of Done \<Rightarrow> True | _ \<Rightarrow> False) \<and> ((case st1 of Done \<Rightarrow> True | _ \<Rightarrow> False) \<longrightarrow> (let o2 :: loc = null; o3 :: kind \<Rightarrow> loc \<Rightarrow> loc = pointers stop in (ext (footprint t) o3 (accessor memo5) \<and> is_tree o3 t root o2) \<and> (is_tree (accessor memo5) t root o2 \<longrightarrow> is_tree (accessor memo5) t root null \<and> unchanged (accessor memo) (accessor memo5) \<and> was_marked t (mark memo) (mark memo5)))))))"
  sorry
end
