theory verifythis_2018_array_based_queuing_lock_1_Top_mainqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref"
begin
consts k :: "int"
axiomatization where k'def:   "(0 :: int) < k"
consts n :: "int"
axiomatization where n'def:   "(0 :: int) < n"
typedecl  bounded_int
consts bmodel :: "bounded_int \<Rightarrow> int"
axiomatization where bounded_int'invariant'0:   "(0 :: int) \<le> bmodel self"
  for self :: "bounded_int"
axiomatization where bounded_int'invariant'1:   "bmodel self < k * n"
  for self :: "bounded_int"
consts bzero :: "bounded_int"
axiomatization where bzero'def:   "bmodel bzero = (0 :: int)"
typedecl  bounded_int2
consts "value" :: "bounded_int2 \<Rightarrow> bounded_int"
consts model :: "bounded_int2 \<Rightarrow> int"
axiomatization where bounded_int2'invariant'0:   "(0 :: int) \<le> model self"
  for self :: "bounded_int2"
axiomatization where bounded_int2'invariant'1:   "model self < n"
  for self :: "bounded_int2"
axiomatization where bounded_int2'invariant'2:   "model self = bmodel (value self) cmod n"
  for self :: "bounded_int2"
definition bounded_int2'eq :: "bounded_int2 \<Rightarrow> bounded_int2 \<Rightarrow> _"
  where "bounded_int2'eq a b \<longleftrightarrow> value a = value b \<and> model a = model b" for a b
axiomatization where bounded_int2'inj:   "a = b"
 if "bounded_int2'eq a b"
  for a :: "bounded_int2"
  and b :: "bounded_int2"
typedecl  ticket
consts tvalue :: "ticket \<Rightarrow> int"
axiomatization where ticket'invariant'0:   "(0 :: int) \<le> tvalue self"
  for self :: "ticket"
axiomatization where ticket'invariant'1:   "tvalue self < n"
  for self :: "ticket"
definition ticket'eq :: "ticket \<Rightarrow> ticket \<Rightarrow> _"
  where "ticket'eq a b \<longleftrightarrow> tvalue a = tvalue b" for a b
axiomatization where ticket'inj:   "a = b"
 if "ticket'eq a b"
  for a :: "ticket"
  and b :: "ticket"
datatype  thread_state = AcqFetched "ticket" | Granted "ticket" | RelSet "ticket" | Released "ticket"
definition ticket1 :: "thread_state \<Rightarrow> int"
  where "ticket1 s = (case s of AcqFetched t \<Rightarrow> tvalue t | Granted t \<Rightarrow> tvalue t | RelSet t \<Rightarrow> tvalue t | Released t \<Rightarrow> tvalue t)" for s
definition released :: "thread_state \<Rightarrow> _"
  where "released s \<longleftrightarrow> (case s of Released _ \<Rightarrow> True | _ \<Rightarrow> False)" for s
datatype  event = Request "int" | Acquire "int"
typedecl  hidden
theorem main'vc:
  shows "let o1 :: int = n in (0 :: int) \<le> o1 \<and> (\<forall>(result :: bool list). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < o1 \<longrightarrow> result ! nat i = False) \<and> int (length result) = o1 \<longrightarrow> int (length result) = n)"
  and "\<forall>(pass :: bool list). int (length pass) = n \<longrightarrow> (\<forall>(o1 :: bounded_int2). model o1 = (0 :: int) \<longrightarrow> ((0 :: int) \<le> (0 :: int) \<and> (0 :: int) < n) \<and> (\<forall>(o2 :: ticket). tvalue o2 = (0 :: int) \<longrightarrow> (let o3 :: int = n in (0 :: int) \<le> o3 \<and> (\<forall>(state :: thread_state list). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < o3 \<longrightarrow> state ! nat i = Released o2) \<and> int (length state) = o3 \<longrightarrow> (let o4 :: int = n in (0 :: int) \<le> o4 \<and> (\<forall>(tmap :: int list). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < o4 \<longrightarrow> tmap ! nat i = (0 :: int)) \<and> int (length tmap) = o4 \<longrightarrow> (let o5 :: int = n - (1 :: int) in ((0 :: int) \<le> o5 + (1 :: int) \<longrightarrow> ((\<forall>(j :: int). (0 :: int) \<le> j \<and> j < (0 :: int) \<longrightarrow> (case state ! nat j of Released t \<Rightarrow> tvalue t = j | _ \<Rightarrow> False)) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < (0 :: int) \<longrightarrow> tmap ! nat j = j)) \<and> (\<forall>(tmap1 :: int list) (state1 :: thread_state list). length tmap1 = length tmap \<longrightarrow> length state1 = length state \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i \<le> o5) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i \<longrightarrow> (case state1 ! nat j of Released t \<Rightarrow> tvalue t = j | _ \<Rightarrow> False)) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i \<longrightarrow> tmap1 ! nat j = j) \<longrightarrow> ((0 :: int) \<le> i \<and> i < n) \<and> (\<forall>(o6 :: ticket). tvalue o6 = i \<longrightarrow> (let o7 :: thread_state = Released o6 in ((0 :: int) \<le> i \<and> i < int (length state1)) \<and> (length (state1[nat i := o7]) = length state1 \<longrightarrow> nth (state1[nat i := o7]) o nat = (nth state1 o nat)(i := o7) \<longrightarrow> ((0 :: int) \<le> i \<and> i < int (length tmap1)) \<and> (length (tmap1[nat i := i]) = length tmap1 \<longrightarrow> nth (tmap1[nat i := i]) o nat = (nth tmap1 o nat)(i := i) \<longrightarrow> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i + (1 :: int) \<longrightarrow> (case state1[nat i := o7] ! nat j of Released t \<Rightarrow> tvalue t = j | _ \<Rightarrow> False)) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i + (1 :: int) \<longrightarrow> tmap1[nat i := i] ! nat j = j)))))) \<and> ((\<forall>(j :: int). (0 :: int) \<le> j \<and> j < o5 + (1 :: int) \<longrightarrow> (case state1 ! nat j of Released t \<Rightarrow> tvalue t = j | _ \<Rightarrow> False)) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < o5 + (1 :: int) \<longrightarrow> tmap1 ! nat j = j) \<longrightarrow> (\<forall>(o6 :: bounded_int2). model o6 = (0 :: int) \<longrightarrow> (\<forall>(o7 :: ticket). tvalue o7 = model o6 \<longrightarrow> (let o8 :: int = n - (1 :: int) in ((1 :: int) \<le> o8 + (1 :: int) \<longrightarrow> (\<forall>(j :: int). (1 :: int) \<le> j \<and> j < (1 :: int) \<longrightarrow> \<not>pass ! nat j = True) \<and> (\<forall>(pass1 :: bool list). length pass1 = length pass \<longrightarrow> (\<forall>(i :: int). ((1 :: int) \<le> i \<and> i \<le> o8) \<and> (\<forall>(j :: int). (1 :: int) \<le> j \<and> j < i \<longrightarrow> \<not>pass1 ! nat j = True) \<longrightarrow> (let o9 :: bool = False in ((0 :: int) \<le> i \<and> i < int (length pass1)) \<and> (length (pass1[nat i := o9]) = length pass1 \<longrightarrow> nth (pass1[nat i := o9]) o nat = (nth pass1 o nat)(i := o9) \<longrightarrow> (\<forall>(j :: int). (1 :: int) \<le> j \<and> j < i + (1 :: int) \<longrightarrow> \<not>pass1[nat i := o9] ! nat j = True)))) \<and> ((\<forall>(j :: int). (1 :: int) \<le> j \<and> j < o8 + (1 :: int) \<longrightarrow> \<not>pass1 ! nat j = True) \<longrightarrow> (let o9 :: bool = True in ((0 :: int) \<le> (0 :: int) \<and> (0 :: int) < int (length pass1)) \<and> (length (pass1[nat (0 :: int) := o9]) = length pass1 \<longrightarrow> nth (pass1[nat (0 :: int) := o9]) o nat = (nth pass1 o nat)(0 :: int := o9) \<longrightarrow> ((\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1[nat (0 :: int) := o9] ! nat i = True \<longrightarrow> i = tvalue o7) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue o7 \<and> pass1[nat (0 :: int) := o9] ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue o7 \<and> \<not>pass1[nat (0 :: int) := o9] ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1 ! nat i \<and> tmap1 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1 ! nat (tmap1 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1 ! nat (ticket1 (state1 ! nat i)) = i) \<and> (model o1 < tvalue o7 \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model o1 \<or> tvalue o7 \<le> i \<and> i < n \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). model o1 \<le> i \<and> i < tvalue o7 \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (tvalue o7 < model o1 \<longrightarrow> (\<forall>(i :: int). tvalue o7 \<le> i \<and> i < model o1 \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue o7 \<or> model o1 \<le> i \<and> i < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (model o1 = tvalue o7 \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)) \<longleftrightarrow> released (state1 ! nat (tmap1 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1 ! nat j of Granted x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))) \<and> (\<forall>(current :: ticket) (tmap2 :: int list) (state2 :: thread_state list) (next :: bounded_int2) (pass2 :: bool list). length tmap2 = length tmap1 \<longrightarrow> length state2 = length state1 \<longrightarrow> length pass2 = length (pass1[nat (0 :: int) := o9]) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass2 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state2 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass2 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass2 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap2 ! nat i \<and> tmap2 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state2 ! nat (tmap2 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap2 ! nat (ticket1 (state2 ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state2 ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state2 ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)) \<longleftrightarrow> released (state2 ! nat (tmap2 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state2 ! nat j of Granted x \<Rightarrow> (case state2 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state2 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True)) \<longrightarrow> (\<forall>(id1 :: int). (0 :: int) \<le> id1 \<and> id1 < n \<longrightarrow> ((0 :: int) \<le> id1 \<and> id1 < int (length state2)) \<and> (case state2 ! nat id1 of AcqFetched ticket2 \<Rightarrow> (let o10 :: int = tvalue ticket2 in ((0 :: int) \<le> o10 \<and> o10 < int (length pass2)) \<and> (if pass2 ! nat o10 = True then let o11 :: thread_state = Granted ticket2 in ((0 :: int) \<le> id1 \<and> id1 < int (length state2)) \<and> (length (state2[nat id1 := o11]) = length state2 \<longrightarrow> nth (state2[nat id1 := o11]) o nat = (nth state2 o nat)(id1 := o11) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass2 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state2[nat id1 := o11] ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass2 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass2 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap2 ! nat i \<and> tmap2 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state2[nat id1 := o11] ! nat (tmap2 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap2 ! nat (ticket1 (state2[nat id1 := o11] ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state2[nat id1 := o11] ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state2[nat id1 := o11] ! nat (tmap2 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state2[nat id1 := o11] ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state2[nat id1 := o11] ! nat (tmap2 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state2[nat id1 := o11] ! nat (tmap2 ! nat i)) \<longleftrightarrow> released (state2[nat id1 := o11] ! nat (tmap2 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state2[nat id1 := o11] ! nat j of Granted x \<Rightarrow> (case state2[nat id1 := o11] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state2[nat id1 := o11] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))) else (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass2 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state2 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass2 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass2 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap2 ! nat i \<and> tmap2 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state2 ! nat (tmap2 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap2 ! nat (ticket1 (state2 ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state2 ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state2 ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)) \<longleftrightarrow> released (state2 ! nat (tmap2 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state2 ! nat j of Granted x \<Rightarrow> (case state2 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state2 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True)))) | Granted ticket2 \<Rightarrow> (\<forall>(o10 :: bool). if o10 = True then let o11 :: thread_state = RelSet ticket2 in ((0 :: int) \<le> id1 \<and> id1 < int (length state2)) \<and> (length (state2[nat id1 := o11]) = length state2 \<longrightarrow> nth (state2[nat id1 := o11]) o nat = (nth state2 o nat)(id1 := o11) \<longrightarrow> (let o12 :: bool = False; o13 :: int = tvalue ticket2 in ((0 :: int) \<le> o13 \<and> o13 < int (length pass2)) \<and> (length (pass2[nat o13 := o12]) = length pass2 \<longrightarrow> nth (pass2[nat o13 := o12]) o nat = (nth pass2 o nat)(o13 := o12) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass2[nat o13 := o12] ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state2[nat id1 := o11] ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass2[nat o13 := o12] ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass2[nat o13 := o12] ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap2 ! nat i \<and> tmap2 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state2[nat id1 := o11] ! nat (tmap2 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap2 ! nat (ticket1 (state2[nat id1 := o11] ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state2[nat id1 := o11] ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state2[nat id1 := o11] ! nat (tmap2 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state2[nat id1 := o11] ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state2[nat id1 := o11] ! nat (tmap2 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state2[nat id1 := o11] ! nat (tmap2 ! nat i)) \<longleftrightarrow> released (state2[nat id1 := o11] ! nat (tmap2 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state2[nat id1 := o11] ! nat j of Granted x \<Rightarrow> (case state2[nat id1 := o11] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state2[nat id1 := o11] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))))) else (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass2 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state2 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass2 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass2 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap2 ! nat i \<and> tmap2 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state2 ! nat (tmap2 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap2 ! nat (ticket1 (state2 ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state2 ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state2 ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)) \<longleftrightarrow> released (state2 ! nat (tmap2 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state2 ! nat j of Granted x \<Rightarrow> (case state2 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state2 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))) | RelSet ticket2 \<Rightarrow> (let o10 :: thread_state = Released ticket2 in ((0 :: int) \<le> id1 \<and> id1 < int (length state2)) \<and> (length (state2[nat id1 := o10]) = length state2 \<longrightarrow> nth (state2[nat id1 := o10]) o nat = (nth state2 o nat)(id1 := o10) \<longrightarrow> (let o11 :: bool = True in \<forall>(o12 :: ticket). (let v :: int = tvalue ticket2 + (1 :: int) in tvalue o12 = (if v = n then 0 :: int else v)) \<longrightarrow> (let o13 :: int = tvalue o12 in ((0 :: int) \<le> o13 \<and> o13 < int (length pass2)) \<and> (length (pass2[nat o13 := o11]) = length pass2 \<longrightarrow> nth (pass2[nat o13 := o11]) o nat = (nth pass2 o nat)(o13 := o11) \<longrightarrow> (\<forall>(o14 :: ticket). (let v :: int = tvalue current + (1 :: int) in tvalue o14 = (if v = n then 0 :: int else v)) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass2[nat o13 := o11] ! nat i = True \<longrightarrow> i = tvalue o14) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state2[nat id1 := o10] ! nat i of Granted t \<Rightarrow> tvalue t = tvalue o14 \<and> pass2[nat o13 := o11] ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue o14 \<and> \<not>pass2[nat o13 := o11] ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap2 ! nat i \<and> tmap2 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state2[nat id1 := o10] ! nat (tmap2 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap2 ! nat (ticket1 (state2[nat id1 := o10] ! nat i)) = i) \<and> (model next < tvalue o14 \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue o14 \<le> i \<and> i < n \<longrightarrow> \<not>released (state2[nat id1 := o10] ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue o14 \<longrightarrow> released (state2[nat id1 := o10] ! nat (tmap2 ! nat i)))) \<and> (tvalue o14 < model next \<longrightarrow> (\<forall>(i :: int). tvalue o14 \<le> i \<and> i < model next \<longrightarrow> \<not>released (state2[nat id1 := o10] ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue o14 \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state2[nat id1 := o10] ! nat (tmap2 ! nat i)))) \<and> (model next = tvalue o14 \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state2[nat id1 := o10] ! nat (tmap2 ! nat i)) \<longleftrightarrow> released (state2[nat id1 := o10] ! nat (tmap2 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state2[nat id1 := o10] ! nat j of Granted x \<Rightarrow> (case state2[nat id1 := o10] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state2[nat id1 := o10] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True)))))))) | Released told \<Rightarrow> (\<forall>(o10 :: bool). if o10 = True then \<forall>(ticket2 :: ticket). tvalue ticket2 = model next \<longrightarrow> (let o11 :: int = tvalue ticket2 in ((0 :: int) \<le> o11 \<and> o11 < int (length tmap2)) \<and> (let id2 :: int = tmap2 ! nat o11 in ((0 :: int) \<le> id2 \<and> id2 < int (length state2)) \<and> (case state2 ! nat id2 of Released _ \<Rightarrow> (let o12 :: thread_state = Released told in ((0 :: int) \<le> id2 \<and> id2 < int (length state2)) \<and> (length (state2[nat id2 := o12]) = length state2 \<longrightarrow> nth (state2[nat id2 := o12]) o nat = (nth state2 o nat)(id2 := o12) \<longrightarrow> (let o13 :: int = tvalue ticket2 in ((0 :: int) \<le> o13 \<and> o13 < int (length tmap2)) \<and> (length (tmap2[nat o13 := id1]) = length tmap2 \<longrightarrow> nth (tmap2[nat o13 := id1]) o nat = (nth tmap2 o nat)(o13 := id1) \<longrightarrow> (let o14 :: int = tvalue told in ((0 :: int) \<le> o14 \<and> o14 < int (length (tmap2[nat o13 := id1]))) \<and> (length (tmap2[nat o14 := id2, nat o13 := id1]) = length (tmap2[nat o13 := id1]) \<longrightarrow> nth (tmap2[nat o14 := id2, nat o13 := id1]) o nat = (nth (tmap2[nat o13 := id1]) o nat)(o14 := id2) \<longrightarrow> (let o15 :: thread_state = AcqFetched ticket2 in ((0 :: int) \<le> id1 \<and> id1 < int (length (state2[nat id2 := o12]))) \<and> (length (state2[nat id1 := o15, nat id2 := o12]) = length (state2[nat id2 := o12]) \<longrightarrow> nth (state2[nat id1 := o15, nat id2 := o12]) o nat = (nth (state2[nat id2 := o12]) o nat)(id1 := o15) \<longrightarrow> (\<forall>(o16 :: bounded_int2). (let v :: int = model next + (1 :: int) in model o16 = (if v = n then 0 :: int else v)) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass2 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state2[nat id1 := o15, nat id2 := o12] ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass2 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass2 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap2[nat o14 := id2, nat o13 := id1] ! nat i \<and> tmap2[nat o14 := id2, nat o13 := id1] ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state2[nat id1 := o15, nat id2 := o12] ! nat (tmap2[nat o14 := id2, nat o13 := id1] ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap2[nat o14 := id2, nat o13 := id1] ! nat (ticket1 (state2[nat id1 := o15, nat id2 := o12] ! nat i)) = i) \<and> (model o16 < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model o16 \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state2[nat id1 := o15, nat id2 := o12] ! nat (tmap2[nat o14 := id2, nat o13 := id1] ! nat i))) \<and> (\<forall>(i :: int). model o16 \<le> i \<and> i < tvalue current \<longrightarrow> released (state2[nat id1 := o15, nat id2 := o12] ! nat (tmap2[nat o14 := id2, nat o13 := id1] ! nat i)))) \<and> (tvalue current < model o16 \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model o16 \<longrightarrow> \<not>released (state2[nat id1 := o15, nat id2 := o12] ! nat (tmap2[nat o14 := id2, nat o13 := id1] ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model o16 \<le> i \<and> i < n \<longrightarrow> released (state2[nat id1 := o15, nat id2 := o12] ! nat (tmap2[nat o14 := id2, nat o13 := id1] ! nat i)))) \<and> (model o16 = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state2[nat id1 := o15, nat id2 := o12] ! nat (tmap2[nat o14 := id2, nat o13 := id1] ! nat i)) \<longleftrightarrow> released (state2[nat id1 := o15, nat id2 := o12] ! nat (tmap2[nat o14 := id2, nat o13 := id1] ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state2[nat id1 := o15, nat id2 := o12] ! nat j of Granted x \<Rightarrow> (case state2[nat id1 := o15, nat id2 := o12] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state2[nat id1 := o15, nat id2 := o12] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))))))))))) | _ \<Rightarrow> False))) else (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass2 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state2 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass2 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass2 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap2 ! nat i \<and> tmap2 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state2 ! nat (tmap2 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap2 ! nat (ticket1 (state2 ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state2 ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state2 ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)) \<longleftrightarrow> released (state2 ! nat (tmap2 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state2 ! nat j of Granted x \<Rightarrow> (case state2 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state2 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))))))))))) \<and> (o8 + (1 :: int) < (1 :: int) \<longrightarrow> (let o9 :: bool = True in ((0 :: int) \<le> (0 :: int) \<and> (0 :: int) < int (length pass)) \<and> (length (pass[nat (0 :: int) := o9]) = length pass \<longrightarrow> nth (pass[nat (0 :: int) := o9]) o nat = (nth pass o nat)(0 :: int := o9) \<longrightarrow> ((\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass[nat (0 :: int) := o9] ! nat i = True \<longrightarrow> i = tvalue o7) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue o7 \<and> pass[nat (0 :: int) := o9] ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue o7 \<and> \<not>pass[nat (0 :: int) := o9] ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1 ! nat i \<and> tmap1 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1 ! nat (tmap1 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1 ! nat (ticket1 (state1 ! nat i)) = i) \<and> (model o1 < tvalue o7 \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model o1 \<or> tvalue o7 \<le> i \<and> i < n \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). model o1 \<le> i \<and> i < tvalue o7 \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (tvalue o7 < model o1 \<longrightarrow> (\<forall>(i :: int). tvalue o7 \<le> i \<and> i < model o1 \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue o7 \<or> model o1 \<le> i \<and> i < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (model o1 = tvalue o7 \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)) \<longleftrightarrow> released (state1 ! nat (tmap1 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1 ! nat j of Granted x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))) \<and> (\<forall>(current :: ticket) (tmap2 :: int list) (state2 :: thread_state list) (next :: bounded_int2) (pass1 :: bool list). length tmap2 = length tmap1 \<longrightarrow> length state2 = length state1 \<longrightarrow> length pass1 = length (pass[nat (0 :: int) := o9]) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state2 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass1 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass1 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap2 ! nat i \<and> tmap2 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state2 ! nat (tmap2 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap2 ! nat (ticket1 (state2 ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state2 ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state2 ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)) \<longleftrightarrow> released (state2 ! nat (tmap2 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state2 ! nat j of Granted x \<Rightarrow> (case state2 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state2 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True)) \<longrightarrow> (\<forall>(id1 :: int). (0 :: int) \<le> id1 \<and> id1 < n \<longrightarrow> ((0 :: int) \<le> id1 \<and> id1 < int (length state2)) \<and> (case state2 ! nat id1 of AcqFetched ticket2 \<Rightarrow> (let o10 :: int = tvalue ticket2 in ((0 :: int) \<le> o10 \<and> o10 < int (length pass1)) \<and> (if pass1 ! nat o10 = True then let o11 :: thread_state = Granted ticket2 in ((0 :: int) \<le> id1 \<and> id1 < int (length state2)) \<and> (length (state2[nat id1 := o11]) = length state2 \<longrightarrow> nth (state2[nat id1 := o11]) o nat = (nth state2 o nat)(id1 := o11) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state2[nat id1 := o11] ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass1 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass1 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap2 ! nat i \<and> tmap2 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state2[nat id1 := o11] ! nat (tmap2 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap2 ! nat (ticket1 (state2[nat id1 := o11] ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state2[nat id1 := o11] ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state2[nat id1 := o11] ! nat (tmap2 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state2[nat id1 := o11] ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state2[nat id1 := o11] ! nat (tmap2 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state2[nat id1 := o11] ! nat (tmap2 ! nat i)) \<longleftrightarrow> released (state2[nat id1 := o11] ! nat (tmap2 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state2[nat id1 := o11] ! nat j of Granted x \<Rightarrow> (case state2[nat id1 := o11] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state2[nat id1 := o11] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))) else (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state2 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass1 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass1 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap2 ! nat i \<and> tmap2 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state2 ! nat (tmap2 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap2 ! nat (ticket1 (state2 ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state2 ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state2 ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)) \<longleftrightarrow> released (state2 ! nat (tmap2 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state2 ! nat j of Granted x \<Rightarrow> (case state2 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state2 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True)))) | Granted ticket2 \<Rightarrow> (\<forall>(o10 :: bool). if o10 = True then let o11 :: thread_state = RelSet ticket2 in ((0 :: int) \<le> id1 \<and> id1 < int (length state2)) \<and> (length (state2[nat id1 := o11]) = length state2 \<longrightarrow> nth (state2[nat id1 := o11]) o nat = (nth state2 o nat)(id1 := o11) \<longrightarrow> (let o12 :: bool = False; o13 :: int = tvalue ticket2 in ((0 :: int) \<le> o13 \<and> o13 < int (length pass1)) \<and> (length (pass1[nat o13 := o12]) = length pass1 \<longrightarrow> nth (pass1[nat o13 := o12]) o nat = (nth pass1 o nat)(o13 := o12) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1[nat o13 := o12] ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state2[nat id1 := o11] ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass1[nat o13 := o12] ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass1[nat o13 := o12] ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap2 ! nat i \<and> tmap2 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state2[nat id1 := o11] ! nat (tmap2 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap2 ! nat (ticket1 (state2[nat id1 := o11] ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state2[nat id1 := o11] ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state2[nat id1 := o11] ! nat (tmap2 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state2[nat id1 := o11] ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state2[nat id1 := o11] ! nat (tmap2 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state2[nat id1 := o11] ! nat (tmap2 ! nat i)) \<longleftrightarrow> released (state2[nat id1 := o11] ! nat (tmap2 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state2[nat id1 := o11] ! nat j of Granted x \<Rightarrow> (case state2[nat id1 := o11] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state2[nat id1 := o11] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))))) else (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state2 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass1 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass1 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap2 ! nat i \<and> tmap2 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state2 ! nat (tmap2 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap2 ! nat (ticket1 (state2 ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state2 ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state2 ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)) \<longleftrightarrow> released (state2 ! nat (tmap2 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state2 ! nat j of Granted x \<Rightarrow> (case state2 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state2 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))) | RelSet ticket2 \<Rightarrow> (let o10 :: thread_state = Released ticket2 in ((0 :: int) \<le> id1 \<and> id1 < int (length state2)) \<and> (length (state2[nat id1 := o10]) = length state2 \<longrightarrow> nth (state2[nat id1 := o10]) o nat = (nth state2 o nat)(id1 := o10) \<longrightarrow> (let o11 :: bool = True in \<forall>(o12 :: ticket). (let v :: int = tvalue ticket2 + (1 :: int) in tvalue o12 = (if v = n then 0 :: int else v)) \<longrightarrow> (let o13 :: int = tvalue o12 in ((0 :: int) \<le> o13 \<and> o13 < int (length pass1)) \<and> (length (pass1[nat o13 := o11]) = length pass1 \<longrightarrow> nth (pass1[nat o13 := o11]) o nat = (nth pass1 o nat)(o13 := o11) \<longrightarrow> (\<forall>(o14 :: ticket). (let v :: int = tvalue current + (1 :: int) in tvalue o14 = (if v = n then 0 :: int else v)) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1[nat o13 := o11] ! nat i = True \<longrightarrow> i = tvalue o14) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state2[nat id1 := o10] ! nat i of Granted t \<Rightarrow> tvalue t = tvalue o14 \<and> pass1[nat o13 := o11] ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue o14 \<and> \<not>pass1[nat o13 := o11] ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap2 ! nat i \<and> tmap2 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state2[nat id1 := o10] ! nat (tmap2 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap2 ! nat (ticket1 (state2[nat id1 := o10] ! nat i)) = i) \<and> (model next < tvalue o14 \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue o14 \<le> i \<and> i < n \<longrightarrow> \<not>released (state2[nat id1 := o10] ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue o14 \<longrightarrow> released (state2[nat id1 := o10] ! nat (tmap2 ! nat i)))) \<and> (tvalue o14 < model next \<longrightarrow> (\<forall>(i :: int). tvalue o14 \<le> i \<and> i < model next \<longrightarrow> \<not>released (state2[nat id1 := o10] ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue o14 \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state2[nat id1 := o10] ! nat (tmap2 ! nat i)))) \<and> (model next = tvalue o14 \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state2[nat id1 := o10] ! nat (tmap2 ! nat i)) \<longleftrightarrow> released (state2[nat id1 := o10] ! nat (tmap2 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state2[nat id1 := o10] ! nat j of Granted x \<Rightarrow> (case state2[nat id1 := o10] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state2[nat id1 := o10] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True)))))))) | Released told \<Rightarrow> (\<forall>(o10 :: bool). if o10 = True then \<forall>(ticket2 :: ticket). tvalue ticket2 = model next \<longrightarrow> (let o11 :: int = tvalue ticket2 in ((0 :: int) \<le> o11 \<and> o11 < int (length tmap2)) \<and> (let id2 :: int = tmap2 ! nat o11 in ((0 :: int) \<le> id2 \<and> id2 < int (length state2)) \<and> (case state2 ! nat id2 of Released _ \<Rightarrow> (let o12 :: thread_state = Released told in ((0 :: int) \<le> id2 \<and> id2 < int (length state2)) \<and> (length (state2[nat id2 := o12]) = length state2 \<longrightarrow> nth (state2[nat id2 := o12]) o nat = (nth state2 o nat)(id2 := o12) \<longrightarrow> (let o13 :: int = tvalue ticket2 in ((0 :: int) \<le> o13 \<and> o13 < int (length tmap2)) \<and> (length (tmap2[nat o13 := id1]) = length tmap2 \<longrightarrow> nth (tmap2[nat o13 := id1]) o nat = (nth tmap2 o nat)(o13 := id1) \<longrightarrow> (let o14 :: int = tvalue told in ((0 :: int) \<le> o14 \<and> o14 < int (length (tmap2[nat o13 := id1]))) \<and> (length (tmap2[nat o14 := id2, nat o13 := id1]) = length (tmap2[nat o13 := id1]) \<longrightarrow> nth (tmap2[nat o14 := id2, nat o13 := id1]) o nat = (nth (tmap2[nat o13 := id1]) o nat)(o14 := id2) \<longrightarrow> (let o15 :: thread_state = AcqFetched ticket2 in ((0 :: int) \<le> id1 \<and> id1 < int (length (state2[nat id2 := o12]))) \<and> (length (state2[nat id1 := o15, nat id2 := o12]) = length (state2[nat id2 := o12]) \<longrightarrow> nth (state2[nat id1 := o15, nat id2 := o12]) o nat = (nth (state2[nat id2 := o12]) o nat)(id1 := o15) \<longrightarrow> (\<forall>(o16 :: bounded_int2). (let v :: int = model next + (1 :: int) in model o16 = (if v = n then 0 :: int else v)) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state2[nat id1 := o15, nat id2 := o12] ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass1 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass1 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap2[nat o14 := id2, nat o13 := id1] ! nat i \<and> tmap2[nat o14 := id2, nat o13 := id1] ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state2[nat id1 := o15, nat id2 := o12] ! nat (tmap2[nat o14 := id2, nat o13 := id1] ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap2[nat o14 := id2, nat o13 := id1] ! nat (ticket1 (state2[nat id1 := o15, nat id2 := o12] ! nat i)) = i) \<and> (model o16 < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model o16 \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state2[nat id1 := o15, nat id2 := o12] ! nat (tmap2[nat o14 := id2, nat o13 := id1] ! nat i))) \<and> (\<forall>(i :: int). model o16 \<le> i \<and> i < tvalue current \<longrightarrow> released (state2[nat id1 := o15, nat id2 := o12] ! nat (tmap2[nat o14 := id2, nat o13 := id1] ! nat i)))) \<and> (tvalue current < model o16 \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model o16 \<longrightarrow> \<not>released (state2[nat id1 := o15, nat id2 := o12] ! nat (tmap2[nat o14 := id2, nat o13 := id1] ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model o16 \<le> i \<and> i < n \<longrightarrow> released (state2[nat id1 := o15, nat id2 := o12] ! nat (tmap2[nat o14 := id2, nat o13 := id1] ! nat i)))) \<and> (model o16 = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state2[nat id1 := o15, nat id2 := o12] ! nat (tmap2[nat o14 := id2, nat o13 := id1] ! nat i)) \<longleftrightarrow> released (state2[nat id1 := o15, nat id2 := o12] ! nat (tmap2[nat o14 := id2, nat o13 := id1] ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state2[nat id1 := o15, nat id2 := o12] ! nat j of Granted x \<Rightarrow> (case state2[nat id1 := o15, nat id2 := o12] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state2[nat id1 := o15, nat id2 := o12] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))))))))))) | _ \<Rightarrow> False))) else (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state2 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass1 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass1 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap2 ! nat i \<and> tmap2 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state2 ! nat (tmap2 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap2 ! nat (ticket1 (state2 ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state2 ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state2 ! nat (tmap2 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state2 ! nat (tmap2 ! nat i)) \<longleftrightarrow> released (state2 ! nat (tmap2 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state2 ! nat j of Granted x \<Rightarrow> (case state2 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state2 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))))))))))))))) \<and> (o5 + (1 :: int) < (0 :: int) \<longrightarrow> (\<forall>(o6 :: bounded_int2). model o6 = (0 :: int) \<longrightarrow> (\<forall>(o7 :: ticket). tvalue o7 = model o6 \<longrightarrow> (let o8 :: int = n - (1 :: int) in ((1 :: int) \<le> o8 + (1 :: int) \<longrightarrow> (\<forall>(j :: int). (1 :: int) \<le> j \<and> j < (1 :: int) \<longrightarrow> \<not>pass ! nat j = True) \<and> (\<forall>(pass1 :: bool list). length pass1 = length pass \<longrightarrow> (\<forall>(i :: int). ((1 :: int) \<le> i \<and> i \<le> o8) \<and> (\<forall>(j :: int). (1 :: int) \<le> j \<and> j < i \<longrightarrow> \<not>pass1 ! nat j = True) \<longrightarrow> (let o9 :: bool = False in ((0 :: int) \<le> i \<and> i < int (length pass1)) \<and> (length (pass1[nat i := o9]) = length pass1 \<longrightarrow> nth (pass1[nat i := o9]) o nat = (nth pass1 o nat)(i := o9) \<longrightarrow> (\<forall>(j :: int). (1 :: int) \<le> j \<and> j < i + (1 :: int) \<longrightarrow> \<not>pass1[nat i := o9] ! nat j = True)))) \<and> ((\<forall>(j :: int). (1 :: int) \<le> j \<and> j < o8 + (1 :: int) \<longrightarrow> \<not>pass1 ! nat j = True) \<longrightarrow> (let o9 :: bool = True in ((0 :: int) \<le> (0 :: int) \<and> (0 :: int) < int (length pass1)) \<and> (length (pass1[nat (0 :: int) := o9]) = length pass1 \<longrightarrow> nth (pass1[nat (0 :: int) := o9]) o nat = (nth pass1 o nat)(0 :: int := o9) \<longrightarrow> ((\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1[nat (0 :: int) := o9] ! nat i = True \<longrightarrow> i = tvalue o7) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state ! nat i of Granted t \<Rightarrow> tvalue t = tvalue o7 \<and> pass1[nat (0 :: int) := o9] ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue o7 \<and> \<not>pass1[nat (0 :: int) := o9] ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap ! nat i \<and> tmap ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state ! nat (tmap ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap ! nat (ticket1 (state ! nat i)) = i) \<and> (model o1 < tvalue o7 \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model o1 \<or> tvalue o7 \<le> i \<and> i < n \<longrightarrow> \<not>released (state ! nat (tmap ! nat i))) \<and> (\<forall>(i :: int). model o1 \<le> i \<and> i < tvalue o7 \<longrightarrow> released (state ! nat (tmap ! nat i)))) \<and> (tvalue o7 < model o1 \<longrightarrow> (\<forall>(i :: int). tvalue o7 \<le> i \<and> i < model o1 \<longrightarrow> \<not>released (state ! nat (tmap ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue o7 \<or> model o1 \<le> i \<and> i < n \<longrightarrow> released (state ! nat (tmap ! nat i)))) \<and> (model o1 = tvalue o7 \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state ! nat (tmap ! nat i)) \<longleftrightarrow> released (state ! nat (tmap ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state ! nat j of Granted x \<Rightarrow> (case state ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))) \<and> (\<forall>(current :: ticket) (tmap1 :: int list) (state1 :: thread_state list) (next :: bounded_int2) (pass2 :: bool list). length tmap1 = length tmap \<longrightarrow> length state1 = length state \<longrightarrow> length pass2 = length (pass1[nat (0 :: int) := o9]) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass2 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass2 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass2 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1 ! nat i \<and> tmap1 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1 ! nat (tmap1 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1 ! nat (ticket1 (state1 ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)) \<longleftrightarrow> released (state1 ! nat (tmap1 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1 ! nat j of Granted x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True)) \<longrightarrow> (\<forall>(id1 :: int). (0 :: int) \<le> id1 \<and> id1 < n \<longrightarrow> ((0 :: int) \<le> id1 \<and> id1 < int (length state1)) \<and> (case state1 ! nat id1 of AcqFetched ticket2 \<Rightarrow> (let o10 :: int = tvalue ticket2 in ((0 :: int) \<le> o10 \<and> o10 < int (length pass2)) \<and> (if pass2 ! nat o10 = True then let o11 :: thread_state = Granted ticket2 in ((0 :: int) \<le> id1 \<and> id1 < int (length state1)) \<and> (length (state1[nat id1 := o11]) = length state1 \<longrightarrow> nth (state1[nat id1 := o11]) o nat = (nth state1 o nat)(id1 := o11) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass2 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1[nat id1 := o11] ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass2 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass2 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1 ! nat i \<and> tmap1 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1[nat id1 := o11] ! nat (tmap1 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1 ! nat (ticket1 (state1[nat id1 := o11] ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state1[nat id1 := o11] ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state1[nat id1 := o11] ! nat (tmap1 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state1[nat id1 := o11] ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state1[nat id1 := o11] ! nat (tmap1 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1[nat id1 := o11] ! nat (tmap1 ! nat i)) \<longleftrightarrow> released (state1[nat id1 := o11] ! nat (tmap1 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1[nat id1 := o11] ! nat j of Granted x \<Rightarrow> (case state1[nat id1 := o11] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1[nat id1 := o11] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))) else (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass2 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass2 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass2 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1 ! nat i \<and> tmap1 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1 ! nat (tmap1 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1 ! nat (ticket1 (state1 ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)) \<longleftrightarrow> released (state1 ! nat (tmap1 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1 ! nat j of Granted x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True)))) | Granted ticket2 \<Rightarrow> (\<forall>(o10 :: bool). if o10 = True then let o11 :: thread_state = RelSet ticket2 in ((0 :: int) \<le> id1 \<and> id1 < int (length state1)) \<and> (length (state1[nat id1 := o11]) = length state1 \<longrightarrow> nth (state1[nat id1 := o11]) o nat = (nth state1 o nat)(id1 := o11) \<longrightarrow> (let o12 :: bool = False; o13 :: int = tvalue ticket2 in ((0 :: int) \<le> o13 \<and> o13 < int (length pass2)) \<and> (length (pass2[nat o13 := o12]) = length pass2 \<longrightarrow> nth (pass2[nat o13 := o12]) o nat = (nth pass2 o nat)(o13 := o12) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass2[nat o13 := o12] ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1[nat id1 := o11] ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass2[nat o13 := o12] ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass2[nat o13 := o12] ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1 ! nat i \<and> tmap1 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1[nat id1 := o11] ! nat (tmap1 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1 ! nat (ticket1 (state1[nat id1 := o11] ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state1[nat id1 := o11] ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state1[nat id1 := o11] ! nat (tmap1 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state1[nat id1 := o11] ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state1[nat id1 := o11] ! nat (tmap1 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1[nat id1 := o11] ! nat (tmap1 ! nat i)) \<longleftrightarrow> released (state1[nat id1 := o11] ! nat (tmap1 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1[nat id1 := o11] ! nat j of Granted x \<Rightarrow> (case state1[nat id1 := o11] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1[nat id1 := o11] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))))) else (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass2 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass2 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass2 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1 ! nat i \<and> tmap1 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1 ! nat (tmap1 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1 ! nat (ticket1 (state1 ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)) \<longleftrightarrow> released (state1 ! nat (tmap1 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1 ! nat j of Granted x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))) | RelSet ticket2 \<Rightarrow> (let o10 :: thread_state = Released ticket2 in ((0 :: int) \<le> id1 \<and> id1 < int (length state1)) \<and> (length (state1[nat id1 := o10]) = length state1 \<longrightarrow> nth (state1[nat id1 := o10]) o nat = (nth state1 o nat)(id1 := o10) \<longrightarrow> (let o11 :: bool = True in \<forall>(o12 :: ticket). (let v :: int = tvalue ticket2 + (1 :: int) in tvalue o12 = (if v = n then 0 :: int else v)) \<longrightarrow> (let o13 :: int = tvalue o12 in ((0 :: int) \<le> o13 \<and> o13 < int (length pass2)) \<and> (length (pass2[nat o13 := o11]) = length pass2 \<longrightarrow> nth (pass2[nat o13 := o11]) o nat = (nth pass2 o nat)(o13 := o11) \<longrightarrow> (\<forall>(o14 :: ticket). (let v :: int = tvalue current + (1 :: int) in tvalue o14 = (if v = n then 0 :: int else v)) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass2[nat o13 := o11] ! nat i = True \<longrightarrow> i = tvalue o14) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1[nat id1 := o10] ! nat i of Granted t \<Rightarrow> tvalue t = tvalue o14 \<and> pass2[nat o13 := o11] ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue o14 \<and> \<not>pass2[nat o13 := o11] ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1 ! nat i \<and> tmap1 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1[nat id1 := o10] ! nat (tmap1 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1 ! nat (ticket1 (state1[nat id1 := o10] ! nat i)) = i) \<and> (model next < tvalue o14 \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue o14 \<le> i \<and> i < n \<longrightarrow> \<not>released (state1[nat id1 := o10] ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue o14 \<longrightarrow> released (state1[nat id1 := o10] ! nat (tmap1 ! nat i)))) \<and> (tvalue o14 < model next \<longrightarrow> (\<forall>(i :: int). tvalue o14 \<le> i \<and> i < model next \<longrightarrow> \<not>released (state1[nat id1 := o10] ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue o14 \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state1[nat id1 := o10] ! nat (tmap1 ! nat i)))) \<and> (model next = tvalue o14 \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1[nat id1 := o10] ! nat (tmap1 ! nat i)) \<longleftrightarrow> released (state1[nat id1 := o10] ! nat (tmap1 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1[nat id1 := o10] ! nat j of Granted x \<Rightarrow> (case state1[nat id1 := o10] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1[nat id1 := o10] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True)))))))) | Released told \<Rightarrow> (\<forall>(o10 :: bool). if o10 = True then \<forall>(ticket2 :: ticket). tvalue ticket2 = model next \<longrightarrow> (let o11 :: int = tvalue ticket2 in ((0 :: int) \<le> o11 \<and> o11 < int (length tmap1)) \<and> (let id2 :: int = tmap1 ! nat o11 in ((0 :: int) \<le> id2 \<and> id2 < int (length state1)) \<and> (case state1 ! nat id2 of Released _ \<Rightarrow> (let o12 :: thread_state = Released told in ((0 :: int) \<le> id2 \<and> id2 < int (length state1)) \<and> (length (state1[nat id2 := o12]) = length state1 \<longrightarrow> nth (state1[nat id2 := o12]) o nat = (nth state1 o nat)(id2 := o12) \<longrightarrow> (let o13 :: int = tvalue ticket2 in ((0 :: int) \<le> o13 \<and> o13 < int (length tmap1)) \<and> (length (tmap1[nat o13 := id1]) = length tmap1 \<longrightarrow> nth (tmap1[nat o13 := id1]) o nat = (nth tmap1 o nat)(o13 := id1) \<longrightarrow> (let o14 :: int = tvalue told in ((0 :: int) \<le> o14 \<and> o14 < int (length (tmap1[nat o13 := id1]))) \<and> (length (tmap1[nat o14 := id2, nat o13 := id1]) = length (tmap1[nat o13 := id1]) \<longrightarrow> nth (tmap1[nat o14 := id2, nat o13 := id1]) o nat = (nth (tmap1[nat o13 := id1]) o nat)(o14 := id2) \<longrightarrow> (let o15 :: thread_state = AcqFetched ticket2 in ((0 :: int) \<le> id1 \<and> id1 < int (length (state1[nat id2 := o12]))) \<and> (length (state1[nat id1 := o15, nat id2 := o12]) = length (state1[nat id2 := o12]) \<longrightarrow> nth (state1[nat id1 := o15, nat id2 := o12]) o nat = (nth (state1[nat id2 := o12]) o nat)(id1 := o15) \<longrightarrow> (\<forall>(o16 :: bounded_int2). (let v :: int = model next + (1 :: int) in model o16 = (if v = n then 0 :: int else v)) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass2 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1[nat id1 := o15, nat id2 := o12] ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass2 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass2 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1[nat o14 := id2, nat o13 := id1] ! nat i \<and> tmap1[nat o14 := id2, nat o13 := id1] ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1[nat id1 := o15, nat id2 := o12] ! nat (tmap1[nat o14 := id2, nat o13 := id1] ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1[nat o14 := id2, nat o13 := id1] ! nat (ticket1 (state1[nat id1 := o15, nat id2 := o12] ! nat i)) = i) \<and> (model o16 < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model o16 \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state1[nat id1 := o15, nat id2 := o12] ! nat (tmap1[nat o14 := id2, nat o13 := id1] ! nat i))) \<and> (\<forall>(i :: int). model o16 \<le> i \<and> i < tvalue current \<longrightarrow> released (state1[nat id1 := o15, nat id2 := o12] ! nat (tmap1[nat o14 := id2, nat o13 := id1] ! nat i)))) \<and> (tvalue current < model o16 \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model o16 \<longrightarrow> \<not>released (state1[nat id1 := o15, nat id2 := o12] ! nat (tmap1[nat o14 := id2, nat o13 := id1] ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model o16 \<le> i \<and> i < n \<longrightarrow> released (state1[nat id1 := o15, nat id2 := o12] ! nat (tmap1[nat o14 := id2, nat o13 := id1] ! nat i)))) \<and> (model o16 = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1[nat id1 := o15, nat id2 := o12] ! nat (tmap1[nat o14 := id2, nat o13 := id1] ! nat i)) \<longleftrightarrow> released (state1[nat id1 := o15, nat id2 := o12] ! nat (tmap1[nat o14 := id2, nat o13 := id1] ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1[nat id1 := o15, nat id2 := o12] ! nat j of Granted x \<Rightarrow> (case state1[nat id1 := o15, nat id2 := o12] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1[nat id1 := o15, nat id2 := o12] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))))))))))) | _ \<Rightarrow> False))) else (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass2 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass2 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass2 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1 ! nat i \<and> tmap1 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1 ! nat (tmap1 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1 ! nat (ticket1 (state1 ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)) \<longleftrightarrow> released (state1 ! nat (tmap1 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1 ! nat j of Granted x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))))))))))) \<and> (o8 + (1 :: int) < (1 :: int) \<longrightarrow> (let o9 :: bool = True in ((0 :: int) \<le> (0 :: int) \<and> (0 :: int) < int (length pass)) \<and> (length (pass[nat (0 :: int) := o9]) = length pass \<longrightarrow> nth (pass[nat (0 :: int) := o9]) o nat = (nth pass o nat)(0 :: int := o9) \<longrightarrow> ((\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass[nat (0 :: int) := o9] ! nat i = True \<longrightarrow> i = tvalue o7) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state ! nat i of Granted t \<Rightarrow> tvalue t = tvalue o7 \<and> pass[nat (0 :: int) := o9] ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue o7 \<and> \<not>pass[nat (0 :: int) := o9] ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap ! nat i \<and> tmap ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state ! nat (tmap ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap ! nat (ticket1 (state ! nat i)) = i) \<and> (model o1 < tvalue o7 \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model o1 \<or> tvalue o7 \<le> i \<and> i < n \<longrightarrow> \<not>released (state ! nat (tmap ! nat i))) \<and> (\<forall>(i :: int). model o1 \<le> i \<and> i < tvalue o7 \<longrightarrow> released (state ! nat (tmap ! nat i)))) \<and> (tvalue o7 < model o1 \<longrightarrow> (\<forall>(i :: int). tvalue o7 \<le> i \<and> i < model o1 \<longrightarrow> \<not>released (state ! nat (tmap ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue o7 \<or> model o1 \<le> i \<and> i < n \<longrightarrow> released (state ! nat (tmap ! nat i)))) \<and> (model o1 = tvalue o7 \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state ! nat (tmap ! nat i)) \<longleftrightarrow> released (state ! nat (tmap ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state ! nat j of Granted x \<Rightarrow> (case state ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))) \<and> (\<forall>(current :: ticket) (tmap1 :: int list) (state1 :: thread_state list) (next :: bounded_int2) (pass1 :: bool list). length tmap1 = length tmap \<longrightarrow> length state1 = length state \<longrightarrow> length pass1 = length (pass[nat (0 :: int) := o9]) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass1 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass1 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1 ! nat i \<and> tmap1 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1 ! nat (tmap1 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1 ! nat (ticket1 (state1 ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)) \<longleftrightarrow> released (state1 ! nat (tmap1 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1 ! nat j of Granted x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True)) \<longrightarrow> (\<forall>(id1 :: int). (0 :: int) \<le> id1 \<and> id1 < n \<longrightarrow> ((0 :: int) \<le> id1 \<and> id1 < int (length state1)) \<and> (case state1 ! nat id1 of AcqFetched ticket2 \<Rightarrow> (let o10 :: int = tvalue ticket2 in ((0 :: int) \<le> o10 \<and> o10 < int (length pass1)) \<and> (if pass1 ! nat o10 = True then let o11 :: thread_state = Granted ticket2 in ((0 :: int) \<le> id1 \<and> id1 < int (length state1)) \<and> (length (state1[nat id1 := o11]) = length state1 \<longrightarrow> nth (state1[nat id1 := o11]) o nat = (nth state1 o nat)(id1 := o11) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1[nat id1 := o11] ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass1 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass1 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1 ! nat i \<and> tmap1 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1[nat id1 := o11] ! nat (tmap1 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1 ! nat (ticket1 (state1[nat id1 := o11] ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state1[nat id1 := o11] ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state1[nat id1 := o11] ! nat (tmap1 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state1[nat id1 := o11] ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state1[nat id1 := o11] ! nat (tmap1 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1[nat id1 := o11] ! nat (tmap1 ! nat i)) \<longleftrightarrow> released (state1[nat id1 := o11] ! nat (tmap1 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1[nat id1 := o11] ! nat j of Granted x \<Rightarrow> (case state1[nat id1 := o11] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1[nat id1 := o11] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))) else (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass1 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass1 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1 ! nat i \<and> tmap1 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1 ! nat (tmap1 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1 ! nat (ticket1 (state1 ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)) \<longleftrightarrow> released (state1 ! nat (tmap1 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1 ! nat j of Granted x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True)))) | Granted ticket2 \<Rightarrow> (\<forall>(o10 :: bool). if o10 = True then let o11 :: thread_state = RelSet ticket2 in ((0 :: int) \<le> id1 \<and> id1 < int (length state1)) \<and> (length (state1[nat id1 := o11]) = length state1 \<longrightarrow> nth (state1[nat id1 := o11]) o nat = (nth state1 o nat)(id1 := o11) \<longrightarrow> (let o12 :: bool = False; o13 :: int = tvalue ticket2 in ((0 :: int) \<le> o13 \<and> o13 < int (length pass1)) \<and> (length (pass1[nat o13 := o12]) = length pass1 \<longrightarrow> nth (pass1[nat o13 := o12]) o nat = (nth pass1 o nat)(o13 := o12) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1[nat o13 := o12] ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1[nat id1 := o11] ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass1[nat o13 := o12] ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass1[nat o13 := o12] ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1 ! nat i \<and> tmap1 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1[nat id1 := o11] ! nat (tmap1 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1 ! nat (ticket1 (state1[nat id1 := o11] ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state1[nat id1 := o11] ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state1[nat id1 := o11] ! nat (tmap1 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state1[nat id1 := o11] ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state1[nat id1 := o11] ! nat (tmap1 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1[nat id1 := o11] ! nat (tmap1 ! nat i)) \<longleftrightarrow> released (state1[nat id1 := o11] ! nat (tmap1 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1[nat id1 := o11] ! nat j of Granted x \<Rightarrow> (case state1[nat id1 := o11] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1[nat id1 := o11] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))))) else (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass1 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass1 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1 ! nat i \<and> tmap1 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1 ! nat (tmap1 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1 ! nat (ticket1 (state1 ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)) \<longleftrightarrow> released (state1 ! nat (tmap1 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1 ! nat j of Granted x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))) | RelSet ticket2 \<Rightarrow> (let o10 :: thread_state = Released ticket2 in ((0 :: int) \<le> id1 \<and> id1 < int (length state1)) \<and> (length (state1[nat id1 := o10]) = length state1 \<longrightarrow> nth (state1[nat id1 := o10]) o nat = (nth state1 o nat)(id1 := o10) \<longrightarrow> (let o11 :: bool = True in \<forall>(o12 :: ticket). (let v :: int = tvalue ticket2 + (1 :: int) in tvalue o12 = (if v = n then 0 :: int else v)) \<longrightarrow> (let o13 :: int = tvalue o12 in ((0 :: int) \<le> o13 \<and> o13 < int (length pass1)) \<and> (length (pass1[nat o13 := o11]) = length pass1 \<longrightarrow> nth (pass1[nat o13 := o11]) o nat = (nth pass1 o nat)(o13 := o11) \<longrightarrow> (\<forall>(o14 :: ticket). (let v :: int = tvalue current + (1 :: int) in tvalue o14 = (if v = n then 0 :: int else v)) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1[nat o13 := o11] ! nat i = True \<longrightarrow> i = tvalue o14) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1[nat id1 := o10] ! nat i of Granted t \<Rightarrow> tvalue t = tvalue o14 \<and> pass1[nat o13 := o11] ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue o14 \<and> \<not>pass1[nat o13 := o11] ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1 ! nat i \<and> tmap1 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1[nat id1 := o10] ! nat (tmap1 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1 ! nat (ticket1 (state1[nat id1 := o10] ! nat i)) = i) \<and> (model next < tvalue o14 \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue o14 \<le> i \<and> i < n \<longrightarrow> \<not>released (state1[nat id1 := o10] ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue o14 \<longrightarrow> released (state1[nat id1 := o10] ! nat (tmap1 ! nat i)))) \<and> (tvalue o14 < model next \<longrightarrow> (\<forall>(i :: int). tvalue o14 \<le> i \<and> i < model next \<longrightarrow> \<not>released (state1[nat id1 := o10] ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue o14 \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state1[nat id1 := o10] ! nat (tmap1 ! nat i)))) \<and> (model next = tvalue o14 \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1[nat id1 := o10] ! nat (tmap1 ! nat i)) \<longleftrightarrow> released (state1[nat id1 := o10] ! nat (tmap1 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1[nat id1 := o10] ! nat j of Granted x \<Rightarrow> (case state1[nat id1 := o10] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1[nat id1 := o10] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True)))))))) | Released told \<Rightarrow> (\<forall>(o10 :: bool). if o10 = True then \<forall>(ticket2 :: ticket). tvalue ticket2 = model next \<longrightarrow> (let o11 :: int = tvalue ticket2 in ((0 :: int) \<le> o11 \<and> o11 < int (length tmap1)) \<and> (let id2 :: int = tmap1 ! nat o11 in ((0 :: int) \<le> id2 \<and> id2 < int (length state1)) \<and> (case state1 ! nat id2 of Released _ \<Rightarrow> (let o12 :: thread_state = Released told in ((0 :: int) \<le> id2 \<and> id2 < int (length state1)) \<and> (length (state1[nat id2 := o12]) = length state1 \<longrightarrow> nth (state1[nat id2 := o12]) o nat = (nth state1 o nat)(id2 := o12) \<longrightarrow> (let o13 :: int = tvalue ticket2 in ((0 :: int) \<le> o13 \<and> o13 < int (length tmap1)) \<and> (length (tmap1[nat o13 := id1]) = length tmap1 \<longrightarrow> nth (tmap1[nat o13 := id1]) o nat = (nth tmap1 o nat)(o13 := id1) \<longrightarrow> (let o14 :: int = tvalue told in ((0 :: int) \<le> o14 \<and> o14 < int (length (tmap1[nat o13 := id1]))) \<and> (length (tmap1[nat o14 := id2, nat o13 := id1]) = length (tmap1[nat o13 := id1]) \<longrightarrow> nth (tmap1[nat o14 := id2, nat o13 := id1]) o nat = (nth (tmap1[nat o13 := id1]) o nat)(o14 := id2) \<longrightarrow> (let o15 :: thread_state = AcqFetched ticket2 in ((0 :: int) \<le> id1 \<and> id1 < int (length (state1[nat id2 := o12]))) \<and> (length (state1[nat id1 := o15, nat id2 := o12]) = length (state1[nat id2 := o12]) \<longrightarrow> nth (state1[nat id1 := o15, nat id2 := o12]) o nat = (nth (state1[nat id2 := o12]) o nat)(id1 := o15) \<longrightarrow> (\<forall>(o16 :: bounded_int2). (let v :: int = model next + (1 :: int) in model o16 = (if v = n then 0 :: int else v)) \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1[nat id1 := o15, nat id2 := o12] ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass1 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass1 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1[nat o14 := id2, nat o13 := id1] ! nat i \<and> tmap1[nat o14 := id2, nat o13 := id1] ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1[nat id1 := o15, nat id2 := o12] ! nat (tmap1[nat o14 := id2, nat o13 := id1] ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1[nat o14 := id2, nat o13 := id1] ! nat (ticket1 (state1[nat id1 := o15, nat id2 := o12] ! nat i)) = i) \<and> (model o16 < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model o16 \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state1[nat id1 := o15, nat id2 := o12] ! nat (tmap1[nat o14 := id2, nat o13 := id1] ! nat i))) \<and> (\<forall>(i :: int). model o16 \<le> i \<and> i < tvalue current \<longrightarrow> released (state1[nat id1 := o15, nat id2 := o12] ! nat (tmap1[nat o14 := id2, nat o13 := id1] ! nat i)))) \<and> (tvalue current < model o16 \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model o16 \<longrightarrow> \<not>released (state1[nat id1 := o15, nat id2 := o12] ! nat (tmap1[nat o14 := id2, nat o13 := id1] ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model o16 \<le> i \<and> i < n \<longrightarrow> released (state1[nat id1 := o15, nat id2 := o12] ! nat (tmap1[nat o14 := id2, nat o13 := id1] ! nat i)))) \<and> (model o16 = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1[nat id1 := o15, nat id2 := o12] ! nat (tmap1[nat o14 := id2, nat o13 := id1] ! nat i)) \<longleftrightarrow> released (state1[nat id1 := o15, nat id2 := o12] ! nat (tmap1[nat o14 := id2, nat o13 := id1] ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1[nat id1 := o15, nat id2 := o12] ! nat j of Granted x \<Rightarrow> (case state1[nat id1 := o15, nat id2 := o12] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1[nat id1 := o15, nat id2 := o12] ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))))))))))) | _ \<Rightarrow> False))) else (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> pass1 ! nat i = True \<longrightarrow> i = tvalue current) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (case state1 ! nat i of Granted t \<Rightarrow> tvalue t = tvalue current \<and> pass1 ! nat (tvalue t) = True | RelSet t \<Rightarrow> tvalue t = tvalue current \<and> \<not>pass1 ! nat (tvalue t) = True | _ \<Rightarrow> True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> tmap1 ! nat i \<and> tmap1 ! nat i < n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> ticket1 (state1 ! nat (tmap1 ! nat i)) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> tmap1 ! nat (ticket1 (state1 ! nat i)) = i) \<and> (model next < tvalue current \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < model next \<or> tvalue current \<le> i \<and> i < n \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). model next \<le> i \<and> i < tvalue current \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (tvalue current < model next \<longrightarrow> (\<forall>(i :: int). tvalue current \<le> i \<and> i < model next \<longrightarrow> \<not>released (state1 ! nat (tmap1 ! nat i))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < tvalue current \<or> model next \<le> i \<and> i < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)))) \<and> (model next = tvalue current \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> released (state1 ! nat (tmap1 ! nat i)) \<longleftrightarrow> released (state1 ! nat (tmap1 ! nat j)))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < n \<longrightarrow> (case state1 ! nat j of Granted x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | RelSet x \<Rightarrow> (case state1 ! nat i of Granted x1 \<Rightarrow> False | RelSet x1 \<Rightarrow> False | _ \<Rightarrow> True) | _ \<Rightarrow> True))))))))))))))))))))"
  sorry
end
