import Mathlib

open Classical

namespace Lean4Why3

instance {n : Nat} : HShiftLeft (BitVec n) Int (BitVec n) where
  hShiftLeft x k := x <<< k.toNat

instance {n : Nat} : HShiftRight (BitVec n) Int (BitVec n) where
  hShiftRight x k := x >>> k.toNat

abbrev sshiftRight'i {n : ℕ} (a : BitVec n) (s : Int) : BitVec n := a.sshiftRight s.toNat

abbrev make_str_i (size : Int) := String.mk (List.replicate (Int.toNat size) 'a')
abbrev _root_.List.create_i {α} (n : ℤ) (f : ℤ -> α) := (List.range n.toNat).map f
abbrev _root_.List.create {α} (n : ℕ) (f : ℕ -> α) := (List.range n).map f

abbrev _root_.Bool.imp (a b : Bool) : Bool := !a || b

abbrev _root_.List.replicate_i {α} (n : ℤ) (x : α) := List.replicate (Int.toNat n) x

abbrev take_i {α : Type} (n : ℤ) (l : List α) := List.take n.toNat l
abbrev drop_i {α : Type} (n : ℤ) (l : List α) := List.drop n.toNat l

abbrev getElem_i! {α : Type} [Inhabited α] (l : List α) (i : Int) := l[i.toNat]!
abbrev getElem_i? {α : Type} (l : List α) (i : Int) := l[i.toNat]?

abbrev length_i {α : Type} (l : List α) := Int.ofNat l.length
abbrev slice {α : Type} (l : List α) (i j : Nat) : List α :=
  (l.drop i).take (j - i)
abbrev slice_i {α : Type} (l : List α) (i j : Int) : List α :=
  (l.drop i.toNat).take (j.toNat - i.toNat)

abbrev Sorted {α : Type} [LE α] (l : List α) := List.Sorted LE.le l
abbrev _root_.List.set_i {α : Type} (l : List α) (n : ℤ) (a : α) :=
  List.set l n.toNat a

abbrev implication (P : Prop) (Q : Prop) := P -> Q

noncomputable def map_occ {α : Type} (v : α) (m : Int -> α) (l u : Int)
  := {n | l ≤ n ∧ n < u ∧ m n = v }.ncard
noncomputable abbrev map_occ_i {α : Type} (v : α) (m : Int -> α) (l u : Int)
  := Int.ofNat (map_occ (v : α) (m : Int -> α) (l : Int) u)

abbrev _root_.BitVec.toUInt {n : Nat} (x : BitVec n) := Int.ofNat x.toNat

abbrev int'16_max : BitVec 16 := 32767
abbrev int'16_min : BitVec 16 := -32768
abbrev int'31_max : BitVec 31 := 1073741823
abbrev int'31_min : BitVec 31 := -1073741824
abbrev int'32_max : BitVec 32 := 2147483647
abbrev int'32_min : BitVec 32 := -2147483648
abbrev int'63_max : BitVec 63 := 4611686018427387903
abbrev int'63_min : BitVec 63 := -4611686018427387904
abbrev int'64_max : BitVec 64 := 9223372036854775807
abbrev int'64_min : BitVec 64 := -9223372036854775808
abbrev uint'16_max : BitVec 16 := 65535
abbrev uint'16_min : BitVec 16 := 0
abbrev uint'31_max : BitVec 31 := 2147483647
abbrev uint'31_min : BitVec 31 := 0
abbrev uint'32_max : BitVec 32 := 4294967295
abbrev uint'32_min : BitVec 32 := 0
abbrev uint'63_max : BitVec 63 := 9223372036854775807
abbrev uint'63_min : BitVec 63 := 0
abbrev uint'64_max : BitVec 64 := 18446744073709551615
abbrev uint'64_min : BitVec 64 := 0

abbrev int'16_in_bounds (x : Int) := int'16_min.toInt ≤ x ∧ x ≤ int'16_max.toInt
abbrev int'31_in_bounds (x : Int) := int'31_min.toInt ≤ x ∧ x ≤ int'31_max.toInt
abbrev int'32_in_bounds (x : Int) := int'32_min.toInt ≤ x ∧ x ≤ int'32_max.toInt
abbrev int'63_in_bounds (x : Int) := int'63_min.toInt ≤ x ∧ x ≤ int'63_max.toInt
abbrev int'64_in_bounds (x : Int) := int'64_min.toInt ≤ x ∧ x ≤ int'64_max.toInt
abbrev uint'8_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ 256
abbrev uint'16_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'16_max.toUInt
abbrev uint'31_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'31_max.toUInt
abbrev uint'32_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'32_max.toUInt
abbrev uint'63_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'63_max.toUInt
abbrev uint'64_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'64_max.toUInt

axiom array31 : Type -> Type
axiom array32 : Type -> Type
axiom array63 : Type -> Type

axiom array31_elts : {α : Type} -> array31 α -> Int -> α
axiom array32_elts : {α : Type} -> array32 α -> Int -> α
axiom array63_elts : {α : Type} -> array63 α -> List α

noncomputable abbrev array63_nth {α : Type} [Inhabited α] (a : array63 α) (i : Int) := (array63_elts a)[i.toNat]!

axiom array31_length : {α : Type} -> array31 α -> BitVec 31
axiom array32_length : {α : Type} -> array32 α -> BitVec 32
axiom array63_length : {α : Type} -> array63 α -> BitVec 63

abbrev is_none {α : Type} (x : Option α) := x = none
abbrev is_nil {α : Type} (x : List α) := x = []

abbrev _root_.List.rev_append {α : Type} (a : List α) (b : List α) := a.reverse ++ b
abbrev _root_.Finset.is_empty {α : Type} (s : Finset α) := s = ∅
abbrev _root_.Finset.filter' {α : Type} (s : Finset α) (p : α → Prop) [DecidablePred p] : Finset α
  := Finset.filter p s

abbrev _root_.Finset.card_i {α : Type} (s : Finset α) := Int.ofNat s.card

abbrev int_power (x : Int) (n : Int) := x ^ n.toNat
abbrev bv2_power (n : Int) := Int.ofNat (2 ^ n.toNat)

abbrev take_bit_i {n : Nat} (x : BitVec n) (i : Int) := x[i.toNat]!
abbrev take_bit_bv {n m : Nat} (x : BitVec n) (i : BitVec m) := x[i.toNat]!

noncomputable def _root_.Finset.pick! {α} [Inhabited α] (s : Finset α) : α :=
  if h : s.Nonempty then Classical.choose h else default
noncomputable def _root_.Set.pick! {α} [Inhabited α] (s : Finset α) : α :=
  if h : s.Nonempty then Classical.choose h else default

noncomputable abbrev _root_.BitVec.eq_sub {m : Nat} (a b : BitVec m) (i n : Nat) :=
  BitVec.extractLsb (i+n-1) i a = BitVec.extractLsb (i+n-1) i b

noncomputable abbrev _root_.BitVec.eq_sub_i {m : Nat} (a b : BitVec m) (i n : Int) :=
  BitVec.eq_sub a b i.toNat n.toNat

noncomputable abbrev _root_.BitVec.eq_sub_bv {m : Nat} {m1 : Nat} {m2 : Nat} (a b : BitVec m) (i : BitVec m1) (n : BitVec m2) :=
  BitVec.eq_sub a b i.toNat n.toNat

abbrev w8_size_bv := (8 : BitVec 8)
abbrev w16_size_bv := (16 : BitVec 16)
abbrev w32_size_bv := (32 : BitVec 32)
abbrev w64_size_bv := (64 : BitVec 64)
abbrev w128_size_bv := (128 : BitVec 128)
abbrev w256_size_bv := (256 : BitVec 256)
abbrev w8_size_i := (8 : Int)
abbrev w16_size_i := (16 : Int)
abbrev w32_size_i := (32 : Int)
abbrev w64_size_i := (64 : Int)
abbrev w128_size_i := (128 : Int)
abbrev w256_size_i := (256 : Int)

abbrev _root_.Finset.erase' {α : Type} [DecidableEq α] (a : α) (s : Finset α) : Finset α
  := Finset.erase s a

abbrev _root_.BitVec.sge {n : ℕ} (x y : BitVec n) := BitVec.sle y x
abbrev _root_.BitVec.sgt {n : ℕ} (x y : BitVec n) := BitVec.slt y x

abbrev _root_.BitVec.sshiftRight_i {n : ℕ} (x : BitVec n) (s : ℤ) := BitVec.sshiftRight x s.toNat
abbrev _root_.BitVec.sshiftRight_bv {n m : ℕ} (x : BitVec n) (s : BitVec m)
  := BitVec.sshiftRight x s.toNat

abbrev _root_.BitVec.rotateLeft_i {w : ℕ} (x : BitVec w) (n : ℤ) := BitVec.rotateLeft x n.toNat
abbrev _root_.BitVec.rotateLeft_nv {w w2 : ℕ} (x : BitVec w) (n : BitVec w2)
  := BitVec.rotateLeft x n.toNat

abbrev _root_.BitVec.rotateRight_i {w : ℕ} (x : BitVec w) (n : ℤ) := BitVec.rotateRight x n.toNat
abbrev _root_.BitVec.rotateRight_nv {w w2 : ℕ} (x : BitVec w) (n : BitVec w2)
  := BitVec.rotateRight x n.toNat

abbrev _root_.Multiset.count_i {α : Type} [DecidableEq α] (a : α) (s : Multiset α)
  := Int.ofNat (s.count a)

abbrev _root_.Multiset.card_i {α : Type} (S : Multiset α) := Int.ofNat S.card

abbrev _root_.Int.gcd_i (a : ℤ) (b : ℤ) := Int.ofNat (Int.gcd a b)

abbrev _root_.Int.Prime (p : ℤ) := Nat.Prime p.toNat
abbrev _root_.Int.Coprime (a b : ℤ) := Nat.Coprime a.toNat b.toNat

abbrev _root_.Set.remove {α : Type} (x : α) (A : Set α) := A \ {x}
abbrev _root_.Set.filter {α : Type} (S : Set α) (P : α -> Bool) := {x ∈ S | P x }

abbrev _root_.Option.the {α : Type} [Inhabited α] (opt : Option α) := opt.getD default

noncomputable abbrev _root_.Finmap.lookup! {K : Type} {V : Type} [Inhabited V] (m : Finmap (fun _ : K => V)) (k : K) :=
  (Finmap.lookup k m).getD default

noncomputable abbrev _root_.Finmap.mapsto {K V : Type} (k : K) (v : V) (m : Finmap (fun _ : K => V))
  := Finmap.lookup k m = some v

abbrev _root_.Finmap.is_empty {K V : Type} (m : Finmap (fun _ : K => V)) := m = ∅
abbrev _root_.Finmap.size {K V : Type} (m : Finmap (fun _ : K => V)) := m.keys.card

abbrev _root_.Finset.min'' {α} [Inhabited α] [LinearOrder α] (s : Finset α) : α :=
  match s.min with
  | ⊤        => default
  | .some a  => a

abbrev _root_.Finset.max'' {α} [Inhabited α] [LinearOrder α] (s : Finset α) : α :=
  match s.max with
  | ⊥        => default
  | .some a  => a

abbrev arrayExchange {α} [Inhabited α] (a1 a2 : List α) (i j : Int) : Prop :=
  let i' := i.toNat
  let j' := j.toNat
  a1 = (a2.set i' a1[j']!).set j' (a1[i']!)

abbrev _root_.List.permut_sub {α} (a1 a2 : List α) (l u : ℕ) : Prop :=
  a1.length = a2.length ∧ (0 ≤ l ∧ l ≤ a1.length) ∧ (0 ≤ u ∧ u ≤ a1.length) ∧
  List.Perm (slice a1 l u) (slice a2 l u)

abbrev _root_.List.permut_sub' {α} (a1 a2 : List α) (l u : ℕ) : Prop :=
  a1.length = a2.length ∧ slice a1 0 l = slice a2 0 l ∧
  slice a1 u a1.length = slice a2 u a1.length ∧
  List.Perm (slice a1 l u) (slice a2 l u)

abbrev _root_.List.foldr' {α β} (f : α -> β -> β) (l : List α) (x : β) := List.foldr f x l

abbrev _root_.Int.to_Real (z : ℤ) : ℝ := z

abbrev _root_.List.mem' {α} (eq : α -> α -> Bool) (x : α) (l : List α) := List.all l (eq x)

noncomputable abbrev _root_.Real.truncate (x : ℝ) : ℤ := if 0 ≤ x then Int.floor x  else Int.ceil x

alias _root_.Math.abs := abs

end Lean4Why3

open Classical
open Lean4Why3

namespace Ref
structure ref (α : Type) where
  contents : α
axiom inhabited_axiom_ref {α : Type} [Inhabited α] : Inhabited (ref α)
attribute [instance] inhabited_axiom_ref
end Ref
namespace verifythis_2018_array_based_queuing_lock_1_Top_mainqtvc
axiom k : ℤ
axiom k'def : (0 : ℤ) < k
axiom n : ℤ
axiom n'def : (0 : ℤ) < n
axiom bounded_int : Type
axiom inhabited_axiom_bounded_int : Inhabited bounded_int
attribute [instance] inhabited_axiom_bounded_int
axiom bmodel : bounded_int -> ℤ
axiom bounded_int'invariant (self : bounded_int) : (0 : ℤ) ≤ bmodel self ∧ bmodel self < k * n
axiom bzero : bounded_int
axiom bzero'def : bmodel bzero = (0 : ℤ)
axiom bounded_int2 : Type
axiom inhabited_axiom_bounded_int2 : Inhabited bounded_int2
attribute [instance] inhabited_axiom_bounded_int2
axiom value : bounded_int2 -> bounded_int
axiom model : bounded_int2 -> ℤ
axiom bounded_int2'invariant (self : bounded_int2) : (0 : ℤ) ≤ model self ∧ model self < n ∧ model self = Int.tmod (bmodel (value self)) n
noncomputable def bounded_int2'eq (a : bounded_int2) (b : bounded_int2) := value a = value b ∧ model a = model b
axiom bounded_int2'inj (a : bounded_int2) (b : bounded_int2) (fact0 : bounded_int2'eq a b) : a = b
axiom ticket : Type
axiom inhabited_axiom_ticket : Inhabited ticket
attribute [instance] inhabited_axiom_ticket
axiom tvalue : ticket -> ℤ
axiom ticket'invariant (self : ticket) : (0 : ℤ) ≤ tvalue self ∧ tvalue self < n
noncomputable def ticket'eq (a : ticket) (b : ticket) := tvalue a = tvalue b
axiom ticket'inj (a : ticket) (b : ticket) (fact0 : ticket'eq a b) : a = b
inductive thread_state where
  | AcqFetched : ticket -> thread_state
  | Granted : ticket -> thread_state
  | RelSet : ticket -> thread_state
  | Released : ticket -> thread_state
axiom inhabited_axiom_thread_state : Inhabited thread_state
attribute [instance] inhabited_axiom_thread_state
noncomputable def ticket1 (s : thread_state) := match s with | thread_state.AcqFetched t => tvalue t | thread_state.Granted t => tvalue t | thread_state.RelSet t => tvalue t | thread_state.Released t => tvalue t
noncomputable def released (s : thread_state) := match s with | thread_state.Released _ => True | _ => False
inductive event where
  | Request : ℤ -> event
  | Acquire : ℤ -> event
axiom inhabited_axiom_event : Inhabited event
attribute [instance] inhabited_axiom_event
axiom hidden : Type
axiom inhabited_axiom_hidden : Inhabited hidden
attribute [instance] inhabited_axiom_hidden
lemma main'vc : (let o1 : ℤ := n; (0 : ℤ) ≤ o1 ∧ (∀(result : List Bool), (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < o1 → result[Int.toNat i]! = false) ∧ Int.ofNat (List.length result) = o1 → Int.ofNat (List.length result) = n)) ∧ (∀(pass : List Bool), Int.ofNat (List.length pass) = n → (∀(o1 : bounded_int2), model o1 = (0 : ℤ) → ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) < n) ∧ (∀(o2 : ticket), tvalue o2 = (0 : ℤ) → (let o3 : ℤ := n; (0 : ℤ) ≤ o3 ∧ (∀(state : List thread_state), (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < o3 → state[Int.toNat i]! = thread_state.Released o2) ∧ Int.ofNat (List.length state) = o3 → (let o4 : ℤ := n; (0 : ℤ) ≤ o4 ∧ (∀(tmap : List ℤ), (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < o4 → tmap[Int.toNat i]! = (0 : ℤ)) ∧ Int.ofNat (List.length tmap) = o4 → (let o5 : ℤ := n - (1 : ℤ); ((0 : ℤ) ≤ o5 + (1 : ℤ) → ((∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < (0 : ℤ) → (match state[Int.toNat j]! with | thread_state.Released t => tvalue t = j | _ => False)) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < (0 : ℤ) → tmap[Int.toNat j]! = j)) ∧ (∀(tmap1 : List ℤ) (state1 : List thread_state), List.length tmap1 = List.length tmap → List.length state1 = List.length state → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i ≤ o5) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < i → (match state1[Int.toNat j]! with | thread_state.Released t => tvalue t = j | _ => False)) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < i → tmap1[Int.toNat j]! = j) → ((0 : ℤ) ≤ i ∧ i < n) ∧ (∀(o6 : ticket), tvalue o6 = i → (let o7 : thread_state := thread_state.Released o6; ((0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length state1)) ∧ (List.length (List.set state1 (Int.toNat i) o7) = List.length state1 → getElem! (List.set state1 (Int.toNat i) o7) ∘ Int.toNat = Function.update (getElem! state1 ∘ Int.toNat) i o7 → ((0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length tmap1)) ∧ (List.length (List.set tmap1 (Int.toNat i) i) = List.length tmap1 → getElem! (List.set tmap1 (Int.toNat i) i) ∘ Int.toNat = Function.update (getElem! tmap1 ∘ Int.toNat) i i → (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < i + (1 : ℤ) → (match (List.set state1 (Int.toNat i) o7)[Int.toNat j]! with | thread_state.Released t => tvalue t = j | _ => False)) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < i + (1 : ℤ) → (List.set tmap1 (Int.toNat i) i)[Int.toNat j]! = j)))))) ∧ ((∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < o5 + (1 : ℤ) → (match state1[Int.toNat j]! with | thread_state.Released t => tvalue t = j | _ => False)) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < o5 + (1 : ℤ) → tmap1[Int.toNat j]! = j) → (∀(o6 : bounded_int2), model o6 = (0 : ℤ) → (∀(o7 : ticket), tvalue o7 = model o6 → (let o8 : ℤ := n - (1 : ℤ); ((1 : ℤ) ≤ o8 + (1 : ℤ) → (∀(j : ℤ), (1 : ℤ) ≤ j ∧ j < (1 : ℤ) → ¬pass[Int.toNat j]! = true) ∧ (∀(pass1 : List Bool), List.length pass1 = List.length pass → (∀(i : ℤ), ((1 : ℤ) ≤ i ∧ i ≤ o8) ∧ (∀(j : ℤ), (1 : ℤ) ≤ j ∧ j < i → ¬pass1[Int.toNat j]! = true) → (let o9 : Bool := false; ((0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length pass1)) ∧ (List.length (List.set pass1 (Int.toNat i) o9) = List.length pass1 → getElem! (List.set pass1 (Int.toNat i) o9) ∘ Int.toNat = Function.update (getElem! pass1 ∘ Int.toNat) i o9 → (∀(j : ℤ), (1 : ℤ) ≤ j ∧ j < i + (1 : ℤ) → ¬(List.set pass1 (Int.toNat i) o9)[Int.toNat j]! = true)))) ∧ ((∀(j : ℤ), (1 : ℤ) ≤ j ∧ j < o8 + (1 : ℤ) → ¬pass1[Int.toNat j]! = true) → (let o9 : Bool := true; ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) < Int.ofNat (List.length pass1)) ∧ (List.length (List.set pass1 (0 : ℕ) o9) = List.length pass1 → getElem! (List.set pass1 (0 : ℕ) o9) ∘ Int.toNat = Function.update (getElem! pass1 ∘ Int.toNat) (0 : ℤ) o9 → ((∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ (List.set pass1 (0 : ℕ) o9)[Int.toNat i]! = true → i = tvalue o7) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state1[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue o7 ∧ (List.set pass1 (0 : ℕ) o9)[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue o7 ∧ ¬(List.set pass1 (0 : ℕ) o9)[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap1[Int.toNat i]! ∧ tmap1[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap1[Int.toNat (ticket1 (state1[Int.toNat i]!))]! = i) ∧ (model o1 < tvalue o7 → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model o1 ∨ tvalue o7 ≤ i ∧ i < n → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model o1 ≤ i ∧ i < tvalue o7 → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (tvalue o7 < model o1 → (∀(i : ℤ), tvalue o7 ≤ i ∧ i < model o1 → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue o7 ∨ model o1 ≤ i ∧ i < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (model o1 = tvalue o7 → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = released (state1[Int.toNat (tmap1[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state1[Int.toNat j]! with | thread_state.Granted x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))) ∧ (∀(current : ticket) (tmap2 : List ℤ) (state2 : List thread_state) (next : bounded_int2) (pass2 : List Bool), List.length tmap2 = List.length tmap1 → List.length state2 = List.length state1 → List.length pass2 = List.length (List.set pass1 (0 : ℕ) o9) → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass2[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state2[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass2[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass2[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap2[Int.toNat i]! ∧ tmap2[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state2[Int.toNat (tmap2[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap2[Int.toNat (ticket1 (state2[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released (state2[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released (state2[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!) = released (state2[Int.toNat (tmap2[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state2[Int.toNat j]! with | thread_state.Granted x => (match state2[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state2[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True)) → (∀(id1 : ℤ), (0 : ℤ) ≤ id1 ∧ id1 < n → ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length state2)) ∧ (match state2[Int.toNat id1]! with | thread_state.AcqFetched ticket2 => (let o10 : ℤ := tvalue ticket2; ((0 : ℤ) ≤ o10 ∧ o10 < Int.ofNat (List.length pass2)) ∧ (if pass2[Int.toNat o10]! = true then let o11 : thread_state := thread_state.Granted ticket2; ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length state2)) ∧ (List.length (List.set state2 (Int.toNat id1) o11) = List.length state2 → getElem! (List.set state2 (Int.toNat id1) o11) ∘ Int.toNat = Function.update (getElem! state2 ∘ Int.toNat) id1 o11 → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass2[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match (List.set state2 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass2[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass2[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap2[Int.toNat i]! ∧ tmap2[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap2[Int.toNat (ticket1 ((List.set state2 (Int.toNat id1) o11)[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!) = released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match (List.set state2 (Int.toNat id1) o11)[Int.toNat j]! with | thread_state.Granted x => (match (List.set state2 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match (List.set state2 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))) else (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass2[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state2[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass2[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass2[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap2[Int.toNat i]! ∧ tmap2[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state2[Int.toNat (tmap2[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap2[Int.toNat (ticket1 (state2[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released (state2[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released (state2[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!) = released (state2[Int.toNat (tmap2[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state2[Int.toNat j]! with | thread_state.Granted x => (match state2[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state2[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True)))) | thread_state.Granted ticket2 => (∀(o10 : Bool), if o10 = true then let o11 : thread_state := thread_state.RelSet ticket2; ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length state2)) ∧ (List.length (List.set state2 (Int.toNat id1) o11) = List.length state2 → getElem! (List.set state2 (Int.toNat id1) o11) ∘ Int.toNat = Function.update (getElem! state2 ∘ Int.toNat) id1 o11 → (let o12 : Bool := false; let o13 : ℤ := tvalue ticket2; ((0 : ℤ) ≤ o13 ∧ o13 < Int.ofNat (List.length pass2)) ∧ (List.length (List.set pass2 (Int.toNat o13) o12) = List.length pass2 → getElem! (List.set pass2 (Int.toNat o13) o12) ∘ Int.toNat = Function.update (getElem! pass2 ∘ Int.toNat) o13 o12 → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ (List.set pass2 (Int.toNat o13) o12)[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match (List.set state2 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ (List.set pass2 (Int.toNat o13) o12)[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬(List.set pass2 (Int.toNat o13) o12)[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap2[Int.toNat i]! ∧ tmap2[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap2[Int.toNat (ticket1 ((List.set state2 (Int.toNat id1) o11)[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!) = released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match (List.set state2 (Int.toNat id1) o11)[Int.toNat j]! with | thread_state.Granted x => (match (List.set state2 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match (List.set state2 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))))) else (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass2[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state2[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass2[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass2[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap2[Int.toNat i]! ∧ tmap2[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state2[Int.toNat (tmap2[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap2[Int.toNat (ticket1 (state2[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released (state2[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released (state2[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!) = released (state2[Int.toNat (tmap2[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state2[Int.toNat j]! with | thread_state.Granted x => (match state2[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state2[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))) | thread_state.RelSet ticket2 => (let o10 : thread_state := thread_state.Released ticket2; ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length state2)) ∧ (List.length (List.set state2 (Int.toNat id1) o10) = List.length state2 → getElem! (List.set state2 (Int.toNat id1) o10) ∘ Int.toNat = Function.update (getElem! state2 ∘ Int.toNat) id1 o10 → (let o11 : Bool := true; ∀(o12 : ticket), (let v : ℤ := tvalue ticket2 + (1 : ℤ); tvalue o12 = (if v = n then (0 : ℤ) else v)) → (let o13 : ℤ := tvalue o12; ((0 : ℤ) ≤ o13 ∧ o13 < Int.ofNat (List.length pass2)) ∧ (List.length (List.set pass2 (Int.toNat o13) o11) = List.length pass2 → getElem! (List.set pass2 (Int.toNat o13) o11) ∘ Int.toNat = Function.update (getElem! pass2 ∘ Int.toNat) o13 o11 → (∀(o14 : ticket), (let v : ℤ := tvalue current + (1 : ℤ); tvalue o14 = (if v = n then (0 : ℤ) else v)) → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ (List.set pass2 (Int.toNat o13) o11)[Int.toNat i]! = true → i = tvalue o14) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match (List.set state2 (Int.toNat id1) o10)[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue o14 ∧ (List.set pass2 (Int.toNat o13) o11)[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue o14 ∧ ¬(List.set pass2 (Int.toNat o13) o11)[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap2[Int.toNat i]! ∧ tmap2[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 ((List.set state2 (Int.toNat id1) o10)[Int.toNat (tmap2[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap2[Int.toNat (ticket1 ((List.set state2 (Int.toNat id1) o10)[Int.toNat i]!))]! = i) ∧ (model next < tvalue o14 → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue o14 ≤ i ∧ i < n → ¬released ((List.set state2 (Int.toNat id1) o10)[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue o14 → released ((List.set state2 (Int.toNat id1) o10)[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (tvalue o14 < model next → (∀(i : ℤ), tvalue o14 ≤ i ∧ i < model next → ¬released ((List.set state2 (Int.toNat id1) o10)[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue o14 ∨ model next ≤ i ∧ i < n → released ((List.set state2 (Int.toNat id1) o10)[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (model next = tvalue o14 → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released ((List.set state2 (Int.toNat id1) o10)[Int.toNat (tmap2[Int.toNat i]!)]!) = released ((List.set state2 (Int.toNat id1) o10)[Int.toNat (tmap2[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match (List.set state2 (Int.toNat id1) o10)[Int.toNat j]! with | thread_state.Granted x => (match (List.set state2 (Int.toNat id1) o10)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match (List.set state2 (Int.toNat id1) o10)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True)))))))) | thread_state.Released told => (∀(o10 : Bool), if o10 = true then ∀(ticket2 : ticket), tvalue ticket2 = model next → (let o11 : ℤ := tvalue ticket2; ((0 : ℤ) ≤ o11 ∧ o11 < Int.ofNat (List.length tmap2)) ∧ (let id2 : ℤ := tmap2[Int.toNat o11]!; ((0 : ℤ) ≤ id2 ∧ id2 < Int.ofNat (List.length state2)) ∧ (match state2[Int.toNat id2]! with | thread_state.Released _ => (let o12 : thread_state := thread_state.Released told; ((0 : ℤ) ≤ id2 ∧ id2 < Int.ofNat (List.length state2)) ∧ (List.length (List.set state2 (Int.toNat id2) o12) = List.length state2 → getElem! (List.set state2 (Int.toNat id2) o12) ∘ Int.toNat = Function.update (getElem! state2 ∘ Int.toNat) id2 o12 → (let o13 : ℤ := tvalue ticket2; ((0 : ℤ) ≤ o13 ∧ o13 < Int.ofNat (List.length tmap2)) ∧ (List.length (List.set tmap2 (Int.toNat o13) id1) = List.length tmap2 → getElem! (List.set tmap2 (Int.toNat o13) id1) ∘ Int.toNat = Function.update (getElem! tmap2 ∘ Int.toNat) o13 id1 → (let o14 : ℤ := tvalue told; ((0 : ℤ) ≤ o14 ∧ o14 < Int.ofNat (List.length (List.set tmap2 (Int.toNat o13) id1))) ∧ (List.length (List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2) = List.length (List.set tmap2 (Int.toNat o13) id1) → getElem! (List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2) ∘ Int.toNat = Function.update (getElem! (List.set tmap2 (Int.toNat o13) id1) ∘ Int.toNat) o14 id2 → (let o15 : thread_state := thread_state.AcqFetched ticket2; ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length (List.set state2 (Int.toNat id2) o12))) ∧ (List.length (List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15) = List.length (List.set state2 (Int.toNat id2) o12) → getElem! (List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15) ∘ Int.toNat = Function.update (getElem! (List.set state2 (Int.toNat id2) o12) ∘ Int.toNat) id1 o15 → (∀(o16 : bounded_int2), (let v : ℤ := model next + (1 : ℤ); model o16 = (if v = n then (0 : ℤ) else v)) → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass2[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match (List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass2[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass2[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ (List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]! ∧ (List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 ((List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat (ticket1 ((List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat i]!))]! = i) ∧ (model o16 < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model o16 ∨ tvalue current ≤ i ∧ i < n → ¬released ((List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model o16 ≤ i ∧ i < tvalue current → released ((List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!))) ∧ (tvalue current < model o16 → (∀(i : ℤ), tvalue current ≤ i ∧ i < model o16 → ¬released ((List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model o16 ≤ i ∧ i < n → released ((List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!))) ∧ (model o16 = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released ((List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!) = released ((List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match (List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat j]! with | thread_state.Granted x => (match (List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match (List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))))))))))) | _ => False))) else (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass2[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state2[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass2[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass2[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap2[Int.toNat i]! ∧ tmap2[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state2[Int.toNat (tmap2[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap2[Int.toNat (ticket1 (state2[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released (state2[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released (state2[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!) = released (state2[Int.toNat (tmap2[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state2[Int.toNat j]! with | thread_state.Granted x => (match state2[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state2[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))))))))))) ∧ (o8 + (1 : ℤ) < (1 : ℤ) → (let o9 : Bool := true; ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) < Int.ofNat (List.length pass)) ∧ (List.length (List.set pass (0 : ℕ) o9) = List.length pass → getElem! (List.set pass (0 : ℕ) o9) ∘ Int.toNat = Function.update (getElem! pass ∘ Int.toNat) (0 : ℤ) o9 → ((∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ (List.set pass (0 : ℕ) o9)[Int.toNat i]! = true → i = tvalue o7) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state1[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue o7 ∧ (List.set pass (0 : ℕ) o9)[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue o7 ∧ ¬(List.set pass (0 : ℕ) o9)[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap1[Int.toNat i]! ∧ tmap1[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap1[Int.toNat (ticket1 (state1[Int.toNat i]!))]! = i) ∧ (model o1 < tvalue o7 → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model o1 ∨ tvalue o7 ≤ i ∧ i < n → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model o1 ≤ i ∧ i < tvalue o7 → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (tvalue o7 < model o1 → (∀(i : ℤ), tvalue o7 ≤ i ∧ i < model o1 → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue o7 ∨ model o1 ≤ i ∧ i < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (model o1 = tvalue o7 → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = released (state1[Int.toNat (tmap1[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state1[Int.toNat j]! with | thread_state.Granted x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))) ∧ (∀(current : ticket) (tmap2 : List ℤ) (state2 : List thread_state) (next : bounded_int2) (pass1 : List Bool), List.length tmap2 = List.length tmap1 → List.length state2 = List.length state1 → List.length pass1 = List.length (List.set pass (0 : ℕ) o9) → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass1[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state2[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass1[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass1[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap2[Int.toNat i]! ∧ tmap2[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state2[Int.toNat (tmap2[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap2[Int.toNat (ticket1 (state2[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released (state2[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released (state2[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!) = released (state2[Int.toNat (tmap2[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state2[Int.toNat j]! with | thread_state.Granted x => (match state2[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state2[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True)) → (∀(id1 : ℤ), (0 : ℤ) ≤ id1 ∧ id1 < n → ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length state2)) ∧ (match state2[Int.toNat id1]! with | thread_state.AcqFetched ticket2 => (let o10 : ℤ := tvalue ticket2; ((0 : ℤ) ≤ o10 ∧ o10 < Int.ofNat (List.length pass1)) ∧ (if pass1[Int.toNat o10]! = true then let o11 : thread_state := thread_state.Granted ticket2; ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length state2)) ∧ (List.length (List.set state2 (Int.toNat id1) o11) = List.length state2 → getElem! (List.set state2 (Int.toNat id1) o11) ∘ Int.toNat = Function.update (getElem! state2 ∘ Int.toNat) id1 o11 → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass1[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match (List.set state2 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass1[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass1[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap2[Int.toNat i]! ∧ tmap2[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap2[Int.toNat (ticket1 ((List.set state2 (Int.toNat id1) o11)[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!) = released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match (List.set state2 (Int.toNat id1) o11)[Int.toNat j]! with | thread_state.Granted x => (match (List.set state2 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match (List.set state2 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))) else (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass1[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state2[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass1[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass1[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap2[Int.toNat i]! ∧ tmap2[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state2[Int.toNat (tmap2[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap2[Int.toNat (ticket1 (state2[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released (state2[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released (state2[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!) = released (state2[Int.toNat (tmap2[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state2[Int.toNat j]! with | thread_state.Granted x => (match state2[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state2[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True)))) | thread_state.Granted ticket2 => (∀(o10 : Bool), if o10 = true then let o11 : thread_state := thread_state.RelSet ticket2; ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length state2)) ∧ (List.length (List.set state2 (Int.toNat id1) o11) = List.length state2 → getElem! (List.set state2 (Int.toNat id1) o11) ∘ Int.toNat = Function.update (getElem! state2 ∘ Int.toNat) id1 o11 → (let o12 : Bool := false; let o13 : ℤ := tvalue ticket2; ((0 : ℤ) ≤ o13 ∧ o13 < Int.ofNat (List.length pass1)) ∧ (List.length (List.set pass1 (Int.toNat o13) o12) = List.length pass1 → getElem! (List.set pass1 (Int.toNat o13) o12) ∘ Int.toNat = Function.update (getElem! pass1 ∘ Int.toNat) o13 o12 → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ (List.set pass1 (Int.toNat o13) o12)[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match (List.set state2 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ (List.set pass1 (Int.toNat o13) o12)[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬(List.set pass1 (Int.toNat o13) o12)[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap2[Int.toNat i]! ∧ tmap2[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap2[Int.toNat (ticket1 ((List.set state2 (Int.toNat id1) o11)[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat i]!)]!) = released ((List.set state2 (Int.toNat id1) o11)[Int.toNat (tmap2[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match (List.set state2 (Int.toNat id1) o11)[Int.toNat j]! with | thread_state.Granted x => (match (List.set state2 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match (List.set state2 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))))) else (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass1[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state2[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass1[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass1[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap2[Int.toNat i]! ∧ tmap2[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state2[Int.toNat (tmap2[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap2[Int.toNat (ticket1 (state2[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released (state2[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released (state2[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!) = released (state2[Int.toNat (tmap2[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state2[Int.toNat j]! with | thread_state.Granted x => (match state2[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state2[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))) | thread_state.RelSet ticket2 => (let o10 : thread_state := thread_state.Released ticket2; ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length state2)) ∧ (List.length (List.set state2 (Int.toNat id1) o10) = List.length state2 → getElem! (List.set state2 (Int.toNat id1) o10) ∘ Int.toNat = Function.update (getElem! state2 ∘ Int.toNat) id1 o10 → (let o11 : Bool := true; ∀(o12 : ticket), (let v : ℤ := tvalue ticket2 + (1 : ℤ); tvalue o12 = (if v = n then (0 : ℤ) else v)) → (let o13 : ℤ := tvalue o12; ((0 : ℤ) ≤ o13 ∧ o13 < Int.ofNat (List.length pass1)) ∧ (List.length (List.set pass1 (Int.toNat o13) o11) = List.length pass1 → getElem! (List.set pass1 (Int.toNat o13) o11) ∘ Int.toNat = Function.update (getElem! pass1 ∘ Int.toNat) o13 o11 → (∀(o14 : ticket), (let v : ℤ := tvalue current + (1 : ℤ); tvalue o14 = (if v = n then (0 : ℤ) else v)) → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ (List.set pass1 (Int.toNat o13) o11)[Int.toNat i]! = true → i = tvalue o14) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match (List.set state2 (Int.toNat id1) o10)[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue o14 ∧ (List.set pass1 (Int.toNat o13) o11)[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue o14 ∧ ¬(List.set pass1 (Int.toNat o13) o11)[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap2[Int.toNat i]! ∧ tmap2[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 ((List.set state2 (Int.toNat id1) o10)[Int.toNat (tmap2[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap2[Int.toNat (ticket1 ((List.set state2 (Int.toNat id1) o10)[Int.toNat i]!))]! = i) ∧ (model next < tvalue o14 → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue o14 ≤ i ∧ i < n → ¬released ((List.set state2 (Int.toNat id1) o10)[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue o14 → released ((List.set state2 (Int.toNat id1) o10)[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (tvalue o14 < model next → (∀(i : ℤ), tvalue o14 ≤ i ∧ i < model next → ¬released ((List.set state2 (Int.toNat id1) o10)[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue o14 ∨ model next ≤ i ∧ i < n → released ((List.set state2 (Int.toNat id1) o10)[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (model next = tvalue o14 → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released ((List.set state2 (Int.toNat id1) o10)[Int.toNat (tmap2[Int.toNat i]!)]!) = released ((List.set state2 (Int.toNat id1) o10)[Int.toNat (tmap2[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match (List.set state2 (Int.toNat id1) o10)[Int.toNat j]! with | thread_state.Granted x => (match (List.set state2 (Int.toNat id1) o10)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match (List.set state2 (Int.toNat id1) o10)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True)))))))) | thread_state.Released told => (∀(o10 : Bool), if o10 = true then ∀(ticket2 : ticket), tvalue ticket2 = model next → (let o11 : ℤ := tvalue ticket2; ((0 : ℤ) ≤ o11 ∧ o11 < Int.ofNat (List.length tmap2)) ∧ (let id2 : ℤ := tmap2[Int.toNat o11]!; ((0 : ℤ) ≤ id2 ∧ id2 < Int.ofNat (List.length state2)) ∧ (match state2[Int.toNat id2]! with | thread_state.Released _ => (let o12 : thread_state := thread_state.Released told; ((0 : ℤ) ≤ id2 ∧ id2 < Int.ofNat (List.length state2)) ∧ (List.length (List.set state2 (Int.toNat id2) o12) = List.length state2 → getElem! (List.set state2 (Int.toNat id2) o12) ∘ Int.toNat = Function.update (getElem! state2 ∘ Int.toNat) id2 o12 → (let o13 : ℤ := tvalue ticket2; ((0 : ℤ) ≤ o13 ∧ o13 < Int.ofNat (List.length tmap2)) ∧ (List.length (List.set tmap2 (Int.toNat o13) id1) = List.length tmap2 → getElem! (List.set tmap2 (Int.toNat o13) id1) ∘ Int.toNat = Function.update (getElem! tmap2 ∘ Int.toNat) o13 id1 → (let o14 : ℤ := tvalue told; ((0 : ℤ) ≤ o14 ∧ o14 < Int.ofNat (List.length (List.set tmap2 (Int.toNat o13) id1))) ∧ (List.length (List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2) = List.length (List.set tmap2 (Int.toNat o13) id1) → getElem! (List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2) ∘ Int.toNat = Function.update (getElem! (List.set tmap2 (Int.toNat o13) id1) ∘ Int.toNat) o14 id2 → (let o15 : thread_state := thread_state.AcqFetched ticket2; ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length (List.set state2 (Int.toNat id2) o12))) ∧ (List.length (List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15) = List.length (List.set state2 (Int.toNat id2) o12) → getElem! (List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15) ∘ Int.toNat = Function.update (getElem! (List.set state2 (Int.toNat id2) o12) ∘ Int.toNat) id1 o15 → (∀(o16 : bounded_int2), (let v : ℤ := model next + (1 : ℤ); model o16 = (if v = n then (0 : ℤ) else v)) → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass1[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match (List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass1[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass1[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ (List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]! ∧ (List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 ((List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat (ticket1 ((List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat i]!))]! = i) ∧ (model o16 < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model o16 ∨ tvalue current ≤ i ∧ i < n → ¬released ((List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model o16 ≤ i ∧ i < tvalue current → released ((List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!))) ∧ (tvalue current < model o16 → (∀(i : ℤ), tvalue current ≤ i ∧ i < model o16 → ¬released ((List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model o16 ≤ i ∧ i < n → released ((List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!))) ∧ (model o16 = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released ((List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!) = released ((List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap2 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match (List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat j]! with | thread_state.Granted x => (match (List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match (List.set (List.set state2 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))))))))))) | _ => False))) else (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass1[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state2[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass1[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass1[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap2[Int.toNat i]! ∧ tmap2[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state2[Int.toNat (tmap2[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap2[Int.toNat (ticket1 (state2[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released (state2[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released (state2[Int.toNat (tmap2[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state2[Int.toNat (tmap2[Int.toNat i]!)]!) = released (state2[Int.toNat (tmap2[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state2[Int.toNat j]! with | thread_state.Granted x => (match state2[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state2[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))))))))))))))) ∧ (o5 + (1 : ℤ) < (0 : ℤ) → (∀(o6 : bounded_int2), model o6 = (0 : ℤ) → (∀(o7 : ticket), tvalue o7 = model o6 → (let o8 : ℤ := n - (1 : ℤ); ((1 : ℤ) ≤ o8 + (1 : ℤ) → (∀(j : ℤ), (1 : ℤ) ≤ j ∧ j < (1 : ℤ) → ¬pass[Int.toNat j]! = true) ∧ (∀(pass1 : List Bool), List.length pass1 = List.length pass → (∀(i : ℤ), ((1 : ℤ) ≤ i ∧ i ≤ o8) ∧ (∀(j : ℤ), (1 : ℤ) ≤ j ∧ j < i → ¬pass1[Int.toNat j]! = true) → (let o9 : Bool := false; ((0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length pass1)) ∧ (List.length (List.set pass1 (Int.toNat i) o9) = List.length pass1 → getElem! (List.set pass1 (Int.toNat i) o9) ∘ Int.toNat = Function.update (getElem! pass1 ∘ Int.toNat) i o9 → (∀(j : ℤ), (1 : ℤ) ≤ j ∧ j < i + (1 : ℤ) → ¬(List.set pass1 (Int.toNat i) o9)[Int.toNat j]! = true)))) ∧ ((∀(j : ℤ), (1 : ℤ) ≤ j ∧ j < o8 + (1 : ℤ) → ¬pass1[Int.toNat j]! = true) → (let o9 : Bool := true; ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) < Int.ofNat (List.length pass1)) ∧ (List.length (List.set pass1 (0 : ℕ) o9) = List.length pass1 → getElem! (List.set pass1 (0 : ℕ) o9) ∘ Int.toNat = Function.update (getElem! pass1 ∘ Int.toNat) (0 : ℤ) o9 → ((∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ (List.set pass1 (0 : ℕ) o9)[Int.toNat i]! = true → i = tvalue o7) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue o7 ∧ (List.set pass1 (0 : ℕ) o9)[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue o7 ∧ ¬(List.set pass1 (0 : ℕ) o9)[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap[Int.toNat i]! ∧ tmap[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state[Int.toNat (tmap[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap[Int.toNat (ticket1 (state[Int.toNat i]!))]! = i) ∧ (model o1 < tvalue o7 → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model o1 ∨ tvalue o7 ≤ i ∧ i < n → ¬released (state[Int.toNat (tmap[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model o1 ≤ i ∧ i < tvalue o7 → released (state[Int.toNat (tmap[Int.toNat i]!)]!))) ∧ (tvalue o7 < model o1 → (∀(i : ℤ), tvalue o7 ≤ i ∧ i < model o1 → ¬released (state[Int.toNat (tmap[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue o7 ∨ model o1 ≤ i ∧ i < n → released (state[Int.toNat (tmap[Int.toNat i]!)]!))) ∧ (model o1 = tvalue o7 → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state[Int.toNat (tmap[Int.toNat i]!)]!) = released (state[Int.toNat (tmap[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state[Int.toNat j]! with | thread_state.Granted x => (match state[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))) ∧ (∀(current : ticket) (tmap1 : List ℤ) (state1 : List thread_state) (next : bounded_int2) (pass2 : List Bool), List.length tmap1 = List.length tmap → List.length state1 = List.length state → List.length pass2 = List.length (List.set pass1 (0 : ℕ) o9) → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass2[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state1[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass2[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass2[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap1[Int.toNat i]! ∧ tmap1[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap1[Int.toNat (ticket1 (state1[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = released (state1[Int.toNat (tmap1[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state1[Int.toNat j]! with | thread_state.Granted x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True)) → (∀(id1 : ℤ), (0 : ℤ) ≤ id1 ∧ id1 < n → ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length state1)) ∧ (match state1[Int.toNat id1]! with | thread_state.AcqFetched ticket2 => (let o10 : ℤ := tvalue ticket2; ((0 : ℤ) ≤ o10 ∧ o10 < Int.ofNat (List.length pass2)) ∧ (if pass2[Int.toNat o10]! = true then let o11 : thread_state := thread_state.Granted ticket2; ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length state1)) ∧ (List.length (List.set state1 (Int.toNat id1) o11) = List.length state1 → getElem! (List.set state1 (Int.toNat id1) o11) ∘ Int.toNat = Function.update (getElem! state1 ∘ Int.toNat) id1 o11 → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass2[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match (List.set state1 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass2[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass2[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap1[Int.toNat i]! ∧ tmap1[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap1[Int.toNat (ticket1 ((List.set state1 (Int.toNat id1) o11)[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!) = released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match (List.set state1 (Int.toNat id1) o11)[Int.toNat j]! with | thread_state.Granted x => (match (List.set state1 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match (List.set state1 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))) else (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass2[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state1[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass2[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass2[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap1[Int.toNat i]! ∧ tmap1[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap1[Int.toNat (ticket1 (state1[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = released (state1[Int.toNat (tmap1[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state1[Int.toNat j]! with | thread_state.Granted x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True)))) | thread_state.Granted ticket2 => (∀(o10 : Bool), if o10 = true then let o11 : thread_state := thread_state.RelSet ticket2; ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length state1)) ∧ (List.length (List.set state1 (Int.toNat id1) o11) = List.length state1 → getElem! (List.set state1 (Int.toNat id1) o11) ∘ Int.toNat = Function.update (getElem! state1 ∘ Int.toNat) id1 o11 → (let o12 : Bool := false; let o13 : ℤ := tvalue ticket2; ((0 : ℤ) ≤ o13 ∧ o13 < Int.ofNat (List.length pass2)) ∧ (List.length (List.set pass2 (Int.toNat o13) o12) = List.length pass2 → getElem! (List.set pass2 (Int.toNat o13) o12) ∘ Int.toNat = Function.update (getElem! pass2 ∘ Int.toNat) o13 o12 → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ (List.set pass2 (Int.toNat o13) o12)[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match (List.set state1 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ (List.set pass2 (Int.toNat o13) o12)[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬(List.set pass2 (Int.toNat o13) o12)[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap1[Int.toNat i]! ∧ tmap1[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap1[Int.toNat (ticket1 ((List.set state1 (Int.toNat id1) o11)[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!) = released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match (List.set state1 (Int.toNat id1) o11)[Int.toNat j]! with | thread_state.Granted x => (match (List.set state1 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match (List.set state1 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))))) else (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass2[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state1[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass2[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass2[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap1[Int.toNat i]! ∧ tmap1[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap1[Int.toNat (ticket1 (state1[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = released (state1[Int.toNat (tmap1[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state1[Int.toNat j]! with | thread_state.Granted x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))) | thread_state.RelSet ticket2 => (let o10 : thread_state := thread_state.Released ticket2; ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length state1)) ∧ (List.length (List.set state1 (Int.toNat id1) o10) = List.length state1 → getElem! (List.set state1 (Int.toNat id1) o10) ∘ Int.toNat = Function.update (getElem! state1 ∘ Int.toNat) id1 o10 → (let o11 : Bool := true; ∀(o12 : ticket), (let v : ℤ := tvalue ticket2 + (1 : ℤ); tvalue o12 = (if v = n then (0 : ℤ) else v)) → (let o13 : ℤ := tvalue o12; ((0 : ℤ) ≤ o13 ∧ o13 < Int.ofNat (List.length pass2)) ∧ (List.length (List.set pass2 (Int.toNat o13) o11) = List.length pass2 → getElem! (List.set pass2 (Int.toNat o13) o11) ∘ Int.toNat = Function.update (getElem! pass2 ∘ Int.toNat) o13 o11 → (∀(o14 : ticket), (let v : ℤ := tvalue current + (1 : ℤ); tvalue o14 = (if v = n then (0 : ℤ) else v)) → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ (List.set pass2 (Int.toNat o13) o11)[Int.toNat i]! = true → i = tvalue o14) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match (List.set state1 (Int.toNat id1) o10)[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue o14 ∧ (List.set pass2 (Int.toNat o13) o11)[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue o14 ∧ ¬(List.set pass2 (Int.toNat o13) o11)[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap1[Int.toNat i]! ∧ tmap1[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 ((List.set state1 (Int.toNat id1) o10)[Int.toNat (tmap1[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap1[Int.toNat (ticket1 ((List.set state1 (Int.toNat id1) o10)[Int.toNat i]!))]! = i) ∧ (model next < tvalue o14 → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue o14 ≤ i ∧ i < n → ¬released ((List.set state1 (Int.toNat id1) o10)[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue o14 → released ((List.set state1 (Int.toNat id1) o10)[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (tvalue o14 < model next → (∀(i : ℤ), tvalue o14 ≤ i ∧ i < model next → ¬released ((List.set state1 (Int.toNat id1) o10)[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue o14 ∨ model next ≤ i ∧ i < n → released ((List.set state1 (Int.toNat id1) o10)[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (model next = tvalue o14 → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released ((List.set state1 (Int.toNat id1) o10)[Int.toNat (tmap1[Int.toNat i]!)]!) = released ((List.set state1 (Int.toNat id1) o10)[Int.toNat (tmap1[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match (List.set state1 (Int.toNat id1) o10)[Int.toNat j]! with | thread_state.Granted x => (match (List.set state1 (Int.toNat id1) o10)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match (List.set state1 (Int.toNat id1) o10)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True)))))))) | thread_state.Released told => (∀(o10 : Bool), if o10 = true then ∀(ticket2 : ticket), tvalue ticket2 = model next → (let o11 : ℤ := tvalue ticket2; ((0 : ℤ) ≤ o11 ∧ o11 < Int.ofNat (List.length tmap1)) ∧ (let id2 : ℤ := tmap1[Int.toNat o11]!; ((0 : ℤ) ≤ id2 ∧ id2 < Int.ofNat (List.length state1)) ∧ (match state1[Int.toNat id2]! with | thread_state.Released _ => (let o12 : thread_state := thread_state.Released told; ((0 : ℤ) ≤ id2 ∧ id2 < Int.ofNat (List.length state1)) ∧ (List.length (List.set state1 (Int.toNat id2) o12) = List.length state1 → getElem! (List.set state1 (Int.toNat id2) o12) ∘ Int.toNat = Function.update (getElem! state1 ∘ Int.toNat) id2 o12 → (let o13 : ℤ := tvalue ticket2; ((0 : ℤ) ≤ o13 ∧ o13 < Int.ofNat (List.length tmap1)) ∧ (List.length (List.set tmap1 (Int.toNat o13) id1) = List.length tmap1 → getElem! (List.set tmap1 (Int.toNat o13) id1) ∘ Int.toNat = Function.update (getElem! tmap1 ∘ Int.toNat) o13 id1 → (let o14 : ℤ := tvalue told; ((0 : ℤ) ≤ o14 ∧ o14 < Int.ofNat (List.length (List.set tmap1 (Int.toNat o13) id1))) ∧ (List.length (List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2) = List.length (List.set tmap1 (Int.toNat o13) id1) → getElem! (List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2) ∘ Int.toNat = Function.update (getElem! (List.set tmap1 (Int.toNat o13) id1) ∘ Int.toNat) o14 id2 → (let o15 : thread_state := thread_state.AcqFetched ticket2; ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length (List.set state1 (Int.toNat id2) o12))) ∧ (List.length (List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15) = List.length (List.set state1 (Int.toNat id2) o12) → getElem! (List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15) ∘ Int.toNat = Function.update (getElem! (List.set state1 (Int.toNat id2) o12) ∘ Int.toNat) id1 o15 → (∀(o16 : bounded_int2), (let v : ℤ := model next + (1 : ℤ); model o16 = (if v = n then (0 : ℤ) else v)) → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass2[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match (List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass2[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass2[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ (List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]! ∧ (List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 ((List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat (ticket1 ((List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat i]!))]! = i) ∧ (model o16 < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model o16 ∨ tvalue current ≤ i ∧ i < n → ¬released ((List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model o16 ≤ i ∧ i < tvalue current → released ((List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!))) ∧ (tvalue current < model o16 → (∀(i : ℤ), tvalue current ≤ i ∧ i < model o16 → ¬released ((List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model o16 ≤ i ∧ i < n → released ((List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!))) ∧ (model o16 = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released ((List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!) = released ((List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match (List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat j]! with | thread_state.Granted x => (match (List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match (List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))))))))))) | _ => False))) else (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass2[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state1[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass2[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass2[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap1[Int.toNat i]! ∧ tmap1[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap1[Int.toNat (ticket1 (state1[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = released (state1[Int.toNat (tmap1[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state1[Int.toNat j]! with | thread_state.Granted x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))))))))))) ∧ (o8 + (1 : ℤ) < (1 : ℤ) → (let o9 : Bool := true; ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) < Int.ofNat (List.length pass)) ∧ (List.length (List.set pass (0 : ℕ) o9) = List.length pass → getElem! (List.set pass (0 : ℕ) o9) ∘ Int.toNat = Function.update (getElem! pass ∘ Int.toNat) (0 : ℤ) o9 → ((∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ (List.set pass (0 : ℕ) o9)[Int.toNat i]! = true → i = tvalue o7) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue o7 ∧ (List.set pass (0 : ℕ) o9)[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue o7 ∧ ¬(List.set pass (0 : ℕ) o9)[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap[Int.toNat i]! ∧ tmap[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state[Int.toNat (tmap[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap[Int.toNat (ticket1 (state[Int.toNat i]!))]! = i) ∧ (model o1 < tvalue o7 → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model o1 ∨ tvalue o7 ≤ i ∧ i < n → ¬released (state[Int.toNat (tmap[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model o1 ≤ i ∧ i < tvalue o7 → released (state[Int.toNat (tmap[Int.toNat i]!)]!))) ∧ (tvalue o7 < model o1 → (∀(i : ℤ), tvalue o7 ≤ i ∧ i < model o1 → ¬released (state[Int.toNat (tmap[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue o7 ∨ model o1 ≤ i ∧ i < n → released (state[Int.toNat (tmap[Int.toNat i]!)]!))) ∧ (model o1 = tvalue o7 → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state[Int.toNat (tmap[Int.toNat i]!)]!) = released (state[Int.toNat (tmap[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state[Int.toNat j]! with | thread_state.Granted x => (match state[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))) ∧ (∀(current : ticket) (tmap1 : List ℤ) (state1 : List thread_state) (next : bounded_int2) (pass1 : List Bool), List.length tmap1 = List.length tmap → List.length state1 = List.length state → List.length pass1 = List.length (List.set pass (0 : ℕ) o9) → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass1[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state1[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass1[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass1[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap1[Int.toNat i]! ∧ tmap1[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap1[Int.toNat (ticket1 (state1[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = released (state1[Int.toNat (tmap1[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state1[Int.toNat j]! with | thread_state.Granted x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True)) → (∀(id1 : ℤ), (0 : ℤ) ≤ id1 ∧ id1 < n → ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length state1)) ∧ (match state1[Int.toNat id1]! with | thread_state.AcqFetched ticket2 => (let o10 : ℤ := tvalue ticket2; ((0 : ℤ) ≤ o10 ∧ o10 < Int.ofNat (List.length pass1)) ∧ (if pass1[Int.toNat o10]! = true then let o11 : thread_state := thread_state.Granted ticket2; ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length state1)) ∧ (List.length (List.set state1 (Int.toNat id1) o11) = List.length state1 → getElem! (List.set state1 (Int.toNat id1) o11) ∘ Int.toNat = Function.update (getElem! state1 ∘ Int.toNat) id1 o11 → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass1[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match (List.set state1 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass1[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass1[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap1[Int.toNat i]! ∧ tmap1[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap1[Int.toNat (ticket1 ((List.set state1 (Int.toNat id1) o11)[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!) = released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match (List.set state1 (Int.toNat id1) o11)[Int.toNat j]! with | thread_state.Granted x => (match (List.set state1 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match (List.set state1 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))) else (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass1[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state1[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass1[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass1[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap1[Int.toNat i]! ∧ tmap1[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap1[Int.toNat (ticket1 (state1[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = released (state1[Int.toNat (tmap1[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state1[Int.toNat j]! with | thread_state.Granted x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True)))) | thread_state.Granted ticket2 => (∀(o10 : Bool), if o10 = true then let o11 : thread_state := thread_state.RelSet ticket2; ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length state1)) ∧ (List.length (List.set state1 (Int.toNat id1) o11) = List.length state1 → getElem! (List.set state1 (Int.toNat id1) o11) ∘ Int.toNat = Function.update (getElem! state1 ∘ Int.toNat) id1 o11 → (let o12 : Bool := false; let o13 : ℤ := tvalue ticket2; ((0 : ℤ) ≤ o13 ∧ o13 < Int.ofNat (List.length pass1)) ∧ (List.length (List.set pass1 (Int.toNat o13) o12) = List.length pass1 → getElem! (List.set pass1 (Int.toNat o13) o12) ∘ Int.toNat = Function.update (getElem! pass1 ∘ Int.toNat) o13 o12 → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ (List.set pass1 (Int.toNat o13) o12)[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match (List.set state1 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ (List.set pass1 (Int.toNat o13) o12)[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬(List.set pass1 (Int.toNat o13) o12)[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap1[Int.toNat i]! ∧ tmap1[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap1[Int.toNat (ticket1 ((List.set state1 (Int.toNat id1) o11)[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat i]!)]!) = released ((List.set state1 (Int.toNat id1) o11)[Int.toNat (tmap1[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match (List.set state1 (Int.toNat id1) o11)[Int.toNat j]! with | thread_state.Granted x => (match (List.set state1 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match (List.set state1 (Int.toNat id1) o11)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))))) else (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass1[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state1[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass1[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass1[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap1[Int.toNat i]! ∧ tmap1[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap1[Int.toNat (ticket1 (state1[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = released (state1[Int.toNat (tmap1[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state1[Int.toNat j]! with | thread_state.Granted x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))) | thread_state.RelSet ticket2 => (let o10 : thread_state := thread_state.Released ticket2; ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length state1)) ∧ (List.length (List.set state1 (Int.toNat id1) o10) = List.length state1 → getElem! (List.set state1 (Int.toNat id1) o10) ∘ Int.toNat = Function.update (getElem! state1 ∘ Int.toNat) id1 o10 → (let o11 : Bool := true; ∀(o12 : ticket), (let v : ℤ := tvalue ticket2 + (1 : ℤ); tvalue o12 = (if v = n then (0 : ℤ) else v)) → (let o13 : ℤ := tvalue o12; ((0 : ℤ) ≤ o13 ∧ o13 < Int.ofNat (List.length pass1)) ∧ (List.length (List.set pass1 (Int.toNat o13) o11) = List.length pass1 → getElem! (List.set pass1 (Int.toNat o13) o11) ∘ Int.toNat = Function.update (getElem! pass1 ∘ Int.toNat) o13 o11 → (∀(o14 : ticket), (let v : ℤ := tvalue current + (1 : ℤ); tvalue o14 = (if v = n then (0 : ℤ) else v)) → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ (List.set pass1 (Int.toNat o13) o11)[Int.toNat i]! = true → i = tvalue o14) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match (List.set state1 (Int.toNat id1) o10)[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue o14 ∧ (List.set pass1 (Int.toNat o13) o11)[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue o14 ∧ ¬(List.set pass1 (Int.toNat o13) o11)[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap1[Int.toNat i]! ∧ tmap1[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 ((List.set state1 (Int.toNat id1) o10)[Int.toNat (tmap1[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap1[Int.toNat (ticket1 ((List.set state1 (Int.toNat id1) o10)[Int.toNat i]!))]! = i) ∧ (model next < tvalue o14 → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue o14 ≤ i ∧ i < n → ¬released ((List.set state1 (Int.toNat id1) o10)[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue o14 → released ((List.set state1 (Int.toNat id1) o10)[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (tvalue o14 < model next → (∀(i : ℤ), tvalue o14 ≤ i ∧ i < model next → ¬released ((List.set state1 (Int.toNat id1) o10)[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue o14 ∨ model next ≤ i ∧ i < n → released ((List.set state1 (Int.toNat id1) o10)[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (model next = tvalue o14 → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released ((List.set state1 (Int.toNat id1) o10)[Int.toNat (tmap1[Int.toNat i]!)]!) = released ((List.set state1 (Int.toNat id1) o10)[Int.toNat (tmap1[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match (List.set state1 (Int.toNat id1) o10)[Int.toNat j]! with | thread_state.Granted x => (match (List.set state1 (Int.toNat id1) o10)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match (List.set state1 (Int.toNat id1) o10)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True)))))))) | thread_state.Released told => (∀(o10 : Bool), if o10 = true then ∀(ticket2 : ticket), tvalue ticket2 = model next → (let o11 : ℤ := tvalue ticket2; ((0 : ℤ) ≤ o11 ∧ o11 < Int.ofNat (List.length tmap1)) ∧ (let id2 : ℤ := tmap1[Int.toNat o11]!; ((0 : ℤ) ≤ id2 ∧ id2 < Int.ofNat (List.length state1)) ∧ (match state1[Int.toNat id2]! with | thread_state.Released _ => (let o12 : thread_state := thread_state.Released told; ((0 : ℤ) ≤ id2 ∧ id2 < Int.ofNat (List.length state1)) ∧ (List.length (List.set state1 (Int.toNat id2) o12) = List.length state1 → getElem! (List.set state1 (Int.toNat id2) o12) ∘ Int.toNat = Function.update (getElem! state1 ∘ Int.toNat) id2 o12 → (let o13 : ℤ := tvalue ticket2; ((0 : ℤ) ≤ o13 ∧ o13 < Int.ofNat (List.length tmap1)) ∧ (List.length (List.set tmap1 (Int.toNat o13) id1) = List.length tmap1 → getElem! (List.set tmap1 (Int.toNat o13) id1) ∘ Int.toNat = Function.update (getElem! tmap1 ∘ Int.toNat) o13 id1 → (let o14 : ℤ := tvalue told; ((0 : ℤ) ≤ o14 ∧ o14 < Int.ofNat (List.length (List.set tmap1 (Int.toNat o13) id1))) ∧ (List.length (List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2) = List.length (List.set tmap1 (Int.toNat o13) id1) → getElem! (List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2) ∘ Int.toNat = Function.update (getElem! (List.set tmap1 (Int.toNat o13) id1) ∘ Int.toNat) o14 id2 → (let o15 : thread_state := thread_state.AcqFetched ticket2; ((0 : ℤ) ≤ id1 ∧ id1 < Int.ofNat (List.length (List.set state1 (Int.toNat id2) o12))) ∧ (List.length (List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15) = List.length (List.set state1 (Int.toNat id2) o12) → getElem! (List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15) ∘ Int.toNat = Function.update (getElem! (List.set state1 (Int.toNat id2) o12) ∘ Int.toNat) id1 o15 → (∀(o16 : bounded_int2), (let v : ℤ := model next + (1 : ℤ); model o16 = (if v = n then (0 : ℤ) else v)) → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass1[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match (List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass1[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass1[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ (List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]! ∧ (List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 ((List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat (ticket1 ((List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat i]!))]! = i) ∧ (model o16 < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model o16 ∨ tvalue current ≤ i ∧ i < n → ¬released ((List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model o16 ≤ i ∧ i < tvalue current → released ((List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!))) ∧ (tvalue current < model o16 → (∀(i : ℤ), tvalue current ≤ i ∧ i < model o16 → ¬released ((List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model o16 ≤ i ∧ i < n → released ((List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!))) ∧ (model o16 = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released ((List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat i]!)]!) = released ((List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat ((List.set (List.set tmap1 (Int.toNat o13) id1) (Int.toNat o14) id2)[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match (List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat j]! with | thread_state.Granted x => (match (List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match (List.set (List.set state1 (Int.toNat id2) o12) (Int.toNat id1) o15)[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True))))))))))) | _ => False))) else (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < n) ∧ pass1[Int.toNat i]! = true → i = tvalue current) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (match state1[Int.toNat i]! with | thread_state.Granted t => tvalue t = tvalue current ∧ pass1[Int.toNat (tvalue t)]! = true | thread_state.RelSet t => tvalue t = tvalue current ∧ ¬pass1[Int.toNat (tvalue t)]! = true | _ => True)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (0 : ℤ) ≤ tmap1[Int.toNat i]! ∧ tmap1[Int.toNat i]! < n) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → ticket1 (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = i) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → tmap1[Int.toNat (ticket1 (state1[Int.toNat i]!))]! = i) ∧ (model next < tvalue current → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), model next ≤ i ∧ i < tvalue current → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (tvalue current < model next → (∀(i : ℤ), tvalue current ≤ i ∧ i < model next → ¬released (state1[Int.toNat (tmap1[Int.toNat i]!)]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!))) ∧ (model next = tvalue current → (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → released (state1[Int.toNat (tmap1[Int.toNat i]!)]!) = released (state1[Int.toNat (tmap1[Int.toNat j]!)]!))) ∧ (∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < n → (match state1[Int.toNat j]! with | thread_state.Granted x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | thread_state.RelSet x => (match state1[Int.toNat i]! with | thread_state.Granted x1 => False | thread_state.RelSet x1 => False | _ => True) | _ => True)))))))))))))))))))))
  := sorry
end verifythis_2018_array_based_queuing_lock_1_Top_mainqtvc
