From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.why3.Ref.Ref.
Open Scope Z_scope.
Axiom k : Z.
Axiom k'def : 0%Z < k.
Axiom n : Z.
Axiom n'def : 0%Z < n.
Axiom bounded_int : Type.
Axiom bounded_int_inhabited : Inhabited bounded_int.
Global Existing Instance bounded_int_inhabited.
Axiom bounded_int_countable : Countable bounded_int.
Global Existing Instance bounded_int_countable.
Axiom bmodel : bounded_int -> Z.
Axiom bounded_int'invariant : forall  (self : bounded_int), 0%Z ≤ bmodel self ∧ bmodel self < k * n.
Axiom bzero : bounded_int.
Axiom bzero'def : bmodel bzero = 0%Z.
Axiom bounded_int2 : Type.
Axiom bounded_int2_inhabited : Inhabited bounded_int2.
Global Existing Instance bounded_int2_inhabited.
Axiom bounded_int2_countable : Countable bounded_int2.
Global Existing Instance bounded_int2_countable.
Axiom value : bounded_int2 -> bounded_int.
Axiom model : bounded_int2 -> Z.
Axiom bounded_int2'invariant : forall  (self : bounded_int2), 0%Z ≤ model self ∧ model self < n ∧ model self = Z.quot (bmodel (value self)) n.
Definition bounded_int2'eq (a : bounded_int2) (b : bounded_int2) := value a = value b ∧ model a = model b.
Axiom bounded_int2'inj : forall  (a : bounded_int2) (b : bounded_int2) (fact0 : bounded_int2'eq a b), a = b.
Axiom ticket : Type.
Axiom ticket_inhabited : Inhabited ticket.
Global Existing Instance ticket_inhabited.
Axiom ticket_countable : Countable ticket.
Global Existing Instance ticket_countable.
Axiom tvalue : ticket -> Z.
Axiom ticket'invariant : forall  (self : ticket), 0%Z ≤ tvalue self ∧ tvalue self < n.
Definition ticket'eq (a : ticket) (b : ticket) := tvalue a = tvalue b.
Axiom ticket'inj : forall  (a : ticket) (b : ticket) (fact0 : ticket'eq a b), a = b.
Inductive thread_state :=
  | AcqFetched : ticket -> thread_state
  | Granted : ticket -> thread_state
  | RelSet : ticket -> thread_state
  | Released : ticket -> thread_state.
Axiom thread_state_inhabited : Inhabited thread_state.
Global Existing Instance thread_state_inhabited.
Axiom thread_state_countable : Countable thread_state.
Global Existing Instance thread_state_countable.
Definition ticket1 (s : thread_state) : Z := match s with | AcqFetched t => tvalue t | Granted t => tvalue t | RelSet t => tvalue t | Released t => tvalue t end.
Definition released (s : thread_state) := match s with | Released _ => True | _ => False end.
Inductive event :=
  | Request : Z -> event
  | Acquire : Z -> event.
Axiom event_inhabited : Inhabited event.
Global Existing Instance event_inhabited.
Axiom event_countable : Countable event.
Global Existing Instance event_countable.
Axiom hidden : Type.
Axiom hidden_inhabited : Inhabited hidden.
Global Existing Instance hidden_inhabited.
Axiom hidden_countable : Countable hidden.
Global Existing Instance hidden_countable.
Theorem main'vc : (let o1 : Z := n in 0%Z ≤ o1 ∧ (∀(result : list bool), (∀(i : Z), 0%Z ≤ i ∧ i < o1 -> nth (Z.to_nat i) result inhabitant = false) ∧ Z.of_nat (length result) = o1 -> Z.of_nat (length result) = n)) ∧ (∀(pass : list bool), Z.of_nat (length pass) = n -> (∀(o1 : bounded_int2), model o1 = 0%Z -> (0%Z ≤ 0%Z ∧ 0%Z < n) ∧ (∀(o2 : ticket), tvalue o2 = 0%Z -> (let o3 : Z := n in 0%Z ≤ o3 ∧ (∀(state : list thread_state), (∀(i : Z), 0%Z ≤ i ∧ i < o3 -> nth (Z.to_nat i) state inhabitant = Released o2) ∧ Z.of_nat (length state) = o3 -> (let o4 : Z := n in 0%Z ≤ o4 ∧ (∀(tmap : list Z), (∀(i : Z), 0%Z ≤ i ∧ i < o4 -> nth (Z.to_nat i) tmap inhabitant = 0%Z) ∧ Z.of_nat (length tmap) = o4 -> (let o5 : Z := n - 1%Z in (0%Z ≤ o5 + 1%Z -> ((∀(j : Z), 0%Z ≤ j ∧ j < 0%Z -> (match nth (Z.to_nat j) state inhabitant with | Released t => tvalue t = j | _ => False end)) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < 0%Z -> nth (Z.to_nat j) tmap inhabitant = j)) ∧ (∀(tmap1 : list Z) (state1 : list thread_state), length tmap1 = length tmap -> length state1 = length state -> (∀(i : Z), (0%Z ≤ i ∧ i ≤ o5) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < i -> (match nth (Z.to_nat j) state1 inhabitant with | Released t => tvalue t = j | _ => False end)) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < i -> nth (Z.to_nat j) tmap1 inhabitant = j) -> (0%Z ≤ i ∧ i < n) ∧ (∀(o6 : ticket), tvalue o6 = i -> (let o7 : thread_state := Released o6 in (0%Z ≤ i ∧ i < Z.of_nat (length state1)) ∧ (length (set_list state1 (Z.to_nat i) o7) = length state1 -> nth_i (set_list state1 (Z.to_nat i) o7) = fun_updt (nth_i state1) i o7 -> (0%Z ≤ i ∧ i < Z.of_nat (length tmap1)) ∧ (length (set_list tmap1 (Z.to_nat i) i) = length tmap1 -> nth_i (set_list tmap1 (Z.to_nat i) i) = fun_updt (nth_i tmap1) i i -> (∀(j : Z), 0%Z ≤ j ∧ j < i + 1%Z -> (match nth (Z.to_nat j) (set_list state1 (Z.to_nat i) o7) inhabitant with | Released t => tvalue t = j | _ => False end)) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < i + 1%Z -> nth (Z.to_nat j) (set_list tmap1 (Z.to_nat i) i) inhabitant = j)))))) ∧ ((∀(j : Z), 0%Z ≤ j ∧ j < o5 + 1%Z -> (match nth (Z.to_nat j) state1 inhabitant with | Released t => tvalue t = j | _ => False end)) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < o5 + 1%Z -> nth (Z.to_nat j) tmap1 inhabitant = j) -> (∀(o6 : bounded_int2), model o6 = 0%Z -> (∀(o7 : ticket), tvalue o7 = model o6 -> (let o8 : Z := n - 1%Z in (1%Z ≤ o8 + 1%Z -> (∀(j : Z), 1%Z ≤ j ∧ j < 1%Z -> ¬ nth (Z.to_nat j) pass inhabitant = true) ∧ (∀(pass1 : list bool), length pass1 = length pass -> (∀(i : Z), (1%Z ≤ i ∧ i ≤ o8) ∧ (∀(j : Z), 1%Z ≤ j ∧ j < i -> ¬ nth (Z.to_nat j) pass1 inhabitant = true) -> (let o9 : bool := false in (0%Z ≤ i ∧ i < Z.of_nat (length pass1)) ∧ (length (set_list pass1 (Z.to_nat i) o9) = length pass1 -> nth_i (set_list pass1 (Z.to_nat i) o9) = fun_updt (nth_i pass1) i o9 -> (∀(j : Z), 1%Z ≤ j ∧ j < i + 1%Z -> ¬ nth (Z.to_nat j) (set_list pass1 (Z.to_nat i) o9) inhabitant = true)))) ∧ ((∀(j : Z), 1%Z ≤ j ∧ j < o8 + 1%Z -> ¬ nth (Z.to_nat j) pass1 inhabitant = true) -> (let o9 : bool := true in (0%Z ≤ 0%Z ∧ 0%Z < Z.of_nat (length pass1)) ∧ (length (set_list pass1 0%nat o9) = length pass1 -> nth_i (set_list pass1 0%nat o9) = fun_updt (nth_i pass1) 0%Z o9 -> ((∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) (set_list pass1 0%nat o9) inhabitant = true -> i = tvalue o7) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state1 inhabitant with | Granted t => tvalue t = tvalue o7 ∧ nth (Z.to_nat (tvalue t)) (set_list pass1 0%nat o9) inhabitant = true | RelSet t => tvalue t = tvalue o7 ∧ ¬ nth (Z.to_nat (tvalue t)) (set_list pass1 0%nat o9) inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap1 inhabitant ∧ nth (Z.to_nat i) tmap1 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state1 inhabitant))) tmap1 inhabitant = i) ∧ (model o1 < tvalue o7 -> (∀(i : Z), 0%Z ≤ i ∧ i < model o1 ∨ tvalue o7 ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), model o1 ≤ i ∧ i < tvalue o7 -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (tvalue o7 < model o1 -> (∀(i : Z), tvalue o7 ≤ i ∧ i < model o1 -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue o7 ∨ model o1 ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (model o1 = tvalue o7 -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap1 inhabitant)) state1 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state1 inhabitant with | Granted x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))) ∧ (∀(current : ticket) (tmap2 : list Z) (state2 : list thread_state) (next : bounded_int2) (pass2 : list bool), length tmap2 = length tmap1 -> length state2 = length state1 -> length pass2 = length (set_list pass1 0%nat o9) -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass2 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state2 inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap2 inhabitant ∧ nth (Z.to_nat i) tmap2 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state2 inhabitant))) tmap2 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap2 inhabitant)) state2 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state2 inhabitant with | Granted x => (match nth (Z.to_nat i) state2 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state2 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end)) -> (∀(id1 : Z), 0%Z ≤ id1 ∧ id1 < n -> (0%Z ≤ id1 ∧ id1 < Z.of_nat (length state2)) ∧ (match nth (Z.to_nat id1) state2 inhabitant with | AcqFetched ticket2 => (let o10 : Z := tvalue ticket2 in (0%Z ≤ o10 ∧ o10 < Z.of_nat (length pass2)) ∧ (if decide (nth (Z.to_nat o10) pass2 inhabitant = true) then let o11 : thread_state := Granted ticket2 in (0%Z ≤ id1 ∧ id1 < Z.of_nat (length state2)) ∧ (length (set_list state2 (Z.to_nat id1) o11) = length state2 -> nth_i (set_list state2 (Z.to_nat id1) o11) = fun_updt (nth_i state2) id1 o11 -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass2 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o11) inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap2 inhabitant ∧ nth (Z.to_nat i) tmap2 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o11) inhabitant))) tmap2 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) (set_list state2 (Z.to_nat id1) o11) inhabitant with | Granted x => (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o11) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o11) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))) else (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass2 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state2 inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap2 inhabitant ∧ nth (Z.to_nat i) tmap2 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state2 inhabitant))) tmap2 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap2 inhabitant)) state2 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state2 inhabitant with | Granted x => (match nth (Z.to_nat i) state2 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state2 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end)))) | Granted ticket2 => (∀(o10 : bool), if decide (o10 = true) then let o11 : thread_state := RelSet ticket2 in (0%Z ≤ id1 ∧ id1 < Z.of_nat (length state2)) ∧ (length (set_list state2 (Z.to_nat id1) o11) = length state2 -> nth_i (set_list state2 (Z.to_nat id1) o11) = fun_updt (nth_i state2) id1 o11 -> (let o12 : bool := false in let o13 : Z := tvalue ticket2 in (0%Z ≤ o13 ∧ o13 < Z.of_nat (length pass2)) ∧ (length (set_list pass2 (Z.to_nat o13) o12) = length pass2 -> nth_i (set_list pass2 (Z.to_nat o13) o12) = fun_updt (nth_i pass2) o13 o12 -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) (set_list pass2 (Z.to_nat o13) o12) inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o11) inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) (set_list pass2 (Z.to_nat o13) o12) inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) (set_list pass2 (Z.to_nat o13) o12) inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap2 inhabitant ∧ nth (Z.to_nat i) tmap2 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o11) inhabitant))) tmap2 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) (set_list state2 (Z.to_nat id1) o11) inhabitant with | Granted x => (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o11) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o11) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))))) else (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass2 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state2 inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap2 inhabitant ∧ nth (Z.to_nat i) tmap2 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state2 inhabitant))) tmap2 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap2 inhabitant)) state2 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state2 inhabitant with | Granted x => (match nth (Z.to_nat i) state2 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state2 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))) | RelSet ticket2 => (let o10 : thread_state := Released ticket2 in (0%Z ≤ id1 ∧ id1 < Z.of_nat (length state2)) ∧ (length (set_list state2 (Z.to_nat id1) o10) = length state2 -> nth_i (set_list state2 (Z.to_nat id1) o10) = fun_updt (nth_i state2) id1 o10 -> (let o11 : bool := true in ∀(o12 : ticket), (let v : Z := tvalue ticket2 + 1%Z in tvalue o12 = (if decide (v = n) then 0%Z else v)) -> (let o13 : Z := tvalue o12 in (0%Z ≤ o13 ∧ o13 < Z.of_nat (length pass2)) ∧ (length (set_list pass2 (Z.to_nat o13) o11) = length pass2 -> nth_i (set_list pass2 (Z.to_nat o13) o11) = fun_updt (nth_i pass2) o13 o11 -> (∀(o14 : ticket), (let v : Z := tvalue current + 1%Z in tvalue o14 = (if decide (v = n) then 0%Z else v)) -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) (set_list pass2 (Z.to_nat o13) o11) inhabitant = true -> i = tvalue o14) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o10) inhabitant with | Granted t => tvalue t = tvalue o14 ∧ nth (Z.to_nat (tvalue t)) (set_list pass2 (Z.to_nat o13) o11) inhabitant = true | RelSet t => tvalue t = tvalue o14 ∧ ¬ nth (Z.to_nat (tvalue t)) (set_list pass2 (Z.to_nat o13) o11) inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap2 inhabitant ∧ nth (Z.to_nat i) tmap2 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o10) inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o10) inhabitant))) tmap2 inhabitant = i) ∧ (model next < tvalue o14 -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue o14 ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o10) inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue o14 -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o10) inhabitant))) ∧ (tvalue o14 < model next -> (∀(i : Z), tvalue o14 ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o10) inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue o14 ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o10) inhabitant))) ∧ (model next = tvalue o14 -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o10) inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o10) inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) (set_list state2 (Z.to_nat id1) o10) inhabitant with | Granted x => (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o10) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o10) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end)))))))) | Released told => (∀(o10 : bool), if decide (o10 = true) then ∀(ticket2 : ticket), tvalue ticket2 = model next -> (let o11 : Z := tvalue ticket2 in (0%Z ≤ o11 ∧ o11 < Z.of_nat (length tmap2)) ∧ (let id2 : Z := nth (Z.to_nat o11) tmap2 inhabitant in (0%Z ≤ id2 ∧ id2 < Z.of_nat (length state2)) ∧ (match nth (Z.to_nat id2) state2 inhabitant with | Released _ => (let o12 : thread_state := Released told in (0%Z ≤ id2 ∧ id2 < Z.of_nat (length state2)) ∧ (length (set_list state2 (Z.to_nat id2) o12) = length state2 -> nth_i (set_list state2 (Z.to_nat id2) o12) = fun_updt (nth_i state2) id2 o12 -> (let o13 : Z := tvalue ticket2 in (0%Z ≤ o13 ∧ o13 < Z.of_nat (length tmap2)) ∧ (length (set_list tmap2 (Z.to_nat o13) id1) = length tmap2 -> nth_i (set_list tmap2 (Z.to_nat o13) id1) = fun_updt (nth_i tmap2) o13 id1 -> (let o14 : Z := tvalue told in (0%Z ≤ o14 ∧ o14 < Z.of_nat (length (set_list tmap2 (Z.to_nat o13) id1))) ∧ (length (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) = length (set_list tmap2 (Z.to_nat o13) id1) -> nth_i (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) = fun_updt (nth_i (set_list tmap2 (Z.to_nat o13) id1)) o14 id2 -> (let o15 : thread_state := AcqFetched ticket2 in (0%Z ≤ id1 ∧ id1 < Z.of_nat (length (set_list state2 (Z.to_nat id2) o12))) ∧ (length (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) = length (set_list state2 (Z.to_nat id2) o12) -> nth_i (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) = fun_updt (nth_i (set_list state2 (Z.to_nat id2) o12)) id1 o15 -> (∀(o16 : bounded_int2), (let v : Z := model next + 1%Z in model o16 = (if decide (v = n) then 0%Z else v)) -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass2 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant ∧ nth (Z.to_nat i) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant))) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant = i) ∧ (model o16 < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model o16 ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant)) ∧ (∀(i : Z), model o16 ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant))) ∧ (tvalue current < model o16 -> (∀(i : Z), tvalue current ≤ i ∧ i < model o16 -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model o16 ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant))) ∧ (model o16 = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant with | Granted x => (match nth (Z.to_nat i) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))))))))))) | _ => False end))) else (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass2 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state2 inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap2 inhabitant ∧ nth (Z.to_nat i) tmap2 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state2 inhabitant))) tmap2 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap2 inhabitant)) state2 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state2 inhabitant with | Granted x => (match nth (Z.to_nat i) state2 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state2 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))) end)))))))) ∧ (o8 + 1%Z < 1%Z -> (let o9 : bool := true in (0%Z ≤ 0%Z ∧ 0%Z < Z.of_nat (length pass)) ∧ (length (set_list pass 0%nat o9) = length pass -> nth_i (set_list pass 0%nat o9) = fun_updt (nth_i pass) 0%Z o9 -> ((∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) (set_list pass 0%nat o9) inhabitant = true -> i = tvalue o7) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state1 inhabitant with | Granted t => tvalue t = tvalue o7 ∧ nth (Z.to_nat (tvalue t)) (set_list pass 0%nat o9) inhabitant = true | RelSet t => tvalue t = tvalue o7 ∧ ¬ nth (Z.to_nat (tvalue t)) (set_list pass 0%nat o9) inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap1 inhabitant ∧ nth (Z.to_nat i) tmap1 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state1 inhabitant))) tmap1 inhabitant = i) ∧ (model o1 < tvalue o7 -> (∀(i : Z), 0%Z ≤ i ∧ i < model o1 ∨ tvalue o7 ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), model o1 ≤ i ∧ i < tvalue o7 -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (tvalue o7 < model o1 -> (∀(i : Z), tvalue o7 ≤ i ∧ i < model o1 -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue o7 ∨ model o1 ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (model o1 = tvalue o7 -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap1 inhabitant)) state1 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state1 inhabitant with | Granted x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))) ∧ (∀(current : ticket) (tmap2 : list Z) (state2 : list thread_state) (next : bounded_int2) (pass1 : list bool), length tmap2 = length tmap1 -> length state2 = length state1 -> length pass1 = length (set_list pass 0%nat o9) -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass1 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state2 inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap2 inhabitant ∧ nth (Z.to_nat i) tmap2 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state2 inhabitant))) tmap2 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap2 inhabitant)) state2 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state2 inhabitant with | Granted x => (match nth (Z.to_nat i) state2 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state2 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end)) -> (∀(id1 : Z), 0%Z ≤ id1 ∧ id1 < n -> (0%Z ≤ id1 ∧ id1 < Z.of_nat (length state2)) ∧ (match nth (Z.to_nat id1) state2 inhabitant with | AcqFetched ticket2 => (let o10 : Z := tvalue ticket2 in (0%Z ≤ o10 ∧ o10 < Z.of_nat (length pass1)) ∧ (if decide (nth (Z.to_nat o10) pass1 inhabitant = true) then let o11 : thread_state := Granted ticket2 in (0%Z ≤ id1 ∧ id1 < Z.of_nat (length state2)) ∧ (length (set_list state2 (Z.to_nat id1) o11) = length state2 -> nth_i (set_list state2 (Z.to_nat id1) o11) = fun_updt (nth_i state2) id1 o11 -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass1 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o11) inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap2 inhabitant ∧ nth (Z.to_nat i) tmap2 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o11) inhabitant))) tmap2 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) (set_list state2 (Z.to_nat id1) o11) inhabitant with | Granted x => (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o11) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o11) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))) else (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass1 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state2 inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap2 inhabitant ∧ nth (Z.to_nat i) tmap2 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state2 inhabitant))) tmap2 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap2 inhabitant)) state2 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state2 inhabitant with | Granted x => (match nth (Z.to_nat i) state2 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state2 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end)))) | Granted ticket2 => (∀(o10 : bool), if decide (o10 = true) then let o11 : thread_state := RelSet ticket2 in (0%Z ≤ id1 ∧ id1 < Z.of_nat (length state2)) ∧ (length (set_list state2 (Z.to_nat id1) o11) = length state2 -> nth_i (set_list state2 (Z.to_nat id1) o11) = fun_updt (nth_i state2) id1 o11 -> (let o12 : bool := false in let o13 : Z := tvalue ticket2 in (0%Z ≤ o13 ∧ o13 < Z.of_nat (length pass1)) ∧ (length (set_list pass1 (Z.to_nat o13) o12) = length pass1 -> nth_i (set_list pass1 (Z.to_nat o13) o12) = fun_updt (nth_i pass1) o13 o12 -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) (set_list pass1 (Z.to_nat o13) o12) inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o11) inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) (set_list pass1 (Z.to_nat o13) o12) inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) (set_list pass1 (Z.to_nat o13) o12) inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap2 inhabitant ∧ nth (Z.to_nat i) tmap2 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o11) inhabitant))) tmap2 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o11) inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) (set_list state2 (Z.to_nat id1) o11) inhabitant with | Granted x => (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o11) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o11) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))))) else (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass1 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state2 inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap2 inhabitant ∧ nth (Z.to_nat i) tmap2 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state2 inhabitant))) tmap2 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap2 inhabitant)) state2 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state2 inhabitant with | Granted x => (match nth (Z.to_nat i) state2 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state2 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))) | RelSet ticket2 => (let o10 : thread_state := Released ticket2 in (0%Z ≤ id1 ∧ id1 < Z.of_nat (length state2)) ∧ (length (set_list state2 (Z.to_nat id1) o10) = length state2 -> nth_i (set_list state2 (Z.to_nat id1) o10) = fun_updt (nth_i state2) id1 o10 -> (let o11 : bool := true in ∀(o12 : ticket), (let v : Z := tvalue ticket2 + 1%Z in tvalue o12 = (if decide (v = n) then 0%Z else v)) -> (let o13 : Z := tvalue o12 in (0%Z ≤ o13 ∧ o13 < Z.of_nat (length pass1)) ∧ (length (set_list pass1 (Z.to_nat o13) o11) = length pass1 -> nth_i (set_list pass1 (Z.to_nat o13) o11) = fun_updt (nth_i pass1) o13 o11 -> (∀(o14 : ticket), (let v : Z := tvalue current + 1%Z in tvalue o14 = (if decide (v = n) then 0%Z else v)) -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) (set_list pass1 (Z.to_nat o13) o11) inhabitant = true -> i = tvalue o14) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o10) inhabitant with | Granted t => tvalue t = tvalue o14 ∧ nth (Z.to_nat (tvalue t)) (set_list pass1 (Z.to_nat o13) o11) inhabitant = true | RelSet t => tvalue t = tvalue o14 ∧ ¬ nth (Z.to_nat (tvalue t)) (set_list pass1 (Z.to_nat o13) o11) inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap2 inhabitant ∧ nth (Z.to_nat i) tmap2 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o10) inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o10) inhabitant))) tmap2 inhabitant = i) ∧ (model next < tvalue o14 -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue o14 ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o10) inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue o14 -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o10) inhabitant))) ∧ (tvalue o14 < model next -> (∀(i : Z), tvalue o14 ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o10) inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue o14 ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o10) inhabitant))) ∧ (model next = tvalue o14 -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o10) inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap2 inhabitant)) (set_list state2 (Z.to_nat id1) o10) inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) (set_list state2 (Z.to_nat id1) o10) inhabitant with | Granted x => (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o10) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) (set_list state2 (Z.to_nat id1) o10) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end)))))))) | Released told => (∀(o10 : bool), if decide (o10 = true) then ∀(ticket2 : ticket), tvalue ticket2 = model next -> (let o11 : Z := tvalue ticket2 in (0%Z ≤ o11 ∧ o11 < Z.of_nat (length tmap2)) ∧ (let id2 : Z := nth (Z.to_nat o11) tmap2 inhabitant in (0%Z ≤ id2 ∧ id2 < Z.of_nat (length state2)) ∧ (match nth (Z.to_nat id2) state2 inhabitant with | Released _ => (let o12 : thread_state := Released told in (0%Z ≤ id2 ∧ id2 < Z.of_nat (length state2)) ∧ (length (set_list state2 (Z.to_nat id2) o12) = length state2 -> nth_i (set_list state2 (Z.to_nat id2) o12) = fun_updt (nth_i state2) id2 o12 -> (let o13 : Z := tvalue ticket2 in (0%Z ≤ o13 ∧ o13 < Z.of_nat (length tmap2)) ∧ (length (set_list tmap2 (Z.to_nat o13) id1) = length tmap2 -> nth_i (set_list tmap2 (Z.to_nat o13) id1) = fun_updt (nth_i tmap2) o13 id1 -> (let o14 : Z := tvalue told in (0%Z ≤ o14 ∧ o14 < Z.of_nat (length (set_list tmap2 (Z.to_nat o13) id1))) ∧ (length (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) = length (set_list tmap2 (Z.to_nat o13) id1) -> nth_i (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) = fun_updt (nth_i (set_list tmap2 (Z.to_nat o13) id1)) o14 id2 -> (let o15 : thread_state := AcqFetched ticket2 in (0%Z ≤ id1 ∧ id1 < Z.of_nat (length (set_list state2 (Z.to_nat id2) o12))) ∧ (length (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) = length (set_list state2 (Z.to_nat id2) o12) -> nth_i (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) = fun_updt (nth_i (set_list state2 (Z.to_nat id2) o12)) id1 o15 -> (∀(o16 : bounded_int2), (let v : Z := model next + 1%Z in model o16 = (if decide (v = n) then 0%Z else v)) -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass1 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant ∧ nth (Z.to_nat i) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant))) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant = i) ∧ (model o16 < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model o16 ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant)) ∧ (∀(i : Z), model o16 ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant))) ∧ (tvalue current < model o16 -> (∀(i : Z), tvalue current ≤ i ∧ i < model o16 -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model o16 ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant))) ∧ (model o16 = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) (set_list (set_list tmap2 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant with | Granted x => (match nth (Z.to_nat i) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) (set_list (set_list state2 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))))))))))) | _ => False end))) else (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass1 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state2 inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap2 inhabitant ∧ nth (Z.to_nat i) tmap2 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state2 inhabitant))) tmap2 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap2 inhabitant)) state2 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap2 inhabitant)) state2 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state2 inhabitant with | Granted x => (match nth (Z.to_nat i) state2 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state2 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))) end)))))))))))) ∧ (o5 + 1%Z < 0%Z -> (∀(o6 : bounded_int2), model o6 = 0%Z -> (∀(o7 : ticket), tvalue o7 = model o6 -> (let o8 : Z := n - 1%Z in (1%Z ≤ o8 + 1%Z -> (∀(j : Z), 1%Z ≤ j ∧ j < 1%Z -> ¬ nth (Z.to_nat j) pass inhabitant = true) ∧ (∀(pass1 : list bool), length pass1 = length pass -> (∀(i : Z), (1%Z ≤ i ∧ i ≤ o8) ∧ (∀(j : Z), 1%Z ≤ j ∧ j < i -> ¬ nth (Z.to_nat j) pass1 inhabitant = true) -> (let o9 : bool := false in (0%Z ≤ i ∧ i < Z.of_nat (length pass1)) ∧ (length (set_list pass1 (Z.to_nat i) o9) = length pass1 -> nth_i (set_list pass1 (Z.to_nat i) o9) = fun_updt (nth_i pass1) i o9 -> (∀(j : Z), 1%Z ≤ j ∧ j < i + 1%Z -> ¬ nth (Z.to_nat j) (set_list pass1 (Z.to_nat i) o9) inhabitant = true)))) ∧ ((∀(j : Z), 1%Z ≤ j ∧ j < o8 + 1%Z -> ¬ nth (Z.to_nat j) pass1 inhabitant = true) -> (let o9 : bool := true in (0%Z ≤ 0%Z ∧ 0%Z < Z.of_nat (length pass1)) ∧ (length (set_list pass1 0%nat o9) = length pass1 -> nth_i (set_list pass1 0%nat o9) = fun_updt (nth_i pass1) 0%Z o9 -> ((∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) (set_list pass1 0%nat o9) inhabitant = true -> i = tvalue o7) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state inhabitant with | Granted t => tvalue t = tvalue o7 ∧ nth (Z.to_nat (tvalue t)) (set_list pass1 0%nat o9) inhabitant = true | RelSet t => tvalue t = tvalue o7 ∧ ¬ nth (Z.to_nat (tvalue t)) (set_list pass1 0%nat o9) inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap inhabitant ∧ nth (Z.to_nat i) tmap inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap inhabitant)) state inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state inhabitant))) tmap inhabitant = i) ∧ (model o1 < tvalue o7 -> (∀(i : Z), 0%Z ≤ i ∧ i < model o1 ∨ tvalue o7 ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap inhabitant)) state inhabitant)) ∧ (∀(i : Z), model o1 ≤ i ∧ i < tvalue o7 -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap inhabitant)) state inhabitant))) ∧ (tvalue o7 < model o1 -> (∀(i : Z), tvalue o7 ≤ i ∧ i < model o1 -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap inhabitant)) state inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue o7 ∨ model o1 ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap inhabitant)) state inhabitant))) ∧ (model o1 = tvalue o7 -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap inhabitant)) state inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap inhabitant)) state inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state inhabitant with | Granted x => (match nth (Z.to_nat i) state inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))) ∧ (∀(current : ticket) (tmap1 : list Z) (state1 : list thread_state) (next : bounded_int2) (pass2 : list bool), length tmap1 = length tmap -> length state1 = length state -> length pass2 = length (set_list pass1 0%nat o9) -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass2 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state1 inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap1 inhabitant ∧ nth (Z.to_nat i) tmap1 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state1 inhabitant))) tmap1 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap1 inhabitant)) state1 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state1 inhabitant with | Granted x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end)) -> (∀(id1 : Z), 0%Z ≤ id1 ∧ id1 < n -> (0%Z ≤ id1 ∧ id1 < Z.of_nat (length state1)) ∧ (match nth (Z.to_nat id1) state1 inhabitant with | AcqFetched ticket2 => (let o10 : Z := tvalue ticket2 in (0%Z ≤ o10 ∧ o10 < Z.of_nat (length pass2)) ∧ (if decide (nth (Z.to_nat o10) pass2 inhabitant = true) then let o11 : thread_state := Granted ticket2 in (0%Z ≤ id1 ∧ id1 < Z.of_nat (length state1)) ∧ (length (set_list state1 (Z.to_nat id1) o11) = length state1 -> nth_i (set_list state1 (Z.to_nat id1) o11) = fun_updt (nth_i state1) id1 o11 -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass2 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o11) inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap1 inhabitant ∧ nth (Z.to_nat i) tmap1 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o11) inhabitant))) tmap1 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) (set_list state1 (Z.to_nat id1) o11) inhabitant with | Granted x => (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o11) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o11) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))) else (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass2 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state1 inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap1 inhabitant ∧ nth (Z.to_nat i) tmap1 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state1 inhabitant))) tmap1 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap1 inhabitant)) state1 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state1 inhabitant with | Granted x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end)))) | Granted ticket2 => (∀(o10 : bool), if decide (o10 = true) then let o11 : thread_state := RelSet ticket2 in (0%Z ≤ id1 ∧ id1 < Z.of_nat (length state1)) ∧ (length (set_list state1 (Z.to_nat id1) o11) = length state1 -> nth_i (set_list state1 (Z.to_nat id1) o11) = fun_updt (nth_i state1) id1 o11 -> (let o12 : bool := false in let o13 : Z := tvalue ticket2 in (0%Z ≤ o13 ∧ o13 < Z.of_nat (length pass2)) ∧ (length (set_list pass2 (Z.to_nat o13) o12) = length pass2 -> nth_i (set_list pass2 (Z.to_nat o13) o12) = fun_updt (nth_i pass2) o13 o12 -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) (set_list pass2 (Z.to_nat o13) o12) inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o11) inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) (set_list pass2 (Z.to_nat o13) o12) inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) (set_list pass2 (Z.to_nat o13) o12) inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap1 inhabitant ∧ nth (Z.to_nat i) tmap1 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o11) inhabitant))) tmap1 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) (set_list state1 (Z.to_nat id1) o11) inhabitant with | Granted x => (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o11) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o11) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))))) else (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass2 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state1 inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap1 inhabitant ∧ nth (Z.to_nat i) tmap1 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state1 inhabitant))) tmap1 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap1 inhabitant)) state1 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state1 inhabitant with | Granted x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))) | RelSet ticket2 => (let o10 : thread_state := Released ticket2 in (0%Z ≤ id1 ∧ id1 < Z.of_nat (length state1)) ∧ (length (set_list state1 (Z.to_nat id1) o10) = length state1 -> nth_i (set_list state1 (Z.to_nat id1) o10) = fun_updt (nth_i state1) id1 o10 -> (let o11 : bool := true in ∀(o12 : ticket), (let v : Z := tvalue ticket2 + 1%Z in tvalue o12 = (if decide (v = n) then 0%Z else v)) -> (let o13 : Z := tvalue o12 in (0%Z ≤ o13 ∧ o13 < Z.of_nat (length pass2)) ∧ (length (set_list pass2 (Z.to_nat o13) o11) = length pass2 -> nth_i (set_list pass2 (Z.to_nat o13) o11) = fun_updt (nth_i pass2) o13 o11 -> (∀(o14 : ticket), (let v : Z := tvalue current + 1%Z in tvalue o14 = (if decide (v = n) then 0%Z else v)) -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) (set_list pass2 (Z.to_nat o13) o11) inhabitant = true -> i = tvalue o14) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o10) inhabitant with | Granted t => tvalue t = tvalue o14 ∧ nth (Z.to_nat (tvalue t)) (set_list pass2 (Z.to_nat o13) o11) inhabitant = true | RelSet t => tvalue t = tvalue o14 ∧ ¬ nth (Z.to_nat (tvalue t)) (set_list pass2 (Z.to_nat o13) o11) inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap1 inhabitant ∧ nth (Z.to_nat i) tmap1 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o10) inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o10) inhabitant))) tmap1 inhabitant = i) ∧ (model next < tvalue o14 -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue o14 ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o10) inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue o14 -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o10) inhabitant))) ∧ (tvalue o14 < model next -> (∀(i : Z), tvalue o14 ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o10) inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue o14 ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o10) inhabitant))) ∧ (model next = tvalue o14 -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o10) inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o10) inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) (set_list state1 (Z.to_nat id1) o10) inhabitant with | Granted x => (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o10) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o10) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end)))))))) | Released told => (∀(o10 : bool), if decide (o10 = true) then ∀(ticket2 : ticket), tvalue ticket2 = model next -> (let o11 : Z := tvalue ticket2 in (0%Z ≤ o11 ∧ o11 < Z.of_nat (length tmap1)) ∧ (let id2 : Z := nth (Z.to_nat o11) tmap1 inhabitant in (0%Z ≤ id2 ∧ id2 < Z.of_nat (length state1)) ∧ (match nth (Z.to_nat id2) state1 inhabitant with | Released _ => (let o12 : thread_state := Released told in (0%Z ≤ id2 ∧ id2 < Z.of_nat (length state1)) ∧ (length (set_list state1 (Z.to_nat id2) o12) = length state1 -> nth_i (set_list state1 (Z.to_nat id2) o12) = fun_updt (nth_i state1) id2 o12 -> (let o13 : Z := tvalue ticket2 in (0%Z ≤ o13 ∧ o13 < Z.of_nat (length tmap1)) ∧ (length (set_list tmap1 (Z.to_nat o13) id1) = length tmap1 -> nth_i (set_list tmap1 (Z.to_nat o13) id1) = fun_updt (nth_i tmap1) o13 id1 -> (let o14 : Z := tvalue told in (0%Z ≤ o14 ∧ o14 < Z.of_nat (length (set_list tmap1 (Z.to_nat o13) id1))) ∧ (length (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) = length (set_list tmap1 (Z.to_nat o13) id1) -> nth_i (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) = fun_updt (nth_i (set_list tmap1 (Z.to_nat o13) id1)) o14 id2 -> (let o15 : thread_state := AcqFetched ticket2 in (0%Z ≤ id1 ∧ id1 < Z.of_nat (length (set_list state1 (Z.to_nat id2) o12))) ∧ (length (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) = length (set_list state1 (Z.to_nat id2) o12) -> nth_i (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) = fun_updt (nth_i (set_list state1 (Z.to_nat id2) o12)) id1 o15 -> (∀(o16 : bounded_int2), (let v : Z := model next + 1%Z in model o16 = (if decide (v = n) then 0%Z else v)) -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass2 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant ∧ nth (Z.to_nat i) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant))) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant = i) ∧ (model o16 < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model o16 ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant)) ∧ (∀(i : Z), model o16 ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant))) ∧ (tvalue current < model o16 -> (∀(i : Z), tvalue current ≤ i ∧ i < model o16 -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model o16 ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant))) ∧ (model o16 = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant with | Granted x => (match nth (Z.to_nat i) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))))))))))) | _ => False end))) else (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass2 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state1 inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass2 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap1 inhabitant ∧ nth (Z.to_nat i) tmap1 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state1 inhabitant))) tmap1 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap1 inhabitant)) state1 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state1 inhabitant with | Granted x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))) end)))))))) ∧ (o8 + 1%Z < 1%Z -> (let o9 : bool := true in (0%Z ≤ 0%Z ∧ 0%Z < Z.of_nat (length pass)) ∧ (length (set_list pass 0%nat o9) = length pass -> nth_i (set_list pass 0%nat o9) = fun_updt (nth_i pass) 0%Z o9 -> ((∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) (set_list pass 0%nat o9) inhabitant = true -> i = tvalue o7) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state inhabitant with | Granted t => tvalue t = tvalue o7 ∧ nth (Z.to_nat (tvalue t)) (set_list pass 0%nat o9) inhabitant = true | RelSet t => tvalue t = tvalue o7 ∧ ¬ nth (Z.to_nat (tvalue t)) (set_list pass 0%nat o9) inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap inhabitant ∧ nth (Z.to_nat i) tmap inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap inhabitant)) state inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state inhabitant))) tmap inhabitant = i) ∧ (model o1 < tvalue o7 -> (∀(i : Z), 0%Z ≤ i ∧ i < model o1 ∨ tvalue o7 ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap inhabitant)) state inhabitant)) ∧ (∀(i : Z), model o1 ≤ i ∧ i < tvalue o7 -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap inhabitant)) state inhabitant))) ∧ (tvalue o7 < model o1 -> (∀(i : Z), tvalue o7 ≤ i ∧ i < model o1 -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap inhabitant)) state inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue o7 ∨ model o1 ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap inhabitant)) state inhabitant))) ∧ (model o1 = tvalue o7 -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap inhabitant)) state inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap inhabitant)) state inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state inhabitant with | Granted x => (match nth (Z.to_nat i) state inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))) ∧ (∀(current : ticket) (tmap1 : list Z) (state1 : list thread_state) (next : bounded_int2) (pass1 : list bool), length tmap1 = length tmap -> length state1 = length state -> length pass1 = length (set_list pass 0%nat o9) -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass1 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state1 inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap1 inhabitant ∧ nth (Z.to_nat i) tmap1 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state1 inhabitant))) tmap1 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap1 inhabitant)) state1 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state1 inhabitant with | Granted x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end)) -> (∀(id1 : Z), 0%Z ≤ id1 ∧ id1 < n -> (0%Z ≤ id1 ∧ id1 < Z.of_nat (length state1)) ∧ (match nth (Z.to_nat id1) state1 inhabitant with | AcqFetched ticket2 => (let o10 : Z := tvalue ticket2 in (0%Z ≤ o10 ∧ o10 < Z.of_nat (length pass1)) ∧ (if decide (nth (Z.to_nat o10) pass1 inhabitant = true) then let o11 : thread_state := Granted ticket2 in (0%Z ≤ id1 ∧ id1 < Z.of_nat (length state1)) ∧ (length (set_list state1 (Z.to_nat id1) o11) = length state1 -> nth_i (set_list state1 (Z.to_nat id1) o11) = fun_updt (nth_i state1) id1 o11 -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass1 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o11) inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap1 inhabitant ∧ nth (Z.to_nat i) tmap1 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o11) inhabitant))) tmap1 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) (set_list state1 (Z.to_nat id1) o11) inhabitant with | Granted x => (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o11) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o11) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))) else (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass1 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state1 inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap1 inhabitant ∧ nth (Z.to_nat i) tmap1 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state1 inhabitant))) tmap1 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap1 inhabitant)) state1 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state1 inhabitant with | Granted x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end)))) | Granted ticket2 => (∀(o10 : bool), if decide (o10 = true) then let o11 : thread_state := RelSet ticket2 in (0%Z ≤ id1 ∧ id1 < Z.of_nat (length state1)) ∧ (length (set_list state1 (Z.to_nat id1) o11) = length state1 -> nth_i (set_list state1 (Z.to_nat id1) o11) = fun_updt (nth_i state1) id1 o11 -> (let o12 : bool := false in let o13 : Z := tvalue ticket2 in (0%Z ≤ o13 ∧ o13 < Z.of_nat (length pass1)) ∧ (length (set_list pass1 (Z.to_nat o13) o12) = length pass1 -> nth_i (set_list pass1 (Z.to_nat o13) o12) = fun_updt (nth_i pass1) o13 o12 -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) (set_list pass1 (Z.to_nat o13) o12) inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o11) inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) (set_list pass1 (Z.to_nat o13) o12) inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) (set_list pass1 (Z.to_nat o13) o12) inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap1 inhabitant ∧ nth (Z.to_nat i) tmap1 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o11) inhabitant))) tmap1 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o11) inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) (set_list state1 (Z.to_nat id1) o11) inhabitant with | Granted x => (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o11) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o11) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))))) else (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass1 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state1 inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap1 inhabitant ∧ nth (Z.to_nat i) tmap1 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state1 inhabitant))) tmap1 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap1 inhabitant)) state1 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state1 inhabitant with | Granted x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))) | RelSet ticket2 => (let o10 : thread_state := Released ticket2 in (0%Z ≤ id1 ∧ id1 < Z.of_nat (length state1)) ∧ (length (set_list state1 (Z.to_nat id1) o10) = length state1 -> nth_i (set_list state1 (Z.to_nat id1) o10) = fun_updt (nth_i state1) id1 o10 -> (let o11 : bool := true in ∀(o12 : ticket), (let v : Z := tvalue ticket2 + 1%Z in tvalue o12 = (if decide (v = n) then 0%Z else v)) -> (let o13 : Z := tvalue o12 in (0%Z ≤ o13 ∧ o13 < Z.of_nat (length pass1)) ∧ (length (set_list pass1 (Z.to_nat o13) o11) = length pass1 -> nth_i (set_list pass1 (Z.to_nat o13) o11) = fun_updt (nth_i pass1) o13 o11 -> (∀(o14 : ticket), (let v : Z := tvalue current + 1%Z in tvalue o14 = (if decide (v = n) then 0%Z else v)) -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) (set_list pass1 (Z.to_nat o13) o11) inhabitant = true -> i = tvalue o14) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o10) inhabitant with | Granted t => tvalue t = tvalue o14 ∧ nth (Z.to_nat (tvalue t)) (set_list pass1 (Z.to_nat o13) o11) inhabitant = true | RelSet t => tvalue t = tvalue o14 ∧ ¬ nth (Z.to_nat (tvalue t)) (set_list pass1 (Z.to_nat o13) o11) inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap1 inhabitant ∧ nth (Z.to_nat i) tmap1 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o10) inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o10) inhabitant))) tmap1 inhabitant = i) ∧ (model next < tvalue o14 -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue o14 ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o10) inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue o14 -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o10) inhabitant))) ∧ (tvalue o14 < model next -> (∀(i : Z), tvalue o14 ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o10) inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue o14 ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o10) inhabitant))) ∧ (model next = tvalue o14 -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o10) inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap1 inhabitant)) (set_list state1 (Z.to_nat id1) o10) inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) (set_list state1 (Z.to_nat id1) o10) inhabitant with | Granted x => (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o10) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) (set_list state1 (Z.to_nat id1) o10) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end)))))))) | Released told => (∀(o10 : bool), if decide (o10 = true) then ∀(ticket2 : ticket), tvalue ticket2 = model next -> (let o11 : Z := tvalue ticket2 in (0%Z ≤ o11 ∧ o11 < Z.of_nat (length tmap1)) ∧ (let id2 : Z := nth (Z.to_nat o11) tmap1 inhabitant in (0%Z ≤ id2 ∧ id2 < Z.of_nat (length state1)) ∧ (match nth (Z.to_nat id2) state1 inhabitant with | Released _ => (let o12 : thread_state := Released told in (0%Z ≤ id2 ∧ id2 < Z.of_nat (length state1)) ∧ (length (set_list state1 (Z.to_nat id2) o12) = length state1 -> nth_i (set_list state1 (Z.to_nat id2) o12) = fun_updt (nth_i state1) id2 o12 -> (let o13 : Z := tvalue ticket2 in (0%Z ≤ o13 ∧ o13 < Z.of_nat (length tmap1)) ∧ (length (set_list tmap1 (Z.to_nat o13) id1) = length tmap1 -> nth_i (set_list tmap1 (Z.to_nat o13) id1) = fun_updt (nth_i tmap1) o13 id1 -> (let o14 : Z := tvalue told in (0%Z ≤ o14 ∧ o14 < Z.of_nat (length (set_list tmap1 (Z.to_nat o13) id1))) ∧ (length (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) = length (set_list tmap1 (Z.to_nat o13) id1) -> nth_i (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) = fun_updt (nth_i (set_list tmap1 (Z.to_nat o13) id1)) o14 id2 -> (let o15 : thread_state := AcqFetched ticket2 in (0%Z ≤ id1 ∧ id1 < Z.of_nat (length (set_list state1 (Z.to_nat id2) o12))) ∧ (length (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) = length (set_list state1 (Z.to_nat id2) o12) -> nth_i (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) = fun_updt (nth_i (set_list state1 (Z.to_nat id2) o12)) id1 o15 -> (∀(o16 : bounded_int2), (let v : Z := model next + 1%Z in model o16 = (if decide (v = n) then 0%Z else v)) -> (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass1 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant ∧ nth (Z.to_nat i) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant))) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant = i) ∧ (model o16 < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model o16 ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant)) ∧ (∀(i : Z), model o16 ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant))) ∧ (tvalue current < model o16 -> (∀(i : Z), tvalue current ≤ i ∧ i < model o16 -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model o16 ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant))) ∧ (model o16 = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) (set_list (set_list tmap1 (Z.to_nat o13) id1) (Z.to_nat o14) id2) inhabitant)) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant with | Granted x => (match nth (Z.to_nat i) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) (set_list (set_list state1 (Z.to_nat id2) o12) (Z.to_nat id1) o15) inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))))))))))) | _ => False end))) else (∀(i : Z), (0%Z ≤ i ∧ i < n) ∧ nth (Z.to_nat i) pass1 inhabitant = true -> i = tvalue current) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> (match nth (Z.to_nat i) state1 inhabitant with | Granted t => tvalue t = tvalue current ∧ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | RelSet t => tvalue t = tvalue current ∧ ¬ nth (Z.to_nat (tvalue t)) pass1 inhabitant = true | _ => True end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> 0%Z ≤ nth (Z.to_nat i) tmap1 inhabitant ∧ nth (Z.to_nat i) tmap1 inhabitant < n) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> ticket1 (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat (ticket1 (nth (Z.to_nat i) state1 inhabitant))) tmap1 inhabitant = i) ∧ (model next < tvalue current -> (∀(i : Z), 0%Z ≤ i ∧ i < model next ∨ tvalue current ≤ i ∧ i < n -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), model next ≤ i ∧ i < tvalue current -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (tvalue current < model next -> (∀(i : Z), tvalue current ≤ i ∧ i < model next -> ¬ released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < tvalue current ∨ model next ≤ i ∧ i < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant))) ∧ (model next = tvalue current -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> released (nth (Z.to_nat (nth (Z.to_nat i) tmap1 inhabitant)) state1 inhabitant) = released (nth (Z.to_nat (nth (Z.to_nat j) tmap1 inhabitant)) state1 inhabitant))) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < n -> (match nth (Z.to_nat j) state1 inhabitant with | Granted x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | RelSet x => (match nth (Z.to_nat i) state1 inhabitant with | Granted x1 => False | RelSet x1 => False | _ => True end) | _ => True end))) end)))))))))))))))))).
Admitted.
