theory verifythis_2018_array_based_queuing_lock_2_ABQL_mainqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.int_NumOf" "Why3STD.queue_Queue"
begin
consts n :: "int"
axiomatization where N_val:   "(2 :: int) \<le> n"
consts k :: "int"
axiomatization where K_val:   "(2 :: int) \<le> k"
typedecl  tick
consts b :: "tick \<Rightarrow> int"
consts v :: "tick \<Rightarrow> int"
axiomatization where tick'invariant'0:   "(0 :: int) \<le> v self"
  for self :: "tick"
axiomatization where tick'invariant'1:   "(0 :: int) \<le> b self"
  for self :: "tick"
axiomatization where tick'invariant'2:   "b self < k * n"
  for self :: "tick"
axiomatization where tick'invariant'3:   "b self = v self emod (k * n)"
  for self :: "tick"
definition tick'eq :: "tick \<Rightarrow> tick \<Rightarrow> _"
  where "tick'eq a b1 \<longleftrightarrow> b a = b b1 \<and> v a = v b1" for a b1
axiomatization where tick'inj:   "a = b1"
 if "tick'eq a b1"
  for a :: "tick"
  and b1 :: "tick"
definition lt :: "tick \<Rightarrow> tick \<Rightarrow> _"
  where "lt tick1 tick2 \<longleftrightarrow> v tick1 < v tick2" for tick1 tick2
definition sorted :: "tick list \<Rightarrow> _"
  where "sorted s \<longleftrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < int (length s) \<longrightarrow> lt (s ! nat i) (s ! nat j))" for s
definition consecutive :: "tick list \<Rightarrow> _"
  where "consecutive l \<longleftrightarrow> (\<forall>(i :: int). (0 :: int) < i \<and> i < int (length l) \<longrightarrow> v (l ! nat i) = v (l ! nat (i - (1 :: int))) + (1 :: int))" for l
definition last :: "tick list \<Rightarrow> tick option"
  where "last l = (if int (length l) = (0 :: int) then None else Some (l ! nat (int (length l) - (1 :: int))))" for l
definition hd :: "tick list \<Rightarrow> tick option"
  where "hd l = (if int (length l) = (0 :: int) then None else Some (l ! (0 :: nat)))" for l
datatype  pc = A1 | A2 | A3 | R1 | R2 | I | W
definition has_ticket :: "pc \<Rightarrow> _"
  where "has_ticket pc1 \<longleftrightarrow> (case pc1 of A1 \<Rightarrow> False | I \<Rightarrow> False | _ \<Rightarrow> True)" for pc1
definition has_lock :: "pc \<Rightarrow> _"
  where "has_lock pc1 \<longleftrightarrow> (case pc1 of A3 \<Rightarrow> True | W \<Rightarrow> True | R1 \<Rightarrow> True | R2 \<Rightarrow> True | _ \<Rightarrow> False)" for pc1
typedecl  nondet_source
typedecl  rng
consts source :: "rng \<Rightarrow> nondet_source"
consts fc :: "'a list \<Rightarrow> 'a \<Rightarrow> int \<Rightarrow> bool"
axiomatization where fc'def:   "fc a v1 i = True \<longleftrightarrow> a ! nat i = v1"
  for a :: "'a list"
  and v1 :: "'a"
  and i :: "int"
theorem main'vc:
  shows "let o1 :: int = k * n in (0 :: int) \<le> o1 \<and> (\<forall>(pass :: bool list). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < o1 \<longrightarrow> pass ! nat i = False) \<and> int (length pass) = o1 \<longrightarrow> (let o2 :: bool = True in ((0 :: int) \<le> (0 :: int) \<and> (0 :: int) < int (length pass)) \<and> (length (pass[nat (0 :: int) := o2]) = length pass \<longrightarrow> nth (pass[nat (0 :: int) := o2]) o nat = (nth pass o nat)(0 :: int := o2) \<longrightarrow> ((0 :: int) \<le> (0 :: int) \<and> ((0 :: int) \<le> (0 :: int) \<and> (0 :: int) < k * n) \<and> (0 :: int) = (0 :: int) emod (k * n)) \<and> (\<forall>(o3 :: tick). b o3 = (0 :: int) \<and> v o3 = (0 :: int) \<longrightarrow> (let o4 :: int = n in (0 :: int) \<le> o4 \<and> (\<forall>(pcs :: pc list). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < o4 \<longrightarrow> pcs ! nat i = I) \<and> int (length pcs) = o4 \<longrightarrow> (let o5 :: int = n in (0 :: int) \<le> o5 \<and> (\<forall>(memo :: tick option list). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < o5 \<longrightarrow> memo ! nat i = None) \<and> int (length memo) = o5 \<longrightarrow> (let o6 :: int = k * n in (0 :: int) \<le> o6 \<and> (\<forall>(owners :: int option list). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < o6 \<longrightarrow> owners ! nat i = None) \<and> int (length owners) = o6 \<longrightarrow> (\<forall>(waiting_list :: tick t). seq waiting_list = [] \<longrightarrow> ((\<forall>(th :: int). (0 :: int) \<le> th \<and> th < n \<longrightarrow> \<not>th = -(1 :: int) \<longrightarrow> \<not>has_lock (pcs ! nat th)) \<and> (-(1 :: int) \<le> -(1 :: int) \<and> -(1 :: int) < n) \<and> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (case owners ! nat b1 of None \<Rightarrow> True | Some th \<Rightarrow> ((0 :: int) \<le> th \<and> th < n) \<and> (case memo ! nat th of None \<Rightarrow> False | Some tick1 \<Rightarrow> b tick1 = b1))) \<and> (\<forall>(tick1 :: tick). pass[nat (0 :: int) := o2] ! nat (b tick1) = True \<longrightarrow> (case owners ! nat (b tick1) of None \<Rightarrow> True | Some th \<Rightarrow> True)) \<and> ((0 :: int) \<le> -(1 :: int) \<and> -(1 :: int) < n \<longrightarrow> (case pcs ! nat (-(1 :: int)) of A3 \<Rightarrow> (case memo ! nat (-(1 :: int)) of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass[nat (0 :: int) := o2] ! nat (b tick1) = True) | W \<Rightarrow> (case memo ! nat (-(1 :: int)) of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass[nat (0 :: int) := o2] ! nat (b tick1) = True) | R1 \<Rightarrow> (case memo ! nat (-(1 :: int)) of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass[nat (0 :: int) := o2] ! nat (b tick1) = True) | R2 \<Rightarrow> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> \<not>pass[nat (0 :: int) := o2] ! nat b1 = True) | _ \<Rightarrow> False)) \<and> (\<forall>(b1 :: int) (b2 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (0 :: int) \<le> b2 \<and> b2 < k * n \<longrightarrow> pass[nat (0 :: int) := o2] ! nat b1 = True \<and> pass[nat (0 :: int) := o2] ! nat b2 = True \<longrightarrow> b1 = b2) \<and> ((0 :: int) \<le> -(1 :: int) \<and> -(1 :: int) < n \<longrightarrow> has_lock (pcs ! nat (-(1 :: int))) \<and> (case memo ! nat (-(1 :: int)) of None \<Rightarrow> False | Some tick1 \<Rightarrow> False)) \<and> (\<forall>(th :: int). (0 :: int) \<le> th \<and> th < n \<longrightarrow> (case memo ! nat th of Some tick1 \<Rightarrow> owners ! nat (b tick1) = Some th | None \<Rightarrow> True)) \<and> (\<forall>(th :: int). (0 :: int) \<le> th \<and> th < n \<longrightarrow> \<not>memo ! nat th = None \<longleftrightarrow> has_ticket (pcs ! nat th)) \<and> (\<forall>(tick1 :: tick). tick1 \<in> set (seq waiting_list) \<longrightarrow> (case owners ! nat (b tick1) of None \<Rightarrow> False | Some th \<Rightarrow> pcs ! nat th = A2 \<and> memo ! nat th = Some tick1)) \<and> (\<forall>(th :: int). (0 :: int) \<le> th \<and> th < n \<longrightarrow> (case memo ! nat th of Some tick1 \<Rightarrow> tick1 \<in> set (seq waiting_list) | None \<Rightarrow> True)) \<and> (\<forall>(th :: int). (0 :: int) \<le> th \<and> th < n \<longrightarrow> \<not>has_lock (pcs ! nat th) \<longrightarrow> (case memo ! nat th of None \<Rightarrow> \<not>pcs ! nat th = A2 | Some tick1 \<Rightarrow> tick1 \<in> set (seq waiting_list))) \<and> consecutive (seq waiting_list) \<and> length (seq waiting_list) = count_list (drop (0 :: nat) (take (nat n - (0 :: nat)) pcs)) A2 \<and> (\<forall>(tick1 :: tick). tick1 \<in> set (seq waiting_list) \<longrightarrow> v o3 - int (length (seq waiting_list)) \<le> v tick1 \<and> v tick1 < v o3) \<and> (case last (seq waiting_list) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v o3 - (1 :: int)) \<and> (case hd (seq waiting_list) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v o3 - int (length (seq waiting_list))) \<and> ((0 :: int) \<le> int (length (seq waiting_list)) \<and> int (length (seq waiting_list)) \<le> n) \<and> (\<not>int (length (seq waiting_list)) = (0 :: int) \<and> pass[nat (0 :: int) := o2] ! nat (b (seq waiting_list ! (0 :: nat))) = True \<or> (\<exists>(th :: int). ((0 :: int) \<le> th \<and> th < n) \<and> memo ! nat th = None \<and> pass[nat (0 :: int) := o2] ! nat (b o3) = True) \<and> seq waiting_list = [])) \<and> (\<forall>(active_tick :: tick option) (waiting_list1 :: tick t) (lock_holder :: int) (owners1 :: int option list) (memo1 :: tick option list) (pcs1 :: pc list) (next :: tick) (pass1 :: bool list). length owners1 = length owners \<longrightarrow> length memo1 = length memo \<longrightarrow> length pcs1 = length pcs \<longrightarrow> length pass1 = length (pass[nat (0 :: int) := o2]) \<longrightarrow> (\<forall>(th :: int). (0 :: int) \<le> th \<and> th < n \<longrightarrow> \<not>th = lock_holder \<longrightarrow> \<not>has_lock (pcs1 ! nat th)) \<and> (-(1 :: int) \<le> lock_holder \<and> lock_holder < n) \<and> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (case owners1 ! nat b1 of None \<Rightarrow> True | Some th \<Rightarrow> ((0 :: int) \<le> th \<and> th < n) \<and> (case memo1 ! nat th of None \<Rightarrow> False | Some tick1 \<Rightarrow> b tick1 = b1))) \<and> (\<forall>(tick1 :: tick). pass1 ! nat (b tick1) = True \<longrightarrow> (case owners1 ! nat (b tick1) of None \<Rightarrow> lock_holder = -(1 :: int) | Some th \<Rightarrow> lock_holder = -(1 :: int) \<or> lock_holder = th)) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n \<longrightarrow> (case pcs1 ! nat lock_holder of A3 \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass1 ! nat (b tick1) = True) | W \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass1 ! nat (b tick1) = True) | R1 \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass1 ! nat (b tick1) = True) | R2 \<Rightarrow> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> \<not>pass1 ! nat b1 = True) | _ \<Rightarrow> False)) \<and> (\<forall>(b1 :: int) (b2 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (0 :: int) \<le> b2 \<and> b2 < k * n \<longrightarrow> pass1 ! nat b1 = True \<and> pass1 ! nat b2 = True \<longrightarrow> b1 = b2) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n \<longrightarrow> has_lock (pcs1 ! nat lock_holder) \<and> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> active_tick = Some tick1)) \<and> (\<forall>(th :: int). (0 :: int) \<le> th \<and> th < n \<longrightarrow> (case memo1 ! nat th of Some tick1 \<Rightarrow> owners1 ! nat (b tick1) = Some th | None \<Rightarrow> True)) \<and> (\<forall>(th :: int). (0 :: int) \<le> th \<and> th < n \<longrightarrow> \<not>memo1 ! nat th = None \<longleftrightarrow> has_ticket (pcs1 ! nat th)) \<and> (\<forall>(tick1 :: tick). tick1 \<in> set (seq waiting_list1) \<longrightarrow> (case owners1 ! nat (b tick1) of None \<Rightarrow> False | Some th \<Rightarrow> pcs1 ! nat th = A2 \<and> memo1 ! nat th = Some tick1)) \<and> (\<forall>(th :: int). (0 :: int) \<le> th \<and> th < n \<longrightarrow> (case memo1 ! nat th of Some tick1 \<Rightarrow> tick1 \<in> set (seq waiting_list1) \<or> active_tick = Some tick1 | None \<Rightarrow> True)) \<and> (\<forall>(th :: int). (0 :: int) \<le> th \<and> th < n \<longrightarrow> \<not>has_lock (pcs1 ! nat th) \<longrightarrow> (case memo1 ! nat th of None \<Rightarrow> \<not>pcs1 ! nat th = A2 | Some tick1 \<Rightarrow> tick1 \<in> set (seq waiting_list1))) \<and> consecutive (seq waiting_list1) \<and> length (seq waiting_list1) = count_list (drop (0 :: nat) (take (nat n - (0 :: nat)) pcs1)) A2 \<and> (\<forall>(tick1 :: tick). tick1 \<in> set (seq waiting_list1) \<longrightarrow> v next - int (length (seq waiting_list1)) \<le> v tick1 \<and> v tick1 < v next) \<and> (case last (seq waiting_list1) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next - (1 :: int)) \<and> (case hd (seq waiting_list1) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next - int (length (seq waiting_list1))) \<and> (case active_tick of None \<Rightarrow> lock_holder = -(1 :: int) | Some tick1 \<Rightarrow> (case hd (seq waiting_list1) of None \<Rightarrow> v next = v tick1 + (1 :: int) | Some t \<Rightarrow> v t = v tick1 + (1 :: int)) \<and> v tick1 = v next - int (length (seq waiting_list1)) - (1 :: int) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n) \<and> memo1 ! nat lock_holder = Some tick1) \<and> ((0 :: int) \<le> int (length (seq waiting_list1)) \<and> int (length (seq waiting_list1)) \<le> n) \<and> (lock_holder = -(1 :: int) \<longrightarrow> \<not>int (length (seq waiting_list1)) = (0 :: int) \<and> pass1 ! nat (b (seq waiting_list1 ! (0 :: nat))) = True \<or> (\<exists>(th :: int). ((0 :: int) \<le> th \<and> th < n) \<and> memo1 ! nat th = None \<and> pass1 ! nat (b next) = True) \<and> seq waiting_list1 = []) \<longrightarrow> (\<forall>(th :: int). (0 :: int) \<le> th \<and> th < n \<longrightarrow> ((0 :: int) \<le> th \<and> th < int (length pcs1)) \<and> (case pcs1 ! nat th of I \<Rightarrow> (let o7 :: pc = A1 in ((0 :: int) \<le> th \<and> th < int (length pcs1)) \<and> (length (pcs1[nat th := o7]) = length pcs1 \<longrightarrow> nth (pcs1[nat th := o7]) o nat = (nth pcs1 o nat)(th := o7) \<longrightarrow> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>th1 = lock_holder \<longrightarrow> \<not>has_lock (pcs1[nat th := o7] ! nat th1)) \<and> (-(1 :: int) \<le> lock_holder \<and> lock_holder < n) \<and> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (case owners1 ! nat b1 of None \<Rightarrow> True | Some th1 \<Rightarrow> ((0 :: int) \<le> th1 \<and> th1 < n) \<and> (case memo1 ! nat th1 of None \<Rightarrow> False | Some tick1 \<Rightarrow> b tick1 = b1))) \<and> (\<forall>(tick1 :: tick). pass1 ! nat (b tick1) = True \<longrightarrow> (case owners1 ! nat (b tick1) of None \<Rightarrow> lock_holder = -(1 :: int) | Some th1 \<Rightarrow> lock_holder = -(1 :: int) \<or> lock_holder = th1)) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n \<longrightarrow> (case pcs1[nat th := o7] ! nat lock_holder of A3 \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass1 ! nat (b tick1) = True) | W \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass1 ! nat (b tick1) = True) | R1 \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass1 ! nat (b tick1) = True) | R2 \<Rightarrow> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> \<not>pass1 ! nat b1 = True) | _ \<Rightarrow> False)) \<and> (\<forall>(b1 :: int) (b2 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (0 :: int) \<le> b2 \<and> b2 < k * n \<longrightarrow> pass1 ! nat b1 = True \<and> pass1 ! nat b2 = True \<longrightarrow> b1 = b2) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n \<longrightarrow> has_lock (pcs1[nat th := o7] ! nat lock_holder) \<and> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> active_tick = Some tick1)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> (case memo1 ! nat th1 of Some tick1 \<Rightarrow> owners1 ! nat (b tick1) = Some th1 | None \<Rightarrow> True)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>memo1 ! nat th1 = None \<longleftrightarrow> has_ticket (pcs1[nat th := o7] ! nat th1)) \<and> (\<forall>(tick1 :: tick). tick1 \<in> set (seq waiting_list1) \<longrightarrow> (case owners1 ! nat (b tick1) of None \<Rightarrow> False | Some th1 \<Rightarrow> pcs1[nat th := o7] ! nat th1 = A2 \<and> memo1 ! nat th1 = Some tick1)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> (case memo1 ! nat th1 of Some tick1 \<Rightarrow> tick1 \<in> set (seq waiting_list1) \<or> active_tick = Some tick1 | None \<Rightarrow> True)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>has_lock (pcs1[nat th := o7] ! nat th1) \<longrightarrow> (case memo1 ! nat th1 of None \<Rightarrow> \<not>pcs1[nat th := o7] ! nat th1 = A2 | Some tick1 \<Rightarrow> tick1 \<in> set (seq waiting_list1))) \<and> consecutive (seq waiting_list1) \<and> length (seq waiting_list1) = count_list (drop (0 :: nat) (take (nat n - (0 :: nat)) (pcs1[nat th := o7]))) A2 \<and> (\<forall>(tick1 :: tick). tick1 \<in> set (seq waiting_list1) \<longrightarrow> v next - int (length (seq waiting_list1)) \<le> v tick1 \<and> v tick1 < v next) \<and> (case last (seq waiting_list1) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next - (1 :: int)) \<and> (case hd (seq waiting_list1) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next - int (length (seq waiting_list1))) \<and> (case active_tick of None \<Rightarrow> lock_holder = -(1 :: int) | Some tick1 \<Rightarrow> (case hd (seq waiting_list1) of None \<Rightarrow> v next = v tick1 + (1 :: int) | Some t \<Rightarrow> v t = v tick1 + (1 :: int)) \<and> v tick1 = v next - int (length (seq waiting_list1)) - (1 :: int) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n) \<and> memo1 ! nat lock_holder = Some tick1) \<and> ((0 :: int) \<le> int (length (seq waiting_list1)) \<and> int (length (seq waiting_list1)) \<le> n) \<and> (lock_holder = -(1 :: int) \<longrightarrow> \<not>int (length (seq waiting_list1)) = (0 :: int) \<and> pass1 ! nat (b (seq waiting_list1 ! (0 :: nat))) = True \<or> (\<exists>(th1 :: int). ((0 :: int) \<le> th1 \<and> th1 < n) \<and> memo1 ! nat th1 = None \<and> pass1 ! nat (b next) = True) \<and> seq waiting_list1 = []))) | A1 \<Rightarrow> (\<forall>(next1 :: tick). v next1 = v next + (1 :: int) \<longrightarrow> (let o7 :: int option = Some th; o8 :: int = b next in ((0 :: int) \<le> o8 \<and> o8 < int (length owners1)) \<and> (length (owners1[nat o8 := o7]) = length owners1 \<longrightarrow> nth (owners1[nat o8 := o7]) o nat = (nth owners1 o nat)(o8 := o7) \<longrightarrow> (let o9 :: tick option = Some next in ((0 :: int) \<le> th \<and> th < int (length memo1)) \<and> (length (memo1[nat th := o9]) = length memo1 \<longrightarrow> nth (memo1[nat th := o9]) o nat = (nth memo1 o nat)(th := o9) \<longrightarrow> (let o10 :: pc = A2 in ((0 :: int) \<le> th \<and> th < int (length pcs1)) \<and> (length (pcs1[nat th := o10]) = length pcs1 \<longrightarrow> nth (pcs1[nat th := o10]) o nat = (nth pcs1 o nat)(th := o10) \<longrightarrow> (\<forall>(waiting_list2 :: tick t). seq waiting_list2 = seq waiting_list1 @ [next] \<longrightarrow> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>th1 = lock_holder \<longrightarrow> \<not>has_lock (pcs1[nat th := o10] ! nat th1)) \<and> (-(1 :: int) \<le> lock_holder \<and> lock_holder < n) \<and> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (case owners1[nat o8 := o7] ! nat b1 of None \<Rightarrow> True | Some th1 \<Rightarrow> ((0 :: int) \<le> th1 \<and> th1 < n) \<and> (case memo1[nat th := o9] ! nat th1 of None \<Rightarrow> False | Some tick1 \<Rightarrow> b tick1 = b1))) \<and> (\<forall>(tick1 :: tick). pass1 ! nat (b tick1) = True \<longrightarrow> (case owners1[nat o8 := o7] ! nat (b tick1) of None \<Rightarrow> lock_holder = -(1 :: int) | Some th1 \<Rightarrow> lock_holder = -(1 :: int) \<or> lock_holder = th1)) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n \<longrightarrow> (case pcs1[nat th := o10] ! nat lock_holder of A3 \<Rightarrow> (case memo1[nat th := o9] ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass1 ! nat (b tick1) = True) | W \<Rightarrow> (case memo1[nat th := o9] ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass1 ! nat (b tick1) = True) | R1 \<Rightarrow> (case memo1[nat th := o9] ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass1 ! nat (b tick1) = True) | R2 \<Rightarrow> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> \<not>pass1 ! nat b1 = True) | _ \<Rightarrow> False)) \<and> (\<forall>(b1 :: int) (b2 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (0 :: int) \<le> b2 \<and> b2 < k * n \<longrightarrow> pass1 ! nat b1 = True \<and> pass1 ! nat b2 = True \<longrightarrow> b1 = b2) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n \<longrightarrow> has_lock (pcs1[nat th := o10] ! nat lock_holder) \<and> (case memo1[nat th := o9] ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> active_tick = Some tick1)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> (case memo1[nat th := o9] ! nat th1 of Some tick1 \<Rightarrow> owners1[nat o8 := o7] ! nat (b tick1) = Some th1 | None \<Rightarrow> True)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>memo1[nat th := o9] ! nat th1 = None \<longleftrightarrow> has_ticket (pcs1[nat th := o10] ! nat th1)) \<and> (\<forall>(tick1 :: tick). tick1 \<in> set (seq waiting_list2) \<longrightarrow> (case owners1[nat o8 := o7] ! nat (b tick1) of None \<Rightarrow> False | Some th1 \<Rightarrow> pcs1[nat th := o10] ! nat th1 = A2 \<and> memo1[nat th := o9] ! nat th1 = Some tick1)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> (case memo1[nat th := o9] ! nat th1 of Some tick1 \<Rightarrow> tick1 \<in> set (seq waiting_list2) \<or> active_tick = Some tick1 | None \<Rightarrow> True)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>has_lock (pcs1[nat th := o10] ! nat th1) \<longrightarrow> (case memo1[nat th := o9] ! nat th1 of None \<Rightarrow> \<not>pcs1[nat th := o10] ! nat th1 = A2 | Some tick1 \<Rightarrow> tick1 \<in> set (seq waiting_list2))) \<and> consecutive (seq waiting_list2) \<and> length (seq waiting_list2) = count_list (drop (0 :: nat) (take (nat n - (0 :: nat)) (pcs1[nat th := o10]))) A2 \<and> (\<forall>(tick1 :: tick). tick1 \<in> set (seq waiting_list2) \<longrightarrow> v next1 - int (length (seq waiting_list2)) \<le> v tick1 \<and> v tick1 < v next1) \<and> (case last (seq waiting_list2) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next1 - (1 :: int)) \<and> (case hd (seq waiting_list2) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next1 - int (length (seq waiting_list2))) \<and> (case active_tick of None \<Rightarrow> lock_holder = -(1 :: int) | Some tick1 \<Rightarrow> (case hd (seq waiting_list2) of None \<Rightarrow> v next1 = v tick1 + (1 :: int) | Some t \<Rightarrow> v t = v tick1 + (1 :: int)) \<and> v tick1 = v next1 - int (length (seq waiting_list2)) - (1 :: int) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n) \<and> memo1[nat th := o9] ! nat lock_holder = Some tick1) \<and> ((0 :: int) \<le> int (length (seq waiting_list2)) \<and> int (length (seq waiting_list2)) \<le> n) \<and> (lock_holder = -(1 :: int) \<longrightarrow> \<not>int (length (seq waiting_list2)) = (0 :: int) \<and> pass1 ! nat (b (seq waiting_list2 ! (0 :: nat))) = True \<or> (\<exists>(th1 :: int). ((0 :: int) \<le> th1 \<and> th1 < n) \<and> memo1[nat th := o9] ! nat th1 = None \<and> pass1 ! nat (b next1) = True) \<and> seq waiting_list2 = []))))))))) | A2 \<Rightarrow> ((0 :: int) \<le> th \<and> th < int (length memo1)) \<and> (case memo1 ! nat th of None \<Rightarrow> False | Some tick1 \<Rightarrow> (let o7 :: int = b tick1 in ((0 :: int) \<le> o7 \<and> o7 < int (length pass1)) \<and> (if pass1 ! nat o7 = True then let o8 :: pc = A3 in ((0 :: int) \<le> th \<and> th < int (length pcs1)) \<and> (length (pcs1[nat th := o8]) = length pcs1 \<longrightarrow> nth (pcs1[nat th := o8]) o nat = (nth pcs1 o nat)(th := o8) \<longrightarrow> \<not>seq waiting_list1 = [] \<and> (\<forall>(waiting_list2 :: tick t). seq waiting_list2 = drop (1 :: nat) (seq waiting_list1) \<longrightarrow> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>th1 = th \<longrightarrow> \<not>has_lock (pcs1[nat th := o8] ! nat th1)) \<and> (-(1 :: int) \<le> th \<and> th < n) \<and> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (case owners1 ! nat b1 of None \<Rightarrow> True | Some th1 \<Rightarrow> ((0 :: int) \<le> th1 \<and> th1 < n) \<and> (case memo1 ! nat th1 of None \<Rightarrow> False | Some tick2 \<Rightarrow> b tick2 = b1))) \<and> (\<forall>(tick2 :: tick). pass1 ! nat (b tick2) = True \<longrightarrow> (case owners1 ! nat (b tick2) of None \<Rightarrow> th = -(1 :: int) | Some th1 \<Rightarrow> th = -(1 :: int) \<or> th = th1)) \<and> ((0 :: int) \<le> th \<and> th < n \<longrightarrow> (case pcs1[nat th := o8] ! nat th of A3 \<Rightarrow> (case memo1 ! nat th of None \<Rightarrow> False | Some tick2 \<Rightarrow> pass1 ! nat (b tick2) = True) | W \<Rightarrow> (case memo1 ! nat th of None \<Rightarrow> False | Some tick2 \<Rightarrow> pass1 ! nat (b tick2) = True) | R1 \<Rightarrow> (case memo1 ! nat th of None \<Rightarrow> False | Some tick2 \<Rightarrow> pass1 ! nat (b tick2) = True) | R2 \<Rightarrow> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> \<not>pass1 ! nat b1 = True) | _ \<Rightarrow> False)) \<and> (\<forall>(b1 :: int) (b2 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (0 :: int) \<le> b2 \<and> b2 < k * n \<longrightarrow> pass1 ! nat b1 = True \<and> pass1 ! nat b2 = True \<longrightarrow> b1 = b2) \<and> ((0 :: int) \<le> th \<and> th < n \<longrightarrow> has_lock (pcs1[nat th := o8] ! nat th) \<and> (case memo1 ! nat th of None \<Rightarrow> False | Some tick2 \<Rightarrow> Some tick1 = Some tick2)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> (case memo1 ! nat th1 of Some tick2 \<Rightarrow> owners1 ! nat (b tick2) = Some th1 | None \<Rightarrow> True)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>memo1 ! nat th1 = None \<longleftrightarrow> has_ticket (pcs1[nat th := o8] ! nat th1)) \<and> (\<forall>(tick2 :: tick). tick2 \<in> set (seq waiting_list2) \<longrightarrow> (case owners1 ! nat (b tick2) of None \<Rightarrow> False | Some th1 \<Rightarrow> pcs1[nat th := o8] ! nat th1 = A2 \<and> memo1 ! nat th1 = Some tick2)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> (case memo1 ! nat th1 of Some tick2 \<Rightarrow> tick2 \<in> set (seq waiting_list2) \<or> Some tick1 = Some tick2 | None \<Rightarrow> True)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>has_lock (pcs1[nat th := o8] ! nat th1) \<longrightarrow> (case memo1 ! nat th1 of None \<Rightarrow> \<not>pcs1[nat th := o8] ! nat th1 = A2 | Some tick2 \<Rightarrow> tick2 \<in> set (seq waiting_list2))) \<and> consecutive (seq waiting_list2) \<and> length (seq waiting_list2) = count_list (drop (0 :: nat) (take (nat n - (0 :: nat)) (pcs1[nat th := o8]))) A2 \<and> (\<forall>(tick2 :: tick). tick2 \<in> set (seq waiting_list2) \<longrightarrow> v next - int (length (seq waiting_list2)) \<le> v tick2 \<and> v tick2 < v next) \<and> (case last (seq waiting_list2) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next - (1 :: int)) \<and> (case hd (seq waiting_list2) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next - int (length (seq waiting_list2))) \<and> (case Some tick1 of None \<Rightarrow> th = -(1 :: int) | Some tick2 \<Rightarrow> (case hd (seq waiting_list2) of None \<Rightarrow> v next = v tick2 + (1 :: int) | Some t \<Rightarrow> v t = v tick2 + (1 :: int)) \<and> v tick2 = v next - int (length (seq waiting_list2)) - (1 :: int) \<and> ((0 :: int) \<le> th \<and> th < n) \<and> memo1 ! nat th = Some tick2) \<and> ((0 :: int) \<le> int (length (seq waiting_list2)) \<and> int (length (seq waiting_list2)) \<le> n) \<and> (th = -(1 :: int) \<longrightarrow> \<not>int (length (seq waiting_list2)) = (0 :: int) \<and> pass1 ! nat (b (seq waiting_list2 ! (0 :: nat))) = True \<or> (\<exists>(th1 :: int). ((0 :: int) \<le> th1 \<and> th1 < n) \<and> memo1 ! nat th1 = None \<and> pass1 ! nat (b next) = True) \<and> seq waiting_list2 = []))) else (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>th1 = lock_holder \<longrightarrow> \<not>has_lock (pcs1 ! nat th1)) \<and> (-(1 :: int) \<le> lock_holder \<and> lock_holder < n) \<and> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (case owners1 ! nat b1 of None \<Rightarrow> True | Some th1 \<Rightarrow> ((0 :: int) \<le> th1 \<and> th1 < n) \<and> (case memo1 ! nat th1 of None \<Rightarrow> False | Some tick2 \<Rightarrow> b tick2 = b1))) \<and> (\<forall>(tick2 :: tick). pass1 ! nat (b tick2) = True \<longrightarrow> (case owners1 ! nat (b tick2) of None \<Rightarrow> lock_holder = -(1 :: int) | Some th1 \<Rightarrow> lock_holder = -(1 :: int) \<or> lock_holder = th1)) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n \<longrightarrow> (case pcs1 ! nat lock_holder of A3 \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick2 \<Rightarrow> pass1 ! nat (b tick2) = True) | W \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick2 \<Rightarrow> pass1 ! nat (b tick2) = True) | R1 \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick2 \<Rightarrow> pass1 ! nat (b tick2) = True) | R2 \<Rightarrow> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> \<not>pass1 ! nat b1 = True) | _ \<Rightarrow> False)) \<and> (\<forall>(b1 :: int) (b2 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (0 :: int) \<le> b2 \<and> b2 < k * n \<longrightarrow> pass1 ! nat b1 = True \<and> pass1 ! nat b2 = True \<longrightarrow> b1 = b2) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n \<longrightarrow> has_lock (pcs1 ! nat lock_holder) \<and> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick2 \<Rightarrow> active_tick = Some tick2)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> (case memo1 ! nat th1 of Some tick2 \<Rightarrow> owners1 ! nat (b tick2) = Some th1 | None \<Rightarrow> True)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>memo1 ! nat th1 = None \<longleftrightarrow> has_ticket (pcs1 ! nat th1)) \<and> (\<forall>(tick2 :: tick). tick2 \<in> set (seq waiting_list1) \<longrightarrow> (case owners1 ! nat (b tick2) of None \<Rightarrow> False | Some th1 \<Rightarrow> pcs1 ! nat th1 = A2 \<and> memo1 ! nat th1 = Some tick2)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> (case memo1 ! nat th1 of Some tick2 \<Rightarrow> tick2 \<in> set (seq waiting_list1) \<or> active_tick = Some tick2 | None \<Rightarrow> True)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>has_lock (pcs1 ! nat th1) \<longrightarrow> (case memo1 ! nat th1 of None \<Rightarrow> \<not>pcs1 ! nat th1 = A2 | Some tick2 \<Rightarrow> tick2 \<in> set (seq waiting_list1))) \<and> consecutive (seq waiting_list1) \<and> length (seq waiting_list1) = count_list (drop (0 :: nat) (take (nat n - (0 :: nat)) pcs1)) A2 \<and> (\<forall>(tick2 :: tick). tick2 \<in> set (seq waiting_list1) \<longrightarrow> v next - int (length (seq waiting_list1)) \<le> v tick2 \<and> v tick2 < v next) \<and> (case last (seq waiting_list1) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next - (1 :: int)) \<and> (case hd (seq waiting_list1) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next - int (length (seq waiting_list1))) \<and> (case active_tick of None \<Rightarrow> lock_holder = -(1 :: int) | Some tick2 \<Rightarrow> (case hd (seq waiting_list1) of None \<Rightarrow> v next = v tick2 + (1 :: int) | Some t \<Rightarrow> v t = v tick2 + (1 :: int)) \<and> v tick2 = v next - int (length (seq waiting_list1)) - (1 :: int) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n) \<and> memo1 ! nat lock_holder = Some tick2) \<and> ((0 :: int) \<le> int (length (seq waiting_list1)) \<and> int (length (seq waiting_list1)) \<le> n) \<and> (lock_holder = -(1 :: int) \<longrightarrow> \<not>int (length (seq waiting_list1)) = (0 :: int) \<and> pass1 ! nat (b (seq waiting_list1 ! (0 :: nat))) = True \<or> (\<exists>(th1 :: int). ((0 :: int) \<le> th1 \<and> th1 < n) \<and> memo1 ! nat th1 = None \<and> pass1 ! nat (b next) = True) \<and> seq waiting_list1 = [])))) | A3 \<Rightarrow> (let o7 :: pc = W in ((0 :: int) \<le> th \<and> th < int (length pcs1)) \<and> (length (pcs1[nat th := o7]) = length pcs1 \<longrightarrow> nth (pcs1[nat th := o7]) o nat = (nth pcs1 o nat)(th := o7) \<longrightarrow> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>th1 = lock_holder \<longrightarrow> \<not>has_lock (pcs1[nat th := o7] ! nat th1)) \<and> (-(1 :: int) \<le> lock_holder \<and> lock_holder < n) \<and> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (case owners1 ! nat b1 of None \<Rightarrow> True | Some th1 \<Rightarrow> ((0 :: int) \<le> th1 \<and> th1 < n) \<and> (case memo1 ! nat th1 of None \<Rightarrow> False | Some tick1 \<Rightarrow> b tick1 = b1))) \<and> (\<forall>(tick1 :: tick). pass1 ! nat (b tick1) = True \<longrightarrow> (case owners1 ! nat (b tick1) of None \<Rightarrow> lock_holder = -(1 :: int) | Some th1 \<Rightarrow> lock_holder = -(1 :: int) \<or> lock_holder = th1)) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n \<longrightarrow> (case pcs1[nat th := o7] ! nat lock_holder of A3 \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass1 ! nat (b tick1) = True) | W \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass1 ! nat (b tick1) = True) | R1 \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass1 ! nat (b tick1) = True) | R2 \<Rightarrow> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> \<not>pass1 ! nat b1 = True) | _ \<Rightarrow> False)) \<and> (\<forall>(b1 :: int) (b2 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (0 :: int) \<le> b2 \<and> b2 < k * n \<longrightarrow> pass1 ! nat b1 = True \<and> pass1 ! nat b2 = True \<longrightarrow> b1 = b2) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n \<longrightarrow> has_lock (pcs1[nat th := o7] ! nat lock_holder) \<and> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> active_tick = Some tick1)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> (case memo1 ! nat th1 of Some tick1 \<Rightarrow> owners1 ! nat (b tick1) = Some th1 | None \<Rightarrow> True)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>memo1 ! nat th1 = None \<longleftrightarrow> has_ticket (pcs1[nat th := o7] ! nat th1)) \<and> (\<forall>(tick1 :: tick). tick1 \<in> set (seq waiting_list1) \<longrightarrow> (case owners1 ! nat (b tick1) of None \<Rightarrow> False | Some th1 \<Rightarrow> pcs1[nat th := o7] ! nat th1 = A2 \<and> memo1 ! nat th1 = Some tick1)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> (case memo1 ! nat th1 of Some tick1 \<Rightarrow> tick1 \<in> set (seq waiting_list1) \<or> active_tick = Some tick1 | None \<Rightarrow> True)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>has_lock (pcs1[nat th := o7] ! nat th1) \<longrightarrow> (case memo1 ! nat th1 of None \<Rightarrow> \<not>pcs1[nat th := o7] ! nat th1 = A2 | Some tick1 \<Rightarrow> tick1 \<in> set (seq waiting_list1))) \<and> consecutive (seq waiting_list1) \<and> length (seq waiting_list1) = count_list (drop (0 :: nat) (take (nat n - (0 :: nat)) (pcs1[nat th := o7]))) A2 \<and> (\<forall>(tick1 :: tick). tick1 \<in> set (seq waiting_list1) \<longrightarrow> v next - int (length (seq waiting_list1)) \<le> v tick1 \<and> v tick1 < v next) \<and> (case last (seq waiting_list1) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next - (1 :: int)) \<and> (case hd (seq waiting_list1) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next - int (length (seq waiting_list1))) \<and> (case active_tick of None \<Rightarrow> lock_holder = -(1 :: int) | Some tick1 \<Rightarrow> (case hd (seq waiting_list1) of None \<Rightarrow> v next = v tick1 + (1 :: int) | Some t \<Rightarrow> v t = v tick1 + (1 :: int)) \<and> v tick1 = v next - int (length (seq waiting_list1)) - (1 :: int) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n) \<and> memo1 ! nat lock_holder = Some tick1) \<and> ((0 :: int) \<le> int (length (seq waiting_list1)) \<and> int (length (seq waiting_list1)) \<le> n) \<and> (lock_holder = -(1 :: int) \<longrightarrow> \<not>int (length (seq waiting_list1)) = (0 :: int) \<and> pass1 ! nat (b (seq waiting_list1 ! (0 :: nat))) = True \<or> (\<exists>(th1 :: int). ((0 :: int) \<le> th1 \<and> th1 < n) \<and> memo1 ! nat th1 = None \<and> pass1 ! nat (b next) = True) \<and> seq waiting_list1 = []))) | W \<Rightarrow> (let o7 :: pc = R1 in ((0 :: int) \<le> th \<and> th < int (length pcs1)) \<and> (length (pcs1[nat th := o7]) = length pcs1 \<longrightarrow> nth (pcs1[nat th := o7]) o nat = (nth pcs1 o nat)(th := o7) \<longrightarrow> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>th1 = lock_holder \<longrightarrow> \<not>has_lock (pcs1[nat th := o7] ! nat th1)) \<and> (-(1 :: int) \<le> lock_holder \<and> lock_holder < n) \<and> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (case owners1 ! nat b1 of None \<Rightarrow> True | Some th1 \<Rightarrow> ((0 :: int) \<le> th1 \<and> th1 < n) \<and> (case memo1 ! nat th1 of None \<Rightarrow> False | Some tick1 \<Rightarrow> b tick1 = b1))) \<and> (\<forall>(tick1 :: tick). pass1 ! nat (b tick1) = True \<longrightarrow> (case owners1 ! nat (b tick1) of None \<Rightarrow> lock_holder = -(1 :: int) | Some th1 \<Rightarrow> lock_holder = -(1 :: int) \<or> lock_holder = th1)) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n \<longrightarrow> (case pcs1[nat th := o7] ! nat lock_holder of A3 \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass1 ! nat (b tick1) = True) | W \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass1 ! nat (b tick1) = True) | R1 \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> pass1 ! nat (b tick1) = True) | R2 \<Rightarrow> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> \<not>pass1 ! nat b1 = True) | _ \<Rightarrow> False)) \<and> (\<forall>(b1 :: int) (b2 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (0 :: int) \<le> b2 \<and> b2 < k * n \<longrightarrow> pass1 ! nat b1 = True \<and> pass1 ! nat b2 = True \<longrightarrow> b1 = b2) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n \<longrightarrow> has_lock (pcs1[nat th := o7] ! nat lock_holder) \<and> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick1 \<Rightarrow> active_tick = Some tick1)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> (case memo1 ! nat th1 of Some tick1 \<Rightarrow> owners1 ! nat (b tick1) = Some th1 | None \<Rightarrow> True)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>memo1 ! nat th1 = None \<longleftrightarrow> has_ticket (pcs1[nat th := o7] ! nat th1)) \<and> (\<forall>(tick1 :: tick). tick1 \<in> set (seq waiting_list1) \<longrightarrow> (case owners1 ! nat (b tick1) of None \<Rightarrow> False | Some th1 \<Rightarrow> pcs1[nat th := o7] ! nat th1 = A2 \<and> memo1 ! nat th1 = Some tick1)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> (case memo1 ! nat th1 of Some tick1 \<Rightarrow> tick1 \<in> set (seq waiting_list1) \<or> active_tick = Some tick1 | None \<Rightarrow> True)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>has_lock (pcs1[nat th := o7] ! nat th1) \<longrightarrow> (case memo1 ! nat th1 of None \<Rightarrow> \<not>pcs1[nat th := o7] ! nat th1 = A2 | Some tick1 \<Rightarrow> tick1 \<in> set (seq waiting_list1))) \<and> consecutive (seq waiting_list1) \<and> length (seq waiting_list1) = count_list (drop (0 :: nat) (take (nat n - (0 :: nat)) (pcs1[nat th := o7]))) A2 \<and> (\<forall>(tick1 :: tick). tick1 \<in> set (seq waiting_list1) \<longrightarrow> v next - int (length (seq waiting_list1)) \<le> v tick1 \<and> v tick1 < v next) \<and> (case last (seq waiting_list1) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next - (1 :: int)) \<and> (case hd (seq waiting_list1) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next - int (length (seq waiting_list1))) \<and> (case active_tick of None \<Rightarrow> lock_holder = -(1 :: int) | Some tick1 \<Rightarrow> (case hd (seq waiting_list1) of None \<Rightarrow> v next = v tick1 + (1 :: int) | Some t \<Rightarrow> v t = v tick1 + (1 :: int)) \<and> v tick1 = v next - int (length (seq waiting_list1)) - (1 :: int) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n) \<and> memo1 ! nat lock_holder = Some tick1) \<and> ((0 :: int) \<le> int (length (seq waiting_list1)) \<and> int (length (seq waiting_list1)) \<le> n) \<and> (lock_holder = -(1 :: int) \<longrightarrow> \<not>int (length (seq waiting_list1)) = (0 :: int) \<and> pass1 ! nat (b (seq waiting_list1 ! (0 :: nat))) = True \<or> (\<exists>(th1 :: int). ((0 :: int) \<le> th1 \<and> th1 < n) \<and> memo1 ! nat th1 = None \<and> pass1 ! nat (b next) = True) \<and> seq waiting_list1 = []))) | R1 \<Rightarrow> ((0 :: int) \<le> th \<and> th < int (length memo1)) \<and> (case memo1 ! nat th of None \<Rightarrow> False | Some tick1 \<Rightarrow> (let o7 :: bool = False; o8 :: int = b tick1 in ((0 :: int) \<le> o8 \<and> o8 < int (length pass1)) \<and> (length (pass1[nat o8 := o7]) = length pass1 \<longrightarrow> nth (pass1[nat o8 := o7]) o nat = (nth pass1 o nat)(o8 := o7) \<longrightarrow> (let o9 :: pc = R2 in ((0 :: int) \<le> th \<and> th < int (length pcs1)) \<and> (length (pcs1[nat th := o9]) = length pcs1 \<longrightarrow> nth (pcs1[nat th := o9]) o nat = (nth pcs1 o nat)(th := o9) \<longrightarrow> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>th1 = lock_holder \<longrightarrow> \<not>has_lock (pcs1[nat th := o9] ! nat th1)) \<and> (-(1 :: int) \<le> lock_holder \<and> lock_holder < n) \<and> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (case owners1 ! nat b1 of None \<Rightarrow> True | Some th1 \<Rightarrow> ((0 :: int) \<le> th1 \<and> th1 < n) \<and> (case memo1 ! nat th1 of None \<Rightarrow> False | Some tick2 \<Rightarrow> b tick2 = b1))) \<and> (\<forall>(tick2 :: tick). pass1[nat o8 := o7] ! nat (b tick2) = True \<longrightarrow> (case owners1 ! nat (b tick2) of None \<Rightarrow> lock_holder = -(1 :: int) | Some th1 \<Rightarrow> lock_holder = -(1 :: int) \<or> lock_holder = th1)) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n \<longrightarrow> (case pcs1[nat th := o9] ! nat lock_holder of A3 \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick2 \<Rightarrow> pass1[nat o8 := o7] ! nat (b tick2) = True) | W \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick2 \<Rightarrow> pass1[nat o8 := o7] ! nat (b tick2) = True) | R1 \<Rightarrow> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick2 \<Rightarrow> pass1[nat o8 := o7] ! nat (b tick2) = True) | R2 \<Rightarrow> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> \<not>pass1[nat o8 := o7] ! nat b1 = True) | _ \<Rightarrow> False)) \<and> (\<forall>(b1 :: int) (b2 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (0 :: int) \<le> b2 \<and> b2 < k * n \<longrightarrow> pass1[nat o8 := o7] ! nat b1 = True \<and> pass1[nat o8 := o7] ! nat b2 = True \<longrightarrow> b1 = b2) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n \<longrightarrow> has_lock (pcs1[nat th := o9] ! nat lock_holder) \<and> (case memo1 ! nat lock_holder of None \<Rightarrow> False | Some tick2 \<Rightarrow> active_tick = Some tick2)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> (case memo1 ! nat th1 of Some tick2 \<Rightarrow> owners1 ! nat (b tick2) = Some th1 | None \<Rightarrow> True)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>memo1 ! nat th1 = None \<longleftrightarrow> has_ticket (pcs1[nat th := o9] ! nat th1)) \<and> (\<forall>(tick2 :: tick). tick2 \<in> set (seq waiting_list1) \<longrightarrow> (case owners1 ! nat (b tick2) of None \<Rightarrow> False | Some th1 \<Rightarrow> pcs1[nat th := o9] ! nat th1 = A2 \<and> memo1 ! nat th1 = Some tick2)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> (case memo1 ! nat th1 of Some tick2 \<Rightarrow> tick2 \<in> set (seq waiting_list1) \<or> active_tick = Some tick2 | None \<Rightarrow> True)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>has_lock (pcs1[nat th := o9] ! nat th1) \<longrightarrow> (case memo1 ! nat th1 of None \<Rightarrow> \<not>pcs1[nat th := o9] ! nat th1 = A2 | Some tick2 \<Rightarrow> tick2 \<in> set (seq waiting_list1))) \<and> consecutive (seq waiting_list1) \<and> length (seq waiting_list1) = count_list (drop (0 :: nat) (take (nat n - (0 :: nat)) (pcs1[nat th := o9]))) A2 \<and> (\<forall>(tick2 :: tick). tick2 \<in> set (seq waiting_list1) \<longrightarrow> v next - int (length (seq waiting_list1)) \<le> v tick2 \<and> v tick2 < v next) \<and> (case last (seq waiting_list1) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next - (1 :: int)) \<and> (case hd (seq waiting_list1) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next - int (length (seq waiting_list1))) \<and> (case active_tick of None \<Rightarrow> lock_holder = -(1 :: int) | Some tick2 \<Rightarrow> (case hd (seq waiting_list1) of None \<Rightarrow> v next = v tick2 + (1 :: int) | Some t \<Rightarrow> v t = v tick2 + (1 :: int)) \<and> v tick2 = v next - int (length (seq waiting_list1)) - (1 :: int) \<and> ((0 :: int) \<le> lock_holder \<and> lock_holder < n) \<and> memo1 ! nat lock_holder = Some tick2) \<and> ((0 :: int) \<le> int (length (seq waiting_list1)) \<and> int (length (seq waiting_list1)) \<le> n) \<and> (lock_holder = -(1 :: int) \<longrightarrow> \<not>int (length (seq waiting_list1)) = (0 :: int) \<and> pass1[nat o8 := o7] ! nat (b (seq waiting_list1 ! (0 :: nat))) = True \<or> (\<exists>(th1 :: int). ((0 :: int) \<le> th1 \<and> th1 < n) \<and> memo1 ! nat th1 = None \<and> pass1[nat o8 := o7] ! nat (b next) = True) \<and> seq waiting_list1 = [])))))) | R2 \<Rightarrow> ((0 :: int) \<le> th \<and> th < int (length memo1)) \<and> (case memo1 ! nat th of None \<Rightarrow> False | Some tick1 \<Rightarrow> (let o7 :: int = k * n in \<not>o7 = (0 :: int) \<and> (let nt :: int = (b tick1 + (1 :: int)) emod o7; o8 :: bool = True in ((0 :: int) \<le> nt \<and> nt < int (length pass1)) \<and> (length (pass1[nat nt := o8]) = length pass1 \<longrightarrow> nth (pass1[nat nt := o8]) o nat = (nth pass1 o nat)(nt := o8) \<longrightarrow> (let o9 :: tick option = None in ((0 :: int) \<le> th \<and> th < int (length memo1)) \<and> (length (memo1[nat th := o9]) = length memo1 \<longrightarrow> nth (memo1[nat th := o9]) o nat = (nth memo1 o nat)(th := o9) \<longrightarrow> (let o10 :: int option = None; o11 :: int = b tick1 in ((0 :: int) \<le> o11 \<and> o11 < int (length owners1)) \<and> (length (owners1[nat o11 := o10]) = length owners1 \<longrightarrow> nth (owners1[nat o11 := o10]) o nat = (nth owners1 o nat)(o11 := o10) \<longrightarrow> (let o12 :: pc = I in ((0 :: int) \<le> th \<and> th < int (length pcs1)) \<and> (length (pcs1[nat th := o12]) = length pcs1 \<longrightarrow> nth (pcs1[nat th := o12]) o nat = (nth pcs1 o nat)(th := o12) \<longrightarrow> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>th1 = -(1 :: int) \<longrightarrow> \<not>has_lock (pcs1[nat th := o12] ! nat th1)) \<and> (-(1 :: int) \<le> -(1 :: int) \<and> -(1 :: int) < n) \<and> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (case owners1[nat o11 := o10] ! nat b1 of None \<Rightarrow> True | Some th1 \<Rightarrow> ((0 :: int) \<le> th1 \<and> th1 < n) \<and> (case memo1[nat th := o9] ! nat th1 of None \<Rightarrow> False | Some tick2 \<Rightarrow> b tick2 = b1))) \<and> (\<forall>(tick2 :: tick). pass1[nat nt := o8] ! nat (b tick2) = True \<longrightarrow> (case owners1[nat o11 := o10] ! nat (b tick2) of None \<Rightarrow> True | Some th1 \<Rightarrow> True \<or> -(1 :: int) = th1)) \<and> ((0 :: int) \<le> -(1 :: int) \<and> -(1 :: int) < n \<longrightarrow> (case pcs1[nat th := o12] ! nat (-(1 :: int)) of A3 \<Rightarrow> (case memo1[nat th := o9] ! nat (-(1 :: int)) of None \<Rightarrow> False | Some tick2 \<Rightarrow> pass1[nat nt := o8] ! nat (b tick2) = True) | W \<Rightarrow> (case memo1[nat th := o9] ! nat (-(1 :: int)) of None \<Rightarrow> False | Some tick2 \<Rightarrow> pass1[nat nt := o8] ! nat (b tick2) = True) | R1 \<Rightarrow> (case memo1[nat th := o9] ! nat (-(1 :: int)) of None \<Rightarrow> False | Some tick2 \<Rightarrow> pass1[nat nt := o8] ! nat (b tick2) = True) | R2 \<Rightarrow> (\<forall>(b1 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> \<not>pass1[nat nt := o8] ! nat b1 = True) | _ \<Rightarrow> False)) \<and> (\<forall>(b1 :: int) (b2 :: int). (0 :: int) \<le> b1 \<and> b1 < k * n \<longrightarrow> (0 :: int) \<le> b2 \<and> b2 < k * n \<longrightarrow> pass1[nat nt := o8] ! nat b1 = True \<and> pass1[nat nt := o8] ! nat b2 = True \<longrightarrow> b1 = b2) \<and> ((0 :: int) \<le> -(1 :: int) \<and> -(1 :: int) < n \<longrightarrow> has_lock (pcs1[nat th := o12] ! nat (-(1 :: int))) \<and> (case memo1[nat th := o9] ! nat (-(1 :: int)) of None \<Rightarrow> False | Some tick2 \<Rightarrow> None = Some tick2)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> (case memo1[nat th := o9] ! nat th1 of Some tick2 \<Rightarrow> owners1[nat o11 := o10] ! nat (b tick2) = Some th1 | None \<Rightarrow> True)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>memo1[nat th := o9] ! nat th1 = None \<longleftrightarrow> has_ticket (pcs1[nat th := o12] ! nat th1)) \<and> (\<forall>(tick2 :: tick). tick2 \<in> set (seq waiting_list1) \<longrightarrow> (case owners1[nat o11 := o10] ! nat (b tick2) of None \<Rightarrow> False | Some th1 \<Rightarrow> pcs1[nat th := o12] ! nat th1 = A2 \<and> memo1[nat th := o9] ! nat th1 = Some tick2)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> (case memo1[nat th := o9] ! nat th1 of Some tick2 \<Rightarrow> tick2 \<in> set (seq waiting_list1) \<or> None = Some tick2 | None \<Rightarrow> True)) \<and> (\<forall>(th1 :: int). (0 :: int) \<le> th1 \<and> th1 < n \<longrightarrow> \<not>has_lock (pcs1[nat th := o12] ! nat th1) \<longrightarrow> (case memo1[nat th := o9] ! nat th1 of None \<Rightarrow> \<not>pcs1[nat th := o12] ! nat th1 = A2 | Some tick2 \<Rightarrow> tick2 \<in> set (seq waiting_list1))) \<and> consecutive (seq waiting_list1) \<and> length (seq waiting_list1) = count_list (drop (0 :: nat) (take (nat n - (0 :: nat)) (pcs1[nat th := o12]))) A2 \<and> (\<forall>(tick2 :: tick). tick2 \<in> set (seq waiting_list1) \<longrightarrow> v next - int (length (seq waiting_list1)) \<le> v tick2 \<and> v tick2 < v next) \<and> (case last (seq waiting_list1) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next - (1 :: int)) \<and> (case hd (seq waiting_list1) of None \<Rightarrow> True | Some t \<Rightarrow> v t = v next - int (length (seq waiting_list1))) \<and> (case None of None \<Rightarrow> True | Some tick2 \<Rightarrow> (case hd (seq waiting_list1) of None \<Rightarrow> v next = v tick2 + (1 :: int) | Some t \<Rightarrow> v t = v tick2 + (1 :: int)) \<and> v tick2 = v next - int (length (seq waiting_list1)) - (1 :: int) \<and> ((0 :: int) \<le> -(1 :: int) \<and> -(1 :: int) < n) \<and> memo1[nat th := o9] ! nat (-(1 :: int)) = Some tick2) \<and> ((0 :: int) \<le> int (length (seq waiting_list1)) \<and> int (length (seq waiting_list1)) \<le> n) \<and> (\<not>int (length (seq waiting_list1)) = (0 :: int) \<and> pass1[nat nt := o8] ! nat (b (seq waiting_list1 ! (0 :: nat))) = True \<or> (\<exists>(th1 :: int). ((0 :: int) \<le> th1 \<and> th1 < n) \<and> memo1[nat th := o9] ! nat th1 = None \<and> pass1[nat nt := o8] ! nat (b next) = True) \<and> seq waiting_list1 = [])))))))))))))))))))))))))"
  sorry
end
