import Why3.Base
import Why3.why3.Ref.Ref
import Why3.int.NumOf
import Why3.queue.Queue
open Classical
open Lean4Why3
namespace verifythis_2018_array_based_queuing_lock_2_ABQL_mainqtvc
axiom n : ℤ
axiom N_val : (2 : ℤ) ≤ n
axiom k : ℤ
axiom K_val : (2 : ℤ) ≤ k
axiom tick : Type
axiom inhabited_axiom_tick : Inhabited tick
attribute [instance] inhabited_axiom_tick
axiom b : tick -> ℤ
axiom v : tick -> ℤ
axiom tick'invariant (self : tick) : (0 : ℤ) ≤ v self ∧ (0 : ℤ) ≤ b self ∧ b self < k * n ∧ b self = v self % (k * n)
noncomputable def tick'eq (a : tick) (b1 : tick) := b a = b b1 ∧ v a = v b1
axiom tick'inj (a : tick) (b1 : tick) (fact0 : tick'eq a b1) : a = b1
noncomputable def lt (tick1 : tick) (tick2 : tick) := v tick1 < v tick2
noncomputable def sorted (s : List tick) := ∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < Int.ofNat (List.length s) → lt (s[Int.toNat i]!) (s[Int.toNat j]!)
noncomputable def consecutive (l : List tick) := ∀(i : ℤ), (0 : ℤ) < i ∧ i < Int.ofNat (List.length l) → v (l[Int.toNat i]!) = v (l[Int.toNat (i - (1 : ℤ))]!) + (1 : ℤ)
noncomputable def last (l : List tick) := if Int.ofNat (List.length l) = (0 : ℤ) then Option.none else Option.some (l[Int.toNat (Int.ofNat (List.length l) - (1 : ℤ))]!)
noncomputable def hd (l : List tick) := if Int.ofNat (List.length l) = (0 : ℤ) then Option.none else Option.some (l[(0 : ℕ)]!)
inductive pc where
  | A1 : pc
  | A2 : pc
  | A3 : pc
  | R1 : pc
  | R2 : pc
  | I : pc
  | W : pc
axiom inhabited_axiom_pc : Inhabited pc
attribute [instance] inhabited_axiom_pc
noncomputable def has_ticket (pc1 : pc) := match pc1 with | pc.A1 => False | pc.I => False | _ => True
noncomputable def has_lock (pc1 : pc) := match pc1 with | pc.A3 => True | pc.W => True | pc.R1 => True | pc.R2 => True | _ => False
axiom nondet_source : Type
axiom inhabited_axiom_nondet_source : Inhabited nondet_source
attribute [instance] inhabited_axiom_nondet_source
axiom rng : Type
axiom inhabited_axiom_rng : Inhabited rng
attribute [instance] inhabited_axiom_rng
axiom source : rng -> nondet_source
axiom fc :  {α : Type} -> [Inhabited α] -> List α -> α -> ℤ -> Bool
axiom fc'def {α : Type} [Inhabited α] (a : List α) (v1 : α) (i : ℤ) : (fc a v1 i = true) = (a[Int.toNat i]! = v1)
theorem main'vc : let o1 : ℤ := k * n; (0 : ℤ) ≤ o1 ∧ (∀(pass : List Bool), (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < o1 → pass[Int.toNat i]! = false) ∧ Int.ofNat (List.length pass) = o1 → (let o2 : Bool := true; ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) < Int.ofNat (List.length pass)) ∧ (List.length (List.set pass (0 : ℕ) o2) = List.length pass → getElem! (List.set pass (0 : ℕ) o2) ∘ Int.toNat = Function.update (getElem! pass ∘ Int.toNat) (0 : ℤ) o2 → ((0 : ℤ) ≤ (0 : ℤ) ∧ ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) < k * n) ∧ (0 : ℤ) = (0 : ℤ) % (k * n)) ∧ (∀(o3 : tick), b o3 = (0 : ℤ) ∧ v o3 = (0 : ℤ) → (let o4 : ℤ := n; (0 : ℤ) ≤ o4 ∧ (∀(pcs : List pc), (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < o4 → pcs[Int.toNat i]! = pc.I) ∧ Int.ofNat (List.length pcs) = o4 → (let o5 : ℤ := n; (0 : ℤ) ≤ o5 ∧ (∀(memo : List (Option tick)), (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < o5 → memo[Int.toNat i]! = Option.none) ∧ Int.ofNat (List.length memo) = o5 → (let o6 : ℤ := k * n; (0 : ℤ) ≤ o6 ∧ (∀(owners : List (Option ℤ)), (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < o6 → owners[Int.toNat i]! = Option.none) ∧ Int.ofNat (List.length owners) = o6 → (∀(waiting_list : Queue.t tick), Queue.seq waiting_list = ([] : List tick) → ((∀(th : ℤ), (0 : ℤ) ≤ th ∧ th < n → ¬th = -(1 : ℤ) → ¬has_lock (pcs[Int.toNat th]!)) ∧ (-(1 : ℤ) ≤ -(1 : ℤ) ∧ -(1 : ℤ) < n) ∧ (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (match owners[Int.toNat b1]! with | Option.none => True | Option.some th => ((0 : ℤ) ≤ th ∧ th < n) ∧ (match memo[Int.toNat th]! with | Option.none => False | Option.some tick1 => b tick1 = b1))) ∧ (∀(tick1 : tick), (List.set pass (0 : ℕ) o2)[Int.toNat (b tick1)]! = true → (match owners[Int.toNat (b tick1)]! with | Option.none => True | Option.some th => True)) ∧ ((0 : ℤ) ≤ -(1 : ℤ) ∧ -(1 : ℤ) < n → (match pcs[Int.toNat (-(1 : ℤ))]! with | pc.A3 => (match memo[Int.toNat (-(1 : ℤ))]! with | Option.none => False | Option.some tick1 => (List.set pass (0 : ℕ) o2)[Int.toNat (b tick1)]! = true) | pc.W => (match memo[Int.toNat (-(1 : ℤ))]! with | Option.none => False | Option.some tick1 => (List.set pass (0 : ℕ) o2)[Int.toNat (b tick1)]! = true) | pc.R1 => (match memo[Int.toNat (-(1 : ℤ))]! with | Option.none => False | Option.some tick1 => (List.set pass (0 : ℕ) o2)[Int.toNat (b tick1)]! = true) | pc.R2 => (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → ¬(List.set pass (0 : ℕ) o2)[Int.toNat b1]! = true) | _ => False)) ∧ (∀(b1 : ℤ) (b2 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (0 : ℤ) ≤ b2 ∧ b2 < k * n → (List.set pass (0 : ℕ) o2)[Int.toNat b1]! = true ∧ (List.set pass (0 : ℕ) o2)[Int.toNat b2]! = true → b1 = b2) ∧ ((0 : ℤ) ≤ -(1 : ℤ) ∧ -(1 : ℤ) < n → has_lock (pcs[Int.toNat (-(1 : ℤ))]!) ∧ (match memo[Int.toNat (-(1 : ℤ))]! with | Option.none => False | Option.some tick1 => False)) ∧ (∀(th : ℤ), (0 : ℤ) ≤ th ∧ th < n → (match memo[Int.toNat th]! with | Option.some tick1 => owners[Int.toNat (b tick1)]! = Option.some th | Option.none => True)) ∧ (∀(th : ℤ), (0 : ℤ) ≤ th ∧ th < n → (¬memo[Int.toNat th]! = Option.none) = has_ticket (pcs[Int.toNat th]!)) ∧ (∀(tick1 : tick), tick1 ∈ Queue.seq waiting_list → (match owners[Int.toNat (b tick1)]! with | Option.none => False | Option.some th => pcs[Int.toNat th]! = pc.A2 ∧ memo[Int.toNat th]! = Option.some tick1)) ∧ (∀(th : ℤ), (0 : ℤ) ≤ th ∧ th < n → (match memo[Int.toNat th]! with | Option.some tick1 => tick1 ∈ Queue.seq waiting_list | Option.none => True)) ∧ (∀(th : ℤ), (0 : ℤ) ≤ th ∧ th < n → ¬has_lock (pcs[Int.toNat th]!) → (match memo[Int.toNat th]! with | Option.none => ¬pcs[Int.toNat th]! = pc.A2 | Option.some tick1 => tick1 ∈ Queue.seq waiting_list)) ∧ consecutive (Queue.seq waiting_list) ∧ List.length (Queue.seq waiting_list) = List.count pc.A2 (List.drop (0 : ℕ) (List.take (Int.toNat n - (0 : ℕ)) pcs)) ∧ (∀(tick1 : tick), tick1 ∈ Queue.seq waiting_list → v o3 - Int.ofNat (List.length (Queue.seq waiting_list)) ≤ v tick1 ∧ v tick1 < v o3) ∧ (match last (Queue.seq waiting_list) with | Option.none => True | Option.some t => v t = v o3 - (1 : ℤ)) ∧ (match hd (Queue.seq waiting_list) with | Option.none => True | Option.some t => v t = v o3 - Int.ofNat (List.length (Queue.seq waiting_list))) ∧ ((0 : ℤ) ≤ Int.ofNat (List.length (Queue.seq waiting_list)) ∧ Int.ofNat (List.length (Queue.seq waiting_list)) ≤ n) ∧ (¬Int.ofNat (List.length (Queue.seq waiting_list)) = (0 : ℤ) ∧ (List.set pass (0 : ℕ) o2)[Int.toNat (b ((Queue.seq waiting_list)[(0 : ℕ)]!))]! = true ∨ (∃(th : ℤ), ((0 : ℤ) ≤ th ∧ th < n) ∧ memo[Int.toNat th]! = Option.none ∧ (List.set pass (0 : ℕ) o2)[Int.toNat (b o3)]! = true) ∧ Queue.seq waiting_list = ([] : List tick))) ∧ (∀(active_tick : Option tick) (waiting_list1 : Queue.t tick) (lock_holder : ℤ) (owners1 : List (Option ℤ)) (memo1 : List (Option tick)) (pcs1 : List pc) (next : tick) (pass1 : List Bool), List.length owners1 = List.length owners → List.length memo1 = List.length memo → List.length pcs1 = List.length pcs → List.length pass1 = List.length (List.set pass (0 : ℕ) o2) → (∀(th : ℤ), (0 : ℤ) ≤ th ∧ th < n → ¬th = lock_holder → ¬has_lock (pcs1[Int.toNat th]!)) ∧ (-(1 : ℤ) ≤ lock_holder ∧ lock_holder < n) ∧ (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (match owners1[Int.toNat b1]! with | Option.none => True | Option.some th => ((0 : ℤ) ≤ th ∧ th < n) ∧ (match memo1[Int.toNat th]! with | Option.none => False | Option.some tick1 => b tick1 = b1))) ∧ (∀(tick1 : tick), pass1[Int.toNat (b tick1)]! = true → (match owners1[Int.toNat (b tick1)]! with | Option.none => lock_holder = -(1 : ℤ) | Option.some th => lock_holder = -(1 : ℤ) ∨ lock_holder = th)) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n → (match pcs1[Int.toNat lock_holder]! with | pc.A3 => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => pass1[Int.toNat (b tick1)]! = true) | pc.W => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => pass1[Int.toNat (b tick1)]! = true) | pc.R1 => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => pass1[Int.toNat (b tick1)]! = true) | pc.R2 => (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → ¬pass1[Int.toNat b1]! = true) | _ => False)) ∧ (∀(b1 : ℤ) (b2 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (0 : ℤ) ≤ b2 ∧ b2 < k * n → pass1[Int.toNat b1]! = true ∧ pass1[Int.toNat b2]! = true → b1 = b2) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n → has_lock (pcs1[Int.toNat lock_holder]!) ∧ (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => active_tick = Option.some tick1)) ∧ (∀(th : ℤ), (0 : ℤ) ≤ th ∧ th < n → (match memo1[Int.toNat th]! with | Option.some tick1 => owners1[Int.toNat (b tick1)]! = Option.some th | Option.none => True)) ∧ (∀(th : ℤ), (0 : ℤ) ≤ th ∧ th < n → (¬memo1[Int.toNat th]! = Option.none) = has_ticket (pcs1[Int.toNat th]!)) ∧ (∀(tick1 : tick), tick1 ∈ Queue.seq waiting_list1 → (match owners1[Int.toNat (b tick1)]! with | Option.none => False | Option.some th => pcs1[Int.toNat th]! = pc.A2 ∧ memo1[Int.toNat th]! = Option.some tick1)) ∧ (∀(th : ℤ), (0 : ℤ) ≤ th ∧ th < n → (match memo1[Int.toNat th]! with | Option.some tick1 => tick1 ∈ Queue.seq waiting_list1 ∨ active_tick = Option.some tick1 | Option.none => True)) ∧ (∀(th : ℤ), (0 : ℤ) ≤ th ∧ th < n → ¬has_lock (pcs1[Int.toNat th]!) → (match memo1[Int.toNat th]! with | Option.none => ¬pcs1[Int.toNat th]! = pc.A2 | Option.some tick1 => tick1 ∈ Queue.seq waiting_list1)) ∧ consecutive (Queue.seq waiting_list1) ∧ List.length (Queue.seq waiting_list1) = List.count pc.A2 (List.drop (0 : ℕ) (List.take (Int.toNat n - (0 : ℕ)) pcs1)) ∧ (∀(tick1 : tick), tick1 ∈ Queue.seq waiting_list1 → v next - Int.ofNat (List.length (Queue.seq waiting_list1)) ≤ v tick1 ∧ v tick1 < v next) ∧ (match last (Queue.seq waiting_list1) with | Option.none => True | Option.some t => v t = v next - (1 : ℤ)) ∧ (match hd (Queue.seq waiting_list1) with | Option.none => True | Option.some t => v t = v next - Int.ofNat (List.length (Queue.seq waiting_list1))) ∧ (match active_tick with | Option.none => lock_holder = -(1 : ℤ) | Option.some tick1 => (match hd (Queue.seq waiting_list1) with | Option.none => v next = v tick1 + (1 : ℤ) | Option.some t => v t = v tick1 + (1 : ℤ)) ∧ v tick1 = v next - Int.ofNat (List.length (Queue.seq waiting_list1)) - (1 : ℤ) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n) ∧ memo1[Int.toNat lock_holder]! = Option.some tick1) ∧ ((0 : ℤ) ≤ Int.ofNat (List.length (Queue.seq waiting_list1)) ∧ Int.ofNat (List.length (Queue.seq waiting_list1)) ≤ n) ∧ (lock_holder = -(1 : ℤ) → ¬Int.ofNat (List.length (Queue.seq waiting_list1)) = (0 : ℤ) ∧ pass1[Int.toNat (b ((Queue.seq waiting_list1)[(0 : ℕ)]!))]! = true ∨ (∃(th : ℤ), ((0 : ℤ) ≤ th ∧ th < n) ∧ memo1[Int.toNat th]! = Option.none ∧ pass1[Int.toNat (b next)]! = true) ∧ Queue.seq waiting_list1 = ([] : List tick)) → (∀(th : ℤ), (0 : ℤ) ≤ th ∧ th < n → ((0 : ℤ) ≤ th ∧ th < Int.ofNat (List.length pcs1)) ∧ (match pcs1[Int.toNat th]! with | pc.I => (let o7 : pc := pc.A1; ((0 : ℤ) ≤ th ∧ th < Int.ofNat (List.length pcs1)) ∧ (List.length (List.set pcs1 (Int.toNat th) o7) = List.length pcs1 → getElem! (List.set pcs1 (Int.toNat th) o7) ∘ Int.toNat = Function.update (getElem! pcs1 ∘ Int.toNat) th o7 → (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → ¬th1 = lock_holder → ¬has_lock ((List.set pcs1 (Int.toNat th) o7)[Int.toNat th1]!)) ∧ (-(1 : ℤ) ≤ lock_holder ∧ lock_holder < n) ∧ (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (match owners1[Int.toNat b1]! with | Option.none => True | Option.some th1 => ((0 : ℤ) ≤ th1 ∧ th1 < n) ∧ (match memo1[Int.toNat th1]! with | Option.none => False | Option.some tick1 => b tick1 = b1))) ∧ (∀(tick1 : tick), pass1[Int.toNat (b tick1)]! = true → (match owners1[Int.toNat (b tick1)]! with | Option.none => lock_holder = -(1 : ℤ) | Option.some th1 => lock_holder = -(1 : ℤ) ∨ lock_holder = th1)) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n → (match (List.set pcs1 (Int.toNat th) o7)[Int.toNat lock_holder]! with | pc.A3 => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => pass1[Int.toNat (b tick1)]! = true) | pc.W => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => pass1[Int.toNat (b tick1)]! = true) | pc.R1 => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => pass1[Int.toNat (b tick1)]! = true) | pc.R2 => (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → ¬pass1[Int.toNat b1]! = true) | _ => False)) ∧ (∀(b1 : ℤ) (b2 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (0 : ℤ) ≤ b2 ∧ b2 < k * n → pass1[Int.toNat b1]! = true ∧ pass1[Int.toNat b2]! = true → b1 = b2) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n → has_lock ((List.set pcs1 (Int.toNat th) o7)[Int.toNat lock_holder]!) ∧ (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => active_tick = Option.some tick1)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (match memo1[Int.toNat th1]! with | Option.some tick1 => owners1[Int.toNat (b tick1)]! = Option.some th1 | Option.none => True)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (¬memo1[Int.toNat th1]! = Option.none) = has_ticket ((List.set pcs1 (Int.toNat th) o7)[Int.toNat th1]!)) ∧ (∀(tick1 : tick), tick1 ∈ Queue.seq waiting_list1 → (match owners1[Int.toNat (b tick1)]! with | Option.none => False | Option.some th1 => (List.set pcs1 (Int.toNat th) o7)[Int.toNat th1]! = pc.A2 ∧ memo1[Int.toNat th1]! = Option.some tick1)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (match memo1[Int.toNat th1]! with | Option.some tick1 => tick1 ∈ Queue.seq waiting_list1 ∨ active_tick = Option.some tick1 | Option.none => True)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → ¬has_lock ((List.set pcs1 (Int.toNat th) o7)[Int.toNat th1]!) → (match memo1[Int.toNat th1]! with | Option.none => ¬(List.set pcs1 (Int.toNat th) o7)[Int.toNat th1]! = pc.A2 | Option.some tick1 => tick1 ∈ Queue.seq waiting_list1)) ∧ consecutive (Queue.seq waiting_list1) ∧ List.length (Queue.seq waiting_list1) = List.count pc.A2 (List.drop (0 : ℕ) (List.take (Int.toNat n - (0 : ℕ)) (List.set pcs1 (Int.toNat th) o7))) ∧ (∀(tick1 : tick), tick1 ∈ Queue.seq waiting_list1 → v next - Int.ofNat (List.length (Queue.seq waiting_list1)) ≤ v tick1 ∧ v tick1 < v next) ∧ (match last (Queue.seq waiting_list1) with | Option.none => True | Option.some t => v t = v next - (1 : ℤ)) ∧ (match hd (Queue.seq waiting_list1) with | Option.none => True | Option.some t => v t = v next - Int.ofNat (List.length (Queue.seq waiting_list1))) ∧ (match active_tick with | Option.none => lock_holder = -(1 : ℤ) | Option.some tick1 => (match hd (Queue.seq waiting_list1) with | Option.none => v next = v tick1 + (1 : ℤ) | Option.some t => v t = v tick1 + (1 : ℤ)) ∧ v tick1 = v next - Int.ofNat (List.length (Queue.seq waiting_list1)) - (1 : ℤ) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n) ∧ memo1[Int.toNat lock_holder]! = Option.some tick1) ∧ ((0 : ℤ) ≤ Int.ofNat (List.length (Queue.seq waiting_list1)) ∧ Int.ofNat (List.length (Queue.seq waiting_list1)) ≤ n) ∧ (lock_holder = -(1 : ℤ) → ¬Int.ofNat (List.length (Queue.seq waiting_list1)) = (0 : ℤ) ∧ pass1[Int.toNat (b ((Queue.seq waiting_list1)[(0 : ℕ)]!))]! = true ∨ (∃(th1 : ℤ), ((0 : ℤ) ≤ th1 ∧ th1 < n) ∧ memo1[Int.toNat th1]! = Option.none ∧ pass1[Int.toNat (b next)]! = true) ∧ Queue.seq waiting_list1 = ([] : List tick)))) | pc.A1 => (∀(next1 : tick), v next1 = v next + (1 : ℤ) → (let o7 : Option ℤ := Option.some th; let o8 : ℤ := b next; ((0 : ℤ) ≤ o8 ∧ o8 < Int.ofNat (List.length owners1)) ∧ (List.length (List.set owners1 (Int.toNat o8) o7) = List.length owners1 → getElem! (List.set owners1 (Int.toNat o8) o7) ∘ Int.toNat = Function.update (getElem! owners1 ∘ Int.toNat) o8 o7 → (let o9 : Option tick := Option.some next; ((0 : ℤ) ≤ th ∧ th < Int.ofNat (List.length memo1)) ∧ (List.length (List.set memo1 (Int.toNat th) o9) = List.length memo1 → getElem! (List.set memo1 (Int.toNat th) o9) ∘ Int.toNat = Function.update (getElem! memo1 ∘ Int.toNat) th o9 → (let o10 : pc := pc.A2; ((0 : ℤ) ≤ th ∧ th < Int.ofNat (List.length pcs1)) ∧ (List.length (List.set pcs1 (Int.toNat th) o10) = List.length pcs1 → getElem! (List.set pcs1 (Int.toNat th) o10) ∘ Int.toNat = Function.update (getElem! pcs1 ∘ Int.toNat) th o10 → (∀(waiting_list2 : Queue.t tick), Queue.seq waiting_list2 = Queue.seq waiting_list1 ++ [next] → (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → ¬th1 = lock_holder → ¬has_lock ((List.set pcs1 (Int.toNat th) o10)[Int.toNat th1]!)) ∧ (-(1 : ℤ) ≤ lock_holder ∧ lock_holder < n) ∧ (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (match (List.set owners1 (Int.toNat o8) o7)[Int.toNat b1]! with | Option.none => True | Option.some th1 => ((0 : ℤ) ≤ th1 ∧ th1 < n) ∧ (match (List.set memo1 (Int.toNat th) o9)[Int.toNat th1]! with | Option.none => False | Option.some tick1 => b tick1 = b1))) ∧ (∀(tick1 : tick), pass1[Int.toNat (b tick1)]! = true → (match (List.set owners1 (Int.toNat o8) o7)[Int.toNat (b tick1)]! with | Option.none => lock_holder = -(1 : ℤ) | Option.some th1 => lock_holder = -(1 : ℤ) ∨ lock_holder = th1)) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n → (match (List.set pcs1 (Int.toNat th) o10)[Int.toNat lock_holder]! with | pc.A3 => (match (List.set memo1 (Int.toNat th) o9)[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => pass1[Int.toNat (b tick1)]! = true) | pc.W => (match (List.set memo1 (Int.toNat th) o9)[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => pass1[Int.toNat (b tick1)]! = true) | pc.R1 => (match (List.set memo1 (Int.toNat th) o9)[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => pass1[Int.toNat (b tick1)]! = true) | pc.R2 => (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → ¬pass1[Int.toNat b1]! = true) | _ => False)) ∧ (∀(b1 : ℤ) (b2 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (0 : ℤ) ≤ b2 ∧ b2 < k * n → pass1[Int.toNat b1]! = true ∧ pass1[Int.toNat b2]! = true → b1 = b2) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n → has_lock ((List.set pcs1 (Int.toNat th) o10)[Int.toNat lock_holder]!) ∧ (match (List.set memo1 (Int.toNat th) o9)[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => active_tick = Option.some tick1)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (match (List.set memo1 (Int.toNat th) o9)[Int.toNat th1]! with | Option.some tick1 => (List.set owners1 (Int.toNat o8) o7)[Int.toNat (b tick1)]! = Option.some th1 | Option.none => True)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (¬(List.set memo1 (Int.toNat th) o9)[Int.toNat th1]! = Option.none) = has_ticket ((List.set pcs1 (Int.toNat th) o10)[Int.toNat th1]!)) ∧ (∀(tick1 : tick), tick1 ∈ Queue.seq waiting_list2 → (match (List.set owners1 (Int.toNat o8) o7)[Int.toNat (b tick1)]! with | Option.none => False | Option.some th1 => (List.set pcs1 (Int.toNat th) o10)[Int.toNat th1]! = pc.A2 ∧ (List.set memo1 (Int.toNat th) o9)[Int.toNat th1]! = Option.some tick1)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (match (List.set memo1 (Int.toNat th) o9)[Int.toNat th1]! with | Option.some tick1 => tick1 ∈ Queue.seq waiting_list2 ∨ active_tick = Option.some tick1 | Option.none => True)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → ¬has_lock ((List.set pcs1 (Int.toNat th) o10)[Int.toNat th1]!) → (match (List.set memo1 (Int.toNat th) o9)[Int.toNat th1]! with | Option.none => ¬(List.set pcs1 (Int.toNat th) o10)[Int.toNat th1]! = pc.A2 | Option.some tick1 => tick1 ∈ Queue.seq waiting_list2)) ∧ consecutive (Queue.seq waiting_list2) ∧ List.length (Queue.seq waiting_list2) = List.count pc.A2 (List.drop (0 : ℕ) (List.take (Int.toNat n - (0 : ℕ)) (List.set pcs1 (Int.toNat th) o10))) ∧ (∀(tick1 : tick), tick1 ∈ Queue.seq waiting_list2 → v next1 - Int.ofNat (List.length (Queue.seq waiting_list2)) ≤ v tick1 ∧ v tick1 < v next1) ∧ (match last (Queue.seq waiting_list2) with | Option.none => True | Option.some t => v t = v next1 - (1 : ℤ)) ∧ (match hd (Queue.seq waiting_list2) with | Option.none => True | Option.some t => v t = v next1 - Int.ofNat (List.length (Queue.seq waiting_list2))) ∧ (match active_tick with | Option.none => lock_holder = -(1 : ℤ) | Option.some tick1 => (match hd (Queue.seq waiting_list2) with | Option.none => v next1 = v tick1 + (1 : ℤ) | Option.some t => v t = v tick1 + (1 : ℤ)) ∧ v tick1 = v next1 - Int.ofNat (List.length (Queue.seq waiting_list2)) - (1 : ℤ) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n) ∧ (List.set memo1 (Int.toNat th) o9)[Int.toNat lock_holder]! = Option.some tick1) ∧ ((0 : ℤ) ≤ Int.ofNat (List.length (Queue.seq waiting_list2)) ∧ Int.ofNat (List.length (Queue.seq waiting_list2)) ≤ n) ∧ (lock_holder = -(1 : ℤ) → ¬Int.ofNat (List.length (Queue.seq waiting_list2)) = (0 : ℤ) ∧ pass1[Int.toNat (b ((Queue.seq waiting_list2)[(0 : ℕ)]!))]! = true ∨ (∃(th1 : ℤ), ((0 : ℤ) ≤ th1 ∧ th1 < n) ∧ (List.set memo1 (Int.toNat th) o9)[Int.toNat th1]! = Option.none ∧ pass1[Int.toNat (b next1)]! = true) ∧ Queue.seq waiting_list2 = ([] : List tick)))))))))) | pc.A2 => ((0 : ℤ) ≤ th ∧ th < Int.ofNat (List.length memo1)) ∧ (match memo1[Int.toNat th]! with | Option.none => False | Option.some tick1 => (let o7 : ℤ := b tick1; ((0 : ℤ) ≤ o7 ∧ o7 < Int.ofNat (List.length pass1)) ∧ (if pass1[Int.toNat o7]! = true then let o8 : pc := pc.A3; ((0 : ℤ) ≤ th ∧ th < Int.ofNat (List.length pcs1)) ∧ (List.length (List.set pcs1 (Int.toNat th) o8) = List.length pcs1 → getElem! (List.set pcs1 (Int.toNat th) o8) ∘ Int.toNat = Function.update (getElem! pcs1 ∘ Int.toNat) th o8 → ¬Queue.seq waiting_list1 = ([] : List tick) ∧ (∀(waiting_list2 : Queue.t tick), Queue.seq waiting_list2 = List.drop (1 : ℕ) (Queue.seq waiting_list1) → (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → ¬th1 = th → ¬has_lock ((List.set pcs1 (Int.toNat th) o8)[Int.toNat th1]!)) ∧ (-(1 : ℤ) ≤ th ∧ th < n) ∧ (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (match owners1[Int.toNat b1]! with | Option.none => True | Option.some th1 => ((0 : ℤ) ≤ th1 ∧ th1 < n) ∧ (match memo1[Int.toNat th1]! with | Option.none => False | Option.some tick2 => b tick2 = b1))) ∧ (∀(tick2 : tick), pass1[Int.toNat (b tick2)]! = true → (match owners1[Int.toNat (b tick2)]! with | Option.none => th = -(1 : ℤ) | Option.some th1 => th = -(1 : ℤ) ∨ th = th1)) ∧ ((0 : ℤ) ≤ th ∧ th < n → (match (List.set pcs1 (Int.toNat th) o8)[Int.toNat th]! with | pc.A3 => (match memo1[Int.toNat th]! with | Option.none => False | Option.some tick2 => pass1[Int.toNat (b tick2)]! = true) | pc.W => (match memo1[Int.toNat th]! with | Option.none => False | Option.some tick2 => pass1[Int.toNat (b tick2)]! = true) | pc.R1 => (match memo1[Int.toNat th]! with | Option.none => False | Option.some tick2 => pass1[Int.toNat (b tick2)]! = true) | pc.R2 => (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → ¬pass1[Int.toNat b1]! = true) | _ => False)) ∧ (∀(b1 : ℤ) (b2 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (0 : ℤ) ≤ b2 ∧ b2 < k * n → pass1[Int.toNat b1]! = true ∧ pass1[Int.toNat b2]! = true → b1 = b2) ∧ ((0 : ℤ) ≤ th ∧ th < n → has_lock ((List.set pcs1 (Int.toNat th) o8)[Int.toNat th]!) ∧ (match memo1[Int.toNat th]! with | Option.none => False | Option.some tick2 => Option.some tick1 = Option.some tick2)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (match memo1[Int.toNat th1]! with | Option.some tick2 => owners1[Int.toNat (b tick2)]! = Option.some th1 | Option.none => True)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (¬memo1[Int.toNat th1]! = Option.none) = has_ticket ((List.set pcs1 (Int.toNat th) o8)[Int.toNat th1]!)) ∧ (∀(tick2 : tick), tick2 ∈ Queue.seq waiting_list2 → (match owners1[Int.toNat (b tick2)]! with | Option.none => False | Option.some th1 => (List.set pcs1 (Int.toNat th) o8)[Int.toNat th1]! = pc.A2 ∧ memo1[Int.toNat th1]! = Option.some tick2)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (match memo1[Int.toNat th1]! with | Option.some tick2 => tick2 ∈ Queue.seq waiting_list2 ∨ Option.some tick1 = Option.some tick2 | Option.none => True)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → ¬has_lock ((List.set pcs1 (Int.toNat th) o8)[Int.toNat th1]!) → (match memo1[Int.toNat th1]! with | Option.none => ¬(List.set pcs1 (Int.toNat th) o8)[Int.toNat th1]! = pc.A2 | Option.some tick2 => tick2 ∈ Queue.seq waiting_list2)) ∧ consecutive (Queue.seq waiting_list2) ∧ List.length (Queue.seq waiting_list2) = List.count pc.A2 (List.drop (0 : ℕ) (List.take (Int.toNat n - (0 : ℕ)) (List.set pcs1 (Int.toNat th) o8))) ∧ (∀(tick2 : tick), tick2 ∈ Queue.seq waiting_list2 → v next - Int.ofNat (List.length (Queue.seq waiting_list2)) ≤ v tick2 ∧ v tick2 < v next) ∧ (match last (Queue.seq waiting_list2) with | Option.none => True | Option.some t => v t = v next - (1 : ℤ)) ∧ (match hd (Queue.seq waiting_list2) with | Option.none => True | Option.some t => v t = v next - Int.ofNat (List.length (Queue.seq waiting_list2))) ∧ (match Option.some tick1 with | Option.none => th = -(1 : ℤ) | Option.some tick2 => (match hd (Queue.seq waiting_list2) with | Option.none => v next = v tick2 + (1 : ℤ) | Option.some t => v t = v tick2 + (1 : ℤ)) ∧ v tick2 = v next - Int.ofNat (List.length (Queue.seq waiting_list2)) - (1 : ℤ) ∧ ((0 : ℤ) ≤ th ∧ th < n) ∧ memo1[Int.toNat th]! = Option.some tick2) ∧ ((0 : ℤ) ≤ Int.ofNat (List.length (Queue.seq waiting_list2)) ∧ Int.ofNat (List.length (Queue.seq waiting_list2)) ≤ n) ∧ (th = -(1 : ℤ) → ¬Int.ofNat (List.length (Queue.seq waiting_list2)) = (0 : ℤ) ∧ pass1[Int.toNat (b ((Queue.seq waiting_list2)[(0 : ℕ)]!))]! = true ∨ (∃(th1 : ℤ), ((0 : ℤ) ≤ th1 ∧ th1 < n) ∧ memo1[Int.toNat th1]! = Option.none ∧ pass1[Int.toNat (b next)]! = true) ∧ Queue.seq waiting_list2 = ([] : List tick)))) else (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → ¬th1 = lock_holder → ¬has_lock (pcs1[Int.toNat th1]!)) ∧ (-(1 : ℤ) ≤ lock_holder ∧ lock_holder < n) ∧ (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (match owners1[Int.toNat b1]! with | Option.none => True | Option.some th1 => ((0 : ℤ) ≤ th1 ∧ th1 < n) ∧ (match memo1[Int.toNat th1]! with | Option.none => False | Option.some tick2 => b tick2 = b1))) ∧ (∀(tick2 : tick), pass1[Int.toNat (b tick2)]! = true → (match owners1[Int.toNat (b tick2)]! with | Option.none => lock_holder = -(1 : ℤ) | Option.some th1 => lock_holder = -(1 : ℤ) ∨ lock_holder = th1)) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n → (match pcs1[Int.toNat lock_holder]! with | pc.A3 => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick2 => pass1[Int.toNat (b tick2)]! = true) | pc.W => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick2 => pass1[Int.toNat (b tick2)]! = true) | pc.R1 => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick2 => pass1[Int.toNat (b tick2)]! = true) | pc.R2 => (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → ¬pass1[Int.toNat b1]! = true) | _ => False)) ∧ (∀(b1 : ℤ) (b2 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (0 : ℤ) ≤ b2 ∧ b2 < k * n → pass1[Int.toNat b1]! = true ∧ pass1[Int.toNat b2]! = true → b1 = b2) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n → has_lock (pcs1[Int.toNat lock_holder]!) ∧ (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick2 => active_tick = Option.some tick2)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (match memo1[Int.toNat th1]! with | Option.some tick2 => owners1[Int.toNat (b tick2)]! = Option.some th1 | Option.none => True)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (¬memo1[Int.toNat th1]! = Option.none) = has_ticket (pcs1[Int.toNat th1]!)) ∧ (∀(tick2 : tick), tick2 ∈ Queue.seq waiting_list1 → (match owners1[Int.toNat (b tick2)]! with | Option.none => False | Option.some th1 => pcs1[Int.toNat th1]! = pc.A2 ∧ memo1[Int.toNat th1]! = Option.some tick2)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (match memo1[Int.toNat th1]! with | Option.some tick2 => tick2 ∈ Queue.seq waiting_list1 ∨ active_tick = Option.some tick2 | Option.none => True)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → ¬has_lock (pcs1[Int.toNat th1]!) → (match memo1[Int.toNat th1]! with | Option.none => ¬pcs1[Int.toNat th1]! = pc.A2 | Option.some tick2 => tick2 ∈ Queue.seq waiting_list1)) ∧ consecutive (Queue.seq waiting_list1) ∧ List.length (Queue.seq waiting_list1) = List.count pc.A2 (List.drop (0 : ℕ) (List.take (Int.toNat n - (0 : ℕ)) pcs1)) ∧ (∀(tick2 : tick), tick2 ∈ Queue.seq waiting_list1 → v next - Int.ofNat (List.length (Queue.seq waiting_list1)) ≤ v tick2 ∧ v tick2 < v next) ∧ (match last (Queue.seq waiting_list1) with | Option.none => True | Option.some t => v t = v next - (1 : ℤ)) ∧ (match hd (Queue.seq waiting_list1) with | Option.none => True | Option.some t => v t = v next - Int.ofNat (List.length (Queue.seq waiting_list1))) ∧ (match active_tick with | Option.none => lock_holder = -(1 : ℤ) | Option.some tick2 => (match hd (Queue.seq waiting_list1) with | Option.none => v next = v tick2 + (1 : ℤ) | Option.some t => v t = v tick2 + (1 : ℤ)) ∧ v tick2 = v next - Int.ofNat (List.length (Queue.seq waiting_list1)) - (1 : ℤ) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n) ∧ memo1[Int.toNat lock_holder]! = Option.some tick2) ∧ ((0 : ℤ) ≤ Int.ofNat (List.length (Queue.seq waiting_list1)) ∧ Int.ofNat (List.length (Queue.seq waiting_list1)) ≤ n) ∧ (lock_holder = -(1 : ℤ) → ¬Int.ofNat (List.length (Queue.seq waiting_list1)) = (0 : ℤ) ∧ pass1[Int.toNat (b ((Queue.seq waiting_list1)[(0 : ℕ)]!))]! = true ∨ (∃(th1 : ℤ), ((0 : ℤ) ≤ th1 ∧ th1 < n) ∧ memo1[Int.toNat th1]! = Option.none ∧ pass1[Int.toNat (b next)]! = true) ∧ Queue.seq waiting_list1 = ([] : List tick))))) | pc.A3 => (let o7 : pc := pc.W; ((0 : ℤ) ≤ th ∧ th < Int.ofNat (List.length pcs1)) ∧ (List.length (List.set pcs1 (Int.toNat th) o7) = List.length pcs1 → getElem! (List.set pcs1 (Int.toNat th) o7) ∘ Int.toNat = Function.update (getElem! pcs1 ∘ Int.toNat) th o7 → (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → ¬th1 = lock_holder → ¬has_lock ((List.set pcs1 (Int.toNat th) o7)[Int.toNat th1]!)) ∧ (-(1 : ℤ) ≤ lock_holder ∧ lock_holder < n) ∧ (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (match owners1[Int.toNat b1]! with | Option.none => True | Option.some th1 => ((0 : ℤ) ≤ th1 ∧ th1 < n) ∧ (match memo1[Int.toNat th1]! with | Option.none => False | Option.some tick1 => b tick1 = b1))) ∧ (∀(tick1 : tick), pass1[Int.toNat (b tick1)]! = true → (match owners1[Int.toNat (b tick1)]! with | Option.none => lock_holder = -(1 : ℤ) | Option.some th1 => lock_holder = -(1 : ℤ) ∨ lock_holder = th1)) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n → (match (List.set pcs1 (Int.toNat th) o7)[Int.toNat lock_holder]! with | pc.A3 => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => pass1[Int.toNat (b tick1)]! = true) | pc.W => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => pass1[Int.toNat (b tick1)]! = true) | pc.R1 => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => pass1[Int.toNat (b tick1)]! = true) | pc.R2 => (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → ¬pass1[Int.toNat b1]! = true) | _ => False)) ∧ (∀(b1 : ℤ) (b2 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (0 : ℤ) ≤ b2 ∧ b2 < k * n → pass1[Int.toNat b1]! = true ∧ pass1[Int.toNat b2]! = true → b1 = b2) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n → has_lock ((List.set pcs1 (Int.toNat th) o7)[Int.toNat lock_holder]!) ∧ (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => active_tick = Option.some tick1)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (match memo1[Int.toNat th1]! with | Option.some tick1 => owners1[Int.toNat (b tick1)]! = Option.some th1 | Option.none => True)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (¬memo1[Int.toNat th1]! = Option.none) = has_ticket ((List.set pcs1 (Int.toNat th) o7)[Int.toNat th1]!)) ∧ (∀(tick1 : tick), tick1 ∈ Queue.seq waiting_list1 → (match owners1[Int.toNat (b tick1)]! with | Option.none => False | Option.some th1 => (List.set pcs1 (Int.toNat th) o7)[Int.toNat th1]! = pc.A2 ∧ memo1[Int.toNat th1]! = Option.some tick1)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (match memo1[Int.toNat th1]! with | Option.some tick1 => tick1 ∈ Queue.seq waiting_list1 ∨ active_tick = Option.some tick1 | Option.none => True)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → ¬has_lock ((List.set pcs1 (Int.toNat th) o7)[Int.toNat th1]!) → (match memo1[Int.toNat th1]! with | Option.none => ¬(List.set pcs1 (Int.toNat th) o7)[Int.toNat th1]! = pc.A2 | Option.some tick1 => tick1 ∈ Queue.seq waiting_list1)) ∧ consecutive (Queue.seq waiting_list1) ∧ List.length (Queue.seq waiting_list1) = List.count pc.A2 (List.drop (0 : ℕ) (List.take (Int.toNat n - (0 : ℕ)) (List.set pcs1 (Int.toNat th) o7))) ∧ (∀(tick1 : tick), tick1 ∈ Queue.seq waiting_list1 → v next - Int.ofNat (List.length (Queue.seq waiting_list1)) ≤ v tick1 ∧ v tick1 < v next) ∧ (match last (Queue.seq waiting_list1) with | Option.none => True | Option.some t => v t = v next - (1 : ℤ)) ∧ (match hd (Queue.seq waiting_list1) with | Option.none => True | Option.some t => v t = v next - Int.ofNat (List.length (Queue.seq waiting_list1))) ∧ (match active_tick with | Option.none => lock_holder = -(1 : ℤ) | Option.some tick1 => (match hd (Queue.seq waiting_list1) with | Option.none => v next = v tick1 + (1 : ℤ) | Option.some t => v t = v tick1 + (1 : ℤ)) ∧ v tick1 = v next - Int.ofNat (List.length (Queue.seq waiting_list1)) - (1 : ℤ) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n) ∧ memo1[Int.toNat lock_holder]! = Option.some tick1) ∧ ((0 : ℤ) ≤ Int.ofNat (List.length (Queue.seq waiting_list1)) ∧ Int.ofNat (List.length (Queue.seq waiting_list1)) ≤ n) ∧ (lock_holder = -(1 : ℤ) → ¬Int.ofNat (List.length (Queue.seq waiting_list1)) = (0 : ℤ) ∧ pass1[Int.toNat (b ((Queue.seq waiting_list1)[(0 : ℕ)]!))]! = true ∨ (∃(th1 : ℤ), ((0 : ℤ) ≤ th1 ∧ th1 < n) ∧ memo1[Int.toNat th1]! = Option.none ∧ pass1[Int.toNat (b next)]! = true) ∧ Queue.seq waiting_list1 = ([] : List tick)))) | pc.W => (let o7 : pc := pc.R1; ((0 : ℤ) ≤ th ∧ th < Int.ofNat (List.length pcs1)) ∧ (List.length (List.set pcs1 (Int.toNat th) o7) = List.length pcs1 → getElem! (List.set pcs1 (Int.toNat th) o7) ∘ Int.toNat = Function.update (getElem! pcs1 ∘ Int.toNat) th o7 → (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → ¬th1 = lock_holder → ¬has_lock ((List.set pcs1 (Int.toNat th) o7)[Int.toNat th1]!)) ∧ (-(1 : ℤ) ≤ lock_holder ∧ lock_holder < n) ∧ (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (match owners1[Int.toNat b1]! with | Option.none => True | Option.some th1 => ((0 : ℤ) ≤ th1 ∧ th1 < n) ∧ (match memo1[Int.toNat th1]! with | Option.none => False | Option.some tick1 => b tick1 = b1))) ∧ (∀(tick1 : tick), pass1[Int.toNat (b tick1)]! = true → (match owners1[Int.toNat (b tick1)]! with | Option.none => lock_holder = -(1 : ℤ) | Option.some th1 => lock_holder = -(1 : ℤ) ∨ lock_holder = th1)) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n → (match (List.set pcs1 (Int.toNat th) o7)[Int.toNat lock_holder]! with | pc.A3 => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => pass1[Int.toNat (b tick1)]! = true) | pc.W => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => pass1[Int.toNat (b tick1)]! = true) | pc.R1 => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => pass1[Int.toNat (b tick1)]! = true) | pc.R2 => (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → ¬pass1[Int.toNat b1]! = true) | _ => False)) ∧ (∀(b1 : ℤ) (b2 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (0 : ℤ) ≤ b2 ∧ b2 < k * n → pass1[Int.toNat b1]! = true ∧ pass1[Int.toNat b2]! = true → b1 = b2) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n → has_lock ((List.set pcs1 (Int.toNat th) o7)[Int.toNat lock_holder]!) ∧ (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick1 => active_tick = Option.some tick1)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (match memo1[Int.toNat th1]! with | Option.some tick1 => owners1[Int.toNat (b tick1)]! = Option.some th1 | Option.none => True)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (¬memo1[Int.toNat th1]! = Option.none) = has_ticket ((List.set pcs1 (Int.toNat th) o7)[Int.toNat th1]!)) ∧ (∀(tick1 : tick), tick1 ∈ Queue.seq waiting_list1 → (match owners1[Int.toNat (b tick1)]! with | Option.none => False | Option.some th1 => (List.set pcs1 (Int.toNat th) o7)[Int.toNat th1]! = pc.A2 ∧ memo1[Int.toNat th1]! = Option.some tick1)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (match memo1[Int.toNat th1]! with | Option.some tick1 => tick1 ∈ Queue.seq waiting_list1 ∨ active_tick = Option.some tick1 | Option.none => True)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → ¬has_lock ((List.set pcs1 (Int.toNat th) o7)[Int.toNat th1]!) → (match memo1[Int.toNat th1]! with | Option.none => ¬(List.set pcs1 (Int.toNat th) o7)[Int.toNat th1]! = pc.A2 | Option.some tick1 => tick1 ∈ Queue.seq waiting_list1)) ∧ consecutive (Queue.seq waiting_list1) ∧ List.length (Queue.seq waiting_list1) = List.count pc.A2 (List.drop (0 : ℕ) (List.take (Int.toNat n - (0 : ℕ)) (List.set pcs1 (Int.toNat th) o7))) ∧ (∀(tick1 : tick), tick1 ∈ Queue.seq waiting_list1 → v next - Int.ofNat (List.length (Queue.seq waiting_list1)) ≤ v tick1 ∧ v tick1 < v next) ∧ (match last (Queue.seq waiting_list1) with | Option.none => True | Option.some t => v t = v next - (1 : ℤ)) ∧ (match hd (Queue.seq waiting_list1) with | Option.none => True | Option.some t => v t = v next - Int.ofNat (List.length (Queue.seq waiting_list1))) ∧ (match active_tick with | Option.none => lock_holder = -(1 : ℤ) | Option.some tick1 => (match hd (Queue.seq waiting_list1) with | Option.none => v next = v tick1 + (1 : ℤ) | Option.some t => v t = v tick1 + (1 : ℤ)) ∧ v tick1 = v next - Int.ofNat (List.length (Queue.seq waiting_list1)) - (1 : ℤ) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n) ∧ memo1[Int.toNat lock_holder]! = Option.some tick1) ∧ ((0 : ℤ) ≤ Int.ofNat (List.length (Queue.seq waiting_list1)) ∧ Int.ofNat (List.length (Queue.seq waiting_list1)) ≤ n) ∧ (lock_holder = -(1 : ℤ) → ¬Int.ofNat (List.length (Queue.seq waiting_list1)) = (0 : ℤ) ∧ pass1[Int.toNat (b ((Queue.seq waiting_list1)[(0 : ℕ)]!))]! = true ∨ (∃(th1 : ℤ), ((0 : ℤ) ≤ th1 ∧ th1 < n) ∧ memo1[Int.toNat th1]! = Option.none ∧ pass1[Int.toNat (b next)]! = true) ∧ Queue.seq waiting_list1 = ([] : List tick)))) | pc.R1 => ((0 : ℤ) ≤ th ∧ th < Int.ofNat (List.length memo1)) ∧ (match memo1[Int.toNat th]! with | Option.none => False | Option.some tick1 => (let o7 : Bool := false; let o8 : ℤ := b tick1; ((0 : ℤ) ≤ o8 ∧ o8 < Int.ofNat (List.length pass1)) ∧ (List.length (List.set pass1 (Int.toNat o8) o7) = List.length pass1 → getElem! (List.set pass1 (Int.toNat o8) o7) ∘ Int.toNat = Function.update (getElem! pass1 ∘ Int.toNat) o8 o7 → (let o9 : pc := pc.R2; ((0 : ℤ) ≤ th ∧ th < Int.ofNat (List.length pcs1)) ∧ (List.length (List.set pcs1 (Int.toNat th) o9) = List.length pcs1 → getElem! (List.set pcs1 (Int.toNat th) o9) ∘ Int.toNat = Function.update (getElem! pcs1 ∘ Int.toNat) th o9 → (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → ¬th1 = lock_holder → ¬has_lock ((List.set pcs1 (Int.toNat th) o9)[Int.toNat th1]!)) ∧ (-(1 : ℤ) ≤ lock_holder ∧ lock_holder < n) ∧ (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (match owners1[Int.toNat b1]! with | Option.none => True | Option.some th1 => ((0 : ℤ) ≤ th1 ∧ th1 < n) ∧ (match memo1[Int.toNat th1]! with | Option.none => False | Option.some tick2 => b tick2 = b1))) ∧ (∀(tick2 : tick), (List.set pass1 (Int.toNat o8) o7)[Int.toNat (b tick2)]! = true → (match owners1[Int.toNat (b tick2)]! with | Option.none => lock_holder = -(1 : ℤ) | Option.some th1 => lock_holder = -(1 : ℤ) ∨ lock_holder = th1)) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n → (match (List.set pcs1 (Int.toNat th) o9)[Int.toNat lock_holder]! with | pc.A3 => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick2 => (List.set pass1 (Int.toNat o8) o7)[Int.toNat (b tick2)]! = true) | pc.W => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick2 => (List.set pass1 (Int.toNat o8) o7)[Int.toNat (b tick2)]! = true) | pc.R1 => (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick2 => (List.set pass1 (Int.toNat o8) o7)[Int.toNat (b tick2)]! = true) | pc.R2 => (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → ¬(List.set pass1 (Int.toNat o8) o7)[Int.toNat b1]! = true) | _ => False)) ∧ (∀(b1 : ℤ) (b2 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (0 : ℤ) ≤ b2 ∧ b2 < k * n → (List.set pass1 (Int.toNat o8) o7)[Int.toNat b1]! = true ∧ (List.set pass1 (Int.toNat o8) o7)[Int.toNat b2]! = true → b1 = b2) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n → has_lock ((List.set pcs1 (Int.toNat th) o9)[Int.toNat lock_holder]!) ∧ (match memo1[Int.toNat lock_holder]! with | Option.none => False | Option.some tick2 => active_tick = Option.some tick2)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (match memo1[Int.toNat th1]! with | Option.some tick2 => owners1[Int.toNat (b tick2)]! = Option.some th1 | Option.none => True)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (¬memo1[Int.toNat th1]! = Option.none) = has_ticket ((List.set pcs1 (Int.toNat th) o9)[Int.toNat th1]!)) ∧ (∀(tick2 : tick), tick2 ∈ Queue.seq waiting_list1 → (match owners1[Int.toNat (b tick2)]! with | Option.none => False | Option.some th1 => (List.set pcs1 (Int.toNat th) o9)[Int.toNat th1]! = pc.A2 ∧ memo1[Int.toNat th1]! = Option.some tick2)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (match memo1[Int.toNat th1]! with | Option.some tick2 => tick2 ∈ Queue.seq waiting_list1 ∨ active_tick = Option.some tick2 | Option.none => True)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → ¬has_lock ((List.set pcs1 (Int.toNat th) o9)[Int.toNat th1]!) → (match memo1[Int.toNat th1]! with | Option.none => ¬(List.set pcs1 (Int.toNat th) o9)[Int.toNat th1]! = pc.A2 | Option.some tick2 => tick2 ∈ Queue.seq waiting_list1)) ∧ consecutive (Queue.seq waiting_list1) ∧ List.length (Queue.seq waiting_list1) = List.count pc.A2 (List.drop (0 : ℕ) (List.take (Int.toNat n - (0 : ℕ)) (List.set pcs1 (Int.toNat th) o9))) ∧ (∀(tick2 : tick), tick2 ∈ Queue.seq waiting_list1 → v next - Int.ofNat (List.length (Queue.seq waiting_list1)) ≤ v tick2 ∧ v tick2 < v next) ∧ (match last (Queue.seq waiting_list1) with | Option.none => True | Option.some t => v t = v next - (1 : ℤ)) ∧ (match hd (Queue.seq waiting_list1) with | Option.none => True | Option.some t => v t = v next - Int.ofNat (List.length (Queue.seq waiting_list1))) ∧ (match active_tick with | Option.none => lock_holder = -(1 : ℤ) | Option.some tick2 => (match hd (Queue.seq waiting_list1) with | Option.none => v next = v tick2 + (1 : ℤ) | Option.some t => v t = v tick2 + (1 : ℤ)) ∧ v tick2 = v next - Int.ofNat (List.length (Queue.seq waiting_list1)) - (1 : ℤ) ∧ ((0 : ℤ) ≤ lock_holder ∧ lock_holder < n) ∧ memo1[Int.toNat lock_holder]! = Option.some tick2) ∧ ((0 : ℤ) ≤ Int.ofNat (List.length (Queue.seq waiting_list1)) ∧ Int.ofNat (List.length (Queue.seq waiting_list1)) ≤ n) ∧ (lock_holder = -(1 : ℤ) → ¬Int.ofNat (List.length (Queue.seq waiting_list1)) = (0 : ℤ) ∧ (List.set pass1 (Int.toNat o8) o7)[Int.toNat (b ((Queue.seq waiting_list1)[(0 : ℕ)]!))]! = true ∨ (∃(th1 : ℤ), ((0 : ℤ) ≤ th1 ∧ th1 < n) ∧ memo1[Int.toNat th1]! = Option.none ∧ (List.set pass1 (Int.toNat o8) o7)[Int.toNat (b next)]! = true) ∧ Queue.seq waiting_list1 = ([] : List tick))))))) | pc.R2 => ((0 : ℤ) ≤ th ∧ th < Int.ofNat (List.length memo1)) ∧ (match memo1[Int.toNat th]! with | Option.none => False | Option.some tick1 => (let o7 : ℤ := k * n; ¬o7 = (0 : ℤ) ∧ (let nt : ℤ := (b tick1 + (1 : ℤ)) % o7; let o8 : Bool := true; ((0 : ℤ) ≤ nt ∧ nt < Int.ofNat (List.length pass1)) ∧ (List.length (List.set pass1 (Int.toNat nt) o8) = List.length pass1 → getElem! (List.set pass1 (Int.toNat nt) o8) ∘ Int.toNat = Function.update (getElem! pass1 ∘ Int.toNat) nt o8 → (let o9 : Option tick := Option.none; ((0 : ℤ) ≤ th ∧ th < Int.ofNat (List.length memo1)) ∧ (List.length (List.set memo1 (Int.toNat th) o9) = List.length memo1 → getElem! (List.set memo1 (Int.toNat th) o9) ∘ Int.toNat = Function.update (getElem! memo1 ∘ Int.toNat) th o9 → (let o10 : Option ℤ := Option.none; let o11 : ℤ := b tick1; ((0 : ℤ) ≤ o11 ∧ o11 < Int.ofNat (List.length owners1)) ∧ (List.length (List.set owners1 (Int.toNat o11) o10) = List.length owners1 → getElem! (List.set owners1 (Int.toNat o11) o10) ∘ Int.toNat = Function.update (getElem! owners1 ∘ Int.toNat) o11 o10 → (let o12 : pc := pc.I; ((0 : ℤ) ≤ th ∧ th < Int.ofNat (List.length pcs1)) ∧ (List.length (List.set pcs1 (Int.toNat th) o12) = List.length pcs1 → getElem! (List.set pcs1 (Int.toNat th) o12) ∘ Int.toNat = Function.update (getElem! pcs1 ∘ Int.toNat) th o12 → (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → ¬th1 = -(1 : ℤ) → ¬has_lock ((List.set pcs1 (Int.toNat th) o12)[Int.toNat th1]!)) ∧ (-(1 : ℤ) ≤ -(1 : ℤ) ∧ -(1 : ℤ) < n) ∧ (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (match (List.set owners1 (Int.toNat o11) o10)[Int.toNat b1]! with | Option.none => True | Option.some th1 => ((0 : ℤ) ≤ th1 ∧ th1 < n) ∧ (match (List.set memo1 (Int.toNat th) o9)[Int.toNat th1]! with | Option.none => False | Option.some tick2 => b tick2 = b1))) ∧ (∀(tick2 : tick), (List.set pass1 (Int.toNat nt) o8)[Int.toNat (b tick2)]! = true → (match (List.set owners1 (Int.toNat o11) o10)[Int.toNat (b tick2)]! with | Option.none => True | Option.some th1 => True ∨ -(1 : ℤ) = th1)) ∧ ((0 : ℤ) ≤ -(1 : ℤ) ∧ -(1 : ℤ) < n → (match (List.set pcs1 (Int.toNat th) o12)[Int.toNat (-(1 : ℤ))]! with | pc.A3 => (match (List.set memo1 (Int.toNat th) o9)[Int.toNat (-(1 : ℤ))]! with | Option.none => False | Option.some tick2 => (List.set pass1 (Int.toNat nt) o8)[Int.toNat (b tick2)]! = true) | pc.W => (match (List.set memo1 (Int.toNat th) o9)[Int.toNat (-(1 : ℤ))]! with | Option.none => False | Option.some tick2 => (List.set pass1 (Int.toNat nt) o8)[Int.toNat (b tick2)]! = true) | pc.R1 => (match (List.set memo1 (Int.toNat th) o9)[Int.toNat (-(1 : ℤ))]! with | Option.none => False | Option.some tick2 => (List.set pass1 (Int.toNat nt) o8)[Int.toNat (b tick2)]! = true) | pc.R2 => (∀(b1 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → ¬(List.set pass1 (Int.toNat nt) o8)[Int.toNat b1]! = true) | _ => False)) ∧ (∀(b1 : ℤ) (b2 : ℤ), (0 : ℤ) ≤ b1 ∧ b1 < k * n → (0 : ℤ) ≤ b2 ∧ b2 < k * n → (List.set pass1 (Int.toNat nt) o8)[Int.toNat b1]! = true ∧ (List.set pass1 (Int.toNat nt) o8)[Int.toNat b2]! = true → b1 = b2) ∧ ((0 : ℤ) ≤ -(1 : ℤ) ∧ -(1 : ℤ) < n → has_lock ((List.set pcs1 (Int.toNat th) o12)[Int.toNat (-(1 : ℤ))]!) ∧ (match (List.set memo1 (Int.toNat th) o9)[Int.toNat (-(1 : ℤ))]! with | Option.none => False | Option.some tick2 => Option.none = Option.some tick2)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (match (List.set memo1 (Int.toNat th) o9)[Int.toNat th1]! with | Option.some tick2 => (List.set owners1 (Int.toNat o11) o10)[Int.toNat (b tick2)]! = Option.some th1 | Option.none => True)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (¬(List.set memo1 (Int.toNat th) o9)[Int.toNat th1]! = Option.none) = has_ticket ((List.set pcs1 (Int.toNat th) o12)[Int.toNat th1]!)) ∧ (∀(tick2 : tick), tick2 ∈ Queue.seq waiting_list1 → (match (List.set owners1 (Int.toNat o11) o10)[Int.toNat (b tick2)]! with | Option.none => False | Option.some th1 => (List.set pcs1 (Int.toNat th) o12)[Int.toNat th1]! = pc.A2 ∧ (List.set memo1 (Int.toNat th) o9)[Int.toNat th1]! = Option.some tick2)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → (match (List.set memo1 (Int.toNat th) o9)[Int.toNat th1]! with | Option.some tick2 => tick2 ∈ Queue.seq waiting_list1 ∨ Option.none = Option.some tick2 | Option.none => True)) ∧ (∀(th1 : ℤ), (0 : ℤ) ≤ th1 ∧ th1 < n → ¬has_lock ((List.set pcs1 (Int.toNat th) o12)[Int.toNat th1]!) → (match (List.set memo1 (Int.toNat th) o9)[Int.toNat th1]! with | Option.none => ¬(List.set pcs1 (Int.toNat th) o12)[Int.toNat th1]! = pc.A2 | Option.some tick2 => tick2 ∈ Queue.seq waiting_list1)) ∧ consecutive (Queue.seq waiting_list1) ∧ List.length (Queue.seq waiting_list1) = List.count pc.A2 (List.drop (0 : ℕ) (List.take (Int.toNat n - (0 : ℕ)) (List.set pcs1 (Int.toNat th) o12))) ∧ (∀(tick2 : tick), tick2 ∈ Queue.seq waiting_list1 → v next - Int.ofNat (List.length (Queue.seq waiting_list1)) ≤ v tick2 ∧ v tick2 < v next) ∧ (match last (Queue.seq waiting_list1) with | Option.none => True | Option.some t => v t = v next - (1 : ℤ)) ∧ (match hd (Queue.seq waiting_list1) with | Option.none => True | Option.some t => v t = v next - Int.ofNat (List.length (Queue.seq waiting_list1))) ∧ (match Option.none with | Option.none => True | Option.some tick2 => (match hd (Queue.seq waiting_list1) with | Option.none => v next = v tick2 + (1 : ℤ) | Option.some t => v t = v tick2 + (1 : ℤ)) ∧ v tick2 = v next - Int.ofNat (List.length (Queue.seq waiting_list1)) - (1 : ℤ) ∧ ((0 : ℤ) ≤ -(1 : ℤ) ∧ -(1 : ℤ) < n) ∧ (List.set memo1 (Int.toNat th) o9)[Int.toNat (-(1 : ℤ))]! = Option.some tick2) ∧ ((0 : ℤ) ≤ Int.ofNat (List.length (Queue.seq waiting_list1)) ∧ Int.ofNat (List.length (Queue.seq waiting_list1)) ≤ n) ∧ (¬Int.ofNat (List.length (Queue.seq waiting_list1)) = (0 : ℤ) ∧ (List.set pass1 (Int.toNat nt) o8)[Int.toNat (b ((Queue.seq waiting_list1)[(0 : ℕ)]!))]! = true ∨ (∃(th1 : ℤ), ((0 : ℤ) ≤ th1 ∧ th1 < n) ∧ (List.set memo1 (Int.toNat th) o9)[Int.toNat th1]! = Option.none ∧ (List.set pass1 (Int.toNat nt) o8)[Int.toNat (b next)]! = true) ∧ Queue.seq waiting_list1 = ([] : List tick))))))))))))))))))))))))))
  := sorry
end verifythis_2018_array_based_queuing_lock_2_ABQL_mainqtvc
