From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.why3.Ref.Ref.
Require Import Why3.int.NumOf.
Require Import Why3.queue.Queue.
Open Scope Z_scope.
Axiom n : Z.
Axiom N_val : 2%Z ≤ n.
Axiom k : Z.
Axiom K_val : 2%Z ≤ k.
Axiom tick : Type.
Axiom tick_inhabited : Inhabited tick.
Global Existing Instance tick_inhabited.
Axiom tick_countable : Countable tick.
Global Existing Instance tick_countable.
Axiom b : tick -> Z.
Axiom v : tick -> Z.
Axiom tick'invariant : forall  (self : tick), 0%Z ≤ v self ∧ 0%Z ≤ b self ∧ b self < k * n ∧ b self = ZEuclid.modulo (v self) (k * n).
Definition tick'eq (a : tick) (b1 : tick) := b a = b b1 ∧ v a = v b1.
Axiom tick'inj : forall  (a : tick) (b1 : tick) (fact0 : tick'eq a b1), a = b1.
Definition lt (tick1 : tick) (tick2 : tick) := v tick1 < v tick2.
Definition sorted (s : list tick) := ∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < Z.of_nat (length s) -> lt (nth (Z.to_nat i) s inhabitant) (nth (Z.to_nat j) s inhabitant).
Definition consecutive (l : list tick) := ∀(i : Z), 0%Z < i ∧ i < Z.of_nat (length l) -> v (nth (Z.to_nat i) l inhabitant) = v (nth (Z.to_nat (i - 1%Z)) l inhabitant) + 1%Z.
Definition last (l : list tick) : option tick := if decide (Z.of_nat (length l) = 0%Z) then None else Some (nth (Z.to_nat (Z.of_nat (length l) - 1%Z)) l inhabitant).
Definition hd (l : list tick) : option tick := if decide (Z.of_nat (length l) = 0%Z) then None else Some (nth 0%nat l inhabitant).
Inductive pc :=
  | A1 : pc
  | A2 : pc
  | A3 : pc
  | R1 : pc
  | R2 : pc
  | I : pc
  | W : pc.
Axiom pc_inhabited : Inhabited pc.
Global Existing Instance pc_inhabited.
Axiom pc_countable : Countable pc.
Global Existing Instance pc_countable.
Definition has_ticket (pc1 : pc) := match pc1 with | A1 => False | I => False | _ => True end.
Definition has_lock (pc1 : pc) := match pc1 with | A3 => True | W => True | R1 => True | R2 => True | _ => False end.
Axiom nondet_source : Type.
Axiom nondet_source_inhabited : Inhabited nondet_source.
Global Existing Instance nondet_source_inhabited.
Axiom nondet_source_countable : Countable nondet_source.
Global Existing Instance nondet_source_countable.
Axiom rng : Type.
Axiom rng_inhabited : Inhabited rng.
Global Existing Instance rng_inhabited.
Axiom rng_countable : Countable rng.
Global Existing Instance rng_countable.
Axiom source : rng -> nondet_source.
Axiom fc : forall {α : Type} `{Inhabited α}, list α -> α -> Z -> bool.
Axiom fc'def : forall  {α : Type} `{Inhabited α} (a : list α) (v1 : α) (i : Z), (fc a v1 i = true) = (nth (Z.to_nat i) a inhabitant = v1).
Theorem main'vc : let o1 : Z := k * n in 0%Z ≤ o1 ∧ (∀(pass : list bool), (∀(i : Z), 0%Z ≤ i ∧ i < o1 -> nth (Z.to_nat i) pass inhabitant = false) ∧ Z.of_nat (length pass) = o1 -> (let o2 : bool := true in (0%Z ≤ 0%Z ∧ 0%Z < Z.of_nat (length pass)) ∧ (length (set_list pass 0%nat o2) = length pass -> nth_i (set_list pass 0%nat o2) = fun_updt (nth_i pass) 0%Z o2 -> (0%Z ≤ 0%Z ∧ (0%Z ≤ 0%Z ∧ 0%Z < k * n) ∧ 0%Z = ZEuclid.modulo 0%Z (k * n)) ∧ (∀(o3 : tick), b o3 = 0%Z ∧ v o3 = 0%Z -> (let o4 : Z := n in 0%Z ≤ o4 ∧ (∀(pcs : list pc), (∀(i : Z), 0%Z ≤ i ∧ i < o4 -> nth (Z.to_nat i) pcs inhabitant = I) ∧ Z.of_nat (length pcs) = o4 -> (let o5 : Z := n in 0%Z ≤ o5 ∧ (∀(memo : list (option tick)), (∀(i : Z), 0%Z ≤ i ∧ i < o5 -> nth (Z.to_nat i) memo inhabitant = None) ∧ Z.of_nat (length memo) = o5 -> (let o6 : Z := k * n in 0%Z ≤ o6 ∧ (∀(owners : list (option Z)), (∀(i : Z), 0%Z ≤ i ∧ i < o6 -> nth (Z.to_nat i) owners inhabitant = None) ∧ Z.of_nat (length owners) = o6 -> (∀(waiting_list : Queue.t tick), seq waiting_list = ([] : list tick) -> ((∀(th : Z), 0%Z ≤ th ∧ th < n -> ¬ th = - 1%Z -> ¬ has_lock (nth (Z.to_nat th) pcs inhabitant)) ∧ (- 1%Z ≤ - 1%Z ∧ - 1%Z < n) ∧ (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> (match nth (Z.to_nat b1) owners inhabitant with | None => True | Some th => (0%Z ≤ th ∧ th < n) ∧ (match nth (Z.to_nat th) memo inhabitant with | None => False | Some tick1 => b tick1 = b1 end) end)) ∧ (∀(tick1 : tick), nth (Z.to_nat (b tick1)) (set_list pass 0%nat o2) inhabitant = true -> (match nth (Z.to_nat (b tick1)) owners inhabitant with | None => True | Some th => True end)) ∧ (0%Z ≤ - 1%Z ∧ - 1%Z < n -> (match nth (Z.to_nat (- 1%Z)) pcs inhabitant with | A3 => (match nth (Z.to_nat (- 1%Z)) memo inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) (set_list pass 0%nat o2) inhabitant = true end) | W => (match nth (Z.to_nat (- 1%Z)) memo inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) (set_list pass 0%nat o2) inhabitant = true end) | R1 => (match nth (Z.to_nat (- 1%Z)) memo inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) (set_list pass 0%nat o2) inhabitant = true end) | R2 => (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> ¬ nth (Z.to_nat b1) (set_list pass 0%nat o2) inhabitant = true) | _ => False end)) ∧ (∀(b1 : Z) (b2 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> 0%Z ≤ b2 ∧ b2 < k * n -> nth (Z.to_nat b1) (set_list pass 0%nat o2) inhabitant = true ∧ nth (Z.to_nat b2) (set_list pass 0%nat o2) inhabitant = true -> b1 = b2) ∧ (0%Z ≤ - 1%Z ∧ - 1%Z < n -> has_lock (nth (Z.to_nat (- 1%Z)) pcs inhabitant) ∧ (match nth (Z.to_nat (- 1%Z)) memo inhabitant with | None => False | Some tick1 => False end)) ∧ (∀(th : Z), 0%Z ≤ th ∧ th < n -> (match nth (Z.to_nat th) memo inhabitant with | Some tick1 => nth (Z.to_nat (b tick1)) owners inhabitant = Some th | None => True end)) ∧ (∀(th : Z), 0%Z ≤ th ∧ th < n -> (¬ nth (Z.to_nat th) memo inhabitant = None) = has_ticket (nth (Z.to_nat th) pcs inhabitant)) ∧ (∀(tick1 : tick), tick1 ∈ seq waiting_list -> (match nth (Z.to_nat (b tick1)) owners inhabitant with | None => False | Some th => nth (Z.to_nat th) pcs inhabitant = A2 ∧ nth (Z.to_nat th) memo inhabitant = Some tick1 end)) ∧ (∀(th : Z), 0%Z ≤ th ∧ th < n -> (match nth (Z.to_nat th) memo inhabitant with | Some tick1 => tick1 ∈ seq waiting_list | None => True end)) ∧ (∀(th : Z), 0%Z ≤ th ∧ th < n -> ¬ has_lock (nth (Z.to_nat th) pcs inhabitant) -> (match nth (Z.to_nat th) memo inhabitant with | None => ¬ nth (Z.to_nat th) pcs inhabitant = A2 | Some tick1 => tick1 ∈ seq waiting_list end)) ∧ consecutive (seq waiting_list) ∧ length (seq waiting_list) = count_occ' (drop 0%nat (take (Z.to_nat n - 0%nat) pcs)) A2 ∧ (∀(tick1 : tick), tick1 ∈ seq waiting_list -> v o3 - Z.of_nat (length (seq waiting_list)) ≤ v tick1 ∧ v tick1 < v o3) ∧ (match last (seq waiting_list) with | None => True | Some t => v t = v o3 - 1%Z end) ∧ (match hd (seq waiting_list) with | None => True | Some t => v t = v o3 - Z.of_nat (length (seq waiting_list)) end) ∧ (0%Z ≤ Z.of_nat (length (seq waiting_list)) ∧ Z.of_nat (length (seq waiting_list)) ≤ n) ∧ (¬ Z.of_nat (length (seq waiting_list)) = 0%Z ∧ nth (Z.to_nat (b (nth 0%nat (seq waiting_list) inhabitant))) (set_list pass 0%nat o2) inhabitant = true ∨ (∃(th : Z), (0%Z ≤ th ∧ th < n) ∧ nth (Z.to_nat th) memo inhabitant = None ∧ nth (Z.to_nat (b o3)) (set_list pass 0%nat o2) inhabitant = true) ∧ seq waiting_list = ([] : list tick))) ∧ (∀(active_tick : option tick) (waiting_list1 : Queue.t tick) (lock_holder : Z) (owners1 : list (option Z)) (memo1 : list (option tick)) (pcs1 : list pc) (next : tick) (pass1 : list bool), length owners1 = length owners -> length memo1 = length memo -> length pcs1 = length pcs -> length pass1 = length (set_list pass 0%nat o2) -> (∀(th : Z), 0%Z ≤ th ∧ th < n -> ¬ th = lock_holder -> ¬ has_lock (nth (Z.to_nat th) pcs1 inhabitant)) ∧ (- 1%Z ≤ lock_holder ∧ lock_holder < n) ∧ (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> (match nth (Z.to_nat b1) owners1 inhabitant with | None => True | Some th => (0%Z ≤ th ∧ th < n) ∧ (match nth (Z.to_nat th) memo1 inhabitant with | None => False | Some tick1 => b tick1 = b1 end) end)) ∧ (∀(tick1 : tick), nth (Z.to_nat (b tick1)) pass1 inhabitant = true -> (match nth (Z.to_nat (b tick1)) owners1 inhabitant with | None => lock_holder = - 1%Z | Some th => lock_holder = - 1%Z ∨ lock_holder = th end)) ∧ (0%Z ≤ lock_holder ∧ lock_holder < n -> (match nth (Z.to_nat lock_holder) pcs1 inhabitant with | A3 => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) pass1 inhabitant = true end) | W => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) pass1 inhabitant = true end) | R1 => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) pass1 inhabitant = true end) | R2 => (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> ¬ nth (Z.to_nat b1) pass1 inhabitant = true) | _ => False end)) ∧ (∀(b1 : Z) (b2 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> 0%Z ≤ b2 ∧ b2 < k * n -> nth (Z.to_nat b1) pass1 inhabitant = true ∧ nth (Z.to_nat b2) pass1 inhabitant = true -> b1 = b2) ∧ (0%Z ≤ lock_holder ∧ lock_holder < n -> has_lock (nth (Z.to_nat lock_holder) pcs1 inhabitant) ∧ (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick1 => active_tick = Some tick1 end)) ∧ (∀(th : Z), 0%Z ≤ th ∧ th < n -> (match nth (Z.to_nat th) memo1 inhabitant with | Some tick1 => nth (Z.to_nat (b tick1)) owners1 inhabitant = Some th | None => True end)) ∧ (∀(th : Z), 0%Z ≤ th ∧ th < n -> (¬ nth (Z.to_nat th) memo1 inhabitant = None) = has_ticket (nth (Z.to_nat th) pcs1 inhabitant)) ∧ (∀(tick1 : tick), tick1 ∈ seq waiting_list1 -> (match nth (Z.to_nat (b tick1)) owners1 inhabitant with | None => False | Some th => nth (Z.to_nat th) pcs1 inhabitant = A2 ∧ nth (Z.to_nat th) memo1 inhabitant = Some tick1 end)) ∧ (∀(th : Z), 0%Z ≤ th ∧ th < n -> (match nth (Z.to_nat th) memo1 inhabitant with | Some tick1 => tick1 ∈ seq waiting_list1 ∨ active_tick = Some tick1 | None => True end)) ∧ (∀(th : Z), 0%Z ≤ th ∧ th < n -> ¬ has_lock (nth (Z.to_nat th) pcs1 inhabitant) -> (match nth (Z.to_nat th) memo1 inhabitant with | None => ¬ nth (Z.to_nat th) pcs1 inhabitant = A2 | Some tick1 => tick1 ∈ seq waiting_list1 end)) ∧ consecutive (seq waiting_list1) ∧ length (seq waiting_list1) = count_occ' (drop 0%nat (take (Z.to_nat n - 0%nat) pcs1)) A2 ∧ (∀(tick1 : tick), tick1 ∈ seq waiting_list1 -> v next - Z.of_nat (length (seq waiting_list1)) ≤ v tick1 ∧ v tick1 < v next) ∧ (match last (seq waiting_list1) with | None => True | Some t => v t = v next - 1%Z end) ∧ (match hd (seq waiting_list1) with | None => True | Some t => v t = v next - Z.of_nat (length (seq waiting_list1)) end) ∧ (match active_tick with | None => lock_holder = - 1%Z | Some tick1 => (match hd (seq waiting_list1) with | None => v next = v tick1 + 1%Z | Some t => v t = v tick1 + 1%Z end) ∧ v tick1 = v next - Z.of_nat (length (seq waiting_list1)) - 1%Z ∧ (0%Z ≤ lock_holder ∧ lock_holder < n) ∧ nth (Z.to_nat lock_holder) memo1 inhabitant = Some tick1 end) ∧ (0%Z ≤ Z.of_nat (length (seq waiting_list1)) ∧ Z.of_nat (length (seq waiting_list1)) ≤ n) ∧ (lock_holder = - 1%Z -> ¬ Z.of_nat (length (seq waiting_list1)) = 0%Z ∧ nth (Z.to_nat (b (nth 0%nat (seq waiting_list1) inhabitant))) pass1 inhabitant = true ∨ (∃(th : Z), (0%Z ≤ th ∧ th < n) ∧ nth (Z.to_nat th) memo1 inhabitant = None ∧ nth (Z.to_nat (b next)) pass1 inhabitant = true) ∧ seq waiting_list1 = ([] : list tick)) -> (∀(th : Z), 0%Z ≤ th ∧ th < n -> (0%Z ≤ th ∧ th < Z.of_nat (length pcs1)) ∧ (match nth (Z.to_nat th) pcs1 inhabitant with | I => (let o7 : pc := A1 in (0%Z ≤ th ∧ th < Z.of_nat (length pcs1)) ∧ (length (set_list pcs1 (Z.to_nat th) o7) = length pcs1 -> nth_i (set_list pcs1 (Z.to_nat th) o7) = fun_updt (nth_i pcs1) th o7 -> (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> ¬ th1 = lock_holder -> ¬ has_lock (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o7) inhabitant)) ∧ (- 1%Z ≤ lock_holder ∧ lock_holder < n) ∧ (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> (match nth (Z.to_nat b1) owners1 inhabitant with | None => True | Some th1 => (0%Z ≤ th1 ∧ th1 < n) ∧ (match nth (Z.to_nat th1) memo1 inhabitant with | None => False | Some tick1 => b tick1 = b1 end) end)) ∧ (∀(tick1 : tick), nth (Z.to_nat (b tick1)) pass1 inhabitant = true -> (match nth (Z.to_nat (b tick1)) owners1 inhabitant with | None => lock_holder = - 1%Z | Some th1 => lock_holder = - 1%Z ∨ lock_holder = th1 end)) ∧ (0%Z ≤ lock_holder ∧ lock_holder < n -> (match nth (Z.to_nat lock_holder) (set_list pcs1 (Z.to_nat th) o7) inhabitant with | A3 => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) pass1 inhabitant = true end) | W => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) pass1 inhabitant = true end) | R1 => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) pass1 inhabitant = true end) | R2 => (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> ¬ nth (Z.to_nat b1) pass1 inhabitant = true) | _ => False end)) ∧ (∀(b1 : Z) (b2 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> 0%Z ≤ b2 ∧ b2 < k * n -> nth (Z.to_nat b1) pass1 inhabitant = true ∧ nth (Z.to_nat b2) pass1 inhabitant = true -> b1 = b2) ∧ (0%Z ≤ lock_holder ∧ lock_holder < n -> has_lock (nth (Z.to_nat lock_holder) (set_list pcs1 (Z.to_nat th) o7) inhabitant) ∧ (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick1 => active_tick = Some tick1 end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (match nth (Z.to_nat th1) memo1 inhabitant with | Some tick1 => nth (Z.to_nat (b tick1)) owners1 inhabitant = Some th1 | None => True end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (¬ nth (Z.to_nat th1) memo1 inhabitant = None) = has_ticket (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o7) inhabitant)) ∧ (∀(tick1 : tick), tick1 ∈ seq waiting_list1 -> (match nth (Z.to_nat (b tick1)) owners1 inhabitant with | None => False | Some th1 => nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o7) inhabitant = A2 ∧ nth (Z.to_nat th1) memo1 inhabitant = Some tick1 end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (match nth (Z.to_nat th1) memo1 inhabitant with | Some tick1 => tick1 ∈ seq waiting_list1 ∨ active_tick = Some tick1 | None => True end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> ¬ has_lock (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o7) inhabitant) -> (match nth (Z.to_nat th1) memo1 inhabitant with | None => ¬ nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o7) inhabitant = A2 | Some tick1 => tick1 ∈ seq waiting_list1 end)) ∧ consecutive (seq waiting_list1) ∧ length (seq waiting_list1) = count_occ' (drop 0%nat (take (Z.to_nat n - 0%nat) (set_list pcs1 (Z.to_nat th) o7))) A2 ∧ (∀(tick1 : tick), tick1 ∈ seq waiting_list1 -> v next - Z.of_nat (length (seq waiting_list1)) ≤ v tick1 ∧ v tick1 < v next) ∧ (match last (seq waiting_list1) with | None => True | Some t => v t = v next - 1%Z end) ∧ (match hd (seq waiting_list1) with | None => True | Some t => v t = v next - Z.of_nat (length (seq waiting_list1)) end) ∧ (match active_tick with | None => lock_holder = - 1%Z | Some tick1 => (match hd (seq waiting_list1) with | None => v next = v tick1 + 1%Z | Some t => v t = v tick1 + 1%Z end) ∧ v tick1 = v next - Z.of_nat (length (seq waiting_list1)) - 1%Z ∧ (0%Z ≤ lock_holder ∧ lock_holder < n) ∧ nth (Z.to_nat lock_holder) memo1 inhabitant = Some tick1 end) ∧ (0%Z ≤ Z.of_nat (length (seq waiting_list1)) ∧ Z.of_nat (length (seq waiting_list1)) ≤ n) ∧ (lock_holder = - 1%Z -> ¬ Z.of_nat (length (seq waiting_list1)) = 0%Z ∧ nth (Z.to_nat (b (nth 0%nat (seq waiting_list1) inhabitant))) pass1 inhabitant = true ∨ (∃(th1 : Z), (0%Z ≤ th1 ∧ th1 < n) ∧ nth (Z.to_nat th1) memo1 inhabitant = None ∧ nth (Z.to_nat (b next)) pass1 inhabitant = true) ∧ seq waiting_list1 = ([] : list tick)))) | A1 => (∀(next1 : tick), v next1 = v next + 1%Z -> (let o7 : option Z := Some th in let o8 : Z := b next in (0%Z ≤ o8 ∧ o8 < Z.of_nat (length owners1)) ∧ (length (set_list owners1 (Z.to_nat o8) o7) = length owners1 -> nth_i (set_list owners1 (Z.to_nat o8) o7) = fun_updt (nth_i owners1) o8 o7 -> (let o9 : option tick := Some next in (0%Z ≤ th ∧ th < Z.of_nat (length memo1)) ∧ (length (set_list memo1 (Z.to_nat th) o9) = length memo1 -> nth_i (set_list memo1 (Z.to_nat th) o9) = fun_updt (nth_i memo1) th o9 -> (let o10 : pc := A2 in (0%Z ≤ th ∧ th < Z.of_nat (length pcs1)) ∧ (length (set_list pcs1 (Z.to_nat th) o10) = length pcs1 -> nth_i (set_list pcs1 (Z.to_nat th) o10) = fun_updt (nth_i pcs1) th o10 -> (∀(waiting_list2 : Queue.t tick), seq waiting_list2 = seq waiting_list1 ++ [next] -> (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> ¬ th1 = lock_holder -> ¬ has_lock (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o10) inhabitant)) ∧ (- 1%Z ≤ lock_holder ∧ lock_holder < n) ∧ (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> (match nth (Z.to_nat b1) (set_list owners1 (Z.to_nat o8) o7) inhabitant with | None => True | Some th1 => (0%Z ≤ th1 ∧ th1 < n) ∧ (match nth (Z.to_nat th1) (set_list memo1 (Z.to_nat th) o9) inhabitant with | None => False | Some tick1 => b tick1 = b1 end) end)) ∧ (∀(tick1 : tick), nth (Z.to_nat (b tick1)) pass1 inhabitant = true -> (match nth (Z.to_nat (b tick1)) (set_list owners1 (Z.to_nat o8) o7) inhabitant with | None => lock_holder = - 1%Z | Some th1 => lock_holder = - 1%Z ∨ lock_holder = th1 end)) ∧ (0%Z ≤ lock_holder ∧ lock_holder < n -> (match nth (Z.to_nat lock_holder) (set_list pcs1 (Z.to_nat th) o10) inhabitant with | A3 => (match nth (Z.to_nat lock_holder) (set_list memo1 (Z.to_nat th) o9) inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) pass1 inhabitant = true end) | W => (match nth (Z.to_nat lock_holder) (set_list memo1 (Z.to_nat th) o9) inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) pass1 inhabitant = true end) | R1 => (match nth (Z.to_nat lock_holder) (set_list memo1 (Z.to_nat th) o9) inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) pass1 inhabitant = true end) | R2 => (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> ¬ nth (Z.to_nat b1) pass1 inhabitant = true) | _ => False end)) ∧ (∀(b1 : Z) (b2 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> 0%Z ≤ b2 ∧ b2 < k * n -> nth (Z.to_nat b1) pass1 inhabitant = true ∧ nth (Z.to_nat b2) pass1 inhabitant = true -> b1 = b2) ∧ (0%Z ≤ lock_holder ∧ lock_holder < n -> has_lock (nth (Z.to_nat lock_holder) (set_list pcs1 (Z.to_nat th) o10) inhabitant) ∧ (match nth (Z.to_nat lock_holder) (set_list memo1 (Z.to_nat th) o9) inhabitant with | None => False | Some tick1 => active_tick = Some tick1 end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (match nth (Z.to_nat th1) (set_list memo1 (Z.to_nat th) o9) inhabitant with | Some tick1 => nth (Z.to_nat (b tick1)) (set_list owners1 (Z.to_nat o8) o7) inhabitant = Some th1 | None => True end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (¬ nth (Z.to_nat th1) (set_list memo1 (Z.to_nat th) o9) inhabitant = None) = has_ticket (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o10) inhabitant)) ∧ (∀(tick1 : tick), tick1 ∈ seq waiting_list2 -> (match nth (Z.to_nat (b tick1)) (set_list owners1 (Z.to_nat o8) o7) inhabitant with | None => False | Some th1 => nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o10) inhabitant = A2 ∧ nth (Z.to_nat th1) (set_list memo1 (Z.to_nat th) o9) inhabitant = Some tick1 end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (match nth (Z.to_nat th1) (set_list memo1 (Z.to_nat th) o9) inhabitant with | Some tick1 => tick1 ∈ seq waiting_list2 ∨ active_tick = Some tick1 | None => True end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> ¬ has_lock (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o10) inhabitant) -> (match nth (Z.to_nat th1) (set_list memo1 (Z.to_nat th) o9) inhabitant with | None => ¬ nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o10) inhabitant = A2 | Some tick1 => tick1 ∈ seq waiting_list2 end)) ∧ consecutive (seq waiting_list2) ∧ length (seq waiting_list2) = count_occ' (drop 0%nat (take (Z.to_nat n - 0%nat) (set_list pcs1 (Z.to_nat th) o10))) A2 ∧ (∀(tick1 : tick), tick1 ∈ seq waiting_list2 -> v next1 - Z.of_nat (length (seq waiting_list2)) ≤ v tick1 ∧ v tick1 < v next1) ∧ (match last (seq waiting_list2) with | None => True | Some t => v t = v next1 - 1%Z end) ∧ (match hd (seq waiting_list2) with | None => True | Some t => v t = v next1 - Z.of_nat (length (seq waiting_list2)) end) ∧ (match active_tick with | None => lock_holder = - 1%Z | Some tick1 => (match hd (seq waiting_list2) with | None => v next1 = v tick1 + 1%Z | Some t => v t = v tick1 + 1%Z end) ∧ v tick1 = v next1 - Z.of_nat (length (seq waiting_list2)) - 1%Z ∧ (0%Z ≤ lock_holder ∧ lock_holder < n) ∧ nth (Z.to_nat lock_holder) (set_list memo1 (Z.to_nat th) o9) inhabitant = Some tick1 end) ∧ (0%Z ≤ Z.of_nat (length (seq waiting_list2)) ∧ Z.of_nat (length (seq waiting_list2)) ≤ n) ∧ (lock_holder = - 1%Z -> ¬ Z.of_nat (length (seq waiting_list2)) = 0%Z ∧ nth (Z.to_nat (b (nth 0%nat (seq waiting_list2) inhabitant))) pass1 inhabitant = true ∨ (∃(th1 : Z), (0%Z ≤ th1 ∧ th1 < n) ∧ nth (Z.to_nat th1) (set_list memo1 (Z.to_nat th) o9) inhabitant = None ∧ nth (Z.to_nat (b next1)) pass1 inhabitant = true) ∧ seq waiting_list2 = ([] : list tick)))))))))) | A2 => (0%Z ≤ th ∧ th < Z.of_nat (length memo1)) ∧ (match nth (Z.to_nat th) memo1 inhabitant with | None => False | Some tick1 => (let o7 : Z := b tick1 in (0%Z ≤ o7 ∧ o7 < Z.of_nat (length pass1)) ∧ (if decide (nth (Z.to_nat o7) pass1 inhabitant = true) then let o8 : pc := A3 in (0%Z ≤ th ∧ th < Z.of_nat (length pcs1)) ∧ (length (set_list pcs1 (Z.to_nat th) o8) = length pcs1 -> nth_i (set_list pcs1 (Z.to_nat th) o8) = fun_updt (nth_i pcs1) th o8 -> ¬ seq waiting_list1 = ([] : list tick) ∧ (∀(waiting_list2 : Queue.t tick), seq waiting_list2 = drop 1%nat (seq waiting_list1) -> (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> ¬ th1 = th -> ¬ has_lock (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o8) inhabitant)) ∧ (- 1%Z ≤ th ∧ th < n) ∧ (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> (match nth (Z.to_nat b1) owners1 inhabitant with | None => True | Some th1 => (0%Z ≤ th1 ∧ th1 < n) ∧ (match nth (Z.to_nat th1) memo1 inhabitant with | None => False | Some tick2 => b tick2 = b1 end) end)) ∧ (∀(tick2 : tick), nth (Z.to_nat (b tick2)) pass1 inhabitant = true -> (match nth (Z.to_nat (b tick2)) owners1 inhabitant with | None => th = - 1%Z | Some th1 => th = - 1%Z ∨ th = th1 end)) ∧ (0%Z ≤ th ∧ th < n -> (match nth (Z.to_nat th) (set_list pcs1 (Z.to_nat th) o8) inhabitant with | A3 => (match nth (Z.to_nat th) memo1 inhabitant with | None => False | Some tick2 => nth (Z.to_nat (b tick2)) pass1 inhabitant = true end) | W => (match nth (Z.to_nat th) memo1 inhabitant with | None => False | Some tick2 => nth (Z.to_nat (b tick2)) pass1 inhabitant = true end) | R1 => (match nth (Z.to_nat th) memo1 inhabitant with | None => False | Some tick2 => nth (Z.to_nat (b tick2)) pass1 inhabitant = true end) | R2 => (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> ¬ nth (Z.to_nat b1) pass1 inhabitant = true) | _ => False end)) ∧ (∀(b1 : Z) (b2 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> 0%Z ≤ b2 ∧ b2 < k * n -> nth (Z.to_nat b1) pass1 inhabitant = true ∧ nth (Z.to_nat b2) pass1 inhabitant = true -> b1 = b2) ∧ (0%Z ≤ th ∧ th < n -> has_lock (nth (Z.to_nat th) (set_list pcs1 (Z.to_nat th) o8) inhabitant) ∧ (match nth (Z.to_nat th) memo1 inhabitant with | None => False | Some tick2 => Some tick1 = Some tick2 end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (match nth (Z.to_nat th1) memo1 inhabitant with | Some tick2 => nth (Z.to_nat (b tick2)) owners1 inhabitant = Some th1 | None => True end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (¬ nth (Z.to_nat th1) memo1 inhabitant = None) = has_ticket (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o8) inhabitant)) ∧ (∀(tick2 : tick), tick2 ∈ seq waiting_list2 -> (match nth (Z.to_nat (b tick2)) owners1 inhabitant with | None => False | Some th1 => nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o8) inhabitant = A2 ∧ nth (Z.to_nat th1) memo1 inhabitant = Some tick2 end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (match nth (Z.to_nat th1) memo1 inhabitant with | Some tick2 => tick2 ∈ seq waiting_list2 ∨ Some tick1 = Some tick2 | None => True end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> ¬ has_lock (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o8) inhabitant) -> (match nth (Z.to_nat th1) memo1 inhabitant with | None => ¬ nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o8) inhabitant = A2 | Some tick2 => tick2 ∈ seq waiting_list2 end)) ∧ consecutive (seq waiting_list2) ∧ length (seq waiting_list2) = count_occ' (drop 0%nat (take (Z.to_nat n - 0%nat) (set_list pcs1 (Z.to_nat th) o8))) A2 ∧ (∀(tick2 : tick), tick2 ∈ seq waiting_list2 -> v next - Z.of_nat (length (seq waiting_list2)) ≤ v tick2 ∧ v tick2 < v next) ∧ (match last (seq waiting_list2) with | None => True | Some t => v t = v next - 1%Z end) ∧ (match hd (seq waiting_list2) with | None => True | Some t => v t = v next - Z.of_nat (length (seq waiting_list2)) end) ∧ (match Some tick1 with | None => th = - 1%Z | Some tick2 => (match hd (seq waiting_list2) with | None => v next = v tick2 + 1%Z | Some t => v t = v tick2 + 1%Z end) ∧ v tick2 = v next - Z.of_nat (length (seq waiting_list2)) - 1%Z ∧ (0%Z ≤ th ∧ th < n) ∧ nth (Z.to_nat th) memo1 inhabitant = Some tick2 end) ∧ (0%Z ≤ Z.of_nat (length (seq waiting_list2)) ∧ Z.of_nat (length (seq waiting_list2)) ≤ n) ∧ (th = - 1%Z -> ¬ Z.of_nat (length (seq waiting_list2)) = 0%Z ∧ nth (Z.to_nat (b (nth 0%nat (seq waiting_list2) inhabitant))) pass1 inhabitant = true ∨ (∃(th1 : Z), (0%Z ≤ th1 ∧ th1 < n) ∧ nth (Z.to_nat th1) memo1 inhabitant = None ∧ nth (Z.to_nat (b next)) pass1 inhabitant = true) ∧ seq waiting_list2 = ([] : list tick)))) else (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> ¬ th1 = lock_holder -> ¬ has_lock (nth (Z.to_nat th1) pcs1 inhabitant)) ∧ (- 1%Z ≤ lock_holder ∧ lock_holder < n) ∧ (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> (match nth (Z.to_nat b1) owners1 inhabitant with | None => True | Some th1 => (0%Z ≤ th1 ∧ th1 < n) ∧ (match nth (Z.to_nat th1) memo1 inhabitant with | None => False | Some tick2 => b tick2 = b1 end) end)) ∧ (∀(tick2 : tick), nth (Z.to_nat (b tick2)) pass1 inhabitant = true -> (match nth (Z.to_nat (b tick2)) owners1 inhabitant with | None => lock_holder = - 1%Z | Some th1 => lock_holder = - 1%Z ∨ lock_holder = th1 end)) ∧ (0%Z ≤ lock_holder ∧ lock_holder < n -> (match nth (Z.to_nat lock_holder) pcs1 inhabitant with | A3 => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick2 => nth (Z.to_nat (b tick2)) pass1 inhabitant = true end) | W => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick2 => nth (Z.to_nat (b tick2)) pass1 inhabitant = true end) | R1 => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick2 => nth (Z.to_nat (b tick2)) pass1 inhabitant = true end) | R2 => (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> ¬ nth (Z.to_nat b1) pass1 inhabitant = true) | _ => False end)) ∧ (∀(b1 : Z) (b2 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> 0%Z ≤ b2 ∧ b2 < k * n -> nth (Z.to_nat b1) pass1 inhabitant = true ∧ nth (Z.to_nat b2) pass1 inhabitant = true -> b1 = b2) ∧ (0%Z ≤ lock_holder ∧ lock_holder < n -> has_lock (nth (Z.to_nat lock_holder) pcs1 inhabitant) ∧ (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick2 => active_tick = Some tick2 end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (match nth (Z.to_nat th1) memo1 inhabitant with | Some tick2 => nth (Z.to_nat (b tick2)) owners1 inhabitant = Some th1 | None => True end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (¬ nth (Z.to_nat th1) memo1 inhabitant = None) = has_ticket (nth (Z.to_nat th1) pcs1 inhabitant)) ∧ (∀(tick2 : tick), tick2 ∈ seq waiting_list1 -> (match nth (Z.to_nat (b tick2)) owners1 inhabitant with | None => False | Some th1 => nth (Z.to_nat th1) pcs1 inhabitant = A2 ∧ nth (Z.to_nat th1) memo1 inhabitant = Some tick2 end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (match nth (Z.to_nat th1) memo1 inhabitant with | Some tick2 => tick2 ∈ seq waiting_list1 ∨ active_tick = Some tick2 | None => True end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> ¬ has_lock (nth (Z.to_nat th1) pcs1 inhabitant) -> (match nth (Z.to_nat th1) memo1 inhabitant with | None => ¬ nth (Z.to_nat th1) pcs1 inhabitant = A2 | Some tick2 => tick2 ∈ seq waiting_list1 end)) ∧ consecutive (seq waiting_list1) ∧ length (seq waiting_list1) = count_occ' (drop 0%nat (take (Z.to_nat n - 0%nat) pcs1)) A2 ∧ (∀(tick2 : tick), tick2 ∈ seq waiting_list1 -> v next - Z.of_nat (length (seq waiting_list1)) ≤ v tick2 ∧ v tick2 < v next) ∧ (match last (seq waiting_list1) with | None => True | Some t => v t = v next - 1%Z end) ∧ (match hd (seq waiting_list1) with | None => True | Some t => v t = v next - Z.of_nat (length (seq waiting_list1)) end) ∧ (match active_tick with | None => lock_holder = - 1%Z | Some tick2 => (match hd (seq waiting_list1) with | None => v next = v tick2 + 1%Z | Some t => v t = v tick2 + 1%Z end) ∧ v tick2 = v next - Z.of_nat (length (seq waiting_list1)) - 1%Z ∧ (0%Z ≤ lock_holder ∧ lock_holder < n) ∧ nth (Z.to_nat lock_holder) memo1 inhabitant = Some tick2 end) ∧ (0%Z ≤ Z.of_nat (length (seq waiting_list1)) ∧ Z.of_nat (length (seq waiting_list1)) ≤ n) ∧ (lock_holder = - 1%Z -> ¬ Z.of_nat (length (seq waiting_list1)) = 0%Z ∧ nth (Z.to_nat (b (nth 0%nat (seq waiting_list1) inhabitant))) pass1 inhabitant = true ∨ (∃(th1 : Z), (0%Z ≤ th1 ∧ th1 < n) ∧ nth (Z.to_nat th1) memo1 inhabitant = None ∧ nth (Z.to_nat (b next)) pass1 inhabitant = true) ∧ seq waiting_list1 = ([] : list tick)))) end) | A3 => (let o7 : pc := W in (0%Z ≤ th ∧ th < Z.of_nat (length pcs1)) ∧ (length (set_list pcs1 (Z.to_nat th) o7) = length pcs1 -> nth_i (set_list pcs1 (Z.to_nat th) o7) = fun_updt (nth_i pcs1) th o7 -> (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> ¬ th1 = lock_holder -> ¬ has_lock (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o7) inhabitant)) ∧ (- 1%Z ≤ lock_holder ∧ lock_holder < n) ∧ (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> (match nth (Z.to_nat b1) owners1 inhabitant with | None => True | Some th1 => (0%Z ≤ th1 ∧ th1 < n) ∧ (match nth (Z.to_nat th1) memo1 inhabitant with | None => False | Some tick1 => b tick1 = b1 end) end)) ∧ (∀(tick1 : tick), nth (Z.to_nat (b tick1)) pass1 inhabitant = true -> (match nth (Z.to_nat (b tick1)) owners1 inhabitant with | None => lock_holder = - 1%Z | Some th1 => lock_holder = - 1%Z ∨ lock_holder = th1 end)) ∧ (0%Z ≤ lock_holder ∧ lock_holder < n -> (match nth (Z.to_nat lock_holder) (set_list pcs1 (Z.to_nat th) o7) inhabitant with | A3 => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) pass1 inhabitant = true end) | W => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) pass1 inhabitant = true end) | R1 => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) pass1 inhabitant = true end) | R2 => (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> ¬ nth (Z.to_nat b1) pass1 inhabitant = true) | _ => False end)) ∧ (∀(b1 : Z) (b2 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> 0%Z ≤ b2 ∧ b2 < k * n -> nth (Z.to_nat b1) pass1 inhabitant = true ∧ nth (Z.to_nat b2) pass1 inhabitant = true -> b1 = b2) ∧ (0%Z ≤ lock_holder ∧ lock_holder < n -> has_lock (nth (Z.to_nat lock_holder) (set_list pcs1 (Z.to_nat th) o7) inhabitant) ∧ (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick1 => active_tick = Some tick1 end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (match nth (Z.to_nat th1) memo1 inhabitant with | Some tick1 => nth (Z.to_nat (b tick1)) owners1 inhabitant = Some th1 | None => True end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (¬ nth (Z.to_nat th1) memo1 inhabitant = None) = has_ticket (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o7) inhabitant)) ∧ (∀(tick1 : tick), tick1 ∈ seq waiting_list1 -> (match nth (Z.to_nat (b tick1)) owners1 inhabitant with | None => False | Some th1 => nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o7) inhabitant = A2 ∧ nth (Z.to_nat th1) memo1 inhabitant = Some tick1 end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (match nth (Z.to_nat th1) memo1 inhabitant with | Some tick1 => tick1 ∈ seq waiting_list1 ∨ active_tick = Some tick1 | None => True end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> ¬ has_lock (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o7) inhabitant) -> (match nth (Z.to_nat th1) memo1 inhabitant with | None => ¬ nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o7) inhabitant = A2 | Some tick1 => tick1 ∈ seq waiting_list1 end)) ∧ consecutive (seq waiting_list1) ∧ length (seq waiting_list1) = count_occ' (drop 0%nat (take (Z.to_nat n - 0%nat) (set_list pcs1 (Z.to_nat th) o7))) A2 ∧ (∀(tick1 : tick), tick1 ∈ seq waiting_list1 -> v next - Z.of_nat (length (seq waiting_list1)) ≤ v tick1 ∧ v tick1 < v next) ∧ (match last (seq waiting_list1) with | None => True | Some t => v t = v next - 1%Z end) ∧ (match hd (seq waiting_list1) with | None => True | Some t => v t = v next - Z.of_nat (length (seq waiting_list1)) end) ∧ (match active_tick with | None => lock_holder = - 1%Z | Some tick1 => (match hd (seq waiting_list1) with | None => v next = v tick1 + 1%Z | Some t => v t = v tick1 + 1%Z end) ∧ v tick1 = v next - Z.of_nat (length (seq waiting_list1)) - 1%Z ∧ (0%Z ≤ lock_holder ∧ lock_holder < n) ∧ nth (Z.to_nat lock_holder) memo1 inhabitant = Some tick1 end) ∧ (0%Z ≤ Z.of_nat (length (seq waiting_list1)) ∧ Z.of_nat (length (seq waiting_list1)) ≤ n) ∧ (lock_holder = - 1%Z -> ¬ Z.of_nat (length (seq waiting_list1)) = 0%Z ∧ nth (Z.to_nat (b (nth 0%nat (seq waiting_list1) inhabitant))) pass1 inhabitant = true ∨ (∃(th1 : Z), (0%Z ≤ th1 ∧ th1 < n) ∧ nth (Z.to_nat th1) memo1 inhabitant = None ∧ nth (Z.to_nat (b next)) pass1 inhabitant = true) ∧ seq waiting_list1 = ([] : list tick)))) | W => (let o7 : pc := R1 in (0%Z ≤ th ∧ th < Z.of_nat (length pcs1)) ∧ (length (set_list pcs1 (Z.to_nat th) o7) = length pcs1 -> nth_i (set_list pcs1 (Z.to_nat th) o7) = fun_updt (nth_i pcs1) th o7 -> (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> ¬ th1 = lock_holder -> ¬ has_lock (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o7) inhabitant)) ∧ (- 1%Z ≤ lock_holder ∧ lock_holder < n) ∧ (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> (match nth (Z.to_nat b1) owners1 inhabitant with | None => True | Some th1 => (0%Z ≤ th1 ∧ th1 < n) ∧ (match nth (Z.to_nat th1) memo1 inhabitant with | None => False | Some tick1 => b tick1 = b1 end) end)) ∧ (∀(tick1 : tick), nth (Z.to_nat (b tick1)) pass1 inhabitant = true -> (match nth (Z.to_nat (b tick1)) owners1 inhabitant with | None => lock_holder = - 1%Z | Some th1 => lock_holder = - 1%Z ∨ lock_holder = th1 end)) ∧ (0%Z ≤ lock_holder ∧ lock_holder < n -> (match nth (Z.to_nat lock_holder) (set_list pcs1 (Z.to_nat th) o7) inhabitant with | A3 => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) pass1 inhabitant = true end) | W => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) pass1 inhabitant = true end) | R1 => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick1 => nth (Z.to_nat (b tick1)) pass1 inhabitant = true end) | R2 => (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> ¬ nth (Z.to_nat b1) pass1 inhabitant = true) | _ => False end)) ∧ (∀(b1 : Z) (b2 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> 0%Z ≤ b2 ∧ b2 < k * n -> nth (Z.to_nat b1) pass1 inhabitant = true ∧ nth (Z.to_nat b2) pass1 inhabitant = true -> b1 = b2) ∧ (0%Z ≤ lock_holder ∧ lock_holder < n -> has_lock (nth (Z.to_nat lock_holder) (set_list pcs1 (Z.to_nat th) o7) inhabitant) ∧ (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick1 => active_tick = Some tick1 end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (match nth (Z.to_nat th1) memo1 inhabitant with | Some tick1 => nth (Z.to_nat (b tick1)) owners1 inhabitant = Some th1 | None => True end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (¬ nth (Z.to_nat th1) memo1 inhabitant = None) = has_ticket (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o7) inhabitant)) ∧ (∀(tick1 : tick), tick1 ∈ seq waiting_list1 -> (match nth (Z.to_nat (b tick1)) owners1 inhabitant with | None => False | Some th1 => nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o7) inhabitant = A2 ∧ nth (Z.to_nat th1) memo1 inhabitant = Some tick1 end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (match nth (Z.to_nat th1) memo1 inhabitant with | Some tick1 => tick1 ∈ seq waiting_list1 ∨ active_tick = Some tick1 | None => True end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> ¬ has_lock (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o7) inhabitant) -> (match nth (Z.to_nat th1) memo1 inhabitant with | None => ¬ nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o7) inhabitant = A2 | Some tick1 => tick1 ∈ seq waiting_list1 end)) ∧ consecutive (seq waiting_list1) ∧ length (seq waiting_list1) = count_occ' (drop 0%nat (take (Z.to_nat n - 0%nat) (set_list pcs1 (Z.to_nat th) o7))) A2 ∧ (∀(tick1 : tick), tick1 ∈ seq waiting_list1 -> v next - Z.of_nat (length (seq waiting_list1)) ≤ v tick1 ∧ v tick1 < v next) ∧ (match last (seq waiting_list1) with | None => True | Some t => v t = v next - 1%Z end) ∧ (match hd (seq waiting_list1) with | None => True | Some t => v t = v next - Z.of_nat (length (seq waiting_list1)) end) ∧ (match active_tick with | None => lock_holder = - 1%Z | Some tick1 => (match hd (seq waiting_list1) with | None => v next = v tick1 + 1%Z | Some t => v t = v tick1 + 1%Z end) ∧ v tick1 = v next - Z.of_nat (length (seq waiting_list1)) - 1%Z ∧ (0%Z ≤ lock_holder ∧ lock_holder < n) ∧ nth (Z.to_nat lock_holder) memo1 inhabitant = Some tick1 end) ∧ (0%Z ≤ Z.of_nat (length (seq waiting_list1)) ∧ Z.of_nat (length (seq waiting_list1)) ≤ n) ∧ (lock_holder = - 1%Z -> ¬ Z.of_nat (length (seq waiting_list1)) = 0%Z ∧ nth (Z.to_nat (b (nth 0%nat (seq waiting_list1) inhabitant))) pass1 inhabitant = true ∨ (∃(th1 : Z), (0%Z ≤ th1 ∧ th1 < n) ∧ nth (Z.to_nat th1) memo1 inhabitant = None ∧ nth (Z.to_nat (b next)) pass1 inhabitant = true) ∧ seq waiting_list1 = ([] : list tick)))) | R1 => (0%Z ≤ th ∧ th < Z.of_nat (length memo1)) ∧ (match nth (Z.to_nat th) memo1 inhabitant with | None => False | Some tick1 => (let o7 : bool := false in let o8 : Z := b tick1 in (0%Z ≤ o8 ∧ o8 < Z.of_nat (length pass1)) ∧ (length (set_list pass1 (Z.to_nat o8) o7) = length pass1 -> nth_i (set_list pass1 (Z.to_nat o8) o7) = fun_updt (nth_i pass1) o8 o7 -> (let o9 : pc := R2 in (0%Z ≤ th ∧ th < Z.of_nat (length pcs1)) ∧ (length (set_list pcs1 (Z.to_nat th) o9) = length pcs1 -> nth_i (set_list pcs1 (Z.to_nat th) o9) = fun_updt (nth_i pcs1) th o9 -> (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> ¬ th1 = lock_holder -> ¬ has_lock (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o9) inhabitant)) ∧ (- 1%Z ≤ lock_holder ∧ lock_holder < n) ∧ (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> (match nth (Z.to_nat b1) owners1 inhabitant with | None => True | Some th1 => (0%Z ≤ th1 ∧ th1 < n) ∧ (match nth (Z.to_nat th1) memo1 inhabitant with | None => False | Some tick2 => b tick2 = b1 end) end)) ∧ (∀(tick2 : tick), nth (Z.to_nat (b tick2)) (set_list pass1 (Z.to_nat o8) o7) inhabitant = true -> (match nth (Z.to_nat (b tick2)) owners1 inhabitant with | None => lock_holder = - 1%Z | Some th1 => lock_holder = - 1%Z ∨ lock_holder = th1 end)) ∧ (0%Z ≤ lock_holder ∧ lock_holder < n -> (match nth (Z.to_nat lock_holder) (set_list pcs1 (Z.to_nat th) o9) inhabitant with | A3 => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick2 => nth (Z.to_nat (b tick2)) (set_list pass1 (Z.to_nat o8) o7) inhabitant = true end) | W => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick2 => nth (Z.to_nat (b tick2)) (set_list pass1 (Z.to_nat o8) o7) inhabitant = true end) | R1 => (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick2 => nth (Z.to_nat (b tick2)) (set_list pass1 (Z.to_nat o8) o7) inhabitant = true end) | R2 => (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> ¬ nth (Z.to_nat b1) (set_list pass1 (Z.to_nat o8) o7) inhabitant = true) | _ => False end)) ∧ (∀(b1 : Z) (b2 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> 0%Z ≤ b2 ∧ b2 < k * n -> nth (Z.to_nat b1) (set_list pass1 (Z.to_nat o8) o7) inhabitant = true ∧ nth (Z.to_nat b2) (set_list pass1 (Z.to_nat o8) o7) inhabitant = true -> b1 = b2) ∧ (0%Z ≤ lock_holder ∧ lock_holder < n -> has_lock (nth (Z.to_nat lock_holder) (set_list pcs1 (Z.to_nat th) o9) inhabitant) ∧ (match nth (Z.to_nat lock_holder) memo1 inhabitant with | None => False | Some tick2 => active_tick = Some tick2 end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (match nth (Z.to_nat th1) memo1 inhabitant with | Some tick2 => nth (Z.to_nat (b tick2)) owners1 inhabitant = Some th1 | None => True end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (¬ nth (Z.to_nat th1) memo1 inhabitant = None) = has_ticket (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o9) inhabitant)) ∧ (∀(tick2 : tick), tick2 ∈ seq waiting_list1 -> (match nth (Z.to_nat (b tick2)) owners1 inhabitant with | None => False | Some th1 => nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o9) inhabitant = A2 ∧ nth (Z.to_nat th1) memo1 inhabitant = Some tick2 end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (match nth (Z.to_nat th1) memo1 inhabitant with | Some tick2 => tick2 ∈ seq waiting_list1 ∨ active_tick = Some tick2 | None => True end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> ¬ has_lock (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o9) inhabitant) -> (match nth (Z.to_nat th1) memo1 inhabitant with | None => ¬ nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o9) inhabitant = A2 | Some tick2 => tick2 ∈ seq waiting_list1 end)) ∧ consecutive (seq waiting_list1) ∧ length (seq waiting_list1) = count_occ' (drop 0%nat (take (Z.to_nat n - 0%nat) (set_list pcs1 (Z.to_nat th) o9))) A2 ∧ (∀(tick2 : tick), tick2 ∈ seq waiting_list1 -> v next - Z.of_nat (length (seq waiting_list1)) ≤ v tick2 ∧ v tick2 < v next) ∧ (match last (seq waiting_list1) with | None => True | Some t => v t = v next - 1%Z end) ∧ (match hd (seq waiting_list1) with | None => True | Some t => v t = v next - Z.of_nat (length (seq waiting_list1)) end) ∧ (match active_tick with | None => lock_holder = - 1%Z | Some tick2 => (match hd (seq waiting_list1) with | None => v next = v tick2 + 1%Z | Some t => v t = v tick2 + 1%Z end) ∧ v tick2 = v next - Z.of_nat (length (seq waiting_list1)) - 1%Z ∧ (0%Z ≤ lock_holder ∧ lock_holder < n) ∧ nth (Z.to_nat lock_holder) memo1 inhabitant = Some tick2 end) ∧ (0%Z ≤ Z.of_nat (length (seq waiting_list1)) ∧ Z.of_nat (length (seq waiting_list1)) ≤ n) ∧ (lock_holder = - 1%Z -> ¬ Z.of_nat (length (seq waiting_list1)) = 0%Z ∧ nth (Z.to_nat (b (nth 0%nat (seq waiting_list1) inhabitant))) (set_list pass1 (Z.to_nat o8) o7) inhabitant = true ∨ (∃(th1 : Z), (0%Z ≤ th1 ∧ th1 < n) ∧ nth (Z.to_nat th1) memo1 inhabitant = None ∧ nth (Z.to_nat (b next)) (set_list pass1 (Z.to_nat o8) o7) inhabitant = true) ∧ seq waiting_list1 = ([] : list tick)))))) end) | R2 => (0%Z ≤ th ∧ th < Z.of_nat (length memo1)) ∧ (match nth (Z.to_nat th) memo1 inhabitant with | None => False | Some tick1 => (let o7 : Z := k * n in ¬ o7 = 0%Z ∧ (let nt : Z := ZEuclid.modulo (b tick1 + 1%Z) o7 in let o8 : bool := true in (0%Z ≤ nt ∧ nt < Z.of_nat (length pass1)) ∧ (length (set_list pass1 (Z.to_nat nt) o8) = length pass1 -> nth_i (set_list pass1 (Z.to_nat nt) o8) = fun_updt (nth_i pass1) nt o8 -> (let o9 : option tick := None in (0%Z ≤ th ∧ th < Z.of_nat (length memo1)) ∧ (length (set_list memo1 (Z.to_nat th) o9) = length memo1 -> nth_i (set_list memo1 (Z.to_nat th) o9) = fun_updt (nth_i memo1) th o9 -> (let o10 : option Z := None in let o11 : Z := b tick1 in (0%Z ≤ o11 ∧ o11 < Z.of_nat (length owners1)) ∧ (length (set_list owners1 (Z.to_nat o11) o10) = length owners1 -> nth_i (set_list owners1 (Z.to_nat o11) o10) = fun_updt (nth_i owners1) o11 o10 -> (let o12 : pc := I in (0%Z ≤ th ∧ th < Z.of_nat (length pcs1)) ∧ (length (set_list pcs1 (Z.to_nat th) o12) = length pcs1 -> nth_i (set_list pcs1 (Z.to_nat th) o12) = fun_updt (nth_i pcs1) th o12 -> (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> ¬ th1 = - 1%Z -> ¬ has_lock (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o12) inhabitant)) ∧ (- 1%Z ≤ - 1%Z ∧ - 1%Z < n) ∧ (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> (match nth (Z.to_nat b1) (set_list owners1 (Z.to_nat o11) o10) inhabitant with | None => True | Some th1 => (0%Z ≤ th1 ∧ th1 < n) ∧ (match nth (Z.to_nat th1) (set_list memo1 (Z.to_nat th) o9) inhabitant with | None => False | Some tick2 => b tick2 = b1 end) end)) ∧ (∀(tick2 : tick), nth (Z.to_nat (b tick2)) (set_list pass1 (Z.to_nat nt) o8) inhabitant = true -> (match nth (Z.to_nat (b tick2)) (set_list owners1 (Z.to_nat o11) o10) inhabitant with | None => True | Some th1 => True ∨ - 1%Z = th1 end)) ∧ (0%Z ≤ - 1%Z ∧ - 1%Z < n -> (match nth (Z.to_nat (- 1%Z)) (set_list pcs1 (Z.to_nat th) o12) inhabitant with | A3 => (match nth (Z.to_nat (- 1%Z)) (set_list memo1 (Z.to_nat th) o9) inhabitant with | None => False | Some tick2 => nth (Z.to_nat (b tick2)) (set_list pass1 (Z.to_nat nt) o8) inhabitant = true end) | W => (match nth (Z.to_nat (- 1%Z)) (set_list memo1 (Z.to_nat th) o9) inhabitant with | None => False | Some tick2 => nth (Z.to_nat (b tick2)) (set_list pass1 (Z.to_nat nt) o8) inhabitant = true end) | R1 => (match nth (Z.to_nat (- 1%Z)) (set_list memo1 (Z.to_nat th) o9) inhabitant with | None => False | Some tick2 => nth (Z.to_nat (b tick2)) (set_list pass1 (Z.to_nat nt) o8) inhabitant = true end) | R2 => (∀(b1 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> ¬ nth (Z.to_nat b1) (set_list pass1 (Z.to_nat nt) o8) inhabitant = true) | _ => False end)) ∧ (∀(b1 : Z) (b2 : Z), 0%Z ≤ b1 ∧ b1 < k * n -> 0%Z ≤ b2 ∧ b2 < k * n -> nth (Z.to_nat b1) (set_list pass1 (Z.to_nat nt) o8) inhabitant = true ∧ nth (Z.to_nat b2) (set_list pass1 (Z.to_nat nt) o8) inhabitant = true -> b1 = b2) ∧ (0%Z ≤ - 1%Z ∧ - 1%Z < n -> has_lock (nth (Z.to_nat (- 1%Z)) (set_list pcs1 (Z.to_nat th) o12) inhabitant) ∧ (match nth (Z.to_nat (- 1%Z)) (set_list memo1 (Z.to_nat th) o9) inhabitant with | None => False | Some tick2 => None = Some tick2 end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (match nth (Z.to_nat th1) (set_list memo1 (Z.to_nat th) o9) inhabitant with | Some tick2 => nth (Z.to_nat (b tick2)) (set_list owners1 (Z.to_nat o11) o10) inhabitant = Some th1 | None => True end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (¬ nth (Z.to_nat th1) (set_list memo1 (Z.to_nat th) o9) inhabitant = None) = has_ticket (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o12) inhabitant)) ∧ (∀(tick2 : tick), tick2 ∈ seq waiting_list1 -> (match nth (Z.to_nat (b tick2)) (set_list owners1 (Z.to_nat o11) o10) inhabitant with | None => False | Some th1 => nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o12) inhabitant = A2 ∧ nth (Z.to_nat th1) (set_list memo1 (Z.to_nat th) o9) inhabitant = Some tick2 end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> (match nth (Z.to_nat th1) (set_list memo1 (Z.to_nat th) o9) inhabitant with | Some tick2 => tick2 ∈ seq waiting_list1 ∨ None = Some tick2 | None => True end)) ∧ (∀(th1 : Z), 0%Z ≤ th1 ∧ th1 < n -> ¬ has_lock (nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o12) inhabitant) -> (match nth (Z.to_nat th1) (set_list memo1 (Z.to_nat th) o9) inhabitant with | None => ¬ nth (Z.to_nat th1) (set_list pcs1 (Z.to_nat th) o12) inhabitant = A2 | Some tick2 => tick2 ∈ seq waiting_list1 end)) ∧ consecutive (seq waiting_list1) ∧ length (seq waiting_list1) = count_occ' (drop 0%nat (take (Z.to_nat n - 0%nat) (set_list pcs1 (Z.to_nat th) o12))) A2 ∧ (∀(tick2 : tick), tick2 ∈ seq waiting_list1 -> v next - Z.of_nat (length (seq waiting_list1)) ≤ v tick2 ∧ v tick2 < v next) ∧ (match last (seq waiting_list1) with | None => True | Some t => v t = v next - 1%Z end) ∧ (match hd (seq waiting_list1) with | None => True | Some t => v t = v next - Z.of_nat (length (seq waiting_list1)) end) ∧ (match None with | None => True | Some tick2 => (match hd (seq waiting_list1) with | None => v next = v tick2 + 1%Z | Some t => v t = v tick2 + 1%Z end) ∧ v tick2 = v next - Z.of_nat (length (seq waiting_list1)) - 1%Z ∧ (0%Z ≤ - 1%Z ∧ - 1%Z < n) ∧ nth (Z.to_nat (- 1%Z)) (set_list memo1 (Z.to_nat th) o9) inhabitant = Some tick2 end) ∧ (0%Z ≤ Z.of_nat (length (seq waiting_list1)) ∧ Z.of_nat (length (seq waiting_list1)) ≤ n) ∧ (¬ Z.of_nat (length (seq waiting_list1)) = 0%Z ∧ nth (Z.to_nat (b (nth 0%nat (seq waiting_list1) inhabitant))) (set_list pass1 (Z.to_nat nt) o8) inhabitant = true ∨ (∃(th1 : Z), (0%Z ≤ th1 ∧ th1 < n) ∧ nth (Z.to_nat th1) (set_list memo1 (Z.to_nat th) o9) inhabitant = None ∧ nth (Z.to_nat (b next)) (set_list pass1 (Z.to_nat nt) o8) inhabitant = true) ∧ seq waiting_list1 = ([] : list tick))))))))))) end) end)))))))))))))).
Admitted.
