From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Open Scope Z_scope.
Inductive color :=
  | Red : color
  | Black : color.
Axiom color_inhabited : Inhabited color.
Global Existing Instance color_inhabited.
Axiom color_countable : Countable color.
Global Existing Instance color_countable.
Axiom coloring : Type.
Axiom coloring_inhabited : Inhabited coloring.
Global Existing Instance coloring_inhabited.
Axiom coloring_countable : Countable coloring.
Global Existing Instance coloring_countable.
Definition tworedneighbors (c : list color) (i : Z) := nth (Z.to_nat (i - 2%Z)) c inhabitant = Red ∧ nth (Z.to_nat (i - 1%Z)) c inhabitant = Red ∧ 2%Z ≤ i ∨ nth (Z.to_nat (i - 1%Z)) c inhabitant = Red ∧ nth (Z.to_nat (i + 1%Z)) c inhabitant = Red ∧ 1%Z ≤ i ∧ i ≤ Z.of_nat (length c) - 2%Z ∨ nth (Z.to_nat (i + 1%Z)) c inhabitant = Red ∧ nth (Z.to_nat (i + 2%Z)) c inhabitant = Red ∧ i ≤ Z.of_nat (length c) - 3%Z.
Definition valid (c : list color) := ∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length c) -> nth (Z.to_nat i) c inhabitant = Red -> tworedneighbors c i.
Axiom first_black_tile : list color -> Z.
Axiom first_black_tile'def : forall  (c : list color), if decide (Z.of_nat (length c) = 0%Z) then first_black_tile c = 0%Z else match nth 0%nat c inhabitant with | Black => first_black_tile c = 0%Z | Red => first_black_tile c = 1%Z + first_black_tile (drop 1%nat c) end.
Axiom first_black_tile'spec'2 : forall  (c : list color), 0%Z ≤ first_black_tile c ∧ first_black_tile c ≤ Z.of_nat (length c).
Axiom first_black_tile'spec'1 : forall  (j : Z) (c : list color) (fact0 : 0%Z ≤ j) (fact1 : j < first_black_tile c) (fact2 : first_black_tile c ≤ Z.of_nat (length c)), nth (Z.to_nat j) c inhabitant = Red.
Axiom first_black_tile'spec'0 : forall  (c : list color) (fact0 : first_black_tile c < Z.of_nat (length c)), nth (Z.to_nat (first_black_tile c)) c inhabitant = Black.
Axiom first_black_tile'spec : forall  (c : list color) (fact0 : valid c), first_black_tile c = 0%Z ∨ 3%Z ≤ first_black_tile c.
Axiom addleft : Z -> list color -> list color.
Axiom addleft'def : forall  (nr : Z) (c : list color), if decide (nr ≤ 0%Z) then addleft nr c = cons Black c else addleft nr c = cons Red (addleft (nr - 1%Z) c).
Axiom addleft'spec : forall  (nr : Z) (c : list color) (fact0 : 0%Z ≤ nr), Z.of_nat (length (addleft nr c)) = Z.of_nat (length c) + nr + 1%Z.
Axiom addleft_closure : Z -> list color -> list color.
Axiom addleft_closure_def : forall  (y : Z) (y1 : list color), addleft_closure y y1 = addleft y y1.
Definition mapaddleft (s : gset (list color)) (nr : Z) : gset (list color) := gset_map (addleft_closure nr) s.
Definition reciprocal {β : Type} {α : Type} `{Inhabited β} `{Countable β} `{Inhabited α} `{Countable α} (f : α -> β) (g : β -> α) := ∀(y : α), g (f y) = y.
Definition rmleft (nr : Z) (c : list color) : list color := drop (Z.to_nat (nr + 1%Z)) c.
Axiom fc : Z -> color.
Axiom fc1 : Z -> color.
Axiom fc2 : Z -> color.
Axiom fc3 : Z -> color.
Axiom fc4 : Z -> color.
Axiom fc5 : Z -> color.
Axiom fc6 : Z -> color.
Axiom fc'def : forall  (y0 : Z), fc y0 = Black.
Axiom fc'def1 : forall  (y0 : Z), fc1 y0 = Black.
Axiom fc'def2 : forall  (y0 : Z), fc2 y0 = Black.
Axiom fc'def3 : forall  (y0 : Z), fc3 y0 = Red.
Axiom fc'def4 : forall  (y0 : Z), fc4 y0 = Black.
Axiom fc'def5 : forall  (y0 : Z), fc5 y0 = Red.
Axiom fc'def6 : forall  (y0 : Z), fc6 y0 = Red.
Theorem enum'vc : 0%Z ≤ 51%Z ∧ (∀(count : list Z), (∀(i : Z), 0%Z ≤ i ∧ i < 51%Z -> nth (Z.to_nat i) count inhabitant = 0%Z) ∧ Z.of_nat (length count) = 51%Z -> 0%Z ≤ 51%Z ∧ (∀(sets : list (gset (list color))), (∀(i : Z), 0%Z ≤ i ∧ i < 51%Z -> nth (Z.to_nat i) sets inhabitant = (∅ : gset (list color))) ∧ Z.of_nat (length sets) = 51%Z -> (0%Z ≤ 0%Z ∧ 0%Z < Z.of_nat (length count)) ∧ (length (set_list count 0%nat 1%Z) = length count -> nth_i (set_list count 0%nat 1%Z) = fun_updt (nth_i count) 0%Z 1%Z -> (let o1 : gset (list color) := ({[create_list 0%nat (fc ∘ Z.of_nat)]} : gset _) in (0%Z ≤ 0%Z ∧ 0%Z < Z.of_nat (length sets)) ∧ (length (set_list sets 0%nat o1) = length sets -> nth_i (set_list sets 0%nat o1) = fun_updt (nth_i sets) 0%Z o1 -> (0%Z ≤ 1%Z ∧ 1%Z < Z.of_nat (length (set_list count 0%nat 1%Z))) ∧ (length (set_list (set_list count 0%nat 1%Z) 1%nat 1%Z) = length (set_list count 0%nat 1%Z) -> nth_i (set_list (set_list count 0%nat 1%Z) 1%nat 1%Z) = fun_updt (nth_i (set_list count 0%nat 1%Z)) 1%Z 1%Z -> (let o2 : gset (list color) := ({[create_list 1%nat (fc1 ∘ Z.of_nat)]} : gset _) in (0%Z ≤ 1%Z ∧ 1%Z < Z.of_nat (length (set_list sets 0%nat o1))) ∧ (length (set_list (set_list sets 0%nat o1) 1%nat o2) = length (set_list sets 0%nat o1) -> nth_i (set_list (set_list sets 0%nat o1) 1%nat o2) = fun_updt (nth_i (set_list sets 0%nat o1)) 1%Z o2 -> (0%Z ≤ 2%Z ∧ 2%Z < Z.of_nat (length (set_list (set_list count 0%nat 1%Z) 1%nat 1%Z))) ∧ (length (set_list (set_list (set_list count 0%nat 1%Z) 1%nat 1%Z) 2%nat 1%Z) = length (set_list (set_list count 0%nat 1%Z) 1%nat 1%Z) -> nth_i (set_list (set_list (set_list count 0%nat 1%Z) 1%nat 1%Z) 2%nat 1%Z) = fun_updt (nth_i (set_list (set_list count 0%nat 1%Z) 1%nat 1%Z)) 2%Z 1%Z -> (let o3 : gset (list color) := ({[create_list 2%nat (fc2 ∘ Z.of_nat)]} : gset _) in (0%Z ≤ 2%Z ∧ 2%Z < Z.of_nat (length (set_list (set_list sets 0%nat o1) 1%nat o2))) ∧ (length (set_list (set_list (set_list sets 0%nat o1) 1%nat o2) 2%nat o3) = length (set_list (set_list sets 0%nat o1) 1%nat o2) -> nth_i (set_list (set_list (set_list sets 0%nat o1) 1%nat o2) 2%nat o3) = fun_updt (nth_i (set_list (set_list sets 0%nat o1) 1%nat o2)) 2%Z o3 -> (0%Z ≤ 3%Z ∧ 3%Z < Z.of_nat (length (set_list (set_list (set_list count 0%nat 1%Z) 1%nat 1%Z) 2%nat 1%Z))) ∧ (length (set_list (set_list (set_list (set_list count 0%nat 1%Z) 1%nat 1%Z) 2%nat 1%Z) 3%nat 2%Z) = length (set_list (set_list (set_list count 0%nat 1%Z) 1%nat 1%Z) 2%nat 1%Z) -> nth_i (set_list (set_list (set_list (set_list count 0%nat 1%Z) 1%nat 1%Z) 2%nat 1%Z) 3%nat 2%Z) = fun_updt (nth_i (set_list (set_list (set_list count 0%nat 1%Z) 1%nat 1%Z) 2%nat 1%Z)) 3%Z 2%Z -> (let o4 : gset (list color) := ({[create_list 3%nat (fc3 ∘ Z.of_nat); create_list 3%nat (fc4 ∘ Z.of_nat)]} : gset _) in (0%Z ≤ 3%Z ∧ 3%Z < Z.of_nat (length (set_list (set_list (set_list sets 0%nat o1) 1%nat o2) 2%nat o3))) ∧ (length (set_list (set_list (set_list (set_list sets 0%nat o1) 1%nat o2) 2%nat o3) 3%nat o4) = length (set_list (set_list (set_list sets 0%nat o1) 1%nat o2) 2%nat o3) -> nth_i (set_list (set_list (set_list (set_list sets 0%nat o1) 1%nat o2) 2%nat o3) 3%nat o4) = fun_updt (nth_i (set_list (set_list (set_list sets 0%nat o1) 1%nat o2) 2%nat o3)) 3%Z o4 -> (4%Z ≤ 50%Z + 1%Z -> ((∀(c : list color), 0%Z ≤ Z.of_nat (length c) ∧ Z.of_nat (length c) < 4%Z -> valid c -> c ∈ nth (length c) (set_list (set_list (set_list (set_list sets 0%nat o1) 1%nat o2) 2%nat o3) 3%nat o4) inhabitant) ∧ (∀(c : list color) (i : Z), 0%Z ≤ i ∧ i < 4%Z -> c ∈ nth (Z.to_nat i) (set_list (set_list (set_list (set_list sets 0%nat o1) 1%nat o2) 2%nat o3) 3%nat o4) inhabitant -> Z.of_nat (length c) = i ∧ valid c) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < 4%Z -> nth (Z.to_nat i) (set_list (set_list (set_list (set_list count 0%nat 1%Z) 1%nat 1%Z) 2%nat 1%Z) 3%nat 2%Z) inhabitant = Z.of_nat (size (nth (Z.to_nat i) (set_list (set_list (set_list (set_list sets 0%nat o1) 1%nat o2) 2%nat o3) 3%nat o4) inhabitant)))) ∧ (∀(sets1 : list (gset (list color))) (count1 : list Z), length sets1 = length (set_list (set_list (set_list (set_list sets 0%nat o1) 1%nat o2) 2%nat o3) 3%nat o4) -> length count1 = length (set_list (set_list (set_list (set_list count 0%nat 1%Z) 1%nat 1%Z) 2%nat 1%Z) 3%nat 2%Z) -> (∀(n : Z), (4%Z ≤ n ∧ n ≤ 50%Z) ∧ (∀(c : list color), 0%Z ≤ Z.of_nat (length c) ∧ Z.of_nat (length c) < n -> valid c -> c ∈ nth (length c) sets1 inhabitant) ∧ (∀(c : list color) (i : Z), 0%Z ≤ i ∧ i < n -> c ∈ nth (Z.to_nat i) sets1 inhabitant -> Z.of_nat (length c) = i ∧ valid c) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat i) count1 inhabitant = Z.of_nat (size (nth (Z.to_nat i) sets1 inhabitant))) -> (let o5 : Z := n - 1%Z in (0%Z ≤ o5 ∧ o5 < Z.of_nat (length count1)) ∧ (let o6 : Z := nth (Z.to_nat o5) count1 inhabitant in (0%Z ≤ n ∧ n < Z.of_nat (length count1)) ∧ (length (set_list count1 (Z.to_nat n) o6) = length count1 -> nth_i (set_list count1 (Z.to_nat n) o6) = fun_updt (nth_i count1) n o6 -> (let o7 : Z := n - 1%Z in (0%Z ≤ o7 ∧ o7 < Z.of_nat (length sets1)) ∧ (let o8 : gset (list color) := mapaddleft (nth (Z.to_nat o7) sets1 inhabitant) 0%Z in (0%Z ≤ n ∧ n < Z.of_nat (length sets1)) ∧ (length (set_list sets1 (Z.to_nat n) o8) = length sets1 -> nth_i (set_list sets1 (Z.to_nat n) o8) = fun_updt (nth_i sets1) n o8 -> (let o9 : Z := n - 1%Z in (3%Z ≤ o9 + 1%Z -> ((∀(c : list color), 0%Z ≤ Z.of_nat (length c) ∧ Z.of_nat (length c) < n -> valid c -> c ∈ nth (length c) (set_list sets1 (Z.to_nat n) o8) inhabitant) ∧ (∀(c : list color) (i : Z), 0%Z ≤ i ∧ i < n -> c ∈ nth (Z.to_nat i) (set_list sets1 (Z.to_nat n) o8) inhabitant -> Z.of_nat (length c) = i ∧ valid c) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat i) (set_list count1 (Z.to_nat n) o6) inhabitant = Z.of_nat (size (nth (Z.to_nat i) (set_list sets1 (Z.to_nat n) o8) inhabitant))) ∧ (∀(c : list color), (c ∈ nth (Z.to_nat n) (set_list sets1 (Z.to_nat n) o8) inhabitant) = (Z.of_nat (length c) = n ∧ valid c ∧ first_black_tile c < 3%Z)) ∧ nth (Z.to_nat n) (set_list count1 (Z.to_nat n) o6) inhabitant = Z.of_nat (size (nth (Z.to_nat n) (set_list sets1 (Z.to_nat n) o8) inhabitant))) ∧ (∀(sets2 : list (gset (list color))) (count2 : list Z), length sets2 = length (set_list sets1 (Z.to_nat n) o8) -> length count2 = length (set_list count1 (Z.to_nat n) o6) -> (∀(k : Z), (3%Z ≤ k ∧ k ≤ o9) ∧ (∀(c : list color), 0%Z ≤ Z.of_nat (length c) ∧ Z.of_nat (length c) < n -> valid c -> c ∈ nth (length c) sets2 inhabitant) ∧ (∀(c : list color) (i : Z), 0%Z ≤ i ∧ i < n -> c ∈ nth (Z.to_nat i) sets2 inhabitant -> Z.of_nat (length c) = i ∧ valid c) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat i) count2 inhabitant = Z.of_nat (size (nth (Z.to_nat i) sets2 inhabitant))) ∧ (∀(c : list color), (c ∈ nth (Z.to_nat n) sets2 inhabitant) = (Z.of_nat (length c) = n ∧ valid c ∧ first_black_tile c < k)) ∧ nth (Z.to_nat n) count2 inhabitant = Z.of_nat (size (nth (Z.to_nat n) sets2 inhabitant)) -> (let o10 : Z := n - k - 1%Z in (0%Z ≤ o10 ∧ o10 < Z.of_nat (length count2)) ∧ (0%Z ≤ n ∧ n < Z.of_nat (length count2)) ∧ (let o11 : Z := nth (Z.to_nat n) count2 inhabitant + nth (Z.to_nat o10) count2 inhabitant in (0%Z ≤ n ∧ n < Z.of_nat (length count2)) ∧ (length (set_list count2 (Z.to_nat n) o11) = length count2 -> nth_i (set_list count2 (Z.to_nat n) o11) = fun_updt (nth_i count2) n o11 -> (let o12 : Z := n - k - 1%Z in (0%Z ≤ o12 ∧ o12 < Z.of_nat (length sets2)) ∧ (let ns : gset (list color) := mapaddleft (nth (Z.to_nat o12) sets2 inhabitant) k in (0%Z ≤ n ∧ n < Z.of_nat (length sets2)) ∧ (let o13 : gset (list color) := nth (Z.to_nat n) sets2 inhabitant in (∀(x : list color), x ∈ o13 -> ¬ x ∈ ns) ∧ (let o14 : gset (list color) := o13 ∪ ns in Z.of_nat (size o14) = Z.of_nat (size o13) + Z.of_nat (size ns) -> (0%Z ≤ n ∧ n < Z.of_nat (length sets2)) ∧ (length (set_list sets2 (Z.to_nat n) o14) = length sets2 -> nth_i (set_list sets2 (Z.to_nat n) o14) = fun_updt (nth_i sets2) n o14 -> (∀(c : list color), 0%Z ≤ Z.of_nat (length c) ∧ Z.of_nat (length c) < n -> valid c -> c ∈ nth (length c) (set_list sets2 (Z.to_nat n) o14) inhabitant) ∧ (∀(c : list color) (i : Z), 0%Z ≤ i ∧ i < n -> c ∈ nth (Z.to_nat i) (set_list sets2 (Z.to_nat n) o14) inhabitant -> Z.of_nat (length c) = i ∧ valid c) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat i) (set_list count2 (Z.to_nat n) o11) inhabitant = Z.of_nat (size (nth (Z.to_nat i) (set_list sets2 (Z.to_nat n) o14) inhabitant))) ∧ (∀(c : list color), (c ∈ nth (Z.to_nat n) (set_list sets2 (Z.to_nat n) o14) inhabitant) = (Z.of_nat (length c) = n ∧ valid c ∧ first_black_tile c < k + 1%Z)) ∧ nth (Z.to_nat n) (set_list count2 (Z.to_nat n) o11) inhabitant = Z.of_nat (size (nth (Z.to_nat n) (set_list sets2 (Z.to_nat n) o14) inhabitant))))))))))) ∧ ((∀(c : list color), 0%Z ≤ Z.of_nat (length c) ∧ Z.of_nat (length c) < n -> valid c -> c ∈ nth (length c) sets2 inhabitant) ∧ (∀(c : list color) (i : Z), 0%Z ≤ i ∧ i < n -> c ∈ nth (Z.to_nat i) sets2 inhabitant -> Z.of_nat (length c) = i ∧ valid c) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat i) count2 inhabitant = Z.of_nat (size (nth (Z.to_nat i) sets2 inhabitant))) ∧ (∀(c : list color), (c ∈ nth (Z.to_nat n) sets2 inhabitant) = (Z.of_nat (length c) = n ∧ valid c ∧ first_black_tile c < o9 + 1%Z)) ∧ nth (Z.to_nat n) count2 inhabitant = Z.of_nat (size (nth (Z.to_nat n) sets2 inhabitant)) -> (let o10 : Z -> color := fc5 in 0%Z ≤ n ∧ (let r : list color := create_list (Z.to_nat n) (o10 ∘ Z.of_nat) in Z.of_nat (length r) = n ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat i) r inhabitant = o10 i) -> (let sr : gset (list color) := ({[r]} : gset _) in (0%Z ≤ n ∧ n < Z.of_nat (length count2)) ∧ (let o11 : Z := nth (Z.to_nat n) count2 inhabitant + 1%Z in (0%Z ≤ n ∧ n < Z.of_nat (length count2)) ∧ (length (set_list count2 (Z.to_nat n) o11) = length count2 -> nth_i (set_list count2 (Z.to_nat n) o11) = fun_updt (nth_i count2) n o11 -> (0%Z ≤ n ∧ n < Z.of_nat (length sets2)) ∧ (let o12 : gset (list color) := nth (Z.to_nat n) sets2 inhabitant in (∀(x : list color), x ∈ o12 -> ¬ x ∈ sr) ∧ (let o13 : gset (list color) := o12 ∪ sr in Z.of_nat (size o13) = Z.of_nat (size o12) + Z.of_nat (size sr) -> (0%Z ≤ n ∧ n < Z.of_nat (length sets2)) ∧ (length (set_list sets2 (Z.to_nat n) o13) = length sets2 -> nth_i (set_list sets2 (Z.to_nat n) o13) = fun_updt (nth_i sets2) n o13 -> (∀(c : list color), 0%Z ≤ Z.of_nat (length c) ∧ Z.of_nat (length c) < n + 1%Z -> valid c -> c ∈ nth (length c) (set_list sets2 (Z.to_nat n) o13) inhabitant) ∧ (∀(c : list color) (i : Z), 0%Z ≤ i ∧ i < n + 1%Z -> c ∈ nth (Z.to_nat i) (set_list sets2 (Z.to_nat n) o13) inhabitant -> Z.of_nat (length c) = i ∧ valid c) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n + 1%Z -> nth (Z.to_nat i) (set_list count2 (Z.to_nat n) o11) inhabitant = Z.of_nat (size (nth (Z.to_nat i) (set_list sets2 (Z.to_nat n) o13) inhabitant)))))))))))))) ∧ (o9 + 1%Z < 3%Z -> (let o10 : Z -> color := fc6 in 0%Z ≤ n ∧ (let r : list color := create_list (Z.to_nat n) (o10 ∘ Z.of_nat) in Z.of_nat (length r) = n ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat i) r inhabitant = o10 i) -> (let sr : gset (list color) := ({[r]} : gset _) in (0%Z ≤ n ∧ n < Z.of_nat (length (set_list count1 (Z.to_nat n) o6))) ∧ (let o11 : Z := nth (Z.to_nat n) (set_list count1 (Z.to_nat n) o6) inhabitant + 1%Z in (0%Z ≤ n ∧ n < Z.of_nat (length (set_list count1 (Z.to_nat n) o6))) ∧ (length (set_list (set_list count1 (Z.to_nat n) o6) (Z.to_nat n) o11) = length (set_list count1 (Z.to_nat n) o6) -> nth_i (set_list (set_list count1 (Z.to_nat n) o6) (Z.to_nat n) o11) = fun_updt (nth_i (set_list count1 (Z.to_nat n) o6)) n o11 -> (0%Z ≤ n ∧ n < Z.of_nat (length (set_list sets1 (Z.to_nat n) o8))) ∧ (let o12 : gset (list color) := nth (Z.to_nat n) (set_list sets1 (Z.to_nat n) o8) inhabitant in (∀(x : list color), x ∈ o12 -> ¬ x ∈ sr) ∧ (let o13 : gset (list color) := o12 ∪ sr in Z.of_nat (size o13) = Z.of_nat (size o12) + Z.of_nat (size sr) -> (0%Z ≤ n ∧ n < Z.of_nat (length (set_list sets1 (Z.to_nat n) o8))) ∧ (length (set_list (set_list sets1 (Z.to_nat n) o8) (Z.to_nat n) o13) = length (set_list sets1 (Z.to_nat n) o8) -> nth_i (set_list (set_list sets1 (Z.to_nat n) o8) (Z.to_nat n) o13) = fun_updt (nth_i (set_list sets1 (Z.to_nat n) o8)) n o13 -> (∀(c : list color), 0%Z ≤ Z.of_nat (length c) ∧ Z.of_nat (length c) < n + 1%Z -> valid c -> c ∈ nth (length c) (set_list (set_list sets1 (Z.to_nat n) o8) (Z.to_nat n) o13) inhabitant) ∧ (∀(c : list color) (i : Z), 0%Z ≤ i ∧ i < n + 1%Z -> c ∈ nth (Z.to_nat i) (set_list (set_list sets1 (Z.to_nat n) o8) (Z.to_nat n) o13) inhabitant -> Z.of_nat (length c) = i ∧ valid c) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n + 1%Z -> nth (Z.to_nat i) (set_list (set_list count1 (Z.to_nat n) o6) (Z.to_nat n) o11) inhabitant = Z.of_nat (size (nth (Z.to_nat i) (set_list (set_list sets1 (Z.to_nat n) o8) (Z.to_nat n) o13) inhabitant)))))))))))))))))))) ∧ ((∀(c : list color), 0%Z ≤ Z.of_nat (length c) ∧ Z.of_nat (length c) < 50%Z + 1%Z -> valid c -> c ∈ nth (length c) sets1 inhabitant) ∧ (∀(c : list color) (i : Z), 0%Z ≤ i ∧ i < 50%Z + 1%Z -> c ∈ nth (Z.to_nat i) sets1 inhabitant -> Z.of_nat (length c) = i ∧ valid c) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < 50%Z + 1%Z -> nth (Z.to_nat i) count1 inhabitant = Z.of_nat (size (nth (Z.to_nat i) sets1 inhabitant))) -> (Z.of_nat (length count1) = 51%Z ∧ 51%Z = Z.of_nat (length sets1)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i ≤ 50%Z -> (∀(c : list color), Z.of_nat (length c) = i -> valid c = (c ∈ nth (Z.to_nat i) sets1 inhabitant))) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < 50%Z -> nth (Z.to_nat i) count1 inhabitant = Z.of_nat (size (nth (Z.to_nat i) sets1 inhabitant)))))) ∧ (50%Z + 1%Z < 4%Z -> (Z.of_nat (length (set_list (set_list (set_list (set_list count 0%nat 1%Z) 1%nat 1%Z) 2%nat 1%Z) 3%nat 2%Z)) = 51%Z ∧ 51%Z = Z.of_nat (length (set_list (set_list (set_list (set_list sets 0%nat o1) 1%nat o2) 2%nat o3) 3%nat o4))) ∧ (∀(i : Z), 0%Z ≤ i ∧ i ≤ 50%Z -> (∀(c : list color), Z.of_nat (length c) = i -> valid c = (c ∈ nth (Z.to_nat i) (set_list (set_list (set_list (set_list sets 0%nat o1) 1%nat o2) 2%nat o3) 3%nat o4) inhabitant))) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < 50%Z -> nth (Z.to_nat i) (set_list (set_list (set_list (set_list count 0%nat 1%Z) 1%nat 1%Z) 2%nat 1%Z) 3%nat 2%Z) inhabitant = Z.of_nat (size (nth (Z.to_nat i) (set_list (set_list (set_list (set_list sets 0%nat o1) 1%nat o2) 2%nat o3) 3%nat o4) inhabitant)))))))))))))))))).
Admitted.
