theory verifythis_2018_le_rouge_et_le_noir_2_Top_mainqtvc
  imports "NTP4Verif.NTP4Verif"
begin
definition bijection :: "'a fset \<Rightarrow> ('b \<Rightarrow> bool) \<Rightarrow> ('a \<Rightarrow> 'b) \<Rightarrow> ('b \<Rightarrow> 'a) \<Rightarrow> _"
  where "bijection p q f g \<longleftrightarrow> (\<forall>(x :: 'a). x |\<in>| p \<longrightarrow> q (f x) = True \<and> g (f x) = x) \<and> (\<forall>(x :: 'b). q x = True \<longrightarrow> g x |\<in>| p \<and> f (g x) = x)" for p q f g
typedecl 'a cardinal
consts card :: "'a cardinal \<Rightarrow> int"
consts cset :: "'a cardinal \<Rightarrow> 'a fset"
axiomatization where cardinal'invariant:   "card self = int (fcard (cset self))"
  for self :: "'a cardinal"
definition cardinal'eq :: "'a cardinal \<Rightarrow> 'a cardinal \<Rightarrow> _"
  where "cardinal'eq a b \<longleftrightarrow> card a = card b \<and> cset a = cset b" for a b
axiomatization where cardinal'inj:   "a = b"
 if "cardinal'eq a b"
  for a :: "'a cardinal"
  and b :: "'a cardinal"
datatype  color = Red | Black
consts fc :: "int \<Rightarrow> color"
axiomatization where fc'def:   "fc x = Red"
  for x :: "int"
definition red :: "int \<Rightarrow> color list"
  where "red n = create_list n fc" for n
inductive valid_coloring_f :: "color \<Rightarrow> color list \<Rightarrow> bool" where
   ValidEmpty: "valid_coloring_f Black []"
 | ValidBlack: "valid_coloring_f c s \<Longrightarrow> valid_coloring_f Black ([Black] @ s)" for c :: "color" and s :: "color list"
 | ValidRed: "(3 :: int) \<le> n \<Longrightarrow> valid_coloring_f Black s \<Longrightarrow> valid_coloring_f Red (red n @ s)" for n :: "int" and s :: "color list"
definition valid_coloring :: "color list \<Rightarrow> _"
  where "valid_coloring s \<longleftrightarrow> valid_coloring_f Red s \<or> valid_coloring_f Black s" for s
definition valid_coloring_l :: "int \<Rightarrow> color list \<Rightarrow> _"
  where "valid_coloring_l n s \<longleftrightarrow> valid_coloring s \<and> int (length s) = n" for n s
definition valid_coloring_inter :: "int \<Rightarrow> int \<Rightarrow> color list \<Rightarrow> _"
  where "valid_coloring_inter n m s \<longleftrightarrow> valid_coloring_l n s \<and> (\<exists>(i :: int). ((0 :: int) \<le> i \<and> i < m) \<and> s ! nat i = Black)" for n m s
definition valid_coloring_at :: "int \<Rightarrow> int \<Rightarrow> color list \<Rightarrow> _"
  where "valid_coloring_at n m s \<longleftrightarrow> valid_coloring_l n s \<and> s ! nat m = Black \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < m \<longrightarrow> s ! nat i = Red)" for n m s
consts valid_coloring_inter_closure :: "int \<Rightarrow> int \<Rightarrow> color list \<Rightarrow> bool"
consts infix_plpl_closure :: "'a list \<Rightarrow> 'a list \<Rightarrow> 'a list"
consts fc1 :: "color list \<Rightarrow> color list"
consts valid_coloring_at_closure :: "int \<Rightarrow> int \<Rightarrow> color list \<Rightarrow> bool"
consts fc2 :: "int \<Rightarrow> color list \<Rightarrow> color list"
consts fc3 :: "int \<Rightarrow> color list \<Rightarrow> color list"
axiomatization where valid_coloring_inter_closure_def:   "valid_coloring_inter_closure y y1 y2 = True \<longleftrightarrow> valid_coloring_inter y y1 y2"
  for y :: "int"
  and y1 :: "int"
  and y2 :: "color list"
axiomatization where infix_plpl_closure_def:   "infix_plpl_closure y y1 = y @ y1"
  for y :: "'a list"
  and y1 :: "'a list"
axiomatization where fc'def1:   "fc1 s = drop (1 :: nat) s"
  for s :: "color list"
axiomatization where valid_coloring_at_closure_def:   "valid_coloring_at_closure y y1 y2 = True \<longleftrightarrow> valid_coloring_at y y1 y2"
  for y :: "int"
  and y1 :: "int"
  and y2 :: "color list"
axiomatization where fc'def2:   "fc2 k s = red k @ [Black] @ s"
  for k :: "int"
  and s :: "color list"
axiomatization where fc'def3:   "fc3 k s = drop (nat (k + (1 :: int))) s"
  for k :: "int"
  and s :: "color list"
theorem main'vc:
  fixes o1 :: "color list cardinal"
  assumes fact0: "cset o1 = fempty"
  assumes fact1: "card o1 = (0 :: int)"
  shows "(0 :: int) \<le> (51 :: int)"
  and "\<forall>(count :: color list cardinal list). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < (51 :: int) \<longrightarrow> count ! nat i = o1) \<and> int (length count) = (51 :: int) \<longrightarrow> (\<forall>(o2 :: color list cardinal). cset o2 = finsert [] fempty \<and> card o2 = (1 :: int) \<longrightarrow> ((0 :: int) \<le> (0 :: int) \<and> (0 :: int) < int (length count)) \<and> (length (count[nat (0 :: int) := o2]) = length count \<longrightarrow> nth (count[nat (0 :: int) := o2]) o nat = (nth count o nat)(0 :: int := o2) \<longrightarrow> (let o3 :: color list = []; o4 :: color list = [Black]; o5 :: color list = o4 @ o3 in int (length o5) = int (length o4) + int (length o3) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o4) \<longrightarrow> o5 ! nat i = o4 ! nat i) \<and> (\<forall>(i :: int). int (length o4) \<le> i \<and> i < int (length o5) \<longrightarrow> o5 ! nat i = o3 ! nat (i - int (length o4))) \<longrightarrow> (\<forall>(o6 :: color list cardinal). cset o6 = finsert o5 fempty \<and> card o6 = (1 :: int) \<longrightarrow> ((0 :: int) \<le> (1 :: int) \<and> (1 :: int) < int (length (count[nat (0 :: int) := o2]))) \<and> (length (count[nat (1 :: int) := o6, nat (0 :: int) := o2]) = length (count[nat (0 :: int) := o2]) \<longrightarrow> nth (count[nat (1 :: int) := o6, nat (0 :: int) := o2]) o nat = (nth (count[nat (0 :: int) := o2]) o nat)(1 :: int := o6) \<longrightarrow> (let o7 :: color list = []; o8 :: color list = [Black]; o9 :: color list = o8 @ o7 in int (length o9) = int (length o8) + int (length o7) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o8) \<longrightarrow> o9 ! nat i = o8 ! nat i) \<and> (\<forall>(i :: int). int (length o8) \<le> i \<and> i < int (length o9) \<longrightarrow> o9 ! nat i = o7 ! nat (i - int (length o8))) \<longrightarrow> (let o10 :: color list = [Black]; o11 :: color list = o10 @ o9 in int (length o11) = int (length o10) + int (length o9) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o10) \<longrightarrow> o11 ! nat i = o10 ! nat i) \<and> (\<forall>(i :: int). int (length o10) \<le> i \<and> i < int (length o11) \<longrightarrow> o11 ! nat i = o9 ! nat (i - int (length o10))) \<longrightarrow> (\<forall>(o12 :: color list cardinal). cset o12 = finsert o11 fempty \<and> card o12 = (1 :: int) \<longrightarrow> ((0 :: int) \<le> (2 :: int) \<and> (2 :: int) < int (length (count[nat (1 :: int) := o6, nat (0 :: int) := o2]))) \<and> (length (count[nat (2 :: int) := o12, nat (1 :: int) := o6, nat (0 :: int) := o2]) = length (count[nat (1 :: int) := o6, nat (0 :: int) := o2]) \<longrightarrow> nth (count[nat (2 :: int) := o12, nat (1 :: int) := o6, nat (0 :: int) := o2]) o nat = (nth (count[nat (1 :: int) := o6, nat (0 :: int) := o2]) o nat)(2 :: int := o12) \<longrightarrow> (let o13 :: color list = []; o14 :: color list = [Black]; o15 :: color list = o14 @ o13 in int (length o15) = int (length o14) + int (length o13) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o14) \<longrightarrow> o15 ! nat i = o14 ! nat i) \<and> (\<forall>(i :: int). int (length o14) \<le> i \<and> i < int (length o15) \<longrightarrow> o15 ! nat i = o13 ! nat (i - int (length o14))) \<longrightarrow> (let o16 :: color list = [Black]; o17 :: color list = o16 @ o15 in int (length o17) = int (length o16) + int (length o15) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o16) \<longrightarrow> o17 ! nat i = o16 ! nat i) \<and> (\<forall>(i :: int). int (length o16) \<le> i \<and> i < int (length o17) \<longrightarrow> o17 ! nat i = o15 ! nat (i - int (length o16))) \<longrightarrow> (let o18 :: color list = [Black]; o19 :: color list = o18 @ o17 in int (length o19) = int (length o18) + int (length o17) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o18) \<longrightarrow> o19 ! nat i = o18 ! nat i) \<and> (\<forall>(i :: int). int (length o18) \<le> i \<and> i < int (length o19) \<longrightarrow> o19 ! nat i = o17 ! nat (i - int (length o18))) \<longrightarrow> (let o20 :: color list = []; o21 :: color list = red (3 :: int); o22 :: color list = o21 @ o20 in int (length o22) = int (length o21) + int (length o20) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o21) \<longrightarrow> o22 ! nat i = o21 ! nat i) \<and> (\<forall>(i :: int). int (length o21) \<le> i \<and> i < int (length o22) \<longrightarrow> o22 ! nat i = o20 ! nat (i - int (length o21))) \<longrightarrow> (let o23 :: color list fset = finsert o22 (finsert o19 fempty) in (2 :: int) = int (fcard o23) \<and> (\<forall>(o24 :: color list cardinal). card o24 = (2 :: int) \<and> cset o24 = o23 \<longrightarrow> ((0 :: int) \<le> (3 :: int) \<and> (3 :: int) < int (length (count[nat (2 :: int) := o12, nat (1 :: int) := o6, nat (0 :: int) := o2]))) \<and> (length (count[nat (3 :: int) := o24, nat (2 :: int) := o12, nat (1 :: int) := o6, nat (0 :: int) := o2]) = length (count[nat (2 :: int) := o12, nat (1 :: int) := o6, nat (0 :: int) := o2]) \<longrightarrow> nth (count[nat (3 :: int) := o24, nat (2 :: int) := o12, nat (1 :: int) := o6, nat (0 :: int) := o2]) o nat = (nth (count[nat (2 :: int) := o12, nat (1 :: int) := o6, nat (0 :: int) := o2]) o nat)(3 :: int := o24) \<longrightarrow> (4 :: int) \<le> (50 :: int) + (1 :: int) \<longrightarrow> (\<forall>(i :: int) (s :: color list). (0 :: int) \<le> i \<and> i < (4 :: int) \<longrightarrow> valid_coloring_l i s \<longleftrightarrow> s |\<in>| cset (count[nat (3 :: int) := o24, nat (2 :: int) := o12, nat (1 :: int) := o6, nat (0 :: int) := o2] ! nat i)) \<and> (\<forall>(count1 :: color list cardinal list). length count1 = length (count[nat (3 :: int) := o24, nat (2 :: int) := o12, nat (1 :: int) := o6, nat (0 :: int) := o2]) \<longrightarrow> (\<forall>(n :: int). ((4 :: int) \<le> n \<and> n \<le> (50 :: int)) \<and> (\<forall>(i :: int) (s :: color list). (0 :: int) \<le> i \<and> i < n \<longrightarrow> valid_coloring_l i s \<longleftrightarrow> s |\<in>| cset (count1 ! nat i)) \<longrightarrow> (let q :: color list \<Rightarrow> bool = valid_coloring_inter_closure n (3 :: int); o25 :: int = n - (1 :: int) in ((0 :: int) \<le> o25 \<and> o25 < int (length count1)) \<and> (let o26 :: color list cardinal = count1 ! nat o25 in bijection (cset o26) q (infix_plpl_closure [Black]) fc1 \<and> (\<forall>(o27 :: color list cardinal). (\<forall>(x :: color list). x |\<in>| cset o27 \<longleftrightarrow> q x = True) \<and> card o27 = card o26 \<longrightarrow> ((0 :: int) \<le> n \<and> n < int (length count1)) \<and> (length (count1[nat n := o27]) = length count1 \<longrightarrow> nth (count1[nat n := o27]) o nat = (nth count1 o nat)(n := o27) \<longrightarrow> (let o28 :: int = n - (1 :: int) in ((3 :: int) \<le> o28 + (1 :: int) \<longrightarrow> ((\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> count1[nat n := o27] ! nat i = count1 ! nat i) \<and> (\<forall>(s :: color list). valid_coloring_inter n (3 :: int) s \<longleftrightarrow> s |\<in>| cset (count1[nat n := o27] ! nat n))) \<and> (\<forall>(count2 :: color list cardinal list). length count2 = length (count1[nat n := o27]) \<longrightarrow> (\<forall>(k :: int). ((3 :: int) \<le> k \<and> k \<le> o28) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> count2 ! nat i = count1 ! nat i) \<and> (\<forall>(s :: color list). valid_coloring_inter n k s \<longleftrightarrow> s |\<in>| cset (count2 ! nat n)) \<longrightarrow> (let q1 :: color list \<Rightarrow> bool = valid_coloring_at_closure n k; o29 :: int = n - k - (1 :: int) in ((0 :: int) \<le> o29 \<and> o29 < int (length count2)) \<and> (let o30 :: color list cardinal = count2 ! nat o29 in bijection (cset o30) q1 (fc2 k) (fc3 k) \<and> (\<forall>(o31 :: color list cardinal). (\<forall>(x :: color list). x |\<in>| cset o31 \<longleftrightarrow> q1 x = True) \<and> card o31 = card o30 \<longrightarrow> ((0 :: int) \<le> n \<and> n < int (length count2)) \<and> (let o32 :: color list cardinal = count2 ! nat n in (\<forall>(x :: color list). \<not>(x |\<in>| cset o32 \<and> x |\<in>| cset o31)) \<and> (\<forall>(o33 :: color list cardinal). cset o33 = cset o32 |\<union>| cset o31 \<and> card o33 = card o32 + card o31 \<longrightarrow> ((0 :: int) \<le> n \<and> n < int (length count2)) \<and> (length (count2[nat n := o33]) = length count2 \<longrightarrow> nth (count2[nat n := o33]) o nat = (nth count2 o nat)(n := o33) \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> count2[nat n := o33] ! nat i = count1 ! nat i) \<and> (\<forall>(s :: color list). valid_coloring_inter n (k + (1 :: int)) s \<longleftrightarrow> s |\<in>| cset (count2[nat n := o33] ! nat n))))))))) \<and> ((\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> count2 ! nat i = count1 ! nat i) \<and> (\<forall>(s :: color list). valid_coloring_inter n (o28 + (1 :: int)) s \<longleftrightarrow> s |\<in>| cset (count2 ! nat n)) \<longrightarrow> (\<forall>(o29 :: color list cardinal). cset o29 = finsert (red n) fempty \<and> card o29 = (1 :: int) \<longrightarrow> ((0 :: int) \<le> n \<and> n < int (length count2)) \<and> (let o30 :: color list cardinal = count2 ! nat n in (\<forall>(x :: color list). \<not>(x |\<in>| cset o30 \<and> x |\<in>| cset o29)) \<and> (\<forall>(o31 :: color list cardinal). cset o31 = cset o30 |\<union>| cset o29 \<and> card o31 = card o30 + card o29 \<longrightarrow> ((0 :: int) \<le> n \<and> n < int (length count2)) \<and> (length (count2[nat n := o31]) = length count2 \<longrightarrow> nth (count2[nat n := o31]) o nat = (nth count2 o nat)(n := o31) \<longrightarrow> (\<forall>(i :: int) (s :: color list). (0 :: int) \<le> i \<and> i < n + (1 :: int) \<longrightarrow> valid_coloring_l i s \<longleftrightarrow> s |\<in>| cset (count2[nat n := o31] ! nat i))))))))) \<and> (o28 + (1 :: int) < (3 :: int) \<longrightarrow> (\<forall>(o29 :: color list cardinal). cset o29 = finsert (red n) fempty \<and> card o29 = (1 :: int) \<longrightarrow> ((0 :: int) \<le> n \<and> n < int (length (count1[nat n := o27]))) \<and> (let o30 :: color list cardinal = count1[nat n := o27] ! nat n in (\<forall>(x :: color list). \<not>(x |\<in>| cset o30 \<and> x |\<in>| cset o29)) \<and> (\<forall>(o31 :: color list cardinal). cset o31 = cset o30 |\<union>| cset o29 \<and> card o31 = card o30 + card o29 \<longrightarrow> ((0 :: int) \<le> n \<and> n < int (length (count1[nat n := o27]))) \<and> (length (count1[nat n := o31, nat n := o27]) = length (count1[nat n := o27]) \<longrightarrow> nth (count1[nat n := o31, nat n := o27]) o nat = (nth (count1[nat n := o27]) o nat)(n := o31) \<longrightarrow> (\<forall>(i :: int) (s :: color list). (0 :: int) \<le> i \<and> i < n + (1 :: int) \<longrightarrow> valid_coloring_l i s \<longleftrightarrow> s |\<in>| cset (count1[nat n := o31, nat n := o27] ! nat i))))))))))))))))))))))))))))))"
  sorry
end
