import Why3.Base
open Classical
open Lean4Why3
namespace verifythis_2018_le_rouge_et_le_noir_2_Top_mainqtvc
noncomputable def bijection {β : Type} {α : Type} [Inhabited β] [Inhabited α] (p : Finset α) (q : β -> Bool) (f : α -> β) (g : β -> α) := (∀(x : α), x ∈ p → q (f x) = true ∧ g (f x) = x) ∧ (∀(x : β), q x = true → g x ∈ p ∧ f (g x) = x)
axiom cardinal : Type -> Type
axiom inhabited_axiom_cardinal {α : Type} [Inhabited α] : Inhabited (cardinal α)
attribute [instance] inhabited_axiom_cardinal
axiom card :  {α : Type} -> [Inhabited α] -> cardinal α -> ℤ
axiom cset :  {α : Type} -> [Inhabited α] -> cardinal α -> Finset α
axiom cardinal'invariant {α : Type} [Inhabited α] (self : cardinal α) : card self = Int.ofNat (Finset.card (cset self))
noncomputable def cardinal'eq {α : Type} [Inhabited α] (a : cardinal α) (b : cardinal α) := card a = card b ∧ cset a = cset b
axiom cardinal'inj {α : Type} [Inhabited α] (a : cardinal α) (b : cardinal α) (fact0 : cardinal'eq a b) : a = b
inductive color where
  | Red : color
  | Black : color
axiom inhabited_axiom_color : Inhabited color
attribute [instance] inhabited_axiom_color
axiom fc : ℤ -> color
axiom fc'def (x : ℤ) : fc x = color.Red
noncomputable def red (n : ℤ) := List.create (Int.toNat n) (fc ∘ Int.ofNat)
inductive valid_coloring_f : color -> List color -> Prop where
 | ValidEmpty : valid_coloring_f color.Black ([] : List color)
 | ValidBlack (c : color) (s : List color) : valid_coloring_f c s → valid_coloring_f color.Black ([color.Black] ++ s)
 | ValidRed (n : ℤ) (s : List color) : (3 : ℤ) ≤ n → valid_coloring_f color.Black s → valid_coloring_f color.Red (red n ++ s)
noncomputable def valid_coloring (s : List color) := valid_coloring_f color.Red s ∨ valid_coloring_f color.Black s
noncomputable def valid_coloring_l (n : ℤ) (s : List color) := valid_coloring s ∧ Int.ofNat (List.length s) = n
noncomputable def valid_coloring_inter (n : ℤ) (m : ℤ) (s : List color) := valid_coloring_l n s ∧ (∃(i : ℤ), ((0 : ℤ) ≤ i ∧ i < m) ∧ s[Int.toNat i]! = color.Black)
noncomputable def valid_coloring_at (n : ℤ) (m : ℤ) (s : List color) := valid_coloring_l n s ∧ s[Int.toNat m]! = color.Black ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < m → s[Int.toNat i]! = color.Red)
axiom valid_coloring_inter_closure : ℤ -> ℤ -> List color -> Bool
axiom infix_plpl_closure :  {α : Type} -> [Inhabited α] -> List α -> List α -> List α
axiom fc1 : List color -> List color
axiom valid_coloring_at_closure : ℤ -> ℤ -> List color -> Bool
axiom fc2 : ℤ -> List color -> List color
axiom fc3 : ℤ -> List color -> List color
axiom valid_coloring_inter_closure_def (y : ℤ) (y1 : ℤ) (y2 : List color) : (valid_coloring_inter_closure y y1 y2 = true) = valid_coloring_inter y y1 y2
axiom infix_plpl_closure_def {α : Type} [Inhabited α] (y : List α) (y1 : List α) : infix_plpl_closure y y1 = y ++ y1
axiom fc'def1 (s : List color) : fc1 s = List.drop (1 : ℕ) s
axiom valid_coloring_at_closure_def (y : ℤ) (y1 : ℤ) (y2 : List color) : (valid_coloring_at_closure y y1 y2 = true) = valid_coloring_at y y1 y2
axiom fc'def2 (k : ℤ) (s : List color) : fc2 k s = red k ++ [color.Black] ++ s
axiom fc'def3 (k : ℤ) (s : List color) : fc3 k s = List.drop (Int.toNat (k + (1 : ℤ))) s
theorem main'vc (o1 : cardinal (List color)) (fact0 : cset o1 = (∅ : Finset (List color))) (fact1 : card o1 = (0 : ℤ)) : (0 : ℤ) ≤ (51 : ℤ) ∧ (∀(count : List (cardinal (List color))), (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < (51 : ℤ) → count[Int.toNat i]! = o1) ∧ Int.ofNat (List.length count) = (51 : ℤ) → (∀(o2 : cardinal (List color)), cset o2 = insert ([] : List color) (∅ : Finset (List color)) ∧ card o2 = (1 : ℤ) → ((0 : ℤ) ≤ (0 : ℤ) ∧ (0 : ℤ) < Int.ofNat (List.length count)) ∧ (List.length (List.set count (0 : ℕ) o2) = List.length count → getElem! (List.set count (0 : ℕ) o2) ∘ Int.toNat = Function.update (getElem! count ∘ Int.toNat) (0 : ℤ) o2 → (let o3 : List color := ([] : List color); let o4 : List color := [color.Black]; let o5 : List color := o4 ++ o3; Int.ofNat (List.length o5) = Int.ofNat (List.length o4) + Int.ofNat (List.length o3) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length o4) → o5[Int.toNat i]! = o4[Int.toNat i]!) ∧ (∀(i : ℤ), Int.ofNat (List.length o4) ≤ i ∧ i < Int.ofNat (List.length o5) → o5[Int.toNat i]! = o3[Int.toNat (i - Int.ofNat (List.length o4))]!) → (∀(o6 : cardinal (List color)), cset o6 = insert o5 (∅ : Finset (List color)) ∧ card o6 = (1 : ℤ) → ((0 : ℤ) ≤ (1 : ℤ) ∧ (1 : ℤ) < Int.ofNat (List.length (List.set count (0 : ℕ) o2))) ∧ (List.length (List.set (List.set count (0 : ℕ) o2) (1 : ℕ) o6) = List.length (List.set count (0 : ℕ) o2) → getElem! (List.set (List.set count (0 : ℕ) o2) (1 : ℕ) o6) ∘ Int.toNat = Function.update (getElem! (List.set count (0 : ℕ) o2) ∘ Int.toNat) (1 : ℤ) o6 → (let o7 : List color := ([] : List color); let o8 : List color := [color.Black]; let o9 : List color := o8 ++ o7; Int.ofNat (List.length o9) = Int.ofNat (List.length o8) + Int.ofNat (List.length o7) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length o8) → o9[Int.toNat i]! = o8[Int.toNat i]!) ∧ (∀(i : ℤ), Int.ofNat (List.length o8) ≤ i ∧ i < Int.ofNat (List.length o9) → o9[Int.toNat i]! = o7[Int.toNat (i - Int.ofNat (List.length o8))]!) → (let o10 : List color := [color.Black]; let o11 : List color := o10 ++ o9; Int.ofNat (List.length o11) = Int.ofNat (List.length o10) + Int.ofNat (List.length o9) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length o10) → o11[Int.toNat i]! = o10[Int.toNat i]!) ∧ (∀(i : ℤ), Int.ofNat (List.length o10) ≤ i ∧ i < Int.ofNat (List.length o11) → o11[Int.toNat i]! = o9[Int.toNat (i - Int.ofNat (List.length o10))]!) → (∀(o12 : cardinal (List color)), cset o12 = insert o11 (∅ : Finset (List color)) ∧ card o12 = (1 : ℤ) → ((0 : ℤ) ≤ (2 : ℤ) ∧ (2 : ℤ) < Int.ofNat (List.length (List.set (List.set count (0 : ℕ) o2) (1 : ℕ) o6))) ∧ (List.length (List.set (List.set (List.set count (0 : ℕ) o2) (1 : ℕ) o6) (2 : ℕ) o12) = List.length (List.set (List.set count (0 : ℕ) o2) (1 : ℕ) o6) → getElem! (List.set (List.set (List.set count (0 : ℕ) o2) (1 : ℕ) o6) (2 : ℕ) o12) ∘ Int.toNat = Function.update (getElem! (List.set (List.set count (0 : ℕ) o2) (1 : ℕ) o6) ∘ Int.toNat) (2 : ℤ) o12 → (let o13 : List color := ([] : List color); let o14 : List color := [color.Black]; let o15 : List color := o14 ++ o13; Int.ofNat (List.length o15) = Int.ofNat (List.length o14) + Int.ofNat (List.length o13) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length o14) → o15[Int.toNat i]! = o14[Int.toNat i]!) ∧ (∀(i : ℤ), Int.ofNat (List.length o14) ≤ i ∧ i < Int.ofNat (List.length o15) → o15[Int.toNat i]! = o13[Int.toNat (i - Int.ofNat (List.length o14))]!) → (let o16 : List color := [color.Black]; let o17 : List color := o16 ++ o15; Int.ofNat (List.length o17) = Int.ofNat (List.length o16) + Int.ofNat (List.length o15) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length o16) → o17[Int.toNat i]! = o16[Int.toNat i]!) ∧ (∀(i : ℤ), Int.ofNat (List.length o16) ≤ i ∧ i < Int.ofNat (List.length o17) → o17[Int.toNat i]! = o15[Int.toNat (i - Int.ofNat (List.length o16))]!) → (let o18 : List color := [color.Black]; let o19 : List color := o18 ++ o17; Int.ofNat (List.length o19) = Int.ofNat (List.length o18) + Int.ofNat (List.length o17) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length o18) → o19[Int.toNat i]! = o18[Int.toNat i]!) ∧ (∀(i : ℤ), Int.ofNat (List.length o18) ≤ i ∧ i < Int.ofNat (List.length o19) → o19[Int.toNat i]! = o17[Int.toNat (i - Int.ofNat (List.length o18))]!) → (let o20 : List color := ([] : List color); let o21 : List color := red (3 : ℤ); let o22 : List color := o21 ++ o20; Int.ofNat (List.length o22) = Int.ofNat (List.length o21) + Int.ofNat (List.length o20) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length o21) → o22[Int.toNat i]! = o21[Int.toNat i]!) ∧ (∀(i : ℤ), Int.ofNat (List.length o21) ≤ i ∧ i < Int.ofNat (List.length o22) → o22[Int.toNat i]! = o20[Int.toNat (i - Int.ofNat (List.length o21))]!) → (let o23 : Finset (List color) := insert o22 (insert o19 (∅ : Finset (List color))); (2 : ℤ) = Int.ofNat (Finset.card o23) ∧ (∀(o24 : cardinal (List color)), card o24 = (2 : ℤ) ∧ cset o24 = o23 → ((0 : ℤ) ≤ (3 : ℤ) ∧ (3 : ℤ) < Int.ofNat (List.length (List.set (List.set (List.set count (0 : ℕ) o2) (1 : ℕ) o6) (2 : ℕ) o12))) ∧ (List.length (List.set (List.set (List.set (List.set count (0 : ℕ) o2) (1 : ℕ) o6) (2 : ℕ) o12) (3 : ℕ) o24) = List.length (List.set (List.set (List.set count (0 : ℕ) o2) (1 : ℕ) o6) (2 : ℕ) o12) → getElem! (List.set (List.set (List.set (List.set count (0 : ℕ) o2) (1 : ℕ) o6) (2 : ℕ) o12) (3 : ℕ) o24) ∘ Int.toNat = Function.update (getElem! (List.set (List.set (List.set count (0 : ℕ) o2) (1 : ℕ) o6) (2 : ℕ) o12) ∘ Int.toNat) (3 : ℤ) o24 → (4 : ℤ) ≤ (50 : ℤ) + (1 : ℤ) → (∀(i : ℤ) (s : List color), (0 : ℤ) ≤ i ∧ i < (4 : ℤ) → valid_coloring_l i s = (s ∈ cset ((List.set (List.set (List.set (List.set count (0 : ℕ) o2) (1 : ℕ) o6) (2 : ℕ) o12) (3 : ℕ) o24)[Int.toNat i]!))) ∧ (∀(count1 : List (cardinal (List color))), List.length count1 = List.length (List.set (List.set (List.set (List.set count (0 : ℕ) o2) (1 : ℕ) o6) (2 : ℕ) o12) (3 : ℕ) o24) → (∀(n : ℤ), ((4 : ℤ) ≤ n ∧ n ≤ (50 : ℤ)) ∧ (∀(i : ℤ) (s : List color), (0 : ℤ) ≤ i ∧ i < n → valid_coloring_l i s = (s ∈ cset (count1[Int.toNat i]!))) → (let q : List color -> Bool := valid_coloring_inter_closure n (3 : ℤ); let o25 : ℤ := n - (1 : ℤ); ((0 : ℤ) ≤ o25 ∧ o25 < Int.ofNat (List.length count1)) ∧ (let o26 : cardinal (List color) := count1[Int.toNat o25]!; bijection (cset o26) q (infix_plpl_closure [color.Black]) fc1 ∧ (∀(o27 : cardinal (List color)), (∀(x : List color), (x ∈ cset o27) = (q x = true)) ∧ card o27 = card o26 → ((0 : ℤ) ≤ n ∧ n < Int.ofNat (List.length count1)) ∧ (List.length (List.set count1 (Int.toNat n) o27) = List.length count1 → getElem! (List.set count1 (Int.toNat n) o27) ∘ Int.toNat = Function.update (getElem! count1 ∘ Int.toNat) n o27 → (let o28 : ℤ := n - (1 : ℤ); ((3 : ℤ) ≤ o28 + (1 : ℤ) → ((∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (List.set count1 (Int.toNat n) o27)[Int.toNat i]! = count1[Int.toNat i]!) ∧ (∀(s : List color), valid_coloring_inter n (3 : ℤ) s = (s ∈ cset ((List.set count1 (Int.toNat n) o27)[Int.toNat n]!)))) ∧ (∀(count2 : List (cardinal (List color))), List.length count2 = List.length (List.set count1 (Int.toNat n) o27) → (∀(k : ℤ), ((3 : ℤ) ≤ k ∧ k ≤ o28) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → count2[Int.toNat i]! = count1[Int.toNat i]!) ∧ (∀(s : List color), valid_coloring_inter n k s = (s ∈ cset (count2[Int.toNat n]!))) → (let q1 : List color -> Bool := valid_coloring_at_closure n k; let o29 : ℤ := n - k - (1 : ℤ); ((0 : ℤ) ≤ o29 ∧ o29 < Int.ofNat (List.length count2)) ∧ (let o30 : cardinal (List color) := count2[Int.toNat o29]!; bijection (cset o30) q1 (fc2 k) (fc3 k) ∧ (∀(o31 : cardinal (List color)), (∀(x : List color), (x ∈ cset o31) = (q1 x = true)) ∧ card o31 = card o30 → ((0 : ℤ) ≤ n ∧ n < Int.ofNat (List.length count2)) ∧ (let o32 : cardinal (List color) := count2[Int.toNat n]!; (∀(x : List color), ¬(x ∈ cset o32 ∧ x ∈ cset o31)) ∧ (∀(o33 : cardinal (List color)), cset o33 = cset o32 ∪ cset o31 ∧ card o33 = card o32 + card o31 → ((0 : ℤ) ≤ n ∧ n < Int.ofNat (List.length count2)) ∧ (List.length (List.set count2 (Int.toNat n) o33) = List.length count2 → getElem! (List.set count2 (Int.toNat n) o33) ∘ Int.toNat = Function.update (getElem! count2 ∘ Int.toNat) n o33 → (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → (List.set count2 (Int.toNat n) o33)[Int.toNat i]! = count1[Int.toNat i]!) ∧ (∀(s : List color), valid_coloring_inter n (k + (1 : ℤ)) s = (s ∈ cset ((List.set count2 (Int.toNat n) o33)[Int.toNat n]!)))))))))) ∧ ((∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → count2[Int.toNat i]! = count1[Int.toNat i]!) ∧ (∀(s : List color), valid_coloring_inter n (o28 + (1 : ℤ)) s = (s ∈ cset (count2[Int.toNat n]!))) → (∀(o29 : cardinal (List color)), cset o29 = insert (red n) (∅ : Finset (List color)) ∧ card o29 = (1 : ℤ) → ((0 : ℤ) ≤ n ∧ n < Int.ofNat (List.length count2)) ∧ (let o30 : cardinal (List color) := count2[Int.toNat n]!; (∀(x : List color), ¬(x ∈ cset o30 ∧ x ∈ cset o29)) ∧ (∀(o31 : cardinal (List color)), cset o31 = cset o30 ∪ cset o29 ∧ card o31 = card o30 + card o29 → ((0 : ℤ) ≤ n ∧ n < Int.ofNat (List.length count2)) ∧ (List.length (List.set count2 (Int.toNat n) o31) = List.length count2 → getElem! (List.set count2 (Int.toNat n) o31) ∘ Int.toNat = Function.update (getElem! count2 ∘ Int.toNat) n o31 → (∀(i : ℤ) (s : List color), (0 : ℤ) ≤ i ∧ i < n + (1 : ℤ) → valid_coloring_l i s = (s ∈ cset ((List.set count2 (Int.toNat n) o31)[Int.toNat i]!)))))))))) ∧ (o28 + (1 : ℤ) < (3 : ℤ) → (∀(o29 : cardinal (List color)), cset o29 = insert (red n) (∅ : Finset (List color)) ∧ card o29 = (1 : ℤ) → ((0 : ℤ) ≤ n ∧ n < Int.ofNat (List.length (List.set count1 (Int.toNat n) o27))) ∧ (let o30 : cardinal (List color) := (List.set count1 (Int.toNat n) o27)[Int.toNat n]!; (∀(x : List color), ¬(x ∈ cset o30 ∧ x ∈ cset o29)) ∧ (∀(o31 : cardinal (List color)), cset o31 = cset o30 ∪ cset o29 ∧ card o31 = card o30 + card o29 → ((0 : ℤ) ≤ n ∧ n < Int.ofNat (List.length (List.set count1 (Int.toNat n) o27))) ∧ (List.length (List.set (List.set count1 (Int.toNat n) o27) (Int.toNat n) o31) = List.length (List.set count1 (Int.toNat n) o27) → getElem! (List.set (List.set count1 (Int.toNat n) o27) (Int.toNat n) o31) ∘ Int.toNat = Function.update (getElem! (List.set count1 (Int.toNat n) o27) ∘ Int.toNat) n o31 → (∀(i : ℤ) (s : List color), (0 : ℤ) ≤ i ∧ i < n + (1 : ℤ) → valid_coloring_l i s = (s ∈ cset ((List.set (List.set count1 (Int.toNat n) o27) (Int.toNat n) o31)[Int.toNat i]!))))))))))))))))))))))))))))))))
  := sorry
end verifythis_2018_le_rouge_et_le_noir_2_Top_mainqtvc
