From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Open Scope Z_scope.
Definition bijection {β : Type} {α : Type} `{Inhabited β} `{Countable β} `{Inhabited α} `{Countable α} (p : gset α) (q : β -> bool) (f : α -> β) (g : β -> α) := (∀(x : α), x ∈ p -> q (f x) = true ∧ g (f x) = x) ∧ (∀(x : β), q x = true -> g x ∈ p ∧ f (g x) = x).
Axiom cardinal : Type -> Type.
Axiom cardinal_inhabited : forall  {α : Type} `{Inhabited α} `{Countable α}, Inhabited (cardinal α).
Global Existing Instance cardinal_inhabited.
Axiom card : forall {α : Type} `{Inhabited α} `{Countable α}, cardinal α -> Z.
Axiom cset : forall {α : Type} `{Inhabited α} `{Countable α}, cardinal α -> gset α.
Axiom cardinal'invariant : forall  {α : Type} `{Inhabited α} `{Countable α} (self : cardinal α), card self = Z.of_nat (size (cset self)).
Definition cardinal'eq {α : Type} `{Inhabited α} `{Countable α} (a : cardinal α) (b : cardinal α) := card a = card b ∧ cset a = cset b.
Axiom cardinal'inj : forall  {α : Type} `{Inhabited α} `{Countable α} (a : cardinal α) (b : cardinal α) (fact0 : cardinal'eq a b), a = b.
Inductive color :=
  | Red : color
  | Black : color.
Axiom color_inhabited : Inhabited color.
Global Existing Instance color_inhabited.
Axiom color_countable : Countable color.
Global Existing Instance color_countable.
Axiom fc : Z -> color.
Axiom fc'def : forall  (x : Z), fc x = Red.
Definition red (n : Z) : list color := create_list (Z.to_nat n) (fc ∘ Z.of_nat).
Inductive valid_coloring_f : color -> list color -> Prop :=
 | ValidEmpty : valid_coloring_f Black ([] : list color)
 | ValidBlack (c : color) (s : list color) : valid_coloring_f c s -> valid_coloring_f Black (([Black]:list color) ++ s)
 | ValidRed (n : Z) (s : list color) : 3%Z ≤ n -> valid_coloring_f Black s -> valid_coloring_f Red (red n ++ s).
Definition valid_coloring (s : list color) := valid_coloring_f Red s ∨ valid_coloring_f Black s.
Definition valid_coloring_l (n : Z) (s : list color) := valid_coloring s ∧ Z.of_nat (length s) = n.
Definition valid_coloring_inter (n : Z) (m : Z) (s : list color) := valid_coloring_l n s ∧ (∃(i : Z), (0%Z ≤ i ∧ i < m) ∧ nth (Z.to_nat i) s inhabitant = Black).
Definition valid_coloring_at (n : Z) (m : Z) (s : list color) := valid_coloring_l n s ∧ nth (Z.to_nat m) s inhabitant = Black ∧ (∀(i : Z), 0%Z ≤ i ∧ i < m -> nth (Z.to_nat i) s inhabitant = Red).
Axiom valid_coloring_inter_closure : Z -> Z -> list color -> bool.
Axiom infix_plpl_closure : forall {α : Type} `{Inhabited α} `{Countable α}, list α -> list α -> list α.
Axiom fc1 : list color -> list color.
Axiom valid_coloring_at_closure : Z -> Z -> list color -> bool.
Axiom fc2 : Z -> list color -> list color.
Axiom fc3 : Z -> list color -> list color.
Axiom valid_coloring_inter_closure_def : forall  (y : Z) (y1 : Z) (y2 : list color), (valid_coloring_inter_closure y y1 y2 = true) = valid_coloring_inter y y1 y2.
Axiom infix_plpl_closure_def : forall  {α : Type} `{Inhabited α} `{Countable α} (y : list α) (y1 : list α), infix_plpl_closure y y1 = y ++ y1.
Axiom fc'def1 : forall  (s : list color), fc1 s = drop 1%nat s.
Axiom valid_coloring_at_closure_def : forall  (y : Z) (y1 : Z) (y2 : list color), (valid_coloring_at_closure y y1 y2 = true) = valid_coloring_at y y1 y2.
Axiom fc'def2 : forall  (k : Z) (s : list color), fc2 k s = red k ++ ([Black]:list color) ++ s.
Axiom fc'def3 : forall  (k : Z) (s : list color), fc3 k s = drop (Z.to_nat (k + 1%Z)) s.
Theorem main'vc (o1 : cardinal (list color)) (fact0 : cset o1 = (∅ : gset (list color))) (fact1 : card o1 = 0%Z) : 0%Z ≤ 51%Z ∧ (∀(count : list (cardinal (list color))), (∀(i : Z), 0%Z ≤ i ∧ i < 51%Z -> nth (Z.to_nat i) count inhabitant = o1) ∧ Z.of_nat (length count) = 51%Z -> (∀(o2 : cardinal (list color)), cset o2 = ({[([] : list color)]} : gset _) ∧ card o2 = 1%Z -> (0%Z ≤ 0%Z ∧ 0%Z < Z.of_nat (length count)) ∧ (length (set_list count 0%nat o2) = length count -> nth_i (set_list count 0%nat o2) = fun_updt (nth_i count) 0%Z o2 -> (let o3 : list color := ([] : list color) in let o4 : list color := ([Black]:list color) in let o5 : list color := o4 ++ o3 in Z.of_nat (length o5) = Z.of_nat (length o4) + Z.of_nat (length o3) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o4) -> nth (Z.to_nat i) o5 inhabitant = nth (Z.to_nat i) o4 inhabitant) ∧ (∀(i : Z), Z.of_nat (length o4) ≤ i ∧ i < Z.of_nat (length o5) -> nth (Z.to_nat i) o5 inhabitant = nth (Z.to_nat (i - Z.of_nat (length o4))) o3 inhabitant) -> (∀(o6 : cardinal (list color)), cset o6 = ({[o5]} : gset _) ∧ card o6 = 1%Z -> (0%Z ≤ 1%Z ∧ 1%Z < Z.of_nat (length (set_list count 0%nat o2))) ∧ (length (set_list (set_list count 0%nat o2) 1%nat o6) = length (set_list count 0%nat o2) -> nth_i (set_list (set_list count 0%nat o2) 1%nat o6) = fun_updt (nth_i (set_list count 0%nat o2)) 1%Z o6 -> (let o7 : list color := ([] : list color) in let o8 : list color := ([Black]:list color) in let o9 : list color := o8 ++ o7 in Z.of_nat (length o9) = Z.of_nat (length o8) + Z.of_nat (length o7) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o8) -> nth (Z.to_nat i) o9 inhabitant = nth (Z.to_nat i) o8 inhabitant) ∧ (∀(i : Z), Z.of_nat (length o8) ≤ i ∧ i < Z.of_nat (length o9) -> nth (Z.to_nat i) o9 inhabitant = nth (Z.to_nat (i - Z.of_nat (length o8))) o7 inhabitant) -> (let o10 : list color := ([Black]:list color) in let o11 : list color := o10 ++ o9 in Z.of_nat (length o11) = Z.of_nat (length o10) + Z.of_nat (length o9) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o10) -> nth (Z.to_nat i) o11 inhabitant = nth (Z.to_nat i) o10 inhabitant) ∧ (∀(i : Z), Z.of_nat (length o10) ≤ i ∧ i < Z.of_nat (length o11) -> nth (Z.to_nat i) o11 inhabitant = nth (Z.to_nat (i - Z.of_nat (length o10))) o9 inhabitant) -> (∀(o12 : cardinal (list color)), cset o12 = ({[o11]} : gset _) ∧ card o12 = 1%Z -> (0%Z ≤ 2%Z ∧ 2%Z < Z.of_nat (length (set_list (set_list count 0%nat o2) 1%nat o6))) ∧ (length (set_list (set_list (set_list count 0%nat o2) 1%nat o6) 2%nat o12) = length (set_list (set_list count 0%nat o2) 1%nat o6) -> nth_i (set_list (set_list (set_list count 0%nat o2) 1%nat o6) 2%nat o12) = fun_updt (nth_i (set_list (set_list count 0%nat o2) 1%nat o6)) 2%Z o12 -> (let o13 : list color := ([] : list color) in let o14 : list color := ([Black]:list color) in let o15 : list color := o14 ++ o13 in Z.of_nat (length o15) = Z.of_nat (length o14) + Z.of_nat (length o13) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o14) -> nth (Z.to_nat i) o15 inhabitant = nth (Z.to_nat i) o14 inhabitant) ∧ (∀(i : Z), Z.of_nat (length o14) ≤ i ∧ i < Z.of_nat (length o15) -> nth (Z.to_nat i) o15 inhabitant = nth (Z.to_nat (i - Z.of_nat (length o14))) o13 inhabitant) -> (let o16 : list color := ([Black]:list color) in let o17 : list color := o16 ++ o15 in Z.of_nat (length o17) = Z.of_nat (length o16) + Z.of_nat (length o15) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o16) -> nth (Z.to_nat i) o17 inhabitant = nth (Z.to_nat i) o16 inhabitant) ∧ (∀(i : Z), Z.of_nat (length o16) ≤ i ∧ i < Z.of_nat (length o17) -> nth (Z.to_nat i) o17 inhabitant = nth (Z.to_nat (i - Z.of_nat (length o16))) o15 inhabitant) -> (let o18 : list color := ([Black]:list color) in let o19 : list color := o18 ++ o17 in Z.of_nat (length o19) = Z.of_nat (length o18) + Z.of_nat (length o17) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o18) -> nth (Z.to_nat i) o19 inhabitant = nth (Z.to_nat i) o18 inhabitant) ∧ (∀(i : Z), Z.of_nat (length o18) ≤ i ∧ i < Z.of_nat (length o19) -> nth (Z.to_nat i) o19 inhabitant = nth (Z.to_nat (i - Z.of_nat (length o18))) o17 inhabitant) -> (let o20 : list color := ([] : list color) in let o21 : list color := red 3%Z in let o22 : list color := o21 ++ o20 in Z.of_nat (length o22) = Z.of_nat (length o21) + Z.of_nat (length o20) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o21) -> nth (Z.to_nat i) o22 inhabitant = nth (Z.to_nat i) o21 inhabitant) ∧ (∀(i : Z), Z.of_nat (length o21) ≤ i ∧ i < Z.of_nat (length o22) -> nth (Z.to_nat i) o22 inhabitant = nth (Z.to_nat (i - Z.of_nat (length o21))) o20 inhabitant) -> (let o23 : gset (list color) := ({[o22; o19]} : gset _) in 2%Z = Z.of_nat (size o23) ∧ (∀(o24 : cardinal (list color)), card o24 = 2%Z ∧ cset o24 = o23 -> (0%Z ≤ 3%Z ∧ 3%Z < Z.of_nat (length (set_list (set_list (set_list count 0%nat o2) 1%nat o6) 2%nat o12))) ∧ (length (set_list (set_list (set_list (set_list count 0%nat o2) 1%nat o6) 2%nat o12) 3%nat o24) = length (set_list (set_list (set_list count 0%nat o2) 1%nat o6) 2%nat o12) -> nth_i (set_list (set_list (set_list (set_list count 0%nat o2) 1%nat o6) 2%nat o12) 3%nat o24) = fun_updt (nth_i (set_list (set_list (set_list count 0%nat o2) 1%nat o6) 2%nat o12)) 3%Z o24 -> 4%Z ≤ 50%Z + 1%Z -> (∀(i : Z) (s : list color), 0%Z ≤ i ∧ i < 4%Z -> valid_coloring_l i s = (s ∈ cset (nth (Z.to_nat i) (set_list (set_list (set_list (set_list count 0%nat o2) 1%nat o6) 2%nat o12) 3%nat o24) inhabitant))) ∧ (∀(count1 : list (cardinal (list color))), length count1 = length (set_list (set_list (set_list (set_list count 0%nat o2) 1%nat o6) 2%nat o12) 3%nat o24) -> (∀(n : Z), (4%Z ≤ n ∧ n ≤ 50%Z) ∧ (∀(i : Z) (s : list color), 0%Z ≤ i ∧ i < n -> valid_coloring_l i s = (s ∈ cset (nth (Z.to_nat i) count1 inhabitant))) -> (let q : list color -> bool := valid_coloring_inter_closure n 3%Z in let o25 : Z := n - 1%Z in (0%Z ≤ o25 ∧ o25 < Z.of_nat (length count1)) ∧ (let o26 : cardinal (list color) := nth (Z.to_nat o25) count1 inhabitant in bijection (cset o26) q (infix_plpl_closure ([Black]:list color)) fc1 ∧ (∀(o27 : cardinal (list color)), (∀(x : list color), (x ∈ cset o27) = (q x = true)) ∧ card o27 = card o26 -> (0%Z ≤ n ∧ n < Z.of_nat (length count1)) ∧ (length (set_list count1 (Z.to_nat n) o27) = length count1 -> nth_i (set_list count1 (Z.to_nat n) o27) = fun_updt (nth_i count1) n o27 -> (let o28 : Z := n - 1%Z in (3%Z ≤ o28 + 1%Z -> ((∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat i) (set_list count1 (Z.to_nat n) o27) inhabitant = nth (Z.to_nat i) count1 inhabitant) ∧ (∀(s : list color), valid_coloring_inter n 3%Z s = (s ∈ cset (nth (Z.to_nat n) (set_list count1 (Z.to_nat n) o27) inhabitant)))) ∧ (∀(count2 : list (cardinal (list color))), length count2 = length (set_list count1 (Z.to_nat n) o27) -> (∀(k : Z), (3%Z ≤ k ∧ k ≤ o28) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat i) count2 inhabitant = nth (Z.to_nat i) count1 inhabitant) ∧ (∀(s : list color), valid_coloring_inter n k s = (s ∈ cset (nth (Z.to_nat n) count2 inhabitant))) -> (let q1 : list color -> bool := valid_coloring_at_closure n k in let o29 : Z := n - k - 1%Z in (0%Z ≤ o29 ∧ o29 < Z.of_nat (length count2)) ∧ (let o30 : cardinal (list color) := nth (Z.to_nat o29) count2 inhabitant in bijection (cset o30) q1 (fc2 k) (fc3 k) ∧ (∀(o31 : cardinal (list color)), (∀(x : list color), (x ∈ cset o31) = (q1 x = true)) ∧ card o31 = card o30 -> (0%Z ≤ n ∧ n < Z.of_nat (length count2)) ∧ (let o32 : cardinal (list color) := nth (Z.to_nat n) count2 inhabitant in (∀(x : list color), ¬ (x ∈ cset o32 ∧ x ∈ cset o31)) ∧ (∀(o33 : cardinal (list color)), cset o33 = cset o32 ∪ cset o31 ∧ card o33 = card o32 + card o31 -> (0%Z ≤ n ∧ n < Z.of_nat (length count2)) ∧ (length (set_list count2 (Z.to_nat n) o33) = length count2 -> nth_i (set_list count2 (Z.to_nat n) o33) = fun_updt (nth_i count2) n o33 -> (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat i) (set_list count2 (Z.to_nat n) o33) inhabitant = nth (Z.to_nat i) count1 inhabitant) ∧ (∀(s : list color), valid_coloring_inter n (k + 1%Z) s = (s ∈ cset (nth (Z.to_nat n) (set_list count2 (Z.to_nat n) o33) inhabitant)))))))))) ∧ ((∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat i) count2 inhabitant = nth (Z.to_nat i) count1 inhabitant) ∧ (∀(s : list color), valid_coloring_inter n (o28 + 1%Z) s = (s ∈ cset (nth (Z.to_nat n) count2 inhabitant))) -> (∀(o29 : cardinal (list color)), cset o29 = ({[red n]} : gset _) ∧ card o29 = 1%Z -> (0%Z ≤ n ∧ n < Z.of_nat (length count2)) ∧ (let o30 : cardinal (list color) := nth (Z.to_nat n) count2 inhabitant in (∀(x : list color), ¬ (x ∈ cset o30 ∧ x ∈ cset o29)) ∧ (∀(o31 : cardinal (list color)), cset o31 = cset o30 ∪ cset o29 ∧ card o31 = card o30 + card o29 -> (0%Z ≤ n ∧ n < Z.of_nat (length count2)) ∧ (length (set_list count2 (Z.to_nat n) o31) = length count2 -> nth_i (set_list count2 (Z.to_nat n) o31) = fun_updt (nth_i count2) n o31 -> (∀(i : Z) (s : list color), 0%Z ≤ i ∧ i < n + 1%Z -> valid_coloring_l i s = (s ∈ cset (nth (Z.to_nat i) (set_list count2 (Z.to_nat n) o31) inhabitant)))))))))) ∧ (o28 + 1%Z < 3%Z -> (∀(o29 : cardinal (list color)), cset o29 = ({[red n]} : gset _) ∧ card o29 = 1%Z -> (0%Z ≤ n ∧ n < Z.of_nat (length (set_list count1 (Z.to_nat n) o27))) ∧ (let o30 : cardinal (list color) := nth (Z.to_nat n) (set_list count1 (Z.to_nat n) o27) inhabitant in (∀(x : list color), ¬ (x ∈ cset o30 ∧ x ∈ cset o29)) ∧ (∀(o31 : cardinal (list color)), cset o31 = cset o30 ∪ cset o29 ∧ card o31 = card o30 + card o29 -> (0%Z ≤ n ∧ n < Z.of_nat (length (set_list count1 (Z.to_nat n) o27))) ∧ (length (set_list (set_list count1 (Z.to_nat n) o27) (Z.to_nat n) o31) = length (set_list count1 (Z.to_nat n) o27) -> nth_i (set_list (set_list count1 (Z.to_nat n) o27) (Z.to_nat n) o31) = fun_updt (nth_i (set_list count1 (Z.to_nat n) o27)) n o31 -> (∀(i : Z) (s : list color), 0%Z ≤ i ∧ i < n + 1%Z -> valid_coloring_l i s = (s ∈ cset (nth (Z.to_nat i) (set_list (set_list count1 (Z.to_nat n) o27) (Z.to_nat n) o31) inhabitant)))))))))))))))))))))))))))))))).
Admitted.
