theory verifythis_2019_cartesian_trees_Top_construct_dirsqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.exn_Exn"
begin
axiomatization where Trans:   "z \<le> x"
 if "y \<le> x"
 and "z \<le> y"
  for y :: "int"
  and x :: "int"
  and z :: "int"
inductive sorted :: "int list \<Rightarrow> bool" where
   Sorted_Nil: "sorted (Nil :: int list)"
 | Sorted_One: "sorted (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two: "y \<le> x \<Longrightarrow> sorted (Cons y l) \<Longrightarrow> sorted (Cons x (Cons y l))" for y :: "int" and x :: "int" and l :: "int list"
axiomatization where sorted_mem:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> y \<le> x) \<and> sorted l \<longleftrightarrow> sorted (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append:   "sorted l1 \<and> sorted l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> y \<le> x) \<longleftrightarrow> sorted (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
consts destruct :: "'xi list \<Rightarrow> 'xi \<times> 'xi list"
axiomatization where destruct'def:   "case l of Cons h t \<Rightarrow> destruct l = (h, t) | _ \<Rightarrow> False"
 if "\<not>is_Nil l"
  for l :: "'xi list"
consts peek :: "'xi list \<Rightarrow> 'xi"
axiomatization where peek'def:   "case destruct l of (h, _) \<Rightarrow> peek l = h"
 if "\<not>is_Nil l"
  for l :: "'xi list"
axiomatization where peek'spec:   "peek l \<in> set l"
 if "\<not>is_Nil l"
  for l :: "'xi list"
consts tail :: "'xi list \<Rightarrow> 'xi list"
axiomatization where tail'def:   "case destruct l of (_, t) \<Rightarrow> tail l = t"
 if "\<not>is_Nil l"
  for l :: "'xi list"
datatype  dir = dir'mk (left1: "int option") (right1: "int option")
typedecl  dirs
definition parent :: "dir list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "parent t p s \<longleftrightarrow> left1 (t ! nat p) = Some s \<or> right1 (t ! nat p) = Some s" for t p s
inductive descendant :: "dir list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> bool" where
   Self: "p = s \<Longrightarrow> descendant t p s" for p :: "int" and s :: "int" and t :: "dir list"
 | Son_left: "descendant t p s1 \<Longrightarrow> left1 (t ! nat s1) = Some s2 \<Longrightarrow> descendant t p s2" for t :: "dir list" and p :: "int" and s1 :: "int" and s2 :: "int"
 | Son_right: "descendant t p s1 \<Longrightarrow> right1 (t ! nat s1) = Some s2 \<Longrightarrow> descendant t p s2" for t :: "dir list" and p :: "int" and s1 :: "int" and s2 :: "int"
definition is_smallest :: "int list \<Rightarrow> int \<Rightarrow> _"
  where "is_smallest a i \<longleftrightarrow> ((0 :: int) \<le> i \<and> i < int (length a)) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> a ! nat i \<le> a ! nat j)" for a i
theorem construct_dirs'vc:
  fixes a :: "int list"
  assumes fact0: "\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < int (length a) \<longrightarrow> \<not>a ! nat i = a ! nat j"
  shows "let n :: int = int (length a) in \<forall>(s_left :: int list). (\<forall>(y :: int). (0 :: int) \<le> y \<and> y < int (length a) \<longrightarrow> s_left ! nat y < y) \<and> (\<forall>(y :: int). (0 :: int) \<le> y \<and> y < int (length a) \<longrightarrow> (0 :: int) \<le> s_left ! nat y \<longrightarrow> a ! nat (s_left ! nat y) < a ! nat y) \<and> (\<forall>(x :: int) (z :: int). (0 :: int) \<le> x \<and> x < int (length a) \<longrightarrow> s_left ! nat x < z \<and> z < x \<longrightarrow> a ! nat x \<le> a ! nat z) \<and> length s_left = length a \<longrightarrow> (\<forall>(s_right :: int list). (\<forall>(y :: int). (0 :: int) \<le> y \<and> y < int (length a) \<longrightarrow> y < s_right ! nat y) \<and> (\<forall>(y :: int). (0 :: int) \<le> y \<and> y < int (length a) \<longrightarrow> s_right ! nat y < int (length a) \<longrightarrow> a ! nat (s_right ! nat y) < a ! nat y) \<and> (\<forall>(x :: int) (z :: int). (0 :: int) \<le> x \<and> x < int (length a) \<longrightarrow> x < z \<and> z < s_right ! nat x \<longrightarrow> a ! nat x \<le> a ! nat z) \<and> length s_right = length a \<longrightarrow> (0 :: int) \<le> n \<and> (\<forall>(dirs1 :: dir list). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> dirs1 ! nat i = dir'mk None None) \<and> int (length dirs1) = n \<longrightarrow> (let o1 :: int = n - (1 :: int) in ((0 :: int) \<le> o1 + (1 :: int) \<longrightarrow> ((\<forall>(j :: int) (v :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (left1 (dirs1 ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> ((0 :: int) \<le> v \<and> v < j) \<and> (\<forall>(x :: int). v < x \<and> x < j \<longrightarrow> a ! nat j \<le> a ! nat x)) \<and> (right1 (dirs1 ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> (j < v \<and> v < int (length a)) \<and> (\<forall>(x :: int). j < x \<and> x < v \<longrightarrow> a ! nat j \<le> a ! nat x))) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < (0 :: int) \<longrightarrow> (if (0 :: int) \<le> s_left ! nat j \<and> n \<le> s_right ! nat j then right1 (dirs1 ! nat (s_left ! nat j)) = Some j else if s_left ! nat j < (0 :: int) \<and> s_right ! nat j < n then left1 (dirs1 ! nat (s_right ! nat j)) = Some j else (0 :: int) \<le> s_left ! nat j \<and> s_right ! nat j < n \<longrightarrow> (if a ! nat (s_right ! nat j) < a ! nat (s_left ! nat j) then right1 (dirs1 ! nat (s_left ! nat j)) = Some j else left1 (dirs1 ! nat (s_right ! nat j)) = Some j))) \<and> (\<forall>(j :: int) (p :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (0 :: int) \<le> p \<and> p < int (length a) \<longrightarrow> (right1 (dirs1 ! nat p) = Some j \<longrightarrow> p = s_left ! nat j \<and> (s_right ! nat j < n \<longrightarrow> a ! nat (s_right ! nat j) < a ! nat (s_left ! nat j))) \<and> (left1 (dirs1 ! nat p) = Some j \<longrightarrow> p = s_right ! nat j \<and> ((0 :: int) \<le> s_left ! nat j \<longrightarrow> a ! nat (s_left ! nat j) \<le> a ! nat (s_right ! nat j))))) \<and> (\<forall>(dirs2 :: dir list). length dirs2 = length dirs1 \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i \<le> o1) \<and> (\<forall>(j :: int) (v :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (left1 (dirs2 ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> ((0 :: int) \<le> v \<and> v < j) \<and> (\<forall>(x :: int). v < x \<and> x < j \<longrightarrow> a ! nat j \<le> a ! nat x)) \<and> (right1 (dirs2 ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> (j < v \<and> v < int (length a)) \<and> (\<forall>(x :: int). j < x \<and> x < v \<longrightarrow> a ! nat j \<le> a ! nat x))) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i \<longrightarrow> (if (0 :: int) \<le> s_left ! nat j \<and> n \<le> s_right ! nat j then right1 (dirs2 ! nat (s_left ! nat j)) = Some j else if s_left ! nat j < (0 :: int) \<and> s_right ! nat j < n then left1 (dirs2 ! nat (s_right ! nat j)) = Some j else (0 :: int) \<le> s_left ! nat j \<and> s_right ! nat j < n \<longrightarrow> (if a ! nat (s_right ! nat j) < a ! nat (s_left ! nat j) then right1 (dirs2 ! nat (s_left ! nat j)) = Some j else left1 (dirs2 ! nat (s_right ! nat j)) = Some j))) \<and> (\<forall>(j :: int) (p :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (0 :: int) \<le> p \<and> p < int (length a) \<longrightarrow> (right1 (dirs2 ! nat p) = Some j \<longrightarrow> p = s_left ! nat j \<and> (s_right ! nat j < n \<longrightarrow> a ! nat (s_right ! nat j) < a ! nat (s_left ! nat j))) \<and> (left1 (dirs2 ! nat p) = Some j \<longrightarrow> p = s_right ! nat j \<and> ((0 :: int) \<le> s_left ! nat j \<longrightarrow> a ! nat (s_left ! nat j) \<le> a ! nat (s_right ! nat j)))) \<longrightarrow> ((0 :: int) \<le> i \<and> i < int (length s_left)) \<and> (let li :: int = s_left ! nat i in ((0 :: int) \<le> i \<and> i < int (length s_right)) \<and> (let ri :: int = s_right ! nat i in if (0 :: int) \<le> li then if ri < n then ((0 :: int) \<le> ri \<and> ri < int (length a)) \<and> ((0 :: int) \<le> li \<and> li < int (length a)) \<and> (if a ! nat ri < a ! nat li then ((0 :: int) \<le> li \<and> li < int (length dirs2)) \<and> (let o2 :: dir = dir'mk (left1 (dirs2 ! nat li)) (Some i) in ((0 :: int) \<le> li \<and> li < int (length dirs2)) \<and> (length (dirs2[nat li := o2]) = length dirs2 \<longrightarrow> nth (dirs2[nat li := o2]) o nat = (nth dirs2 o nat)(li := o2) \<longrightarrow> (\<forall>(j :: int) (v :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (left1 (dirs2[nat li := o2] ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> ((0 :: int) \<le> v \<and> v < j) \<and> (\<forall>(x :: int). v < x \<and> x < j \<longrightarrow> a ! nat j \<le> a ! nat x)) \<and> (right1 (dirs2[nat li := o2] ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> (j < v \<and> v < int (length a)) \<and> (\<forall>(x :: int). j < x \<and> x < v \<longrightarrow> a ! nat j \<le> a ! nat x))) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i + (1 :: int) \<longrightarrow> (if (0 :: int) \<le> s_left ! nat j \<and> n \<le> s_right ! nat j then right1 (dirs2[nat li := o2] ! nat (s_left ! nat j)) = Some j else if s_left ! nat j < (0 :: int) \<and> s_right ! nat j < n then left1 (dirs2[nat li := o2] ! nat (s_right ! nat j)) = Some j else (0 :: int) \<le> s_left ! nat j \<and> s_right ! nat j < n \<longrightarrow> (if a ! nat (s_right ! nat j) < a ! nat (s_left ! nat j) then right1 (dirs2[nat li := o2] ! nat (s_left ! nat j)) = Some j else left1 (dirs2[nat li := o2] ! nat (s_right ! nat j)) = Some j))) \<and> (\<forall>(j :: int) (p :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (0 :: int) \<le> p \<and> p < int (length a) \<longrightarrow> (right1 (dirs2[nat li := o2] ! nat p) = Some j \<longrightarrow> p = s_left ! nat j \<and> (s_right ! nat j < n \<longrightarrow> a ! nat (s_right ! nat j) < a ! nat (s_left ! nat j))) \<and> (left1 (dirs2[nat li := o2] ! nat p) = Some j \<longrightarrow> p = s_right ! nat j \<and> ((0 :: int) \<le> s_left ! nat j \<longrightarrow> a ! nat (s_left ! nat j) \<le> a ! nat (s_right ! nat j)))))) else ((0 :: int) \<le> ri \<and> ri < int (length dirs2)) \<and> (let o2 :: dir = dir'mk (Some i) (right1 (dirs2 ! nat ri)) in ((0 :: int) \<le> ri \<and> ri < int (length dirs2)) \<and> (length (dirs2[nat ri := o2]) = length dirs2 \<longrightarrow> nth (dirs2[nat ri := o2]) o nat = (nth dirs2 o nat)(ri := o2) \<longrightarrow> (\<forall>(j :: int) (v :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (left1 (dirs2[nat ri := o2] ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> ((0 :: int) \<le> v \<and> v < j) \<and> (\<forall>(x :: int). v < x \<and> x < j \<longrightarrow> a ! nat j \<le> a ! nat x)) \<and> (right1 (dirs2[nat ri := o2] ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> (j < v \<and> v < int (length a)) \<and> (\<forall>(x :: int). j < x \<and> x < v \<longrightarrow> a ! nat j \<le> a ! nat x))) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i + (1 :: int) \<longrightarrow> (if (0 :: int) \<le> s_left ! nat j \<and> n \<le> s_right ! nat j then right1 (dirs2[nat ri := o2] ! nat (s_left ! nat j)) = Some j else if s_left ! nat j < (0 :: int) \<and> s_right ! nat j < n then left1 (dirs2[nat ri := o2] ! nat (s_right ! nat j)) = Some j else (0 :: int) \<le> s_left ! nat j \<and> s_right ! nat j < n \<longrightarrow> (if a ! nat (s_right ! nat j) < a ! nat (s_left ! nat j) then right1 (dirs2[nat ri := o2] ! nat (s_left ! nat j)) = Some j else left1 (dirs2[nat ri := o2] ! nat (s_right ! nat j)) = Some j))) \<and> (\<forall>(j :: int) (p :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (0 :: int) \<le> p \<and> p < int (length a) \<longrightarrow> (right1 (dirs2[nat ri := o2] ! nat p) = Some j \<longrightarrow> p = s_left ! nat j \<and> (s_right ! nat j < n \<longrightarrow> a ! nat (s_right ! nat j) < a ! nat (s_left ! nat j))) \<and> (left1 (dirs2[nat ri := o2] ! nat p) = Some j \<longrightarrow> p = s_right ! nat j \<and> ((0 :: int) \<le> s_left ! nat j \<longrightarrow> a ! nat (s_left ! nat j) \<le> a ! nat (s_right ! nat j))))))) else ((0 :: int) \<le> li \<and> li < int (length dirs2)) \<and> (let o2 :: dir = dir'mk (left1 (dirs2 ! nat li)) (Some i) in ((0 :: int) \<le> li \<and> li < int (length dirs2)) \<and> (length (dirs2[nat li := o2]) = length dirs2 \<longrightarrow> nth (dirs2[nat li := o2]) o nat = (nth dirs2 o nat)(li := o2) \<longrightarrow> (\<forall>(j :: int) (v :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (left1 (dirs2[nat li := o2] ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> ((0 :: int) \<le> v \<and> v < j) \<and> (\<forall>(x :: int). v < x \<and> x < j \<longrightarrow> a ! nat j \<le> a ! nat x)) \<and> (right1 (dirs2[nat li := o2] ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> (j < v \<and> v < int (length a)) \<and> (\<forall>(x :: int). j < x \<and> x < v \<longrightarrow> a ! nat j \<le> a ! nat x))) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i + (1 :: int) \<longrightarrow> (if (0 :: int) \<le> s_left ! nat j \<and> n \<le> s_right ! nat j then right1 (dirs2[nat li := o2] ! nat (s_left ! nat j)) = Some j else if s_left ! nat j < (0 :: int) \<and> s_right ! nat j < n then left1 (dirs2[nat li := o2] ! nat (s_right ! nat j)) = Some j else (0 :: int) \<le> s_left ! nat j \<and> s_right ! nat j < n \<longrightarrow> (if a ! nat (s_right ! nat j) < a ! nat (s_left ! nat j) then right1 (dirs2[nat li := o2] ! nat (s_left ! nat j)) = Some j else left1 (dirs2[nat li := o2] ! nat (s_right ! nat j)) = Some j))) \<and> (\<forall>(j :: int) (p :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (0 :: int) \<le> p \<and> p < int (length a) \<longrightarrow> (right1 (dirs2[nat li := o2] ! nat p) = Some j \<longrightarrow> p = s_left ! nat j \<and> (s_right ! nat j < n \<longrightarrow> a ! nat (s_right ! nat j) < a ! nat (s_left ! nat j))) \<and> (left1 (dirs2[nat li := o2] ! nat p) = Some j \<longrightarrow> p = s_right ! nat j \<and> ((0 :: int) \<le> s_left ! nat j \<longrightarrow> a ! nat (s_left ! nat j) \<le> a ! nat (s_right ! nat j)))))) else if ri < n then ((0 :: int) \<le> ri \<and> ri < int (length dirs2)) \<and> (let o2 :: dir = dir'mk (Some i) (right1 (dirs2 ! nat ri)) in ((0 :: int) \<le> ri \<and> ri < int (length dirs2)) \<and> (length (dirs2[nat ri := o2]) = length dirs2 \<longrightarrow> nth (dirs2[nat ri := o2]) o nat = (nth dirs2 o nat)(ri := o2) \<longrightarrow> (\<forall>(j :: int) (v :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (left1 (dirs2[nat ri := o2] ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> ((0 :: int) \<le> v \<and> v < j) \<and> (\<forall>(x :: int). v < x \<and> x < j \<longrightarrow> a ! nat j \<le> a ! nat x)) \<and> (right1 (dirs2[nat ri := o2] ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> (j < v \<and> v < int (length a)) \<and> (\<forall>(x :: int). j < x \<and> x < v \<longrightarrow> a ! nat j \<le> a ! nat x))) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i + (1 :: int) \<longrightarrow> (if (0 :: int) \<le> s_left ! nat j \<and> n \<le> s_right ! nat j then right1 (dirs2[nat ri := o2] ! nat (s_left ! nat j)) = Some j else if s_left ! nat j < (0 :: int) \<and> s_right ! nat j < n then left1 (dirs2[nat ri := o2] ! nat (s_right ! nat j)) = Some j else (0 :: int) \<le> s_left ! nat j \<and> s_right ! nat j < n \<longrightarrow> (if a ! nat (s_right ! nat j) < a ! nat (s_left ! nat j) then right1 (dirs2[nat ri := o2] ! nat (s_left ! nat j)) = Some j else left1 (dirs2[nat ri := o2] ! nat (s_right ! nat j)) = Some j))) \<and> (\<forall>(j :: int) (p :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (0 :: int) \<le> p \<and> p < int (length a) \<longrightarrow> (right1 (dirs2[nat ri := o2] ! nat p) = Some j \<longrightarrow> p = s_left ! nat j \<and> (s_right ! nat j < n \<longrightarrow> a ! nat (s_right ! nat j) < a ! nat (s_left ! nat j))) \<and> (left1 (dirs2[nat ri := o2] ! nat p) = Some j \<longrightarrow> p = s_right ! nat j \<and> ((0 :: int) \<le> s_left ! nat j \<longrightarrow> a ! nat (s_left ! nat j) \<le> a ! nat (s_right ! nat j)))))) else (\<forall>(j :: int) (v :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (left1 (dirs2 ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> ((0 :: int) \<le> v \<and> v < j) \<and> (\<forall>(x :: int). v < x \<and> x < j \<longrightarrow> a ! nat j \<le> a ! nat x)) \<and> (right1 (dirs2 ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> (j < v \<and> v < int (length a)) \<and> (\<forall>(x :: int). j < x \<and> x < v \<longrightarrow> a ! nat j \<le> a ! nat x))) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i + (1 :: int) \<longrightarrow> (if (0 :: int) \<le> s_left ! nat j \<and> n \<le> s_right ! nat j then right1 (dirs2 ! nat (s_left ! nat j)) = Some j else if s_left ! nat j < (0 :: int) \<and> s_right ! nat j < n then left1 (dirs2 ! nat (s_right ! nat j)) = Some j else (0 :: int) \<le> s_left ! nat j \<and> s_right ! nat j < n \<longrightarrow> (if a ! nat (s_right ! nat j) < a ! nat (s_left ! nat j) then right1 (dirs2 ! nat (s_left ! nat j)) = Some j else left1 (dirs2 ! nat (s_right ! nat j)) = Some j))) \<and> (\<forall>(j :: int) (p :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (0 :: int) \<le> p \<and> p < int (length a) \<longrightarrow> (right1 (dirs2 ! nat p) = Some j \<longrightarrow> p = s_left ! nat j \<and> (s_right ! nat j < n \<longrightarrow> a ! nat (s_right ! nat j) < a ! nat (s_left ! nat j))) \<and> (left1 (dirs2 ! nat p) = Some j \<longrightarrow> p = s_right ! nat j \<and> ((0 :: int) \<le> s_left ! nat j \<longrightarrow> a ! nat (s_left ! nat j) \<le> a ! nat (s_right ! nat j))))))) \<and> ((\<forall>(j :: int) (v :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (left1 (dirs2 ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> ((0 :: int) \<le> v \<and> v < j) \<and> (\<forall>(x :: int). v < x \<and> x < j \<longrightarrow> a ! nat j \<le> a ! nat x)) \<and> (right1 (dirs2 ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> (j < v \<and> v < int (length a)) \<and> (\<forall>(x :: int). j < x \<and> x < v \<longrightarrow> a ! nat j \<le> a ! nat x))) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < o1 + (1 :: int) \<longrightarrow> (if (0 :: int) \<le> s_left ! nat j \<and> n \<le> s_right ! nat j then right1 (dirs2 ! nat (s_left ! nat j)) = Some j else if s_left ! nat j < (0 :: int) \<and> s_right ! nat j < n then left1 (dirs2 ! nat (s_right ! nat j)) = Some j else (0 :: int) \<le> s_left ! nat j \<and> s_right ! nat j < n \<longrightarrow> (if a ! nat (s_right ! nat j) < a ! nat (s_left ! nat j) then right1 (dirs2 ! nat (s_left ! nat j)) = Some j else left1 (dirs2 ! nat (s_right ! nat j)) = Some j))) \<and> (\<forall>(j :: int) (p :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (0 :: int) \<le> p \<and> p < int (length a) \<longrightarrow> (right1 (dirs2 ! nat p) = Some j \<longrightarrow> p = s_left ! nat j \<and> (s_right ! nat j < n \<longrightarrow> a ! nat (s_right ! nat j) < a ! nat (s_left ! nat j))) \<and> (left1 (dirs2 ! nat p) = Some j \<longrightarrow> p = s_right ! nat j \<and> ((0 :: int) \<le> s_left ! nat j \<longrightarrow> a ! nat (s_left ! nat j) \<le> a ! nat (s_right ! nat j)))) \<longrightarrow> length dirs2 = length a \<and> (\<forall>(j :: int) (v :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (left1 (dirs2 ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> ((0 :: int) \<le> v \<and> v < j) \<and> (\<forall>(x :: int). v < x \<and> x < j \<longrightarrow> a ! nat j < a ! nat x)) \<and> (right1 (dirs2 ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> (j < v \<and> v < int (length a)) \<and> (\<forall>(x :: int). j < x \<and> x < v \<longrightarrow> a ! nat j < a ! nat x))) \<and> (\<forall>(p :: int) (s :: int). (0 :: int) \<le> p \<and> p < int (length a) \<longrightarrow> descendant dirs2 p s \<longrightarrow> ((0 :: int) \<le> s \<and> s < int (length a)) \<and> a ! nat p \<le> a ! nat s) \<and> (\<forall>(p1 :: int) (p2 :: int) (s :: int). (0 :: int) \<le> p1 \<and> p1 < int (length a) \<longrightarrow> descendant dirs2 p2 s \<longrightarrow> (left1 (dirs2 ! nat p1) = Some p2 \<longrightarrow> s < p1) \<and> (right1 (dirs2 ! nat p1) = Some p2 \<longrightarrow> p1 < s)) \<and> (\<forall>(i :: int) (k :: int). (0 :: int) \<le> i \<and> i < int (length a) \<longrightarrow> (0 :: int) \<le> k \<and> k < int (length a) \<longrightarrow> a ! nat k < a ! nat i \<longrightarrow> (\<exists>(sm :: int). ((0 :: int) \<le> sm \<and> sm < int (length a)) \<and> parent dirs2 sm i)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length a) \<longrightarrow> is_smallest a i \<or> (\<exists>(sm :: int). ((0 :: int) \<le> sm \<and> sm < int (length a)) \<and> parent dirs2 sm i)) \<and> (\<forall>(p1 :: int) (p2 :: int) (s :: int). (0 :: int) \<le> p1 \<and> p1 < int (length a) \<longrightarrow> (0 :: int) \<le> p2 \<and> p2 < int (length a) \<longrightarrow> (0 :: int) \<le> s \<and> s < int (length a) \<longrightarrow> parent dirs2 p1 s \<longrightarrow> parent dirs2 p2 s \<longrightarrow> p1 = p2) \<and> (\<forall>(p1 :: int) (p2 :: int). (0 :: int) \<le> p1 \<and> p1 < int (length a) \<longrightarrow> (0 :: int) \<le> p2 \<and> p2 < int (length a) \<longrightarrow> (0 :: int) \<le> p1 \<and> p1 < int (length a) \<longrightarrow> parent dirs2 p1 p2 \<longrightarrow> descendant dirs2 p2 p1 \<longrightarrow> \<not>True)))) \<and> (o1 + (1 :: int) < (0 :: int) \<longrightarrow> length dirs1 = length a \<and> (\<forall>(j :: int) (v :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> (left1 (dirs1 ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> ((0 :: int) \<le> v \<and> v < j) \<and> (\<forall>(x :: int). v < x \<and> x < j \<longrightarrow> a ! nat j < a ! nat x)) \<and> (right1 (dirs1 ! nat j) = Some v \<longrightarrow> a ! nat j < a ! nat v \<and> (j < v \<and> v < int (length a)) \<and> (\<forall>(x :: int). j < x \<and> x < v \<longrightarrow> a ! nat j < a ! nat x))) \<and> (\<forall>(p :: int) (s :: int). (0 :: int) \<le> p \<and> p < int (length a) \<longrightarrow> descendant dirs1 p s \<longrightarrow> ((0 :: int) \<le> s \<and> s < int (length a)) \<and> a ! nat p \<le> a ! nat s) \<and> (\<forall>(p1 :: int) (p2 :: int) (s :: int). (0 :: int) \<le> p1 \<and> p1 < int (length a) \<longrightarrow> descendant dirs1 p2 s \<longrightarrow> (left1 (dirs1 ! nat p1) = Some p2 \<longrightarrow> s < p1) \<and> (right1 (dirs1 ! nat p1) = Some p2 \<longrightarrow> p1 < s)) \<and> (\<forall>(i :: int) (k :: int). (0 :: int) \<le> i \<and> i < int (length a) \<longrightarrow> (0 :: int) \<le> k \<and> k < int (length a) \<longrightarrow> a ! nat k < a ! nat i \<longrightarrow> (\<exists>(sm :: int). ((0 :: int) \<le> sm \<and> sm < int (length a)) \<and> parent dirs1 sm i)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length a) \<longrightarrow> is_smallest a i \<or> (\<exists>(sm :: int). ((0 :: int) \<le> sm \<and> sm < int (length a)) \<and> parent dirs1 sm i)) \<and> (\<forall>(p1 :: int) (p2 :: int) (s :: int). (0 :: int) \<le> p1 \<and> p1 < int (length a) \<longrightarrow> (0 :: int) \<le> p2 \<and> p2 < int (length a) \<longrightarrow> (0 :: int) \<le> s \<and> s < int (length a) \<longrightarrow> parent dirs1 p1 s \<longrightarrow> parent dirs1 p2 s \<longrightarrow> p1 = p2) \<and> (\<forall>(p1 :: int) (p2 :: int). (0 :: int) \<le> p1 \<and> p1 < int (length a) \<longrightarrow> (0 :: int) \<le> p2 \<and> p2 < int (length a) \<longrightarrow> (0 :: int) \<le> p1 \<and> p1 < int (length a) \<longrightarrow> parent dirs1 p1 p2 \<longrightarrow> descendant dirs1 p2 p1 \<longrightarrow> \<not>True)))))"
  sorry
end
