theory verifythis_2019_cartesian_trees_Top_other_descendantqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.exn_Exn"
begin
axiomatization where Trans:   "z \<le> x"
 if "y \<le> x"
 and "z \<le> y"
  for y :: "int"
  and x :: "int"
  and z :: "int"
inductive sorted :: "int list \<Rightarrow> bool" where
   Sorted_Nil: "sorted (Nil :: int list)"
 | Sorted_One: "sorted (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two: "y \<le> x \<Longrightarrow> sorted (Cons y l) \<Longrightarrow> sorted (Cons x (Cons y l))" for y :: "int" and x :: "int" and l :: "int list"
axiomatization where sorted_mem:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> y \<le> x) \<and> sorted l \<longleftrightarrow> sorted (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append:   "sorted l1 \<and> sorted l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> y \<le> x) \<longleftrightarrow> sorted (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
consts destruct :: "'xi list \<Rightarrow> 'xi \<times> 'xi list"
axiomatization where destruct'def:   "case l of Cons h t \<Rightarrow> destruct l = (h, t) | _ \<Rightarrow> False"
 if "\<not>is_Nil l"
  for l :: "'xi list"
consts peek :: "'xi list \<Rightarrow> 'xi"
axiomatization where peek'def:   "case destruct l of (h, _) \<Rightarrow> peek l = h"
 if "\<not>is_Nil l"
  for l :: "'xi list"
axiomatization where peek'spec:   "peek l \<in> set l"
 if "\<not>is_Nil l"
  for l :: "'xi list"
consts tail :: "'xi list \<Rightarrow> 'xi list"
axiomatization where tail'def:   "case destruct l of (_, t) \<Rightarrow> tail l = t"
 if "\<not>is_Nil l"
  for l :: "'xi list"
datatype  dir = dir'mk (left1: "int option") (right1: "int option")
typedecl  dirs
definition parent :: "dir list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "parent t p s \<longleftrightarrow> left1 (t ! nat p) = Some s \<or> right1 (t ! nat p) = Some s" for t p s
inductive descendant :: "dir list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> bool" where
   Self: "p = s \<Longrightarrow> descendant t p s" for p :: "int" and s :: "int" and t :: "dir list"
 | Son_left: "descendant t p s1 \<Longrightarrow> left1 (t ! nat s1) = Some s2 \<Longrightarrow> descendant t p s2" for t :: "dir list" and p :: "int" and s1 :: "int" and s2 :: "int"
 | Son_right: "descendant t p s1 \<Longrightarrow> right1 (t ! nat s1) = Some s2 \<Longrightarrow> descendant t p s2" for t :: "dir list" and p :: "int" and s1 :: "int" and s2 :: "int"
definition is_smallest :: "int list \<Rightarrow> int \<Rightarrow> _"
  where "is_smallest a i \<longleftrightarrow> ((0 :: int) \<le> i \<and> i < int (length a)) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> a ! nat i \<le> a ! nat j)" for a i
theorem other_descendant'vc:
  fixes t :: "dir list"
  fixes p1 :: "int"
  fixes p2 :: "int"
  fixes s :: "int"
  assumes fact0: "parent t p1 p2"
  assumes fact1: "descendant t p2 s"
  shows "descendant t p1 s"
  sorry
end
