theory verifythis_2019_cartesian_trees_Top_traversalqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.exn_Exn"
begin
axiomatization where Trans:   "z \<le> x"
 if "y \<le> x"
 and "z \<le> y"
  for y :: "int"
  and x :: "int"
  and z :: "int"
inductive sorted :: "int list \<Rightarrow> bool" where
   Sorted_Nil: "sorted (Nil :: int list)"
 | Sorted_One: "sorted (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two: "y \<le> x \<Longrightarrow> sorted (Cons y l) \<Longrightarrow> sorted (Cons x (Cons y l))" for y :: "int" and x :: "int" and l :: "int list"
axiomatization where sorted_mem:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> y \<le> x) \<and> sorted l \<longleftrightarrow> sorted (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append:   "sorted l1 \<and> sorted l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> y \<le> x) \<longleftrightarrow> sorted (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
consts destruct :: "'xi list \<Rightarrow> 'xi \<times> 'xi list"
axiomatization where destruct'def:   "case l of Cons h t \<Rightarrow> destruct l = (h, t) | _ \<Rightarrow> False"
 if "\<not>is_Nil l"
  for l :: "'xi list"
consts peek :: "'xi list \<Rightarrow> 'xi"
axiomatization where peek'def:   "case destruct l of (h, _) \<Rightarrow> peek l = h"
 if "\<not>is_Nil l"
  for l :: "'xi list"
axiomatization where peek'spec:   "peek l \<in> set l"
 if "\<not>is_Nil l"
  for l :: "'xi list"
consts tail :: "'xi list \<Rightarrow> 'xi list"
axiomatization where tail'def:   "case destruct l of (_, t) \<Rightarrow> tail l = t"
 if "\<not>is_Nil l"
  for l :: "'xi list"
datatype  dir = dir'mk (left1: "int option") (right1: "int option")
typedecl  dirs
definition parent :: "dir list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "parent t p s \<longleftrightarrow> left1 (t ! nat p) = Some s \<or> right1 (t ! nat p) = Some s" for t p s
inductive descendant :: "dir list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> bool" where
   Self: "p = s \<Longrightarrow> descendant t p s" for p :: "int" and s :: "int" and t :: "dir list"
 | Son_left: "descendant t p s1 \<Longrightarrow> left1 (t ! nat s1) = Some s2 \<Longrightarrow> descendant t p s2" for t :: "dir list" and p :: "int" and s1 :: "int" and s2 :: "int"
 | Son_right: "descendant t p s1 \<Longrightarrow> right1 (t ! nat s1) = Some s2 \<Longrightarrow> descendant t p s2" for t :: "dir list" and p :: "int" and s1 :: "int" and s2 :: "int"
definition is_smallest :: "int list \<Rightarrow> int \<Rightarrow> _"
  where "is_smallest a i \<longleftrightarrow> ((0 :: int) \<le> i \<and> i < int (length a)) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < int (length a) \<longrightarrow> a ! nat i \<le> a ! nat j)" for a i
axiomatization where Trans1:   "x < z"
 if "x < y"
 and "y < z"
  for x :: "int"
  and y :: "int"
  and z :: "int"
inductive sorted1 :: "int list \<Rightarrow> bool" where
   Sorted_Nil1: "sorted1 (Nil :: int list)"
 | Sorted_One1: "sorted1 (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two1: "x < y \<Longrightarrow> sorted1 (Cons y l) \<Longrightarrow> sorted1 (Cons x (Cons y l))" for x :: "int" and y :: "int" and l :: "int list"
axiomatization where sorted_mem1:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> x < y) \<and> sorted1 l \<longleftrightarrow> sorted1 (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append1:   "sorted1 l1 \<and> sorted1 l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> x < y) \<longleftrightarrow> sorted1 (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
theorem traversal'vc:
  fixes dirs1 :: "dir list"
  fixes a :: "int list"
  fixes s :: "int"
  fixes e :: "int"
  fixes top :: "int option"
  assumes fact0: "length dirs1 = length a"
  assumes fact1: "(0 :: int) \<le> s"
  assumes fact2: "s \<le> e"
  assumes fact3: "e \<le> int (length a)"
  assumes fact4: "\<forall>(p1 :: int) (p2 :: int) (s1 :: int). (0 :: int) \<le> p1 \<and> p1 < int (length a) \<longrightarrow> descendant dirs1 p2 s1 \<longrightarrow> (left1 (dirs1 ! nat p1) = Some p2 \<longrightarrow> s1 < p1) \<and> (right1 (dirs1 ! nat p1) = Some p2 \<longrightarrow> p1 < s1)"
  assumes fact5: "\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < int (length a) \<longrightarrow> \<not>a ! nat i = a ! nat j"
  assumes fact6: "case top of Some top1 \<Rightarrow> (\<forall>(son :: int). descendant dirs1 top1 son \<longleftrightarrow> s \<le> son \<and> son < e) | None \<Rightarrow> s = e"
  shows "case top of None \<Rightarrow> True | Some top1 \<Rightarrow> ((0 :: int) \<le> top1 \<and> top1 < int (length dirs1)) \<and> (let dir1 :: dir = dirs1 ! nat top1; o1 :: int = top1 + (1 :: int) in (((0 :: int) \<le> e - s \<and> e - o1 < e - s) \<and> length dirs1 = length a \<and> ((0 :: int) \<le> o1 \<and> o1 \<le> e \<and> e \<le> int (length a)) \<and> (\<forall>(p1 :: int) (p2 :: int) (s1 :: int). (0 :: int) \<le> p1 \<and> p1 < int (length a) \<longrightarrow> descendant dirs1 p2 s1 \<longrightarrow> (left1 (dirs1 ! nat p1) = Some p2 \<longrightarrow> s1 < p1) \<and> (right1 (dirs1 ! nat p1) = Some p2 \<longrightarrow> p1 < s1)) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < int (length a) \<longrightarrow> \<not>a ! nat i = a ! nat j) \<and> (case right1 dir1 of Some top2 \<Rightarrow> (\<forall>(son :: int). descendant dirs1 top2 son \<longleftrightarrow> o1 \<le> son \<and> son < e) | None \<Rightarrow> o1 = e)) \<and> (\<forall>(o2 :: int list). (\<forall>(x :: int). x \<in> set o2 \<longleftrightarrow> o1 \<le> x \<and> x < e) \<and> sorted1 o2 \<longrightarrow> ((0 :: int) \<le> e - s \<and> top1 - s < e - s) \<and> length dirs1 = length a \<and> ((0 :: int) \<le> s \<and> s \<le> top1 \<and> top1 \<le> int (length a)) \<and> (\<forall>(p1 :: int) (p2 :: int) (s1 :: int). (0 :: int) \<le> p1 \<and> p1 < int (length a) \<longrightarrow> descendant dirs1 p2 s1 \<longrightarrow> (left1 (dirs1 ! nat p1) = Some p2 \<longrightarrow> s1 < p1) \<and> (right1 (dirs1 ! nat p1) = Some p2 \<longrightarrow> p1 < s1)) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < int (length a) \<longrightarrow> \<not>a ! nat i = a ! nat j) \<and> (case left1 dir1 of Some top2 \<Rightarrow> (\<forall>(son :: int). descendant dirs1 top2 son \<longleftrightarrow> s \<le> son \<and> son < top1) | None \<Rightarrow> s = top1)))"
  and "\<forall>(result :: int list). (case top of None \<Rightarrow> result = (Nil :: int list) | Some top1 \<Rightarrow> (\<exists>(o1 :: int list). ((\<forall>(x :: int). x \<in> set o1 \<longleftrightarrow> top1 + (1 :: int) \<le> x \<and> x < e) \<and> sorted1 o1) \<and> (\<exists>(o2 :: int list). ((\<forall>(x :: int). x \<in> set o2 \<longleftrightarrow> s \<le> x \<and> x < top1) \<and> sorted1 o2) \<and> result = o2 @ Cons top1 o1))) \<longrightarrow> (\<forall>(x :: int). x \<in> set result \<longleftrightarrow> s \<le> x \<and> x < e) \<and> sorted1 result"
  sorry
end
