import Why3.Base
import Why3.why3.Ref.Ref
import Why3.exn.Exn
open Classical
open Lean4Why3
namespace verifythis_2019_cartesian_trees_Top_construct_dirsqtvc
axiom Trans (y : ℤ) (x : ℤ) (z : ℤ) (fact0 : y ≤ x) (fact1 : z ≤ y) : z ≤ x
inductive sorted : List ℤ -> Prop where
 | Sorted_Nil : sorted ([] : List ℤ)
 | Sorted_One (x : ℤ) : sorted (List.cons x ([] : List ℤ))
 | Sorted_Two (y : ℤ) (x : ℤ) (l : List ℤ) : y ≤ x → sorted (List.cons y l) → sorted (List.cons x (List.cons y l))
axiom sorted_mem (l : List ℤ) (x : ℤ) : ((∀(y : ℤ), y ∈ l → y ≤ x) ∧ sorted l) = sorted (List.cons x l)
axiom sorted_append (l1 : List ℤ) (l2 : List ℤ) : (sorted l1 ∧ sorted l2 ∧ (∀(x : ℤ) (y : ℤ), x ∈ l1 → y ∈ l2 → y ≤ x)) = sorted (l1 ++ l2)
axiom destruct :  {ty'xi : Type} -> [Inhabited ty'xi] -> List ty'xi -> ty'xi × List ty'xi
axiom destruct'def {ty'xi : Type} [Inhabited ty'xi] (l : List ty'xi) (fact0 : ¬is_nil l) : match l with | List.cons h t => destruct l = (h, t) | _ => False
axiom peek :  {ty'xi : Type} -> [Inhabited ty'xi] -> List ty'xi -> ty'xi
axiom peek'def {ty'xi : Type} [Inhabited ty'xi] (l : List ty'xi) (fact0 : ¬is_nil l) : match destruct l with | (h, _) => peek l = h
axiom peek'spec {ty'xi : Type} [Inhabited ty'xi] (l : List ty'xi) (fact0 : ¬is_nil l) : peek l ∈ l
axiom tail :  {ty'xi : Type} -> [Inhabited ty'xi] -> List ty'xi -> List ty'xi
axiom tail'def {ty'xi : Type} [Inhabited ty'xi] (l : List ty'xi) (fact0 : ¬is_nil l) : match destruct l with | (_, t) => tail l = t
structure dir where
  left1 : Option ℤ
  right1 : Option ℤ
axiom inhabited_axiom_dir : Inhabited dir
attribute [instance] inhabited_axiom_dir
axiom dirs : Type
axiom inhabited_axiom_dirs : Inhabited dirs
attribute [instance] inhabited_axiom_dirs
noncomputable def parent (t : List dir) (p : ℤ) (s : ℤ) := dir.left1 (t[Int.toNat p]!) = Option.some s ∨ dir.right1 (t[Int.toNat p]!) = Option.some s
inductive descendant : List dir -> ℤ -> ℤ -> Prop where
 | Self (p : ℤ) (s : ℤ) (t : List dir) : p = s → descendant t p s
 | Son_left (t : List dir) (p : ℤ) (s1 : ℤ) (s2 : ℤ) : descendant t p s1 → dir.left1 (t[Int.toNat s1]!) = Option.some s2 → descendant t p s2
 | Son_right (t : List dir) (p : ℤ) (s1 : ℤ) (s2 : ℤ) : descendant t p s1 → dir.right1 (t[Int.toNat s1]!) = Option.some s2 → descendant t p s2
noncomputable def is_smallest (a : List ℤ) (i : ℤ) := ((0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length a)) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → a[Int.toNat i]! ≤ a[Int.toNat j]!)
theorem construct_dirs'vc (a : List ℤ) (fact0 : ∀(i : ℤ) (j : ℤ), (0 : ℤ) ≤ i ∧ i < j ∧ j < Int.ofNat (List.length a) → ¬a[Int.toNat i]! = a[Int.toNat j]!) : let n : ℤ := Int.ofNat (List.length a); ∀(s_left : List ℤ), (∀(y : ℤ), (0 : ℤ) ≤ y ∧ y < Int.ofNat (List.length a) → s_left[Int.toNat y]! < y) ∧ (∀(y : ℤ), (0 : ℤ) ≤ y ∧ y < Int.ofNat (List.length a) → (0 : ℤ) ≤ s_left[Int.toNat y]! → a[Int.toNat (s_left[Int.toNat y]!)]! < a[Int.toNat y]!) ∧ (∀(x : ℤ) (z : ℤ), (0 : ℤ) ≤ x ∧ x < Int.ofNat (List.length a) → s_left[Int.toNat x]! < z ∧ z < x → a[Int.toNat x]! ≤ a[Int.toNat z]!) ∧ List.length s_left = List.length a → (∀(s_right : List ℤ), (∀(y : ℤ), (0 : ℤ) ≤ y ∧ y < Int.ofNat (List.length a) → y < s_right[Int.toNat y]!) ∧ (∀(y : ℤ), (0 : ℤ) ≤ y ∧ y < Int.ofNat (List.length a) → s_right[Int.toNat y]! < Int.ofNat (List.length a) → a[Int.toNat (s_right[Int.toNat y]!)]! < a[Int.toNat y]!) ∧ (∀(x : ℤ) (z : ℤ), (0 : ℤ) ≤ x ∧ x < Int.ofNat (List.length a) → x < z ∧ z < s_right[Int.toNat x]! → a[Int.toNat x]! ≤ a[Int.toNat z]!) ∧ List.length s_right = List.length a → (0 : ℤ) ≤ n ∧ (∀(dirs1 : List dir), (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < n → dirs1[Int.toNat i]! = dir.mk Option.none Option.none) ∧ Int.ofNat (List.length dirs1) = n → (let o1 : ℤ := n - (1 : ℤ); ((0 : ℤ) ≤ o1 + (1 : ℤ) → ((∀(j : ℤ) (v : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (dir.left1 (dirs1[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ ((0 : ℤ) ≤ v ∧ v < j) ∧ (∀(x : ℤ), v < x ∧ x < j → a[Int.toNat j]! ≤ a[Int.toNat x]!)) ∧ (dir.right1 (dirs1[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ (j < v ∧ v < Int.ofNat (List.length a)) ∧ (∀(x : ℤ), j < x ∧ x < v → a[Int.toNat j]! ≤ a[Int.toNat x]!))) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < (0 : ℤ) → (if (0 : ℤ) ≤ s_left[Int.toNat j]! ∧ n ≤ s_right[Int.toNat j]! then dir.right1 (dirs1[Int.toNat (s_left[Int.toNat j]!)]!) = Option.some j else if s_left[Int.toNat j]! < (0 : ℤ) ∧ s_right[Int.toNat j]! < n then dir.left1 (dirs1[Int.toNat (s_right[Int.toNat j]!)]!) = Option.some j else (0 : ℤ) ≤ s_left[Int.toNat j]! ∧ s_right[Int.toNat j]! < n → (if a[Int.toNat (s_right[Int.toNat j]!)]! < a[Int.toNat (s_left[Int.toNat j]!)]! then dir.right1 (dirs1[Int.toNat (s_left[Int.toNat j]!)]!) = Option.some j else dir.left1 (dirs1[Int.toNat (s_right[Int.toNat j]!)]!) = Option.some j))) ∧ (∀(j : ℤ) (p : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (0 : ℤ) ≤ p ∧ p < Int.ofNat (List.length a) → (dir.right1 (dirs1[Int.toNat p]!) = Option.some j → p = s_left[Int.toNat j]! ∧ (s_right[Int.toNat j]! < n → a[Int.toNat (s_right[Int.toNat j]!)]! < a[Int.toNat (s_left[Int.toNat j]!)]!)) ∧ (dir.left1 (dirs1[Int.toNat p]!) = Option.some j → p = s_right[Int.toNat j]! ∧ ((0 : ℤ) ≤ s_left[Int.toNat j]! → a[Int.toNat (s_left[Int.toNat j]!)]! ≤ a[Int.toNat (s_right[Int.toNat j]!)]!)))) ∧ (∀(dirs2 : List dir), List.length dirs2 = List.length dirs1 → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i ≤ o1) ∧ (∀(j : ℤ) (v : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (dir.left1 (dirs2[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ ((0 : ℤ) ≤ v ∧ v < j) ∧ (∀(x : ℤ), v < x ∧ x < j → a[Int.toNat j]! ≤ a[Int.toNat x]!)) ∧ (dir.right1 (dirs2[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ (j < v ∧ v < Int.ofNat (List.length a)) ∧ (∀(x : ℤ), j < x ∧ x < v → a[Int.toNat j]! ≤ a[Int.toNat x]!))) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < i → (if (0 : ℤ) ≤ s_left[Int.toNat j]! ∧ n ≤ s_right[Int.toNat j]! then dir.right1 (dirs2[Int.toNat (s_left[Int.toNat j]!)]!) = Option.some j else if s_left[Int.toNat j]! < (0 : ℤ) ∧ s_right[Int.toNat j]! < n then dir.left1 (dirs2[Int.toNat (s_right[Int.toNat j]!)]!) = Option.some j else (0 : ℤ) ≤ s_left[Int.toNat j]! ∧ s_right[Int.toNat j]! < n → (if a[Int.toNat (s_right[Int.toNat j]!)]! < a[Int.toNat (s_left[Int.toNat j]!)]! then dir.right1 (dirs2[Int.toNat (s_left[Int.toNat j]!)]!) = Option.some j else dir.left1 (dirs2[Int.toNat (s_right[Int.toNat j]!)]!) = Option.some j))) ∧ (∀(j : ℤ) (p : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (0 : ℤ) ≤ p ∧ p < Int.ofNat (List.length a) → (dir.right1 (dirs2[Int.toNat p]!) = Option.some j → p = s_left[Int.toNat j]! ∧ (s_right[Int.toNat j]! < n → a[Int.toNat (s_right[Int.toNat j]!)]! < a[Int.toNat (s_left[Int.toNat j]!)]!)) ∧ (dir.left1 (dirs2[Int.toNat p]!) = Option.some j → p = s_right[Int.toNat j]! ∧ ((0 : ℤ) ≤ s_left[Int.toNat j]! → a[Int.toNat (s_left[Int.toNat j]!)]! ≤ a[Int.toNat (s_right[Int.toNat j]!)]!))) → ((0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length s_left)) ∧ (let li : ℤ := s_left[Int.toNat i]!; ((0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length s_right)) ∧ (let ri : ℤ := s_right[Int.toNat i]!; if (0 : ℤ) ≤ li then if ri < n then ((0 : ℤ) ≤ ri ∧ ri < Int.ofNat (List.length a)) ∧ ((0 : ℤ) ≤ li ∧ li < Int.ofNat (List.length a)) ∧ (if a[Int.toNat ri]! < a[Int.toNat li]! then ((0 : ℤ) ≤ li ∧ li < Int.ofNat (List.length dirs2)) ∧ (let o2 : dir := dir.mk (dir.left1 (dirs2[Int.toNat li]!)) (Option.some i); ((0 : ℤ) ≤ li ∧ li < Int.ofNat (List.length dirs2)) ∧ (List.length (List.set dirs2 (Int.toNat li) o2) = List.length dirs2 → getElem! (List.set dirs2 (Int.toNat li) o2) ∘ Int.toNat = Function.update (getElem! dirs2 ∘ Int.toNat) li o2 → (∀(j : ℤ) (v : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (dir.left1 ((List.set dirs2 (Int.toNat li) o2)[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ ((0 : ℤ) ≤ v ∧ v < j) ∧ (∀(x : ℤ), v < x ∧ x < j → a[Int.toNat j]! ≤ a[Int.toNat x]!)) ∧ (dir.right1 ((List.set dirs2 (Int.toNat li) o2)[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ (j < v ∧ v < Int.ofNat (List.length a)) ∧ (∀(x : ℤ), j < x ∧ x < v → a[Int.toNat j]! ≤ a[Int.toNat x]!))) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < i + (1 : ℤ) → (if (0 : ℤ) ≤ s_left[Int.toNat j]! ∧ n ≤ s_right[Int.toNat j]! then dir.right1 ((List.set dirs2 (Int.toNat li) o2)[Int.toNat (s_left[Int.toNat j]!)]!) = Option.some j else if s_left[Int.toNat j]! < (0 : ℤ) ∧ s_right[Int.toNat j]! < n then dir.left1 ((List.set dirs2 (Int.toNat li) o2)[Int.toNat (s_right[Int.toNat j]!)]!) = Option.some j else (0 : ℤ) ≤ s_left[Int.toNat j]! ∧ s_right[Int.toNat j]! < n → (if a[Int.toNat (s_right[Int.toNat j]!)]! < a[Int.toNat (s_left[Int.toNat j]!)]! then dir.right1 ((List.set dirs2 (Int.toNat li) o2)[Int.toNat (s_left[Int.toNat j]!)]!) = Option.some j else dir.left1 ((List.set dirs2 (Int.toNat li) o2)[Int.toNat (s_right[Int.toNat j]!)]!) = Option.some j))) ∧ (∀(j : ℤ) (p : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (0 : ℤ) ≤ p ∧ p < Int.ofNat (List.length a) → (dir.right1 ((List.set dirs2 (Int.toNat li) o2)[Int.toNat p]!) = Option.some j → p = s_left[Int.toNat j]! ∧ (s_right[Int.toNat j]! < n → a[Int.toNat (s_right[Int.toNat j]!)]! < a[Int.toNat (s_left[Int.toNat j]!)]!)) ∧ (dir.left1 ((List.set dirs2 (Int.toNat li) o2)[Int.toNat p]!) = Option.some j → p = s_right[Int.toNat j]! ∧ ((0 : ℤ) ≤ s_left[Int.toNat j]! → a[Int.toNat (s_left[Int.toNat j]!)]! ≤ a[Int.toNat (s_right[Int.toNat j]!)]!))))) else ((0 : ℤ) ≤ ri ∧ ri < Int.ofNat (List.length dirs2)) ∧ (let o2 : dir := dir.mk (Option.some i) (dir.right1 (dirs2[Int.toNat ri]!)); ((0 : ℤ) ≤ ri ∧ ri < Int.ofNat (List.length dirs2)) ∧ (List.length (List.set dirs2 (Int.toNat ri) o2) = List.length dirs2 → getElem! (List.set dirs2 (Int.toNat ri) o2) ∘ Int.toNat = Function.update (getElem! dirs2 ∘ Int.toNat) ri o2 → (∀(j : ℤ) (v : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (dir.left1 ((List.set dirs2 (Int.toNat ri) o2)[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ ((0 : ℤ) ≤ v ∧ v < j) ∧ (∀(x : ℤ), v < x ∧ x < j → a[Int.toNat j]! ≤ a[Int.toNat x]!)) ∧ (dir.right1 ((List.set dirs2 (Int.toNat ri) o2)[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ (j < v ∧ v < Int.ofNat (List.length a)) ∧ (∀(x : ℤ), j < x ∧ x < v → a[Int.toNat j]! ≤ a[Int.toNat x]!))) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < i + (1 : ℤ) → (if (0 : ℤ) ≤ s_left[Int.toNat j]! ∧ n ≤ s_right[Int.toNat j]! then dir.right1 ((List.set dirs2 (Int.toNat ri) o2)[Int.toNat (s_left[Int.toNat j]!)]!) = Option.some j else if s_left[Int.toNat j]! < (0 : ℤ) ∧ s_right[Int.toNat j]! < n then dir.left1 ((List.set dirs2 (Int.toNat ri) o2)[Int.toNat (s_right[Int.toNat j]!)]!) = Option.some j else (0 : ℤ) ≤ s_left[Int.toNat j]! ∧ s_right[Int.toNat j]! < n → (if a[Int.toNat (s_right[Int.toNat j]!)]! < a[Int.toNat (s_left[Int.toNat j]!)]! then dir.right1 ((List.set dirs2 (Int.toNat ri) o2)[Int.toNat (s_left[Int.toNat j]!)]!) = Option.some j else dir.left1 ((List.set dirs2 (Int.toNat ri) o2)[Int.toNat (s_right[Int.toNat j]!)]!) = Option.some j))) ∧ (∀(j : ℤ) (p : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (0 : ℤ) ≤ p ∧ p < Int.ofNat (List.length a) → (dir.right1 ((List.set dirs2 (Int.toNat ri) o2)[Int.toNat p]!) = Option.some j → p = s_left[Int.toNat j]! ∧ (s_right[Int.toNat j]! < n → a[Int.toNat (s_right[Int.toNat j]!)]! < a[Int.toNat (s_left[Int.toNat j]!)]!)) ∧ (dir.left1 ((List.set dirs2 (Int.toNat ri) o2)[Int.toNat p]!) = Option.some j → p = s_right[Int.toNat j]! ∧ ((0 : ℤ) ≤ s_left[Int.toNat j]! → a[Int.toNat (s_left[Int.toNat j]!)]! ≤ a[Int.toNat (s_right[Int.toNat j]!)]!)))))) else ((0 : ℤ) ≤ li ∧ li < Int.ofNat (List.length dirs2)) ∧ (let o2 : dir := dir.mk (dir.left1 (dirs2[Int.toNat li]!)) (Option.some i); ((0 : ℤ) ≤ li ∧ li < Int.ofNat (List.length dirs2)) ∧ (List.length (List.set dirs2 (Int.toNat li) o2) = List.length dirs2 → getElem! (List.set dirs2 (Int.toNat li) o2) ∘ Int.toNat = Function.update (getElem! dirs2 ∘ Int.toNat) li o2 → (∀(j : ℤ) (v : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (dir.left1 ((List.set dirs2 (Int.toNat li) o2)[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ ((0 : ℤ) ≤ v ∧ v < j) ∧ (∀(x : ℤ), v < x ∧ x < j → a[Int.toNat j]! ≤ a[Int.toNat x]!)) ∧ (dir.right1 ((List.set dirs2 (Int.toNat li) o2)[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ (j < v ∧ v < Int.ofNat (List.length a)) ∧ (∀(x : ℤ), j < x ∧ x < v → a[Int.toNat j]! ≤ a[Int.toNat x]!))) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < i + (1 : ℤ) → (if (0 : ℤ) ≤ s_left[Int.toNat j]! ∧ n ≤ s_right[Int.toNat j]! then dir.right1 ((List.set dirs2 (Int.toNat li) o2)[Int.toNat (s_left[Int.toNat j]!)]!) = Option.some j else if s_left[Int.toNat j]! < (0 : ℤ) ∧ s_right[Int.toNat j]! < n then dir.left1 ((List.set dirs2 (Int.toNat li) o2)[Int.toNat (s_right[Int.toNat j]!)]!) = Option.some j else (0 : ℤ) ≤ s_left[Int.toNat j]! ∧ s_right[Int.toNat j]! < n → (if a[Int.toNat (s_right[Int.toNat j]!)]! < a[Int.toNat (s_left[Int.toNat j]!)]! then dir.right1 ((List.set dirs2 (Int.toNat li) o2)[Int.toNat (s_left[Int.toNat j]!)]!) = Option.some j else dir.left1 ((List.set dirs2 (Int.toNat li) o2)[Int.toNat (s_right[Int.toNat j]!)]!) = Option.some j))) ∧ (∀(j : ℤ) (p : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (0 : ℤ) ≤ p ∧ p < Int.ofNat (List.length a) → (dir.right1 ((List.set dirs2 (Int.toNat li) o2)[Int.toNat p]!) = Option.some j → p = s_left[Int.toNat j]! ∧ (s_right[Int.toNat j]! < n → a[Int.toNat (s_right[Int.toNat j]!)]! < a[Int.toNat (s_left[Int.toNat j]!)]!)) ∧ (dir.left1 ((List.set dirs2 (Int.toNat li) o2)[Int.toNat p]!) = Option.some j → p = s_right[Int.toNat j]! ∧ ((0 : ℤ) ≤ s_left[Int.toNat j]! → a[Int.toNat (s_left[Int.toNat j]!)]! ≤ a[Int.toNat (s_right[Int.toNat j]!)]!))))) else if ri < n then ((0 : ℤ) ≤ ri ∧ ri < Int.ofNat (List.length dirs2)) ∧ (let o2 : dir := dir.mk (Option.some i) (dir.right1 (dirs2[Int.toNat ri]!)); ((0 : ℤ) ≤ ri ∧ ri < Int.ofNat (List.length dirs2)) ∧ (List.length (List.set dirs2 (Int.toNat ri) o2) = List.length dirs2 → getElem! (List.set dirs2 (Int.toNat ri) o2) ∘ Int.toNat = Function.update (getElem! dirs2 ∘ Int.toNat) ri o2 → (∀(j : ℤ) (v : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (dir.left1 ((List.set dirs2 (Int.toNat ri) o2)[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ ((0 : ℤ) ≤ v ∧ v < j) ∧ (∀(x : ℤ), v < x ∧ x < j → a[Int.toNat j]! ≤ a[Int.toNat x]!)) ∧ (dir.right1 ((List.set dirs2 (Int.toNat ri) o2)[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ (j < v ∧ v < Int.ofNat (List.length a)) ∧ (∀(x : ℤ), j < x ∧ x < v → a[Int.toNat j]! ≤ a[Int.toNat x]!))) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < i + (1 : ℤ) → (if (0 : ℤ) ≤ s_left[Int.toNat j]! ∧ n ≤ s_right[Int.toNat j]! then dir.right1 ((List.set dirs2 (Int.toNat ri) o2)[Int.toNat (s_left[Int.toNat j]!)]!) = Option.some j else if s_left[Int.toNat j]! < (0 : ℤ) ∧ s_right[Int.toNat j]! < n then dir.left1 ((List.set dirs2 (Int.toNat ri) o2)[Int.toNat (s_right[Int.toNat j]!)]!) = Option.some j else (0 : ℤ) ≤ s_left[Int.toNat j]! ∧ s_right[Int.toNat j]! < n → (if a[Int.toNat (s_right[Int.toNat j]!)]! < a[Int.toNat (s_left[Int.toNat j]!)]! then dir.right1 ((List.set dirs2 (Int.toNat ri) o2)[Int.toNat (s_left[Int.toNat j]!)]!) = Option.some j else dir.left1 ((List.set dirs2 (Int.toNat ri) o2)[Int.toNat (s_right[Int.toNat j]!)]!) = Option.some j))) ∧ (∀(j : ℤ) (p : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (0 : ℤ) ≤ p ∧ p < Int.ofNat (List.length a) → (dir.right1 ((List.set dirs2 (Int.toNat ri) o2)[Int.toNat p]!) = Option.some j → p = s_left[Int.toNat j]! ∧ (s_right[Int.toNat j]! < n → a[Int.toNat (s_right[Int.toNat j]!)]! < a[Int.toNat (s_left[Int.toNat j]!)]!)) ∧ (dir.left1 ((List.set dirs2 (Int.toNat ri) o2)[Int.toNat p]!) = Option.some j → p = s_right[Int.toNat j]! ∧ ((0 : ℤ) ≤ s_left[Int.toNat j]! → a[Int.toNat (s_left[Int.toNat j]!)]! ≤ a[Int.toNat (s_right[Int.toNat j]!)]!))))) else (∀(j : ℤ) (v : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (dir.left1 (dirs2[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ ((0 : ℤ) ≤ v ∧ v < j) ∧ (∀(x : ℤ), v < x ∧ x < j → a[Int.toNat j]! ≤ a[Int.toNat x]!)) ∧ (dir.right1 (dirs2[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ (j < v ∧ v < Int.ofNat (List.length a)) ∧ (∀(x : ℤ), j < x ∧ x < v → a[Int.toNat j]! ≤ a[Int.toNat x]!))) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < i + (1 : ℤ) → (if (0 : ℤ) ≤ s_left[Int.toNat j]! ∧ n ≤ s_right[Int.toNat j]! then dir.right1 (dirs2[Int.toNat (s_left[Int.toNat j]!)]!) = Option.some j else if s_left[Int.toNat j]! < (0 : ℤ) ∧ s_right[Int.toNat j]! < n then dir.left1 (dirs2[Int.toNat (s_right[Int.toNat j]!)]!) = Option.some j else (0 : ℤ) ≤ s_left[Int.toNat j]! ∧ s_right[Int.toNat j]! < n → (if a[Int.toNat (s_right[Int.toNat j]!)]! < a[Int.toNat (s_left[Int.toNat j]!)]! then dir.right1 (dirs2[Int.toNat (s_left[Int.toNat j]!)]!) = Option.some j else dir.left1 (dirs2[Int.toNat (s_right[Int.toNat j]!)]!) = Option.some j))) ∧ (∀(j : ℤ) (p : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (0 : ℤ) ≤ p ∧ p < Int.ofNat (List.length a) → (dir.right1 (dirs2[Int.toNat p]!) = Option.some j → p = s_left[Int.toNat j]! ∧ (s_right[Int.toNat j]! < n → a[Int.toNat (s_right[Int.toNat j]!)]! < a[Int.toNat (s_left[Int.toNat j]!)]!)) ∧ (dir.left1 (dirs2[Int.toNat p]!) = Option.some j → p = s_right[Int.toNat j]! ∧ ((0 : ℤ) ≤ s_left[Int.toNat j]! → a[Int.toNat (s_left[Int.toNat j]!)]! ≤ a[Int.toNat (s_right[Int.toNat j]!)]!)))))) ∧ ((∀(j : ℤ) (v : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (dir.left1 (dirs2[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ ((0 : ℤ) ≤ v ∧ v < j) ∧ (∀(x : ℤ), v < x ∧ x < j → a[Int.toNat j]! ≤ a[Int.toNat x]!)) ∧ (dir.right1 (dirs2[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ (j < v ∧ v < Int.ofNat (List.length a)) ∧ (∀(x : ℤ), j < x ∧ x < v → a[Int.toNat j]! ≤ a[Int.toNat x]!))) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < o1 + (1 : ℤ) → (if (0 : ℤ) ≤ s_left[Int.toNat j]! ∧ n ≤ s_right[Int.toNat j]! then dir.right1 (dirs2[Int.toNat (s_left[Int.toNat j]!)]!) = Option.some j else if s_left[Int.toNat j]! < (0 : ℤ) ∧ s_right[Int.toNat j]! < n then dir.left1 (dirs2[Int.toNat (s_right[Int.toNat j]!)]!) = Option.some j else (0 : ℤ) ≤ s_left[Int.toNat j]! ∧ s_right[Int.toNat j]! < n → (if a[Int.toNat (s_right[Int.toNat j]!)]! < a[Int.toNat (s_left[Int.toNat j]!)]! then dir.right1 (dirs2[Int.toNat (s_left[Int.toNat j]!)]!) = Option.some j else dir.left1 (dirs2[Int.toNat (s_right[Int.toNat j]!)]!) = Option.some j))) ∧ (∀(j : ℤ) (p : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (0 : ℤ) ≤ p ∧ p < Int.ofNat (List.length a) → (dir.right1 (dirs2[Int.toNat p]!) = Option.some j → p = s_left[Int.toNat j]! ∧ (s_right[Int.toNat j]! < n → a[Int.toNat (s_right[Int.toNat j]!)]! < a[Int.toNat (s_left[Int.toNat j]!)]!)) ∧ (dir.left1 (dirs2[Int.toNat p]!) = Option.some j → p = s_right[Int.toNat j]! ∧ ((0 : ℤ) ≤ s_left[Int.toNat j]! → a[Int.toNat (s_left[Int.toNat j]!)]! ≤ a[Int.toNat (s_right[Int.toNat j]!)]!))) → List.length dirs2 = List.length a ∧ (∀(j : ℤ) (v : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (dir.left1 (dirs2[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ ((0 : ℤ) ≤ v ∧ v < j) ∧ (∀(x : ℤ), v < x ∧ x < j → a[Int.toNat j]! < a[Int.toNat x]!)) ∧ (dir.right1 (dirs2[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ (j < v ∧ v < Int.ofNat (List.length a)) ∧ (∀(x : ℤ), j < x ∧ x < v → a[Int.toNat j]! < a[Int.toNat x]!))) ∧ (∀(p : ℤ) (s : ℤ), (0 : ℤ) ≤ p ∧ p < Int.ofNat (List.length a) → descendant dirs2 p s → ((0 : ℤ) ≤ s ∧ s < Int.ofNat (List.length a)) ∧ a[Int.toNat p]! ≤ a[Int.toNat s]!) ∧ (∀(p1 : ℤ) (p2 : ℤ) (s : ℤ), (0 : ℤ) ≤ p1 ∧ p1 < Int.ofNat (List.length a) → descendant dirs2 p2 s → (dir.left1 (dirs2[Int.toNat p1]!) = Option.some p2 → s < p1) ∧ (dir.right1 (dirs2[Int.toNat p1]!) = Option.some p2 → p1 < s)) ∧ (∀(i : ℤ) (k : ℤ), (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length a) → (0 : ℤ) ≤ k ∧ k < Int.ofNat (List.length a) → a[Int.toNat k]! < a[Int.toNat i]! → (∃(sm : ℤ), ((0 : ℤ) ≤ sm ∧ sm < Int.ofNat (List.length a)) ∧ parent dirs2 sm i)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length a) → is_smallest a i ∨ (∃(sm : ℤ), ((0 : ℤ) ≤ sm ∧ sm < Int.ofNat (List.length a)) ∧ parent dirs2 sm i)) ∧ (∀(p1 : ℤ) (p2 : ℤ) (s : ℤ), (0 : ℤ) ≤ p1 ∧ p1 < Int.ofNat (List.length a) → (0 : ℤ) ≤ p2 ∧ p2 < Int.ofNat (List.length a) → (0 : ℤ) ≤ s ∧ s < Int.ofNat (List.length a) → parent dirs2 p1 s → parent dirs2 p2 s → p1 = p2) ∧ (∀(p1 : ℤ) (p2 : ℤ), (0 : ℤ) ≤ p1 ∧ p1 < Int.ofNat (List.length a) → (0 : ℤ) ≤ p2 ∧ p2 < Int.ofNat (List.length a) → (0 : ℤ) ≤ p1 ∧ p1 < Int.ofNat (List.length a) → parent dirs2 p1 p2 → descendant dirs2 p2 p1 → ¬True)))) ∧ (o1 + (1 : ℤ) < (0 : ℤ) → List.length dirs1 = List.length a ∧ (∀(j : ℤ) (v : ℤ), (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a) → (dir.left1 (dirs1[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ ((0 : ℤ) ≤ v ∧ v < j) ∧ (∀(x : ℤ), v < x ∧ x < j → a[Int.toNat j]! < a[Int.toNat x]!)) ∧ (dir.right1 (dirs1[Int.toNat j]!) = Option.some v → a[Int.toNat j]! < a[Int.toNat v]! ∧ (j < v ∧ v < Int.ofNat (List.length a)) ∧ (∀(x : ℤ), j < x ∧ x < v → a[Int.toNat j]! < a[Int.toNat x]!))) ∧ (∀(p : ℤ) (s : ℤ), (0 : ℤ) ≤ p ∧ p < Int.ofNat (List.length a) → descendant dirs1 p s → ((0 : ℤ) ≤ s ∧ s < Int.ofNat (List.length a)) ∧ a[Int.toNat p]! ≤ a[Int.toNat s]!) ∧ (∀(p1 : ℤ) (p2 : ℤ) (s : ℤ), (0 : ℤ) ≤ p1 ∧ p1 < Int.ofNat (List.length a) → descendant dirs1 p2 s → (dir.left1 (dirs1[Int.toNat p1]!) = Option.some p2 → s < p1) ∧ (dir.right1 (dirs1[Int.toNat p1]!) = Option.some p2 → p1 < s)) ∧ (∀(i : ℤ) (k : ℤ), (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length a) → (0 : ℤ) ≤ k ∧ k < Int.ofNat (List.length a) → a[Int.toNat k]! < a[Int.toNat i]! → (∃(sm : ℤ), ((0 : ℤ) ≤ sm ∧ sm < Int.ofNat (List.length a)) ∧ parent dirs1 sm i)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length a) → is_smallest a i ∨ (∃(sm : ℤ), ((0 : ℤ) ≤ sm ∧ sm < Int.ofNat (List.length a)) ∧ parent dirs1 sm i)) ∧ (∀(p1 : ℤ) (p2 : ℤ) (s : ℤ), (0 : ℤ) ≤ p1 ∧ p1 < Int.ofNat (List.length a) → (0 : ℤ) ≤ p2 ∧ p2 < Int.ofNat (List.length a) → (0 : ℤ) ≤ s ∧ s < Int.ofNat (List.length a) → parent dirs1 p1 s → parent dirs1 p2 s → p1 = p2) ∧ (∀(p1 : ℤ) (p2 : ℤ), (0 : ℤ) ≤ p1 ∧ p1 < Int.ofNat (List.length a) → (0 : ℤ) ≤ p2 ∧ p2 < Int.ofNat (List.length a) → (0 : ℤ) ≤ p1 ∧ p1 < Int.ofNat (List.length a) → parent dirs1 p1 p2 → descendant dirs1 p2 p1 → ¬True)))))
  := sorry
end verifythis_2019_cartesian_trees_Top_construct_dirsqtvc
