From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.why3.Ref.Ref.
Require Import Why3.exn.Exn.
Open Scope Z_scope.
Axiom Trans : forall  (y : Z) (x : Z) (z : Z) (fact0 : y ≤ x) (fact1 : z ≤ y), z ≤ x.
Inductive sorted : list Z -> Prop :=
 | Sorted_Nil : sorted ([] : list Z)
 | Sorted_One (x : Z) : sorted (cons x ([] : list Z))
 | Sorted_Two (y : Z) (x : Z) (l : list Z) : y ≤ x -> sorted (cons y l) -> sorted (cons x (cons y l)).
Axiom sorted_mem : forall  (l : list Z) (x : Z), ((∀(y : Z), y ∈ l -> y ≤ x) ∧ sorted l) = sorted (cons x l).
Axiom sorted_append : forall  (l1 : list Z) (l2 : list Z), (sorted l1 ∧ sorted l2 ∧ (∀(x : Z) (y : Z), x ∈ l1 -> y ∈ l2 -> y ≤ x)) = sorted (l1 ++ l2).
Axiom destruct : forall {ty'xi : Type} `{Inhabited ty'xi}, list ty'xi -> ty'xi * list ty'xi.
Axiom destruct'def : forall  {ty'xi : Type} `{Inhabited ty'xi} (l : list ty'xi) (fact0 : ¬ is_Nil l), match l with | cons h t => destruct l = (h, t) | _ => False end.
Axiom peek : forall {ty'xi : Type} `{Inhabited ty'xi}, list ty'xi -> ty'xi.
Axiom peek'def : forall  {ty'xi : Type} `{Inhabited ty'xi} (l : list ty'xi) (fact0 : ¬ is_Nil l), match destruct l with | (h, _) => peek l = h end.
Axiom peek'spec : forall  {ty'xi : Type} `{Inhabited ty'xi} (l : list ty'xi) (fact0 : ¬ is_Nil l), peek l ∈ l.
Axiom tail : forall {ty'xi : Type} `{Inhabited ty'xi}, list ty'xi -> list ty'xi.
Axiom tail'def : forall  {ty'xi : Type} `{Inhabited ty'xi} (l : list ty'xi) (fact0 : ¬ is_Nil l), match destruct l with | (_, t) => tail l = t end.
Inductive dir :=
  | dir'mk : option Z -> option Z -> dir.
Axiom dir_inhabited : Inhabited dir.
Global Existing Instance dir_inhabited.
Axiom dir_countable : Countable dir.
Global Existing Instance dir_countable.
Definition left1 (x : dir) := match x with |  dir'mk a _ => a end.
Definition right1 (x : dir) := match x with |  dir'mk _ a => a end.
Axiom dirs : Type.
Axiom dirs_inhabited : Inhabited dirs.
Global Existing Instance dirs_inhabited.
Axiom dirs_countable : Countable dirs.
Global Existing Instance dirs_countable.
Definition parent (t : list dir) (p : Z) (s : Z) := left1 (nth (Z.to_nat p) t inhabitant) = Some s ∨ right1 (nth (Z.to_nat p) t inhabitant) = Some s.
Inductive descendant : list dir -> Z -> Z -> Prop :=
 | Self (p : Z) (s : Z) (t : list dir) : p = s -> descendant t p s
 | Son_left (t : list dir) (p : Z) (s1 : Z) (s2 : Z) : descendant t p s1 -> left1 (nth (Z.to_nat s1) t inhabitant) = Some s2 -> descendant t p s2
 | Son_right (t : list dir) (p : Z) (s1 : Z) (s2 : Z) : descendant t p s1 -> right1 (nth (Z.to_nat s1) t inhabitant) = Some s2 -> descendant t p s2.
Definition is_smallest (a : list Z) (i : Z) := (0%Z ≤ i ∧ i < Z.of_nat (length a)) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> nth (Z.to_nat i) a inhabitant ≤ nth (Z.to_nat j) a inhabitant).
Theorem construct_dirs'vc (a : list Z) (fact0 : ∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < Z.of_nat (length a) -> ¬ nth (Z.to_nat i) a inhabitant = nth (Z.to_nat j) a inhabitant) : let n : Z := Z.of_nat (length a) in ∀(s_left : list Z), (∀(y : Z), 0%Z ≤ y ∧ y < Z.of_nat (length a) -> nth (Z.to_nat y) s_left inhabitant < y) ∧ (∀(y : Z), 0%Z ≤ y ∧ y < Z.of_nat (length a) -> 0%Z ≤ nth (Z.to_nat y) s_left inhabitant -> nth (Z.to_nat (nth (Z.to_nat y) s_left inhabitant)) a inhabitant < nth (Z.to_nat y) a inhabitant) ∧ (∀(x : Z) (z : Z), 0%Z ≤ x ∧ x < Z.of_nat (length a) -> nth (Z.to_nat x) s_left inhabitant < z ∧ z < x -> nth (Z.to_nat x) a inhabitant ≤ nth (Z.to_nat z) a inhabitant) ∧ length s_left = length a -> (∀(s_right : list Z), (∀(y : Z), 0%Z ≤ y ∧ y < Z.of_nat (length a) -> y < nth (Z.to_nat y) s_right inhabitant) ∧ (∀(y : Z), 0%Z ≤ y ∧ y < Z.of_nat (length a) -> nth (Z.to_nat y) s_right inhabitant < Z.of_nat (length a) -> nth (Z.to_nat (nth (Z.to_nat y) s_right inhabitant)) a inhabitant < nth (Z.to_nat y) a inhabitant) ∧ (∀(x : Z) (z : Z), 0%Z ≤ x ∧ x < Z.of_nat (length a) -> x < z ∧ z < nth (Z.to_nat x) s_right inhabitant -> nth (Z.to_nat x) a inhabitant ≤ nth (Z.to_nat z) a inhabitant) ∧ length s_right = length a -> 0%Z ≤ n ∧ (∀(dirs1 : list dir), (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat i) dirs1 inhabitant = dir'mk None None) ∧ Z.of_nat (length dirs1) = n -> (let o1 : Z := n - 1%Z in (0%Z ≤ o1 + 1%Z -> ((∀(j : Z) (v : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> (left1 (nth (Z.to_nat j) dirs1 inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (0%Z ≤ v ∧ v < j) ∧ (∀(x : Z), v < x ∧ x < j -> nth (Z.to_nat j) a inhabitant ≤ nth (Z.to_nat x) a inhabitant)) ∧ (right1 (nth (Z.to_nat j) dirs1 inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (j < v ∧ v < Z.of_nat (length a)) ∧ (∀(x : Z), j < x ∧ x < v -> nth (Z.to_nat j) a inhabitant ≤ nth (Z.to_nat x) a inhabitant))) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < 0%Z -> (if decide (0%Z ≤ nth (Z.to_nat j) s_left inhabitant ∧ n ≤ nth (Z.to_nat j) s_right inhabitant) then right1 (nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) dirs1 inhabitant) = Some j else if decide (nth (Z.to_nat j) s_left inhabitant < 0%Z ∧ nth (Z.to_nat j) s_right inhabitant < n) then left1 (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) dirs1 inhabitant) = Some j else 0%Z ≤ nth (Z.to_nat j) s_left inhabitant ∧ nth (Z.to_nat j) s_right inhabitant < n -> (if decide (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant < nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant) then right1 (nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) dirs1 inhabitant) = Some j else left1 (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) dirs1 inhabitant) = Some j))) ∧ (∀(j : Z) (p : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> 0%Z ≤ p ∧ p < Z.of_nat (length a) -> (right1 (nth (Z.to_nat p) dirs1 inhabitant) = Some j -> p = nth (Z.to_nat j) s_left inhabitant ∧ (nth (Z.to_nat j) s_right inhabitant < n -> nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant < nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant)) ∧ (left1 (nth (Z.to_nat p) dirs1 inhabitant) = Some j -> p = nth (Z.to_nat j) s_right inhabitant ∧ (0%Z ≤ nth (Z.to_nat j) s_left inhabitant -> nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant ≤ nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant)))) ∧ (∀(dirs2 : list dir), length dirs2 = length dirs1 -> (∀(i : Z), (0%Z ≤ i ∧ i ≤ o1) ∧ (∀(j : Z) (v : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> (left1 (nth (Z.to_nat j) dirs2 inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (0%Z ≤ v ∧ v < j) ∧ (∀(x : Z), v < x ∧ x < j -> nth (Z.to_nat j) a inhabitant ≤ nth (Z.to_nat x) a inhabitant)) ∧ (right1 (nth (Z.to_nat j) dirs2 inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (j < v ∧ v < Z.of_nat (length a)) ∧ (∀(x : Z), j < x ∧ x < v -> nth (Z.to_nat j) a inhabitant ≤ nth (Z.to_nat x) a inhabitant))) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < i -> (if decide (0%Z ≤ nth (Z.to_nat j) s_left inhabitant ∧ n ≤ nth (Z.to_nat j) s_right inhabitant) then right1 (nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) dirs2 inhabitant) = Some j else if decide (nth (Z.to_nat j) s_left inhabitant < 0%Z ∧ nth (Z.to_nat j) s_right inhabitant < n) then left1 (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) dirs2 inhabitant) = Some j else 0%Z ≤ nth (Z.to_nat j) s_left inhabitant ∧ nth (Z.to_nat j) s_right inhabitant < n -> (if decide (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant < nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant) then right1 (nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) dirs2 inhabitant) = Some j else left1 (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) dirs2 inhabitant) = Some j))) ∧ (∀(j : Z) (p : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> 0%Z ≤ p ∧ p < Z.of_nat (length a) -> (right1 (nth (Z.to_nat p) dirs2 inhabitant) = Some j -> p = nth (Z.to_nat j) s_left inhabitant ∧ (nth (Z.to_nat j) s_right inhabitant < n -> nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant < nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant)) ∧ (left1 (nth (Z.to_nat p) dirs2 inhabitant) = Some j -> p = nth (Z.to_nat j) s_right inhabitant ∧ (0%Z ≤ nth (Z.to_nat j) s_left inhabitant -> nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant ≤ nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant))) -> (0%Z ≤ i ∧ i < Z.of_nat (length s_left)) ∧ (let li : Z := nth (Z.to_nat i) s_left inhabitant in (0%Z ≤ i ∧ i < Z.of_nat (length s_right)) ∧ (let ri : Z := nth (Z.to_nat i) s_right inhabitant in if decide (0%Z ≤ li) then if decide (ri < n) then (0%Z ≤ ri ∧ ri < Z.of_nat (length a)) ∧ (0%Z ≤ li ∧ li < Z.of_nat (length a)) ∧ (if decide (nth (Z.to_nat ri) a inhabitant < nth (Z.to_nat li) a inhabitant) then (0%Z ≤ li ∧ li < Z.of_nat (length dirs2)) ∧ (let o2 : dir := dir'mk (left1 (nth (Z.to_nat li) dirs2 inhabitant)) (Some i) in (0%Z ≤ li ∧ li < Z.of_nat (length dirs2)) ∧ (length (set_list dirs2 (Z.to_nat li) o2) = length dirs2 -> nth_i (set_list dirs2 (Z.to_nat li) o2) = fun_updt (nth_i dirs2) li o2 -> (∀(j : Z) (v : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> (left1 (nth (Z.to_nat j) (set_list dirs2 (Z.to_nat li) o2) inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (0%Z ≤ v ∧ v < j) ∧ (∀(x : Z), v < x ∧ x < j -> nth (Z.to_nat j) a inhabitant ≤ nth (Z.to_nat x) a inhabitant)) ∧ (right1 (nth (Z.to_nat j) (set_list dirs2 (Z.to_nat li) o2) inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (j < v ∧ v < Z.of_nat (length a)) ∧ (∀(x : Z), j < x ∧ x < v -> nth (Z.to_nat j) a inhabitant ≤ nth (Z.to_nat x) a inhabitant))) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < i + 1%Z -> (if decide (0%Z ≤ nth (Z.to_nat j) s_left inhabitant ∧ n ≤ nth (Z.to_nat j) s_right inhabitant) then right1 (nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) (set_list dirs2 (Z.to_nat li) o2) inhabitant) = Some j else if decide (nth (Z.to_nat j) s_left inhabitant < 0%Z ∧ nth (Z.to_nat j) s_right inhabitant < n) then left1 (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) (set_list dirs2 (Z.to_nat li) o2) inhabitant) = Some j else 0%Z ≤ nth (Z.to_nat j) s_left inhabitant ∧ nth (Z.to_nat j) s_right inhabitant < n -> (if decide (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant < nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant) then right1 (nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) (set_list dirs2 (Z.to_nat li) o2) inhabitant) = Some j else left1 (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) (set_list dirs2 (Z.to_nat li) o2) inhabitant) = Some j))) ∧ (∀(j : Z) (p : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> 0%Z ≤ p ∧ p < Z.of_nat (length a) -> (right1 (nth (Z.to_nat p) (set_list dirs2 (Z.to_nat li) o2) inhabitant) = Some j -> p = nth (Z.to_nat j) s_left inhabitant ∧ (nth (Z.to_nat j) s_right inhabitant < n -> nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant < nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant)) ∧ (left1 (nth (Z.to_nat p) (set_list dirs2 (Z.to_nat li) o2) inhabitant) = Some j -> p = nth (Z.to_nat j) s_right inhabitant ∧ (0%Z ≤ nth (Z.to_nat j) s_left inhabitant -> nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant ≤ nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant))))) else (0%Z ≤ ri ∧ ri < Z.of_nat (length dirs2)) ∧ (let o2 : dir := dir'mk (Some i) (right1 (nth (Z.to_nat ri) dirs2 inhabitant)) in (0%Z ≤ ri ∧ ri < Z.of_nat (length dirs2)) ∧ (length (set_list dirs2 (Z.to_nat ri) o2) = length dirs2 -> nth_i (set_list dirs2 (Z.to_nat ri) o2) = fun_updt (nth_i dirs2) ri o2 -> (∀(j : Z) (v : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> (left1 (nth (Z.to_nat j) (set_list dirs2 (Z.to_nat ri) o2) inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (0%Z ≤ v ∧ v < j) ∧ (∀(x : Z), v < x ∧ x < j -> nth (Z.to_nat j) a inhabitant ≤ nth (Z.to_nat x) a inhabitant)) ∧ (right1 (nth (Z.to_nat j) (set_list dirs2 (Z.to_nat ri) o2) inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (j < v ∧ v < Z.of_nat (length a)) ∧ (∀(x : Z), j < x ∧ x < v -> nth (Z.to_nat j) a inhabitant ≤ nth (Z.to_nat x) a inhabitant))) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < i + 1%Z -> (if decide (0%Z ≤ nth (Z.to_nat j) s_left inhabitant ∧ n ≤ nth (Z.to_nat j) s_right inhabitant) then right1 (nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) (set_list dirs2 (Z.to_nat ri) o2) inhabitant) = Some j else if decide (nth (Z.to_nat j) s_left inhabitant < 0%Z ∧ nth (Z.to_nat j) s_right inhabitant < n) then left1 (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) (set_list dirs2 (Z.to_nat ri) o2) inhabitant) = Some j else 0%Z ≤ nth (Z.to_nat j) s_left inhabitant ∧ nth (Z.to_nat j) s_right inhabitant < n -> (if decide (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant < nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant) then right1 (nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) (set_list dirs2 (Z.to_nat ri) o2) inhabitant) = Some j else left1 (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) (set_list dirs2 (Z.to_nat ri) o2) inhabitant) = Some j))) ∧ (∀(j : Z) (p : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> 0%Z ≤ p ∧ p < Z.of_nat (length a) -> (right1 (nth (Z.to_nat p) (set_list dirs2 (Z.to_nat ri) o2) inhabitant) = Some j -> p = nth (Z.to_nat j) s_left inhabitant ∧ (nth (Z.to_nat j) s_right inhabitant < n -> nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant < nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant)) ∧ (left1 (nth (Z.to_nat p) (set_list dirs2 (Z.to_nat ri) o2) inhabitant) = Some j -> p = nth (Z.to_nat j) s_right inhabitant ∧ (0%Z ≤ nth (Z.to_nat j) s_left inhabitant -> nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant ≤ nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant)))))) else (0%Z ≤ li ∧ li < Z.of_nat (length dirs2)) ∧ (let o2 : dir := dir'mk (left1 (nth (Z.to_nat li) dirs2 inhabitant)) (Some i) in (0%Z ≤ li ∧ li < Z.of_nat (length dirs2)) ∧ (length (set_list dirs2 (Z.to_nat li) o2) = length dirs2 -> nth_i (set_list dirs2 (Z.to_nat li) o2) = fun_updt (nth_i dirs2) li o2 -> (∀(j : Z) (v : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> (left1 (nth (Z.to_nat j) (set_list dirs2 (Z.to_nat li) o2) inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (0%Z ≤ v ∧ v < j) ∧ (∀(x : Z), v < x ∧ x < j -> nth (Z.to_nat j) a inhabitant ≤ nth (Z.to_nat x) a inhabitant)) ∧ (right1 (nth (Z.to_nat j) (set_list dirs2 (Z.to_nat li) o2) inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (j < v ∧ v < Z.of_nat (length a)) ∧ (∀(x : Z), j < x ∧ x < v -> nth (Z.to_nat j) a inhabitant ≤ nth (Z.to_nat x) a inhabitant))) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < i + 1%Z -> (if decide (0%Z ≤ nth (Z.to_nat j) s_left inhabitant ∧ n ≤ nth (Z.to_nat j) s_right inhabitant) then right1 (nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) (set_list dirs2 (Z.to_nat li) o2) inhabitant) = Some j else if decide (nth (Z.to_nat j) s_left inhabitant < 0%Z ∧ nth (Z.to_nat j) s_right inhabitant < n) then left1 (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) (set_list dirs2 (Z.to_nat li) o2) inhabitant) = Some j else 0%Z ≤ nth (Z.to_nat j) s_left inhabitant ∧ nth (Z.to_nat j) s_right inhabitant < n -> (if decide (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant < nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant) then right1 (nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) (set_list dirs2 (Z.to_nat li) o2) inhabitant) = Some j else left1 (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) (set_list dirs2 (Z.to_nat li) o2) inhabitant) = Some j))) ∧ (∀(j : Z) (p : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> 0%Z ≤ p ∧ p < Z.of_nat (length a) -> (right1 (nth (Z.to_nat p) (set_list dirs2 (Z.to_nat li) o2) inhabitant) = Some j -> p = nth (Z.to_nat j) s_left inhabitant ∧ (nth (Z.to_nat j) s_right inhabitant < n -> nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant < nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant)) ∧ (left1 (nth (Z.to_nat p) (set_list dirs2 (Z.to_nat li) o2) inhabitant) = Some j -> p = nth (Z.to_nat j) s_right inhabitant ∧ (0%Z ≤ nth (Z.to_nat j) s_left inhabitant -> nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant ≤ nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant))))) else if decide (ri < n) then (0%Z ≤ ri ∧ ri < Z.of_nat (length dirs2)) ∧ (let o2 : dir := dir'mk (Some i) (right1 (nth (Z.to_nat ri) dirs2 inhabitant)) in (0%Z ≤ ri ∧ ri < Z.of_nat (length dirs2)) ∧ (length (set_list dirs2 (Z.to_nat ri) o2) = length dirs2 -> nth_i (set_list dirs2 (Z.to_nat ri) o2) = fun_updt (nth_i dirs2) ri o2 -> (∀(j : Z) (v : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> (left1 (nth (Z.to_nat j) (set_list dirs2 (Z.to_nat ri) o2) inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (0%Z ≤ v ∧ v < j) ∧ (∀(x : Z), v < x ∧ x < j -> nth (Z.to_nat j) a inhabitant ≤ nth (Z.to_nat x) a inhabitant)) ∧ (right1 (nth (Z.to_nat j) (set_list dirs2 (Z.to_nat ri) o2) inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (j < v ∧ v < Z.of_nat (length a)) ∧ (∀(x : Z), j < x ∧ x < v -> nth (Z.to_nat j) a inhabitant ≤ nth (Z.to_nat x) a inhabitant))) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < i + 1%Z -> (if decide (0%Z ≤ nth (Z.to_nat j) s_left inhabitant ∧ n ≤ nth (Z.to_nat j) s_right inhabitant) then right1 (nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) (set_list dirs2 (Z.to_nat ri) o2) inhabitant) = Some j else if decide (nth (Z.to_nat j) s_left inhabitant < 0%Z ∧ nth (Z.to_nat j) s_right inhabitant < n) then left1 (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) (set_list dirs2 (Z.to_nat ri) o2) inhabitant) = Some j else 0%Z ≤ nth (Z.to_nat j) s_left inhabitant ∧ nth (Z.to_nat j) s_right inhabitant < n -> (if decide (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant < nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant) then right1 (nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) (set_list dirs2 (Z.to_nat ri) o2) inhabitant) = Some j else left1 (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) (set_list dirs2 (Z.to_nat ri) o2) inhabitant) = Some j))) ∧ (∀(j : Z) (p : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> 0%Z ≤ p ∧ p < Z.of_nat (length a) -> (right1 (nth (Z.to_nat p) (set_list dirs2 (Z.to_nat ri) o2) inhabitant) = Some j -> p = nth (Z.to_nat j) s_left inhabitant ∧ (nth (Z.to_nat j) s_right inhabitant < n -> nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant < nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant)) ∧ (left1 (nth (Z.to_nat p) (set_list dirs2 (Z.to_nat ri) o2) inhabitant) = Some j -> p = nth (Z.to_nat j) s_right inhabitant ∧ (0%Z ≤ nth (Z.to_nat j) s_left inhabitant -> nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant ≤ nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant))))) else (∀(j : Z) (v : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> (left1 (nth (Z.to_nat j) dirs2 inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (0%Z ≤ v ∧ v < j) ∧ (∀(x : Z), v < x ∧ x < j -> nth (Z.to_nat j) a inhabitant ≤ nth (Z.to_nat x) a inhabitant)) ∧ (right1 (nth (Z.to_nat j) dirs2 inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (j < v ∧ v < Z.of_nat (length a)) ∧ (∀(x : Z), j < x ∧ x < v -> nth (Z.to_nat j) a inhabitant ≤ nth (Z.to_nat x) a inhabitant))) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < i + 1%Z -> (if decide (0%Z ≤ nth (Z.to_nat j) s_left inhabitant ∧ n ≤ nth (Z.to_nat j) s_right inhabitant) then right1 (nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) dirs2 inhabitant) = Some j else if decide (nth (Z.to_nat j) s_left inhabitant < 0%Z ∧ nth (Z.to_nat j) s_right inhabitant < n) then left1 (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) dirs2 inhabitant) = Some j else 0%Z ≤ nth (Z.to_nat j) s_left inhabitant ∧ nth (Z.to_nat j) s_right inhabitant < n -> (if decide (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant < nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant) then right1 (nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) dirs2 inhabitant) = Some j else left1 (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) dirs2 inhabitant) = Some j))) ∧ (∀(j : Z) (p : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> 0%Z ≤ p ∧ p < Z.of_nat (length a) -> (right1 (nth (Z.to_nat p) dirs2 inhabitant) = Some j -> p = nth (Z.to_nat j) s_left inhabitant ∧ (nth (Z.to_nat j) s_right inhabitant < n -> nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant < nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant)) ∧ (left1 (nth (Z.to_nat p) dirs2 inhabitant) = Some j -> p = nth (Z.to_nat j) s_right inhabitant ∧ (0%Z ≤ nth (Z.to_nat j) s_left inhabitant -> nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant ≤ nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant)))))) ∧ ((∀(j : Z) (v : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> (left1 (nth (Z.to_nat j) dirs2 inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (0%Z ≤ v ∧ v < j) ∧ (∀(x : Z), v < x ∧ x < j -> nth (Z.to_nat j) a inhabitant ≤ nth (Z.to_nat x) a inhabitant)) ∧ (right1 (nth (Z.to_nat j) dirs2 inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (j < v ∧ v < Z.of_nat (length a)) ∧ (∀(x : Z), j < x ∧ x < v -> nth (Z.to_nat j) a inhabitant ≤ nth (Z.to_nat x) a inhabitant))) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < o1 + 1%Z -> (if decide (0%Z ≤ nth (Z.to_nat j) s_left inhabitant ∧ n ≤ nth (Z.to_nat j) s_right inhabitant) then right1 (nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) dirs2 inhabitant) = Some j else if decide (nth (Z.to_nat j) s_left inhabitant < 0%Z ∧ nth (Z.to_nat j) s_right inhabitant < n) then left1 (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) dirs2 inhabitant) = Some j else 0%Z ≤ nth (Z.to_nat j) s_left inhabitant ∧ nth (Z.to_nat j) s_right inhabitant < n -> (if decide (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant < nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant) then right1 (nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) dirs2 inhabitant) = Some j else left1 (nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) dirs2 inhabitant) = Some j))) ∧ (∀(j : Z) (p : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> 0%Z ≤ p ∧ p < Z.of_nat (length a) -> (right1 (nth (Z.to_nat p) dirs2 inhabitant) = Some j -> p = nth (Z.to_nat j) s_left inhabitant ∧ (nth (Z.to_nat j) s_right inhabitant < n -> nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant < nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant)) ∧ (left1 (nth (Z.to_nat p) dirs2 inhabitant) = Some j -> p = nth (Z.to_nat j) s_right inhabitant ∧ (0%Z ≤ nth (Z.to_nat j) s_left inhabitant -> nth (Z.to_nat (nth (Z.to_nat j) s_left inhabitant)) a inhabitant ≤ nth (Z.to_nat (nth (Z.to_nat j) s_right inhabitant)) a inhabitant))) -> length dirs2 = length a ∧ (∀(j : Z) (v : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> (left1 (nth (Z.to_nat j) dirs2 inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (0%Z ≤ v ∧ v < j) ∧ (∀(x : Z), v < x ∧ x < j -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat x) a inhabitant)) ∧ (right1 (nth (Z.to_nat j) dirs2 inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (j < v ∧ v < Z.of_nat (length a)) ∧ (∀(x : Z), j < x ∧ x < v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat x) a inhabitant))) ∧ (∀(p : Z) (s : Z), 0%Z ≤ p ∧ p < Z.of_nat (length a) -> descendant dirs2 p s -> (0%Z ≤ s ∧ s < Z.of_nat (length a)) ∧ nth (Z.to_nat p) a inhabitant ≤ nth (Z.to_nat s) a inhabitant) ∧ (∀(p1 : Z) (p2 : Z) (s : Z), 0%Z ≤ p1 ∧ p1 < Z.of_nat (length a) -> descendant dirs2 p2 s -> (left1 (nth (Z.to_nat p1) dirs2 inhabitant) = Some p2 -> s < p1) ∧ (right1 (nth (Z.to_nat p1) dirs2 inhabitant) = Some p2 -> p1 < s)) ∧ (∀(i : Z) (k : Z), 0%Z ≤ i ∧ i < Z.of_nat (length a) -> 0%Z ≤ k ∧ k < Z.of_nat (length a) -> nth (Z.to_nat k) a inhabitant < nth (Z.to_nat i) a inhabitant -> (∃(sm : Z), (0%Z ≤ sm ∧ sm < Z.of_nat (length a)) ∧ parent dirs2 sm i)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length a) -> is_smallest a i ∨ (∃(sm : Z), (0%Z ≤ sm ∧ sm < Z.of_nat (length a)) ∧ parent dirs2 sm i)) ∧ (∀(p1 : Z) (p2 : Z) (s : Z), 0%Z ≤ p1 ∧ p1 < Z.of_nat (length a) -> 0%Z ≤ p2 ∧ p2 < Z.of_nat (length a) -> 0%Z ≤ s ∧ s < Z.of_nat (length a) -> parent dirs2 p1 s -> parent dirs2 p2 s -> p1 = p2) ∧ (∀(p1 : Z) (p2 : Z), 0%Z ≤ p1 ∧ p1 < Z.of_nat (length a) -> 0%Z ≤ p2 ∧ p2 < Z.of_nat (length a) -> 0%Z ≤ p1 ∧ p1 < Z.of_nat (length a) -> parent dirs2 p1 p2 -> descendant dirs2 p2 p1 -> ¬ True)))) ∧ (o1 + 1%Z < 0%Z -> length dirs1 = length a ∧ (∀(j : Z) (v : Z), 0%Z ≤ j ∧ j < Z.of_nat (length a) -> (left1 (nth (Z.to_nat j) dirs1 inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (0%Z ≤ v ∧ v < j) ∧ (∀(x : Z), v < x ∧ x < j -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat x) a inhabitant)) ∧ (right1 (nth (Z.to_nat j) dirs1 inhabitant) = Some v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat v) a inhabitant ∧ (j < v ∧ v < Z.of_nat (length a)) ∧ (∀(x : Z), j < x ∧ x < v -> nth (Z.to_nat j) a inhabitant < nth (Z.to_nat x) a inhabitant))) ∧ (∀(p : Z) (s : Z), 0%Z ≤ p ∧ p < Z.of_nat (length a) -> descendant dirs1 p s -> (0%Z ≤ s ∧ s < Z.of_nat (length a)) ∧ nth (Z.to_nat p) a inhabitant ≤ nth (Z.to_nat s) a inhabitant) ∧ (∀(p1 : Z) (p2 : Z) (s : Z), 0%Z ≤ p1 ∧ p1 < Z.of_nat (length a) -> descendant dirs1 p2 s -> (left1 (nth (Z.to_nat p1) dirs1 inhabitant) = Some p2 -> s < p1) ∧ (right1 (nth (Z.to_nat p1) dirs1 inhabitant) = Some p2 -> p1 < s)) ∧ (∀(i : Z) (k : Z), 0%Z ≤ i ∧ i < Z.of_nat (length a) -> 0%Z ≤ k ∧ k < Z.of_nat (length a) -> nth (Z.to_nat k) a inhabitant < nth (Z.to_nat i) a inhabitant -> (∃(sm : Z), (0%Z ≤ sm ∧ sm < Z.of_nat (length a)) ∧ parent dirs1 sm i)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length a) -> is_smallest a i ∨ (∃(sm : Z), (0%Z ≤ sm ∧ sm < Z.of_nat (length a)) ∧ parent dirs1 sm i)) ∧ (∀(p1 : Z) (p2 : Z) (s : Z), 0%Z ≤ p1 ∧ p1 < Z.of_nat (length a) -> 0%Z ≤ p2 ∧ p2 < Z.of_nat (length a) -> 0%Z ≤ s ∧ s < Z.of_nat (length a) -> parent dirs1 p1 s -> parent dirs1 p2 s -> p1 = p2) ∧ (∀(p1 : Z) (p2 : Z), 0%Z ≤ p1 ∧ p1 < Z.of_nat (length a) -> 0%Z ≤ p2 ∧ p2 < Z.of_nat (length a) -> 0%Z ≤ p1 ∧ p1 < Z.of_nat (length a) -> parent dirs1 p1 p2 -> descendant dirs1 p2 p1 -> ¬ True))))).
Admitted.
