From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.why3.Ref.Ref.
Require Import Why3.exn.Exn.
Open Scope Z_scope.
Axiom Trans : forall  (y : Z) (x : Z) (z : Z) (fact0 : y ≤ x) (fact1 : z ≤ y), z ≤ x.
Inductive sorted : list Z -> Prop :=
 | Sorted_Nil : sorted ([] : list Z)
 | Sorted_One (x : Z) : sorted (cons x ([] : list Z))
 | Sorted_Two (y : Z) (x : Z) (l : list Z) : y ≤ x -> sorted (cons y l) -> sorted (cons x (cons y l)).
Axiom sorted_mem : forall  (l : list Z) (x : Z), ((∀(y : Z), y ∈ l -> y ≤ x) ∧ sorted l) = sorted (cons x l).
Axiom sorted_append : forall  (l1 : list Z) (l2 : list Z), (sorted l1 ∧ sorted l2 ∧ (∀(x : Z) (y : Z), x ∈ l1 -> y ∈ l2 -> y ≤ x)) = sorted (l1 ++ l2).
Axiom destruct : forall {ty'xi : Type} `{Inhabited ty'xi}, list ty'xi -> ty'xi * list ty'xi.
Axiom destruct'def : forall  {ty'xi : Type} `{Inhabited ty'xi} (l : list ty'xi) (fact0 : ¬ is_Nil l), match l with | cons h t => destruct l = (h, t) | _ => False end.
Axiom peek : forall {ty'xi : Type} `{Inhabited ty'xi}, list ty'xi -> ty'xi.
Axiom peek'def : forall  {ty'xi : Type} `{Inhabited ty'xi} (l : list ty'xi) (fact0 : ¬ is_Nil l), match destruct l with | (h, _) => peek l = h end.
Axiom peek'spec : forall  {ty'xi : Type} `{Inhabited ty'xi} (l : list ty'xi) (fact0 : ¬ is_Nil l), peek l ∈ l.
Axiom tail : forall {ty'xi : Type} `{Inhabited ty'xi}, list ty'xi -> list ty'xi.
Axiom tail'def : forall  {ty'xi : Type} `{Inhabited ty'xi} (l : list ty'xi) (fact0 : ¬ is_Nil l), match destruct l with | (_, t) => tail l = t end.
Theorem smaller_left'vc (s : list Z) : let n : Z := Z.of_nat (length s) in 0%Z ≤ n ∧ (∀(left1 : list Z), (∀(i : Z), 0%Z ≤ i ∧ i < n -> nth (Z.to_nat i) left1 inhabitant = - 1%Z) ∧ Z.of_nat (length left1) = n -> (let o1 : Z := Z.of_nat (length s) - 1%Z in (0%Z ≤ o1 + 1%Z -> ((∀(z : Z), z ∈ ([] : list Z) -> 0%Z ≤ z ∧ z < 0%Z) ∧ (¬ is_Nil ([] : list Z) -> peek ([] : list Z) = 0%Z - 1%Z) ∧ sorted ([] : list Z) ∧ (∀(y : Z), 0%Z ≤ y ∧ y < 0%Z -> nth (Z.to_nat y) left1 inhabitant < y) ∧ (∀(y : Z), 0%Z ≤ y ∧ y < 0%Z -> 0%Z ≤ nth (Z.to_nat y) left1 inhabitant -> nth (Z.to_nat (nth (Z.to_nat y) left1 inhabitant)) s inhabitant < nth (Z.to_nat y) s inhabitant) ∧ (∀(z : Z), 0%Z ≤ z ∧ z < 0%Z -> (∃(y : Z), (z ≤ y ∧ y < 0%Z) ∧ y ∈ ([] : list Z) ∧ nth (Z.to_nat y) s inhabitant ≤ nth (Z.to_nat z) s inhabitant)) ∧ (∀(y : Z) (z : Z), 0%Z ≤ y ∧ y < 0%Z -> nth (Z.to_nat y) left1 inhabitant < z ∧ z < y -> nth (Z.to_nat y) s inhabitant ≤ nth (Z.to_nat z) s inhabitant)) ∧ (∀(my_stack : list Z) (left2 : list Z), length left2 = length left1 -> (∀(x : Z), (0%Z ≤ x ∧ x ≤ o1) ∧ (∀(z : Z), z ∈ my_stack -> 0%Z ≤ z ∧ z < x) ∧ (is_Nil my_stack -> x = 0%Z) ∧ (¬ is_Nil my_stack -> peek my_stack = x - 1%Z) ∧ sorted my_stack ∧ (∀(y : Z), 0%Z ≤ y ∧ y < x -> nth (Z.to_nat y) left2 inhabitant < y) ∧ (∀(y : Z), 0%Z ≤ y ∧ y < x -> 0%Z ≤ nth (Z.to_nat y) left2 inhabitant -> nth (Z.to_nat (nth (Z.to_nat y) left2 inhabitant)) s inhabitant < nth (Z.to_nat y) s inhabitant) ∧ (∀(z : Z), 0%Z ≤ z ∧ z < x -> (∃(y : Z), (z ≤ y ∧ y < x) ∧ y ∈ my_stack ∧ nth (Z.to_nat y) s inhabitant ≤ nth (Z.to_nat z) s inhabitant)) ∧ (∀(y : Z) (z : Z), 0%Z ≤ y ∧ y < x -> nth (Z.to_nat y) left2 inhabitant < z ∧ z < y -> nth (Z.to_nat y) s inhabitant ≤ nth (Z.to_nat z) s inhabitant) -> ((∀(z : Z), z ∈ my_stack -> 0%Z ≤ z ∧ z < x) ∧ sorted my_stack ∧ (∀(z : Z), z ∈ my_stack -> nth (Z.to_nat x) s inhabitant ≤ nth (Z.to_nat z) s inhabitant ∨ z ∈ my_stack) ∧ (∀(z : Z), ¬ is_Nil my_stack -> z ∈ my_stack -> z ≤ peek my_stack) ∧ (∀(z : Z), ¬ is_Nil my_stack -> peek my_stack < z ∧ z < x -> nth (Z.to_nat x) s inhabitant ≤ nth (Z.to_nat z) s inhabitant) ∧ (∀(z : Z), is_Nil my_stack -> 0%Z ≤ z ∧ z < x -> nth (Z.to_nat x) s inhabitant ≤ nth (Z.to_nat z) s inhabitant)) ∧ (∀(my_stack1 : list Z), (∀(z : Z), z ∈ my_stack1 -> 0%Z ≤ z ∧ z < x) ∧ sorted my_stack1 ∧ (∀(z : Z), z ∈ my_stack -> nth (Z.to_nat x) s inhabitant ≤ nth (Z.to_nat z) s inhabitant ∨ z ∈ my_stack1) ∧ (∀(z : Z), ¬ is_Nil my_stack1 -> z ∈ my_stack1 -> z ≤ peek my_stack1) ∧ (∀(z : Z), ¬ is_Nil my_stack1 -> peek my_stack1 < z ∧ z < x -> nth (Z.to_nat x) s inhabitant ≤ nth (Z.to_nat z) s inhabitant) ∧ (∀(z : Z), is_Nil my_stack1 -> 0%Z ≤ z ∧ z < x -> nth (Z.to_nat x) s inhabitant ≤ nth (Z.to_nat z) s inhabitant) -> is_Nil my_stack1 = (my_stack1 = ([] : list Z)) -> (¬ is_Nil my_stack1 -> (0%Z ≤ x ∧ x < Z.of_nat (length s)) ∧ ¬ is_Nil my_stack1 ∧ (let o2 : Z := peek my_stack1 in o2 ∈ my_stack1 -> 0%Z ≤ o2 ∧ o2 < Z.of_nat (length s))) ∧ (∀(o2 : bool), (if decide (¬ is_Nil my_stack1) then let o3 : Z := peek my_stack1 in o3 ∈ my_stack1 ∧ o2 = (if decide (nth (Z.to_nat x) s inhabitant ≤ nth (Z.to_nat o3) s inhabitant) then true else false) else o2 = false) -> (if decide (o2 = true) then ¬ is_Nil my_stack1 ∧ (0%Z ≤ Z.of_nat (length my_stack1) ∧ Z.of_nat (length (tail my_stack1)) < Z.of_nat (length my_stack1)) ∧ (∀(z : Z), z ∈ tail my_stack1 -> 0%Z ≤ z ∧ z < x) ∧ sorted (tail my_stack1) ∧ (∀(z : Z), z ∈ my_stack -> nth (Z.to_nat x) s inhabitant ≤ nth (Z.to_nat z) s inhabitant ∨ z ∈ tail my_stack1) ∧ (∀(z : Z), ¬ is_Nil (tail my_stack1) -> z ∈ tail my_stack1 -> z ≤ peek (tail my_stack1)) ∧ (∀(z : Z), ¬ is_Nil (tail my_stack1) -> peek (tail my_stack1) < z ∧ z < x -> nth (Z.to_nat x) s inhabitant ≤ nth (Z.to_nat z) s inhabitant) ∧ (∀(z : Z), is_Nil (tail my_stack1) -> 0%Z ≤ z ∧ z < x -> nth (Z.to_nat x) s inhabitant ≤ nth (Z.to_nat z) s inhabitant) else is_Nil my_stack1 = (my_stack1 = ([] : list Z)) -> (if decide (is_Nil my_stack1) then (0%Z ≤ x ∧ x < Z.of_nat (length left2)) ∧ (length (set_list left2 (Z.to_nat x) (- 1%Z)) = length left2 -> nth_i (set_list left2 (Z.to_nat x) (- 1%Z)) = fun_updt (nth_i left2) x (- 1%Z) -> (∀(z : Z), z ∈ cons x my_stack1 -> 0%Z ≤ z ∧ z < x + 1%Z) ∧ (is_Nil (cons x my_stack1) -> x + 1%Z = 0%Z) ∧ (¬ is_Nil (cons x my_stack1) -> peek (cons x my_stack1) = x + 1%Z - 1%Z) ∧ sorted (cons x my_stack1) ∧ (∀(y : Z), 0%Z ≤ y ∧ y < x + 1%Z -> nth (Z.to_nat y) (set_list left2 (Z.to_nat x) (- 1%Z)) inhabitant < y) ∧ (∀(y : Z), 0%Z ≤ y ∧ y < x + 1%Z -> 0%Z ≤ nth (Z.to_nat y) (set_list left2 (Z.to_nat x) (- 1%Z)) inhabitant -> nth (Z.to_nat (nth (Z.to_nat y) (set_list left2 (Z.to_nat x) (- 1%Z)) inhabitant)) s inhabitant < nth (Z.to_nat y) s inhabitant) ∧ (∀(z : Z), 0%Z ≤ z ∧ z < x + 1%Z -> (∃(y : Z), (z ≤ y ∧ y < x + 1%Z) ∧ y ∈ cons x my_stack1 ∧ nth (Z.to_nat y) s inhabitant ≤ nth (Z.to_nat z) s inhabitant)) ∧ (∀(y : Z) (z : Z), 0%Z ≤ y ∧ y < x + 1%Z -> nth (Z.to_nat y) (set_list left2 (Z.to_nat x) (- 1%Z)) inhabitant < z ∧ z < y -> nth (Z.to_nat y) s inhabitant ≤ nth (Z.to_nat z) s inhabitant)) else ¬ is_Nil my_stack1 ∧ (let o3 : Z := peek my_stack1 in o3 ∈ my_stack1 -> (0%Z ≤ x ∧ x < Z.of_nat (length left2)) ∧ (length (set_list left2 (Z.to_nat x) o3) = length left2 -> nth_i (set_list left2 (Z.to_nat x) o3) = fun_updt (nth_i left2) x o3 -> (∀(z : Z), z ∈ cons x my_stack1 -> 0%Z ≤ z ∧ z < x + 1%Z) ∧ (is_Nil (cons x my_stack1) -> x + 1%Z = 0%Z) ∧ (¬ is_Nil (cons x my_stack1) -> peek (cons x my_stack1) = x + 1%Z - 1%Z) ∧ sorted (cons x my_stack1) ∧ (∀(y : Z), 0%Z ≤ y ∧ y < x + 1%Z -> nth (Z.to_nat y) (set_list left2 (Z.to_nat x) o3) inhabitant < y) ∧ (∀(y : Z), 0%Z ≤ y ∧ y < x + 1%Z -> 0%Z ≤ nth (Z.to_nat y) (set_list left2 (Z.to_nat x) o3) inhabitant -> nth (Z.to_nat (nth (Z.to_nat y) (set_list left2 (Z.to_nat x) o3) inhabitant)) s inhabitant < nth (Z.to_nat y) s inhabitant) ∧ (∀(z : Z), 0%Z ≤ z ∧ z < x + 1%Z -> (∃(y : Z), (z ≤ y ∧ y < x + 1%Z) ∧ y ∈ cons x my_stack1 ∧ nth (Z.to_nat y) s inhabitant ≤ nth (Z.to_nat z) s inhabitant)) ∧ (∀(y : Z) (z : Z), 0%Z ≤ y ∧ y < x + 1%Z -> nth (Z.to_nat y) (set_list left2 (Z.to_nat x) o3) inhabitant < z ∧ z < y -> nth (Z.to_nat y) s inhabitant ≤ nth (Z.to_nat z) s inhabitant)))))))) ∧ ((∀(z : Z), z ∈ my_stack -> 0%Z ≤ z ∧ z < o1 + 1%Z) ∧ (is_Nil my_stack -> o1 + 1%Z = 0%Z) ∧ (¬ is_Nil my_stack -> peek my_stack = o1 + 1%Z - 1%Z) ∧ sorted my_stack ∧ (∀(y : Z), 0%Z ≤ y ∧ y < o1 + 1%Z -> nth (Z.to_nat y) left2 inhabitant < y) ∧ (∀(y : Z), 0%Z ≤ y ∧ y < o1 + 1%Z -> 0%Z ≤ nth (Z.to_nat y) left2 inhabitant -> nth (Z.to_nat (nth (Z.to_nat y) left2 inhabitant)) s inhabitant < nth (Z.to_nat y) s inhabitant) ∧ (∀(z : Z), 0%Z ≤ z ∧ z < o1 + 1%Z -> (∃(y : Z), (z ≤ y ∧ y < o1 + 1%Z) ∧ y ∈ my_stack ∧ nth (Z.to_nat y) s inhabitant ≤ nth (Z.to_nat z) s inhabitant)) ∧ (∀(y : Z) (z : Z), 0%Z ≤ y ∧ y < o1 + 1%Z -> nth (Z.to_nat y) left2 inhabitant < z ∧ z < y -> nth (Z.to_nat y) s inhabitant ≤ nth (Z.to_nat z) s inhabitant) -> (∀(y : Z), 0%Z ≤ y ∧ y < Z.of_nat (length s) -> nth (Z.to_nat y) left2 inhabitant < y) ∧ (∀(y : Z), 0%Z ≤ y ∧ y < Z.of_nat (length s) -> 0%Z ≤ nth (Z.to_nat y) left2 inhabitant -> nth (Z.to_nat (nth (Z.to_nat y) left2 inhabitant)) s inhabitant < nth (Z.to_nat y) s inhabitant) ∧ (∀(x : Z) (z : Z), 0%Z ≤ x ∧ x < Z.of_nat (length s) -> nth (Z.to_nat x) left2 inhabitant < z ∧ z < x -> nth (Z.to_nat x) s inhabitant ≤ nth (Z.to_nat z) s inhabitant) ∧ length left2 = length s))) ∧ (o1 + 1%Z < 0%Z -> (∀(y : Z), 0%Z ≤ y ∧ y < Z.of_nat (length s) -> nth (Z.to_nat y) left1 inhabitant < y) ∧ (∀(y : Z), 0%Z ≤ y ∧ y < Z.of_nat (length s) -> 0%Z ≤ nth (Z.to_nat y) left1 inhabitant -> nth (Z.to_nat (nth (Z.to_nat y) left1 inhabitant)) s inhabitant < nth (Z.to_nat y) s inhabitant) ∧ (∀(x : Z) (z : Z), 0%Z ≤ x ∧ x < Z.of_nat (length s) -> nth (Z.to_nat x) left1 inhabitant < z ∧ z < x -> nth (Z.to_nat x) s inhabitant ≤ nth (Z.to_nat z) s inhabitant) ∧ length left1 = length s))).
Admitted.
