theory verifythis_2019_ghc_sort_Top_copy_listqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.int_NumOf" "Why3STD.map_MapEq" "Why3STD.map_MapExchange" "Why3STD.map_MapPermut" "Why3STD.array_IntArraySorted" "Why3STD.exn_Exn"
begin
axiomatization where Trans:   "x < z"
 if "x < y"
 and "y < z"
  for x :: "int"
  and y :: "int"
  and z :: "int"
inductive sorted :: "int list \<Rightarrow> bool" where
   Sorted_Nil: "sorted (Nil :: int list)"
 | Sorted_One: "sorted (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two: "x < y \<Longrightarrow> sorted (Cons y l) \<Longrightarrow> sorted (Cons x (Cons y l))" for x :: "int" and y :: "int" and l :: "int list"
axiomatization where sorted_mem:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> x < y) \<and> sorted l \<longleftrightarrow> sorted (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append:   "sorted l1 \<and> sorted l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> x < y) \<longleftrightarrow> sorted (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
axiomatization where Trans1:   "x \<le> z"
 if "x \<le> y"
 and "y \<le> z"
  for x :: "int"
  and y :: "int"
  and z :: "int"
inductive sorted1 :: "int list \<Rightarrow> bool" where
   Sorted_Nil1: "sorted1 (Nil :: int list)"
 | Sorted_One1: "sorted1 (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two1: "x \<le> y \<Longrightarrow> sorted1 (Cons y l) \<Longrightarrow> sorted1 (Cons x (Cons y l))" for x :: "int" and y :: "int" and l :: "int list"
axiomatization where sorted_mem1:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> x \<le> y) \<and> sorted1 l \<longleftrightarrow> sorted1 (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append1:   "sorted1 l1 \<and> sorted1 l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> x \<le> y) \<longleftrightarrow> sorted1 (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
inductive sorted2 :: "int list \<Rightarrow> bool" where
   Sorted_Nil2: "sorted2 (Nil :: int list)"
 | Sorted_One2: "sorted2 (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two2: "y \<le> x \<Longrightarrow> sorted2 (Cons y l) \<Longrightarrow> sorted2 (Cons x (Cons y l))" for y :: "int" and x :: "int" and l :: "int list"
axiomatization where sorted_mem2:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> y \<le> x) \<and> sorted2 l \<longleftrightarrow> sorted2 (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append2:   "sorted2 l1 \<and> sorted2 l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> y \<le> x) \<longleftrightarrow> sorted2 (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
definition compat :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "compat s t \<longleftrightarrow> (case (s, t) of (Cons x _, Cons y _) \<Rightarrow> x \<le> y | (_, _) \<Rightarrow> True)" for s t
axiomatization where rev_append_sorted_incr:   "sorted1 (rev s @ t) \<longleftrightarrow> sorted2 s \<and> sorted1 t \<and> compat s t"
  for s :: "int list"
  and t :: "int list"
axiomatization where rev_append_sorted_decr:   "sorted2 (rev s @ t) \<longleftrightarrow> sorted1 s \<and> sorted2 t \<and> compat t s"
  for s :: "int list"
  and t :: "int list"
definition eqb :: "bool \<Rightarrow> bool \<Rightarrow> bool"
  where "eqb b1 b2 = ((b1 \<longrightarrow> b2) \<and> (b2 \<longrightarrow> b1))" for b1 b2
axiomatization where eqb'spec:   "eqb b1 b2 = True \<longleftrightarrow> b1 = b2"
  for b1 :: "bool"
  and b2 :: "bool"
typedecl  list_seq
consts list :: "list_seq \<Rightarrow> int list"
consts seq :: "list_seq \<Rightarrow> int list"
axiomatization where list_seq'invariant:   "seq self = rev (list self)"
  for self :: "list_seq"
definition list_seq'eq :: "list_seq \<Rightarrow> list_seq \<Rightarrow> _"
  where "list_seq'eq a b \<longleftrightarrow> list a = list b \<and> seq a = seq b" for a b
axiomatization where list_seq'inj:   "a = b"
 if "list_seq'eq a b"
  for a :: "list_seq"
  and b :: "list_seq"
consts nil :: "list_seq"
axiomatization where nil'def'0:   "list nil = (Nil :: int list)"
axiomatization where nil'def'1:   "seq nil = []"
consts order :: "int list \<Rightarrow> int list"
axiomatization where order'def:   "case l of Nil \<Rightarrow> order l = l | Cons _ Nil \<Rightarrow> order l = l | Cons h1 (Cons h2 _) \<Rightarrow> (if h1 < h2 then order l = l else order l = rev l)"
 if "sorted l \<or> sorted2 l"
  for l :: "int list"
axiomatization where order'spec'0:   "sorted1 (order l)"
 if "sorted l \<or> sorted2 l"
  for l :: "int list"
axiomatization where order'spec:   "l <~~> order l"
 if "sorted l \<or> sorted2 l"
  for l :: "int list"
theorem copy_list'vc:
  fixes s :: "int"
  fixes l :: "int list"
  fixes a :: "int list"
  assumes fact0: "(0 :: int) \<le> s"
  assumes fact1: "int (length l) = int (length a) - s"
  shows "case l of Nil \<Rightarrow> (\<forall>(x :: int). s \<le> x \<and> x < int (length a) \<longrightarrow> a ! nat x = l ! nat (x - s)) \<and> (\<forall>(x :: int). map_occ x (nth a o nat) s (int (length a)) = count_list l x) | Cons h t \<Rightarrow> ((0 :: int) \<le> s \<and> s < int (length a)) \<and> (length (a[nat s := h]) = length a \<longrightarrow> nth (a[nat s := h]) o nat = (nth a o nat)(s := h) \<longrightarrow> (let o1 :: int = s + (1 :: int) in ((case l of Nil \<Rightarrow> False | Cons _ f \<Rightarrow> f = t) \<and> (0 :: int) \<le> o1 \<and> int (length t) = int (length (a[nat s := h])) - o1) \<and> (\<forall>(a1 :: int list). length a1 = length (a[nat s := h]) \<longrightarrow> (\<forall>(x :: int). o1 \<le> x \<and> x < int (length a1) \<longrightarrow> a1 ! nat x = t ! nat (x - o1)) \<and> (\<forall>(x :: int). (0 :: int) \<le> x \<and> x < o1 \<longrightarrow> a1 ! nat x = a[nat s := h] ! nat x) \<and> (\<forall>(x :: int). map_occ x (nth a1 o nat) o1 (int (length a1)) = count_list t x) \<longrightarrow> (\<forall>(x :: int). s \<le> x \<and> x < int (length a1) \<longrightarrow> a1 ! nat x = l ! nat (x - s)) \<and> (\<forall>(x :: int). (0 :: int) \<le> x \<and> x < s \<longrightarrow> a1 ! nat x = a ! nat x) \<and> (\<forall>(x :: int). map_occ x (nth a1 o nat) s (int (length a1)) = count_list l x))))"
  sorry
end
