theory verifythis_2019_ghc_sort_Top_cutpointsqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.exn_Exn"
begin
axiomatization where Trans:   "x < z"
 if "x < y"
 and "y < z"
  for x :: "int"
  and y :: "int"
  and z :: "int"
inductive sorted :: "int list \<Rightarrow> bool" where
   Sorted_Nil: "sorted (Nil :: int list)"
 | Sorted_One: "sorted (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two: "x < y \<Longrightarrow> sorted (Cons y l) \<Longrightarrow> sorted (Cons x (Cons y l))" for x :: "int" and y :: "int" and l :: "int list"
axiomatization where sorted_mem:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> x < y) \<and> sorted l \<longleftrightarrow> sorted (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append:   "sorted l1 \<and> sorted l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> x < y) \<longleftrightarrow> sorted (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
axiomatization where Trans1:   "x \<le> z"
 if "x \<le> y"
 and "y \<le> z"
  for x :: "int"
  and y :: "int"
  and z :: "int"
inductive sorted1 :: "int list \<Rightarrow> bool" where
   Sorted_Nil1: "sorted1 (Nil :: int list)"
 | Sorted_One1: "sorted1 (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two1: "x \<le> y \<Longrightarrow> sorted1 (Cons y l) \<Longrightarrow> sorted1 (Cons x (Cons y l))" for x :: "int" and y :: "int" and l :: "int list"
axiomatization where sorted_mem1:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> x \<le> y) \<and> sorted1 l \<longleftrightarrow> sorted1 (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append1:   "sorted1 l1 \<and> sorted1 l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> x \<le> y) \<longleftrightarrow> sorted1 (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
inductive sorted2 :: "int list \<Rightarrow> bool" where
   Sorted_Nil2: "sorted2 (Nil :: int list)"
 | Sorted_One2: "sorted2 (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two2: "y \<le> x \<Longrightarrow> sorted2 (Cons y l) \<Longrightarrow> sorted2 (Cons x (Cons y l))" for y :: "int" and x :: "int" and l :: "int list"
axiomatization where sorted_mem2:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> y \<le> x) \<and> sorted2 l \<longleftrightarrow> sorted2 (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append2:   "sorted2 l1 \<and> sorted2 l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> y \<le> x) \<longleftrightarrow> sorted2 (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
definition compat :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "compat s t \<longleftrightarrow> (case (s, t) of (Cons x _, Cons y _) \<Rightarrow> x \<le> y | (_, _) \<Rightarrow> True)" for s t
axiomatization where rev_append_sorted_incr:   "sorted1 (rev s @ t) \<longleftrightarrow> sorted2 s \<and> sorted1 t \<and> compat s t"
  for s :: "int list"
  and t :: "int list"
axiomatization where rev_append_sorted_decr:   "sorted2 (rev s @ t) \<longleftrightarrow> sorted1 s \<and> sorted2 t \<and> compat t s"
  for s :: "int list"
  and t :: "int list"
definition eqb :: "bool \<Rightarrow> bool \<Rightarrow> bool"
  where "eqb b1 b2 = ((b1 \<longrightarrow> b2) \<and> (b2 \<longrightarrow> b1))" for b1 b2
axiomatization where eqb'spec:   "eqb b1 b2 = True \<longleftrightarrow> b1 = b2"
  for b1 :: "bool"
  and b2 :: "bool"
typedecl  list_seq
consts list :: "list_seq \<Rightarrow> int list"
consts seq :: "list_seq \<Rightarrow> int list"
axiomatization where list_seq'invariant:   "seq self = rev (list self)"
  for self :: "list_seq"
definition list_seq'eq :: "list_seq \<Rightarrow> list_seq \<Rightarrow> _"
  where "list_seq'eq a b \<longleftrightarrow> list a = list b \<and> seq a = seq b" for a b
axiomatization where list_seq'inj:   "a = b"
 if "list_seq'eq a b"
  for a :: "list_seq"
  and b :: "list_seq"
consts nil :: "list_seq"
axiomatization where nil'def'0:   "list nil = (Nil :: int list)"
axiomatization where nil'def'1:   "seq nil = []"
theorem cutpoints'vc:
  fixes s :: "int list"
  assumes fact0: "(0 :: int) < int (length s)"
  shows "let n :: int = int (length s) in \<forall>(o1 :: list_seq). list o1 = Cons (0 :: int) (list nil) \<longrightarrow> ((1 :: int) = (0 :: int) + (1 :: int) \<and> ((0 :: int) < (1 :: int) \<and> (1 :: int) \<le> n + (1 :: int)) \<and> (0 :: int) < int (length (seq o1)) \<and> seq o1 ! (0 :: nat) = (0 :: int) \<and> seq o1 ! nat (int (length (seq o1)) - (1 :: int)) = (0 :: int) \<and> (\<forall>(z :: int). z \<in> set (list o1) \<longrightarrow> (0 :: int) \<le> z \<and> z \<le> n) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length (seq o1)) - (1 :: int) \<longrightarrow> (let ck :: int = seq o1 ! nat k; ck1 :: int = seq o1 ! nat (k + (1 :: int)) in (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> s ! nat z1 < s ! nat z2) \<or> (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> s ! nat z2 \<le> s ! nat z1))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < int (length (seq o1)) \<longrightarrow> seq o1 ! nat i \<le> seq o1 ! nat j)) \<and> (\<forall>(cut :: list_seq). ((0 :: int) < seq cut ! nat (int (length (seq cut)) - (1 :: int)) + (1 :: int) \<and> seq cut ! nat (int (length (seq cut)) - (1 :: int)) + (1 :: int) \<le> n + (1 :: int)) \<and> (0 :: int) < int (length (seq cut)) \<and> seq cut ! (0 :: nat) = (0 :: int) \<and> (\<forall>(z :: int). z \<in> set (list cut) \<longrightarrow> (0 :: int) \<le> z \<and> z \<le> n) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length (seq cut)) - (1 :: int) \<longrightarrow> (let ck :: int = seq cut ! nat k; ck1 :: int = seq cut ! nat (k + (1 :: int)) in (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> s ! nat z1 < s ! nat z2) \<or> (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> s ! nat z2 \<le> s ! nat z1))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < int (length (seq cut)) \<longrightarrow> seq cut ! nat i \<le> seq cut ! nat j) \<longrightarrow> (if seq cut ! nat (int (length (seq cut)) - (1 :: int)) + (1 :: int) < n then ((0 :: int) \<le> seq cut ! nat (int (length (seq cut)) - (1 :: int)) + (1 :: int) \<and> seq cut ! nat (int (length (seq cut)) - (1 :: int)) + (1 :: int) < int (length s)) \<and> ((0 :: int) \<le> seq cut ! nat (int (length (seq cut)) - (1 :: int)) \<and> seq cut ! nat (int (length (seq cut)) - (1 :: int)) < int (length s)) \<and> ((seq cut ! nat (int (length (seq cut)) - (1 :: int)) + (1 :: int) \<le> seq cut ! nat (int (length (seq cut)) - (1 :: int)) + (1 :: int) \<and> seq cut ! nat (int (length (seq cut)) - (1 :: int)) + (1 :: int) \<le> n) \<and> ((\<forall>(z1 :: int) (z2 :: int). seq cut ! nat (int (length (seq cut)) - (1 :: int)) \<le> z1 \<and> z1 < z2 \<and> z2 < seq cut ! nat (int (length (seq cut)) - (1 :: int)) + (1 :: int) \<longrightarrow> s ! nat z1 < s ! nat z2) \<or> (\<forall>(z1 :: int) (z2 :: int). seq cut ! nat (int (length (seq cut)) - (1 :: int)) \<le> z1 \<and> z1 < z2 \<and> z2 < seq cut ! nat (int (length (seq cut)) - (1 :: int)) + (1 :: int) \<longrightarrow> s ! nat z2 \<le> s ! nat z1))) \<and> (\<forall>(y :: int). (seq cut ! nat (int (length (seq cut)) - (1 :: int)) + (1 :: int) \<le> y \<and> y \<le> n) \<and> ((\<forall>(z1 :: int) (z2 :: int). seq cut ! nat (int (length (seq cut)) - (1 :: int)) \<le> z1 \<and> z1 < z2 \<and> z2 < y \<longrightarrow> s ! nat z1 < s ! nat z2) \<or> (\<forall>(z1 :: int) (z2 :: int). seq cut ! nat (int (length (seq cut)) - (1 :: int)) \<le> z1 \<and> z1 < z2 \<and> z2 < y \<longrightarrow> s ! nat z2 \<le> s ! nat z1)) \<longrightarrow> (y < n \<longrightarrow> ((0 :: int) \<le> y \<and> y < int (length s)) \<and> (let o2 :: int = y - (1 :: int) in (0 :: int) \<le> o2 \<and> o2 < int (length s))) \<and> (\<forall>(o2 :: bool). (if y < n then let o3 :: bool = if s ! nat (y - (1 :: int)) < s ! nat y then True else False in o2 = eqb o3 (if s ! nat (seq cut ! nat (int (length (seq cut)) - (1 :: int))) < s ! nat (seq cut ! nat (int (length (seq cut)) - (1 :: int)) + (1 :: int)) then True else False) \<and> (o2 = True \<longleftrightarrow> o3 = (if s ! nat (seq cut ! nat (int (length (seq cut)) - (1 :: int))) < s ! nat (seq cut ! nat (int (length (seq cut)) - (1 :: int)) + (1 :: int)) then True else False)) else o2 = False) \<longrightarrow> (if o2 = True then ((0 :: int) \<le> n - y \<and> n - (y + (1 :: int)) < n - y) \<and> (seq cut ! nat (int (length (seq cut)) - (1 :: int)) + (1 :: int) \<le> y + (1 :: int) \<and> y + (1 :: int) \<le> n) \<and> ((\<forall>(z1 :: int) (z2 :: int). seq cut ! nat (int (length (seq cut)) - (1 :: int)) \<le> z1 \<and> z1 < z2 \<and> z2 < y + (1 :: int) \<longrightarrow> s ! nat z1 < s ! nat z2) \<or> (\<forall>(z1 :: int) (z2 :: int). seq cut ! nat (int (length (seq cut)) - (1 :: int)) \<le> z1 \<and> z1 < z2 \<and> z2 < y + (1 :: int) \<longrightarrow> s ! nat z2 \<le> s ! nat z1)) else \<forall>(o3 :: list_seq). list o3 = Cons y (list cut) \<longrightarrow> ((0 :: int) \<le> n - (seq cut ! nat (int (length (seq cut)) - (1 :: int)) + (1 :: int)) \<and> n - (y + (1 :: int)) < n - (seq cut ! nat (int (length (seq cut)) - (1 :: int)) + (1 :: int))) \<and> ((0 :: int) < y + (1 :: int) \<and> y + (1 :: int) \<le> n + (1 :: int)) \<and> (0 :: int) < int (length (seq o3)) \<and> seq o3 ! (0 :: nat) = (0 :: int) \<and> seq o3 ! nat (int (length (seq o3)) - (1 :: int)) = y \<and> (\<forall>(z :: int). z \<in> set (list o3) \<longrightarrow> (0 :: int) \<le> z \<and> z \<le> n) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length (seq o3)) - (1 :: int) \<longrightarrow> (let ck :: int = seq o3 ! nat k; ck1 :: int = seq o3 ! nat (k + (1 :: int)) in (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> s ! nat z1 < s ! nat z2) \<or> (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> s ! nat z2 \<le> s ! nat z1))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < int (length (seq o3)) \<longrightarrow> seq o3 ! nat i \<le> seq o3 ! nat j)))) else if seq cut ! nat (int (length (seq cut)) - (1 :: int)) < n then \<forall>(o2 :: list_seq). list o2 = Cons n (list cut) \<longrightarrow> seq o2 ! (0 :: nat) = (0 :: int) \<and> seq o2 ! nat (int (length (seq o2)) - (1 :: int)) = int (length s) \<and> (2 :: int) \<le> int (length (list o2)) \<and> (\<forall>(z :: int). z \<in> set (list o2) \<longrightarrow> (0 :: int) \<le> z \<and> z \<le> int (length s)) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length (seq o2)) - (1 :: int) \<longrightarrow> (let ck :: int = seq o2 ! nat k; ck1 :: int = seq o2 ! nat (k + (1 :: int)) in (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> s ! nat z1 < s ! nat z2) \<or> (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> s ! nat z2 \<le> s ! nat z1))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < int (length (seq o2)) \<longrightarrow> seq o2 ! nat i \<le> seq o2 ! nat j) else seq cut ! (0 :: nat) = (0 :: int) \<and> seq cut ! nat (int (length (seq cut)) - (1 :: int)) = int (length s) \<and> (2 :: int) \<le> int (length (list cut)) \<and> (\<forall>(z :: int). z \<in> set (list cut) \<longrightarrow> (0 :: int) \<le> z \<and> z \<le> int (length s)) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length (seq cut)) - (1 :: int) \<longrightarrow> (let ck :: int = seq cut ! nat k; ck1 :: int = seq cut ! nat (k + (1 :: int)) in (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> s ! nat z1 < s ! nat z2) \<or> (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> s ! nat z2 \<le> s ! nat z1))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < int (length (seq cut)) \<longrightarrow> seq cut ! nat i \<le> seq cut ! nat j)))"
  sorry
end
