theory verifythis_2019_ghc_sort_Top_list_seqqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.exn_Exn"
begin
axiomatization where Trans:   "x < z"
 if "x < y"
 and "y < z"
  for x :: "int"
  and y :: "int"
  and z :: "int"
inductive sorted :: "int list \<Rightarrow> bool" where
   Sorted_Nil: "sorted (Nil :: int list)"
 | Sorted_One: "sorted (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two: "x < y \<Longrightarrow> sorted (Cons y l) \<Longrightarrow> sorted (Cons x (Cons y l))" for x :: "int" and y :: "int" and l :: "int list"
axiomatization where sorted_mem:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> x < y) \<and> sorted l \<longleftrightarrow> sorted (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append:   "sorted l1 \<and> sorted l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> x < y) \<longleftrightarrow> sorted (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
axiomatization where Trans1:   "x \<le> z"
 if "x \<le> y"
 and "y \<le> z"
  for x :: "int"
  and y :: "int"
  and z :: "int"
inductive sorted1 :: "int list \<Rightarrow> bool" where
   Sorted_Nil1: "sorted1 (Nil :: int list)"
 | Sorted_One1: "sorted1 (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two1: "x \<le> y \<Longrightarrow> sorted1 (Cons y l) \<Longrightarrow> sorted1 (Cons x (Cons y l))" for x :: "int" and y :: "int" and l :: "int list"
axiomatization where sorted_mem1:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> x \<le> y) \<and> sorted1 l \<longleftrightarrow> sorted1 (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append1:   "sorted1 l1 \<and> sorted1 l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> x \<le> y) \<longleftrightarrow> sorted1 (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
inductive sorted2 :: "int list \<Rightarrow> bool" where
   Sorted_Nil2: "sorted2 (Nil :: int list)"
 | Sorted_One2: "sorted2 (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two2: "y \<le> x \<Longrightarrow> sorted2 (Cons y l) \<Longrightarrow> sorted2 (Cons x (Cons y l))" for y :: "int" and x :: "int" and l :: "int list"
axiomatization where sorted_mem2:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> y \<le> x) \<and> sorted2 l \<longleftrightarrow> sorted2 (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append2:   "sorted2 l1 \<and> sorted2 l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> y \<le> x) \<longleftrightarrow> sorted2 (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
definition compat :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "compat s t \<longleftrightarrow> (case (s, t) of (Cons x _, Cons y _) \<Rightarrow> x \<le> y | (_, _) \<Rightarrow> True)" for s t
axiomatization where rev_append_sorted_incr:   "sorted1 (rev s @ t) \<longleftrightarrow> sorted2 s \<and> sorted1 t \<and> compat s t"
  for s :: "int list"
  and t :: "int list"
axiomatization where rev_append_sorted_decr:   "sorted2 (rev s @ t) \<longleftrightarrow> sorted1 s \<and> sorted2 t \<and> compat t s"
  for s :: "int list"
  and t :: "int list"
definition eqb :: "bool \<Rightarrow> bool \<Rightarrow> bool"
  where "eqb b1 b2 = ((b1 \<longrightarrow> b2) \<and> (b2 \<longrightarrow> b1))" for b1 b2
axiomatization where eqb'spec:   "eqb b1 b2 = True \<longleftrightarrow> b1 = b2"
  for b1 :: "bool"
  and b2 :: "bool"
theorem list_seq'vc:
  shows "[] = rev (Nil :: int list)"
  sorry
end
