theory verifythis_2019_ghc_sort_Top_merge_pairqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.exn_Exn"
begin
axiomatization where Trans:   "x < z"
 if "x < y"
 and "y < z"
  for x :: "int"
  and y :: "int"
  and z :: "int"
inductive sorted :: "int list \<Rightarrow> bool" where
   Sorted_Nil: "sorted (Nil :: int list)"
 | Sorted_One: "sorted (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two: "x < y \<Longrightarrow> sorted (Cons y l) \<Longrightarrow> sorted (Cons x (Cons y l))" for x :: "int" and y :: "int" and l :: "int list"
axiomatization where sorted_mem:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> x < y) \<and> sorted l \<longleftrightarrow> sorted (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append:   "sorted l1 \<and> sorted l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> x < y) \<longleftrightarrow> sorted (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
axiomatization where Trans1:   "x \<le> z"
 if "x \<le> y"
 and "y \<le> z"
  for x :: "int"
  and y :: "int"
  and z :: "int"
inductive sorted1 :: "int list \<Rightarrow> bool" where
   Sorted_Nil1: "sorted1 (Nil :: int list)"
 | Sorted_One1: "sorted1 (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two1: "x \<le> y \<Longrightarrow> sorted1 (Cons y l) \<Longrightarrow> sorted1 (Cons x (Cons y l))" for x :: "int" and y :: "int" and l :: "int list"
axiomatization where sorted_mem1:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> x \<le> y) \<and> sorted1 l \<longleftrightarrow> sorted1 (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append1:   "sorted1 l1 \<and> sorted1 l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> x \<le> y) \<longleftrightarrow> sorted1 (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
inductive sorted2 :: "int list \<Rightarrow> bool" where
   Sorted_Nil2: "sorted2 (Nil :: int list)"
 | Sorted_One2: "sorted2 (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two2: "y \<le> x \<Longrightarrow> sorted2 (Cons y l) \<Longrightarrow> sorted2 (Cons x (Cons y l))" for y :: "int" and x :: "int" and l :: "int list"
axiomatization where sorted_mem2:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> y \<le> x) \<and> sorted2 l \<longleftrightarrow> sorted2 (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append2:   "sorted2 l1 \<and> sorted2 l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> y \<le> x) \<longleftrightarrow> sorted2 (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
definition compat :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "compat s t \<longleftrightarrow> (case (s, t) of (Cons x _, Cons y _) \<Rightarrow> x \<le> y | (_, _) \<Rightarrow> True)" for s t
axiomatization where rev_append_sorted_incr:   "sorted1 (rev s @ t) \<longleftrightarrow> sorted2 s \<and> sorted1 t \<and> compat s t"
  for s :: "int list"
  and t :: "int list"
axiomatization where rev_append_sorted_decr:   "sorted2 (rev s @ t) \<longleftrightarrow> sorted1 s \<and> sorted2 t \<and> compat t s"
  for s :: "int list"
  and t :: "int list"
definition eqb :: "bool \<Rightarrow> bool \<Rightarrow> bool"
  where "eqb b1 b2 = ((b1 \<longrightarrow> b2) \<and> (b2 \<longrightarrow> b1))" for b1 b2
axiomatization where eqb'spec:   "eqb b1 b2 = True \<longleftrightarrow> b1 = b2"
  for b1 :: "bool"
  and b2 :: "bool"
typedecl  list_seq
consts list :: "list_seq \<Rightarrow> int list"
consts seq :: "list_seq \<Rightarrow> int list"
axiomatization where list_seq'invariant:   "seq self = rev (list self)"
  for self :: "list_seq"
definition list_seq'eq :: "list_seq \<Rightarrow> list_seq \<Rightarrow> _"
  where "list_seq'eq a b \<longleftrightarrow> list a = list b \<and> seq a = seq b" for a b
axiomatization where list_seq'inj:   "a = b"
 if "list_seq'eq a b"
  for a :: "list_seq"
  and b :: "list_seq"
consts nil :: "list_seq"
axiomatization where nil'def'0:   "list nil = (Nil :: int list)"
axiomatization where nil'def'1:   "seq nil = []"
consts order :: "int list \<Rightarrow> int list"
axiomatization where order'def:   "case l of Nil \<Rightarrow> order l = l | Cons _ Nil \<Rightarrow> order l = l | Cons h1 (Cons h2 _) \<Rightarrow> (if h1 < h2 then order l = l else order l = rev l)"
 if "sorted l \<or> sorted2 l"
  for l :: "int list"
axiomatization where order'spec'0:   "sorted1 (order l)"
 if "sorted l \<or> sorted2 l"
  for l :: "int list"
axiomatization where order'spec:   "l <~~> order l"
 if "sorted l \<or> sorted2 l"
  for l :: "int list"
consts infix_plpl_closure :: "'a list \<Rightarrow> 'a list \<Rightarrow> 'a list"
axiomatization where infix_plpl_closure_def:   "infix_plpl_closure y y1 = y @ y1"
  for y :: "'a list"
  and y1 :: "'a list"
theorem merge_pair'vc:
  fixes ls :: "int list list"
  assumes fact0: "\<forall>(l :: int list). l \<in> set ls \<longrightarrow> sorted1 l"
  shows "case ls of Nil \<Rightarrow> True | Cons _ Nil \<Rightarrow> True | Cons l1 (Cons l2 r) \<Rightarrow> (((0 :: int) \<le> int (length ls) \<and> length r < length ls) \<and> (\<forall>(l :: int list). l \<in> set r \<longrightarrow> sorted1 l)) \<and> (\<forall>(o1 :: int list list). length o1 \<le> length r \<and> ((1 :: int) < int (length r) \<longrightarrow> (0 :: int) < int (length o1) \<and> length o1 < length r) \<and> (\<forall>(l :: int list). l \<in> set o1 \<longrightarrow> sorted1 l) \<and> foldr infix_plpl_closure o1 (Nil :: int list) <~~> foldr infix_plpl_closure r (Nil :: int list) \<longrightarrow> sorted1 l1 \<and> sorted1 l2)"
  and "\<forall>(result :: int list list). (case ls of Nil \<Rightarrow> result = ls | Cons _ Nil \<Rightarrow> result = ls | Cons l1 (Cons l2 r) \<Rightarrow> (\<exists>(o1 :: int list list). (length o1 \<le> length r \<and> ((1 :: int) < int (length r) \<longrightarrow> (0 :: int) < int (length o1) \<and> length o1 < length r) \<and> (\<forall>(l :: int list). l \<in> set o1 \<longrightarrow> sorted1 l) \<and> foldr infix_plpl_closure o1 (Nil :: int list) <~~> foldr infix_plpl_closure r (Nil :: int list)) \<and> (\<exists>(o2 :: int list). (sorted1 o2 \<and> o2 <~~> l1 @ l2) \<and> result = Cons o2 o1))) \<longrightarrow> length result \<le> length ls \<and> ((1 :: int) < int (length ls) \<longrightarrow> (0 :: int) < int (length result) \<and> length result < length ls) \<and> (\<forall>(l :: int list). l \<in> set result \<longrightarrow> sorted1 l) \<and> foldr infix_plpl_closure result (Nil :: int list) <~~> foldr infix_plpl_closure ls (Nil :: int list)"
  sorry
end
