theory verifythis_2019_ghc_sort_Top_sort_to_listqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.int_NumOf" "Why3STD.exn_Exn"
begin
axiomatization where Trans:   "x < z"
 if "x < y"
 and "y < z"
  for x :: "int"
  and y :: "int"
  and z :: "int"
inductive sorted :: "int list \<Rightarrow> bool" where
   Sorted_Nil: "sorted (Nil :: int list)"
 | Sorted_One: "sorted (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two: "x < y \<Longrightarrow> sorted (Cons y l) \<Longrightarrow> sorted (Cons x (Cons y l))" for x :: "int" and y :: "int" and l :: "int list"
axiomatization where sorted_mem:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> x < y) \<and> sorted l \<longleftrightarrow> sorted (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append:   "sorted l1 \<and> sorted l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> x < y) \<longleftrightarrow> sorted (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
axiomatization where Trans1:   "x \<le> z"
 if "x \<le> y"
 and "y \<le> z"
  for x :: "int"
  and y :: "int"
  and z :: "int"
inductive sorted1 :: "int list \<Rightarrow> bool" where
   Sorted_Nil1: "sorted1 (Nil :: int list)"
 | Sorted_One1: "sorted1 (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two1: "x \<le> y \<Longrightarrow> sorted1 (Cons y l) \<Longrightarrow> sorted1 (Cons x (Cons y l))" for x :: "int" and y :: "int" and l :: "int list"
axiomatization where sorted_mem1:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> x \<le> y) \<and> sorted1 l \<longleftrightarrow> sorted1 (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append1:   "sorted1 l1 \<and> sorted1 l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> x \<le> y) \<longleftrightarrow> sorted1 (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
inductive sorted2 :: "int list \<Rightarrow> bool" where
   Sorted_Nil2: "sorted2 (Nil :: int list)"
 | Sorted_One2: "sorted2 (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two2: "y \<le> x \<Longrightarrow> sorted2 (Cons y l) \<Longrightarrow> sorted2 (Cons x (Cons y l))" for y :: "int" and x :: "int" and l :: "int list"
axiomatization where sorted_mem2:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> y \<le> x) \<and> sorted2 l \<longleftrightarrow> sorted2 (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append2:   "sorted2 l1 \<and> sorted2 l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> y \<le> x) \<longleftrightarrow> sorted2 (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
definition compat :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "compat s t \<longleftrightarrow> (case (s, t) of (Cons x _, Cons y _) \<Rightarrow> x \<le> y | (_, _) \<Rightarrow> True)" for s t
axiomatization where rev_append_sorted_incr:   "sorted1 (rev s @ t) \<longleftrightarrow> sorted2 s \<and> sorted1 t \<and> compat s t"
  for s :: "int list"
  and t :: "int list"
axiomatization where rev_append_sorted_decr:   "sorted2 (rev s @ t) \<longleftrightarrow> sorted1 s \<and> sorted2 t \<and> compat t s"
  for s :: "int list"
  and t :: "int list"
definition eqb :: "bool \<Rightarrow> bool \<Rightarrow> bool"
  where "eqb b1 b2 = ((b1 \<longrightarrow> b2) \<and> (b2 \<longrightarrow> b1))" for b1 b2
axiomatization where eqb'spec:   "eqb b1 b2 = True \<longleftrightarrow> b1 = b2"
  for b1 :: "bool"
  and b2 :: "bool"
typedecl  list_seq
consts list :: "list_seq \<Rightarrow> int list"
consts seq :: "list_seq \<Rightarrow> int list"
axiomatization where list_seq'invariant:   "seq self = rev (list self)"
  for self :: "list_seq"
definition list_seq'eq :: "list_seq \<Rightarrow> list_seq \<Rightarrow> _"
  where "list_seq'eq a b \<longleftrightarrow> list a = list b \<and> seq a = seq b" for a b
axiomatization where list_seq'inj:   "a = b"
 if "list_seq'eq a b"
  for a :: "list_seq"
  and b :: "list_seq"
consts nil :: "list_seq"
axiomatization where nil'def'0:   "list nil = (Nil :: int list)"
axiomatization where nil'def'1:   "seq nil = []"
consts order :: "int list \<Rightarrow> int list"
axiomatization where order'def:   "case l of Nil \<Rightarrow> order l = l | Cons _ Nil \<Rightarrow> order l = l | Cons h1 (Cons h2 _) \<Rightarrow> (if h1 < h2 then order l = l else order l = rev l)"
 if "sorted l \<or> sorted2 l"
  for l :: "int list"
axiomatization where order'spec'0:   "sorted1 (order l)"
 if "sorted l \<or> sorted2 l"
  for l :: "int list"
axiomatization where order'spec:   "l <~~> order l"
 if "sorted l \<or> sorted2 l"
  for l :: "int list"
consts infix_plpl_closure :: "'a list \<Rightarrow> 'a list \<Rightarrow> 'a list"
axiomatization where infix_plpl_closure_def:   "infix_plpl_closure y y1 = y @ y1"
  for y :: "'a list"
  and y1 :: "'a list"
theorem sort_to_list'vc:
  fixes a :: "int list"
  assumes fact0: "(0 :: int) < int (length a)"
  shows "(0 :: int) < int (length a)"
  and "\<forall>(o1 :: list_seq). seq o1 ! (0 :: nat) = (0 :: int) \<and> seq o1 ! nat (int (length (seq o1)) - (1 :: int)) = int (length a) \<and> (2 :: int) \<le> int (length (list o1)) \<and> (\<forall>(z :: int). z \<in> set (list o1) \<longrightarrow> (0 :: int) \<le> z \<and> z \<le> int (length a)) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length (seq o1)) - (1 :: int) \<longrightarrow> (let ck :: int = seq o1 ! nat k; ck1 :: int = seq o1 ! nat (k + (1 :: int)) in (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> a ! nat z1 < a ! nat z2) \<or> (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> a ! nat z2 \<le> a ! nat z1))) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < int (length (seq o1)) \<longrightarrow> seq o1 ! nat i \<le> seq o1 ! nat j) \<longrightarrow> ((0 :: int) < int (length (list o1)) \<and> (\<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < y \<and> y < int (length (seq o1)) \<longrightarrow> seq o1 ! nat x \<le> seq o1 ! nat y) \<and> (\<forall>(z :: int). z \<in> set (list o1) \<longrightarrow> (0 :: int) \<le> z \<and> z \<le> int (length a)) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length (seq o1)) - (1 :: int) \<longrightarrow> (let ck :: int = seq o1 ! nat k; ck1 :: int = seq o1 ! nat (k + (1 :: int)) in (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> a ! nat z1 < a ! nat z2) \<or> (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> a ! nat z2 \<le> a ! nat z1)))) \<and> (\<forall>(o2 :: int list list). (\<forall>(l :: int list). l \<in> set o2 \<longrightarrow> sorted1 l) \<and> (\<forall>(x :: int). count_list (foldr infix_plpl_closure o2 (Nil :: int list)) x = map_occ x (nth a o nat) (seq o1 ! (0 :: nat)) (seq o1 ! nat (int (length (seq o1)) - (1 :: int)))) \<longrightarrow> (\<forall>(l :: int list). l \<in> set o2 \<longrightarrow> sorted1 l) \<and> (\<forall>(res :: int list). sorted1 res \<and> res <~~> foldr infix_plpl_closure o2 (Nil :: int list) \<longrightarrow> sorted1 res \<and> (\<forall>(x :: int). map_occ x (nth a o nat) (0 :: int) (int (length a)) = count_list res x) \<and> length res = length a))"
  sorry
end
