theory verifythis_2019_ghc_sort_Top_sorted_listsqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.exn_Exn"
begin
axiomatization where Trans:   "x < z"
 if "x < y"
 and "y < z"
  for x :: "int"
  and y :: "int"
  and z :: "int"
inductive sorted :: "int list \<Rightarrow> bool" where
   Sorted_Nil: "sorted (Nil :: int list)"
 | Sorted_One: "sorted (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two: "x < y \<Longrightarrow> sorted (Cons y l) \<Longrightarrow> sorted (Cons x (Cons y l))" for x :: "int" and y :: "int" and l :: "int list"
axiomatization where sorted_mem:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> x < y) \<and> sorted l \<longleftrightarrow> sorted (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append:   "sorted l1 \<and> sorted l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> x < y) \<longleftrightarrow> sorted (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
axiomatization where Trans1:   "x \<le> z"
 if "x \<le> y"
 and "y \<le> z"
  for x :: "int"
  and y :: "int"
  and z :: "int"
inductive sorted1 :: "int list \<Rightarrow> bool" where
   Sorted_Nil1: "sorted1 (Nil :: int list)"
 | Sorted_One1: "sorted1 (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two1: "x \<le> y \<Longrightarrow> sorted1 (Cons y l) \<Longrightarrow> sorted1 (Cons x (Cons y l))" for x :: "int" and y :: "int" and l :: "int list"
axiomatization where sorted_mem1:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> x \<le> y) \<and> sorted1 l \<longleftrightarrow> sorted1 (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append1:   "sorted1 l1 \<and> sorted1 l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> x \<le> y) \<longleftrightarrow> sorted1 (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
inductive sorted2 :: "int list \<Rightarrow> bool" where
   Sorted_Nil2: "sorted2 (Nil :: int list)"
 | Sorted_One2: "sorted2 (Cons x (Nil :: int list))" for x :: "int"
 | Sorted_Two2: "y \<le> x \<Longrightarrow> sorted2 (Cons y l) \<Longrightarrow> sorted2 (Cons x (Cons y l))" for y :: "int" and x :: "int" and l :: "int list"
axiomatization where sorted_mem2:   "(\<forall>(y :: int). y \<in> set l \<longrightarrow> y \<le> x) \<and> sorted2 l \<longleftrightarrow> sorted2 (Cons x l)"
  for l :: "int list"
  and x :: "int"
axiomatization where sorted_append2:   "sorted2 l1 \<and> sorted2 l2 \<and> (\<forall>(x :: int) (y :: int). x \<in> set l1 \<longrightarrow> y \<in> set l2 \<longrightarrow> y \<le> x) \<longleftrightarrow> sorted2 (l1 @ l2)"
  for l1 :: "int list"
  and l2 :: "int list"
definition compat :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "compat s t \<longleftrightarrow> (case (s, t) of (Cons x _, Cons y _) \<Rightarrow> x \<le> y | (_, _) \<Rightarrow> True)" for s t
axiomatization where rev_append_sorted_incr:   "sorted1 (rev s @ t) \<longleftrightarrow> sorted2 s \<and> sorted1 t \<and> compat s t"
  for s :: "int list"
  and t :: "int list"
axiomatization where rev_append_sorted_decr:   "sorted2 (rev s @ t) \<longleftrightarrow> sorted1 s \<and> sorted2 t \<and> compat t s"
  for s :: "int list"
  and t :: "int list"
definition eqb :: "bool \<Rightarrow> bool \<Rightarrow> bool"
  where "eqb b1 b2 = ((b1 \<longrightarrow> b2) \<and> (b2 \<longrightarrow> b1))" for b1 b2
axiomatization where eqb'spec:   "eqb b1 b2 = True \<longleftrightarrow> b1 = b2"
  for b1 :: "bool"
  and b2 :: "bool"
typedecl  list_seq
consts list :: "list_seq \<Rightarrow> int list"
consts seq :: "list_seq \<Rightarrow> int list"
axiomatization where list_seq'invariant:   "seq self = rev (list self)"
  for self :: "list_seq"
definition list_seq'eq :: "list_seq \<Rightarrow> list_seq \<Rightarrow> _"
  where "list_seq'eq a b \<longleftrightarrow> list a = list b \<and> seq a = seq b" for a b
axiomatization where list_seq'inj:   "a = b"
 if "list_seq'eq a b"
  for a :: "list_seq"
  and b :: "list_seq"
consts nil :: "list_seq"
axiomatization where nil'def'0:   "list nil = (Nil :: int list)"
axiomatization where nil'def'1:   "seq nil = []"
consts order :: "int list \<Rightarrow> int list"
axiomatization where order'def:   "case l of Nil \<Rightarrow> order l = l | Cons _ Nil \<Rightarrow> order l = l | Cons h1 (Cons h2 _) \<Rightarrow> (if h1 < h2 then order l = l else order l = rev l)"
 if "sorted l \<or> sorted2 l"
  for l :: "int list"
axiomatization where order'spec'0:   "sorted1 (order l)"
 if "sorted l \<or> sorted2 l"
  for l :: "int list"
axiomatization where order'spec:   "l <~~> order l"
 if "sorted l \<or> sorted2 l"
  for l :: "int list"
consts infix_plpl_closure :: "'a list \<Rightarrow> 'a list \<Rightarrow> 'a list"
axiomatization where infix_plpl_closure_def:   "infix_plpl_closure y y1 = y @ y1"
  for y :: "'a list"
  and y1 :: "'a list"
theorem sorted_lists'vc:
  fixes cutp :: "list_seq"
  fixes s :: "int list"
  assumes fact0: "(0 :: int) < int (length (list cutp))"
  assumes fact1: "\<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < y \<and> y < int (length (seq cutp)) \<longrightarrow> seq cutp ! nat x \<le> seq cutp ! nat y"
  assumes fact2: "\<forall>(z :: int). z \<in> set (list cutp) \<longrightarrow> (0 :: int) \<le> z \<and> z \<le> int (length s)"
  assumes fact3: "\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length (seq cutp)) - (1 :: int) \<longrightarrow> (let ck :: int = seq cutp ! nat k; ck1 :: int = seq cutp ! nat (k + (1 :: int)) in (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> s ! nat z1 < s ! nat z2) \<or> (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> s ! nat z2 \<le> s ! nat z1))"
  shows "let ls :: int list = list cutp; seq1 :: int list = seq cutp in (case ls of Nil \<Rightarrow> True | Cons _ Nil \<Rightarrow> True | Cons h1 (Cons h2 t) \<Rightarrow> (((0 :: int) \<le> h2 \<and> h2 \<le> int (length s)) \<and> ((0 :: int) \<le> h1 \<and> h1 \<le> int (length s)) \<and> ((\<forall>(z1 :: int) (z2 :: int). h2 \<le> z1 \<and> z1 < z2 \<and> z2 < h1 \<longrightarrow> s ! nat z1 < s ! nat z2) \<or> (\<forall>(z1 :: int) (z2 :: int). h2 \<le> z1 \<and> z1 < z2 \<and> z2 < h1 \<longrightarrow> s ! nat z2 \<le> s ! nat z1))) \<and> (\<forall>(seqi :: int list). (\<forall>(x :: int). count_list seqi x = map_occ x (nth s o nat) h2 h1) \<and> (\<forall>(x :: int). x \<in> set seqi \<longrightarrow> (\<exists>(z :: int). (h2 \<le> z \<and> z < h1) \<and> s ! nat z = x)) \<and> ((\<forall>(z1 :: int) (z2 :: int). h2 \<le> z1 \<and> z1 < z2 \<and> z2 < h1 \<longrightarrow> s ! nat z1 < s ! nat z2) \<longrightarrow> sorted seqi) \<and> ((\<forall>(z1 :: int) (z2 :: int). h2 \<le> z1 \<and> z1 < z2 \<and> z2 < h1 \<longrightarrow> s ! nat z2 \<le> s ! nat z1) \<longrightarrow> sorted2 seqi) \<and> (sorted seqi \<or> sorted2 seqi) \<longrightarrow> (let o1 :: int = int (length seq1) - (1 :: int) in ((0 :: int) \<le> (0 :: int) \<and> (0 :: int) \<le> o1 \<and> o1 \<le> int (length seq1)) \<and> (let o2 :: int list = drop (0 :: nat) (take (nat o1 - (0 :: nat)) seq1) in int (length o2) = o1 - (0 :: int) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < o1 - (0 :: int) \<longrightarrow> o2 ! nat k = seq1 ! nat ((0 :: int) + k)) \<longrightarrow> (let o3 :: int list = Cons h2 t in o2 = rev o3 \<and> (\<forall>(lseq :: list_seq). list lseq = o3 \<and> seq lseq = o2 \<longrightarrow> ((case list cutp of Nil \<Rightarrow> False | Cons _ f \<Rightarrow> f = list lseq) \<and> (0 :: int) < int (length (list lseq)) \<and> (\<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < y \<and> y < int (length (seq lseq)) \<longrightarrow> seq lseq ! nat x \<le> seq lseq ! nat y) \<and> (\<forall>(z :: int). z \<in> set (list lseq) \<longrightarrow> (0 :: int) \<le> z \<and> z \<le> int (length s)) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length (seq lseq)) - (1 :: int) \<longrightarrow> (let ck :: int = seq lseq ! nat k; ck1 :: int = seq lseq ! nat (k + (1 :: int)) in (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> s ! nat z1 < s ! nat z2) \<or> (\<forall>(z1 :: int) (z2 :: int). ck \<le> z1 \<and> z1 < z2 \<and> z2 < ck1 \<longrightarrow> s ! nat z2 \<le> s ! nat z1)))) \<and> (\<forall>(o4 :: int list list). (\<forall>(l :: int list). l \<in> set o4 \<longrightarrow> sorted1 l) \<and> (\<forall>(x :: int). count_list (foldr infix_plpl_closure o4 (Nil :: int list)) x = map_occ x (nth s o nat) (seq lseq ! (0 :: nat)) (seq lseq ! nat (int (length (seq lseq)) - (1 :: int)))) \<longrightarrow> sorted seqi \<or> sorted2 seqi))))))) \<and> (\<forall>(result :: int list list). (case ls of Nil \<Rightarrow> result = (Nil :: int list list) | Cons _ Nil \<Rightarrow> result = (Nil :: int list list) | Cons h1 (Cons h2 t) \<Rightarrow> (\<exists>(seqi :: int list). ((\<forall>(x :: int). count_list seqi x = map_occ x (nth s o nat) h2 h1) \<and> (\<forall>(x :: int). x \<in> set seqi \<longrightarrow> (\<exists>(z :: int). (h2 \<le> z \<and> z < h1) \<and> s ! nat z = x)) \<and> ((\<forall>(z1 :: int) (z2 :: int). h2 \<le> z1 \<and> z1 < z2 \<and> z2 < h1 \<longrightarrow> s ! nat z1 < s ! nat z2) \<longrightarrow> sorted seqi) \<and> ((\<forall>(z1 :: int) (z2 :: int). h2 \<le> z1 \<and> z1 < z2 \<and> z2 < h1 \<longrightarrow> s ! nat z2 \<le> s ! nat z1) \<longrightarrow> sorted2 seqi) \<and> (sorted seqi \<or> sorted2 seqi)) \<and> (let o1 :: int = int (length seq1) - (1 :: int); o2 :: int list = drop (0 :: nat) (take (nat o1 - (0 :: nat)) seq1) in (int (length o2) = o1 - (0 :: int) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < o1 - (0 :: int) \<longrightarrow> o2 ! nat k = seq1 ! nat ((0 :: int) + k))) \<and> (\<exists>(lseq :: list_seq). (list lseq = Cons h2 t \<and> seq lseq = o2) \<and> (\<exists>(o3 :: int list list). ((\<forall>(l :: int list). l \<in> set o3 \<longrightarrow> sorted1 l) \<and> (\<forall>(x :: int). count_list (foldr infix_plpl_closure o3 (Nil :: int list)) x = map_occ x (nth s o nat) (seq lseq ! (0 :: nat)) (seq lseq ! nat (int (length (seq lseq)) - (1 :: int))))) \<and> (let o4 :: int list = order seqi in (sorted1 o4 \<and> seqi <~~> o4) \<and> result = Cons o4 o3)))))) \<longrightarrow> (\<forall>(l :: int list). l \<in> set result \<longrightarrow> sorted1 l) \<and> (\<forall>(x :: int). count_list (foldr infix_plpl_closure result (Nil :: int list)) x = map_occ x (nth s o nat) (seq cutp ! (0 :: nat)) (seq cutp ! nat (int (length (seq cutp)) - (1 :: int)))))"
  sorry
end
