import Why3.Base
import Why3.why3.Ref.Ref
import Why3.exn.Exn
open Classical
open Lean4Why3
namespace verifythis_2019_ghc_sort_Top_mergerecqtvc
axiom Trans (x : ℤ) (y : ℤ) (z : ℤ) (fact0 : x < y) (fact1 : y < z) : x < z
inductive sorted : List ℤ -> Prop where
 | Sorted_Nil : sorted ([] : List ℤ)
 | Sorted_One (x : ℤ) : sorted (List.cons x ([] : List ℤ))
 | Sorted_Two (x : ℤ) (y : ℤ) (l : List ℤ) : x < y → sorted (List.cons y l) → sorted (List.cons x (List.cons y l))
axiom sorted_mem (l : List ℤ) (x : ℤ) : ((∀(y : ℤ), y ∈ l → x < y) ∧ sorted l) = sorted (List.cons x l)
axiom sorted_append (l1 : List ℤ) (l2 : List ℤ) : (sorted l1 ∧ sorted l2 ∧ (∀(x : ℤ) (y : ℤ), x ∈ l1 → y ∈ l2 → x < y)) = sorted (l1 ++ l2)
axiom Trans1 (x : ℤ) (y : ℤ) (z : ℤ) (fact0 : x ≤ y) (fact1 : y ≤ z) : x ≤ z
inductive sorted1 : List ℤ -> Prop where
 | Sorted_Nil1 : sorted1 ([] : List ℤ)
 | Sorted_One1 (x : ℤ) : sorted1 (List.cons x ([] : List ℤ))
 | Sorted_Two1 (x : ℤ) (y : ℤ) (l : List ℤ) : x ≤ y → sorted1 (List.cons y l) → sorted1 (List.cons x (List.cons y l))
axiom sorted_mem1 (l : List ℤ) (x : ℤ) : ((∀(y : ℤ), y ∈ l → x ≤ y) ∧ sorted1 l) = sorted1 (List.cons x l)
axiom sorted_append1 (l1 : List ℤ) (l2 : List ℤ) : (sorted1 l1 ∧ sorted1 l2 ∧ (∀(x : ℤ) (y : ℤ), x ∈ l1 → y ∈ l2 → x ≤ y)) = sorted1 (l1 ++ l2)
inductive sorted2 : List ℤ -> Prop where
 | Sorted_Nil2 : sorted2 ([] : List ℤ)
 | Sorted_One2 (x : ℤ) : sorted2 (List.cons x ([] : List ℤ))
 | Sorted_Two2 (y : ℤ) (x : ℤ) (l : List ℤ) : y ≤ x → sorted2 (List.cons y l) → sorted2 (List.cons x (List.cons y l))
axiom sorted_mem2 (l : List ℤ) (x : ℤ) : ((∀(y : ℤ), y ∈ l → y ≤ x) ∧ sorted2 l) = sorted2 (List.cons x l)
axiom sorted_append2 (l1 : List ℤ) (l2 : List ℤ) : (sorted2 l1 ∧ sorted2 l2 ∧ (∀(x : ℤ) (y : ℤ), x ∈ l1 → y ∈ l2 → y ≤ x)) = sorted2 (l1 ++ l2)
noncomputable def compat (s : List ℤ) (t : List ℤ) := match (s, t) with | (List.cons x _, List.cons y _) => x ≤ y | (_, _) => True
axiom rev_append_sorted_incr (s : List ℤ) (t : List ℤ) : sorted1 (List.reverse s ++ t) = (sorted2 s ∧ sorted1 t ∧ compat s t)
axiom rev_append_sorted_decr (s : List ℤ) (t : List ℤ) : sorted2 (List.reverse s ++ t) = (sorted1 s ∧ sorted2 t ∧ compat t s)
noncomputable def eqb (b1 : Bool) (b2 : Bool) := Bool.imp b1 b2 && Bool.imp b2 b1
axiom eqb'spec (b1 : Bool) (b2 : Bool) : (eqb b1 b2 = true) = (b1 = b2)
axiom list_seq : Type
axiom inhabited_axiom_list_seq : Inhabited list_seq
attribute [instance] inhabited_axiom_list_seq
axiom list : list_seq -> List ℤ
axiom seq : list_seq -> List ℤ
axiom list_seq'invariant (self : list_seq) : seq self = List.reverse (list self)
noncomputable def list_seq'eq (a : list_seq) (b : list_seq) := list a = list b ∧ seq a = seq b
axiom list_seq'inj (a : list_seq) (b : list_seq) (fact0 : list_seq'eq a b) : a = b
axiom nil : list_seq
axiom nil'def : list nil = ([] : List ℤ) ∧ seq nil = ([] : List ℤ)
axiom order : List ℤ -> List ℤ
axiom order'def (l : List ℤ) (fact0 : sorted l ∨ sorted2 l) : match l with | ([] : List ℤ) => order l = l | List.cons _ ([] : List ℤ) => order l = l | List.cons h1 (List.cons h2 _) => (if h1 < h2 then order l = l else order l = List.reverse l)
axiom order'spec'0 (l : List ℤ) (fact0 : sorted l ∨ sorted2 l) : sorted1 (order l)
axiom order'spec (l : List ℤ) (fact0 : sorted l ∨ sorted2 l) : List.Perm l (order l)
axiom infix_plpl_closure :  {α : Type} -> [Inhabited α] -> List α -> List α -> List α
axiom infix_plpl_closure_def {α : Type} [Inhabited α] (y : List α) (y1 : List α) : infix_plpl_closure y y1 = y ++ y1
theorem mergerec'vc (ls : List (List ℤ)) (fact0 : ∀(l : List ℤ), l ∈ ls → sorted1 l) : (match ls with | ([] : List (List ℤ)) => True | List.cons l ([] : List (List ℤ)) => True | List.cons _ (List.cons _ _) => (∀(l : List ℤ), l ∈ ls → sorted1 l) ∧ (∀(o1 : List (List ℤ)), List.length o1 ≤ List.length ls ∧ ((1 : ℤ) < Int.ofNat (List.length ls) → (0 : ℤ) < Int.ofNat (List.length o1) ∧ List.length o1 < List.length ls) ∧ (∀(l : List ℤ), l ∈ o1 → sorted1 l) ∧ List.Perm (List.foldr' infix_plpl_closure o1 ([] : List ℤ)) (List.foldr' infix_plpl_closure ls ([] : List ℤ)) → ((0 : ℤ) ≤ Int.ofNat (List.length ls) ∧ List.length o1 < List.length ls) ∧ (∀(l : List ℤ), l ∈ o1 → sorted1 l))) ∧ (∀(result : List ℤ), (match ls with | ([] : List (List ℤ)) => result = ([] : List ℤ) | List.cons l ([] : List (List ℤ)) => result = l | List.cons _ (List.cons _ _) => (∃(o1 : List (List ℤ)), (List.length o1 ≤ List.length ls ∧ ((1 : ℤ) < Int.ofNat (List.length ls) → (0 : ℤ) < Int.ofNat (List.length o1) ∧ List.length o1 < List.length ls) ∧ (∀(l : List ℤ), l ∈ o1 → sorted1 l) ∧ List.Perm (List.foldr' infix_plpl_closure o1 ([] : List ℤ)) (List.foldr' infix_plpl_closure ls ([] : List ℤ))) ∧ sorted1 result ∧ List.Perm result (List.foldr' infix_plpl_closure o1 ([] : List ℤ)))) → sorted1 result ∧ List.Perm result (List.foldr' infix_plpl_closure ls ([] : List ℤ)))
  := sorry
end verifythis_2019_ghc_sort_Top_mergerecqtvc
