theory verifythis_2021_dll_to_bst_Top_dll_to_bst_recqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.ocaml_Exceptions" "Why3STD.bintree_Tree" "Why3STD.bintree_Size" "Why3STD.bintree_Height"
begin
typedecl  loc
typedecl 'v t
consts to_fmap :: "'v t \<Rightarrow> (loc, 'v) fmap"
consts null :: "loc"
definition valid :: "(loc, loc) fmap \<Rightarrow> (loc, loc) fmap \<Rightarrow> loc list \<Rightarrow> _"
  where "valid prev next s \<longleftrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length s) \<longrightarrow> \<not>s ! nat i = null \<and> s ! nat i |\<in>| fmdom prev \<and> s ! nat i |\<in>| fmdom next \<and> (\<forall>(j :: int). i < j \<and> j < int (length s) \<longrightarrow> \<not>s ! nat i = s ! nat j))" for prev "next" s
definition dll :: "(loc, loc) fmap \<Rightarrow> (loc, loc) fmap \<Rightarrow> loc list \<Rightarrow> loc \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "dll prev next s head lo hi \<longleftrightarrow> valid prev next s \<and> ((0 :: int) \<le> lo \<and> lo \<le> hi \<and> hi \<le> int (length s)) \<and> head = (if lo = int (length s) then null else s ! nat lo) \<and> (\<forall>(i :: int). lo \<le> i \<and> i < hi - (1 :: int) \<longrightarrow> fm_contents next (s ! nat i) = s ! nat (i + (1 :: int))) \<and> (\<forall>(i :: int). lo < i \<and> i < hi \<longrightarrow> fm_contents prev (s ! nat i) = s ! nat (i - (1 :: int))) \<and> (lo < hi \<longrightarrow> fm_contents next (s ! nat (hi - (1 :: int))) = (if hi = int (length s) then null else s ! nat hi)) \<and> (lo < hi \<longrightarrow> fm_contents prev (s ! nat lo) = (if lo = (0 :: int) then null else s ! nat (lo - (1 :: int))))" for prev "next" s head lo hi
fun tree :: "(loc, loc) fmap \<Rightarrow> (loc, loc) fmap \<Rightarrow> loc list \<Rightarrow> loc \<Rightarrow> int tree \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "tree prev next s root t1 lo hi = (valid prev next s \<and> ((0 :: int) \<le> lo \<and> lo \<le> hi \<and> hi \<le> int (length s)) \<and> (case t1 of (Empty :: int tree) \<Rightarrow> root = null \<and> lo = hi | Node l p r \<Rightarrow> (lo \<le> p \<and> p < hi) \<and> root = s ! nat p \<and> tree prev next s (fm_contents prev root) l lo p \<and> tree prev next s (fm_contents next root) r (p + (1 :: int)) hi))" for prev "next" s root t1 lo hi
theorem dll_to_bst_rec'vc:
  fixes prev :: "loc t"
  fixes "next" :: "loc t"
  fixes s :: "loc list"
  fixes head :: "loc"
  fixes ihead :: "int"
  fixes n :: "int"
  assumes fact0: "dll (to_fmap prev) (to_fmap next) s head ihead (ihead + n)"
  shows "if n = (0 :: int) then head = (if ihead + n = int (length s) then null else s ! nat (ihead + n)) \<and> tree (to_fmap prev) (to_fmap next) s null (Empty :: int tree) ihead (ihead + n) \<and> fmdom (to_fmap prev) = fmdom (to_fmap prev) \<and> fmdom (to_fmap next) = fmdom (to_fmap next) \<and> ((0 :: int) < n \<longrightarrow> (let h :: int = height (Empty :: int tree) in (2 :: int) ^\<^sub>i (h - (1 :: int)) \<le> n \<and> n < (2 :: int) ^\<^sub>i h)) else \<not>(2 :: int) = (0 :: int) \<and> (let nl :: int = n cdiv (2 :: int) in (((0 :: int) \<le> n \<and> nl < n) \<and> dll (to_fmap prev) (to_fmap next) s head ihead (ihead + nl)) \<and> (\<forall>(next1 :: loc t) (prev1 :: loc t) (left1 :: loc) (l :: int tree). tree (to_fmap prev1) (to_fmap next1) s left1 l ihead (ihead + nl) \<and> fmdom (to_fmap prev1) = fmdom (to_fmap prev) \<and> fmdom (to_fmap next1) = fmdom (to_fmap next) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < ihead \<longrightarrow> fm_contents (to_fmap prev1) (s ! nat i) = fm_contents (to_fmap prev) (s ! nat i)) \<and> (\<forall>(i :: int). ihead + nl \<le> i \<and> i < int (length s) \<longrightarrow> fm_contents (to_fmap prev1) (s ! nat i) = fm_contents (to_fmap prev) (s ! nat i)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < ihead \<longrightarrow> fm_contents (to_fmap next1) (s ! nat i) = fm_contents (to_fmap next) (s ! nat i)) \<and> (\<forall>(i :: int). ihead + nl \<le> i \<and> i < int (length s) \<longrightarrow> fm_contents (to_fmap next1) (s ! nat i) = fm_contents (to_fmap next) (s ! nat i)) \<and> ((0 :: int) < nl \<longrightarrow> (let h :: int = height l in (2 :: int) ^\<^sub>i (h - (1 :: int)) \<le> nl \<and> nl < (2 :: int) ^\<^sub>i h)) \<longrightarrow> (if ihead + nl = int (length s) then null else s ! nat (ihead + nl)) |\<in>| fmdom (to_fmap prev1) \<and> (\<forall>(prev2 :: loc t). to_fmap prev2 = fmupd (if ihead + nl = int (length s) then null else s ! nat (ihead + nl)) left1 (to_fmap prev1) \<longrightarrow> (let o1 :: int = n - nl - (1 :: int); o2 :: int = ihead + nl + (1 :: int) in (if ihead + nl = int (length s) then null else s ! nat (ihead + nl)) |\<in>| fmdom (to_fmap next1) \<and> (let o3 :: loc = fm_contents (to_fmap next1) (if ihead + nl = int (length s) then null else s ! nat (ihead + nl)) in o3 = the (fmlookup (to_fmap next1) (if ihead + nl = int (length s) then null else s ! nat (ihead + nl))) \<longrightarrow> (((0 :: int) \<le> n \<and> o1 < n) \<and> dll (to_fmap prev2) (to_fmap next1) s o3 o2 (o2 + o1)) \<and> (\<forall>(next2 :: loc t) (prev3 :: loc t) (temp :: loc) (r :: int tree). tree (to_fmap prev3) (to_fmap next2) s temp r o2 (o2 + o1) \<and> fmdom (to_fmap prev3) = fmdom (to_fmap prev2) \<and> fmdom (to_fmap next2) = fmdom (to_fmap next1) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < o2 \<longrightarrow> fm_contents (to_fmap prev3) (s ! nat i) = fm_contents (to_fmap prev2) (s ! nat i)) \<and> (\<forall>(i :: int). o2 + o1 \<le> i \<and> i < int (length s) \<longrightarrow> fm_contents (to_fmap prev3) (s ! nat i) = fm_contents (to_fmap prev2) (s ! nat i)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < o2 \<longrightarrow> fm_contents (to_fmap next2) (s ! nat i) = fm_contents (to_fmap next1) (s ! nat i)) \<and> (\<forall>(i :: int). o2 + o1 \<le> i \<and> i < int (length s) \<longrightarrow> fm_contents (to_fmap next2) (s ! nat i) = fm_contents (to_fmap next1) (s ! nat i)) \<and> ((0 :: int) < o1 \<longrightarrow> (let h :: int = height r in (2 :: int) ^\<^sub>i (h - (1 :: int)) \<le> o1 \<and> o1 < (2 :: int) ^\<^sub>i h)) \<longrightarrow> (if ihead + nl = int (length s) then null else s ! nat (ihead + nl)) |\<in>| fmdom (to_fmap next2) \<and> (\<forall>(next3 :: loc t). to_fmap next3 = fmupd (if ihead + nl = int (length s) then null else s ! nat (ihead + nl)) temp (to_fmap next2) \<longrightarrow> (let o4 :: int tree = Node l (ihead + nl) r in (if o2 + o1 = int (length s) then null else s ! nat (o2 + o1)) = (if ihead + n = int (length s) then null else s ! nat (ihead + n)) \<and> tree (to_fmap prev3) (to_fmap next3) s (if ihead + nl = int (length s) then null else s ! nat (ihead + nl)) o4 ihead (ihead + n) \<and> fmdom (to_fmap prev3) = fmdom (to_fmap prev) \<and> fmdom (to_fmap next3) = fmdom (to_fmap next) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < ihead \<longrightarrow> fm_contents (to_fmap prev3) (s ! nat i) = fm_contents (to_fmap prev) (s ! nat i)) \<and> (\<forall>(i :: int). ihead + n \<le> i \<and> i < int (length s) \<longrightarrow> fm_contents (to_fmap prev3) (s ! nat i) = fm_contents (to_fmap prev) (s ! nat i)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < ihead \<longrightarrow> fm_contents (to_fmap next3) (s ! nat i) = fm_contents (to_fmap next) (s ! nat i)) \<and> (\<forall>(i :: int). ihead + n \<le> i \<and> i < int (length s) \<longrightarrow> fm_contents (to_fmap next3) (s ! nat i) = fm_contents (to_fmap next) (s ! nat i)) \<and> ((0 :: int) < n \<longrightarrow> (let h :: int = height o4 in (2 :: int) ^\<^sub>i (h - (1 :: int)) \<le> n \<and> n < (2 :: int) ^\<^sub>i h))))))))))"
  sorry
end
