import Why3.Base
import Why3.ocaml.Exceptions
import Why3.bintree.Tree
import Why3.bintree.Size
import Why3.bintree.Height
open Classical
open Lean4Why3
namespace verifythis_2021_dll_to_bst_Top_dll_to_bst_recqtvc
axiom loc : Type
axiom inhabited_axiom_loc : Inhabited loc
attribute [instance] inhabited_axiom_loc
axiom t : Type -> Type
axiom inhabited_axiom_t {χ : Type} [Inhabited χ] : Inhabited (t χ)
attribute [instance] inhabited_axiom_t
axiom to_fmap :  {χ : Type} -> [Inhabited χ] -> t χ -> Finmap (fun (_ : loc) => χ)
axiom null : loc
noncomputable def valid (prev : Finmap (fun (_ : loc) => loc)) (next : Finmap (fun (_ : loc) => loc)) (s : List loc) := ∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length s) → ¬s[Int.toNat i]! = null ∧ s[Int.toNat i]! ∈ prev ∧ s[Int.toNat i]! ∈ next ∧ (∀(j : ℤ), i < j ∧ j < Int.ofNat (List.length s) → ¬s[Int.toNat i]! = s[Int.toNat j]!)
noncomputable def dll (prev : Finmap (fun (_ : loc) => loc)) (next : Finmap (fun (_ : loc) => loc)) (s : List loc) (head : loc) (lo : ℤ) (hi : ℤ) := valid prev next s ∧ ((0 : ℤ) ≤ lo ∧ lo ≤ hi ∧ hi ≤ Int.ofNat (List.length s)) ∧ head = (if lo = Int.ofNat (List.length s) then null else s[Int.toNat lo]!) ∧ (∀(i : ℤ), lo ≤ i ∧ i < hi - (1 : ℤ) → Finmap.lookup! next (s[Int.toNat i]!) = s[Int.toNat (i + (1 : ℤ))]!) ∧ (∀(i : ℤ), lo < i ∧ i < hi → Finmap.lookup! prev (s[Int.toNat i]!) = s[Int.toNat (i - (1 : ℤ))]!) ∧ (lo < hi → Finmap.lookup! next (s[Int.toNat (hi - (1 : ℤ))]!) = (if hi = Int.ofNat (List.length s) then null else s[Int.toNat hi]!)) ∧ (lo < hi → Finmap.lookup! prev (s[Int.toNat lo]!) = (if lo = (0 : ℤ) then null else s[Int.toNat (lo - (1 : ℤ))]!))
noncomputable def tree : Finmap (fun (_ : loc) => loc) -> Finmap (fun (_ : loc) => loc) -> List loc -> loc -> Tree.tree ℤ -> ℤ -> ℤ -> Prop
  | prev, next, s, root, t1, lo, hi => valid prev next s ∧ ((0 : ℤ) ≤ lo ∧ lo ≤ hi ∧ hi ≤ Int.ofNat (List.length s)) ∧ (match t1 with | (Tree.tree.Empty : Tree.tree ℤ) => root = null ∧ lo = hi | Tree.tree.Node l p r => (lo ≤ p ∧ p < hi) ∧ root = s[Int.toNat p]! ∧ tree prev next s (Finmap.lookup! prev root) l lo p ∧ tree prev next s (Finmap.lookup! next root) r (p + (1 : ℤ)) hi)
theorem dll_to_bst_rec'vc (prev : t loc) (next : t loc) (s : List loc) (head : loc) (ihead : ℤ) (n : ℤ) (fact0 : dll (to_fmap prev) (to_fmap next) s head ihead (ihead + n)) : if n = (0 : ℤ) then head = (if ihead + n = Int.ofNat (List.length s) then null else s[Int.toNat (ihead + n)]!) ∧ tree (to_fmap prev) (to_fmap next) s null (Tree.tree.Empty : Tree.tree ℤ) ihead (ihead + n) ∧ Finmap.keys (to_fmap prev) = Finmap.keys (to_fmap prev) ∧ Finmap.keys (to_fmap next) = Finmap.keys (to_fmap next) ∧ ((0 : ℤ) < n → (let h : ℤ := Height.height (Tree.tree.Empty : Tree.tree ℤ); HPow.hPow (2 : ℤ) (Int.toNat (h - (1 : ℤ))) ≤ n ∧ n < HPow.hPow (2 : ℤ) (Int.toNat h))) else ¬(2 : ℤ) = (0 : ℤ) ∧ (let nl : ℤ := Int.tdiv n (2 : ℤ); (((0 : ℤ) ≤ n ∧ nl < n) ∧ dll (to_fmap prev) (to_fmap next) s head ihead (ihead + nl)) ∧ (∀(next1 : t loc) (prev1 : t loc) (left1 : loc) (l : Tree.tree ℤ), tree (to_fmap prev1) (to_fmap next1) s left1 l ihead (ihead + nl) ∧ Finmap.keys (to_fmap prev1) = Finmap.keys (to_fmap prev) ∧ Finmap.keys (to_fmap next1) = Finmap.keys (to_fmap next) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < ihead → Finmap.lookup! (to_fmap prev1) (s[Int.toNat i]!) = Finmap.lookup! (to_fmap prev) (s[Int.toNat i]!)) ∧ (∀(i : ℤ), ihead + nl ≤ i ∧ i < Int.ofNat (List.length s) → Finmap.lookup! (to_fmap prev1) (s[Int.toNat i]!) = Finmap.lookup! (to_fmap prev) (s[Int.toNat i]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < ihead → Finmap.lookup! (to_fmap next1) (s[Int.toNat i]!) = Finmap.lookup! (to_fmap next) (s[Int.toNat i]!)) ∧ (∀(i : ℤ), ihead + nl ≤ i ∧ i < Int.ofNat (List.length s) → Finmap.lookup! (to_fmap next1) (s[Int.toNat i]!) = Finmap.lookup! (to_fmap next) (s[Int.toNat i]!)) ∧ ((0 : ℤ) < nl → (let h : ℤ := Height.height l; HPow.hPow (2 : ℤ) (Int.toNat (h - (1 : ℤ))) ≤ nl ∧ nl < HPow.hPow (2 : ℤ) (Int.toNat h))) → (if ihead + nl = Int.ofNat (List.length s) then null else s[Int.toNat (ihead + nl)]!) ∈ to_fmap prev1 ∧ (∀(prev2 : t loc), to_fmap prev2 = Finmap.insert (if ihead + nl = Int.ofNat (List.length s) then null else s[Int.toNat (ihead + nl)]!) left1 (to_fmap prev1) → (let o1 : ℤ := n - nl - (1 : ℤ); let o2 : ℤ := ihead + nl + (1 : ℤ); (if ihead + nl = Int.ofNat (List.length s) then null else s[Int.toNat (ihead + nl)]!) ∈ to_fmap next1 ∧ (let o3 : loc := Finmap.lookup! (to_fmap next1) (if ihead + nl = Int.ofNat (List.length s) then null else s[Int.toNat (ihead + nl)]!); o3 = Option.the (Finmap.lookup (if ihead + nl = Int.ofNat (List.length s) then null else s[Int.toNat (ihead + nl)]!) (to_fmap next1)) → (((0 : ℤ) ≤ n ∧ o1 < n) ∧ dll (to_fmap prev2) (to_fmap next1) s o3 o2 (o2 + o1)) ∧ (∀(next2 : t loc) (prev3 : t loc) (temp : loc) (r : Tree.tree ℤ), tree (to_fmap prev3) (to_fmap next2) s temp r o2 (o2 + o1) ∧ Finmap.keys (to_fmap prev3) = Finmap.keys (to_fmap prev2) ∧ Finmap.keys (to_fmap next2) = Finmap.keys (to_fmap next1) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < o2 → Finmap.lookup! (to_fmap prev3) (s[Int.toNat i]!) = Finmap.lookup! (to_fmap prev2) (s[Int.toNat i]!)) ∧ (∀(i : ℤ), o2 + o1 ≤ i ∧ i < Int.ofNat (List.length s) → Finmap.lookup! (to_fmap prev3) (s[Int.toNat i]!) = Finmap.lookup! (to_fmap prev2) (s[Int.toNat i]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < o2 → Finmap.lookup! (to_fmap next2) (s[Int.toNat i]!) = Finmap.lookup! (to_fmap next1) (s[Int.toNat i]!)) ∧ (∀(i : ℤ), o2 + o1 ≤ i ∧ i < Int.ofNat (List.length s) → Finmap.lookup! (to_fmap next2) (s[Int.toNat i]!) = Finmap.lookup! (to_fmap next1) (s[Int.toNat i]!)) ∧ ((0 : ℤ) < o1 → (let h : ℤ := Height.height r; HPow.hPow (2 : ℤ) (Int.toNat (h - (1 : ℤ))) ≤ o1 ∧ o1 < HPow.hPow (2 : ℤ) (Int.toNat h))) → (if ihead + nl = Int.ofNat (List.length s) then null else s[Int.toNat (ihead + nl)]!) ∈ to_fmap next2 ∧ (∀(next3 : t loc), to_fmap next3 = Finmap.insert (if ihead + nl = Int.ofNat (List.length s) then null else s[Int.toNat (ihead + nl)]!) temp (to_fmap next2) → (let o4 : Tree.tree ℤ := Tree.tree.Node l (ihead + nl) r; (if o2 + o1 = Int.ofNat (List.length s) then null else s[Int.toNat (o2 + o1)]!) = (if ihead + n = Int.ofNat (List.length s) then null else s[Int.toNat (ihead + n)]!) ∧ tree (to_fmap prev3) (to_fmap next3) s (if ihead + nl = Int.ofNat (List.length s) then null else s[Int.toNat (ihead + nl)]!) o4 ihead (ihead + n) ∧ Finmap.keys (to_fmap prev3) = Finmap.keys (to_fmap prev) ∧ Finmap.keys (to_fmap next3) = Finmap.keys (to_fmap next) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < ihead → Finmap.lookup! (to_fmap prev3) (s[Int.toNat i]!) = Finmap.lookup! (to_fmap prev) (s[Int.toNat i]!)) ∧ (∀(i : ℤ), ihead + n ≤ i ∧ i < Int.ofNat (List.length s) → Finmap.lookup! (to_fmap prev3) (s[Int.toNat i]!) = Finmap.lookup! (to_fmap prev) (s[Int.toNat i]!)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < ihead → Finmap.lookup! (to_fmap next3) (s[Int.toNat i]!) = Finmap.lookup! (to_fmap next) (s[Int.toNat i]!)) ∧ (∀(i : ℤ), ihead + n ≤ i ∧ i < Int.ofNat (List.length s) → Finmap.lookup! (to_fmap next3) (s[Int.toNat i]!) = Finmap.lookup! (to_fmap next) (s[Int.toNat i]!)) ∧ ((0 : ℤ) < n → (let h : ℤ := Height.height o4; HPow.hPow (2 : ℤ) (Int.toNat (h - (1 : ℤ))) ≤ n ∧ n < HPow.hPow (2 : ℤ) (Int.toNat h)))))))))))
  := sorry
end verifythis_2021_dll_to_bst_Top_dll_to_bst_recqtvc
