theory verifythis_2021_lexicographic_permutations_1_Top_nextqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.int_NumOf"
begin
typedecl  elt
typedecl  permutation
definition lt :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "lt p q \<longleftrightarrow> (length p = length q \<and> (0 :: int) < int (length q)) \<and> (\<exists>(i :: int). ((0 :: int) \<le> i \<and> i < int (length p)) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i \<longrightarrow> p ! nat j = q ! nat j) \<and> p ! nat i < q ! nat i)" for p q
consts iseq :: "'a \<Rightarrow> 'a list \<Rightarrow> int \<Rightarrow> bool"
axiomatization where iseq'def:   "iseq x s i = True \<longleftrightarrow> s ! nat i = x"
  for x :: "'a"
  and s :: "'a list"
  and i :: "int"
definition occ :: "'a \<Rightarrow> 'a list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
  where "occ x s l u = numof (iseq x s) l u" for x s l u
definition occ_all :: "'a \<Rightarrow> 'a list \<Rightarrow> int"
  where "occ_all x s = occ x s (0 :: int) (int (length s))" for x s
definition is_permutation_of :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "is_permutation_of p a \<longleftrightarrow> length p = length a \<and> (\<forall>(x :: int). occ_all x p = occ_all x a)" for p a
definition descending :: "int list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "descending s lo hi \<longleftrightarrow> ((0 :: int) \<le> lo \<and> lo \<le> hi \<and> hi \<le> int (length s)) \<and> (\<forall>(i :: int) (j :: int). lo \<le> i \<and> i \<le> j \<and> j < hi \<longrightarrow> s ! nat j \<le> s ! nat i)" for s lo hi
definition ascending :: "int list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "ascending s lo hi \<longleftrightarrow> ((0 :: int) \<le> lo \<and> lo \<le> hi \<and> hi \<le> int (length s)) \<and> (\<forall>(i :: int) (j :: int). lo \<le> i \<and> i \<le> j \<and> j < hi \<longrightarrow> s ! nat i \<le> s ! nat j)" for s lo hi
consts to_seq :: "int list \<Rightarrow> int list"
axiomatization where to_seq'spec'0:   "length (to_seq a) = length a"
  for a :: "int list"
axiomatization where to_seq'spec:   "to_seq a ! nat i = a ! nat i"
 if "(0 :: int) \<le> i"
 and "i < int (length (to_seq a))"
  for i :: "int"
  and a :: "int list"
theorem next'vc:
  fixes a :: "int list"
  fixes a0 :: "int list"
  assumes fact0: "length a = length a0"
  assumes fact1: "is_permutation_of (to_seq a) a0"
  shows "let n :: int = int (length a); o1 :: int = n - (1 :: int) in ((-(1 :: int) \<le> o1 \<and> o1 < n) \<and> (o1 = -(1 :: int) \<and> n = (0 :: int) \<or> (0 :: int) \<le> o1 \<and> descending (to_seq a) o1 n)) \<and> (\<forall>(i :: int). (-(1 :: int) \<le> i \<and> i < n) \<and> (i = -(1 :: int) \<and> n = (0 :: int) \<or> (0 :: int) \<le> i \<and> descending (to_seq a) i n) \<longrightarrow> ((0 :: int) < i \<longrightarrow> ((0 :: int) \<le> i \<and> i < int (length a)) \<and> (let o2 :: int = i - (1 :: int) in (0 :: int) \<le> o2 \<and> o2 < int (length a))) \<and> (\<forall>(o2 :: bool). (if (0 :: int) < i then o2 = (if a ! nat i \<le> a ! nat (i - (1 :: int)) then True else False) else o2 = False) \<longrightarrow> (if o2 = True then ((0 :: int) \<le> i \<and> i - (1 :: int) < i) \<and> (-(1 :: int) \<le> i - (1 :: int) \<and> i - (1 :: int) < n) \<and> (i - (1 :: int) = -(1 :: int) \<and> n = (0 :: int) \<or> (0 :: int) \<le> i - (1 :: int) \<and> descending (to_seq a) (i - (1 :: int)) n) else if i \<le> (0 :: int) then is_permutation_of (to_seq a) a0 \<and> (\<forall>(p :: int list). is_permutation_of p a0 \<longrightarrow> \<not>lt (to_seq a) p) else let i0 :: int = i - (1 :: int) in ((0 :: int) \<le> i0 \<and> i0 < int (length a)) \<and> (let x :: int = a ! nat i0; o3 :: int = n - (1 :: int) in ((i \<le> o3 \<and> o3 < n) \<and> (\<forall>(k :: int). o3 < k \<and> k < n \<longrightarrow> a ! nat k \<le> x)) \<and> (\<forall>(j :: int). (i \<le> j \<and> j < n) \<and> (\<forall>(k :: int). j < k \<and> k < n \<longrightarrow> a ! nat k \<le> x) \<longrightarrow> (let o4 :: int = i - (1 :: int) in ((0 :: int) \<le> o4 \<and> o4 < int (length a)) \<and> ((0 :: int) \<le> j \<and> j < int (length a)) \<and> (if a ! nat j \<le> a ! nat o4 then ((0 :: int) \<le> j \<and> j - (1 :: int) < j) \<and> (i \<le> j - (1 :: int) \<and> j - (1 :: int) < n) \<and> (\<forall>(k :: int). j - (1 :: int) < k \<and> k < n \<longrightarrow> a ! nat k \<le> x) else ((0 :: int) \<le> j \<and> j < int (length a)) \<and> (let z :: int = a ! nat j; o5 :: int = i - (1 :: int) in (((0 :: int) \<le> o5 \<and> o5 < int (length a)) \<and> (0 :: int) \<le> j \<and> j < int (length a)) \<and> (\<forall>(a1 :: int list). length a1 = length a \<longrightarrow> a1 ! nat o5 = a ! nat j \<and> a1 ! nat j = a ! nat o5 \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length a1) \<longrightarrow> \<not>k = o5 \<longrightarrow> \<not>k = j \<longrightarrow> a1 ! nat k = a ! nat k) \<and> is_permutation_of (to_seq a1) (to_seq a) \<longrightarrow> ((i0 < i \<and> i0 < n - (1 :: int) \<and> n - (1 :: int) < n) \<and> is_permutation_of (to_seq a1) a0 \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < i0 \<longrightarrow> a1 ! nat k = a ! nat k) \<and> a1 ! nat i0 = z \<and> i - i0 = n - (n - (1 :: int)) \<and> (\<forall>(k :: int). (0 :: int) < k \<and> k < i - i0 \<longrightarrow> a1 ! nat (i0 + k) = a1 ! nat (n - k) \<and> a1 ! nat (n - k) = a1 ! nat (i0 + k))) \<and> (\<forall>(j1 :: int) (i1 :: int) (a2 :: int list). length a2 = length a1 \<longrightarrow> (i0 < i1 \<and> i0 < j1 \<and> j1 < n) \<and> is_permutation_of (to_seq a2) a0 \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < i0 \<longrightarrow> a2 ! nat k = a ! nat k) \<and> a2 ! nat i0 = z \<and> i1 - i0 = n - j1 \<and> (\<forall>(k :: int). i1 \<le> k \<and> k \<le> j1 \<longrightarrow> a2 ! nat k = a1 ! nat k) \<and> (\<forall>(k :: int). (0 :: int) < k \<and> k < i1 - i0 \<longrightarrow> a2 ! nat (i0 + k) = a1 ! nat (n - k) \<and> a2 ! nat (n - k) = a1 ! nat (i0 + k)) \<longrightarrow> (if i1 < j1 then (((0 :: int) \<le> i1 \<and> i1 < int (length a2)) \<and> (0 :: int) \<le> j1 \<and> j1 < int (length a2)) \<and> (\<forall>(a3 :: int list). length a3 = length a2 \<longrightarrow> a3 ! nat i1 = a2 ! nat j1 \<and> a3 ! nat j1 = a2 ! nat i1 \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length a3) \<longrightarrow> \<not>k = i1 \<longrightarrow> \<not>k = j1 \<longrightarrow> a3 ! nat k = a2 ! nat k) \<and> is_permutation_of (to_seq a3) (to_seq a2) \<longrightarrow> ((0 :: int) \<le> j1 - i1 \<and> j1 - (1 :: int) - (i1 + (1 :: int)) < j1 - i1) \<and> (i0 < i1 + (1 :: int) \<and> i0 < j1 - (1 :: int) \<and> j1 - (1 :: int) < n) \<and> is_permutation_of (to_seq a3) a0 \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < i0 \<longrightarrow> a3 ! nat k = a ! nat k) \<and> a3 ! nat i0 = z \<and> i1 + (1 :: int) - i0 = n - (j1 - (1 :: int)) \<and> (\<forall>(k :: int). i1 + (1 :: int) \<le> k \<and> k \<le> j1 - (1 :: int) \<longrightarrow> a3 ! nat k = a1 ! nat k) \<and> (\<forall>(k :: int). (0 :: int) < k \<and> k < i1 + (1 :: int) - i0 \<longrightarrow> a3 ! nat (i0 + k) = a1 ! nat (n - k) \<and> a3 ! nat (n - k) = a1 ! nat (i0 + k))) else (\<forall>(p :: int list). is_permutation_of p a0 \<and> lt (to_seq a) p \<and> lt p (to_seq a2) \<longrightarrow> (let a11 :: int list = to_seq a; v :: int = p ! nat i0 in if v = x then let o6 :: int = n - (1 :: int); o7 :: int = i0 + (1 :: int) in (o7 \<le> o6 + (1 :: int) \<longrightarrow> (\<forall>(k :: int). i0 + (1 :: int) \<le> k \<and> k < o7 \<longrightarrow> p ! nat k = a11 ! nat k) \<and> (\<forall>(l :: int). (o7 \<le> l \<and> l \<le> o6) \<and> (\<forall>(k :: int). i0 + (1 :: int) \<le> k \<and> k < l \<longrightarrow> p ! nat k = a11 ! nat k) \<longrightarrow> p ! nat l = a11 ! nat l \<and> (\<forall>(k :: int). i0 + (1 :: int) \<le> k \<and> k < l + (1 :: int) \<longrightarrow> p ! nat k = a11 ! nat k)) \<and> \<not>(\<forall>(k :: int). i0 + (1 :: int) \<le> k \<and> k < o6 + (1 :: int) \<longrightarrow> p ! nat k = a11 ! nat k)) \<and> \<not>o6 + (1 :: int) < o7 else v = z \<and> (let a21 :: int list = to_seq a2 in length a21 = length a2 \<and> (\<forall>(i2 :: int). (0 :: int) \<le> i2 \<and> i2 < int (length a21) \<longrightarrow> a21 ! nat i2 = a2 ! nat i2) \<longrightarrow> (let o6 :: int = n - (1 :: int); o7 :: int = i0 + (1 :: int) in (o7 \<le> o6 + (1 :: int) \<longrightarrow> (\<forall>(k :: int). i0 + (1 :: int) \<le> k \<and> k < o7 \<longrightarrow> p ! nat k = a21 ! nat k) \<and> (\<forall>(l :: int). (o7 \<le> l \<and> l \<le> o6) \<and> (\<forall>(k :: int). i0 + (1 :: int) \<le> k \<and> k < l \<longrightarrow> p ! nat k = a21 ! nat k) \<longrightarrow> p ! nat l = a21 ! nat l \<and> (\<forall>(k :: int). i0 + (1 :: int) \<le> k \<and> k < l + (1 :: int) \<longrightarrow> p ! nat k = a21 ! nat k)) \<and> \<not>(\<forall>(k :: int). i0 + (1 :: int) \<le> k \<and> k < o6 + (1 :: int) \<longrightarrow> p ! nat k = a21 ! nat k)) \<and> \<not>o6 + (1 :: int) < o7)))) \<and> ((\<forall>(p :: int list). \<not>(is_permutation_of p a0 \<and> lt (to_seq a) p \<and> lt p (to_seq a2))) \<longrightarrow> is_permutation_of (to_seq a2) a0 \<and> lt (to_seq a) (to_seq a2) \<and> (\<forall>(p :: int list). is_permutation_of p a0 \<longrightarrow> \<not>(lt (to_seq a) p \<and> lt p (to_seq a2)))))))))))))))"
  sorry
end
