theory verifythis_2021_lexicographic_permutations_1_Top_permutqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.int_NumOf"
begin
typedecl  elt
typedecl  permutation
definition lt :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "lt p q \<longleftrightarrow> (length p = length q \<and> (0 :: int) < int (length q)) \<and> (\<exists>(i :: int). ((0 :: int) \<le> i \<and> i < int (length p)) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i \<longrightarrow> p ! nat j = q ! nat j) \<and> p ! nat i < q ! nat i)" for p q
consts iseq :: "'a \<Rightarrow> 'a list \<Rightarrow> int \<Rightarrow> bool"
axiomatization where iseq'def:   "iseq x s i = True \<longleftrightarrow> s ! nat i = x"
  for x :: "'a"
  and s :: "'a list"
  and i :: "int"
definition occ :: "'a \<Rightarrow> 'a list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
  where "occ x s l u = numof (iseq x s) l u" for x s l u
definition occ_all :: "'a \<Rightarrow> 'a list \<Rightarrow> int"
  where "occ_all x s = occ x s (0 :: int) (int (length s))" for x s
definition is_permutation_of :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "is_permutation_of p a \<longleftrightarrow> length p = length a \<and> (\<forall>(x :: int). occ_all x p = occ_all x a)" for p a
definition descending :: "int list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "descending s lo hi \<longleftrightarrow> ((0 :: int) \<le> lo \<and> lo \<le> hi \<and> hi \<le> int (length s)) \<and> (\<forall>(i :: int) (j :: int). lo \<le> i \<and> i \<le> j \<and> j < hi \<longrightarrow> s ! nat j \<le> s ! nat i)" for s lo hi
definition ascending :: "int list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "ascending s lo hi \<longleftrightarrow> ((0 :: int) \<le> lo \<and> lo \<le> hi \<and> hi \<le> int (length s)) \<and> (\<forall>(i :: int) (j :: int). lo \<le> i \<and> i \<le> j \<and> j < hi \<longrightarrow> s ! nat i \<le> s ! nat j)" for s lo hi
consts to_seq :: "int list \<Rightarrow> int list"
axiomatization where to_seq'spec'0:   "length (to_seq a) = length a"
  for a :: "int list"
axiomatization where to_seq'spec:   "to_seq a ! nat i = a ! nat i"
 if "(0 :: int) \<le> i"
 and "i < int (length (to_seq a))"
  for i :: "int"
  and a :: "int list"
consts all_permutations :: "int list \<Rightarrow> int list fset"
axiomatization where all_permutations'spec:   "p |\<in>| all_permutations s"
 if "is_permutation_of p s"
  for p :: "int list"
  and s :: "int list"
theorem permut'vc:
  fixes a :: "int list"
  shows "let a0 :: int list = to_seq a in length a0 = length a \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length a0) \<longrightarrow> a0 ! nat i = a ! nat i) \<longrightarrow> (let all1 :: int list fset = all_permutations a0 in (\<forall>(p :: int list). is_permutation_of p a0 \<longrightarrow> p |\<in>| all1) \<longrightarrow> (\<forall>(a1 :: int list). length a1 = length a \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i \<le> j \<and> j < int (length a1) \<longrightarrow> a1 ! nat i \<le> a1 ! nat j) \<and> is_permutation_of (to_seq a1) (to_seq a) \<longrightarrow> (let o1 :: int list = to_seq a1 in length o1 = length a1 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o1) \<longrightarrow> o1 ! nat i = a1 ! nat i) \<longrightarrow> (let o2 :: int list list = []; o3 :: int list list = o2 @ [o1] in int (length o3) = (1 :: int) + int (length o2) \<and> o3 ! length o2 = o1 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o2) \<longrightarrow> o3 ! nat i = o2 ! nat i) \<longrightarrow> (let o4 :: int list = to_seq a1 in length o4 = length a1 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o4) \<longrightarrow> o4 ! nat i = a1 ! nat i) \<longrightarrow> (let o5 :: int list = to_seq a1 in length o5 = length a1 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o5) \<longrightarrow> o5 ! nat i = a1 ! nat i) \<longrightarrow> (let o6 :: int list fset = finsert o5 fempty in ((0 :: int) < int (length o3) \<and> is_permutation_of (to_seq a1) a0 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o3) \<longrightarrow> is_permutation_of (o3 ! nat i) a0) \<and> (o4 = o3 ! nat (int (length o3) - (1 :: int)) \<and> o3 ! nat (int (length o3) - (1 :: int)) = to_seq a1) \<and> is_permutation_of o4 a0 \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < int (length o3) \<longrightarrow> lt (o3 ! nat i) (o3 ! nat j)) \<and> (\<forall>(p :: int list). is_permutation_of p a0 \<longrightarrow> lt p o4 \<longrightarrow> (\<exists>(i :: int). ((0 :: int) \<le> i \<and> i < int (length o3) - (1 :: int)) \<and> o3 ! nat i = p)) \<and> (\<forall>(p :: int list). p |\<in>| o6 \<longleftrightarrow> (\<exists>(i :: int). ((0 :: int) \<le> i \<and> i < int (length o3)) \<and> o3 ! nat i = p)) \<and> o6 |\<subseteq>| all1) \<and> (\<forall>(sresult :: int list fset) (result :: int list list) (a2 :: int list). length a2 = length a1 \<longrightarrow> (0 :: int) < int (length result) \<and> is_permutation_of (to_seq a2) a0 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length result) \<longrightarrow> is_permutation_of (result ! nat i) a0) \<and> result ! nat (int (length result) - (1 :: int)) = to_seq a2 \<and> is_permutation_of (result ! nat (int (length result) - (1 :: int))) a0 \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < int (length result) \<longrightarrow> lt (result ! nat i) (result ! nat j)) \<and> (\<forall>(p :: int list). is_permutation_of p a0 \<longrightarrow> lt p (result ! nat (int (length result) - (1 :: int))) \<longrightarrow> (\<exists>(i :: int). ((0 :: int) \<le> i \<and> i < int (length result) - (1 :: int)) \<and> result ! nat i = p)) \<and> (\<forall>(p :: int list). p |\<in>| sresult \<longleftrightarrow> (\<exists>(i :: int). ((0 :: int) \<le> i \<and> i < int (length result)) \<and> result ! nat i = p)) \<and> sresult |\<subseteq>| all1 \<longrightarrow> (length a2 = length a0 \<and> is_permutation_of (to_seq a2) a0) \<and> (\<forall>(a3 :: int list). length a3 = length a2 \<longrightarrow> (\<forall>(o7 :: bool). is_permutation_of (to_seq a3) a0 \<and> (\<not>o7 = True \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length a3) \<longrightarrow> a3 ! nat i = a2 ! nat i)) \<and> (\<not>o7 = True \<longrightarrow> (\<forall>(p :: int list). is_permutation_of p a0 \<longrightarrow> \<not>lt (to_seq a3) p)) \<and> (o7 = True \<longrightarrow> lt (to_seq a2) (to_seq a3)) \<and> (o7 = True \<longrightarrow> (\<forall>(p :: int list). is_permutation_of p a0 \<longrightarrow> \<not>(lt (to_seq a2) p \<and> lt p (to_seq a3)))) \<longrightarrow> (if o7 = True then let o8 :: int list = to_seq a3 in length o8 = length a3 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o8) \<longrightarrow> o8 ! nat i = a3 ! nat i) \<longrightarrow> (let o9 :: int list list = result @ [o8] in int (length o9) = (1 :: int) + int (length result) \<and> o9 ! length result = o8 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length result) \<longrightarrow> o9 ! nat i = result ! nat i) \<longrightarrow> (let o10 :: int list = to_seq a3 in length o10 = length a3 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o10) \<longrightarrow> o10 ! nat i = a3 ! nat i) \<longrightarrow> (let o11 :: int list = to_seq a3 in length o11 = length a3 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o11) \<longrightarrow> o11 ! nat i = a3 ! nat i) \<longrightarrow> ((0 :: int) \<le> int (fcard all1) - int (fcard sresult) \<and> int (fcard all1) - int (fcard (finsert o11 sresult)) < int (fcard all1) - int (fcard sresult)) \<and> (0 :: int) < int (length o9) \<and> is_permutation_of (to_seq a3) a0 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o9) \<longrightarrow> is_permutation_of (o9 ! nat i) a0) \<and> (o10 = o9 ! nat (int (length o9) - (1 :: int)) \<and> o9 ! nat (int (length o9) - (1 :: int)) = to_seq a3) \<and> is_permutation_of o10 a0 \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < int (length o9) \<longrightarrow> lt (o9 ! nat i) (o9 ! nat j)) \<and> (\<forall>(p :: int list). is_permutation_of p a0 \<longrightarrow> lt p o10 \<longrightarrow> (\<exists>(i :: int). ((0 :: int) \<le> i \<and> i < int (length o9) - (1 :: int)) \<and> o9 ! nat i = p)) \<and> (\<forall>(p :: int list). p |\<in>| finsert o11 sresult \<longleftrightarrow> (\<exists>(i :: int). ((0 :: int) \<le> i \<and> i < int (length o9)) \<and> o9 ! nat i = p)) \<and> finsert o11 sresult |\<subseteq>| all1))) else (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length result) \<longrightarrow> is_permutation_of (result ! nat i) (to_seq a)) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < int (length result) \<longrightarrow> lt (result ! nat i) (result ! nat j)) \<and> (\<forall>(p :: int list). is_permutation_of p (to_seq a) \<longrightarrow> (\<exists>(i :: int). ((0 :: int) \<le> i \<and> i < int (length result)) \<and> result ! nat i = p)))))))))))))"
  sorry
end
