theory verifythis_2021_lexicographic_permutations_2_Permut_eq_le_compatqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.map_MapEq" "Why3STD.map_MapExchange" "Why3STD.map_MapPermut" "Why3STD.array_IntArraySorted"
begin
definition sorted_sub :: "int list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "sorted_sub a l u \<longleftrightarrow> (\<forall>(i1 :: int) (i2 :: int). l \<le> i1 \<and> i1 < i2 \<and> i2 < u \<longrightarrow> a ! nat i2 \<le> a ! nat i1)" for a l u
definition sorted :: "int list \<Rightarrow> _"
  where "sorted a \<longleftrightarrow> (\<forall>(i1 :: int) (i2 :: int). (0 :: int) \<le> i1 \<and> i1 < i2 \<and> i2 < int (length a) \<longrightarrow> a ! nat i2 \<le> a ! nat i1)" for a
definition le :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "le a1 a2 \<longleftrightarrow> length a1 = length a2 \<and> (\<exists>(i :: int). ((0 :: int) \<le> i \<and> i \<le> int (length a1)) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i \<longrightarrow> a1 ! nat j = a2 ! nat j) \<and> (i < int (length a1) \<longrightarrow> a1 ! nat i < a2 ! nat i))" for a1 a2
definition lt :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "lt a1 a2 \<longleftrightarrow> le a1 a2 \<and> \<not>a1 = a2" for a1 a2
consts find_eq :: "int list \<Rightarrow> int list \<Rightarrow> int \<Rightarrow> int"
axiomatization where find_eq'def:   "if i = int (length a1) \<or> \<not>a1 ! nat i = a2 ! nat i then find_eq a1 a2 i = i else find_eq a1 a2 i = find_eq a1 a2 (i + (1 :: int))"
 if "length a1 = length a2"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a1)"
 and "drop (0 :: nat) (take (nat i - (0 :: nat)) a1) = drop (0 :: nat) (take (nat i - (0 :: nat)) a2)"
  for a1 :: "int list"
  and a2 :: "int list"
  and i :: "int"
axiomatization where find_eq'spec'1'0:   "(0 :: int) \<le> find_eq a1 a2 i"
 if "length a1 = length a2"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a1)"
 and "drop (0 :: nat) (take (nat i - (0 :: nat)) a1) = drop (0 :: nat) (take (nat i - (0 :: nat)) a2)"
  for a1 :: "int list"
  and a2 :: "int list"
  and i :: "int"
axiomatization where find_eq'spec'1'1:   "find_eq a1 a2 i \<le> int (length a1)"
 if "length a1 = length a2"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a1)"
 and "drop (0 :: nat) (take (nat i - (0 :: nat)) a1) = drop (0 :: nat) (take (nat i - (0 :: nat)) a2)"
  for a1 :: "int list"
  and a2 :: "int list"
  and i :: "int"
axiomatization where find_eq'spec'0:   "drop (0 :: nat) (take (nat (find_eq a1 a2 i) - (0 :: nat)) a1) = drop (0 :: nat) (take (nat (find_eq a1 a2 i) - (0 :: nat)) a2)"
 if "length a1 = length a2"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a1)"
 and "drop (0 :: nat) (take (nat i - (0 :: nat)) a1) = drop (0 :: nat) (take (nat i - (0 :: nat)) a2)"
  for a1 :: "int list"
  and a2 :: "int list"
  and i :: "int"
axiomatization where find_eq'spec:   "\<not>a1 ! nat (find_eq a1 a2 i) = a2 ! nat (find_eq a1 a2 i)"
 if "length a1 = length a2"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a1)"
 and "drop (0 :: nat) (take (nat i - (0 :: nat)) a1) = drop (0 :: nat) (take (nat i - (0 :: nat)) a2)"
 and "find_eq a1 a2 i < int (length a1)"
  for a1 :: "int list"
  and a2 :: "int list"
  and i :: "int"
definition find_le :: "int list \<Rightarrow> int list \<Rightarrow> bool"
  where "find_le a1 a2 = (if length a1 = length a2 then let i :: int = find_eq a1 a2 (0 :: int) in if i = int (length a1) then True else if a1 ! nat i < a2 ! nat i then True else False else False)" for a1 a2
axiomatization where find_le'spec:   "find_le a1 a2 = True \<longleftrightarrow> le a1 a2"
  for a1 :: "int list"
  and a2 :: "int list"
theorem eq_le_compat'vc:
  fixes a1 :: "int list"
  fixes b1 :: "int list"
  fixes a2 :: "int list"
  fixes b2 :: "int list"
  assumes fact0: "a1 = b1"
  assumes fact1: "a2 = b2"
  assumes fact2: "le a1 a2"
  shows "le b1 b2"
  sorry
end
