theory verifythis_2021_lexicographic_permutations_2_Permut_permutqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.map_MapEq" "Why3STD.map_MapExchange" "Why3STD.map_MapPermut" "./verifythis_2021_lexicographic_permutations_2_ArrayListConversions" "Why3STD.array_IntArraySorted" "./verifythis_2021_lexicographic_permutations_2_BoxedIntArrays" "Why3STD.queue_Queue"
begin
definition sorted_sub :: "int list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "sorted_sub a l u \<longleftrightarrow> (\<forall>(i1 :: int) (i2 :: int). l \<le> i1 \<and> i1 < i2 \<and> i2 < u \<longrightarrow> a ! nat i2 \<le> a ! nat i1)" for a l u
definition sorted :: "int list \<Rightarrow> _"
  where "sorted a \<longleftrightarrow> (\<forall>(i1 :: int) (i2 :: int). (0 :: int) \<le> i1 \<and> i1 < i2 \<and> i2 < int (length a) \<longrightarrow> a ! nat i2 \<le> a ! nat i1)" for a
definition le :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "le a1 a2 \<longleftrightarrow> length a1 = length a2 \<and> (\<exists>(i :: int). ((0 :: int) \<le> i \<and> i \<le> int (length a1)) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i \<longrightarrow> a1 ! nat j = a2 ! nat j) \<and> (i < int (length a1) \<longrightarrow> a1 ! nat i < a2 ! nat i))" for a1 a2
definition lt :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "lt a1 a2 \<longleftrightarrow> le a1 a2 \<and> \<not>a1 = a2" for a1 a2
consts find_eq :: "int list \<Rightarrow> int list \<Rightarrow> int \<Rightarrow> int"
axiomatization where find_eq'def:   "if i = int (length a1) \<or> \<not>a1 ! nat i = a2 ! nat i then find_eq a1 a2 i = i else find_eq a1 a2 i = find_eq a1 a2 (i + (1 :: int))"
 if "length a1 = length a2"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a1)"
 and "drop (0 :: nat) (take (nat i - (0 :: nat)) a1) = drop (0 :: nat) (take (nat i - (0 :: nat)) a2)"
  for a1 :: "int list"
  and a2 :: "int list"
  and i :: "int"
axiomatization where find_eq'spec'1'0:   "(0 :: int) \<le> find_eq a1 a2 i"
 if "length a1 = length a2"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a1)"
 and "drop (0 :: nat) (take (nat i - (0 :: nat)) a1) = drop (0 :: nat) (take (nat i - (0 :: nat)) a2)"
  for a1 :: "int list"
  and a2 :: "int list"
  and i :: "int"
axiomatization where find_eq'spec'1'1:   "find_eq a1 a2 i \<le> int (length a1)"
 if "length a1 = length a2"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a1)"
 and "drop (0 :: nat) (take (nat i - (0 :: nat)) a1) = drop (0 :: nat) (take (nat i - (0 :: nat)) a2)"
  for a1 :: "int list"
  and a2 :: "int list"
  and i :: "int"
axiomatization where find_eq'spec'0:   "drop (0 :: nat) (take (nat (find_eq a1 a2 i) - (0 :: nat)) a1) = drop (0 :: nat) (take (nat (find_eq a1 a2 i) - (0 :: nat)) a2)"
 if "length a1 = length a2"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a1)"
 and "drop (0 :: nat) (take (nat i - (0 :: nat)) a1) = drop (0 :: nat) (take (nat i - (0 :: nat)) a2)"
  for a1 :: "int list"
  and a2 :: "int list"
  and i :: "int"
axiomatization where find_eq'spec:   "\<not>a1 ! nat (find_eq a1 a2 i) = a2 ! nat (find_eq a1 a2 i)"
 if "length a1 = length a2"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a1)"
 and "drop (0 :: nat) (take (nat i - (0 :: nat)) a1) = drop (0 :: nat) (take (nat i - (0 :: nat)) a2)"
 and "find_eq a1 a2 i < int (length a1)"
  for a1 :: "int list"
  and a2 :: "int list"
  and i :: "int"
definition find_le :: "int list \<Rightarrow> int list \<Rightarrow> bool"
  where "find_le a1 a2 = (if length a1 = length a2 then let i :: int = find_eq a1 a2 (0 :: int) in if i = int (length a1) then True else if a1 ! nat i < a2 ! nat i then True else False else False)" for a1 a2
axiomatization where find_le'spec:   "find_le a1 a2 = True \<longleftrightarrow> le a1 a2"
  for a1 :: "int list"
  and a2 :: "int list"
consts as_num :: "int \<Rightarrow> int list \<Rightarrow> int \<Rightarrow> int"
axiomatization where as_num'def:   "if i = int (length a) then as_num base a i = (0 :: int) else as_num base a i = a ! nat i * base ^\<^sub>i (int (length a) - (1 :: int) - i) + as_num base a (i + (1 :: int))"
 if "boxed base a"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a)"
  for base :: "int"
  and a :: "int list"
  and i :: "int"
axiomatization where as_num'spec:   "(2 :: int) * abs (as_num base a i) < base ^\<^sub>i (int (length a) - i)"
 if "boxed base a"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a)"
  for base :: "int"
  and a :: "int list"
  and i :: "int"
consts as_number :: "int \<Rightarrow> int list \<Rightarrow> int"
axiomatization where as_number'def:   "as_number base a = as_num base a (0 :: int)"
 if "boxed base a"
  for base :: "int"
  and a :: "int list"
axiomatization where as_number'spec:   "abs (as_number base a) \<le> maxi base a"
 if "boxed base a"
  for base :: "int"
  and a :: "int list"
theorem permut'vc:
  fixes a :: "int list"
  shows "let base :: int = greater a in (0 :: int) \<le> base \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length a) \<longrightarrow> (2 :: int) * abs (a ! nat i) < base) \<longrightarrow> (\<forall>(res :: int list t). seq res = [] \<longrightarrow> (if int (length a) = (0 :: int) then \<forall>(res1 :: int list t). seq res1 = seq res @ [(Nil :: int list)] \<longrightarrow> (\<forall>(i1 :: int) (i2 :: int). (0 :: int) \<le> i1 \<and> i1 < i2 \<and> i2 < int (length (seq res1)) \<longrightarrow> lt (of_list (seq res1 ! nat i1)) (of_list (seq res1 ! nat i2))) \<and> (\<forall>(a' :: int list). a <~~> a' \<longrightarrow> to_list_from (0 :: int) a' \<in> set (seq res1)) else \<forall>(a1 :: int list). length a1 = length a \<longrightarrow> a1 <~~> a \<and> array_IntArraySorted.sorted a1 \<longrightarrow> (a1 <~~> a \<and> boxed base a1 \<and> (\<forall>(a' :: int list). a' <~~> a1 \<longrightarrow> lt a' a1 \<longrightarrow> to_list_from (0 :: int) a' \<in> set (seq res)) \<and> (\<forall>(a' :: int list). to_list_from (0 :: int) a' \<in> set (seq res) \<longrightarrow> lt a' a1) \<and> (\<forall>(i1 :: int) (i2 :: int). (0 :: int) \<le> i1 \<and> i1 < i2 \<and> i2 < int (length (seq res)) \<longrightarrow> lt (of_list (seq res ! nat i1)) (of_list (seq res ! nat i2)))) \<and> (\<forall>(cont_int :: int) (cont :: bool) (res1 :: int list t) (a2 :: int list). length a2 = length a1 \<longrightarrow> a2 <~~> a \<and> boxed base a2 \<and> (cont_int = (1 :: int) \<longleftrightarrow> cont = True) \<and> (cont = True \<longrightarrow> (\<forall>(a' :: int list). a' <~~> a2 \<longrightarrow> lt a' a2 \<longrightarrow> to_list_from (0 :: int) a' \<in> set (seq res1))) \<and> (\<not>cont = True \<longrightarrow> (\<forall>(a' :: int list). a' <~~> a2 \<longrightarrow> le a' a2 \<longrightarrow> to_list_from (0 :: int) a' \<in> set (seq res1))) \<and> (cont = True \<longrightarrow> (\<forall>(a' :: int list). to_list_from (0 :: int) a' \<in> set (seq res1) \<longrightarrow> lt a' a2)) \<and> (\<not>cont = True \<longrightarrow> (\<forall>(a' :: int list). a2 <~~> a' \<longrightarrow> le a2 a' \<longrightarrow> a2 = a')) \<and> (\<forall>(i1 :: int) (i2 :: int). (0 :: int) \<le> i1 \<and> i1 < i2 \<and> i2 < int (length (seq res1)) \<longrightarrow> lt (of_list (seq res1 ! nat i1)) (of_list (seq res1 ! nat i2))) \<longrightarrow> (if cont = True then \<forall>(res2 :: int list t). seq res2 = seq res1 @ [to_list_from (0 :: int) a2] \<longrightarrow> (\<forall>(a3 :: int list). length a3 = length a2 \<longrightarrow> (\<forall>(o1 :: bool). a3 <~~> a2 \<and> (\<not>o1 = True \<longrightarrow> a3 = a2 \<and> (\<forall>(a' :: int list). a3 <~~> a' \<longrightarrow> le a3 a' \<longrightarrow> a3 = a')) \<and> (o1 = True \<longrightarrow> lt a2 a3 \<and> (\<forall>(a' :: int list). a2 <~~> a' \<longrightarrow> lt a2 a' \<longrightarrow> le a3 a')) \<longrightarrow> (if o1 = True then ((0 :: int) \<le> cont_int \<and> cont_int < cont_int \<or> (0 :: int) \<le> maxi base a2 - as_number base a2 \<and> maxi base a3 - as_number base a3 < maxi base a2 - as_number base a2) \<and> a3 <~~> a \<and> boxed base a3 \<and> (cont_int = (1 :: int) \<longleftrightarrow> o1 = True) \<and> (o1 = True \<longrightarrow> (\<forall>(a' :: int list). a' <~~> a3 \<longrightarrow> lt a' a3 \<longrightarrow> to_list_from (0 :: int) a' \<in> set (seq res2))) \<and> (\<not>o1 = True \<longrightarrow> (\<forall>(a' :: int list). a' <~~> a3 \<longrightarrow> le a' a3 \<longrightarrow> to_list_from (0 :: int) a' \<in> set (seq res2))) \<and> (o1 = True \<longrightarrow> (\<forall>(a' :: int list). to_list_from (0 :: int) a' \<in> set (seq res2) \<longrightarrow> lt a' a3)) \<and> (\<not>o1 = True \<longrightarrow> (\<forall>(a' :: int list). a3 <~~> a' \<longrightarrow> le a3 a' \<longrightarrow> a3 = a')) \<and> (\<forall>(i1 :: int) (i2 :: int). (0 :: int) \<le> i1 \<and> i1 < i2 \<and> i2 < int (length (seq res2)) \<longrightarrow> lt (of_list (seq res2 ! nat i1)) (of_list (seq res2 ! nat i2))) else ((0 :: int) \<le> cont_int \<and> (0 :: int) < cont_int \<or> cont_int = (0 :: int) \<and> (0 :: int) \<le> maxi base a2 - as_number base a2 \<and> maxi base a3 - as_number base a3 < maxi base a2 - as_number base a2) \<and> a3 <~~> a \<and> boxed base a3 \<and> ((0 :: int) = (1 :: int) \<longleftrightarrow> o1 = True) \<and> (o1 = True \<longrightarrow> (\<forall>(a' :: int list). a' <~~> a3 \<longrightarrow> lt a' a3 \<longrightarrow> to_list_from (0 :: int) a' \<in> set (seq res2))) \<and> (\<not>o1 = True \<longrightarrow> (\<forall>(a' :: int list). a' <~~> a3 \<longrightarrow> le a' a3 \<longrightarrow> to_list_from (0 :: int) a' \<in> set (seq res2))) \<and> (o1 = True \<longrightarrow> (\<forall>(a' :: int list). to_list_from (0 :: int) a' \<in> set (seq res2) \<longrightarrow> lt a' a3)) \<and> (\<not>o1 = True \<longrightarrow> (\<forall>(a' :: int list). a3 <~~> a' \<longrightarrow> le a3 a' \<longrightarrow> a3 = a')) \<and> (\<forall>(i1 :: int) (i2 :: int). (0 :: int) \<le> i1 \<and> i1 < i2 \<and> i2 < int (length (seq res2)) \<longrightarrow> lt (of_list (seq res2 ! nat i1)) (of_list (seq res2 ! nat i2)))))) else (\<forall>(i1 :: int) (i2 :: int). (0 :: int) \<le> i1 \<and> i1 < i2 \<and> i2 < int (length (seq res1)) \<longrightarrow> lt (of_list (seq res1 ! nat i1)) (of_list (seq res1 ! nat i2))) \<and> (\<forall>(a' :: int list). a2 <~~> a' \<longrightarrow> to_list_from (0 :: int) a' \<in> set (seq res1))))))"
  sorry
end
