theory verifythis_2021_lexicographic_permutations_2_Permut_seq_snoc_memqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.map_MapEq" "Why3STD.map_MapExchange" "Why3STD.map_MapPermut" "./verifythis_2021_lexicographic_permutations_2_ArrayListConversions" "Why3STD.array_IntArraySorted" "./verifythis_2021_lexicographic_permutations_2_BoxedIntArrays" "Why3STD.queue_Queue"
begin
definition sorted_sub :: "int list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "sorted_sub a l u \<longleftrightarrow> (\<forall>(i1 :: int) (i2 :: int). l \<le> i1 \<and> i1 < i2 \<and> i2 < u \<longrightarrow> a ! nat i2 \<le> a ! nat i1)" for a l u
definition sorted :: "int list \<Rightarrow> _"
  where "sorted a \<longleftrightarrow> (\<forall>(i1 :: int) (i2 :: int). (0 :: int) \<le> i1 \<and> i1 < i2 \<and> i2 < int (length a) \<longrightarrow> a ! nat i2 \<le> a ! nat i1)" for a
definition le :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "le a1 a2 \<longleftrightarrow> length a1 = length a2 \<and> (\<exists>(i :: int). ((0 :: int) \<le> i \<and> i \<le> int (length a1)) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i \<longrightarrow> a1 ! nat j = a2 ! nat j) \<and> (i < int (length a1) \<longrightarrow> a1 ! nat i < a2 ! nat i))" for a1 a2
definition lt :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "lt a1 a2 \<longleftrightarrow> le a1 a2 \<and> \<not>a1 = a2" for a1 a2
consts find_eq :: "int list \<Rightarrow> int list \<Rightarrow> int \<Rightarrow> int"
axiomatization where find_eq'def:   "if i = int (length a1) \<or> \<not>a1 ! nat i = a2 ! nat i then find_eq a1 a2 i = i else find_eq a1 a2 i = find_eq a1 a2 (i + (1 :: int))"
 if "length a1 = length a2"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a1)"
 and "drop (0 :: nat) (take (nat i - (0 :: nat)) a1) = drop (0 :: nat) (take (nat i - (0 :: nat)) a2)"
  for a1 :: "int list"
  and a2 :: "int list"
  and i :: "int"
axiomatization where find_eq'spec'1'0:   "(0 :: int) \<le> find_eq a1 a2 i"
 if "length a1 = length a2"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a1)"
 and "drop (0 :: nat) (take (nat i - (0 :: nat)) a1) = drop (0 :: nat) (take (nat i - (0 :: nat)) a2)"
  for a1 :: "int list"
  and a2 :: "int list"
  and i :: "int"
axiomatization where find_eq'spec'1'1:   "find_eq a1 a2 i \<le> int (length a1)"
 if "length a1 = length a2"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a1)"
 and "drop (0 :: nat) (take (nat i - (0 :: nat)) a1) = drop (0 :: nat) (take (nat i - (0 :: nat)) a2)"
  for a1 :: "int list"
  and a2 :: "int list"
  and i :: "int"
axiomatization where find_eq'spec'0:   "drop (0 :: nat) (take (nat (find_eq a1 a2 i) - (0 :: nat)) a1) = drop (0 :: nat) (take (nat (find_eq a1 a2 i) - (0 :: nat)) a2)"
 if "length a1 = length a2"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a1)"
 and "drop (0 :: nat) (take (nat i - (0 :: nat)) a1) = drop (0 :: nat) (take (nat i - (0 :: nat)) a2)"
  for a1 :: "int list"
  and a2 :: "int list"
  and i :: "int"
axiomatization where find_eq'spec:   "\<not>a1 ! nat (find_eq a1 a2 i) = a2 ! nat (find_eq a1 a2 i)"
 if "length a1 = length a2"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a1)"
 and "drop (0 :: nat) (take (nat i - (0 :: nat)) a1) = drop (0 :: nat) (take (nat i - (0 :: nat)) a2)"
 and "find_eq a1 a2 i < int (length a1)"
  for a1 :: "int list"
  and a2 :: "int list"
  and i :: "int"
definition find_le :: "int list \<Rightarrow> int list \<Rightarrow> bool"
  where "find_le a1 a2 = (if length a1 = length a2 then let i :: int = find_eq a1 a2 (0 :: int) in if i = int (length a1) then True else if a1 ! nat i < a2 ! nat i then True else False else False)" for a1 a2
axiomatization where find_le'spec:   "find_le a1 a2 = True \<longleftrightarrow> le a1 a2"
  for a1 :: "int list"
  and a2 :: "int list"
consts as_num :: "int \<Rightarrow> int list \<Rightarrow> int \<Rightarrow> int"
axiomatization where as_num'def:   "if i = int (length a) then as_num base a i = (0 :: int) else as_num base a i = a ! nat i * base ^\<^sub>i (int (length a) - (1 :: int) - i) + as_num base a (i + (1 :: int))"
 if "boxed base a"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a)"
  for base :: "int"
  and a :: "int list"
  and i :: "int"
axiomatization where as_num'spec:   "(2 :: int) * abs (as_num base a i) < base ^\<^sub>i (int (length a) - i)"
 if "boxed base a"
 and "(0 :: int) \<le> i"
 and "i \<le> int (length a)"
  for base :: "int"
  and a :: "int list"
  and i :: "int"
consts as_number :: "int \<Rightarrow> int list \<Rightarrow> int"
axiomatization where as_number'def:   "as_number base a = as_num base a (0 :: int)"
 if "boxed base a"
  for base :: "int"
  and a :: "int list"
axiomatization where as_number'spec:   "abs (as_number base a) \<le> maxi base a"
 if "boxed base a"
  for base :: "int"
  and a :: "int list"
theorem seq_snoc_mem'vc:
  fixes x :: "'a"
  fixes s :: "'a list"
  fixes y :: "'a"
  shows "x \<in> set (s @ [y]) \<longleftrightarrow> x \<in> set s \<or> x = y"
  sorry
end
