From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.why3.Ref.Ref.
Require Import Why3.map.MapEq.
Require Import Why3.map.MapExchange.
Require Import Why3.map.MapPermut.
Require Import Why3.array.IntArraySorted.
Open Scope Z_scope.
Definition sorted_sub (a : list Z) (l : Z) (u : Z) := ∀(i1 : Z) (i2 : Z), l ≤ i1 ∧ i1 < i2 ∧ i2 < u -> nth (Z.to_nat i2) a inhabitant ≤ nth (Z.to_nat i1) a inhabitant.
Definition sorted (a : list Z) := ∀(i1 : Z) (i2 : Z), 0%Z ≤ i1 ∧ i1 < i2 ∧ i2 < Z.of_nat (length a) -> nth (Z.to_nat i2) a inhabitant ≤ nth (Z.to_nat i1) a inhabitant.
Definition le (a1 : list Z) (a2 : list Z) := length a1 = length a2 ∧ (∃(i : Z), (0%Z ≤ i ∧ i ≤ Z.of_nat (length a1)) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < i -> nth (Z.to_nat j) a1 inhabitant = nth (Z.to_nat j) a2 inhabitant) ∧ (i < Z.of_nat (length a1) -> nth (Z.to_nat i) a1 inhabitant < nth (Z.to_nat i) a2 inhabitant)).
Definition lt (a1 : list Z) (a2 : list Z) := le a1 a2 ∧ ¬ a1 = a2.
Axiom find_eq : list Z -> list Z -> Z -> Z.
Axiom find_eq'def : forall  (a1 : list Z) (a2 : list Z) (i : Z) (fact0 : length a1 = length a2) (fact1 : 0%Z ≤ i) (fact2 : i ≤ Z.of_nat (length a1)) (fact3 : drop 0%nat (take (Z.to_nat i - 0%nat) a1) = drop 0%nat (take (Z.to_nat i - 0%nat) a2)), if decide (i = Z.of_nat (length a1) ∨ ¬ nth (Z.to_nat i) a1 inhabitant = nth (Z.to_nat i) a2 inhabitant) then find_eq a1 a2 i = i else find_eq a1 a2 i = find_eq a1 a2 (i + 1%Z).
Axiom find_eq'spec'1 : forall  (a1 : list Z) (a2 : list Z) (i : Z) (fact0 : length a1 = length a2) (fact1 : 0%Z ≤ i) (fact2 : i ≤ Z.of_nat (length a1)) (fact3 : drop 0%nat (take (Z.to_nat i - 0%nat) a1) = drop 0%nat (take (Z.to_nat i - 0%nat) a2)), 0%Z ≤ find_eq a1 a2 i ∧ find_eq a1 a2 i ≤ Z.of_nat (length a1).
Axiom find_eq'spec'0 : forall  (a1 : list Z) (a2 : list Z) (i : Z) (fact0 : length a1 = length a2) (fact1 : 0%Z ≤ i) (fact2 : i ≤ Z.of_nat (length a1)) (fact3 : drop 0%nat (take (Z.to_nat i - 0%nat) a1) = drop 0%nat (take (Z.to_nat i - 0%nat) a2)), drop 0%nat (take (Z.to_nat (find_eq a1 a2 i) - 0%nat) a1) = drop 0%nat (take (Z.to_nat (find_eq a1 a2 i) - 0%nat) a2).
Axiom find_eq'spec : forall  (a1 : list Z) (a2 : list Z) (i : Z) (fact0 : length a1 = length a2) (fact1 : 0%Z ≤ i) (fact2 : i ≤ Z.of_nat (length a1)) (fact3 : drop 0%nat (take (Z.to_nat i - 0%nat) a1) = drop 0%nat (take (Z.to_nat i - 0%nat) a2)) (fact4 : find_eq a1 a2 i < Z.of_nat (length a1)), ¬ nth (Z.to_nat (find_eq a1 a2 i)) a1 inhabitant = nth (Z.to_nat (find_eq a1 a2 i)) a2 inhabitant.
Definition find_le (a1 : list Z) (a2 : list Z) : bool := if decide (length a1 = length a2) then let i : Z := find_eq a1 a2 0%Z in if decide (i = Z.of_nat (length a1)) then true else if decide (nth (Z.to_nat i) a1 inhabitant < nth (Z.to_nat i) a2 inhabitant) then true else false else false.
Axiom find_le'spec : forall  (a1 : list Z) (a2 : list Z), (find_le a1 a2 = true) = le a1 a2.
Theorem next'vc (a : list Z) : let o1 : Z := Z.of_nat (length a) - 1%Z in (o1 ≤ Z.of_nat (length a) - 1%Z ∧ sorted_sub a o1 (Z.of_nat (length a))) ∧ (∀(i : Z), i ≤ Z.of_nat (length a) - 1%Z ∧ sorted_sub a i (Z.of_nat (length a)) -> (0%Z < i -> (0%Z ≤ i ∧ i < Z.of_nat (length a)) ∧ (let o2 : Z := i - 1%Z in 0%Z ≤ o2 ∧ o2 < Z.of_nat (length a))) ∧ (∀(o2 : bool), (if decide (0%Z < i) then o2 = (if decide (nth (Z.to_nat i) a inhabitant ≤ nth (Z.to_nat (i - 1%Z)) a inhabitant) then true else false) else o2 = false) -> (if decide (o2 = true) then (0%Z ≤ i ∧ i - 1%Z < i) ∧ i - 1%Z ≤ Z.of_nat (length a) - 1%Z ∧ sorted_sub a (i - 1%Z) (Z.of_nat (length a)) else if decide (i ≤ 0%Z) then a ≡ₚ a ∧ (∀(a' : list Z), a ≡ₚ a' -> le a a' -> a = a') else let o3 : Z := Z.of_nat (length a) - 1%Z in ((i ≤ o3 ∧ o3 ≤ Z.of_nat (length a) - 1%Z) ∧ (∀(k : Z), o3 < k ∧ k < Z.of_nat (length a) -> nth (Z.to_nat k) a inhabitant ≤ nth (Z.to_nat (i - 1%Z)) a inhabitant)) ∧ (∀(j : Z), (i ≤ j ∧ j ≤ Z.of_nat (length a) - 1%Z) ∧ (∀(k : Z), j < k ∧ k < Z.of_nat (length a) -> nth (Z.to_nat k) a inhabitant ≤ nth (Z.to_nat (i - 1%Z)) a inhabitant) -> (let o4 : Z := i - 1%Z in (0%Z ≤ o4 ∧ o4 < Z.of_nat (length a)) ∧ (0%Z ≤ j ∧ j < Z.of_nat (length a)) ∧ (if decide (nth (Z.to_nat j) a inhabitant ≤ nth (Z.to_nat o4) a inhabitant) then (0%Z ≤ j ∧ j - 1%Z < j) ∧ (i ≤ j - 1%Z ∧ j - 1%Z ≤ Z.of_nat (length a) - 1%Z) ∧ (∀(k : Z), j - 1%Z < k ∧ k < Z.of_nat (length a) -> nth (Z.to_nat k) a inhabitant ≤ nth (Z.to_nat (i - 1%Z)) a inhabitant) else let o5 : Z := i - 1%Z in (0%Z ≤ o5 ∧ o5 < Z.of_nat (length a)) ∧ (let o6 : Z := nth (Z.to_nat o5) a inhabitant in (0%Z ≤ j ∧ j < Z.of_nat (length a)) ∧ (let o7 : Z := nth (Z.to_nat j) a inhabitant in let o8 : Z := i - 1%Z in (0%Z ≤ o8 ∧ o8 < Z.of_nat (length a)) ∧ (length (set_list a (Z.to_nat o8) o7) = length a -> nth_i (set_list a (Z.to_nat o8) o7) = fun_updt (nth_i a) o8 o7 -> (0%Z ≤ j ∧ j < Z.of_nat (length (set_list a (Z.to_nat o8) o7))) ∧ (length (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6) = length (set_list a (Z.to_nat o8) o7) -> nth_i (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6) = fun_updt (nth_i (set_list a (Z.to_nat o8) o7)) j o6 -> ((i ≤ i ∧ i < Z.of_nat (length (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6))) ∧ (i ≤ Z.of_nat (length (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6)) - 1%Z ∧ Z.of_nat (length (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6)) - 1%Z < Z.of_nat (length (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6))) ∧ set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6 ≡ₚ set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6 ∧ drop 0%nat (take (Z.to_nat i - 0%nat) (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6)) = drop 0%nat (take (Z.to_nat i - 0%nat) (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6)) ∧ (∀(k1 : Z) (k2 : Z), i ≤ k1 ∧ k1 < k2 ∧ k2 < i -> nth (Z.to_nat k1) (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6) inhabitant ≤ nth (Z.to_nat k2) (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6) inhabitant) ∧ (∀(k1 : Z) (k2 : Z), i ≤ k1 ∧ k1 < k2 ∧ k2 < Z.of_nat (length (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6)) - 1%Z + 1%Z -> nth (Z.to_nat k2) (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6) inhabitant ≤ nth (Z.to_nat k1) (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6) inhabitant) ∧ (∀(k1 : Z) (k2 : Z), Z.of_nat (length (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6)) - 1%Z + 1%Z ≤ k1 ∧ k1 < k2 ∧ k2 < Z.of_nat (length (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6)) -> nth (Z.to_nat k1) (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6) inhabitant ≤ nth (Z.to_nat k2) (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6) inhabitant) ∧ (∀(k1 : Z) (k2 : Z), i ≤ k1 ∧ k1 < i -> i ≤ k2 ∧ k2 ≤ Z.of_nat (length (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6)) - 1%Z -> nth (Z.to_nat k1) (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6) inhabitant ≤ nth (Z.to_nat k2) (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6) inhabitant) ∧ (∀(k1 : Z) (k2 : Z), i ≤ k1 ∧ k1 ≤ Z.of_nat (length (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6)) - 1%Z -> Z.of_nat (length (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6)) - 1%Z < k2 ∧ k2 < Z.of_nat (length (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6)) -> nth (Z.to_nat k1) (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6) inhabitant ≤ nth (Z.to_nat k2) (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6) inhabitant) ∧ (∀(k1 : Z) (k2 : Z), i ≤ k1 ∧ k1 < i -> Z.of_nat (length (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6)) - 1%Z < k2 ∧ k2 < Z.of_nat (length (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6)) -> nth (Z.to_nat k1) (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6) inhabitant ≤ nth (Z.to_nat k2) (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6) inhabitant)) ∧ (∀(j1 : Z) (i1 : Z) (a1 : list Z), length a1 = length (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6) -> (i ≤ i1 ∧ i1 < Z.of_nat (length a1)) ∧ (i ≤ j1 ∧ j1 < Z.of_nat (length a1)) ∧ a1 ≡ₚ set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6 ∧ drop 0%nat (take (Z.to_nat i - 0%nat) a1) = drop 0%nat (take (Z.to_nat i - 0%nat) (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6)) ∧ (∀(k1 : Z) (k2 : Z), i ≤ k1 ∧ k1 < k2 ∧ k2 < i1 -> nth (Z.to_nat k1) a1 inhabitant ≤ nth (Z.to_nat k2) a1 inhabitant) ∧ (∀(k1 : Z) (k2 : Z), i1 ≤ k1 ∧ k1 < k2 ∧ k2 < j1 + 1%Z -> nth (Z.to_nat k2) a1 inhabitant ≤ nth (Z.to_nat k1) a1 inhabitant) ∧ (∀(k1 : Z) (k2 : Z), j1 + 1%Z ≤ k1 ∧ k1 < k2 ∧ k2 < Z.of_nat (length a1) -> nth (Z.to_nat k1) a1 inhabitant ≤ nth (Z.to_nat k2) a1 inhabitant) ∧ (∀(k1 : Z) (k2 : Z), i ≤ k1 ∧ k1 < i1 -> i1 ≤ k2 ∧ k2 ≤ j1 -> nth (Z.to_nat k1) a1 inhabitant ≤ nth (Z.to_nat k2) a1 inhabitant) ∧ (∀(k1 : Z) (k2 : Z), i1 ≤ k1 ∧ k1 ≤ j1 -> j1 < k2 ∧ k2 < Z.of_nat (length a1) -> nth (Z.to_nat k1) a1 inhabitant ≤ nth (Z.to_nat k2) a1 inhabitant) ∧ (∀(k1 : Z) (k2 : Z), i ≤ k1 ∧ k1 < i1 -> j1 < k2 ∧ k2 < Z.of_nat (length a1) -> nth (Z.to_nat k1) a1 inhabitant ≤ nth (Z.to_nat k2) a1 inhabitant) -> (if decide (i1 < j1) then (0%Z ≤ i1 ∧ i1 < Z.of_nat (length a1)) ∧ (0%Z ≤ j1 ∧ j1 < Z.of_nat (length a1)) ∧ (let o9 : Z := nth (Z.to_nat j1) a1 inhabitant in (0%Z ≤ i1 ∧ i1 < Z.of_nat (length a1)) ∧ (length (set_list a1 (Z.to_nat i1) o9) = length a1 -> nth_i (set_list a1 (Z.to_nat i1) o9) = fun_updt (nth_i a1) i1 o9 -> (0%Z ≤ j1 ∧ j1 < Z.of_nat (length (set_list a1 (Z.to_nat i1) o9))) ∧ (length (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant)) = length (set_list a1 (Z.to_nat i1) o9) -> nth_i (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant)) = fun_updt (nth_i (set_list a1 (Z.to_nat i1) o9)) j1 (nth (Z.to_nat i1) a1 inhabitant) -> (0%Z ≤ j1 - i1 ∧ j1 - 1%Z - (i1 + 1%Z) < j1 - i1) ∧ (i ≤ i1 + 1%Z ∧ i1 + 1%Z < Z.of_nat (length (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant)))) ∧ (i ≤ j1 - 1%Z ∧ j1 - 1%Z < Z.of_nat (length (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant)))) ∧ set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant) ≡ₚ set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6 ∧ drop 0%nat (take (Z.to_nat i - 0%nat) (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant))) = drop 0%nat (take (Z.to_nat i - 0%nat) (set_list (set_list a (Z.to_nat o8) o7) (Z.to_nat j) o6)) ∧ (∀(k1 : Z) (k2 : Z), i ≤ k1 ∧ k1 < k2 ∧ k2 < i1 + 1%Z -> nth (Z.to_nat k1) (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant)) inhabitant ≤ nth (Z.to_nat k2) (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant)) inhabitant) ∧ (∀(k1 : Z) (k2 : Z), i1 + 1%Z ≤ k1 ∧ k1 < k2 ∧ k2 < j1 - 1%Z + 1%Z -> nth (Z.to_nat k2) (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant)) inhabitant ≤ nth (Z.to_nat k1) (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant)) inhabitant) ∧ (∀(k1 : Z) (k2 : Z), j1 - 1%Z + 1%Z ≤ k1 ∧ k1 < k2 ∧ k2 < Z.of_nat (length (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant))) -> nth (Z.to_nat k1) (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant)) inhabitant ≤ nth (Z.to_nat k2) (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant)) inhabitant) ∧ (∀(k1 : Z) (k2 : Z), i ≤ k1 ∧ k1 < i1 + 1%Z -> i1 + 1%Z ≤ k2 ∧ k2 ≤ j1 - 1%Z -> nth (Z.to_nat k1) (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant)) inhabitant ≤ nth (Z.to_nat k2) (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant)) inhabitant) ∧ (∀(k1 : Z) (k2 : Z), i1 + 1%Z ≤ k1 ∧ k1 ≤ j1 - 1%Z -> j1 - 1%Z < k2 ∧ k2 < Z.of_nat (length (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant))) -> nth (Z.to_nat k1) (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant)) inhabitant ≤ nth (Z.to_nat k2) (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant)) inhabitant) ∧ (∀(k1 : Z) (k2 : Z), i ≤ k1 ∧ k1 < i1 + 1%Z -> j1 - 1%Z < k2 ∧ k2 < Z.of_nat (length (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant))) -> nth (Z.to_nat k1) (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant)) inhabitant ≤ nth (Z.to_nat k2) (set_list (set_list a1 (Z.to_nat i1) o9) (Z.to_nat j1) (nth (Z.to_nat i1) a1 inhabitant)) inhabitant)))) else a1 ≡ₚ a ∧ lt a a1 ∧ (∀(a' : list Z), a ≡ₚ a' -> lt a a' -> le a1 a'))))))))))))).
Admitted.
