theory verifythis_2021_shearsort_modified_Top_shearsortqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.int_NumOf" "Why3STD.int_Sum" "Why3STD.matrix_Matrix"
begin
consts fc :: "int \<Rightarrow> int matrix \<Rightarrow> int \<Rightarrow> int"
axiomatization where fc'def:   "fc x m i = int (map_occ x (elts m i) (0 :: int) (columns m))"
  for x :: "int"
  and m :: "int matrix"
  and i :: "int"
definition mocc :: "int \<Rightarrow> int matrix \<Rightarrow> int"
  where "mocc x m = sum (fc x m) (0 :: int) (rows m)" for x m
definition lt :: "int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "lt i j k l \<longleftrightarrow> i < k \<or> i = k \<and> (if i cmod (2 :: int) = (0 :: int) then j < l else l < j)" for i j k l
definition snake_order :: "int matrix \<Rightarrow> _"
  where "snake_order m \<longleftrightarrow> (let rw :: int = rows m; cl :: int = columns m in \<forall>(i :: int) (j :: int) (k :: int) (l :: int). (0 :: int) \<le> i \<and> i < rw \<longrightarrow> (0 :: int) \<le> j \<and> j < cl \<longrightarrow> (0 :: int) \<le> k \<and> k < rw \<longrightarrow> (0 :: int) \<le> l \<and> l < cl \<longrightarrow> lt i j k l \<longrightarrow> elts m i j \<le> elts m k l)" for m
consts fc1 :: "int matrix \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> bool"
consts fc2 :: "int matrix \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
consts fc3 :: "int matrix \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
consts fc4 :: "int matrix \<Rightarrow> int \<Rightarrow> int"
axiomatization where fc'def1:   "fc1 m i j k l = True \<longleftrightarrow> lt i j k l \<and> elts m k l < elts m i j"
  for m :: "int matrix"
  and i :: "int"
  and j :: "int"
  and k :: "int"
  and l :: "int"
axiomatization where fc'def2:   "fc2 m i j k = numof (fc1 m i j k) (0 :: int) (columns m)"
  for m :: "int matrix"
  and i :: "int"
  and j :: "int"
  and k :: "int"
axiomatization where fc'def3:   "fc3 m i j = sum (fc2 m i j) (0 :: int) (rows m)"
  for m :: "int matrix"
  and i :: "int"
  and j :: "int"
axiomatization where fc'def4:   "fc4 m i = sum (fc3 m i) (0 :: int) (columns m)"
  for m :: "int matrix"
  and i :: "int"
definition inversions :: "int matrix \<Rightarrow> int"
  where "inversions m = sum (fc4 m) (0 :: int) (rows m)" for m
definition sorted_row :: "int matrix \<Rightarrow> int \<Rightarrow> bool \<Rightarrow> _"
  where "sorted_row m row ascending \<longleftrightarrow> ((0 :: int) \<le> row \<and> row < rows m) \<and> (if ascending = True then \<forall>(j :: int) (l :: int). (0 :: int) \<le> j \<and> j \<le> l \<and> l < columns m \<longrightarrow> elts m row j \<le> elts m row l else \<forall>(j :: int) (l :: int). (0 :: int) \<le> j \<and> j \<le> l \<and> l < columns m \<longrightarrow> elts m row l \<le> elts m row j)" for m row ascending
definition sorted_column :: "int matrix \<Rightarrow> int \<Rightarrow> _"
  where "sorted_column m column \<longleftrightarrow> ((0 :: int) \<le> column \<and> column < columns m) \<and> (\<forall>(i :: int) (k :: int). (0 :: int) \<le> i \<and> i \<le> k \<and> k < rows m \<longrightarrow> elts m i column \<le> elts m k column)" for m column
theorem shearsort'vc:
  fixes m :: "int matrix"
  fixes m1 :: "int matrix"
  assumes fact0: "rows m = columns m"
  assumes fact1: "rows m1 = rows m"
  assumes fact2: "columns m1 = columns m"
  assumes fact3: "\<forall>(x :: int). mocc x m1 = mocc x m"
  shows "let o1 :: int = columns m - (1 :: int) in ((0 :: int) \<le> o1 + (1 :: int) \<longrightarrow> ((\<forall>(k :: int). (0 :: int) \<le> k \<and> k < (0 :: int) \<longrightarrow> sorted_row m1 k (if k cmod (2 :: int) = (0 :: int) then True else False)) \<and> (\<forall>(x :: int). mocc x m1 = mocc x m) \<and> inversions m1 \<le> inversions m1) \<and> (\<forall>(m2 :: int matrix). rows m2 = rows m1 \<and> columns m2 = columns m1 \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i \<le> o1) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < i \<longrightarrow> sorted_row m2 k (if k cmod (2 :: int) = (0 :: int) then True else False)) \<and> (\<forall>(x :: int). mocc x m2 = mocc x m) \<and> inversions m2 \<le> inversions m1 \<longrightarrow> \<not>(2 :: int) = (0 :: int) \<and> ((0 :: int) \<le> i \<and> i < rows m2) \<and> (\<forall>(m3 :: int matrix). rows m3 = rows m2 \<and> columns m3 = columns m2 \<longrightarrow> (\<forall>(i1 :: int) (j :: int). (0 :: int) \<le> i1 \<and> i1 < rows m3 \<longrightarrow> (0 :: int) \<le> j \<and> j < columns m3 \<longrightarrow> \<not>i1 = i \<longrightarrow> elts m3 i1 j = elts m2 i1 j) \<and> (\<forall>(x :: int). mocc x m3 = mocc x m2) \<and> sorted_row m3 i (if i cmod (2 :: int) = (0 :: int) then True else False) \<and> inversions m3 \<le> inversions m2 \<longrightarrow> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < i + (1 :: int) \<longrightarrow> sorted_row m3 k (if k cmod (2 :: int) = (0 :: int) then True else False)) \<and> (\<forall>(x :: int). mocc x m3 = mocc x m) \<and> inversions m3 \<le> inversions m1)) \<and> ((\<forall>(k :: int). (0 :: int) \<le> k \<and> k < o1 + (1 :: int) \<longrightarrow> sorted_row m2 k (if k cmod (2 :: int) = (0 :: int) then True else False)) \<and> (\<forall>(x :: int). mocc x m2 = mocc x m) \<and> inversions m2 \<le> inversions m1 \<longrightarrow> (let o2 :: int = columns m - (1 :: int) in ((0 :: int) \<le> o2 + (1 :: int) \<longrightarrow> ((\<forall>(l :: int). (0 :: int) \<le> l \<and> l < (0 :: int) \<longrightarrow> sorted_column m2 l) \<and> (\<forall>(x :: int). mocc x m2 = mocc x m) \<and> inversions m2 \<le> inversions m2) \<and> (\<forall>(nochange :: bool) (m3 :: int matrix). rows m3 = rows m2 \<and> columns m3 = columns m2 \<longrightarrow> (\<forall>(j :: int). ((0 :: int) \<le> j \<and> j \<le> o2) \<and> (nochange = True \<longrightarrow> (\<forall>(i :: int) (j1 :: int). (0 :: int) \<le> i \<and> i < rows m3 \<longrightarrow> (0 :: int) \<le> j1 \<and> j1 < columns m3 \<longrightarrow> elts m3 i j1 = elts m2 i j1)) \<and> (\<forall>(l :: int). (0 :: int) \<le> l \<and> l < j \<longrightarrow> sorted_column m3 l) \<and> (\<forall>(x :: int). mocc x m3 = mocc x m) \<and> inversions m3 \<le> inversions m2 \<and> (\<not>nochange = True \<longrightarrow> inversions m3 < inversions m2) \<longrightarrow> ((0 :: int) \<le> j \<and> j < columns m3) \<and> (\<forall>(m4 :: int matrix). rows m4 = rows m3 \<and> columns m4 = columns m3 \<longrightarrow> (\<forall>(nch :: bool). (\<forall>(i :: int) (j1 :: int). (0 :: int) \<le> i \<and> i < rows m4 \<longrightarrow> (0 :: int) \<le> j1 \<and> j1 < columns m4 \<longrightarrow> \<not>j1 = j \<longrightarrow> elts m4 i j1 = elts m3 i j1) \<and> (\<forall>(x :: int). mocc x m4 = mocc x m3) \<and> (nch = True \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < rows m4 \<longrightarrow> elts m4 i j = elts m3 i j)) \<and> sorted_column m4 j \<and> inversions m4 \<le> inversions m3 \<and> (\<not>nch = True \<longrightarrow> inversions m4 < inversions m3) \<longrightarrow> (if \<not>nch = True then (False = True \<longrightarrow> (\<forall>(i :: int) (j1 :: int). (0 :: int) \<le> i \<and> i < rows m4 \<longrightarrow> (0 :: int) \<le> j1 \<and> j1 < columns m4 \<longrightarrow> elts m4 i j1 = elts m2 i j1)) \<and> (\<forall>(l :: int). (0 :: int) \<le> l \<and> l < j + (1 :: int) \<longrightarrow> sorted_column m4 l) \<and> (\<forall>(x :: int). mocc x m4 = mocc x m) \<and> inversions m4 \<le> inversions m2 \<and> (\<not>False = True \<longrightarrow> inversions m4 < inversions m2) else (nochange = True \<longrightarrow> (\<forall>(i :: int) (j1 :: int). (0 :: int) \<le> i \<and> i < rows m4 \<longrightarrow> (0 :: int) \<le> j1 \<and> j1 < columns m4 \<longrightarrow> elts m4 i j1 = elts m2 i j1)) \<and> (\<forall>(l :: int). (0 :: int) \<le> l \<and> l < j + (1 :: int) \<longrightarrow> sorted_column m4 l) \<and> (\<forall>(x :: int). mocc x m4 = mocc x m) \<and> inversions m4 \<le> inversions m2 \<and> (\<not>nochange = True \<longrightarrow> inversions m4 < inversions m2))))) \<and> ((nochange = True \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < rows m3 \<longrightarrow> (0 :: int) \<le> j \<and> j < columns m3 \<longrightarrow> elts m3 i j = elts m2 i j)) \<and> (\<forall>(l :: int). (0 :: int) \<le> l \<and> l < o2 + (1 :: int) \<longrightarrow> sorted_column m3 l) \<and> (\<forall>(x :: int). mocc x m3 = mocc x m) \<and> inversions m3 \<le> inversions m2 \<and> (\<not>nochange = True \<longrightarrow> inversions m3 < inversions m2) \<longrightarrow> (if nochange = True then (\<forall>(i :: int) (j :: int) (k :: int) (l :: int). ((0 :: int) \<le> i \<and> i < columns m) \<and> ((0 :: int) \<le> j \<and> j < columns m) \<and> ((0 :: int) \<le> k \<and> k < columns m) \<and> ((0 :: int) \<le> l \<and> l < columns m) \<and> lt i j k l \<longrightarrow> elts m3 i j \<le> elts m3 k l) \<and> snake_order m3 \<and> (\<forall>(x :: int). mocc x m3 = mocc x m) else ((0 :: int) \<le> inversions m1 \<and> inversions m3 < inversions m1) \<and> (\<forall>(x :: int). mocc x m3 = mocc x m))))) \<and> (o2 + (1 :: int) < (0 :: int) \<longrightarrow> (\<forall>(i :: int) (j :: int) (k :: int) (l :: int). ((0 :: int) \<le> i \<and> i < columns m) \<and> ((0 :: int) \<le> j \<and> j < columns m) \<and> ((0 :: int) \<le> k \<and> k < columns m) \<and> ((0 :: int) \<le> l \<and> l < columns m) \<and> lt i j k l \<longrightarrow> elts m2 i j \<le> elts m2 k l) \<and> snake_order m2 \<and> (\<forall>(x :: int). mocc x m2 = mocc x m)))))) \<and> (o1 + (1 :: int) < (0 :: int) \<longrightarrow> (let o2 :: int = columns m - (1 :: int) in ((0 :: int) \<le> o2 + (1 :: int) \<longrightarrow> ((\<forall>(l :: int). (0 :: int) \<le> l \<and> l < (0 :: int) \<longrightarrow> sorted_column m1 l) \<and> (\<forall>(x :: int). mocc x m1 = mocc x m) \<and> inversions m1 \<le> inversions m1) \<and> (\<forall>(nochange :: bool) (m2 :: int matrix). rows m2 = rows m1 \<and> columns m2 = columns m1 \<longrightarrow> (\<forall>(j :: int). ((0 :: int) \<le> j \<and> j \<le> o2) \<and> (nochange = True \<longrightarrow> (\<forall>(i :: int) (j1 :: int). (0 :: int) \<le> i \<and> i < rows m2 \<longrightarrow> (0 :: int) \<le> j1 \<and> j1 < columns m2 \<longrightarrow> elts m2 i j1 = elts m1 i j1)) \<and> (\<forall>(l :: int). (0 :: int) \<le> l \<and> l < j \<longrightarrow> sorted_column m2 l) \<and> (\<forall>(x :: int). mocc x m2 = mocc x m) \<and> inversions m2 \<le> inversions m1 \<and> (\<not>nochange = True \<longrightarrow> inversions m2 < inversions m1) \<longrightarrow> ((0 :: int) \<le> j \<and> j < columns m2) \<and> (\<forall>(m3 :: int matrix). rows m3 = rows m2 \<and> columns m3 = columns m2 \<longrightarrow> (\<forall>(nch :: bool). (\<forall>(i :: int) (j1 :: int). (0 :: int) \<le> i \<and> i < rows m3 \<longrightarrow> (0 :: int) \<le> j1 \<and> j1 < columns m3 \<longrightarrow> \<not>j1 = j \<longrightarrow> elts m3 i j1 = elts m2 i j1) \<and> (\<forall>(x :: int). mocc x m3 = mocc x m2) \<and> (nch = True \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < rows m3 \<longrightarrow> elts m3 i j = elts m2 i j)) \<and> sorted_column m3 j \<and> inversions m3 \<le> inversions m2 \<and> (\<not>nch = True \<longrightarrow> inversions m3 < inversions m2) \<longrightarrow> (if \<not>nch = True then (False = True \<longrightarrow> (\<forall>(i :: int) (j1 :: int). (0 :: int) \<le> i \<and> i < rows m3 \<longrightarrow> (0 :: int) \<le> j1 \<and> j1 < columns m3 \<longrightarrow> elts m3 i j1 = elts m1 i j1)) \<and> (\<forall>(l :: int). (0 :: int) \<le> l \<and> l < j + (1 :: int) \<longrightarrow> sorted_column m3 l) \<and> (\<forall>(x :: int). mocc x m3 = mocc x m) \<and> inversions m3 \<le> inversions m1 \<and> (\<not>False = True \<longrightarrow> inversions m3 < inversions m1) else (nochange = True \<longrightarrow> (\<forall>(i :: int) (j1 :: int). (0 :: int) \<le> i \<and> i < rows m3 \<longrightarrow> (0 :: int) \<le> j1 \<and> j1 < columns m3 \<longrightarrow> elts m3 i j1 = elts m1 i j1)) \<and> (\<forall>(l :: int). (0 :: int) \<le> l \<and> l < j + (1 :: int) \<longrightarrow> sorted_column m3 l) \<and> (\<forall>(x :: int). mocc x m3 = mocc x m) \<and> inversions m3 \<le> inversions m1 \<and> (\<not>nochange = True \<longrightarrow> inversions m3 < inversions m1))))) \<and> ((nochange = True \<longrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < rows m2 \<longrightarrow> (0 :: int) \<le> j \<and> j < columns m2 \<longrightarrow> elts m2 i j = elts m1 i j)) \<and> (\<forall>(l :: int). (0 :: int) \<le> l \<and> l < o2 + (1 :: int) \<longrightarrow> sorted_column m2 l) \<and> (\<forall>(x :: int). mocc x m2 = mocc x m) \<and> inversions m2 \<le> inversions m1 \<and> (\<not>nochange = True \<longrightarrow> inversions m2 < inversions m1) \<longrightarrow> (if nochange = True then (\<forall>(i :: int) (j :: int) (k :: int) (l :: int). ((0 :: int) \<le> i \<and> i < columns m) \<and> ((0 :: int) \<le> j \<and> j < columns m) \<and> ((0 :: int) \<le> k \<and> k < columns m) \<and> ((0 :: int) \<le> l \<and> l < columns m) \<and> lt i j k l \<longrightarrow> elts m2 i j \<le> elts m2 k l) \<and> snake_order m2 \<and> (\<forall>(x :: int). mocc x m2 = mocc x m) else ((0 :: int) \<le> inversions m1 \<and> inversions m2 < inversions m1) \<and> (\<forall>(x :: int). mocc x m2 = mocc x m))))) \<and> (o2 + (1 :: int) < (0 :: int) \<longrightarrow> (\<forall>(i :: int) (j :: int) (k :: int) (l :: int). ((0 :: int) \<le> i \<and> i < columns m) \<and> ((0 :: int) \<le> j \<and> j < columns m) \<and> ((0 :: int) \<le> k \<and> k < columns m) \<and> ((0 :: int) \<le> l \<and> l < columns m) \<and> lt i j k l \<longrightarrow> elts m1 i j \<le> elts m1 k l) \<and> snake_order m1 \<and> (\<forall>(x :: int). mocc x m1 = mocc x m))))"
  sorry
end
