theory verifythis_2021_shearsort_ShearSort_permut_swapqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.int_NumOf" "Why3STD.int_Sum" "Why3STD.map_MapExt" "Why3STD.map_MapPermut" "Why3STD.matrix_Matrix"
begin
consts column :: "'a matrix \<Rightarrow> int \<Rightarrow> int \<Rightarrow> 'a"
axiomatization where column'def:   "column m j i = elts m i j"
  for m :: "'a matrix"
  and j :: "int"
  and i :: "int"
consts moccf :: "'a \<Rightarrow> (int \<Rightarrow> int \<Rightarrow> 'a) \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
axiomatization where moccf'def:   "moccf x e c i = int (map_occ x (e i) (0 :: int) c)"
  for x :: "'a"
  and e :: "int \<Rightarrow> int \<Rightarrow> 'a"
  and c :: "int"
  and i :: "int"
definition mocc :: "'a \<Rightarrow> (int \<Rightarrow> int \<Rightarrow> 'a) \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
  where "mocc x e r c = sum (moccf x e c) (0 :: int) r" for x e r c
theorem permut_swap'vc:
  fixes l :: "int"
  fixes x :: "int"
  fixes u :: "int"
  fixes y :: "int"
  fixes a :: "int \<Rightarrow> 'a"
  fixes b :: "int \<Rightarrow> 'a"
  assumes fact0: "l \<le> x"
  assumes fact1: "x < u"
  assumes fact2: "l \<le> y"
  assumes fact3: "y < u"
  assumes fact4: "\<forall>(i :: int). (l \<le> i \<and> i \<le> u) \<and> \<not>i = x \<and> \<not>i = y \<longrightarrow> a i = b i"
  assumes fact5: "a x = b y"
  assumes fact6: "a y = b x"
  shows "permut a b l u"
  sorry
end
