From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.why3.Ref.Ref.
Require Import Why3.int.NumOf.
Require Import Why3.int.Sum.
Require Import Why3.map.MapExt.
Require Import Why3.map.MapPermut.
Require Import Why3.matrix.Matrix.
Open Scope Z_scope.
Axiom column : forall {α : Type} `{Inhabited α}, matrix α -> Z -> Z -> α.
Axiom column'def : forall  {α : Type} `{Inhabited α} (m : matrix α) (j : Z) (i : Z), column m j i = elts m i j.
Axiom moccf : forall {α : Type} `{Inhabited α}, α -> (Z -> Z -> α) -> Z -> Z -> Z.
Axiom moccf'def : forall  {α : Type} `{Inhabited α} (x : α) (e : Z -> Z -> α) (c : Z) (i : Z), moccf x e c i = Z.of_nat (map_occ_list x (e i) 0%Z c).
Definition mocc {α : Type} `{Inhabited α} (x : α) (e : Z -> Z -> α) (r : Z) (c : Z) : Z := sum (moccf x e c) 0%Z r.
Axiom compose : forall {γ : Type} `{Inhabited γ} {β : Type} `{Inhabited β} {α : Type} `{Inhabited α}, (β -> γ) -> (α -> β) -> α -> γ.
Axiom compose'def : forall  {γ : Type} {β : Type} {α : Type} `{Inhabited γ} `{Inhabited β} `{Inhabited α} (g : β -> γ) (f : α -> β) (x : α), compose g f x = g (f x).
Definition below_column (e : Z -> Z -> Z) (col : Z) (v : Z) (row : Z) := e row col ≤ v.
Definition above_column (e : Z -> Z -> Z) (col : Z) (v : Z) (row : Z) := v < e row col.
Axiom fc : Z -> Z.
Axiom fc1 : Z -> Z.
Axiom fc2 : Z -> Z -> Z.
Axiom fc3 : Z -> Z -> Z.
Axiom fc4 : Z -> Z -> Z.
Axiom fc5 : Z -> Z.
Axiom fc6 : Z -> Z.
Axiom fc7 : Z -> Z -> Z.
Axiom below_column_closure : (Z -> Z -> Z) -> Z -> Z -> Z -> bool.
Axiom above_column_closure : (Z -> Z -> Z) -> Z -> Z -> Z -> bool.
Axiom column_closure : forall {α : Type} `{Inhabited α}, matrix α -> Z -> Z -> α.
Axiom fc8 : Z -> Z.
Axiom fc9 : Z -> Z.
Axiom fc10 : Z -> Z -> Z.
Axiom fc11 : Z -> Z -> Z.
Axiom fc12 : Z -> Z -> Z.
Axiom fc13 : Z -> Z.
Axiom fc14 : Z -> Z.
Axiom fc15 : Z -> Z -> Z.
Axiom fc'def : forall  (x : Z), fc x = 0%Z.
Axiom fc'def1 : forall  (x : Z), fc1 x = 0%Z.
Axiom fc'def2 : forall  (n : Z) (x : Z), fc2 n x = n.
Axiom fc'def3 : forall  (n : Z) (x : Z), fc3 n x = n.
Axiom fc'def4 : forall  (n : Z) (x : Z), fc4 n x = n.
Axiom fc'def5 : forall  (x : Z), fc5 x = 0%Z.
Axiom fc'def6 : forall  (x : Z), fc6 x = 0%Z.
Axiom fc'def7 : forall  (n : Z) (x : Z), fc7 n x = n.
Axiom below_column_closure_def : forall  (y : Z -> Z -> Z) (y1 : Z) (y2 : Z) (y3 : Z), (below_column_closure y y1 y2 y3 = true) = below_column y y1 y2 y3.
Axiom above_column_closure_def : forall  (y : Z -> Z -> Z) (y1 : Z) (y2 : Z) (y3 : Z), (above_column_closure y y1 y2 y3 = true) = above_column y y1 y2 y3.
Axiom column_closure_def : forall  {α : Type} `{Inhabited α} (y : matrix α) (y1 : Z), column_closure y y1 = column y y1.
Axiom fc'def8 : forall  (x : Z), fc8 x = 0%Z.
Axiom fc'def9 : forall  (x : Z), fc9 x = 0%Z.
Axiom fc'def10 : forall  (n : Z) (x : Z), fc10 n x = n.
Axiom fc'def11 : forall  (n : Z) (x : Z), fc11 n x = n.
Axiom fc'def12 : forall  (n : Z) (x : Z), fc12 n x = n.
Axiom fc'def13 : forall  (x : Z), fc13 x = 0%Z.
Axiom fc'def14 : forall  (x : Z), fc14 x = 0%Z.
Axiom fc'def15 : forall  (n : Z) (x : Z), fc15 n x = n.
Theorem shear_sort'vc (m : matrix Z) : let n : Z := rows m in let c : Z := columns m in if decide (¬ n = 0%Z) then let o1 : Z := n - 1%Z in ((0%Z ≤ 0%Z ∧ 0%Z ≤ o1) ∧ o1 * Z.pow 2%Z 0%Z < n ∧ n ≤ Z.pow 2%Z 0%Z * (o1 + 1%Z)) ∧ (∀(p : Z) (l : Z), (0%Z ≤ l ∧ 0%Z ≤ p) ∧ (¬ l = 0%Z -> Z.pow 2%Z (l - 1%Z) ≤ n) ∧ p * Z.pow 2%Z l < n ∧ n ≤ Z.pow 2%Z l * (p + 1%Z) -> (if decide (¬ p = 0%Z) then ¬ 2%Z = 0%Z ∧ (0%Z ≤ p ∧ Z.rem p 2%Z < p) ∧ (0%Z ≤ l + 1%Z ∧ 0%Z ≤ Z.rem p 2%Z) ∧ (¬ l + 1%Z = 0%Z -> Z.pow 2%Z (l + 1%Z - 1%Z) ≤ n) ∧ Z.rem p 2%Z * Z.pow 2%Z (l + 1%Z) < n ∧ n ≤ Z.pow 2%Z (l + 1%Z) * (Z.rem p 2%Z + 1%Z) else (∀(ones : Z -> Z) (zeros : Z -> Z) (m1 : matrix Z), rows m1 = rows m ∧ columns m1 = columns m -> (∀(v : Z), 0%Z ≤ zeros v ∧ zeros v ≤ ones v ∧ ones v ≤ n) ∧ (∀(v : Z), ones v ≤ zeros v + 1%Z) ∧ (∀(v : Z) (i : Z) (j : Z), (0%Z ≤ i ∧ i < zeros v) ∧ 0%Z ≤ j ∧ j < c -> elts m1 i j ≤ v) ∧ (∀(v : Z) (i : Z) (j : Z), (ones v ≤ i ∧ i < n) ∧ 0%Z ≤ j ∧ j < c -> v < elts m1 i j) -> (∀(i : Z) (j1 : Z) (j2 : Z) (k : Z), (0%Z ≤ i ∧ i < k ∧ k < n) ∧ (0%Z ≤ j1 ∧ j1 < c) ∧ 0%Z ≤ j2 ∧ j2 < c -> elts m1 i j1 ≤ elts m1 k j2)) ∧ (0%Z ≤ l + 1%Z -> ((∀(v : Z), 0%Z ≤ fc v ∧ fc1 v ≤ fc2 n v ∧ fc3 n v ≤ n) ∧ (∀(v : Z), fc4 n v ≤ fc5 v + n) ∧ (∀(v : Z) (i : Z) (j : Z), (0%Z ≤ i ∧ i < fc6 v) ∧ 0%Z ≤ j ∧ j < c -> elts m i j ≤ v) ∧ (∀(v : Z) (i : Z) (j : Z), (fc7 n v ≤ i ∧ i < n) ∧ 0%Z ≤ j ∧ j < c -> v < elts m i j) ∧ 0%Z < n ∧ ((n - 1%Z) * Z.pow 2%Z 0%Z < n ∧ n ≤ n * Z.pow 2%Z 0%Z) ∧ (l < 0%Z -> (∀(i : Z) (j : Z) (k : Z), (0%Z ≤ i ∧ i < n) ∧ 0%Z ≤ j ∧ j ≤ k ∧ k < c -> (let a : Z := elts m i j in let b : Z := elts m i k in if decide (Z.quot i 2%Z = 0%Z) then a ≤ b else b ≤ a)))) ∧ (∀(ones : Z -> Z) (zeros : Z -> Z) (k : Z) (m1 : matrix Z), rows m1 = rows m ∧ columns m1 = columns m -> (∀(ind : Z), (0%Z ≤ ind ∧ ind ≤ l) ∧ (∀(v : Z), 0%Z ≤ zeros v ∧ zeros v ≤ ones v ∧ ones v ≤ n) ∧ (∀(v : Z), ones v ≤ zeros v + k) ∧ (∀(v : Z) (i : Z) (j : Z), (0%Z ≤ i ∧ i < zeros v) ∧ 0%Z ≤ j ∧ j < c -> elts m1 i j ≤ v) ∧ (∀(v : Z) (i : Z) (j : Z), (ones v ≤ i ∧ i < n) ∧ 0%Z ≤ j ∧ j < c -> v < elts m1 i j) ∧ 0%Z < k ∧ ((k - 1%Z) * Z.pow 2%Z ind < n ∧ n ≤ k * Z.pow 2%Z ind) ∧ (l < ind -> (∀(i : Z) (j : Z) (k1 : Z), (0%Z ≤ i ∧ i < n) ∧ 0%Z ≤ j ∧ j ≤ k1 ∧ k1 < c -> (let a : Z := elts m1 i j in let b : Z := elts m1 i k1 in if decide (Z.quot i 2%Z = 0%Z) then a ≤ b else b ≤ a))) ∧ (∀(x : Z), mocc x (elts m) n c = mocc x (elts m1) n c) -> (∀(m2 : matrix Z), rows m2 = rows m1 ∧ columns m2 = columns m1 -> (∀(i : Z), 0%Z ≤ i ∧ i < rows m2 -> permut (elts m2 i) (elts m1 i) 0%Z (columns m2)) ∧ (∀(i : Z) (j : Z) (k1 : Z), (0%Z ≤ i ∧ i < rows m2) ∧ 0%Z ≤ j ∧ j ≤ k1 ∧ k1 < columns m2 -> (let a : Z := elts m2 i j in let b : Z := elts m2 i k1 in if decide (Z.quot i 2%Z = 0%Z) then a ≤ b else b ≤ a)) -> (let e : Z -> Z -> Z := elts m2 in ¬ 2%Z = 0%Z ∧ (let kd : Z := Z.rem (k + 1%Z) 2%Z in (∀(v : Z), let z : Z := zeros v in let o2 : Z := ones v in ((z ≤ z ∧ z ≤ o2) ∧ (z ≤ z ∧ o2 ≤ o2) ∧ z - z = 2%Z * (z - z + o2 - o2) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < c -> z ≤ numof (below_column_closure e j v) 0%Z z ∧ n - o2 ≤ numof (above_column_closure e j v) 0%Z z + numof (above_column_closure e j v) o2 n)) ∧ (∀(index : Z) (no : Z) (nz : Z), (z ≤ index ∧ index ≤ o2) ∧ (z ≤ nz ∧ no ≤ o2) ∧ index - z = 2%Z * (nz - z + o2 - no) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < c -> nz ≤ numof (below_column_closure e j v) 0%Z index ∧ n - no ≤ numof (above_column_closure e j v) 0%Z index + numof (above_column_closure e j v) o2 n) -> (if decide (index + 1%Z < o2) then (∀(r1 : Z -> Z) (r2 : Z -> Z) (b : bool), (∀(j : Z) (k1 : Z), 0%Z ≤ j ∧ j ≤ k1 ∧ k1 < c -> (if decide (b = true) then r1 j ≤ r1 k1 else r1 k1 ≤ r1 j)) ∧ (∀(j : Z) (k1 : Z), 0%Z ≤ j ∧ j ≤ k1 ∧ k1 < c -> (if decide (b = true) then r2 k1 ≤ r2 j else r2 j ≤ r2 k1)) -> (if decide (¬ b = true) then ((0%Z ≤ (if decide (b = true) then 0%Z else 1%Z) ∧ (if decide True then 0%Z else 1%Z) < (if decide (b = true) then 0%Z else 1%Z)) ∧ (∀(j : Z) (k1 : Z), 0%Z ≤ j ∧ j ≤ k1 ∧ k1 < c -> r2 j ≤ r2 k1) ∧ (∀(j : Z) (k1 : Z), 0%Z ≤ j ∧ j ≤ k1 ∧ k1 < c -> r1 k1 ≤ r1 j)) ∧ (∀(result : bool), (result = true -> (∀(i : Z), 0%Z ≤ i ∧ i < c -> r2 i ≤ v ∨ r1 i ≤ v)) ∧ (¬ result = true -> (∀(i : Z), 0%Z ≤ i ∧ i < c -> v < r2 i ∨ v < r1 i)) -> (result = true -> (∀(i : Z), 0%Z ≤ i ∧ i < c -> r1 i ≤ v ∨ r2 i ≤ v)) ∧ (¬ result = true -> (∀(i : Z), 0%Z ≤ i ∧ i < c -> v < r1 i ∨ v < r2 i))) else ((0%Z ≤ 0%Z ∧ 0%Z ≤ c) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < 0%Z -> r1 j ≤ v ∧ v < r2 j)) ∧ (∀(i : Z), (0%Z ≤ i ∧ i ≤ c) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < i -> r1 j ≤ v ∧ v < r2 j) -> (∀(o3 : bool), (if decide (¬ i = c) then if decide (r1 i ≤ v) then o3 = (if decide (v < r2 i) then true else false) else o3 = false else o3 = false) -> (if decide (o3 = true) then (0%Z ≤ c - i ∧ c - (i + 1%Z) < c - i) ∧ (0%Z ≤ i + 1%Z ∧ i + 1%Z ≤ c) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < i + 1%Z -> r1 j ≤ v ∧ v < r2 j) else ∀(result : bool), (if decide (i = c) then result = true else result = (if decide (r2 i ≤ v) then true else false)) -> (result = true -> (∀(i1 : Z), 0%Z ≤ i1 ∧ i1 < c -> r1 i1 ≤ v ∨ r2 i1 ≤ v)) ∧ (¬ result = true -> (∀(i1 : Z), 0%Z ≤ i1 ∧ i1 < c -> v < r1 i1 ∨ v < r2 i1))))))) ∧ ¬ 2%Z = 0%Z ∧ (let o3 : Z := Z.quot index 2%Z in let o4 : Z -> Z := e (index + 1%Z) in let o5 : Z -> Z := e index in ((∀(j : Z) (k1 : Z), 0%Z ≤ j ∧ j ≤ k1 ∧ k1 < c -> (if decide (o3 = 0%Z) then o5 j ≤ o5 k1 else o5 k1 ≤ o5 j)) ∧ (∀(j : Z) (k1 : Z), 0%Z ≤ j ∧ j ≤ k1 ∧ k1 < c -> (if decide (o3 = 0%Z) then o4 k1 ≤ o4 j else o4 j ≤ o4 k1))) ∧ (∀(o6 : bool), (o6 = true -> (∀(i : Z), 0%Z ≤ i ∧ i < c -> o5 i ≤ v ∨ o4 i ≤ v)) ∧ (¬ o6 = true -> (∀(i : Z), 0%Z ≤ i ∧ i < c -> v < o5 i ∨ v < o4 i)) -> (if decide (o6 = true) then (0%Z ≤ o2 - index ∧ o2 - (index + 2%Z) < o2 - index) ∧ (z ≤ index + 2%Z ∧ index + 2%Z ≤ o2) ∧ (z ≤ nz + 1%Z ∧ no ≤ o2) ∧ index + 2%Z - z = 2%Z * (nz + 1%Z - z + o2 - no) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < c -> nz + 1%Z ≤ numof (below_column_closure e j v) 0%Z (index + 2%Z) ∧ n - no ≤ numof (above_column_closure e j v) 0%Z (index + 2%Z) + numof (above_column_closure e j v) o2 n) else (0%Z ≤ o2 - index ∧ o2 - (index + 2%Z) < o2 - index) ∧ (z ≤ index + 2%Z ∧ index + 2%Z ≤ o2) ∧ (z ≤ nz ∧ no - 1%Z ≤ o2) ∧ index + 2%Z - z = 2%Z * (nz - z + o2 - (no - 1%Z)) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < c -> nz ≤ numof (below_column_closure e j v) 0%Z (index + 2%Z) ∧ n - (no - 1%Z) ≤ numof (above_column_closure e j v) 0%Z (index + 2%Z) + numof (above_column_closure e j v) o2 n)))) else (0%Z ≤ nz ∧ nz ≤ no ∧ no ≤ n) ∧ no ≤ nz + kd ∧ (∀(j : Z), 0%Z ≤ j ∧ j < c -> nz ≤ numof (below_column_closure e j v) 0%Z n ∧ n - no ≤ numof (above_column_closure e j v) 0%Z n)))) ∧ (∀(nzo : Z -> Z * Z), (∀(v : Z), (match nzo v with | (nz, no) => (0%Z ≤ nz ∧ nz ≤ no ∧ no ≤ n) ∧ no ≤ nz + kd ∧ (∀(j : Z), 0%Z ≤ j ∧ j < c -> nz ≤ numof (below_column_closure e j v) 0%Z n ∧ n - no ≤ numof (above_column_closure e j v) 0%Z n) end)) -> (∀(v : Z), let o2 : Z * Z := nzo v in (match o2 with | (nz, no) => (0%Z ≤ nz ∧ nz ≤ no ∧ no ≤ n) ∧ no ≤ nz + kd ∧ (∀(j : Z), 0%Z ≤ j ∧ j < c -> nz ≤ numof (below_column_closure e j v) 0%Z n ∧ n - no ≤ numof (above_column_closure e j v) 0%Z n) end) -> (∀(result : Z), (match o2 with | (x, _) => result = x end) -> result = (match nzo v with | (x, _) => x end))) ∧ (∀(newz : Z -> Z), (∀(v : Z), newz v = (match nzo v with | (x, _) => x end)) -> (∀(v : Z), let o2 : Z * Z := nzo v in (match o2 with | (nz, no) => (0%Z ≤ nz ∧ nz ≤ no ∧ no ≤ n) ∧ no ≤ nz + kd ∧ (∀(j : Z), 0%Z ≤ j ∧ j < c -> nz ≤ numof (below_column_closure e j v) 0%Z n ∧ n - no ≤ numof (above_column_closure e j v) 0%Z n) end) -> (∀(result : Z), (match o2 with | (_, y) => result = y end) -> result = (match nzo v with | (_, y) => y end))) ∧ (∀(newo : Z -> Z), (∀(v : Z), newo v = (match nzo v with | (_, y) => y end)) -> (ind = l -> (∀(v : Z), 0%Z ≤ zeros v ∧ zeros v ≤ ones v ∧ ones v ≤ n) ∧ (∀(v : Z), ones v ≤ zeros v + 1%Z) ∧ (∀(v : Z) (i : Z) (j : Z), (0%Z ≤ i ∧ i < zeros v) ∧ 0%Z ≤ j ∧ j < c -> elts m2 i j ≤ v) ∧ (∀(v : Z) (i : Z) (j : Z), (ones v ≤ i ∧ i < n) ∧ 0%Z ≤ j ∧ j < c -> v < elts m2 i j)) ∧ ((ind = l -> (∀(i : Z) (j1 : Z) (j2 : Z) (k1 : Z), (0%Z ≤ i ∧ i < k1 ∧ k1 < n) ∧ (0%Z ≤ j1 ∧ j1 < c) ∧ 0%Z ≤ j2 ∧ j2 < c -> elts m2 i j1 ≤ elts m2 k1 j2)) -> (∀(m3 : matrix Z), rows m3 = rows m2 ∧ columns m3 = columns m2 -> (∀(j : Z), 0%Z ≤ j ∧ j < columns m3 -> permut (column m3 j) (column m2 j) 0%Z (rows m3)) ∧ (∀(i : Z) (j : Z) (k1 : Z), (0%Z ≤ i ∧ i ≤ k1 ∧ k1 < rows m3) ∧ 0%Z ≤ j ∧ j < columns m3 -> elts m3 i j ≤ elts m3 k1 j) -> (let cl2 : Z -> Z -> Z := column_closure m3 in let e1 : Z -> Z -> Z := elts m3 in (∀(v : Z) (i : Z) (j : Z), (0%Z ≤ i ∧ i < n) ∧ (0%Z < numof (below_column_closure e1 j v) (i + 1%Z) n ∧ 0%Z ≤ j ∧ j < c) ∧ v < cl2 j i -> (let o2 : Z := i + 1%Z in (0%Z ≤ n - i ∧ n - o2 < n - i) ∧ (0%Z ≤ o2 ∧ o2 < n) ∧ (0%Z < numof (below_column_closure e1 j v) (o2 + 1%Z) n ∧ 0%Z ≤ j ∧ j < c) ∧ v < cl2 j o2)) ∧ (∀(v : Z) (i : Z) (j : Z), (0%Z ≤ i ∧ i < n) ∧ (0%Z < numof (above_column_closure e1 j v) 0%Z i ∧ 0%Z ≤ j ∧ j < c) ∧ cl2 j i ≤ v -> (let o2 : Z := i - 1%Z in (0%Z ≤ i ∧ o2 < i) ∧ (0%Z ≤ o2 ∧ o2 < n) ∧ (0%Z < numof (above_column_closure e1 j v) 0%Z o2 ∧ 0%Z ≤ j ∧ j < c) ∧ cl2 j o2 ≤ v)) ∧ (∀(v : Z), 0%Z ≤ newz v ∧ newz v ≤ newo v ∧ newo v ≤ n) ∧ (∀(v : Z), newo v ≤ newz v + kd) ∧ (∀(v : Z) (i : Z) (j : Z), (0%Z ≤ i ∧ i < newz v) ∧ 0%Z ≤ j ∧ j < c -> elts m3 i j ≤ v) ∧ (∀(v : Z) (i : Z) (j : Z), (newo v ≤ i ∧ i < n) ∧ 0%Z ≤ j ∧ j < c -> v < elts m3 i j) ∧ 0%Z < kd ∧ ((kd - 1%Z) * Z.pow 2%Z (ind + 1%Z) < n ∧ n ≤ kd * Z.pow 2%Z (ind + 1%Z)) ∧ (l < ind + 1%Z -> (∀(i : Z) (j : Z) (k1 : Z), (0%Z ≤ i ∧ i < n) ∧ 0%Z ≤ j ∧ j ≤ k1 ∧ k1 < c -> (let a : Z := elts m3 i j in let b : Z := elts m3 i k1 in if decide (Z.quot i 2%Z = 0%Z) then a ≤ b else b ≤ a))) ∧ (∀(x : Z), mocc x (elts m) n c = mocc x (elts m3) n c))))))))))) ∧ ((∀(v : Z), 0%Z ≤ zeros v ∧ zeros v ≤ ones v ∧ ones v ≤ n) ∧ (∀(v : Z), ones v ≤ zeros v + k) ∧ (∀(v : Z) (i : Z) (j : Z), (0%Z ≤ i ∧ i < zeros v) ∧ 0%Z ≤ j ∧ j < c -> elts m1 i j ≤ v) ∧ (∀(v : Z) (i : Z) (j : Z), (ones v ≤ i ∧ i < n) ∧ 0%Z ≤ j ∧ j < c -> v < elts m1 i j) ∧ 0%Z < k ∧ ((k - 1%Z) * Z.pow 2%Z (l + 1%Z) < n ∧ n ≤ k * Z.pow 2%Z (l + 1%Z)) ∧ (l < l + 1%Z -> (∀(i : Z) (j : Z) (k1 : Z), (0%Z ≤ i ∧ i < n) ∧ 0%Z ≤ j ∧ j ≤ k1 ∧ k1 < c -> (let a : Z := elts m1 i j in let b : Z := elts m1 i k1 in if decide (Z.quot i 2%Z = 0%Z) then a ≤ b else b ≤ a))) ∧ (∀(x : Z), mocc x (elts m) n c = mocc x (elts m1) n c) -> ((∀(v : Z), 0%Z ≤ zeros v ∧ zeros v ≤ ones v ∧ ones v ≤ n) ∧ (∀(v : Z), ones v ≤ zeros v + 1%Z) ∧ (∀(v : Z) (i : Z) (j : Z), (0%Z ≤ i ∧ i < zeros v) ∧ 0%Z ≤ j ∧ j < c -> elts m1 i j ≤ v) ∧ (∀(v : Z) (i : Z) (j : Z), (ones v ≤ i ∧ i < n) ∧ 0%Z ≤ j ∧ j < c -> v < elts m1 i j)) ∧ ((∀(i : Z) (j1 : Z) (j2 : Z) (k1 : Z), (0%Z ≤ i ∧ i < k1 ∧ k1 < n) ∧ (0%Z ≤ j1 ∧ j1 < c) ∧ 0%Z ≤ j2 ∧ j2 < c -> elts m1 i j1 ≤ elts m1 k1 j2) -> (∀(i : Z) (j1 : Z) (j2 : Z) (k1 : Z), (0%Z ≤ i ∧ i < k1 ∧ k1 < rows m1) ∧ (0%Z ≤ j1 ∧ j1 < columns m1) ∧ 0%Z ≤ j2 ∧ j2 < columns m1 -> elts m1 i j1 ≤ elts m1 k1 j2) ∧ (∀(i : Z) (j : Z) (k1 : Z), (0%Z ≤ i ∧ i < rows m1) ∧ 0%Z ≤ j ∧ j ≤ k1 ∧ k1 < columns m1 -> (if decide (Z.quot i 2%Z = 0%Z) then elts m1 i j ≤ elts m1 i k1 else elts m1 i k1 ≤ elts m1 i j)) ∧ (∀(x : Z), mocc x (elts m) (rows m1) (columns m1) = mocc x (elts m1) (rows m1) (columns m1)))))) ∧ (l + 1%Z < 0%Z -> ((∀(v : Z), 0%Z ≤ fc8 v ∧ fc9 v ≤ fc10 n v ∧ fc11 n v ≤ n) ∧ (∀(v : Z), fc12 n v ≤ fc13 v + 1%Z) ∧ (∀(v : Z) (i : Z) (j : Z), (0%Z ≤ i ∧ i < fc14 v) ∧ 0%Z ≤ j ∧ j < c -> elts m i j ≤ v) ∧ (∀(v : Z) (i : Z) (j : Z), (fc15 n v ≤ i ∧ i < n) ∧ 0%Z ≤ j ∧ j < c -> v < elts m i j)) ∧ ((∀(i : Z) (j1 : Z) (j2 : Z) (k : Z), (0%Z ≤ i ∧ i < k ∧ k < n) ∧ (0%Z ≤ j1 ∧ j1 < c) ∧ 0%Z ≤ j2 ∧ j2 < c -> elts m i j1 ≤ elts m k j2) -> (∀(i : Z) (j1 : Z) (j2 : Z) (k : Z), (0%Z ≤ i ∧ i < k ∧ k < rows m) ∧ (0%Z ≤ j1 ∧ j1 < columns m) ∧ 0%Z ≤ j2 ∧ j2 < columns m -> elts m i j1 ≤ elts m k j2) ∧ (∀(i : Z) (j : Z) (k : Z), (0%Z ≤ i ∧ i < rows m) ∧ 0%Z ≤ j ∧ j ≤ k ∧ k < columns m -> (if decide (Z.quot i 2%Z = 0%Z) then elts m i j ≤ elts m i k else elts m i k ≤ elts m i j)))))) else (∀(i : Z) (j1 : Z) (j2 : Z) (k : Z), (0%Z ≤ i ∧ i < k ∧ k < rows m) ∧ (0%Z ≤ j1 ∧ j1 < columns m) ∧ 0%Z ≤ j2 ∧ j2 < columns m -> elts m i j1 ≤ elts m k j2) ∧ (∀(i : Z) (j : Z) (k : Z), (0%Z ≤ i ∧ i < rows m) ∧ 0%Z ≤ j ∧ j ≤ k ∧ k < columns m -> (if decide (Z.quot i 2%Z = 0%Z) then elts m i j ≤ elts m i k else elts m i k ≤ elts m i j)).
Admitted.
