theory verifythis_2024_challenge1_Top_smart_array_copy_1qtvc
  imports "NTP4Verif.NTP4Verif"
begin
definition permutation :: "int \<Rightarrow> int list \<Rightarrow> _"
  where "permutation l p \<longleftrightarrow> ((0 :: int) \<le> l \<and> l \<le> int (length p)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < l \<longrightarrow> (0 :: int) \<le> p ! nat i \<and> p ! nat i < l) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < l \<longrightarrow> (0 :: int) \<le> j \<and> j < l \<longrightarrow> \<not>i = j \<longrightarrow> \<not>p ! nat i = p ! nat j)" for l p
definition permutation_pair :: "int \<Rightarrow> int list \<Rightarrow> int list \<Rightarrow> _"
  where "permutation_pair l p invp \<longleftrightarrow> permutation l p \<and> permutation l invp \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < l \<longrightarrow> p ! nat (invp ! nat i) = i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < l \<longrightarrow> invp ! nat (p ! nat i) = i)" for l p invp
consts identity :: "int \<Rightarrow> int list"
axiomatization where identity'spec'1:   "int (length (identity l)) = l"
 if "(0 :: int) < l"
  for l :: "int"
axiomatization where identity'spec'0:   "identity l ! nat i = i"
 if "(0 :: int) < l"
 and "(0 :: int) \<le> i"
 and "i < l"
  for l :: "int"
  and i :: "int"
axiomatization where identity'spec:   "permutation_pair l (identity l) (identity l)"
 if "(0 :: int) < l"
  for l :: "int"
typedecl  elt
definition valid_chunk :: "elt list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "valid_chunk a ofs len \<longleftrightarrow> (0 :: int) \<le> ofs \<and> ofs \<le> ofs + len \<and> ofs + len \<le> int (length a)" for a ofs len
definition copy :: "elt list \<Rightarrow> elt list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "copy src dst ofs len \<longleftrightarrow> valid_chunk src ofs len \<and> length src = length dst \<and> (\<forall>(i :: int). ofs \<le> i \<and> i < ofs + len \<longrightarrow> dst ! nat i = src ! nat i)" for src dst ofs len
definition copy_to :: "elt list \<Rightarrow> elt list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "copy_to src dst ofss ofsd len \<longleftrightarrow> valid_chunk src ofss len \<and> valid_chunk dst ofsd len \<and> length src = length dst \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < len \<longrightarrow> dst ! nat (ofsd + i) = src ! nat (ofss + i)) \<and> (\<forall>(i :: int). ofsd \<le> i \<and> i < ofsd + len \<longrightarrow> dst ! nat i = src ! nat (i + (ofss - ofsd)))" for src dst ofss ofsd len
definition copy_perm :: "elt list \<Rightarrow> elt list \<Rightarrow> int \<Rightarrow> int list \<Rightarrow> int list \<Rightarrow> _"
  where "copy_perm src dst size p invp \<longleftrightarrow> valid_chunk src (0 :: int) size \<and> length src = length dst \<and> permutation_pair size p invp \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < size \<longrightarrow> (0 :: int) \<le> p ! nat i \<and> p ! nat i < size) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < size \<longrightarrow> (0 :: int) \<le> invp ! nat i \<and> invp ! nat i < size) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < size \<longrightarrow> dst ! nat i = src ! nat (p ! nat i)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < size \<longrightarrow> src ! nat i = dst ! nat (invp ! nat i))" for src dst size p invp
definition copy_subsegment :: "elt list \<Rightarrow> elt list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int list \<Rightarrow> int list \<Rightarrow> int list \<Rightarrow> int list \<Rightarrow> _"
  where "copy_subsegment src dst s k l j sigma tau p invp \<longleftrightarrow> (let start :: int = s * (k * l); starts :: int = start + sigma ! nat j * k; startd :: int = start + tau ! nat (sigma ! nat j) * k in copy_to src dst starts startd k \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < k \<longrightarrow> p ! nat (startd + i) = starts + i) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < k \<longrightarrow> invp ! nat (starts + i) = startd + i))" for src dst s k l j sigma tau p invp
definition frame :: "'a list \<Rightarrow> 'a list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "frame a1 a2 ofs len \<longleftrightarrow> length a2 = length a1 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < ofs \<longrightarrow> a2 ! nat i = a1 ! nat i) \<and> (\<forall>(i :: int). ofs + len \<le> i \<and> i < int (length a2) \<longrightarrow> a2 ! nat i = a1 ! nat i)" for a1 a2 ofs len
theorem smart_array_copy_1'vc:
  fixes src :: "elt list"
  fixes dst :: "elt list"
  fixes k :: "int"
  fixes l :: "int"
  fixes q :: "int"
  fixes r :: "int"
  assumes fact0: "length src = length dst"
  assumes fact1: "(0 :: int) < int (length dst)"
  assumes fact2: "(0 :: int) < k"
  assumes fact3: "(0 :: int) < l"
  assumes fact4: "(0 :: int) \<le> q"
  assumes fact5: "(0 :: int) \<le> r"
  assumes fact6: "r < k * l"
  assumes fact7: "int (length dst) = q * k * l + r"
  shows "(0 :: int) < int (length dst)"
  and "let p :: int list = identity (int (length dst)) in length p = length dst \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length dst) \<longrightarrow> p ! nat i = i) \<and> permutation_pair (int (length dst)) p p \<longrightarrow> (0 :: int) < int (length dst) \<and> (let invp :: int list = identity (int (length dst)) in length invp = length dst \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length dst) \<longrightarrow> invp ! nat i = i) \<and> permutation_pair (int (length dst)) invp invp \<longrightarrow> (let m :: int = k * l; o1 :: int = q - (1 :: int) in ((0 :: int) \<le> o1 + (1 :: int) \<longrightarrow> (permutation_pair ((0 :: int) * m) p invp \<and> copy_perm src dst ((0 :: int) * m) p invp) \<and> (\<forall>(invp1 :: int list) (p1 :: int list) (dst1 :: elt list). length invp1 = length invp \<longrightarrow> length p1 = length p \<longrightarrow> length dst1 = length dst \<longrightarrow> (\<forall>(s :: int). ((0 :: int) \<le> s \<and> s \<le> o1) \<and> permutation_pair (s * m) p1 invp1 \<and> copy_perm src dst1 (s * m) p1 invp1 \<longrightarrow> (let start :: int = s * m in (0 :: int) < l \<and> (\<forall>(sigma :: int list) (invsigma :: int list). (length sigma = length invsigma \<and> int (length invsigma) = l) \<and> permutation_pair l sigma invsigma \<longrightarrow> (0 :: int) < l \<and> (\<forall>(tau :: int list) (invtau :: int list). (length tau = length invtau \<and> int (length invtau) = l) \<and> permutation_pair l tau invtau \<longrightarrow> (let o2 :: int = l - (1 :: int) in ((0 :: int) \<le> o2 + (1 :: int) \<longrightarrow> (permutation_pair (s * m) p1 invp1 \<and> copy_perm src dst1 (s * m) p1 invp1 \<and> (\<forall>(j' :: int). (0 :: int) \<le> j' \<and> j' < (0 :: int) \<longrightarrow> copy_subsegment src dst1 s k l j' sigma tau p1 invp1)) \<and> (\<forall>(invp2 :: int list) (p2 :: int list) (dst2 :: elt list). length invp2 = length invp1 \<longrightarrow> length p2 = length p1 \<longrightarrow> length dst2 = length dst1 \<longrightarrow> (\<forall>(j :: int). ((0 :: int) \<le> j \<and> j \<le> o2) \<and> permutation_pair (s * m) p2 invp2 \<and> copy_perm src dst2 (s * m) p2 invp2 \<and> (\<forall>(j' :: int). (0 :: int) \<le> j' \<and> j' < j \<longrightarrow> copy_subsegment src dst2 s k l j' sigma tau p2 invp2) \<longrightarrow> ((0 :: int) \<le> j \<and> j < int (length sigma)) \<and> (let startsrc :: int = start + sigma ! nat j * k in ((0 :: int) \<le> j \<and> j < int (length sigma)) \<and> (let o3 :: int = sigma ! nat j in ((0 :: int) \<le> o3 \<and> o3 < int (length tau)) \<and> (let startdst :: int = start + tau ! nat o3 * k; o4 :: int = k - (1 :: int) in ((0 :: int) \<le> o4 + (1 :: int) \<longrightarrow> (frame dst2 dst2 startdst k \<and> frame p2 p2 startdst k \<and> frame invp2 invp2 startsrc k \<and> permutation_pair (s * m) p2 invp2 \<and> copy_perm src dst2 (s * m) p2 invp2 \<and> copy_to src dst2 startsrc startdst (0 :: int) \<and> (\<forall>(i' :: int). (0 :: int) \<le> i' \<and> i' < (0 :: int) \<longrightarrow> p2 ! nat (startdst + i') = startsrc + i') \<and> (\<forall>(i' :: int). (0 :: int) \<le> i' \<and> i' < (0 :: int) \<longrightarrow> invp2 ! nat (startsrc + i') = startdst + i') \<and> (\<forall>(j' :: int). (0 :: int) \<le> j' \<and> j' < j \<longrightarrow> copy_subsegment src dst2 s k l j' sigma tau p2 invp2)) \<and> (\<forall>(invp3 :: int list) (p3 :: int list) (dst3 :: elt list). length invp3 = length invp2 \<longrightarrow> length p3 = length p2 \<longrightarrow> length dst3 = length dst2 \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i \<le> o4) \<and> frame dst2 dst3 startdst k \<and> frame p2 p3 startdst k \<and> frame invp2 invp3 startsrc k \<and> permutation_pair (s * m) p3 invp3 \<and> copy_perm src dst3 (s * m) p3 invp3 \<and> copy_to src dst3 startsrc startdst i \<and> (\<forall>(i' :: int). (0 :: int) \<le> i' \<and> i' < i \<longrightarrow> p3 ! nat (startdst + i') = startsrc + i') \<and> (\<forall>(i' :: int). (0 :: int) \<le> i' \<and> i' < i \<longrightarrow> invp3 ! nat (startsrc + i') = startdst + i') \<and> (\<forall>(j' :: int). (0 :: int) \<le> j' \<and> j' < j \<longrightarrow> copy_subsegment src dst3 s k l j' sigma tau p3 invp3) \<longrightarrow> (let o5 :: int = startsrc + i in ((0 :: int) \<le> o5 \<and> o5 < int (length src)) \<and> (let o6 :: elt = src ! nat o5; o7 :: int = startdst + i in ((0 :: int) \<le> o7 \<and> o7 < int (length dst3)) \<and> (length (dst3[nat o7 := o6]) = length dst3 \<longrightarrow> nth (dst3[nat o7 := o6]) o nat = (nth dst3 o nat)(o7 := o6) \<longrightarrow> (let o8 :: int = startsrc + i; o9 :: int = startdst + i in ((0 :: int) \<le> o9 \<and> o9 < int (length p3)) \<and> (length (p3[nat o9 := o8]) = length p3 \<longrightarrow> nth (p3[nat o9 := o8]) o nat = (nth p3 o nat)(o9 := o8) \<longrightarrow> (let o10 :: int = startdst + i; o11 :: int = startsrc + i in ((0 :: int) \<le> o11 \<and> o11 < int (length invp3)) \<and> (length (invp3[nat o11 := o10]) = length invp3 \<longrightarrow> nth (invp3[nat o11 := o10]) o nat = (nth invp3 o nat)(o11 := o10) \<longrightarrow> frame dst2 (dst3[nat o7 := o6]) startdst k \<and> frame p2 (p3[nat o9 := o8]) startdst k \<and> frame invp2 (invp3[nat o11 := o10]) startsrc k \<and> permutation_pair (s * m) (p3[nat o9 := o8]) (invp3[nat o11 := o10]) \<and> copy_perm src (dst3[nat o7 := o6]) (s * m) (p3[nat o9 := o8]) (invp3[nat o11 := o10]) \<and> copy_to src (dst3[nat o7 := o6]) startsrc startdst (i + (1 :: int)) \<and> (\<forall>(i' :: int). (0 :: int) \<le> i' \<and> i' < i + (1 :: int) \<longrightarrow> p3[nat o9 := o8] ! nat (startdst + i') = startsrc + i') \<and> (\<forall>(i' :: int). (0 :: int) \<le> i' \<and> i' < i + (1 :: int) \<longrightarrow> invp3[nat o11 := o10] ! nat (startsrc + i') = startdst + i') \<and> (\<forall>(j' :: int). (0 :: int) \<le> j' \<and> j' < j \<longrightarrow> copy_subsegment src (dst3[nat o7 := o6]) s k l j' sigma tau (p3[nat o9 := o8]) (invp3[nat o11 := o10])))))))))) \<and> (frame dst2 dst3 startdst k \<and> frame p2 p3 startdst k \<and> frame invp2 invp3 startsrc k \<and> permutation_pair (s * m) p3 invp3 \<and> copy_perm src dst3 (s * m) p3 invp3 \<and> copy_to src dst3 startsrc startdst (o4 + (1 :: int)) \<and> (\<forall>(i' :: int). (0 :: int) \<le> i' \<and> i' < o4 + (1 :: int) \<longrightarrow> p3 ! nat (startdst + i') = startsrc + i') \<and> (\<forall>(i' :: int). (0 :: int) \<le> i' \<and> i' < o4 + (1 :: int) \<longrightarrow> invp3 ! nat (startsrc + i') = startdst + i') \<and> (\<forall>(j' :: int). (0 :: int) \<le> j' \<and> j' < j \<longrightarrow> copy_subsegment src dst3 s k l j' sigma tau p3 invp3) \<longrightarrow> permutation_pair (s * m) p3 invp3 \<and> copy_perm src dst3 (s * m) p3 invp3 \<and> (\<forall>(j' :: int). (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<longrightarrow> copy_subsegment src dst3 s k l j' sigma tau p3 invp3)))) \<and> (o4 + (1 :: int) < (0 :: int) \<longrightarrow> permutation_pair (s * m) p2 invp2 \<and> copy_perm src dst2 (s * m) p2 invp2 \<and> (\<forall>(j' :: int). (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<longrightarrow> copy_subsegment src dst2 s k l j' sigma tau p2 invp2)))))) \<and> (permutation_pair (s * m) p2 invp2 \<and> copy_perm src dst2 (s * m) p2 invp2 \<and> (\<forall>(j' :: int). (0 :: int) \<le> j' \<and> j' < o2 + (1 :: int) \<longrightarrow> copy_subsegment src dst2 s k l j' sigma tau p2 invp2) \<longrightarrow> permutation_pair ((s + (1 :: int)) * m) p2 invp2 \<and> copy_perm src dst2 ((s + (1 :: int)) * m) p2 invp2))) \<and> (o2 + (1 :: int) < (0 :: int) \<longrightarrow> permutation_pair ((s + (1 :: int)) * m) p1 invp1 \<and> copy_perm src dst1 ((s + (1 :: int)) * m) p1 invp1)))))) \<and> (permutation_pair ((o1 + (1 :: int)) * m) p1 invp1 \<and> copy_perm src dst1 ((o1 + (1 :: int)) * m) p1 invp1 \<longrightarrow> (let last :: int = q * m; o2 :: int = r - (1 :: int) in ((0 :: int) \<le> o2 + (1 :: int) \<longrightarrow> (permutation_pair (last + (0 :: int)) p1 invp1 \<and> copy_perm src dst1 (last + (0 :: int)) p1 invp1) \<and> (\<forall>(invp2 :: int list) (p2 :: int list) (dst2 :: elt list). length invp2 = length invp1 \<longrightarrow> length p2 = length p1 \<longrightarrow> length dst2 = length dst1 \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i \<le> o2) \<and> permutation_pair (last + i) p2 invp2 \<and> copy_perm src dst2 (last + i) p2 invp2 \<longrightarrow> (let o3 :: int = last + i in ((0 :: int) \<le> o3 \<and> o3 < int (length src)) \<and> (let o4 :: elt = src ! nat o3; o5 :: int = last + i in ((0 :: int) \<le> o5 \<and> o5 < int (length dst2)) \<and> (length (dst2[nat o5 := o4]) = length dst2 \<longrightarrow> nth (dst2[nat o5 := o4]) o nat = (nth dst2 o nat)(o5 := o4) \<longrightarrow> (let o6 :: int = last + i; o7 :: int = last + i in ((0 :: int) \<le> o7 \<and> o7 < int (length p2)) \<and> (length (p2[nat o7 := o6]) = length p2 \<longrightarrow> nth (p2[nat o7 := o6]) o nat = (nth p2 o nat)(o7 := o6) \<longrightarrow> (let o8 :: int = last + i; o9 :: int = last + i in ((0 :: int) \<le> o9 \<and> o9 < int (length invp2)) \<and> (length (invp2[nat o9 := o8]) = length invp2 \<longrightarrow> nth (invp2[nat o9 := o8]) o nat = (nth invp2 o nat)(o9 := o8) \<longrightarrow> permutation_pair (last + (i + (1 :: int))) (p2[nat o7 := o6]) (invp2[nat o9 := o8]) \<and> copy_perm src (dst2[nat o5 := o4]) (last + (i + (1 :: int))) (p2[nat o7 := o6]) (invp2[nat o9 := o8]))))))))) \<and> (permutation_pair (last + (o2 + (1 :: int))) p2 invp2 \<and> copy_perm src dst2 (last + (o2 + (1 :: int))) p2 invp2 \<longrightarrow> copy_perm src dst2 (int (length dst)) p2 invp2))) \<and> (o2 + (1 :: int) < (0 :: int) \<longrightarrow> copy_perm src dst1 (int (length dst)) p1 invp1))))) \<and> (o1 + (1 :: int) < (0 :: int) \<longrightarrow> (let last :: int = q * m; o2 :: int = r - (1 :: int) in ((0 :: int) \<le> o2 + (1 :: int) \<longrightarrow> (permutation_pair (last + (0 :: int)) p invp \<and> copy_perm src dst (last + (0 :: int)) p invp) \<and> (\<forall>(invp1 :: int list) (p1 :: int list) (dst1 :: elt list). length invp1 = length invp \<longrightarrow> length p1 = length p \<longrightarrow> length dst1 = length dst \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i \<le> o2) \<and> permutation_pair (last + i) p1 invp1 \<and> copy_perm src dst1 (last + i) p1 invp1 \<longrightarrow> (let o3 :: int = last + i in ((0 :: int) \<le> o3 \<and> o3 < int (length src)) \<and> (let o4 :: elt = src ! nat o3; o5 :: int = last + i in ((0 :: int) \<le> o5 \<and> o5 < int (length dst1)) \<and> (length (dst1[nat o5 := o4]) = length dst1 \<longrightarrow> nth (dst1[nat o5 := o4]) o nat = (nth dst1 o nat)(o5 := o4) \<longrightarrow> (let o6 :: int = last + i; o7 :: int = last + i in ((0 :: int) \<le> o7 \<and> o7 < int (length p1)) \<and> (length (p1[nat o7 := o6]) = length p1 \<longrightarrow> nth (p1[nat o7 := o6]) o nat = (nth p1 o nat)(o7 := o6) \<longrightarrow> (let o8 :: int = last + i; o9 :: int = last + i in ((0 :: int) \<le> o9 \<and> o9 < int (length invp1)) \<and> (length (invp1[nat o9 := o8]) = length invp1 \<longrightarrow> nth (invp1[nat o9 := o8]) o nat = (nth invp1 o nat)(o9 := o8) \<longrightarrow> permutation_pair (last + (i + (1 :: int))) (p1[nat o7 := o6]) (invp1[nat o9 := o8]) \<and> copy_perm src (dst1[nat o5 := o4]) (last + (i + (1 :: int))) (p1[nat o7 := o6]) (invp1[nat o9 := o8]))))))))) \<and> (permutation_pair (last + (o2 + (1 :: int))) p1 invp1 \<and> copy_perm src dst1 (last + (o2 + (1 :: int))) p1 invp1 \<longrightarrow> copy_perm src dst1 (int (length dst)) p1 invp1))) \<and> (o2 + (1 :: int) < (0 :: int) \<longrightarrow> copy_perm src dst (int (length dst)) p invp)))))"
  sorry
end
