From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Open Scope Z_scope.
Definition permutation (l : Z) (p : list Z) := (0%Z ≤ l ∧ l ≤ Z.of_nat (length p)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < l -> 0%Z ≤ nth (Z.to_nat i) p inhabitant ∧ nth (Z.to_nat i) p inhabitant < l) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < l -> 0%Z ≤ j ∧ j < l -> ¬ i = j -> ¬ nth (Z.to_nat i) p inhabitant = nth (Z.to_nat j) p inhabitant).
Definition permutation_pair (l : Z) (p : list Z) (invp : list Z) := permutation l p ∧ permutation l invp ∧ (∀(i : Z), 0%Z ≤ i ∧ i < l -> nth (Z.to_nat (nth (Z.to_nat i) invp inhabitant)) p inhabitant = i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < l -> nth (Z.to_nat (nth (Z.to_nat i) p inhabitant)) invp inhabitant = i).
Axiom identity : Z -> list Z.
Axiom identity'spec'1 : forall  (l : Z) (fact0 : 0%Z < l), Z.of_nat (length (identity l)) = l.
Axiom identity'spec'0 : forall  (l : Z) (i : Z) (fact0 : 0%Z < l) (fact1 : 0%Z ≤ i) (fact2 : i < l), nth (Z.to_nat i) (identity l) inhabitant = i.
Axiom identity'spec : forall  (l : Z) (fact0 : 0%Z < l), permutation_pair l (identity l) (identity l).
Axiom elt : Type.
Axiom elt_inhabited : Inhabited elt.
Global Existing Instance elt_inhabited.
Axiom elt_countable : Countable elt.
Global Existing Instance elt_countable.
Definition valid_chunk (a : list elt) (ofs : Z) (len : Z) := 0%Z ≤ ofs ∧ ofs ≤ ofs + len ∧ ofs + len ≤ Z.of_nat (length a).
Definition copy (src : list elt) (dst : list elt) (ofs : Z) (len : Z) := valid_chunk src ofs len ∧ length src = length dst ∧ (∀(i : Z), ofs ≤ i ∧ i < ofs + len -> nth (Z.to_nat i) dst inhabitant = nth (Z.to_nat i) src inhabitant).
Definition copy_to (src : list elt) (dst : list elt) (ofss : Z) (ofsd : Z) (len : Z) := valid_chunk src ofss len ∧ valid_chunk dst ofsd len ∧ length src = length dst ∧ (∀(i : Z), 0%Z ≤ i ∧ i < len -> nth (Z.to_nat (ofsd + i)) dst inhabitant = nth (Z.to_nat (ofss + i)) src inhabitant) ∧ (∀(i : Z), ofsd ≤ i ∧ i < ofsd + len -> nth (Z.to_nat i) dst inhabitant = nth (Z.to_nat (i + (ofss - ofsd))) src inhabitant).
Definition copy_perm (src : list elt) (dst : list elt) (size : Z) (p : list Z) (invp : list Z) := valid_chunk src 0%Z size ∧ length src = length dst ∧ permutation_pair size p invp ∧ (∀(i : Z), 0%Z ≤ i ∧ i < size -> 0%Z ≤ nth (Z.to_nat i) p inhabitant ∧ nth (Z.to_nat i) p inhabitant < size) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < size -> 0%Z ≤ nth (Z.to_nat i) invp inhabitant ∧ nth (Z.to_nat i) invp inhabitant < size) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < size -> nth (Z.to_nat i) dst inhabitant = nth (Z.to_nat (nth (Z.to_nat i) p inhabitant)) src inhabitant) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < size -> nth (Z.to_nat i) src inhabitant = nth (Z.to_nat (nth (Z.to_nat i) invp inhabitant)) dst inhabitant).
Definition copy_subsegment (src : list elt) (dst : list elt) (s : Z) (k : Z) (l : Z) (j : Z) (sigma : list Z) (tau : list Z) (p : list Z) (invp : list Z) := let start : Z := s * (k * l) in let starts : Z := start + nth (Z.to_nat j) sigma inhabitant * k in let startd : Z := start + nth (Z.to_nat (nth (Z.to_nat j) sigma inhabitant)) tau inhabitant * k in copy_to src dst starts startd k ∧ (∀(i : Z), 0%Z ≤ i ∧ i < k -> nth (Z.to_nat (startd + i)) p inhabitant = starts + i) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < k -> nth (Z.to_nat (starts + i)) invp inhabitant = startd + i).
Definition frame {α : Type} `{Inhabited α} (a1 : list α) (a2 : list α) (ofs : Z) (len : Z) := length a2 = length a1 ∧ (∀(i : Z), 0%Z ≤ i ∧ i < ofs -> nth (Z.to_nat i) a2 inhabitant = nth (Z.to_nat i) a1 inhabitant) ∧ (∀(i : Z), ofs + len ≤ i ∧ i < Z.of_nat (length a2) -> nth (Z.to_nat i) a2 inhabitant = nth (Z.to_nat i) a1 inhabitant).
Theorem smart_array_copy_1'vc (src : list elt) (dst : list elt) (k : Z) (l : Z) (q : Z) (r : Z) (fact0 : length src = length dst) (fact1 : 0%Z < Z.of_nat (length dst)) (fact2 : 0%Z < k) (fact3 : 0%Z < l) (fact4 : 0%Z ≤ q) (fact5 : 0%Z ≤ r) (fact6 : r < k * l) (fact7 : Z.of_nat (length dst) = q * k * l + r) : 0%Z < Z.of_nat (length dst) ∧ (let p : list Z := identity (Z.of_nat (length dst)) in length p = length dst ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length dst) -> nth (Z.to_nat i) p inhabitant = i) ∧ permutation_pair (Z.of_nat (length dst)) p p -> 0%Z < Z.of_nat (length dst) ∧ (let invp : list Z := identity (Z.of_nat (length dst)) in length invp = length dst ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length dst) -> nth (Z.to_nat i) invp inhabitant = i) ∧ permutation_pair (Z.of_nat (length dst)) invp invp -> (let m : Z := k * l in let o1 : Z := q - 1%Z in (0%Z ≤ o1 + 1%Z -> (permutation_pair (0%Z * m) p invp ∧ copy_perm src dst (0%Z * m) p invp) ∧ (∀(invp1 : list Z) (p1 : list Z) (dst1 : list elt), length invp1 = length invp -> length p1 = length p -> length dst1 = length dst -> (∀(s : Z), (0%Z ≤ s ∧ s ≤ o1) ∧ permutation_pair (s * m) p1 invp1 ∧ copy_perm src dst1 (s * m) p1 invp1 -> (let start : Z := s * m in 0%Z < l ∧ (∀(sigma : list Z) (invsigma : list Z), (length sigma = length invsigma ∧ Z.of_nat (length invsigma) = l) ∧ permutation_pair l sigma invsigma -> 0%Z < l ∧ (∀(tau : list Z) (invtau : list Z), (length tau = length invtau ∧ Z.of_nat (length invtau) = l) ∧ permutation_pair l tau invtau -> (let o2 : Z := l - 1%Z in (0%Z ≤ o2 + 1%Z -> (permutation_pair (s * m) p1 invp1 ∧ copy_perm src dst1 (s * m) p1 invp1 ∧ (∀(j' : Z), 0%Z ≤ j' ∧ j' < 0%Z -> copy_subsegment src dst1 s k l j' sigma tau p1 invp1)) ∧ (∀(invp2 : list Z) (p2 : list Z) (dst2 : list elt), length invp2 = length invp1 -> length p2 = length p1 -> length dst2 = length dst1 -> (∀(j : Z), (0%Z ≤ j ∧ j ≤ o2) ∧ permutation_pair (s * m) p2 invp2 ∧ copy_perm src dst2 (s * m) p2 invp2 ∧ (∀(j' : Z), 0%Z ≤ j' ∧ j' < j -> copy_subsegment src dst2 s k l j' sigma tau p2 invp2) -> (0%Z ≤ j ∧ j < Z.of_nat (length sigma)) ∧ (let startsrc : Z := start + nth (Z.to_nat j) sigma inhabitant * k in (0%Z ≤ j ∧ j < Z.of_nat (length sigma)) ∧ (let o3 : Z := nth (Z.to_nat j) sigma inhabitant in (0%Z ≤ o3 ∧ o3 < Z.of_nat (length tau)) ∧ (let startdst : Z := start + nth (Z.to_nat o3) tau inhabitant * k in let o4 : Z := k - 1%Z in (0%Z ≤ o4 + 1%Z -> (frame dst2 dst2 startdst k ∧ frame p2 p2 startdst k ∧ frame invp2 invp2 startsrc k ∧ permutation_pair (s * m) p2 invp2 ∧ copy_perm src dst2 (s * m) p2 invp2 ∧ copy_to src dst2 startsrc startdst 0%Z ∧ (∀(i' : Z), 0%Z ≤ i' ∧ i' < 0%Z -> nth (Z.to_nat (startdst + i')) p2 inhabitant = startsrc + i') ∧ (∀(i' : Z), 0%Z ≤ i' ∧ i' < 0%Z -> nth (Z.to_nat (startsrc + i')) invp2 inhabitant = startdst + i') ∧ (∀(j' : Z), 0%Z ≤ j' ∧ j' < j -> copy_subsegment src dst2 s k l j' sigma tau p2 invp2)) ∧ (∀(invp3 : list Z) (p3 : list Z) (dst3 : list elt), length invp3 = length invp2 -> length p3 = length p2 -> length dst3 = length dst2 -> (∀(i : Z), (0%Z ≤ i ∧ i ≤ o4) ∧ frame dst2 dst3 startdst k ∧ frame p2 p3 startdst k ∧ frame invp2 invp3 startsrc k ∧ permutation_pair (s * m) p3 invp3 ∧ copy_perm src dst3 (s * m) p3 invp3 ∧ copy_to src dst3 startsrc startdst i ∧ (∀(i' : Z), 0%Z ≤ i' ∧ i' < i -> nth (Z.to_nat (startdst + i')) p3 inhabitant = startsrc + i') ∧ (∀(i' : Z), 0%Z ≤ i' ∧ i' < i -> nth (Z.to_nat (startsrc + i')) invp3 inhabitant = startdst + i') ∧ (∀(j' : Z), 0%Z ≤ j' ∧ j' < j -> copy_subsegment src dst3 s k l j' sigma tau p3 invp3) -> (let o5 : Z := startsrc + i in (0%Z ≤ o5 ∧ o5 < Z.of_nat (length src)) ∧ (let o6 : elt := nth (Z.to_nat o5) src inhabitant in let o7 : Z := startdst + i in (0%Z ≤ o7 ∧ o7 < Z.of_nat (length dst3)) ∧ (length (set_list dst3 (Z.to_nat o7) o6) = length dst3 -> nth_i (set_list dst3 (Z.to_nat o7) o6) = fun_updt (nth_i dst3) o7 o6 -> (let o8 : Z := startsrc + i in let o9 : Z := startdst + i in (0%Z ≤ o9 ∧ o9 < Z.of_nat (length p3)) ∧ (length (set_list p3 (Z.to_nat o9) o8) = length p3 -> nth_i (set_list p3 (Z.to_nat o9) o8) = fun_updt (nth_i p3) o9 o8 -> (let o10 : Z := startdst + i in let o11 : Z := startsrc + i in (0%Z ≤ o11 ∧ o11 < Z.of_nat (length invp3)) ∧ (length (set_list invp3 (Z.to_nat o11) o10) = length invp3 -> nth_i (set_list invp3 (Z.to_nat o11) o10) = fun_updt (nth_i invp3) o11 o10 -> frame dst2 (set_list dst3 (Z.to_nat o7) o6) startdst k ∧ frame p2 (set_list p3 (Z.to_nat o9) o8) startdst k ∧ frame invp2 (set_list invp3 (Z.to_nat o11) o10) startsrc k ∧ permutation_pair (s * m) (set_list p3 (Z.to_nat o9) o8) (set_list invp3 (Z.to_nat o11) o10) ∧ copy_perm src (set_list dst3 (Z.to_nat o7) o6) (s * m) (set_list p3 (Z.to_nat o9) o8) (set_list invp3 (Z.to_nat o11) o10) ∧ copy_to src (set_list dst3 (Z.to_nat o7) o6) startsrc startdst (i + 1%Z) ∧ (∀(i' : Z), 0%Z ≤ i' ∧ i' < i + 1%Z -> nth (Z.to_nat (startdst + i')) (set_list p3 (Z.to_nat o9) o8) inhabitant = startsrc + i') ∧ (∀(i' : Z), 0%Z ≤ i' ∧ i' < i + 1%Z -> nth (Z.to_nat (startsrc + i')) (set_list invp3 (Z.to_nat o11) o10) inhabitant = startdst + i') ∧ (∀(j' : Z), 0%Z ≤ j' ∧ j' < j -> copy_subsegment src (set_list dst3 (Z.to_nat o7) o6) s k l j' sigma tau (set_list p3 (Z.to_nat o9) o8) (set_list invp3 (Z.to_nat o11) o10)))))))))) ∧ (frame dst2 dst3 startdst k ∧ frame p2 p3 startdst k ∧ frame invp2 invp3 startsrc k ∧ permutation_pair (s * m) p3 invp3 ∧ copy_perm src dst3 (s * m) p3 invp3 ∧ copy_to src dst3 startsrc startdst (o4 + 1%Z) ∧ (∀(i' : Z), 0%Z ≤ i' ∧ i' < o4 + 1%Z -> nth (Z.to_nat (startdst + i')) p3 inhabitant = startsrc + i') ∧ (∀(i' : Z), 0%Z ≤ i' ∧ i' < o4 + 1%Z -> nth (Z.to_nat (startsrc + i')) invp3 inhabitant = startdst + i') ∧ (∀(j' : Z), 0%Z ≤ j' ∧ j' < j -> copy_subsegment src dst3 s k l j' sigma tau p3 invp3) -> permutation_pair (s * m) p3 invp3 ∧ copy_perm src dst3 (s * m) p3 invp3 ∧ (∀(j' : Z), 0%Z ≤ j' ∧ j' < j + 1%Z -> copy_subsegment src dst3 s k l j' sigma tau p3 invp3)))) ∧ (o4 + 1%Z < 0%Z -> permutation_pair (s * m) p2 invp2 ∧ copy_perm src dst2 (s * m) p2 invp2 ∧ (∀(j' : Z), 0%Z ≤ j' ∧ j' < j + 1%Z -> copy_subsegment src dst2 s k l j' sigma tau p2 invp2)))))) ∧ (permutation_pair (s * m) p2 invp2 ∧ copy_perm src dst2 (s * m) p2 invp2 ∧ (∀(j' : Z), 0%Z ≤ j' ∧ j' < o2 + 1%Z -> copy_subsegment src dst2 s k l j' sigma tau p2 invp2) -> permutation_pair ((s + 1%Z) * m) p2 invp2 ∧ copy_perm src dst2 ((s + 1%Z) * m) p2 invp2))) ∧ (o2 + 1%Z < 0%Z -> permutation_pair ((s + 1%Z) * m) p1 invp1 ∧ copy_perm src dst1 ((s + 1%Z) * m) p1 invp1)))))) ∧ (permutation_pair ((o1 + 1%Z) * m) p1 invp1 ∧ copy_perm src dst1 ((o1 + 1%Z) * m) p1 invp1 -> (let last : Z := q * m in let o2 : Z := r - 1%Z in (0%Z ≤ o2 + 1%Z -> (permutation_pair (last + 0%Z) p1 invp1 ∧ copy_perm src dst1 (last + 0%Z) p1 invp1) ∧ (∀(invp2 : list Z) (p2 : list Z) (dst2 : list elt), length invp2 = length invp1 -> length p2 = length p1 -> length dst2 = length dst1 -> (∀(i : Z), (0%Z ≤ i ∧ i ≤ o2) ∧ permutation_pair (last + i) p2 invp2 ∧ copy_perm src dst2 (last + i) p2 invp2 -> (let o3 : Z := last + i in (0%Z ≤ o3 ∧ o3 < Z.of_nat (length src)) ∧ (let o4 : elt := nth (Z.to_nat o3) src inhabitant in let o5 : Z := last + i in (0%Z ≤ o5 ∧ o5 < Z.of_nat (length dst2)) ∧ (length (set_list dst2 (Z.to_nat o5) o4) = length dst2 -> nth_i (set_list dst2 (Z.to_nat o5) o4) = fun_updt (nth_i dst2) o5 o4 -> (let o6 : Z := last + i in let o7 : Z := last + i in (0%Z ≤ o7 ∧ o7 < Z.of_nat (length p2)) ∧ (length (set_list p2 (Z.to_nat o7) o6) = length p2 -> nth_i (set_list p2 (Z.to_nat o7) o6) = fun_updt (nth_i p2) o7 o6 -> (let o8 : Z := last + i in let o9 : Z := last + i in (0%Z ≤ o9 ∧ o9 < Z.of_nat (length invp2)) ∧ (length (set_list invp2 (Z.to_nat o9) o8) = length invp2 -> nth_i (set_list invp2 (Z.to_nat o9) o8) = fun_updt (nth_i invp2) o9 o8 -> permutation_pair (last + (i + 1%Z)) (set_list p2 (Z.to_nat o7) o6) (set_list invp2 (Z.to_nat o9) o8) ∧ copy_perm src (set_list dst2 (Z.to_nat o5) o4) (last + (i + 1%Z)) (set_list p2 (Z.to_nat o7) o6) (set_list invp2 (Z.to_nat o9) o8))))))))) ∧ (permutation_pair (last + (o2 + 1%Z)) p2 invp2 ∧ copy_perm src dst2 (last + (o2 + 1%Z)) p2 invp2 -> copy_perm src dst2 (Z.of_nat (length dst)) p2 invp2))) ∧ (o2 + 1%Z < 0%Z -> copy_perm src dst1 (Z.of_nat (length dst)) p1 invp1))))) ∧ (o1 + 1%Z < 0%Z -> (let last : Z := q * m in let o2 : Z := r - 1%Z in (0%Z ≤ o2 + 1%Z -> (permutation_pair (last + 0%Z) p invp ∧ copy_perm src dst (last + 0%Z) p invp) ∧ (∀(invp1 : list Z) (p1 : list Z) (dst1 : list elt), length invp1 = length invp -> length p1 = length p -> length dst1 = length dst -> (∀(i : Z), (0%Z ≤ i ∧ i ≤ o2) ∧ permutation_pair (last + i) p1 invp1 ∧ copy_perm src dst1 (last + i) p1 invp1 -> (let o3 : Z := last + i in (0%Z ≤ o3 ∧ o3 < Z.of_nat (length src)) ∧ (let o4 : elt := nth (Z.to_nat o3) src inhabitant in let o5 : Z := last + i in (0%Z ≤ o5 ∧ o5 < Z.of_nat (length dst1)) ∧ (length (set_list dst1 (Z.to_nat o5) o4) = length dst1 -> nth_i (set_list dst1 (Z.to_nat o5) o4) = fun_updt (nth_i dst1) o5 o4 -> (let o6 : Z := last + i in let o7 : Z := last + i in (0%Z ≤ o7 ∧ o7 < Z.of_nat (length p1)) ∧ (length (set_list p1 (Z.to_nat o7) o6) = length p1 -> nth_i (set_list p1 (Z.to_nat o7) o6) = fun_updt (nth_i p1) o7 o6 -> (let o8 : Z := last + i in let o9 : Z := last + i in (0%Z ≤ o9 ∧ o9 < Z.of_nat (length invp1)) ∧ (length (set_list invp1 (Z.to_nat o9) o8) = length invp1 -> nth_i (set_list invp1 (Z.to_nat o9) o8) = fun_updt (nth_i invp1) o9 o8 -> permutation_pair (last + (i + 1%Z)) (set_list p1 (Z.to_nat o7) o6) (set_list invp1 (Z.to_nat o9) o8) ∧ copy_perm src (set_list dst1 (Z.to_nat o5) o4) (last + (i + 1%Z)) (set_list p1 (Z.to_nat o7) o6) (set_list invp1 (Z.to_nat o9) o8))))))))) ∧ (permutation_pair (last + (o2 + 1%Z)) p1 invp1 ∧ copy_perm src dst1 (last + (o2 + 1%Z)) p1 invp1 -> copy_perm src dst1 (Z.of_nat (length dst)) p1 invp1))) ∧ (o2 + 1%Z < 0%Z -> copy_perm src dst (Z.of_nat (length dst)) p invp)))))).
Admitted.
