theory vstte12_tree_reconstruction_ZipperBased_tcqtvc
  imports "NTP4Verif.NTP4Verif" "./vstte12_tree_reconstruction_Tree"
begin
fun forest_depths :: "(int \<times> tree) list \<Rightarrow> int list"
  where "forest_depths (Nil :: (int \<times> tree) list) = (Nil :: int list)"
      | "forest_depths (Cons (d, t) r) = depths d t @ forest_depths r" for d t r
fun greedy :: "int \<Rightarrow> int \<Rightarrow> tree \<Rightarrow> _"
  where "greedy d d1 t1 = (\<not>d = d1 \<and> (case t1 of Leaf \<Rightarrow> True | Node l1 _ \<Rightarrow> greedy d (d1 + (1 :: int)) l1))" for d d1 t1
inductive g :: "(int \<times> tree) list \<Rightarrow> bool" where
   Gnil: "g (Nil :: (int \<times> tree) list)"
 | Gone: "g (Cons (d, t) (Nil :: (int \<times> tree) list))" for d :: "int" and t :: "tree"
 | Gtwo: "greedy d1 d2 t2 \<Longrightarrow> g (Cons (d1, t1) l) \<Longrightarrow> g (Cons (d2, t2) (Cons (d1, t1) l))" for d1 :: "int" and d2 :: "int" and t2 :: "tree" and t1 :: "tree" and l :: "(int \<times> tree) list"
fun only_leaf :: "(int \<times> tree) list \<Rightarrow> _"
  where "only_leaf (Nil :: (int \<times> tree) list) = True"
      | "only_leaf (Cons (x, t) r) = (t = Leaf \<and> only_leaf r)" for x t r
theorem tc'vc:
  fixes left1 :: "(int \<times> tree) list"
  fixes right1 :: "(int \<times> tree) list"
  assumes fact0: "g left1"
  assumes fact1: "case left1 of Cons (d1, _) Nil \<Rightarrow> \<not>d1 = (0 :: int) \<or> \<not>right1 = (Nil :: (int \<times> tree) list) | _ \<Rightarrow> True"
  assumes fact2: "case right1 of Cons (d2, t2) right' \<Rightarrow> only_leaf right' \<and> (case t2 of Node l2 _ \<Rightarrow> g (Cons (d2 + (1 :: int), l2) left1) | Leaf \<Rightarrow> True) | Nil \<Rightarrow> True"
  shows "case right1 of Nil \<Rightarrow> (\<forall>(t :: tree). \<not>depths (0 :: int) t = forest_depths (rev left1 @ right1)) | Cons x x1 \<Rightarrow> (case x1 of Nil \<Rightarrow> (case x of (x2, x3) \<Rightarrow> (case left1 of Nil \<Rightarrow> (if x2 = (0 :: int) then depths (0 :: int) x3 = forest_depths (rev left1 @ right1) else \<forall>(t :: tree). \<not>depths (0 :: int) t = forest_depths (rev left1 @ right1)) | Cons x4 x5 \<Rightarrow> (case x4 of (x6, x7) \<Rightarrow> (if x6 = x2 then let o1 :: int = x6 - (1 :: int); o2 :: (int \<times> tree) list = Cons (o1, Node x7 x3) x1 in (((0 :: int) \<le> int (length left1) + (2 :: int) * int (length right1) \<and> int (length x5) + (2 :: int) * int (length o2) < int (length left1) + (2 :: int) * int (length right1)) \<and> g x5 \<and> (case x5 of Cons (d1, _) Nil \<Rightarrow> True | _ \<Rightarrow> True) \<and> only_leaf x1 \<and> g (Cons (o1 + (1 :: int), x7) x5)) \<and> (\<forall>(result :: tree). depths (0 :: int) result = forest_depths (rev x5 @ o2) \<longrightarrow> depths (0 :: int) result = forest_depths (rev left1 @ right1)) \<and> ((\<forall>(t :: tree). \<not>depths (0 :: int) t = forest_depths (rev x5 @ o2)) \<longrightarrow> (\<forall>(t :: tree). \<not>depths (0 :: int) t = forest_depths (rev left1 @ right1))) else let o1 :: (int \<times> tree) list = Cons (x2, x3) left1 in (((0 :: int) \<le> int (length left1) + (2 :: int) * int (length right1) \<and> int (length o1) + (2 :: int) * int (length x1) < int (length left1) + (2 :: int) * int (length right1)) \<and> g o1 \<and> (case left1 of Nil \<Rightarrow> \<not>x2 = (0 :: int) \<or> \<not>x1 = (Nil :: (int \<times> tree) list) | _ \<Rightarrow> True) \<and> (case x1 of Cons (d2, t2) right' \<Rightarrow> only_leaf right' \<and> (case t2 of Node l2 _ \<Rightarrow> g (Cons (d2 + (1 :: int), l2) o1) | Leaf \<Rightarrow> True) | Nil \<Rightarrow> True)) \<and> (\<forall>(result :: tree). depths (0 :: int) result = forest_depths (rev o1 @ x1) \<longrightarrow> depths (0 :: int) result = forest_depths (rev left1 @ right1)) \<and> ((\<forall>(t :: tree). \<not>depths (0 :: int) t = forest_depths (rev o1 @ x1)) \<longrightarrow> (\<forall>(t :: tree). \<not>depths (0 :: int) t = forest_depths (rev left1 @ right1))))))) | _ \<Rightarrow> (case x of (x2, x3) \<Rightarrow> (case left1 of Nil \<Rightarrow> (let o1 :: (int \<times> tree) list = Cons (x2, x3) (Nil :: (int \<times> tree) list) in (((0 :: int) \<le> int (length left1) + (2 :: int) * int (length right1) \<and> int (length o1) + (2 :: int) * int (length x1) < int (length left1) + (2 :: int) * int (length right1)) \<and> g o1 \<and> (\<not>x2 = (0 :: int) \<or> \<not>x1 = (Nil :: (int \<times> tree) list)) \<and> (case x1 of Cons (d2, t2) right' \<Rightarrow> only_leaf right' \<and> (case t2 of Node l2 _ \<Rightarrow> g (Cons (d2 + (1 :: int), l2) o1) | Leaf \<Rightarrow> True) | Nil \<Rightarrow> True)) \<and> (\<forall>(result :: tree). depths (0 :: int) result = forest_depths (rev o1 @ x1) \<longrightarrow> depths (0 :: int) result = forest_depths (rev left1 @ right1)) \<and> ((\<forall>(t :: tree). \<not>depths (0 :: int) t = forest_depths (rev o1 @ x1)) \<longrightarrow> (\<forall>(t :: tree). \<not>depths (0 :: int) t = forest_depths (rev left1 @ right1)))) | Cons x4 x5 \<Rightarrow> (case x4 of (x6, x7) \<Rightarrow> (if x6 = x2 then let o1 :: int = x6 - (1 :: int); o2 :: (int \<times> tree) list = Cons (o1, Node x7 x3) x1 in (((0 :: int) \<le> int (length left1) + (2 :: int) * int (length right1) \<and> int (length x5) + (2 :: int) * int (length o2) < int (length left1) + (2 :: int) * int (length right1)) \<and> g x5 \<and> (case x5 of Cons (d1, _) Nil \<Rightarrow> True | _ \<Rightarrow> True) \<and> only_leaf x1 \<and> g (Cons (o1 + (1 :: int), x7) x5)) \<and> (\<forall>(result :: tree). depths (0 :: int) result = forest_depths (rev x5 @ o2) \<longrightarrow> depths (0 :: int) result = forest_depths (rev left1 @ right1)) \<and> ((\<forall>(t :: tree). \<not>depths (0 :: int) t = forest_depths (rev x5 @ o2)) \<longrightarrow> (\<forall>(t :: tree). \<not>depths (0 :: int) t = forest_depths (rev left1 @ right1))) else let o1 :: (int \<times> tree) list = Cons (x2, x3) left1 in (((0 :: int) \<le> int (length left1) + (2 :: int) * int (length right1) \<and> int (length o1) + (2 :: int) * int (length x1) < int (length left1) + (2 :: int) * int (length right1)) \<and> g o1 \<and> (case left1 of Nil \<Rightarrow> \<not>x2 = (0 :: int) \<or> \<not>x1 = (Nil :: (int \<times> tree) list) | _ \<Rightarrow> True) \<and> (case x1 of Cons (d2, t2) right' \<Rightarrow> only_leaf right' \<and> (case t2 of Node l2 _ \<Rightarrow> g (Cons (d2 + (1 :: int), l2) o1) | Leaf \<Rightarrow> True) | Nil \<Rightarrow> True)) \<and> (\<forall>(result :: tree). depths (0 :: int) result = forest_depths (rev o1 @ x1) \<longrightarrow> depths (0 :: int) result = forest_depths (rev left1 @ right1)) \<and> ((\<forall>(t :: tree). \<not>depths (0 :: int) t = forest_depths (rev o1 @ x1)) \<longrightarrow> (\<forall>(t :: tree). \<not>depths (0 :: int) t = forest_depths (rev left1 @ right1))))))))"
  sorry
end
