theory warshall_algorithm_WarshallAlgorithm_transitive_closureqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.matrix_Matrix"
begin
inductive path :: "bool matrix \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> bool" where
   Path_empty: "elts m i j = True \<Longrightarrow> path m i j k" for m :: "bool matrix" and i :: "int" and j :: "int" and k :: "int"
 | Path_cons: "(0 :: int) \<le> x \<Longrightarrow> x < k \<Longrightarrow> path m i x k \<Longrightarrow> path m x j k \<Longrightarrow> path m i j k" for x :: "int" and k :: "int" and m :: "bool matrix" and i :: "int" and j :: "int"
theorem transitive_closure'vc:
  fixes m :: "bool matrix"
  fixes t :: "bool matrix"
  assumes fact0: "rows m = columns m"
  assumes fact1: "rows t = rows m"
  assumes fact2: "columns t = columns m"
  assumes fact3: "\<forall>(r :: int). (0 :: int) \<le> r \<and> r < rows t \<longrightarrow> (\<forall>(c :: int). (0 :: int) \<le> c \<and> c < columns t \<longrightarrow> elts t r c = elts m r c)"
  shows "let n :: int = rows m; o1 :: int = n - (1 :: int) in ((0 :: int) \<le> o1 + (1 :: int) \<longrightarrow> (\<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < n \<longrightarrow> (0 :: int) \<le> y \<and> y < n \<longrightarrow> elts t x y = True \<longleftrightarrow> path m x y (0 :: int)) \<and> (\<forall>(t1 :: bool matrix). rows t1 = rows t \<and> columns t1 = columns t \<longrightarrow> (\<forall>(k :: int). ((0 :: int) \<le> k \<and> k \<le> o1) \<and> (\<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < n \<longrightarrow> (0 :: int) \<le> y \<and> y < n \<longrightarrow> elts t1 x y = True \<longleftrightarrow> path m x y k) \<longrightarrow> (let o2 :: int = n - (1 :: int) in ((0 :: int) \<le> o2 + (1 :: int) \<longrightarrow> (\<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < n \<longrightarrow> (0 :: int) \<le> y \<and> y < n \<longrightarrow> elts t1 x y = True \<longleftrightarrow> (if x < (0 :: int) then path m x y (k + (1 :: int)) else path m x y k)) \<and> (\<forall>(t2 :: bool matrix). rows t2 = rows t1 \<and> columns t2 = columns t1 \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i \<le> o2) \<and> (\<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < n \<longrightarrow> (0 :: int) \<le> y \<and> y < n \<longrightarrow> elts t2 x y = True \<longleftrightarrow> (if x < i then path m x y (k + (1 :: int)) else path m x y k)) \<longrightarrow> (let o3 :: int = n - (1 :: int) in ((0 :: int) \<le> o3 + (1 :: int) \<longrightarrow> (\<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < n \<longrightarrow> (0 :: int) \<le> y \<and> y < n \<longrightarrow> elts t2 x y = True \<longleftrightarrow> (if x < i \<or> x = i \<and> y < (0 :: int) then path m x y (k + (1 :: int)) else path m x y k)) \<and> (\<forall>(t3 :: bool matrix). rows t3 = rows t2 \<and> columns t3 = columns t2 \<longrightarrow> (\<forall>(j :: int). ((0 :: int) \<le> j \<and> j \<le> o3) \<and> (\<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < n \<longrightarrow> (0 :: int) \<le> y \<and> y < n \<longrightarrow> elts t3 x y = True \<longleftrightarrow> (if x < i \<or> x = i \<and> y < j then path m x y (k + (1 :: int)) else path m x y k)) \<longrightarrow> valid_index t3 i j \<and> (let o4 :: bool = elts t3 i j in (\<not>o4 = True \<longrightarrow> valid_index t3 i k \<and> (elts t3 i k = True \<longrightarrow> valid_index t3 k j)) \<and> (\<forall>(o5 :: bool). (if o4 = True then o5 = True else if elts t3 i k = True then o5 = elts t3 k j else o5 = False) \<longrightarrow> valid_index t3 i j \<and> (\<forall>(t4 :: bool matrix). rows t4 = rows t3 \<and> columns t4 = columns t3 \<longrightarrow> elts t4 = (elts t3)(i := (elts t3 i)(j := o5)) \<longrightarrow> (\<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < n \<longrightarrow> (0 :: int) \<le> y \<and> y < n \<longrightarrow> elts t4 x y = True \<longleftrightarrow> (if x < i \<or> x = i \<and> y < j + (1 :: int) then path m x y (k + (1 :: int)) else path m x y k)))))) \<and> ((\<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < n \<longrightarrow> (0 :: int) \<le> y \<and> y < n \<longrightarrow> elts t3 x y = True \<longleftrightarrow> (if x < i \<or> x = i \<and> y < o3 + (1 :: int) then path m x y (k + (1 :: int)) else path m x y k)) \<longrightarrow> (\<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < n \<longrightarrow> (0 :: int) \<le> y \<and> y < n \<longrightarrow> elts t3 x y = True \<longleftrightarrow> (if x < i + (1 :: int) then path m x y (k + (1 :: int)) else path m x y k))))) \<and> (o3 + (1 :: int) < (0 :: int) \<longrightarrow> (\<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < n \<longrightarrow> (0 :: int) \<le> y \<and> y < n \<longrightarrow> elts t2 x y = True \<longleftrightarrow> (if x < i + (1 :: int) then path m x y (k + (1 :: int)) else path m x y k))))) \<and> ((\<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < n \<longrightarrow> (0 :: int) \<le> y \<and> y < n \<longrightarrow> elts t2 x y = True \<longleftrightarrow> (if x < o2 + (1 :: int) then path m x y (k + (1 :: int)) else path m x y k)) \<longrightarrow> (\<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < n \<longrightarrow> (0 :: int) \<le> y \<and> y < n \<longrightarrow> elts t2 x y = True \<longleftrightarrow> path m x y (k + (1 :: int)))))) \<and> (o2 + (1 :: int) < (0 :: int) \<longrightarrow> (\<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < n \<longrightarrow> (0 :: int) \<le> y \<and> y < n \<longrightarrow> elts t1 x y = True \<longleftrightarrow> path m x y (k + (1 :: int)))))) \<and> ((\<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < n \<longrightarrow> (0 :: int) \<le> y \<and> y < n \<longrightarrow> elts t1 x y = True \<longleftrightarrow> path m x y (o1 + (1 :: int))) \<longrightarrow> (let n1 :: int = rows m in \<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < n1 \<longrightarrow> (0 :: int) \<le> y \<and> y < n1 \<longrightarrow> elts t1 x y = True \<longleftrightarrow> path m x y n1)))) \<and> (o1 + (1 :: int) < (0 :: int) \<longrightarrow> (let n1 :: int = rows m in \<forall>(x :: int) (y :: int). (0 :: int) \<le> x \<and> x < n1 \<longrightarrow> (0 :: int) \<le> y \<and> y < n1 \<longrightarrow> elts t x y = True \<longleftrightarrow> path m x y n1))"
  sorry
end
