theory Cint_Cint
  imports "NTP4Verif.NTP4Verif"
begin
definition is_bool :: "int \<Rightarrow> _"
  where "is_bool x \<longleftrightarrow> x = (0 :: int) \<or> x = (1 :: int)" for x
consts is_uint8 :: "int \<Rightarrow> bool"
axiomatization where is_uint8_def:   "is_uint8 x \<longleftrightarrow> (0 :: int) \<le> x \<and> x < (256 :: int)"
  for x :: "int"
consts is_sint8 :: "int \<Rightarrow> bool"
axiomatization where is_sint8_def:   "is_sint8 x \<longleftrightarrow> -(128 :: int) \<le> x \<and> x < (128 :: int)"
  for x :: "int"
consts is_uint16 :: "int \<Rightarrow> bool"
axiomatization where is_uint16_def:   "is_uint16 x \<longleftrightarrow> (0 :: int) \<le> x \<and> x < (65536 :: int)"
  for x :: "int"
definition is_sint16 :: "int \<Rightarrow> _"
  where "is_sint16 x \<longleftrightarrow> -(32768 :: int) \<le> x \<and> x < (32768 :: int)" for x
consts is_uint32 :: "int \<Rightarrow> bool"
axiomatization where is_uint32_def:   "is_uint32 x \<longleftrightarrow> (0 :: int) \<le> x \<and> x < (4294967296 :: int)"
  for x :: "int"
consts is_sint32 :: "int \<Rightarrow> bool"
axiomatization where is_sint32_def:   "is_sint32 x \<longleftrightarrow> -(2147483648 :: int) \<le> x \<and> x < (2147483648 :: int)"
  for x :: "int"
consts is_uint64 :: "int \<Rightarrow> bool"
axiomatization where is_uint64_def:   "is_uint64 x \<longleftrightarrow> (0 :: int) \<le> x \<and> x < (18446744073709551616 :: int)"
  for x :: "int"
consts is_sint64 :: "int \<Rightarrow> bool"
axiomatization where is_sint64_def:   "is_sint64 x \<longleftrightarrow> -(9223372036854775808 :: int) \<le> x \<and> x < (9223372036854775808 :: int)"
  for x :: "int"
axiomatization where is_bool0:   "is_bool (0 :: int)"
axiomatization where is_bool1:   "is_bool (1 :: int)"
definition to_bool :: "int \<Rightarrow> int"
  where "to_bool x = (if x = (0 :: int) then 0 :: int else (1 :: int))" for x
consts to_uint8 :: "int \<Rightarrow> int"
consts to_sint8 :: "int \<Rightarrow> int"
consts to_uint16 :: "int \<Rightarrow> int"
consts to_sint16 :: "int \<Rightarrow> int"
consts to_uint32 :: "int \<Rightarrow> int"
consts to_sint32 :: "int \<Rightarrow> int"
consts to_uint64 :: "int \<Rightarrow> int"
consts to_sint64 :: "int \<Rightarrow> int"
consts two_power_abs :: "int \<Rightarrow> int"
definition is_uint :: "int \<Rightarrow> int \<Rightarrow> _"
  where "is_uint n x \<longleftrightarrow> (0 :: int) \<le> x \<and> x < two_power_abs n" for n x
definition is_sint :: "int \<Rightarrow> int \<Rightarrow> _"
  where "is_sint n x \<longleftrightarrow> -two_power_abs n \<le> x \<and> x < two_power_abs n" for n x
consts to_uint :: "int \<Rightarrow> int \<Rightarrow> int"
consts to_sint :: "int \<Rightarrow> int \<Rightarrow> int"
axiomatization where is_to_uint8:   "is_uint8 (to_uint8 x)"
  for x :: "int"
axiomatization where is_to_sint8:   "is_sint8 (to_sint8 x)"
  for x :: "int"
axiomatization where is_to_uint16:   "is_uint16 (to_uint16 x)"
  for x :: "int"
axiomatization where is_to_sint16:   "is_sint16 (to_sint16 x)"
  for x :: "int"
axiomatization where is_to_uint32:   "is_uint32 (to_uint32 x)"
  for x :: "int"
axiomatization where is_to_sint32:   "is_sint32 (to_sint32 x)"
  for x :: "int"
axiomatization where is_to_uint64:   "is_uint64 (to_uint64 x)"
  for x :: "int"
axiomatization where is_to_sint64:   "is_sint64 (to_sint64 x)"
  for x :: "int"
axiomatization where id_uint8:   "to_uint8 x = x"
 if "(0 :: int) \<le> x"
 and "x < (256 :: int)"
  for x :: "int"
axiomatization where id_sint8:   "to_sint8 x = x"
 if "-(128 :: int) \<le> x"
 and "x < (128 :: int)"
  for x :: "int"
axiomatization where id_uint16:   "to_uint16 x = x"
 if "(0 :: int) \<le> x"
 and "x < (65536 :: int)"
  for x :: "int"
axiomatization where id_sint16:   "to_sint16 x = x"
 if "-(32768 :: int) \<le> x"
 and "x < (32768 :: int)"
  for x :: "int"
axiomatization where id_uint32:   "to_uint32 x = x"
 if "(0 :: int) \<le> x"
 and "x < (4294967296 :: int)"
  for x :: "int"
axiomatization where id_sint32:   "to_sint32 x = x"
 if "-(2147483648 :: int) \<le> x"
 and "x < (2147483648 :: int)"
  for x :: "int"
axiomatization where id_uint64:   "to_uint64 x = x"
 if "(0 :: int) \<le> x"
 and "x < (18446744073709551616 :: int)"
  for x :: "int"
axiomatization where id_sint64:   "to_sint64 x = x"
 if "-(9223372036854775808 :: int) \<le> x"
 and "x < (9223372036854775808 :: int)"
  for x :: "int"
axiomatization where proj_int8:   "to_sint8 (to_uint8 x) = to_sint8 x"
  for x :: "int"
axiomatization where proj_int16:   "to_sint16 (to_uint16 x) = to_sint16 x"
  for x :: "int"
axiomatization where proj_int32:   "to_sint32 (to_uint32 x) = to_sint32 x"
  for x :: "int"
axiomatization where proj_int64:   "to_sint64 (to_uint64 x) = to_sint64 x"
  for x :: "int"
consts lnot :: "int \<Rightarrow> int"
consts land :: "int \<Rightarrow> int \<Rightarrow> int"
consts lxor :: "int \<Rightarrow> int \<Rightarrow> int"
consts lor :: "int \<Rightarrow> int \<Rightarrow> int"
consts lsl :: "int \<Rightarrow> int \<Rightarrow> int"
consts lsr :: "int \<Rightarrow> int \<Rightarrow> int"
consts bit_testb :: "int \<Rightarrow> int \<Rightarrow> bool"
consts bit_test :: "int \<Rightarrow> int \<Rightarrow> bool"
end
