theory Memory_Memory
  imports "NTP4Verif.NTP4Verif"
begin
datatype  addr = Mk_addr (base: "int") (offset: "int")
consts addr_le :: "addr \<Rightarrow> addr \<Rightarrow> bool"
consts addr_lt :: "addr \<Rightarrow> addr \<Rightarrow> bool"
consts addr_le_bool :: "addr \<Rightarrow> addr \<Rightarrow> bool"
consts addr_lt_bool :: "addr \<Rightarrow> addr \<Rightarrow> bool"
axiomatization where addr_le_def:   "addr_le p q \<longleftrightarrow> offset p \<le> offset q"
 if "base p = base q"
  for p :: "addr"
  and q :: "addr"
axiomatization where addr_lt_def:   "addr_lt p q \<longleftrightarrow> offset p < offset q"
 if "base p = base q"
  for p :: "addr"
  and q :: "addr"
axiomatization where addr_le_bool_def:   "addr_le p q \<longleftrightarrow> addr_le_bool p q = True"
  for p :: "addr"
  and q :: "addr"
axiomatization where addr_lt_bool_def:   "addr_lt p q \<longleftrightarrow> addr_lt_bool p q = True"
  for p :: "addr"
  and q :: "addr"
definition shift :: "addr \<Rightarrow> int \<Rightarrow> addr"
  where "shift p k = Mk_addr (base p) (offset p + k)" for p k
definition shift_sint16 :: "addr \<Rightarrow> int \<Rightarrow> addr"
  where "shift_sint16 p k = shift p ((2 :: int) * k)" for p k
definition shift_sint32 :: "addr \<Rightarrow> int \<Rightarrow> addr"
  where "shift_sint32 p k = shift p ((4 :: int) * k)" for p k
definition shift_sint64 :: "addr \<Rightarrow> int \<Rightarrow> addr"
  where "shift_sint64 p k = shift p ((8 :: int) * k)" for p k
definition shift_uint16 :: "addr \<Rightarrow> int \<Rightarrow> addr"
  where "shift_uint16 p k = shift p ((2 :: int) * k)" for p k
definition shift_uint32 :: "addr \<Rightarrow> int \<Rightarrow> addr"
  where "shift_uint32 p k = shift p ((4 :: int) * k)" for p k
definition shift_uint64 :: "addr \<Rightarrow> int \<Rightarrow> addr"
  where "shift_uint64 p k = shift p ((8 :: int) * k)" for p k
definition shift_ptr :: "addr \<Rightarrow> int \<Rightarrow> addr"
  where "shift_ptr p k = shift p ((8 :: int) * k)" for p k
definition included :: "addr \<Rightarrow> int \<Rightarrow> addr \<Rightarrow> int \<Rightarrow> _"
  where "included p a q b \<longleftrightarrow> (0 :: int) < a \<longrightarrow> (0 :: int) \<le> b \<and> base p = base q \<and> offset q \<le> offset p \<and> offset p + a \<le> offset q + b" for p a q b
definition separated :: "addr \<Rightarrow> int \<Rightarrow> addr \<Rightarrow> int \<Rightarrow> _"
  where "separated p a q b \<longleftrightarrow> a \<le> (0 :: int) \<or> b \<le> (0 :: int) \<or> \<not>base p = base q \<or> offset q + b \<le> offset p \<or> offset p + a \<le> offset q" for p a q b
definition eqmem :: "(addr \<Rightarrow> 'a) \<Rightarrow> (addr \<Rightarrow> 'a) \<Rightarrow> addr \<Rightarrow> int \<Rightarrow> _"
  where "eqmem m1 m2 p a \<longleftrightarrow> (\<forall>(q :: addr). included q (1 :: int) p a \<longrightarrow> m1 q = m2 q)" for m1 m2 p a
consts havoc :: "(addr \<Rightarrow> 'a) \<Rightarrow> (addr \<Rightarrow> 'a) \<Rightarrow> addr \<Rightarrow> int \<Rightarrow> addr \<Rightarrow> 'a"
definition valid_rw :: "(int \<Rightarrow> int) \<Rightarrow> addr \<Rightarrow> int \<Rightarrow> _"
  where "valid_rw m p n \<longleftrightarrow> (0 :: int) < n \<longrightarrow> (0 :: int) < base p \<and> (0 :: int) \<le> offset p \<and> offset p + n \<le> m (base p)" for m p n
definition valid_rd :: "(int \<Rightarrow> int) \<Rightarrow> addr \<Rightarrow> int \<Rightarrow> _"
  where "valid_rd m p n \<longleftrightarrow> (0 :: int) < n \<longrightarrow> \<not>(0 :: int) = base p \<and> (0 :: int) \<le> offset p \<and> offset p + n \<le> m (base p)" for m p n
definition invalid :: "(int \<Rightarrow> int) \<Rightarrow> addr \<Rightarrow> int \<Rightarrow> _"
  where "invalid m p n \<longleftrightarrow> (0 :: int) < n \<longrightarrow> m (base p) \<le> offset p \<or> offset p + n \<le> (0 :: int)" for m p n
axiomatization where valid_rw_rd:   "valid_rd m p n"
 if "valid_rw m p n"
  for m :: "int \<Rightarrow> int"
  and p :: "addr"
  and n :: "int"
axiomatization where valid_string'0:   "valid_rd m p (1 :: int)"
 if "base p < (0 :: int)"
 and "(0 :: int) \<le> offset p"
 and "offset p < m (base p)"
  for p :: "addr"
  and m :: "int \<Rightarrow> int"
axiomatization where valid_string'1:   "\<not>valid_rw m p (1 :: int)"
 if "base p < (0 :: int)"
 and "(0 :: int) \<le> offset p"
 and "offset p < m (base p)"
  for p :: "addr"
  and m :: "int \<Rightarrow> int"
axiomatization where separated_1:   "\<not>Mk_addr (base p) i = Mk_addr (base q) j"
 if "separated p a q b"
 and "offset p \<le> i"
 and "i < offset p + a"
 and "offset q \<le> j"
 and "j < offset q + b"
  for p :: "addr"
  and a :: "int"
  and q :: "addr"
  and b :: "int"
  and i :: "int"
  and j :: "int"
consts region :: "int \<Rightarrow> int"
consts linked :: "(int \<Rightarrow> int) \<Rightarrow> bool"
consts sconst :: "(addr \<Rightarrow> int) \<Rightarrow> bool"
definition framed :: "(addr \<Rightarrow> addr) \<Rightarrow> _"
  where "framed m \<longleftrightarrow> (\<forall>(p :: addr). region (base (m p)) \<le> (0 :: int))" for m
axiomatization where separated_included:   "\<not>included p a q b"
 if "(0 :: int) < a"
 and "(0 :: int) < b"
 and "separated p a q b"
  for a :: "int"
  and b :: "int"
  and p :: "addr"
  and q :: "addr"
axiomatization where included_trans:   "included p a r c"
 if "included p a q b"
 and "included q b r c"
  for p :: "addr"
  and a :: "int"
  and q :: "addr"
  and b :: "int"
  and r :: "addr"
  and c :: "int"
axiomatization where separated_trans:   "separated p a r c"
 if "included p a q b"
 and "separated q b r c"
  for p :: "addr"
  and a :: "int"
  and q :: "addr"
  and b :: "int"
  and r :: "addr"
  and c :: "int"
axiomatization where separated_sym:   "separated p a q b \<longleftrightarrow> separated q b p a"
  for p :: "addr"
  and a :: "int"
  and q :: "addr"
  and b :: "int"
axiomatization where eqmem_included:   "eqmem m1 m2 p a"
 if "included p a q b"
 and "eqmem m1 m2 q b"
  for p :: "addr"
  and a :: "int"
  and q :: "addr"
  and b :: "int"
  and m1 :: "addr \<Rightarrow> 'a"
  and m2 :: "addr \<Rightarrow> 'a"
axiomatization where eqmem_sym:   "eqmem m2 m1 p a"
 if "eqmem m1 m2 p a"
  for m1 :: "addr \<Rightarrow> 'a"
  and m2 :: "addr \<Rightarrow> 'a"
  and p :: "addr"
  and a :: "int"
axiomatization where havoc_access:   "havoc m0 m1 p a q = (if separated q (1 :: int) p a then m1 q else m0 q)"
  for m0 :: "addr \<Rightarrow> 'a"
  and m1 :: "addr \<Rightarrow> 'a"
  and p :: "addr"
  and a :: "int"
  and q :: "addr"
consts int_of_addr :: "addr \<Rightarrow> int"
consts addr_of_int :: "int \<Rightarrow> addr"
consts base_offset :: "int \<Rightarrow> int"
consts base_index :: "int \<Rightarrow> int"
axiomatization where int_of_addr_bijection:   "int_of_addr (addr_of_int a) = a"
  for a :: "int"
axiomatization where addr_of_int_bijection:   "addr_of_int (int_of_addr p) = p"
  for p :: "addr"
axiomatization where addr_of_null:   "int_of_addr (Mk_addr (0 :: int) (0 :: int)) = (0 :: int)"
axiomatization where base_offset_zero:   "base_offset (0 :: int) = (0 :: int)"
axiomatization where base_offset_inj:   "base_index (base_offset i) = i"
  for i :: "int"
axiomatization where base_offset_monotonic:   "base_offset i < base_offset j"
 if "i < j"
  for i :: "int"
  and j :: "int"
end
