theory Qed_Qed
  imports "NTP4Verif.NTP4Verif"
begin
consts match_bool :: "bool \<Rightarrow> 'a \<Rightarrow> 'a \<Rightarrow> 'a"
consts eqb :: "'a \<Rightarrow> 'a \<Rightarrow> bool"
axiomatization where eqb1:   "eqb x y = True \<longleftrightarrow> x = y"
  for x :: "'a"
  and y :: "'a"
consts neqb :: "'a \<Rightarrow> 'a \<Rightarrow> bool"
axiomatization where neqb1:   "neqb x y = True \<longleftrightarrow> \<not>x = y"
  for x :: "'a"
  and y :: "'a"
consts zlt :: "int \<Rightarrow> int \<Rightarrow> bool"
consts zleq :: "int \<Rightarrow> int \<Rightarrow> bool"
axiomatization where zlt1:   "zlt x y = True \<longleftrightarrow> x < y"
  for x :: "int"
  and y :: "int"
axiomatization where zleq1:   "zleq x y = True \<longleftrightarrow> x \<le> y"
  for x :: "int"
  and y :: "int"
consts rlt :: "real \<Rightarrow> real \<Rightarrow> bool"
consts rleq :: "real \<Rightarrow> real \<Rightarrow> bool"
axiomatization where rlt1:   "rlt x y = True \<longleftrightarrow> x < y"
  for x :: "real"
  and y :: "real"
axiomatization where rleq1:   "rleq x y = True \<longleftrightarrow> x \<le> y"
  for x :: "real"
  and y :: "real"
axiomatization where c_euclidian:   "n = n cdiv d * d + n cmod d"
 if "\<not>d = (0 :: int)"
  for d :: "int"
  and n :: "int"
axiomatization where cdiv_cases'0:   "n \<le> (0 :: int) \<longrightarrow> (0 :: int) < d \<longrightarrow> n cdiv d = -(-n cdiv d)"
  for n :: "int"
  and d :: "int"
axiomatization where cdiv_cases'1:   "(0 :: int) \<le> n \<longrightarrow> d < (0 :: int) \<longrightarrow> n cdiv d = -(n cdiv -d)"
  for n :: "int"
  and d :: "int"
axiomatization where cdiv_cases'2:   "n \<le> (0 :: int) \<longrightarrow> d < (0 :: int) \<longrightarrow> n cdiv d = -n cdiv -d"
  for n :: "int"
  and d :: "int"
axiomatization where cmod_cases'0:   "n \<le> (0 :: int) \<longrightarrow> (0 :: int) < d \<longrightarrow> n cmod d = -(-n cmod d)"
  for n :: "int"
  and d :: "int"
axiomatization where cmod_cases'1:   "(0 :: int) \<le> n \<longrightarrow> d < (0 :: int) \<longrightarrow> n cmod d = n cmod -d"
  for n :: "int"
  and d :: "int"
axiomatization where cmod_cases'2:   "n \<le> (0 :: int) \<longrightarrow> d < (0 :: int) \<longrightarrow> n cmod d = -(-n cmod -d)"
  for n :: "int"
  and d :: "int"
axiomatization where cmod_remainder'0:   "(0 :: int) \<le> n \<longrightarrow> (0 :: int) < d \<longrightarrow> (0 :: int) \<le> n cmod d \<and> n cmod d < d"
  for n :: "int"
  and d :: "int"
axiomatization where cmod_remainder'1:   "n \<le> (0 :: int) \<longrightarrow> (0 :: int) < d \<longrightarrow> -d < n cmod d \<and> n cmod d \<le> (0 :: int)"
  for n :: "int"
  and d :: "int"
axiomatization where cmod_remainder'2:   "(0 :: int) \<le> n \<longrightarrow> d < (0 :: int) \<longrightarrow> (0 :: int) \<le> n cmod d \<and> n cmod d < -d"
  for n :: "int"
  and d :: "int"
axiomatization where cmod_remainder'3:   "n \<le> (0 :: int) \<longrightarrow> d < (0 :: int) \<longrightarrow> d < n cmod d \<and> n cmod d \<le> (0 :: int)"
  for n :: "int"
  and d :: "int"
axiomatization where cdiv_neutral:   "a cdiv (1 :: int) = a"
  for a :: "int"
axiomatization where cdiv_inv:   "a cdiv a = (1 :: int)"
 if "\<not>a = (0 :: int)"
  for a :: "int"
end
